/*
 * non-Latin-1 (>0x00ff) Unicode -> IBM CP437 conversion hash table
 * Markus Kuhn
 */
#define IBM_HASHSIZE   146
#define IBM_HASHSTEP    19
#define IBM_HASHLEVEL    4
static struct {
      unsigned short ucs;        /* a Unicode code */
      unsigned char ibm437;      /* the corresponding IBM code */
} ibm_hash[IBM_HASHSIZE] = {
  {0x221a,0xfb}, {0x2580,0xdf}, {0x2524,0xb4}, {0xffff,0x00}, {0x221e,0xec}, 
  {0x20a7,0x9e}, {0x2126,0xea}, {0x253c,0xc5}, {0xffff,0x00}, {0x2588,0xdb}, 
  {0x2666,0x04}, {0x2190,0x1b}, {0x2193,0x19}, {0x2665,0x03}, {0x2195,0x12}, 
  {0x2663,0x05}, {0x2660,0x06}, {0x2590,0xde}, {0x2022,0x07}, {0x2592,0xb1}, 
  {0x266c,0x0e}, {0x2502,0xb3}, {0x266a,0x0d}, {0x250c,0xda}, {0x258c,0xdd}, 
  {0xffff,0x00}, {0xffff,0x00}, {0xffff,0x00}, {0xffff,0x00}, {0x2191,0x18}, 
  {0x2261,0xf0}, {0x2514,0xc0}, {0x2192,0x1a}, {0x2264,0xf3}, {0x2194,0x1d}, 
  {0x2591,0xb0}, {0x0393,0xe2}, {0x2593,0xb2}, {0x2500,0xc4}, {0x251c,0xc3}, 
  {0x2205,0xed}, {0xffff,0x00}, {0x266b,0x0e}, {0x2518,0xd9}, {0x203c,0x13}, 
  {0xffff,0x00}, {0x2642,0x0b}, {0x2564,0xd1}, {0x2640,0x0c}, {0x2566,0xcb}, 
  {0x2561,0xb5}, {0x2560,0xcc}, {0x2563,0xb9}, {0x2562,0xb6}, {0x2510,0xbf}, 
  {0x256c,0xce}, {0x2008,0x00}, {0x03a6,0xe8}, {0x2569,0xca}, {0x2568,0xd0}, 
  {0x256b,0xd7}, {0x256a,0xd8}, {0x03a9,0xea}, {0xffff,0x00}, {0xffff,0x00}, 
  {0x25c0,0x11}, {0x0398,0xe9}, {0x2567,0xcf}, {0xffff,0x00}, {0x2248,0xf7}, 
  {0x03b1,0xe0}, {0x03a3,0xe4}, {0x2265,0xf2}, {0xffff,0x00}, {0x25cb,0x09}, 
  {0x03b4,0xeb}, {0x2320,0xf4}, {0xffff,0x00}, {0xffff,0x00}, {0xffff,0x00}, 
  {0x25c4,0x11}, {0xffff,0x00}, {0xffff,0x00}, {0x03bc,0xe6}, {0x2565,0xd2}, 
  {0xffff,0x00}, {0x22c5,0xf9}, {0x2302,0x7f}, {0x25d9,0x0a}, {0x25d8,0x08}, 
  {0xffff,0x00}, {0x03c4,0xe7}, {0xffff,0x00}, {0xffff,0x00}, {0x2555,0xb8}, 
  {0x2554,0xc9}, {0x2557,0xbb}, {0x2556,0xb7}, {0x2551,0xba}, {0x2550,0xcd}, 
  {0x2553,0xd6}, {0x2552,0xd5}, {0x255d,0xbc}, {0x255c,0xbd}, {0x255f,0xc7}, 
  {0x2310,0xa9}, {0x2559,0xd3}, {0x2558,0xd4}, {0x255b,0xbe}, {0x255a,0xc8}, 
  {0xffff,0x00}, {0x0192,0x9f}, {0x2319,0x1c}, {0x2321,0xf5}, {0xffff,0x00}, 
  {0x25a0,0xfe}, {0xffff,0x00}, {0x21a8,0x17}, {0x263c,0x0f}, {0x25ac,0x16}, 
  {0x263a,0x01}, {0x263b,0x02}, {0x03c3,0xe5}, {0xffff,0x00}, {0x255e,0xc6}, 
  {0x03c0,0xe3}, {0x03b2,0xe1}, {0x2300,0xed}, {0xffff,0x00}, {0x25b6,0x10}, 
  {0x207f,0xfc}, {0xffff,0x00}, {0x2208,0xee}, {0x25b2,0x1e}, {0x220e,0xfe}, 
  {0x25bc,0x1f}, {0x212b,0x8f}, {0x252c,0xc2}, {0xffff,0x00}, {0x2229,0xef}, 
  {0xffff,0x00}, {0x25ba,0x10}, {0xffff,0x00}, {0x2584,0xdc}, {0xffff,0x00}, 
  {0x2534,0xc1}
};

/*
 * Find the correct PC character set (CP437) code for a 
 * UCS character outside Latin-1 by hash lookup in ibm_hash[].
 * Return -1 if character not available, return -2 for zero-width
 * space characters.
 */
int
conv_uni_to_pc(unsigned long ucs)
{
      int c = -1;
      int i, h;
      
      if (ucs == 0xffff || ucs == 0xfffe)
              return -1;
      if (ucs == 0xfeff || (ucs >= 0x200a && ucs <= 0x200f))
              return -2;
      
      h = (ucs ^ (ucs >> 8)) % IBM_HASHSIZE;
      for (i = 0; i < IBM_HASHLEVEL && c == -1; i++)
              if (ibm_hash[h].ucs == ucs)
                      c = ibm_hash[h].ibm437;
              else
                      if ((h += IBM_HASHSTEP) >= IBM_HASHSIZE)
                              h -= IBM_HASHSIZE;
      
      return c;
}

#if 0
/* 
 * Conversion from unicode to ibm pc character set (code page 437)
 *
 * aeb@cwi.nl, Dec 1993
 */
#define NOTFOUND	254	/* small square */

static struct unipc {
	long unicode;
	unsigned char pc;
} uni_to_pc[255] = {
	{0x0020, 0x20},  {0x0021, 0x21},  {0x0022, 0x22},  {0x0023, 0x23},
	{0x0024, 0x24},  {0x0025, 0x25},  {0x0026, 0x26},  {0x0027, 0x27},
	{0x0028, 0x28},  {0x0029, 0x29},  {0x002A, 0x2A},  {0x002B, 0x2B},
	{0x002C, 0x2C},  {0x002D, 0x2D},  {0x002E, 0x2E},  {0x002F, 0x2F},
	{0x0030, 0x30},  {0x0031, 0x31},  {0x0032, 0x32},  {0x0033, 0x33},
	{0x0034, 0x34},  {0x0035, 0x35},  {0x0036, 0x36},  {0x0037, 0x37},
	{0x0038, 0x38},  {0x0039, 0x39},  {0x003A, 0x3A},  {0x003B, 0x3B},
	{0x003C, 0x3C},  {0x003D, 0x3D},  {0x003E, 0x3E},  {0x003F, 0x3F},
	{0x0040, 0x40},  {0x0041, 0x41},  {0x0042, 0x42},  {0x0043, 0x43},
	{0x0044, 0x44},  {0x0045, 0x45},  {0x0046, 0x46},  {0x0047, 0x47},
	{0x0048, 0x48},  {0x0049, 0x49},  {0x004A, 0x4A},  {0x004B, 0x4B},
	{0x004C, 0x4C},  {0x004D, 0x4D},  {0x004E, 0x4E},  {0x004F, 0x4F},
	{0x0050, 0x50},  {0x0051, 0x51},  {0x0052, 0x52},  {0x0053, 0x53},
	{0x0054, 0x54},  {0x0055, 0x55},  {0x0056, 0x56},  {0x0057, 0x57},
	{0x0058, 0x58},  {0x0059, 0x59},  {0x005A, 0x5A},  {0x005B, 0x5B},
	{0x005C, 0x5C},  {0x005D, 0x5D},  {0x005E, 0x5E},  {0x005F, 0x5F},
	{0x0060, 0x60},  {0x0061, 0x61},  {0x0062, 0x62},  {0x0063, 0x63},
	{0x0064, 0x64},  {0x0065, 0x65},  {0x0066, 0x66},  {0x0067, 0x67},
	{0x0068, 0x68},  {0x0069, 0x69},  {0x006A, 0x6A},  {0x006B, 0x6B},
	{0x006C, 0x6C},  {0x006D, 0x6D},  {0x006E, 0x6E},  {0x006F, 0x6F},
	{0x0070, 0x70},  {0x0071, 0x71},  {0x0072, 0x72},  {0x0073, 0x73},
	{0x0074, 0x74},  {0x0075, 0x75},  {0x0076, 0x76},  {0x0077, 0x77},
	{0x0078, 0x78},  {0x0079, 0x79},  {0x007A, 0x7A},  {0x007B, 0x7B},
	{0x007C, 0x7C},  {0x007D, 0x7D},  {0x007E, 0x7E},  {0x00A0, 0xFF},
	{0x00A1, 0xAD},  {0x00A2, 0x9B},  {0x00A3, 0x9C},  {0x00A5, 0x9D},
	{0x00A7, 0x15},  {0x00AA, 0xA6},  {0x00AB, 0xAE},  {0x00AC, 0xAA},
	{0x00B0, 0xF8},  {0x00B1, 0xF1},  {0x00B2, 0xFD},  {0x00B5, 0xE6},
	{0x00B6, 0x14},  {0x00B7, 0xFA},  {0x00BA, 0xA7},  {0x00BB, 0xAF},
	{0x00BC, 0xAC},  {0x00BD, 0xAB},  {0x00BF, 0xA8},  {0x00C4, 0x8E},
	{0x00C5, 0x8F},  {0x00C6, 0x92},  {0x00C7, 0x80},  {0x00C9, 0x90},
	{0x00D1, 0xA5},  {0x00D6, 0x99},  {0x00DC, 0x9A},  {0x00DF, 0xE1},
	{0x00E0, 0x85},  {0x00E1, 0xA0},  {0x00E2, 0x83},  {0x00E4, 0x84},
	{0x00E5, 0x86},  {0x00E6, 0x91},  {0x00E7, 0x87},  {0x00E8, 0x8A},
	{0x00E9, 0x82},  {0x00EA, 0x88},  {0x00EB, 0x89},  {0x00EC, 0x8D},
	{0x00ED, 0xA1},  {0x00EE, 0x8C},  {0x00EF, 0x8B},  {0x00F1, 0xA4},
	{0x00F2, 0x95},  {0x00F3, 0xA2},  {0x00F4, 0x93},  {0x00F6, 0x94},
	{0x00F7, 0xF6},  {0x00F9, 0x97},  {0x00FA, 0xA3},  {0x00FB, 0x96},
	{0x00FC, 0x81},  {0x00FF, 0x98},  {0x0192, 0x9F},  {0x0393, 0xE2},
	{0x0398, 0xE9},  {0x03A3, 0xE4},  {0x03A6, 0xE8},  {0x03A9, 0xEA},
	{0x03B1, 0xE0},  {0x03B4, 0xEB},  {0x03B5, 0xEE},  {0x03C0, 0xE3},
	{0x03C3, 0xE5},  {0x03C4, 0xE7},  {0x03C6, 0xED},  {0x2022, 0x07},
	{0x203C, 0x13},  {0x207F, 0xFC},  {0x20A7, 0x9E},  {0x2190, 0x1B},
	{0x2191, 0x18},  {0x2192, 0x1A},  {0x2193, 0x19},  {0x2194, 0x1D},
	{0x2195, 0x12},  {0x21A8, 0x17},  {0x2219, 0xF9},  {0x221A, 0xFB},
	{0x221E, 0xEC},  {0x221F, 0x1C},  {0x2229, 0xEF},  {0x2248, 0xF7},
	{0x2261, 0xF0},  {0x2264, 0xF3},  {0x2265, 0xF2},  {0x2302, 0x7F},
	{0x2310, 0xA9},  {0x2320, 0xF4},  {0x2321, 0xF5},  {0x2500, 0xC4},
	{0x2502, 0xB3},  {0x250C, 0xDA},  {0x2510, 0xBF},  {0x2514, 0xC0},
	{0x2518, 0xD9},  {0x251C, 0xC3},  {0x2524, 0xB4},  {0x252C, 0xC2},
	{0x2534, 0xC1},  {0x253C, 0xC5},  {0x2550, 0xCD},  {0x2551, 0xBA},
	{0x2552, 0xD5},  {0x2553, 0xD6},  {0x2554, 0xC9},  {0x2555, 0xB8},
	{0x2556, 0xB7},  {0x2557, 0xBB},  {0x2558, 0xD4},  {0x2559, 0xD3},
	{0x255A, 0xC8},  {0x255B, 0xBE},  {0x255C, 0xBD},  {0x255D, 0xBC},
	{0x255E, 0xC6},  {0x255F, 0xC7},  {0x2560, 0xCC},  {0x2561, 0xB5},
	{0x2562, 0xB6},  {0x2563, 0xB9},  {0x2564, 0xD1},  {0x2565, 0xD2},
	{0x2566, 0xCB},  {0x2567, 0xCF},  {0x2568, 0xD0},  {0x2569, 0xCA},
	{0x256A, 0xD8},  {0x256B, 0xD7},  {0x256C, 0xCE},  {0x2580, 0xDF},
	{0x2584, 0xDC},  {0x2588, 0xDB},  {0x258C, 0xDD},  {0x2590, 0xDE},
	{0x2591, 0xB0},  {0x2592, 0xB1},  {0x2593, 0xB2},  {0x25A0, 0xFE},
	{0x25AC, 0x16},  {0x25B2, 0x1E},  {0x25BA, 0x10},  {0x25BC, 0x1F},
	{0x25C4, 0x11},  {0x25CB, 0x09},  {0x25D8, 0x08},  {0x25D9, 0x0A},
	{0x263A, 0x01},  {0x263B, 0x02},  {0x263C, 0x0F},  {0x2640, 0x0C},
	{0x2642, 0x0B},  {0x2660, 0x06},  {0x2663, 0x05},  {0x2665, 0x03},
	{0x2666, 0x04},  {0x266A, 0x0D},  {0x266B, 0x0E}
};

unsigned char
conv_uni_to_pc(unsigned long u) {
	/* Binary search - no doubt this can be sped up using hash codes */
	/* (or by table lookup if we are in the first half) */
	int step = 128;
	struct unipc *up = uni_to_pc + step - 1;

	while(1) {
		if(up->unicode == u)
			return up->pc;
		step >>= 1;
		if(!step)
			return NOTFOUND;
		if(up->unicode < u)
			up += step;
		else
			up -= step;
	}
}
#endif
