/* SPDX-License-Identifier: GPL-2.0 */
/*
 * mt6357.h  --  mt6357 ALSA SoC audio codec driver
 *
 * Copyright (c) 2024 Baylibre
 * Author: Nicolas Belin <nbelin@baylibre.com>
 */

#ifndef __MT6357_H__
#define __MT6357_H__

#include <linux/types.h>

/* Reg bit defines */
/* MT6357_GPIO_DIR0 */
#define MT6357_GPIO8_DIR_MASK			BIT(8)
#define MT6357_GPIO8_DIR_INPUT			0
#define MT6357_GPIO8_DIR_OUTPUT			BIT(8)
#define MT6357_GPIO9_DIR_MASK			BIT(9)
#define MT6357_GPIO9_DIR_INPUT			0
#define MT6357_GPIO9_DIR_OUTPUT			BIT(9)
#define MT6357_GPIO10_DIR_MASK			BIT(10)
#define MT6357_GPIO10_DIR_INPUT			0
#define MT6357_GPIO10_DIR_OUTPUT		BIT(10)
#define MT6357_GPIO11_DIR_MASK			BIT(11)
#define MT6357_GPIO11_DIR_INPUT			0
#define MT6357_GPIO11_DIR_OUTPUT		BIT(11)
#define MT6357_GPIO12_DIR_MASK			BIT(12)
#define MT6357_GPIO12_DIR_INPUT			0
#define MT6357_GPIO12_DIR_OUTPUT		BIT(12)
#define MT6357_GPIO13_DIR_MASK			BIT(13)
#define MT6357_GPIO13_DIR_INPUT			0
#define MT6357_GPIO13_DIR_OUTPUT		BIT(13)
#define MT6357_GPIO14_DIR_MASK			BIT(14)
#define MT6357_GPIO14_DIR_INPUT			0
#define MT6357_GPIO14_DIR_OUTPUT		BIT(14)
#define MT6357_GPIO15_DIR_MASK			BIT(15)
#define MT6357_GPIO15_DIR_INPUT			0
#define MT6357_GPIO15_DIR_OUTPUT		BIT(15)

/* MT6357_GPIO_MODE2 */
#define MT6357_GPIO8_MODE_MASK			GENMASK(2, 0)
#define MT6357_GPIO8_MODE_AUD_CLK_MOSI		BIT(0)
#define MT6357_GPIO8_MODE_GPIO			0
#define MT6357_GPIO9_MODE_MASK			GENMASK(5, 3)
#define MT6357_GPIO9_MODE_AUD_DAT_MOSI0		BIT(3)
#define MT6357_GPIO9_MODE_GPIO			0
#define MT6357_GPIO10_MODE_MASK			GENMASK(8, 6)
#define MT6357_GPIO10_MODE_AUD_DAT_MOSI1	BIT(6)
#define MT6357_GPIO10_MODE_GPIO			0
#define MT6357_GPIO11_MODE_MASK			GENMASK(11, 9)
#define MT6357_GPIO11_MODE_AUD_SYNC_MOSI	BIT(9)
#define MT6357_GPIO11_MODE_GPIO			0

/* MT6357_GPIO_MODE2_SET */
#define MT6357_GPIO8_MODE_SET_MASK		GENMASK(2, 0)
#define MT6357_GPIO8_MODE_SET_AUD_CLK_MOSI	BIT(0)
#define MT6357_GPIO9_MODE_SET_MASK		GENMASK(5, 3)
#define MT6357_GPIO9_MODE_SET_AUD_DAT_MOSI0	BIT(3)
#define MT6357_GPIO10_MODE_SET_MASK		GENMASK(8, 6)
#define MT6357_GPIO10_MODE_SET_AUD_DAT_MOSI1	BIT(6)
#define MT6357_GPIO11_MODE_SET_MASK		GENMASK(11, 9)
#define MT6357_GPIO11_MODE_SET_AUD_SYNC_MOSI	BIT(9)

/* MT6357_GPIO_MODE2_CLR */
#define MT6357_GPIO_MODE2_CLEAR_ALL		GENMASK(15, 0)

/* MT6357_GPIO_MODE3 */
#define MT6357_GPIO12_MODE_MASK			GENMASK(2, 0)
#define MT6357_GPIO12_MODE_AUD_CLK_MISO		BIT(0)
#define MT6357_GPIO12_MODE_GPIO			0
#define MT6357_GPIO13_MODE_MASK			GENMASK(5, 3)
#define MT6357_GPIO13_MODE_AUD_DAT_MISO0	BIT(3)
#define MT6357_GPIO13_MODE_GPIO			0
#define MT6357_GPIO14_MODE_MASK			GENMASK(8, 6)
#define MT6357_GPIO14_MODE_AUD_DAT_MISO1	BIT(6)
#define MT6357_GPIO14_MODE_GPIO			0
#define MT6357_GPIO15_MODE_MASK			GENMASK(11, 9)
#define MT6357_GPIO15_MODE_AUD_SYNC_MISO	BIT(9)
#define MT6357_GPIO15_MODE_GPIO			0

/* MT6357_GPIO_MODE3_SET */
#define MT6357_GPIO12_MODE_SET_MASK		GENMASK(2, 0)
#define MT6357_GPIO12_MODE_SET_AUD_CLK_MISO	BIT(0)
#define MT6357_GPIO13_MODE_SET_MASK		GENMASK(5, 3)
#define MT6357_GPIO13_MODE_SET_AUD_DAT_MISO0	BIT(3)
#define MT6357_GPIO14_MODE_SET_MASK		GENMASK(8, 6)
#define MT6357_GPIO14_MODE_SET_AUD_DAT_MISO1	BIT(6)
#define MT6357_GPIO15_MODE_SET_MASK		GENMASK(11, 9)
#define MT6357_GPIO15_MODE_SET_AUD_SYNC_MISO	BIT(9)

/* MT6357_GPIO_MODE3_CLR */
#define MT6357_GPIO_MODE3_CLEAR_ALL		GENMASK(15, 0)

/* MT6357_DCXO_CW14 */
#define MT6357_XO_AUDIO_EN_M_SFT		13
#define MT6357_XO_AUDIO_EN_M_MASK		BIT(13)
#define MT6357_XO_AUDIO_EN_M_ENABLE		BIT(13)
#define MT6357_XO_AUDIO_EN_M_DISABLE		0

/* MT6357_AUD_TOP_CKPDN_CON0 */
#define MT6357_AUDNCP_CK_PDN_SFT		6
#define MT6357_ZCD13M_CK_PDN_SFT		5
#define MT6357_AUDIF_CK_PDN_SFT			2
#define MT6357_AUD_CK_PDN_SFT			1

/* MT6357_AUDNCP_CLKDIV_CON0 */
#define MT6357_DIVCKS_CHG			BIT(0)

/* MT6357_AUDNCP_CLKDIV_CON1 */
#define MT6357_DIVCKS_ON			BIT(0)

/* MT6357_AUDNCP_CLKDIV_CON3 */
#define MT6357_DIVCKS_PWD_NCP_MASK		BIT(0)
#define MT6357_DIVCKS_PWD_NCP_DISABLE		BIT(0)
#define MT6357_DIVCKS_PWD_NCP_ENABLE		0

/* MT6357_AUDNCP_CLKDIV_CON4 */
#define MT6357_DIVCKS_PWD_NCP_ST_SEL_MASK	GENMASK(1, 0)
#define MT6357_DIVCKS_PWD_NCP_ST_50US		0
#define MT6357_DIVCKS_PWD_NCP_ST_100US		1
#define MT6357_DIVCKS_PWD_NCP_ST_150US		2
#define MT6357_DIVCKS_PWD_NCP_ST_200US		3

/* MT6357_AFE_UL_DL_CON0 */
#define MT6357_AFE_UL_LR_SWAP_SFT		15
#define MT6357_AFE_ON_SFT			0

/* MT6357_AFE_DL_SRC2_CON0_L */
#define MT6357_DL_2_SRC_ON_TMP_CTL_PRE_SFT	0

/* MT6357_AFE_UL_SRC_CON0_H */
#define MT6357_C_TWO_DIGITAL_MIC_CTL_MASK	BIT(7)
#define MT6357_C_TWO_DIGITAL_MIC_ENABLE		BIT(7)
#define MT6357_C_TWO_DIGITAL_MIC_DISABLE	0

/* MT6357_AFE_UL_SRC_CON0_L */
#define MT6357_UL_SDM_3_LEVEL_CTL_MASK		BIT(1)
#define MT6357_UL_SDM_3_LEVEL_SELECT		BIT(1)
#define MT6357_UL_SDM_3_LEVEL_DESELECT		0
#define MT6357_UL_SRC_ON_TMP_CTL_MASK		BIT(0)
#define MT6357_UL_SRC_ENABLE			BIT(0)
#define MT6357_UL_SRC_DISABLE			0

/* MT6357_AFE_TOP_CON0 */
#define MT6357_UL_SINE_ON_SFT			1
#define MT6357_UL_SINE_ON_MASK			BIT(1)
#define MT6357_DL_SINE_ON_SFT			0
#define MT6357_DL_SINE_ON_MASK			BIT(0)

/* MT6357_AUDIO_TOP_CON0 */
#define MT6357_PDN_LPBK_CTL_SFT			15
#define MT6357_PDN_AFE_CTL_SFT			7
#define MT6357_PDN_DAC_CTL_SFT			6
#define MT6357_PDN_ADC_CTL_SFT			5
#define MT6357_PDN_I2S_DL_CTL_SFT		3
#define MT6357_PWR_CLK_DIS_CTL_SFT		2
#define MT6357_PDN_AFE_TESTMODEL_CTL_SFT	1
#define MT6357_PDN_RESERVED_SFT			0

/* MT6357_AFUNC_AUD_CON0 */
#define MT6357_CCI_AUD_ANACK_INVERT			BIT(15)
#define MT6357_CCI_AUD_ANACK_NORMAL			0
#define MT6357_CCI_AUDIO_FIFO_WPTR_SFT			12
#define MT6357_CCI_SCRAMBLER_CG_ENABLE			BIT(11)
#define MT6357_CCI_SCRAMBLER_CG_DISABLE			0
#define MT6357_CCI_LCK_INV_OUT_OF_PHASE			BIT(10)
#define MT6357_CCI_LCK_INV_IN_PHASE			0
#define MT6357_CCI_RAND_ENABLE				BIT(9)
#define MT6357_CCI_RAND_DISABLE				0
#define MT6357_CCI_SPLT_SCRMB_CLK_ON			BIT(8)
#define MT6357_CCI_SPLT_SCRMB_CLK_OFF			0
#define MT6357_CCI_SPLT_SCRMB_ON			BIT(7)
#define MT6357_CCI_SPLT_SCRMB_OFF			0
#define MT6357_CCI_AUD_IDAC_TEST_EN_FROM_TEST_IN	BIT(6)
#define MT6357_CCI_AUD_IDAC_TEST_EN_NORMAL_PATH		0
#define MT6357_CCI_ZERO_PADDING_DISABLE			BIT(5)
#define MT6357_CCI_ZERO_PADDING_ENABLE			0
#define MT6357_CCI_AUD_SPLIT_TEST_EN_FROM_TEST_IN	BIT(4)
#define MT6357_CCI_AUD_SPLIT_TEST_EN_NORMAL_PATH	0
#define MT6357_CCI_AUD_SDM_MUTE_L_REG_CTL		BIT(3)
#define MT6357_CCI_AUD_SDM_MUTE_L_NO_CTL		0
#define MT6357_CCI_AUD_SDM_MUTE_R_REG_CTL		BIT(2)
#define MT6357_CCI_AUD_SDM_MUTE_R_NO_CTL		0
#define MT6357_CCI_AUD_SDM_7BIT_FROM_SPLITTER3		BIT(1)
#define MT6357_CCI_AUD_SDM_7BIT_FROM_SPLITTER1		0
#define MT6357_CCI_SCRAMBLER_ENABLE			BIT(0)
#define MT6357_CCI_SCRAMBLER_DISABLE			0

/* MT6357_AFUNC_AUD_CON2 */
#define MT6357_CCI_AUDIO_FIFO_ENABLE		BIT(3)
#define MT6357_CCI_AUDIO_FIFO_DISABLE		0
#define MT6357_CCI_ACD_MODE_NORMAL_PATH		BIT(2)
#define MT6357_CCI_ACD_MODE_TEST_PATH		0
#define MT6357_CCI_AFIFO_CLK_PWDB_ON		BIT(1)
#define MT6357_CCI_AFIFO_CLK_PWDB_DOWN		0
#define MT6357_CCI_ACD_FUNC_RSTB_RELEASE	BIT(0)
#define MT6357_CCI_ACD_FUNC_RSTB_RESET		0

/* MT6357_AFE_ADDA_MTKAIF_CFG0 */
#define MT6357_ADDA_MTKAIF_LPBK_CTL_MASK	BIT(1)
#define MT6357_ADDA_MTKAIF_LPBK_ENABLE		BIT(1)
#define MT6357_ADDA_MTKAIF_LPBK_DISABLE		0

/* MT6357_AFE_SGEN_CFG0 */
#define MT6357_SGEN_DAC_EN_CTL_SFT		7
#define MT6357_SGEN_DAC_ENABLE			BIT(7)
#define MT6357_SGEN_MUTE_SW_CTL_SFT		6
#define MT6357_SGEN_MUTE_SW_DISABLE		0

/* MT6357_AFE_DCCLK_CFG0 */
#define MT6357_DCCLK_DIV_MASK			GENMASK(15, 5)
#define MT6357_DCCLK_DIV_SFT			5
#define MT6357_DCCLK_DIV_RUN_VALUE		(32 << MT6357_DCCLK_DIV_SFT)
#define MT6357_DCCLK_DIV_STOP_VALUE		(259 << MT6357_DCCLK_DIV_SFT)
#define MT6357_DCCLK_PDN_MASK			BIT(1)
#define MT6357_DCCLK_PDN			BIT(1)
#define MT6357_DCCLK_OUTPUT			0
#define MT6357_DCCLK_GEN_ON_MASK		BIT(0)
#define MT6357_DCCLK_GEN_ON			BIT(0)
#define MT6357_DCCLK_GEN_OFF			0

/* MT6357_AFE_DCCLK_CFG1 */
#define MT6357_DCCLK_RESYNC_BYPASS_MASK		BIT(8)
#define MT6357_DCCLK_RESYNC_BYPASS		BIT(8)

/* MT6357_AFE_AUD_PAD_TOP */
#define MT6357_AUD_PAD_TX_FIFO_NORMAL_PATH_MASK		GENMASK(15, 8)
#define MT6357_AUD_PAD_TX_FIFO_NORMAL_PATH_ENABLE	(BIT(13) | BIT(12) | BIT(8))
#define MT6357_AUD_PAD_TX_FIFO_NORMAL_PATH_DISABLE	(BIT(13) | BIT(12))
#define MT6357_AUD_PAD_TX_FIFO_LPBK_MASK		GENMASK(7, 0)
#define MT6357_AUD_PAD_TX_FIFO_LPBK_ENABLE		(BIT(5) | BIT(4) | BIT(0))
#define MT6357_AUD_PAD_TX_FIFO_LPBK_DISABLE		0

/* MT6357_AUDENC_ANA_CON0 */
#define MT6357_AUDADCLINPUTSEL_MASK		GENMASK(14, 13)
#define MT6357_AUDADCLINPUTSEL_PREAMPLIFIER	BIT(14)
#define MT6357_AUDADCLINPUTSEL_IDLE		0
#define MT6357_AUDADCLPWRUP_SFT			12
#define MT6357_AUDADCLPWRUP_MASK		BIT(12)
#define MT6357_AUDADCLPWRUP			BIT(12)
#define MT6357_AUDADCLPWRDOWN			0
#define MT6357_AUDPREAMPLGAIN_SFT		8
#define MT6357_AUDPREAMPLGAIN_MASK		GENMASK(10, 8)
#define MT6357_AUDPREAMPLGAIN_MAX		4
#define MT6357_AUDPREAMPLINPUTSEL_SFT		6
#define MT6357_AUDPREAMPLINPUTSEL_MASK_NOSFT	GENMASK(1, 0)
#define MT6357_AUDPREAMPLDCPRECHARGE_MASK	BIT(2)
#define MT6357_AUDPREAMPLDCPRECHARGE_ENABLE	BIT(2)
#define MT6357_AUDPREAMPLDCPRECHARGE_DISABLE	0
#define MT6357_AUDPREAMPLDCCEN_MASK		BIT(1)
#define MT6357_AUDPREAMPLDCCEN_DC		BIT(1)
#define MT6357_AUDPREAMPLDCCEN_AC		0
#define MT6357_AUDPREAMPLON_MASK		BIT(0)
#define MT6357_AUDPREAMPLON_ENABLE		BIT(0)
#define MT6357_AUDPREAMPLON_DISABLE		0

/* MT6357_AUDENC_ANA_CON1 */
#define MT6357_AUDADCRINPUTSEL_MASK		GENMASK(14, 13)
#define MT6357_AUDADCRINPUTSEL_PREAMPLIFIER	BIT(14)
#define MT6357_AUDADCRINPUTSEL_IDLE		0
#define MT6357_AUDADCRPWRUP_SFT			12
#define MT6357_AUDADCRPWRUP_MASK		BIT(12)
#define MT6357_AUDADCRPWRUP			BIT(12)
#define MT6357_AUDADCRPWRDOWN			0
#define MT6357_AUDPREAMPRGAIN_SFT		8
#define MT6357_AUDPREAMPRGAIN_MASK		GENMASK(10, 8)
#define MT6357_AUDPREAMPRGAIN_MAX		4
#define MT6357_AUDPREAMPRINPUTSEL_SFT		6
#define MT6357_AUDPREAMPRINPUTSEL_MASK_NOSFT	GENMASK(1, 0)
#define MT6357_AUDPREAMPRDCPRECHARGE_MASK	BIT(2)
#define MT6357_AUDPREAMPRDCPRECHARGE_ENABLE	BIT(2)
#define MT6357_AUDPREAMPRDCPRECHARGE_DISABLE	0
#define MT6357_AUDPREAMPRDCCEN_MASK		BIT(1)
#define MT6357_AUDPREAMPRDCCEN_DC		BIT(1)
#define MT6357_AUDPREAMPRDCCEN_AC		0
#define MT6357_AUDPREAMPRON_MASK		BIT(0)
#define MT6357_AUDPREAMPRON_ENABLE		BIT(0)
#define MT6357_AUDPREAMPRON_DISABLE		0

/* MT6357_AUDENC_ANA_CON6 */
#define MT6357_CLKSQ_EN_SFT			0

/* MT6357_AUDENC_ANA_CON7 */
#define MT6357_AUDDIGMICBIAS_MASK		GENMASK(2, 1)
#define MT6357_AUDDIGMICBIAS_DEFAULT_VALUE	BIT(2)
#define MT6357_AUDDIGMICBIAS_OFF		0
#define MT6357_AUDDIGMICEN_MASK			BIT(0)
#define MT6357_AUDDIGMICEN_ENABLE		BIT(0)
#define MT6357_AUDDIGMICEN_DISABLE		0

/* MT6357_AUDENC_ANA_CON8 */
#define MT6357_AUD_MICBIAS0_DCSW2N_EN_MASK	BIT(14)
#define MT6357_AUD_MICBIAS0_DCSW2N_ENABLE	BIT(14)
#define MT6357_AUD_MICBIAS0_DCSW2N_DISABLE	0
#define MT6357_AUD_MICBIAS0_DCSW2P2_EN_MASK	BIT(13)
#define MT6357_AUD_MICBIAS0_DCSW2P2_ENABLE	BIT(13)
#define MT6357_AUD_MICBIAS0_DCSW2P2_DISABLE	0
#define MT6357_AUD_MICBIAS0_DCSW2P1_EN_MASK	BIT(12)
#define MT6357_AUD_MICBIAS0_DCSW2P1_ENABLE	BIT(12)
#define MT6357_AUD_MICBIAS0_DCSW2P1_DISABLE	0
#define MT6357_AUD_MICBIAS0_DCSW0N_EN_MASK	BIT(10)
#define MT6357_AUD_MICBIAS0_DCSW0N_ENABLE	BIT(10)
#define MT6357_AUD_MICBIAS0_DCSWN_DISABLE	0
#define MT6357_AUD_MICBIAS0_DCSW0P2_EN_MASK	BIT(9)
#define MT6357_AUD_MICBIAS0_DCSW0P2_ENABLE	BIT(9)
#define MT6357_AUD_MICBIAS0_DCSW0P2_DISABLE	0
#define MT6357_AUD_MICBIAS0_DCSW0P1_EN_MASK	BIT(8)
#define MT6357_AUD_MICBIAS0_DCSW0P1_ENABLE	BIT(8)
#define MT6357_AUD_MICBIAS0_DCSW0P1_DISABLE	0
#define MT6357_AUD_MICBIAS0_VREF_MASK		GENMASK(6, 4)
#define MT6357_AUD_MICBIAS0_VREF_SFT		4
#define MT6357_AUD_MICBIAS0_PWD_SFT		0

#define MT6357_AUD_MICBIAS0_DC_MASK		(MT6357_AUD_MICBIAS0_DCSW2N_EN_MASK | \
						 MT6357_AUD_MICBIAS0_DCSW2P2_EN_MASK | \
						 MT6357_AUD_MICBIAS0_DCSW2P1_EN_MASK | \
						 MT6357_AUD_MICBIAS0_DCSW0N_EN_MASK | \
						 MT6357_AUD_MICBIAS0_DCSW0P2_EN_MASK | \
						 MT6357_AUD_MICBIAS0_DCSW0P1_EN_MASK)

#define MT6357_AUD_MICBIAS0_DC_ENABLE_ALL	(MT6357_AUD_MICBIAS0_DCSW2N_ENABLE | \
						 MT6357_AUD_MICBIAS0_DCSW2P2_ENABLE | \
						 MT6357_AUD_MICBIAS0_DCSW2P1_ENABLE | \
						 MT6357_AUD_MICBIAS0_DCSW0N_ENABLE | \
						 MT6357_AUD_MICBIAS0_DCSW0P2_ENABLE | \
						 MT6357_AUD_MICBIAS0_DCSW0P1_ENABLE)

#define MT6357_AUD_MICBIAS0_DC_ENABLE_P1	(MT6357_AUD_MICBIAS0_DCSW2P1_ENABLE | \
						 MT6357_AUD_MICBIAS0_DCSW0P1_ENABLE)

#define MT6357_AUD_MICBIAS0_DC_DISABLE_ALL	0

/* MT6357_AUDENC_ANA_CON9 */
#define MT6357_AUD_MICBIAS1_DCSW1P_EN_MASK	BIT(8)
#define MT6357_AUD_MICBIAS1_DCSW1P_ENABLE	BIT(8)
#define MT6357_AUD_MICBIAS1_DCSW1P_DISABLE	0
#define MT6357_AUD_MICBIAS1_VREF_MASK		GENMASK(6, 4)
#define MT6357_AUD_MICBIAS1_VREF_SFT		4
#define MT6357_AUD_MICBIAS1_PWD_SFT		0

/* MT6357_AUDDEC_ANA_CON0 */
#define MT6357_AUD_HPR_SC_VAUDP15_MASK			BIT(13)
#define MT6357_AUD_HPR_SC_VAUDP15_DISABLE		BIT(13)
#define MT6357_AUD_HPR_SC_VAUDP15_ENABLE		0
#define MT6357_AUD_HPL_SC_VAUDP15_MASK			BIT(12)
#define MT6357_AUD_HPL_SC_VAUDP15_DISABLE		BIT(12)
#define MT6357_AUD_HPL_SC_VAUDP15_ENABLE		0
#define MT6357_AUD_HPR_MUX_INPUT_VAUDP15_MASK_NOSFT	GENMASK(1, 0)
#define MT6357_AUD_HPR_MUX_INPUT_VAUDP15_SFT		10
#define MT6357_AUD_HPL_MUX_INPUT_VAUDP15_MASK_NOSFT	GENMASK(1, 0)
#define MT6357_AUD_HPL_MUX_INPUT_VAUDP15_SFT		8
#define MT6357_AUD_HPR_BIAS_VAUDP15_MASK		BIT(7)
#define MT6357_AUD_HPR_BIAS_VAUDP15_ENABLE		BIT(7)
#define MT6357_AUD_HPR_BIAS_VAUDP15_DISABLE		0
#define MT6357_AUD_HPL_BIAS_VAUDP15_MASK		BIT(6)
#define MT6357_AUD_HPL_BIAS_VAUDP15_ENABLE		BIT(6)
#define MT6357_AUD_HPL_BIAS_VAUDP15_DISABLE		0
#define MT6357_AUD_HPR_PWRUP_VAUDP15_MASK		BIT(5)
#define MT6357_AUD_HPR_PWRUP_VAUDP15_ENABLE		BIT(5)
#define MT6357_AUD_HPR_PWRUP_VAUDP15_DISABLE		0
#define MT6357_AUD_HPL_PWRUP_VAUDP15_MASK		BIT(4)
#define MT6357_AUD_HPL_PWRUP_VAUDP15_ENABLE		BIT(4)
#define MT6357_AUD_HPL_PWRUP_VAUDP15_DISABLE		0
#define MT6357_AUD_DACL_PWRUP_VA28_MASK			BIT(3)
#define MT6357_AUD_DACL_PWRUP_VA28_ENABLE		BIT(3)
#define MT6357_AUD_DACL_PWRUP_VA28_DISABLE		0
#define MT6357_AUD_DACR_PWRUP_VA28_MASK			BIT(2)
#define MT6357_AUD_DACR_PWRUP_VA28_ENABLE		BIT(2)
#define MT6357_AUD_DACR_PWRUP_VA28_DISABLE		0
#define MT6357_AUD_DACR_PWRUP_VAUDP15_MASK		BIT(1)
#define MT6357_AUD_DACR_PWRUP_VAUDP15_ENABLE		BIT(1)
#define MT6357_AUD_DACR_PWRUP_VAUDP15_DISABLE		0
#define MT6357_AUD_DACL_PWRUP_VAUDP15_MASK		BIT(0)
#define MT6357_AUD_DACL_PWRUP_VAUDP15_ENABLE		BIT(0)
#define MT6357_AUD_DACL_PWRUP_VAUDP15_DISABLE		0

/* MT6357_AUDDEC_ANA_CON1 */
#define MT6357_HPROUT_STG_CTRL_VAUDP15_MASK		GENMASK(14, 12)
#define MT6357_HPROUT_STG_CTRL_VAUDP15_SFT		12
#define MT6357_HPLOUT_STG_CTRL_VAUDP15_MASK		GENMASK(10, 8)
#define MT6357_HPLOUT_STG_CTRL_VAUDP15_SFT		8
#define MT6357_HPLOUT_STG_CTRL_VAUDP15_MAX		7
#define MT6357_HPR_SHORT2HPR_AUX_VAUDP15_MASK		BIT(7)
#define MT6357_HPR_SHORT2HPR_AUX_VAUDP15_ENABLE		BIT(7)
#define MT6357_HPR_SHORT2HPR_AUX_VAUDP15_DISABLE	0
#define MT6357_HPL_SHORT2HPR_AUX_VAUDP15_MASK		BIT(6)
#define MT6357_HPL_SHORT2HPR_AUX_VAUDP15_ENABLE		BIT(6)
#define MT6357_HPL_SHORT2HPR_AUX_VAUDP15_DISABLE	0
#define MT6357_HPR_AUX_FBRSW_VAUDP15_MASK		BIT(5)
#define MT6357_HPR_AUX_FBRSW_VAUDP15_ENABLE		BIT(5)
#define MT6357_HPR_AUX_FBRSW_VAUDP15_DISABLE		0
#define MT6357_HPL_AUX_FBRSW_VAUDP15_MASK		BIT(4)
#define MT6357_HPL_AUX_FBRSW_VAUDP15_ENABLE		BIT(4)
#define MT6357_HPL_AUX_FBRSW_VAUDP15_DISABLE		0
#define MT6357_HPROUT_AUX_PWRUP_VAUDP15_MASK		BIT(3)
#define MT6357_HPROUT_AUX_PWRUP_VAUDP15_ENABLE		BIT(3)
#define MT6357_HPROUT_AUX_PWRUP_VAUDP15_DISABLE	0
#define MT6357_HPLOUT_AUX_PWRUP_VAUDP15_MASK		BIT(2)
#define MT6357_HPLOUT_AUX_PWRUP_VAUDP15_ENABLE		BIT(2)
#define MT6357_HPLOUT_AUX_PWRUP_VAUDP15_DISABLE	0
#define MT6357_HPROUT_PWRUP_VAUDP15_MASK		BIT(1)
#define MT6357_HPROUT_PWRUP_VAUDP15_ENABLE		BIT(1)
#define MT6357_HPROUT_PWRUP_VAUDP15_DISABLE		0
#define MT6357_HPLOUT_PWRUP_VAUDP15_MASK		BIT(0)
#define MT6357_HPLOUT_PWRUP_VAUDP15_ENABLE		BIT(0)
#define MT6357_HPLOUT_PWRUP_VAUDP15_DISABLE		0

/* MT6357_AUDDEC_ANA_CON2 */
#define MT6357_HPP_SHORT_2VCM_VAUDP15_MASK		BIT(10)
#define MT6357_HPP_SHORT_2VCM_VAUDP15_ENABLE		BIT(10)
#define MT6357_HPP_SHORT_2VCM_VAUDP15_DISABLE		0
#define MT6357_AUD_REFN_DERES_VAUDP15_MASK		BIT(9)
#define MT6357_AUD_REFN_DERES_VAUDP15_ENABLE		BIT(9)
#define MT6357_AUD_REFN_DERES_VAUDP15_DISABLE		0
#define MT6357_HPROUT_STB_ENH_VAUDP15_MASK		GENMASK(6, 4)
#define MT6357_HPROUT_STB_ENH_VAUDP15_OPEN		0
#define MT6357_HPROUT_STB_ENH_VAUDP15_NOPEN_P250	BIT(4)
#define MT6357_HPROUT_STB_ENH_VAUDP15_N470_POPEN	BIT(5)
#define MT6357_HPROUT_STB_ENH_VAUDP15_N470_P250		(BIT(4) | BIT(5))
#define MT6357_HPROUT_STB_ENH_VAUDP15_NOPEN_P470	(BIT(4) | BIT(6))
#define MT6357_HPROUT_STB_ENH_VAUDP15_N470_P470		(BIT(4) | BIT(5) | BIT(6))
#define MT6357_HPLOUT_STB_ENH_VAUDP15_MASK		GENMASK(2, 0)
#define MT6357_HPLOUT_STB_ENH_VAUDP15_OPEN		0
#define MT6357_HPLOUT_STB_ENH_VAUDP15_NOPEN_P250	BIT(0)
#define MT6357_HPLOUT_STB_ENH_VAUDP15_N470_POPEN	BIT(1)
#define MT6357_HPLOUT_STB_ENH_VAUDP15_N470_P250		(BIT(0) | BIT(1))
#define MT6357_HPLOUT_STB_ENH_VAUDP15_NOPEN_P470	(BIT(0) | BIT(2))
#define MT6357_HPLOUT_STB_ENH_VAUDP15_N470_P470		(BIT(0) | BIT(1) | BIT(2))

/* MT6357_AUDDEC_ANA_CON3 */
#define MT6357_AUD_HSOUT_STB_ENH_VAUDP15_MASK		BIT(7)
#define MT6357_AUD_HSOUT_STB_ENH_VAUDP15_ENABLE		BIT(7)
#define MT6357_AUD_HSOUT_STB_ENH_VAUDP15_DISABLE	0
#define MT6357_AUD_HS_SC_VAUDP15_MASK			BIT(4)
#define MT6357_AUD_HS_SC_VAUDP15_DISABLE		BIT(4)
#define MT6357_AUD_HS_SC_VAUDP15_ENABLE			0
#define MT6357_AUD_HS_MUX_INPUT_VAUDP15_MASK_NOSFT	GENMASK(1, 0)
#define MT6357_AUD_HS_MUX_INPUT_VAUDP15_SFT		2
#define MT6357_AUD_HS_PWRUP_BIAS_VAUDP15_MASK		BIT(1)
#define MT6357_AUD_HS_PWRUP_BIAS_VAUDP15_ENABLE		BIT(1)
#define MT6357_AUD_HS_PWRUP_BIAS_VAUDP15_DISABLE	0
#define MT6357_AUD_HS_PWRUP_VAUDP15_MASK		BIT(0)
#define MT6357_AUD_HS_PWRUP_VAUDP15_ENABLE		BIT(0)
#define MT6357_AUD_HS_PWRUP_VAUDP15_DISABLE		0

/* MT6357_AUDDEC_ANA_CON4 */
#define MT6357_AUD_LOLOUT_STB_ENH_VAUDP15_MASK		BIT(8)
#define MT6357_AUD_LOLOUT_STB_ENH_VAUDP15_ENABLE	BIT(8)
#define MT6357_AUD_LOLOUT_STB_ENH_VAUDP15_DISABLE	0
#define MT6357_AUD_LOL_SC_VAUDP15_MASK			BIT(4)
#define MT6357_AUD_LOL_SC_VAUDP15_DISABLE		BIT(4)
#define MT6357_AUD_LOL_SC_VAUDP15_ENABLE		0
#define MT6357_AUD_LOL_MUX_INPUT_VAUDP15_MASK_NOSFT	GENMASK(1, 0)
#define MT6357_AUD_LOL_MUX_INPUT_VAUDP15_SFT		2
#define MT6357_AUD_LOL_PWRUP_BIAS_VAUDP15_MASK		BIT(1)
#define MT6357_AUD_LOL_PWRUP_BIAS_VAUDP15_ENABLE	BIT(1)
#define MT6357_AUD_LOL_PWRUP_BIAS_VAUDP15_DISABLE	0
#define MT6357_AUD_LOL_PWRUP_VAUDP15_MASK		BIT(0)
#define MT6357_AUD_LOL_PWRUP_VAUDP15_ENABLE		BIT(0)
#define MT6357_AUD_LOL_PWRUP_VAUDP15_DISABLE		0

/* MT6357_AUDDEC_ANA_CON6 */
#define MT6357_HP_AUX_LOOP_GAIN_MASK		GENMASK(15, 12)
#define MT6357_HP_AUX_LOOP_GAIN_SFT		12
#define MT6357_HP_AUX_LOOP_GAIN_MAX		0x0f
#define MT6357_HPR_AUX_CMFB_LOOP_MASK		BIT(11)
#define MT6357_HPR_AUX_CMFB_LOOP_ENABLE		BIT(11)
#define MT6357_HPR_AUX_CMFB_LOOP_DISABLE	0
#define MT6357_HPL_AUX_CMFB_LOOP_MASK		BIT(10)
#define MT6357_HPL_AUX_CMFB_LOOP_ENABLE		BIT(10)
#define MT6357_HPL_AUX_CMFB_LOOP_DISABLE	0
#define MT6357_HPRL_MAIN_CMFB_LOOP_MASK		BIT(9)
#define MT6357_HPRL_MAIN_CMFB_LOOP_ENABLE	BIT(9)
#define MT6357_HPRL_MAIN_CMFB_LOOP_DISABLE	0
#define MT6357_HP_CMFB_RST_MASK			BIT(7)
#define MT6357_HP_CMFB_RST_NORMAL		BIT(7)
#define MT6357_HP_CMFB_RST_RESET		0
#define MT6357_DAC_LOW_NOISE_MODE_MASK		BIT(0)
#define MT6357_DAC_LOW_NOISE_MODE_ENABLE	BIT(0)
#define MT6357_DAC_LOW_NOISE_MODE_DISABLE	0

/* MT6357_AUDDEC_ANA_CON7 */
#define MT6357_HP_IVBUF_DEGAIN_SFT		2
#define MT6357_HP_IVBUF_DEGAIN_MAX		1

/* MT6357_AUDDEC_ANA_CON10 */
#define MT6357_AUD_IBIAS_PWRDN_VAUDP15_MASK	BIT(8)
#define MT6357_AUD_IBIAS_PWRDN_VAUDP15_DISABLE	BIT(8)
#define MT6357_AUD_IBIAS_PWRDN_VAUDP15_ENABLE	0

/* MT6357_AUDDEC_ANA_CON11 */
#define MT6357_RSTB_ENCODER_VA28_MASK		BIT(5)
#define MT6357_RSTB_ENCODER_VA28_ENABLE		BIT(5)
#define MT6357_RSTB_ENCODER_VA28_DISABLE	0
#define MT6357_AUDGLB_PWRDN_VA28_SFT		4
#define MT6357_RSTB_DECODER_VA28_MASK		BIT(0)
#define MT6357_RSTB_DECODER_VA28_ENABLE		BIT(0)
#define MT6357_RSTB_DECODER_VA28_DISABLE	0

/* MT6357_AUDDEC_ANA_CON12 */
#define MT6357_VA28REFGEN_EN_VA28_MASK			BIT(13)
#define MT6357_VA28REFGEN_EN_VA28_ENABLE		BIT(13)
#define MT6357_VA28REFGEN_EN_VA28_DISABLE		0
#define MT6357_VA33REFGEN_EN_VA18_MASK			BIT(12)
#define MT6357_VA33REFGEN_EN_VA18_ENABLE		BIT(12)
#define MT6357_VA33REFGEN_EN_VA18_DISABLE		0
#define MT6357_LCLDO_ENC_REMOTE_SENSE_VA28_MASK		BIT(10)
#define MT6357_LCLDO_ENC_REMOTE_SENSE_VA28_ENABLE	BIT(10)
#define MT6357_LCLDO_ENC_REMOTE_SENSE_VA28_DISABLE	0
#define MT6357_LCLDO_ENC_EN_VA28_MASK			BIT(8)
#define MT6357_LCLDO_ENC_EN_VA28_ENABLE			BIT(8)
#define MT6357_LCLDO_ENC_EN_VA28_DISABLE		0
#define MT6357_LCLDO_REMOTE_SENSE_VA18_MASK		BIT(6)
#define MT6357_LCLDO_REMOTE_SENSE_VA18_ENABLE		BIT(6)
#define MT6357_LCLDO_REMOTE_SENSE_VA18_DISABLE		0
#define MT6357_LCLDO_EN_VA18_MASK			BIT(4)
#define MT6357_LCLDO_EN_VA18_ENABLE			BIT(4)
#define MT6357_LCLDO_EN_VA18_DISABLE			0
#define MT6357_HCLDO_REMOTE_SENSE_VA18_MASK		BIT(2)
#define MT6357_HCLDO_REMOTE_SENSE_VA18_ENABLE		BIT(2)
#define MT6357_HCLDO_REMOTE_SENSE_VA18_DISABLE		0
#define MT6357_HCLDO_EN_VA18_MASK			BIT(0)
#define MT6357_HCLDO_EN_VA18_ENABLE			BIT(0)
#define MT6357_HCLDO_EN_VA18_DISABLE			0

/* MT6357_AUDDEC_ANA_CON13 */
#define MT6357_NVREG_EN_VAUDP15_MASK		BIT(0)
#define MT6357_NVREG_EN_VAUDP15_ENABLE		BIT(0)
#define MT6357_NVREG_EN_VAUDP15_DISABLE		0

/* MT6357_AUDDEC_ELR_0 */
#define MT6357_AUD_HP_TRIM_EN_VAUDP15_MASK	BIT(12)
#define MT6357_AUD_HP_TRIM_EN_VAUDP15_ENABLE	BIT(12)
#define MT6357_AUD_HP_TRIM_EN_VAUDP15_DISABLE	0

/* MT6357_ZCD_CON1 */
#define MT6357_AUD_LOL_GAIN_MASK		GENMASK(4, 0)
#define MT6357_AUD_LOL_GAIN_SFT			0
#define MT6357_AUD_LOR_GAIN_MASK		GENMASK(11, 7)
#define MT6357_AUD_LOR_GAIN_SFT			7
#define MT6357_AUD_LO_GAIN_MAX			0x12

/* MT6357_ZCD_CON2 */
#define MT6357_AUD_HPL_GAIN_MASK		GENMASK(4, 0)
#define MT6357_AUD_HPL_GAIN_SFT			0
#define MT6357_AUD_HPR_GAIN_MASK		GENMASK(11, 7)
#define MT6357_AUD_HPR_GAIN_SFT			7
#define MT6357_AUD_HP_GAIN_MAX			0x12

/* MT6357_ZCD_CON3 */
#define MT6357_AUD_HS_GAIN_MASK			GENMASK(4, 0)
#define MT6357_AUD_HS_GAIN_SFT			0
#define MT6357_AUD_HS_GAIN_MAX			0x12

/* Registers list */
/* gpio direction */
#define MT6357_GPIO_DIR0			0x0088
/* mosi */
#define MT6357_GPIO_MODE2			0x00B6
#define MT6357_GPIO_MODE2_SET			0x00B8
#define MT6357_GPIO_MODE2_CLR			0x00BA
/* miso */
#define MT6357_GPIO_MODE3			0x00BC
#define MT6357_GPIO_MODE3_SET			0x00BE
#define MT6357_GPIO_MODE3_CLR			0x00C0

#define MT6357_DCXO_CW14			0x07AC

#define MT6357_AUD_TOP_CKPDN_CON0		0x208C
#define MT6357_AUDNCP_CLKDIV_CON0		0x20B4
#define MT6357_AUDNCP_CLKDIV_CON1		0x20B6
#define MT6357_AUDNCP_CLKDIV_CON2		0x20B8
#define MT6357_AUDNCP_CLKDIV_CON3		0x20BA
#define MT6357_AUDNCP_CLKDIV_CON4		0x20BC
#define MT6357_AFE_UL_DL_CON0			0x2108
#define MT6357_AFE_DL_SRC2_CON0_L		0x210A
#define MT6357_AFE_UL_SRC_CON0_H		0x210C
#define MT6357_AFE_UL_SRC_CON0_L		0x210E
#define MT6357_AFE_TOP_CON0			0x2110
#define MT6357_AUDIO_TOP_CON0			0x2112
#define MT6357_AFUNC_AUD_CON0			0x2116
#define MT6357_AFUNC_AUD_CON2			0x211A
#define MT6357_AFE_ADDA_MTKAIF_CFG0		0x2134
#define MT6357_AFE_SGEN_CFG0			0x2140
#define MT6357_AFE_DCCLK_CFG0			0x2146
#define MT6357_AFE_DCCLK_CFG1			0x2148
#define MT6357_AFE_AUD_PAD_TOP			0x214C
#define MT6357_AUDENC_ANA_CON0			0x2188
#define MT6357_AUDENC_ANA_CON1			0x218A
#define MT6357_AUDENC_ANA_CON6			0x2194
#define MT6357_AUDENC_ANA_CON7			0x2196
#define MT6357_AUDENC_ANA_CON8			0x2198
#define MT6357_AUDENC_ANA_CON9			0x219A
#define MT6357_AUDDEC_ANA_CON0			0x2208
#define MT6357_AUDDEC_ANA_CON1			0x220A
#define MT6357_AUDDEC_ANA_CON2			0x220C
#define MT6357_AUDDEC_ANA_CON3			0x220E
#define MT6357_AUDDEC_ANA_CON4			0x2210
#define MT6357_AUDDEC_ANA_CON6			0x2214
#define MT6357_AUDDEC_ANA_CON7			0x2216
#define MT6357_AUDDEC_ANA_CON10			0x221C
#define MT6357_AUDDEC_ANA_CON11			0x221E
#define MT6357_AUDDEC_ANA_CON12			0x2220
#define MT6357_AUDDEC_ANA_CON13			0x2222
#define MT6357_AUDDEC_ELR_0			0x2226
#define MT6357_ZCD_CON1				0x228A
#define MT6357_ZCD_CON2				0x228C
#define MT6357_ZCD_CON3				0x228E

enum {
	DL_GAIN_8DB = 0,
	DL_GAIN_0DB = 8,
	DL_GAIN_N_1DB = 9,
	DL_GAIN_N_10DB = 18,
	DL_GAIN_N_12DB = 20,
	DL_GAIN_N_40DB = 0x1f,
};

enum {
	UL_GAIN_0DB = 0,
	UL_GAIN_6DB,
	UL_GAIN_12DB,
	UL_GAIN_18DB,
	UL_GAIN_24DB,
};

#define MT6357_DL_GAIN_N_40DB_REG		(DL_GAIN_N_40DB << 7 | DL_GAIN_N_40DB)
#define MT6357_DL_GAIN_REG_LEFT_MASK		0x001f
#define MT6357_DL_GAIN_REG_LEFT_SHIFT		0
#define MT6357_DL_GAIN_REG_RIGHT_MASK		0x0f80
#define MT6357_DL_GAIN_REG_RIGHT_SHIFT		7
#define MT6357_DL_GAIN_REG_MASK			0x0f9f

#define MT6357_SND_SOC_ADV_MT_FMTS (\
				SNDRV_PCM_FMTBIT_S16_LE |\
				SNDRV_PCM_FMTBIT_S16_BE |\
				SNDRV_PCM_FMTBIT_U16_LE |\
				SNDRV_PCM_FMTBIT_U16_BE |\
				SNDRV_PCM_FMTBIT_S24_LE |\
				SNDRV_PCM_FMTBIT_S24_BE |\
				SNDRV_PCM_FMTBIT_U24_LE |\
				SNDRV_PCM_FMTBIT_U24_BE |\
				SNDRV_PCM_FMTBIT_S32_LE |\
				SNDRV_PCM_FMTBIT_S32_BE |\
				SNDRV_PCM_FMTBIT_U32_LE |\
				SNDRV_PCM_FMTBIT_U32_BE)

#define MT6357_SOC_HIGH_USE_RATE (\
				SNDRV_PCM_RATE_CONTINUOUS |\
				SNDRV_PCM_RATE_8000_192000)

/* codec private structure */
struct mt6357_priv {
	struct device *dev;
	struct regmap *regmap;
	bool pull_down_needed;
	int hp_channel_number;
};
#endif
