; -*- fundamental -*- (asm-mode sucks)
; $Id: isolinux.asm,v 1.52 2002/04/23 01:22:22 hpa Exp $
; ****************************************************************************
;
;  isolinux.asm
;
;  A program to boot Linux kernels off a CD-ROM using the El Torito
;  boot standard in "no emulation" mode, making the entire filesystem
;  available.  It is based on the SYSLINUX boot loader for MS-DOS
;  floppies.
;
;   Copyright (C) 1994-2002  H. Peter Anvin
;
;  This program is free software; you can redistribute it and/or modify
;  it under the terms of the GNU General Public License as published by
;  the Free Software Foundation, Inc., 675 Mass Ave, Cambridge MA 02139,
;  USA; either version 2 of the License, or (at your option) any later
;  version; incorporated herein by reference.
; 
; ****************************************************************************

; Note: The Makefile builds one version with DEBUG_MESSAGES automatically.
; %define DEBUG_TRACERS			; Uncomment to get debugging tracers
; %define DEBUG_MESSAGES		; Uncomment to get debugging messages

%ifdef DEBUG_TRACERS

%macro TRACER	1
	call debug_tracer
	db %1
%endmacro

%else	; DEBUG_TRACERS

%macro	TRACER	1
%endmacro

%endif	; DEBUG_TRACERS

;
; Some semi-configurable constants... change on your own risk.  Most are imposed
; by the kernel.
;
max_cmd_len	equ 255			; Must be odd; 255 is the kernel limit
FILENAME_MAX_LG2 equ 8			; log2(Max filename size Including final null)
FILENAME_MAX	equ (1 << FILENAME_MAX_LG2)
HIGHMEM_MAX	equ 037FFFFFFh		; DEFAULT highest address for an initrd
HIGHMEM_SLOP	equ 128*1024		; Avoid this much memory near the top
DEFAULT_BAUD	equ 9600		; Default baud rate for serial port
BAUD_DIVISOR	equ 115200		; Serial port parameter
MAX_OPEN_LG2	equ 6			; log2(Max number of open files)
MAX_OPEN	equ (1 << MAX_OPEN_LG2)
SECTORSIZE_LG2	equ 11			; 2048 bytes/sector (El Torito requirement)
SECTORSIZE	equ (1 << SECTORSIZE_LG2)

;
; Should be updated with every release to avoid bootsector/SYS file mismatch
;
%define	version_str	VERSION		; Must be 4 characters long!
%define date		DATE_STR	; Defined from the Makefile
%define	year		'2002'
;
; Debgging stuff
;
; %define debug 1			; Uncomment to enable debugging
;
; ID for SYSLINUX (reported to kernel)
;
syslinux_id	equ 033h		; SYSLINUX (3) 3 = ISOLINUX

;
; Segments used by Linux
;
real_mode_seg	equ 5000h
fake_setup_seg	equ real_mode_seg+020h

		struc real_mode_seg_t
		resb 20h-($-$$)		; org 20h
kern_cmd_magic	resw 1			; 0020 Magic # for command line
kern_cmd_offset resw 1			; 0022 Offset for kernel command line
		resb 497-($-$$)		; org 497d
bs_setupsecs	resb 1			; 01F1 Sectors for setup code (0 -> 4)
bs_rootflags	resw 1			; 01F2 Root readonly flag
bs_syssize	resw 1			; 01F4
bs_swapdev	resw 1			; 01F6 Swap device (obsolete)
bs_ramsize	resw 1			; 01F8 Ramdisk flags, formerly ramdisk size
bs_vidmode	resw 1			; 01FA Video mode
bs_rootdev	resw 1			; 01FC Root device
bs_bootsign	resw 1			; 01FE Boot sector signature (0AA55h)
su_jump		resb 1			; 0200 0EBh
su_jump2	resb 1			; 0201 Size of following header
su_header	resd 1			; 0202 New setup code: header
su_version	resw 1			; 0206 See linux/arch/i386/boot/setup.S
su_switch	resw 1			; 0208
su_setupseg	resw 1			; 020A
su_startsys	resw 1			; 020C
su_kver		resw 1			; 020E Kernel version pointer
su_loader	resb 1			; 0210 Loader ID
su_loadflags	resb 1			; 0211 Load high flag
su_movesize	resw 1			; 0212
su_code32start	resd 1			; 0214 Start of code loaded high
su_ramdiskat	resd 1			; 0218 Start of initial ramdisk
su_ramdisklen	equ $			; Length of initial ramdisk
su_ramdisklen1	resw 1			; 021C
su_ramdisklen2	resw 1			; 021E
su_bsklugeoffs	resw 1			; 0220
su_bsklugeseg	resw 1			; 0222
su_heapend	resw 1			; 0224
su_pad1		resw 1			; 0226
su_cmd_line_ptr	resd 1			; 0228
su_ramdisk_max	resd 1			; 022C
		resb (9000h-12)-($-$$)	; Were bootsect.S puts it...
linux_stack	equ $			; 8FF4
linux_fdctab	equ $
		resb 9000h-($-$$)
cmd_line_here	equ $			; 9000 Should be out of the way
		endstruc

;
; Kernel command line signature
;
CMD_MAGIC	equ 0A33Fh		; Command line magic

;
; Magic number of su_header field
;
HEADER_ID       equ 'HdrS'		; HdrS (in littleendian hex)

;
; Flags for the su_loadflags field
;
LOAD_HIGH	equ 01h			; Large kernel, load high
CAN_USE_HEAP    equ 80h                 ; Boot loader reports heap size

;
; The following structure is used for "virtual kernels"; i.e. LILO-style
; option labels.  The options we permit here are `kernel' and `append
; Since there is no room in the bottom 64K for all of these, we
; stick them at vk_seg:0000 and copy them down before we need them.
;
; Note: this structure can be added to, but it must 
;
%define vk_power	6		; log2(max number of vkernels)
%define	max_vk		(1 << vk_power)	; Maximum number of vkernels
%define vk_shift	(16-vk_power)	; Number of bits to shift
%define vk_size		(1 << vk_shift)	; Size of a vkernel buffer

		struc vkernel
vk_vname:	resb FILENAME_MAX	; Virtual name **MUST BE FIRST!**
vk_rname:	resb FILENAME_MAX	; Real name
vk_appendlen:	resw 1
		alignb 4
vk_append:	resb max_cmd_len+1	; Command line
		alignb 4
vk_end:		equ $			; Should be <= vk_size
		endstruc

%if (vk_end > vk_size) || (vk_size*max_vk > 65536)
%error "Too many vkernels defined, reduce vk_power"
%endif

;
; Segment assignments in the bottom 640K
; 0000h - main code/data segment (and BIOS segment)
; 5000h - real_mode_seg
;
vk_seg          equ 4000h		; Virtual kernels
xfer_buf_seg	equ 3000h		; Bounce buffer for I/O to high mem
comboot_seg	equ 2000h		; COMBOOT image loading zone

;
; File structure.  This holds the information for each currently open file.
;
		struc open_file_t
file_sector	resd 1			; Sector pointer (0 = structure free)
file_left	resd 1			; Number of sectors left
		endstruc

%if (open_file_t_size & (open_file_t_size-1))
%error "open_file_t is not a power of 2"
%endif

;
; For our convenience: define macros for jump-over-unconditinal jumps
;
%macro	jmpz	1
	jnz %%skip
	jmp %1
%%skip:
%endmacro

%macro	jmpnz	1
	jz %%skip
	jmp %1
%%skip:
%endmacro

%macro	jmpe	1
	jne %%skip
	jmp %1
%%skip:
%endmacro

%macro	jmpne	1
	je %%skip
	jmp %1
%%skip:
%endmacro

%macro	jmpc	1
	jnc %%skip
	jmp %1
%%skip:
%endmacro

%macro	jmpnc	1
	jc %%skip
	jmp %1
%%skip:
%endmacro

%macro	jmpb	1
	jnb %%skip
	jmp %1
%%skip:
%endmacro

%macro	jmpnb	1
	jb %%skip
	jmp %1
%%skip:
%endmacro

;
; Macros similar to res[bwd], but which works in the code segment (after
; section .text)
;
%macro	zb	1
	times %1 db 0
%endmacro

%macro	zw	1
	times %1 dw 0
%endmacro

%macro	zd	1
	times %1 dd 0
%endmacro

; ---------------------------------------------------------------------------
;   BEGIN THE BIOS/CODE/DATA SEGMENT
; ---------------------------------------------------------------------------

		absolute 0400h
serial_base	resw 4			; Base addresses for 4 serial ports
		absolute 0413h
BIOS_fbm	resw 1			; Free Base Memory (kilobytes)
		absolute 046Ch
BIOS_timer	resw 1			; Timer ticks
		absolute 0472h
BIOS_magic	resw 1			; BIOS reset magic
                absolute 0484h
BIOS_vidrows    resb 1			; Number of screen rows

;
; Memory below this point is reserved for the BIOS and the MBR
;
 		absolute 1000h
trackbuf	resb 8192		; Track buffer goes here
trackbufsize	equ $-trackbuf
;		trackbuf ends at 3000h


;
; Constants for the xfer_buf_seg
;
; The xfer_buf_seg is also used to store message file buffers.  We
; need two trackbuffers (text and graphics), plus a work buffer
; for the graphics decompressor.
;
xbs_textbuf	equ 0			; Also hard-coded, do not change
xbs_vgabuf	equ trackbufsize
xbs_vgatmpbuf	equ 2*trackbufsize

		struc dir_t
dir_lba		resd 1			; Directory start (LBA)
dir_len		resd 1			; Length in bytes
dir_clust	resd 1			; Length in clusters
		endstruc

                absolute 5000h          ; Here we keep our BSS stuff
VKernelBuf:	resb vk_size		; "Current" vkernel
		alignb 4
AppendBuf       resb max_cmd_len+1	; append=
KbdMap		resb 256		; Keyboard map
FKeyName	resb 10*FILENAME_MAX	; File names for F-key help
NumBuf		resb 15			; Buffer to load number
NumBufEnd	resb 1			; Last byte in NumBuf
ISOFileName	resb 64			; ISO filename canonicalization buffer
ISOFileNameEnd	equ $
		alignb 32
KernelName      resb FILENAME_MAX       ; Mangled name for kernel
KernelCName     resb FILENAME_MAX	; Unmangled kernel name
InitRDCName     resb FILENAME_MAX       ; Unmangled initrd name
MNameBuf	resb FILENAME_MAX
InitRD		resb FILENAME_MAX
PartInfo	resb 16			; Partition table entry
E820Buf		resd 5			; INT 15:E820 data buffer
HiLoadAddr      resd 1			; Address pointer for high load loop
HighMemSize	resd 1			; End of memory pointer (bytes)
RamdiskMax	resd 1			; Highest address for a ramdisk
KernelSize	resd 1			; Size of kernel (bytes)
RootDir		resb dir_t_size		; Root directory
CurDir		resb dir_t_size		; Current directory
SavedSSSP	resd 1			; Our SS:SP while running a COMBOOT image
KernelClust	resd 1			; Kernel size in clusters
InitStack	resd 1			; Initial stack pointer (SS:SP)
FirstSecSum	resd 1			; Checksum of bytes 64-2048
ImageDwords	resd 1			; isolinux.bin size, dwords
FBytes		equ $			; Used by open/getc
FBytes1		resw 1
FBytes2		resw 1
FClust		resw 1			; Number of clusters in open/getc file
FNextClust	resw 1			; Pointer to next cluster in d:o
FPtr		resw 1			; Pointer to next char in buffer
CmdOptPtr       resw 1			; Pointer to first option on cmd line
KernelCNameLen  resw 1			; Length of unmangled kernel name
InitRDCNameLen  resw 1			; Length of unmangled initrd name
NextCharJump    resw 1			; Routine to interpret next print char
SetupSecs	resw 1			; Number of setup sectors
A20Test		resw 1			; Counter for testing status of A20
CmdLineLen	resw 1			; Length of command line including null
GraphXSize	resw 1			; Width of splash screen file
VGAPos		resw 1			; Pointer into VGA memory
VGACluster	resw 1			; Cluster pointer for VGA image file
VGAFilePtr	resw 1			; Pointer into VGAFileBuf
ConfigFile	resw 1			; Socket for config file
PktTimeout	resw 1			; Timeout for current packet
KernelExtPtr	resw 1			; During search, final null pointer
LocalBootType	resw 1			; Local boot return code
ImageSectors	resw 1			; isolinux.bin size, sectors
TextAttrBX      equ $
TextAttribute   resb 1			; Text attribute for message file
TextPage        resb 1			; Active display page
CursorDX        equ $
CursorCol       resb 1			; Cursor column for message file
CursorRow       resb 1			; Cursor row for message file
ScreenSize      equ $
VidCols         resb 1			; Columns on screen-1
VidRows         resb 1			; Rows on screen-1
FlowControl	equ $
FlowOutput	resb 1			; Outputs to assert for serial flow
FlowInput	resb 1			; Input bits for serial flow
FlowIgnore	resb 1			; Ignore input unless these bits set
RetryCount      resb 1			; Used for disk access retries
KbdFlags	resb 1			; Check for keyboard escapes
LoadFlags	resb 1			; Loadflags from kernel
A20Tries	resb 1			; Times until giving up on A20
FuncFlag	resb 1			; == 1 if <Ctrl-F> pressed
DisplayMask	resb 1			; Display modes mask
ISOFlags	resb 1			; Flags for ISO directory search
DiskError	resb 1			; Error code for disk I/O
DriveNo		resb 1			; CD-ROM BIOS drive number
TextColorReg	resb 17			; VGA color registers for text mode
VGAFileBuf	resb FILENAME_MAX	; Unmangled VGA image name
VGAFileBufEnd	equ $
VGAFileMBuf	resb FILENAME_MAX	; Mangled VGA image name

		alignb open_file_t_size
Files		resb MAX_OPEN*open_file_t_size

		section .text
                org 7C00h
;;
;; Primary entry point.  Because BIOSes are buggy, we only load the first
;; CD-ROM sector (2K) of the file, so the number one priority is actually
;; loading the rest.
;;
bootsec		equ $
_start:		; Far jump makes sure we canonicalize the address
		cli
		jmp 0:_start1
		times 8-($-$$) nop		; Pad to file offset 8

		; This table gets filled in by mkisofs using the
		; -boot-info-table option
bi_pvd:		dd 0xdeadbeef			; LBA of primary volume descriptor
bi_file:	dd 0xdeadbeef			; LBA of boot file
bi_length:	dd 0xdeadbeef			; Length of boot file
bi_csum:	dd 0xdeadbeef			; Checksum of boot file
bi_reserved:	times 10 dd 0xdeadbeef		; Reserved

_start1:	mov [cs:InitStack],sp		; Save initial stack pointer
		mov ax,ss
		mov [cs:InitStack+2],ax
		xor ax,ax
		mov ss,ax
		mov sp,_start			; Set up stack
		mov ds,ax
		mov es,ax
		mov fs,ax
		mov gs,ax
		sti

		cld
		; Show signs of life
		mov si,isolinux_banner
		call writestr
%ifdef DEBUG_MESSAGES
		mov si,copyright_str
		call writestr
%endif

		;
		; Before modifying any memory, get the checksum of bytes
		; 64-2048
		;
initial_csum:	xor edi,edi
		mov si,_start1
		mov cx,(SECTORSIZE-64) >> 2
.loop:		lodsd
		add edi,eax
		loop .loop
		mov [FirstSecSum],edi

		; Set up boot file sizes
		mov eax,[bi_length]
		sub eax,SECTORSIZE-3
		shr eax,2			; bytes->dwords
		mov [ImageDwords],eax		; boot file dwords
		add eax,(2047 >> 2)
		shr eax,9			; dwords->sectors
		mov [ImageSectors],ax		; boot file sectors

		mov [DriveNo],dl
%ifdef DEBUG_MESSAGES
		mov si,startup_msg
		call writemsg
		mov al,dl
		call writehex2
		call crlf
%endif

		; Now figure out what we're actually doing
		; Note: use passed-in DL value rather than 7Fh because
		; at least some BIOSes will get the wrong value otherwise
		mov ax,4B01h			; Get disk emulation status
		mov dl,[DriveNo]
		mov si,spec_packet
		int 13h
		jc near spec_query_failed	; Shouldn't happen (BIOS bug)
		mov dl,[DriveNo]
		cmp [sp_drive],dl		; Should contain the drive number
		jne near spec_query_failed

%ifdef DEBUG_MESSAGES
		mov si,spec_ok_msg
		call writemsg
		mov al,byte [sp_drive]
		call writehex2
		call crlf
%endif

found_drive:
		; Get drive information
		mov ah,48h
		mov dl,[DriveNo]
		mov si,drive_params
		int 13h
		jnc params_ok

		mov si,nosecsize_msg
		call writemsg

params_ok:
		; Check for the sector size (should be 2048, but
		; some BIOSes apparently think we're 512-byte media)
		;
		; FIX: We need to check what the proper behaviour
		; is for getlinsec when the BIOS thinks the sector
		; size is 512!!!  For that, we need such a BIOS, though...
%ifdef DEBUG_MESSAGES
		mov si,secsize_msg
		call writemsg
		mov ax,[dp_secsize]
		call writehex4
		call crlf
%endif

load_image:
		; Some BIOSes apparently have limitations on the size 
		; that may be loaded (despite the El Torito spec being very
		; clear on the fact that it must all be loaded.)  Therefore,
		; we load it ourselves, and *bleep* the BIOS.

		mov eax,[bi_file]		; Address of code to load
		inc eax				; Don't reload bootstrap code
%ifdef DEBUG_MESSAGES
		mov si,offset_msg
		call writemsg
		call writehex8
		call crlf
%endif

		; Just in case some BIOSes have problems with
		; segment wraparound, use the normalized address
		mov bx,((7C00h+2048) >> 4)
		mov es,bx
		xor bx,bx
		mov bp,[ImageSectors]
%ifdef DEBUG_MESSAGES
		push ax
		mov si,size_msg
		call writemsg
		mov ax,bp
		call writehex4
		call crlf
		pop ax
%endif
		call getlinsec

		push ds
		pop es

%ifdef DEBUG_MESSAGES
		mov si,loaded_msg
		call writemsg
%endif

		; Verify the checksum on the loaded image.
verify_image:
		mov si,7C00h+2048
		mov bx,es
		mov ecx,[ImageDwords]
		mov edi,[FirstSecSum]		; First sector checksum
.loop		es lodsd
		add edi,eax
		dec ecx
		jz .done
		and si,si
		jnz .loop
		; SI wrapped around, advance ES
		add bx,1000h
		mov es,bx
		jmp short .loop
.done:		mov ax,ds
		mov es,ax
		cmp [bi_csum],edi
		je integrity_ok

		mov si,checkerr_msg
		call writemsg
		jmp kaboom

integrity_ok:
%ifdef DEBUG_MESSAGES
		mov si,allread_msg
		call writemsg
%endif
		jmp all_read			; Jump to main code

		; INT 13h, AX=4B01h, DL=<passed in value> failed.
		; Try to scan the entire 80h-FFh from the end.
spec_query_failed:
		mov si,spec_err_msg
		call writemsg

		mov dl,0FFh
.test_loop:	pusha
		mov ax,4B01h
		mov si,spec_packet
		mov byte [si],13		; Size of buffer
		int 13h
		popa
		jc .still_broken

		mov si,maybe_msg
		call writemsg
		mov al,dl
		call writehex2
		call crlf

		cmp byte [sp_drive],dl
		jne .maybe_broken

		; Okay, good enough...
		mov si,alright_msg
		call writemsg
		mov [DriveNo],dl
.found_drive:	jmp found_drive

		; Award BIOS 4.51 apparently passes garbage in sp_drive,
		; but if this was the drive number originally passed in
		; DL then consider it "good enough"
.maybe_broken:
		cmp byte [DriveNo],dl
		je .found_drive

.still_broken:	dec dx
		cmp dl, 80h
		jnb .test_loop

fatal_error:
		mov si,nothing_msg
		call writemsg

.norge:		jmp short .norge

		; Information message (DS:SI) output
		; Prefix with "isolinux: "
		;
writemsg:	push ax
		push si
		mov si,isolinux_str
		call writestr
		pop si
		call writestr
		pop ax				
		ret

;
; crlf: Print a newline
;
crlf:		mov si,crlf_msg
		; Fall through

;
; cwritestr: write a null-terminated string to the console, saving
;            registers on entry.
;
; Note: writestr and cwritestr are distinct in SYSLINUX, not in ISOLINUX
;
cwritestr:
		pushfd
                pushad
.top:		lodsb
		and al,al
                jz .end
		call writechr
                jmp short .top
.end:		popad
		popfd
                ret

writestr	equ cwritestr

;
; writehex[248]: Write a hex number in (AL, AX, EAX) to the console
;
writehex2:
		pushfd
		pushad
		shl eax,24
		mov cx,2
		jmp short writehex_common
writehex4:
		pushfd
		pushad
		shl eax,16
		mov cx,4
		jmp short writehex_common
writehex8:
		pushfd
		pushad
		mov cx,8
writehex_common:
.loop:		rol eax,4
		push eax
		and al,0Fh
		cmp al,10
		jae .high
.low:		add al,'0'
		jmp short .ischar
.high:		add al,'A'-10
.ischar:	call writechr
		pop eax
		loop .loop
		popad
		popfd
		ret

;
; Write a character to the screen.  There is a more "sophisticated"
; version of this in the subsequent code, so we patch the pointer
; when appropriate.
;

writechr:
		jmp near writechr_simple	; NOT "short"!!!!

writechr_simple:
		pushfd
		pushad
		mov ah,0Eh
		xor bx,bx
		int 10h
		popad
		popfd
		ret

;
; Get one sector.  Convenience entry point.
;
getonesec:
		mov bp,1
		; Fall through to getlinsec

;
; Get linear sectors - EBIOS LBA addressing, 2048-byte sectors.
;
; Note that we can't always do this as a single request, because at least
; Phoenix BIOSes has a 127-sector limit.  To be on the safe side, stick
; to 32 sectors (64K) per request.
;
; Input:
;	EAX	- Linear sector number
;	ES:BX	- Target buffer
;	BP	- Sector count
;
getlinsec:
		mov si,dapa			; Load up the DAPA
		mov [si+4],bx
		mov bx,es
		mov [si+6],bx
		mov [si+8],eax
.loop:
		push bp				; Sectors left
		cmp bp,byte 32
		jbe .bp_ok
		mov bp,32
.bp_ok:
		mov [si+2],bp
		push si
		mov dl,[DriveNo]
		mov ah,42h			; Extended Read
		call xint13
		pop si
		pop bp
		movzx eax,word [si+2]		; Sectors we read
		add [si+8],eax			; Advance sector pointer
		sub bp,ax			; Sectors left
		shl ax,SECTORSIZE_LG2-4		; 2048-byte sectors -> segment
		add [si+6],ax			; Advance buffer pointer
		and bp,bp
		jnz .loop
		mov eax,[si+8]			; Next sector
		ret

		; INT 13h with retry
xint13:		mov byte [RetryCount], 6
.try:		pushad
		int 13h
		jc .error
		add sp,byte 8*4			; Clean up stack
		ret
.error:		mov [DiskError],ah		; Save error code
		popad
		dec byte [RetryCount]
		jnz .try

.real_error:	mov si,diskerr_msg
		call writemsg
		mov al,[DiskError]
		call writehex2
		mov si,ondrive_str
		call writestr
		mov al,dl
		call writehex2
		call crlf
		; Fall through to kaboom

;
; kaboom: write a message and bail out.  Wait for a user keypress,
;	  then do a hard reboot.
;
kaboom:
		lss sp,[cs:Stack]
		mov ax,cs
		mov ds,ax
		mov es,ax
		mov fs,ax
		mov gs,ax
		sti
		mov si,err_bootfailed
		call cwritestr
		call getchar
		cli
		mov word [BIOS_magic],0	; Cold reboot
		jmp 0F000h:0FFF0h	; Reset vector address

;
; Data that needs to be in the first sector
;
isolinux_banner	db CR, LF, 'ISOLINUX ', version_str, ' ', date, ' ', 0
copyright_str   db ' Copyright (C) 1994-', year, ' H. Peter Anvin'
		db CR, LF, 0
isolinux_str	db 'isolinux: ', 0
%ifdef DEBUG_MESSAGES
startup_msg:	db 'Starting up, DL = ', 0
spec_ok_msg:	db 'Loaded spec packet OK, drive = ', 0
secsize_msg:	db 'Sector size appears to be ', 0
offset_msg:	db 'Loading main image from LBA = ', 0
size_msg:	db 'Sectors to load = ', 0
loaded_msg:	db 'Loaded boot image, verifying...', CR, LF, 0
verify_msg:	db 'Image checksum verified.', CR, LF, 0
allread_msg	db 'Main image read, jumping to main code...', CR, LF, 0
%endif
spec_err_msg:	db 'Loading spec packet failed, trying to wing it...', CR, LF, 0
maybe_msg:	db 'Found something at drive = ', 0
alright_msg:	db 'Looks like it might be right, continuing...', CR, LF, 0
nosecsize_msg:	db 'Failed to get sector size, assuming 0800', CR, LF, 0
diskerr_msg:	db 'Disk error ', 0
ondrive_str:	db ', drive ', 0
nothing_msg:	db 'Failed to locate CD-ROM device; boot failed.', CR, LF, 0
checkerr_msg:	db 'Image checksum error, sorry...', CR, LF, 0

err_bootfailed	db CR, LF, 'Boot failed: press a key to retry...'
bailmsg		equ err_bootfailed
crlf_msg	db CR, LF, 0

;
; El Torito spec packet
;
		align 8, db 0
spec_packet:	db 13h				; Size of packet
sp_media:	db 0				; Media type
sp_drive:	db 0				; Drive number
sp_controller:	db 0				; Controller index
sp_lba:		dd 0				; LBA for emulated disk image
sp_devspec:	dw 0				; IDE/SCSI information
sp_buffer:	dw 0				; User-provided buffer
sp_loadseg:	dw 0				; Load segment
sp_sectors:	dw 0				; Sector count
sp_chs:		db 0,0,0			; Simulated CHS geometry
sp_dummy:	db 0				; Scratch, safe to overwrite

;
; Spec packet for disk image emulation
;
		align 8, db 0
dspec_packet:	db 13h				; Size of packet
dsp_media:	db 0				; Media type
dsp_drive:	db 0				; Drive number
dsp_controller:	db 0				; Controller index
dsp_lba:	dd 0				; LBA for emulated disk image
dsp_devspec:	dw 0				; IDE/SCSI information
dsp_buffer:	dw 0				; User-provided buffer
dsp_loadseg:	dw 0				; Load segment
dsp_sectors:	dw 1				; Sector count
dsp_chs:	db 0,0,0			; Simulated CHS geometry
dsp_dummy:	db 0				; Scratch, safe to overwrite

;
; EBIOS drive parameter packet
;
		align 8, db 0
drive_params:	dw 30				; Buffer size
dp_flags:	dw 0				; Information flags
dp_cyl:		dd 0				; Physical cylinders
dp_head:	dd 0				; Physical heads
dp_sec:		dd 0				; Physical sectors/track
dp_totalsec:	dd 0,0				; Total sectors
dp_secsize:	dw 0				; Bytes per sector
dp_dpte:	dd 0				; Device Parameter Table
dp_dpi_key:	dw 0				; 0BEDDh if rest valid
dp_dpi_len:	db 0				; DPI len
		db 0
		dw 0
dp_bus:		times 4 db 0			; Host bus type
dp_interface:	times 8 db 0			; Interface type
db_i_path:	dd 0,0				; Interface path
db_d_path:	dd 0,0				; Device path
		db 0
db_dpi_csum:	db 0				; Checksum for DPI info

;
; EBIOS disk address packet
;
		align 8, db 0
dapa:		dw 16				; Packet size
.count:		dw 0				; Block count
.off:		dw 0				; Offset of buffer
.seg:		dw 0				; Segment of buffer
.lba:		dd 0				; LBA (LSW)
		dd 0				; LBA (MSW)

		alignb 4, db 0
Stack		dw _start, 0		; SS:SP for stack reset

rl_checkpt	equ $				; Must be <= 800h

rl_checkpt_off	equ ($-$$)
%if rl_checkpt_off > 0x800
%error "Sector 0 overflow"
%endif

; ----------------------------------------------------------------------------
;  End of code and data that have to be in the first sector
; ----------------------------------------------------------------------------

all_read:
;
; Initialize screen (if we're using one)
;
		; Now set up screen parameters
		call adjust_screen

		; Patch the writechr routine to point to the full code
		mov word [writechr+1], writechr_full-(writechr+3)

; Tell the user we got this far...
%ifndef DEBUG_MESSAGES			; Gets messy with debugging on
		mov si,copyright_str
		call writestr
%endif

; Test tracers
		TRACER 'T'
		TRACER '>'

;
; Clear Files structures
;
		mov di,Files
		mov cx,(MAX_OPEN*open_file_t_size)/4
		xor eax,eax
		rep stosd

; 
; Check that no moron is trying to boot Linux on a 286 or so.  According
; to Intel, the way to check is to see if the high 4 bits of the FLAGS
; register are either all stuck at 1 (8086/8088) or all stuck at 0
; (286 in real mode), if not it is a 386 or higher.  They didn't
; say how to check for a 186/188, so I *hope* it falls out as a 8086
; or 286 in this test.
;
; Also, provide an escape route in case it doesn't work.
;
check_escapes:
		mov ah,02h			; Check keyboard flags
		int 16h
		mov [KbdFlags],al		; Save for boot prompt check
		test al,04h			; Ctrl->skip 386 check
		jnz skip_checks
test_8086:
		pushf				; Get flags
		pop ax
		and ax,0FFFh			; Clear top 4 bits
		push ax				; Load into FLAGS
		popf
		pushf				; And load back
		pop ax
		and ax,0F000h			; Get top 4 bits
		cmp ax,0F000h			; If set -> 8086/8088
		je not_386
test_286:
		pushf				; Get flags
		pop ax
		or ax,0F000h			; Set top 4 bits
		push ax
		popf
		pushf
		pop ax
		and ax,0F000h			; Get top 4 bits
		jnz is_386			; If not clear -> 386
not_386:
		mov si,err_not386
		call writestr
		jmp kaboom
is_386:
		; Now we know it's a 386 or higher
;
; Now check that there is sufficient low (DOS) memory
;
		int 12h
		cmp ax,(real_mode_seg+0xa00) >> 6
		jae enough_ram
		mov si,err_noram
		call writestr
		jmp kaboom
enough_ram:
skip_checks:

;
; Check if we're 386 (as opposed to 486+); if so we need to blank out
; the WBINVD instruction
;
; We check for 486 by setting EFLAGS.AC
;
		pushfd				; Save the good flags
		pushfd
		pop eax
		mov ebx,eax
		xor eax,(1 << 18)		; AC bit
		push eax
		popfd
		pushfd
		pop eax
		popfd				; Restore the original flags
		xor eax,ebx
		jnz is_486
;
; 386 - Looks like we better blot out the WBINVD instruction
;
		mov byte [try_wbinvd],0c3h		; Near RET		
is_486:

;
; Now we're all set to start with our *real* business.	First load the
; configuration file (if any) and parse it.
;
; In previous versions I avoided using 32-bit registers because of a
; rumour some BIOSes clobbered the upper half of 32-bit registers at
; random.  I figure, though, that if there are any of those still left
; they probably won't be trying to install Linux on them...
;
; The code is still ripe with 16-bitisms, though.  Not worth the hassle
; to take'm out.  In fact, we may want to put them back if we're going
; to boot ELKS at some point.
;
		mov si,linuxauto_cmd		; Default command: "linux auto"
		mov di,default_cmd
                mov cx,linuxauto_len
		rep movsb

		mov di,KbdMap			; Default keymap 1:1
		xor al,al
		mov cx,256
mkkeymap:	stosb
		inc al
		loop mkkeymap

;
; Now, we need to sniff out the actual filesystem data structures.
; mkisofs gave us a pointer to the primary volume descriptor
; (which will be at 16 only for a single-session disk!); from the PVD
; we should be able to find the rest of what we need to know.
; 
get_fs_structures:
		mov eax,[bi_pvd]
		mov bx,trackbuf
		call getonesec

		mov eax,[trackbuf+156+2]
		mov [RootDir+dir_lba],eax
		mov [CurDir+dir_lba],eax
%ifdef DEBUG_MESSAGES
		mov si,dbg_rootdir_msg
		call writemsg
		call writehex8
		call crlf
%endif
		mov eax,[trackbuf+156+10]
		mov [RootDir+dir_len],eax		
		mov [CurDir+dir_len],eax
		add eax,SECTORSIZE-1
		shr eax,SECTORSIZE_LG2
		mov [RootDir+dir_clust],eax
		mov [CurDir+dir_clust],eax

		; Look for an "isolinux" directory, and if found,
		; make it the current directory instead of the root
		; directory.
		mov di,isolinux_dir
		mov al,02h			; Search for a directory
		call searchdir_iso
		jz .no_isolinux_dir
		mov [CurDir+dir_len],eax
		mov eax,[si+file_left]
		mov [CurDir+dir_clust],eax
		xor eax,eax			; Free this file pointer entry
		xchg eax,[si+file_sector]
		mov [CurDir+dir_lba],eax
%ifdef DEBUG_MESSAGES
		push si
		mov si,dbg_isodir_msg
		call writemsg
		pop si
		call writehex8
		call crlf
%endif
.no_isolinux_dir:

;
; Locate the configuration file
;
load_config:
%ifdef DEBUG_MESSAGES
		mov si,dbg_config_msg
		call writemsg
%endif

		mov di,isolinux_cfg
		call open
		jz near no_config_file		; Not found or empty

%ifdef DEBUG_MESSAGES
		mov si,dbg_configok_msg
		call writemsg
%endif

;
; Now we have the config file open
;
parse_config:
		call getkeyword
                jc near end_config_file		; Config file loaded
		cmp ax,'de'			; DEfault
		je pc_default
		cmp ax,'ap'			; APpend
		je pc_append
		cmp ax,'ti'			; TImeout
		je near pc_timeout
		cmp ax,'pr'			; PRompt
		je near pc_prompt
		cmp ax,'fo'			; FOnt
		je near pc_font
		cmp ax,'kb'			; KBd
		je near pc_kbd
		cmp ax,'di'			; DIsplay
		je near pc_display
		cmp ax,'la'			; LAbel
		je near pc_label
		cmp ax,'ke'			; KErnel
		je near pc_kernel
                cmp ax,'im'                     ; IMplicit
                je near pc_implicit
		cmp ax,'se'			; SErial
		je near pc_serial
		cmp ax,'sa'			; SAy
		je near pc_say
		cmp ax,'lo'			; LOcalboot
		je pc_localboot
		cmp al,'f'			; F-key
		jne parse_config
		jmp pc_fkey

pc_default:	mov di,default_cmd		; "default" command
		call getline
		xor al,al
		stosb				; null-terminate
		jmp short parse_config

pc_append:      cmp word [VKernelCtr],byte 0	; "append" command
		ja pc_append_vk
                mov di,AppendBuf
		call getline
                sub di,AppendBuf
pc_app1:        mov [AppendLen],di
                jmp short parse_config_2
pc_append_vk:	mov di,VKernelBuf+vk_append	; "append" command (vkernel)
		call getline
		sub di,VKernelBuf+vk_append
                cmp di,byte 2
                jne pc_app2
                cmp byte [VKernelBuf+vk_append],'-'
                jne pc_app2
                mov di,0                        ; If "append -" -> null string
pc_app2:        mov [VKernelBuf+vk_appendlen],di
		jmp short parse_config_2	

pc_localboot:	call getint			; "localboot" command
		cmp word [VKernelCtr],byte 0	; ("label" section only)
		je parse_config_2
		mov [VKernelBuf+vk_rname], byte 0	; Null kernel name
		mov [VKernelBuf+vk_rname+1], bx	; Return type
		jmp short parse_config_2

pc_kernel:	cmp word [VKernelCtr],byte 0	; "kernel" command
		je parse_config_2		; ("label" section only)
		mov di,trackbuf
		push di
		call getline
		pop si
		mov di,VKernelBuf+vk_rname
		call mangle_name
		jmp short parse_config_2

pc_timeout:	call getint			; "timeout" command
		jc parse_config_2
		mov ax,0D215h			; There are approx 1.D215h
		mul bx				; clock ticks per 1/10 s
		add bx,dx
		mov [KbdTimeOut],bx
parse_config_2:	jmp parse_config

pc_display:	call pc_getfile			; "display" command
		jz parse_config_2		; File not found?
		call get_msg_file		; Load and display file
		jmp short parse_config_2

pc_prompt:	call getint			; "prompt" command
		jc parse_config_2
		mov [ForcePrompt],bx
		jmp short parse_config_2

pc_implicit:    call getint                     ; "implicit" command
                jc parse_config_2
                mov [AllowImplicit],bx
                jmp short parse_config_2

pc_serial:	call getint			; "serial" command
		jc parse_config_2
		push bx				; Serial port #
		call skipspace
		jc parse_config_2
		call ungetc
		call getint
		mov [FlowControl], word 0	; Default to no flow control
		jc .nobaud
.valid_baud:	
		push ebx
		call skipspace
		jc .no_flow
		call ungetc
		call getint			; Hardware flow control?
		jnc .valid_flow
.no_flow:
		xor bx,bx			; Default -> no flow control
.valid_flow:
		and bh,0Fh			; FlowIgnore
		shl bh,4
		mov [FlowIgnore],bh
		mov bh,bl
		and bx,0F003h			; Valid bits
		mov [FlowControl],bx
		pop ebx				; Baud rate
		jmp short .parse_baud
.nobaud:
		mov ebx,DEFAULT_BAUD		; No baud rate given
.parse_baud:
		pop di				; Serial port #
		cmp ebx,byte 75
		jb parse_config_2		; < 75 baud == bogus
		mov eax,BAUD_DIVISOR
		cdq
		div ebx
		push ax				; Baud rate divisor
		cmp di,3
		ja .port_is_io			; If port > 3 then port is I/O addr
		shl di,1
		mov di,[di+serial_base]		; Get the I/O port from the BIOS
.port_is_io:
		mov [SerialPort],di
		lea dx,[di+3]			; DX -> LCR
		mov al,83h			; Enable DLAB
		call slow_out
		pop ax				; Divisor
		mov dx,di			; DX -> LS
		call slow_out
		inc dx				; DX -> MS
		mov al,ah
		call slow_out
		mov al,03h			; Disable DLAB
		add dx,byte 2			; DX -> LCR
		call slow_out
		in al,dx			; Read back LCR (detect missing hw)
		cmp al,03h			; If nothing here we'll read 00 or FF
		jne .serial_port_bad		; Assume serial port busted
		sub dx,byte 2			; DX -> IER
		xor al,al			; IRQ disable
		call slow_out

		add dx,byte 3			; DX -> MCR
		in al,dx
		or al,[FlowOutput]		; Assert bits
		call slow_out

		; Show some life
		mov si,isolinux_banner
		call write_serial_str
		mov si,copyright_str
		call write_serial_str

		jmp short parse_config_3

.serial_port_bad:
		mov [SerialPort], word 0
		jmp short parse_config_3

pc_fkey:	sub ah,'1'
		jnb pc_fkey1
		mov ah,9			; F10
pc_fkey1:	xor cx,cx
		mov cl,ah
		push cx
		mov ax,1
		shl ax,cl
		or [FKeyMap], ax		; Mark that we have this loaded
		mov di,trackbuf
		push di
		call getline			; Get filename to display
		pop si
		pop di
		shl di,FILENAME_MAX_LG2		; Convert to offset
		add di,FKeyName
		call mangle_name		; Mangle file name
		jmp short parse_config_3

pc_label:	call commit_vk			; Commit any current vkernel
		mov di,trackbuf			; Get virtual filename
		push di
		call getline
		pop si
		mov di,VKernelBuf+vk_vname
		call mangle_name		; Mangle virtual name
		inc word [VKernelCtr]		; One more vkernel
		mov si,VKernelBuf+vk_vname 	; By default, rname == vname
		mov di,VKernelBuf+vk_rname
		mov cx,FILENAME_MAX
		rep movsb
                mov si,AppendBuf         	; Default append==global append
                mov di,VKernelBuf+vk_append
                mov cx,[AppendLen]
                mov [VKernelBuf+vk_appendlen],cx
                rep movsb
		jmp near parse_config_3

pc_font:	call pc_getfile			; "font" command
		jz parse_config_3		; File not found?
		call loadfont			; Load and install font
		jmp short parse_config_3

pc_kbd:		call pc_getfile			; "kbd" command
		jz parse_config_3
		call loadkeys
parse_config_3:	jmp parse_config

pc_say:		mov di,trackbuf			; "say" command
		push di
		call getline
		xor al,al
		stosb				; Null-terminate
		pop si
		call writestr
		call crlf
		jmp short parse_config_3

;
; pc_getfile:	For command line options that take file argument, this
; 		routine decodes the file argument and runs it through searchdir
;
pc_getfile:	mov di,trackbuf
		push di
		call getline
		pop si
		mov di,MNameBuf
		push di
		call mangle_name
		pop di
		jmp searchdir			; Tailcall

;
; commit_vk: Store the current VKernelBuf into buffer segment
;
commit_vk:
		cmp word [VKernelCtr],byte 0
		je cvk_ret			; No VKernel = return
		cmp word [VKernelCtr],max_vk	; Above limit?
		ja cvk_overflow
		mov di,[VKernelCtr]
		dec di
		shl di,vk_shift
		mov si,VKernelBuf
		mov cx,(vk_size >> 2)
		push es
		push word vk_seg
		pop es
		rep movsd			; Copy to buffer segment
		pop es
cvk_ret:	ret
cvk_overflow:	mov word [VKernelCtr],max_vk	; No more than max_vk, please
		ret

;
; End of configuration file
;
end_config_file:
		call commit_vk			; Commit any current vkernel
no_config_file:
;
; Check whether or not we are supposed to display the boot prompt.
;
check_for_key:
		cmp word [ForcePrompt],byte 0	; Force prompt?
		jnz enter_command
		test byte [KbdFlags],5Bh	; Caps, Scroll, Shift, Alt
		jz near auto_boot		; If neither, default boot

enter_command:
		mov si,boot_prompt
		call cwritestr

		mov byte [FuncFlag],0		; <Ctrl-F> not pressed
		mov di,command_line
;
; get the very first character -- we can either time
; out, or receive a character press at this time.  Some dorky BIOSes stuff
; a return in the buffer on bootup, so wipe the keyboard buffer first.
;
clear_buffer:	mov ah,1			; Check for pending char
		int 16h
		jz get_char_time
		xor ax,ax			; Get char
		int 16h
		jmp short clear_buffer
get_char_time:	
		call vgashowcursor
		mov cx,[KbdTimeOut]
		and cx,cx
		jz get_char			; Timeout == 0 -> no timeout
		inc cx				; The first loop will happen
						; immediately as we don't
						; know the appropriate DX value
time_loop:	push cx
tick_loop:	push dx
		call pollchar
		jnz get_char_pop
		mov dx,[BIOS_timer]		; Get time "of day"
		pop ax
		cmp dx,ax			; Has the timer advanced?
		je tick_loop
		pop cx
		loop time_loop			; If so, decrement counter
		call vgahidecursor
		jmp command_done		; Timeout!

get_char_pop:	pop eax				; Clear stack
get_char:
		call vgashowcursor
		call getchar
		call vgahidecursor
		and al,al
		jz func_key

got_ascii:	cmp al,7Fh			; <DEL> == <BS>
		je backspace
		cmp al,' '			; ASCII?
		jb not_ascii
		ja enter_char
		cmp di,command_line		; Space must not be first
		je get_char
enter_char:	test byte [FuncFlag],1
		jz .not_ctrl_f
		mov byte [FuncFlag],0
		cmp al,'0'
		jb .not_ctrl_f
		je ctrl_f_0
		cmp al,'9'
		jbe ctrl_f
.not_ctrl_f:	cmp di,max_cmd_len+command_line ; Check there's space
		jnb get_char
		stosb				; Save it
		call writechr			; Echo to screen
get_char_2:	jmp short get_char
not_ascii:	mov byte [FuncFlag],0
		cmp al,0Dh			; Enter
		je near command_done
		cmp al,06h			; <Ctrl-F>
		je set_func_flag
		cmp al,08h			; Backspace
		jne get_char
backspace:	cmp di,command_line		; Make sure there is anything
		je get_char			; to erase
		dec di				; Unstore one character
		mov si,wipe_char		; and erase it from the screen
		call cwritestr
		jmp short get_char_2

set_func_flag:
		mov byte [FuncFlag],1
		jmp short get_char_2

ctrl_f_0:	add al,10			; <Ctrl-F>0 == F10
ctrl_f:		push di
		sub al,'1'
		xor ah,ah
		jmp short show_help

func_key:
		push di
		cmp ah,68			; F10
		ja get_char_2
		sub ah,59			; F1
		jb get_char_2
		shr ax,8
show_help:	; AX = func key # (0 = F1, 9 = F10)
		mov cl,al> LCR
		mo
		call loadfestore the original flags
	).
; 
get_fs_d [Vfla if rl_chLmp abet_chge     Xn		jmp ase	
cvk_overflowal flags
0ort .pars loadfesto
		sh_out

		; ce]f

		; Justov ds,ae	
cvvvvvvvvvIf

	 FILEoadfecommand_lineom
ls
%de3,tvvvEoadfecoverflowad_lineomandrad_r_ms k at 0
cvvde3,t	s1Diinc wo;y
		cmp r pc_kbd(l getintsf]jnz2all cwrxhbits
f	resbf
		pussbf
	CR
		caLEoadfecomhNpu_adfedrnelBu Now	cmp woimplicdd bx,dx
		mov [KbdTimcacddand_donegetint      )cacdddgok_msg
cx
		jz geky a BIOS,x,eax
	gok_mz2alytedstore one char needcx,cx
	iled
crlfmmit_vk			;_get_chmissing hw)hdi			; Dcx
		for Flag],0		; <Ctrl-F> not pree/pdl5h
		mul bx				; clock ticsg
	call w)led
crlf<if rX -> LS	ja cvk_overfolinux_banne	call w	jmp sho S; Ha rl_chLm_adfed    kag],0,t needr4lCtr]
		decke dd
				plkag],0,t neel-F>edr4lCtve to be in the icause atled	SecSumags the icausn the icauFiles  si,VKerne.eedr4l icauFiles eedr48Ue:Eedr4jb gKernel .*[Vf	pus	push di
		sub ent vgis1  si,	ng hw)hdi			; f de	dd 0					ngi(l:ttwo jb b_r4l icauFiles eedr48rA			g
		obut
		; some BIO	; F the icause atl:ed to nea		shr op eax				; deat			; Load aad		g	ngshift
		moi			; f de	ddag]ica ent opa
		jc	ng
		ca		; x,0F0		je ngshift
s%1
%%skiul
Ktors]
%ifsg	ngs al,al
bfolinux ngshie	call wnything
		.tg
		cadal
bis_386l,al
	jmp nders
dp_head:	dd 0			shiflear	cadal
becu p eILF,T%1
%%skiget_fs_d ctors we Mr	cadal
buff
; shiflearlve a ,_vk, Ue:E6l,a
		.tgdFh		get	jb RS 4.r
no_sca di,de	cce p,.sanc	resw 1			sh de	ddag]ica ent opa
		jc	ng
		ca		 1			sh dedEm.  Iile_		pop  F the i1f out tt_s		cayte [,g
		%%s;board map
FKedishor1	shr op da, and if ncFndBuf         	;		; knowcu pcb.  Iii:cmp- (kilobytes)
		abso
h di
		sub alrd m		call sloternv [Seria1ILENAMb!:)=Unt vgis1i1f m_adfensloternv0en_fnnot_op  Feckg hw)hdi		dDILENA6 only for isho1i1f mApop eax	p si
		pop diately as we don'uf         	; Default append==global append
                mov di,VKernelBuf+vk_me
		xor axbi_pvdesto
	oefdef3b*d
     	; Deernv.feny If 6et:	ret
Bufut tt_s	etionyName
b	; f de	rightENA6 only for isho1i1z
 for ish as we ,eax				1ho1i1z
d)
		F,se_confiho1i1z
 		jnve,2o1i1_s	etionyNa/:ame
		push  Write az
 		j getint
		mov [F0 0xdeanve,2o1
NumBu movMb!:)=Unt vgis eax	ing up, key1:	xomap

;
; Now, w 1			; Poide	detint
		mov [F0 or ish as we ,6	decoeC
ume descr  bx,Flags]uomaor inter to 	jnb .tedescr  bx, sectors/:	callM	jmpg:
		auFilesuomaet_char eedro8rcala type
dsh cx

.port_int		cl font
		.  Therear	cadal
1z
 	or ish as we ,6	:e ncFndwe ,6	:ncFndnidecurs:ncFndnidecurs:ncFndor A eax,ax			; Geme
	yX valuesernelBuf+vk_me
		xor axbi_pvdesto
	oefdef3rac,4d:ncF2o1i1_s	etionyNa/:8sho11f3b*d
 0.g
		obment
		add [si+6]
		.   p eIL	cmp ah,eout ==r axbi_pv	sub alwFFher ef ncFnfdefonfibi_pv	suer t_Diviso si,-i			; Dcx
		for Fe
		push_chai_pv	sual,'0'
		jb .noaje .fo>ll wp command_d
pc_dpi./	calrsi
		sb
	dnidecurF>0 == 		mochar
		int 16rN-	fig_fil		inurF>0 == 	e
		shl ax 	; Defaul Co Show some life
		mov si,i		; FOnt
sh di
		cmp ah,6 Show some lif n bootupl:	call clif nbtrollea],eax
 somefig_7
 shl p short get_char
not_Fe_len:	db 0A eancF2o1i1_sya=en:	db 0A e],dl	FDto 32e,i1_sya=en:	namese_,copyrk	jc near ar_time
some lifverfIpc_kbd(lf(
1z
 	orr ar_t7orr ar_tbutkerhort ge"ame
		cas rs/:s4r i_name0si,-i			; r_ elClust_fs%I ica-i			; r_ elClust_fs%I ica- di
 ishtedstore one; Lo		call slovk, igurai_nak_sifd
		pop_Ll 'ta*d
 t			cp:dd 1_sya=en8nt
sh dip pacNA6 onln licdd 	sub avvvvvpend	SecSumags the icauv cx,		pop_ig_7avvvvvp,ort_bad		o_out
		inc s		pe:	db
 		jno_o INT 13h with byte"p_Ll 'tdi
	d
				plkaOrtl:ed t_char eedra cvk_oveh with(in buffed eedra cvk_oba cvk_overfl appe(
 		i,boh eedra cv.Ipc_kbd with byte"p_est 3			cpst_bad		o_orovifile argutack]iIpc_ know(o_orea],eaxaf the root
		;lra cvk_t_c.dcall cro.oadfec    equ $
CursorCol   m,  the keyboard buffer first.
;
clear_buffer	.tgdFh		get	jb pnIpc_k keymap becu p eg_file:
;
; Check nfirbi_pvdes	callt0				; IDE; r_ ,s%I i_file:
;
; pk nfir01h,lboot:	call getinoron is :; 64-2048
		;
initial	.  e
dsp_devs;
; pks			; se
		xor  di,byte 2

initial			; se
		heck nfi+vk_rname
		mov cx,FILENAME_load_image:
call cr
		je ticklinuword [wllt0-hme
		push  Write az
 		j getin	xor eaxax,ax		bha cvk_tes:
	e;
; pk nl
1z
4l icauFchar
not_Fritestrminatepushfcacddhfailed	tlClust_fscauFoi1z
d)
		F,se_confiho1(linu1ata that eugArd [hme
		push  h eedra 0csi,isolinux_bann4r i0

		kp; DPIul Co  DPIul Ce	pop axt_Fe_len:	db 0A drF>0 ==get_char:
		call vgashowgsinc cx				; Th...'4o non4r i0

orth the hass		; soft
s%1
eDPIul Co  DPIu;
initi8]: Write ap shent, this0wiho1,ll wp commter
har_time
		xowiho1,l; LBA (LSW)
 A e_bann4rUhKBd
		je near pc_kbd
d			 (Lr01h,7C00h+2hKBd'oron'r4jb gKerneisTailce
		_devs;C00h+2hKBd'orbt'r4jb gKerneisTailce
		_devs;C00h+2hKBd'oME_'r4jb gKerneisTequ 	_devs;C00h+2hKBd'o	; 'r4jb gKerneisT	; _ddressingr
		cKBd 00ffffffh;C00h+2hKBd'o	;'r4jb gKerneisT	 for dse passeOgns of l	j getin	xor t
s%1
	j getin	xor inc wo;ydif

; ssioparts:eck nfi+vk_r,er aupe: writf
		;in	xor incde.	T
; 		roui+vk_rnul neeom
execuh			tinctb
	dnidnDE; red l
db CR,ave etility,	mov etiti8]: Wri_2		;testr
..'4o necu p takk at 0
c	call cF VKernedidn't
; 's an	xor iis		mov fs,a1		g
		lcvk_di
		8Mot clverfoowadush di
		8Mruction
;
		mternge
%endifgic_me
	t      rshort warive)l,04h			ue argumcx,8ir0)
		mov cl,ae az
 64Kax_vl0Fh
r,	mov etieax,gottr_clbutkul		movze (shoulj getin	xor ip_devs_me
	o
		mov    srucad thma_kbet_char_sovl0Fh
.		and_us
		ms eax	i_display
		cmp ax,'la'x,8heck is8FFh			; ja(in buffed eedringr
		dcmp bytet
Bin buffsaop ax
		cmmov 2has a B for ds [S1er auper ds
clear_fut tt_s	eted eedriin buffsaop end.
spec_query_dec_query_failed:
		mot      s:ncFndnidecurs:ncFndr ish as we ,6	rX -> LSand_litransforr   resb n	xor t
supl:	call clif nbtrollea],eax
 somear writechr_single-seixDPIul bysb
	dnideis suf_msg
		cdll wgle-s---------oot filen	xor it vgis1 for a sp byte [VKe	xor sk et 16 only forda sp byt    dhr op C LBAsk etle-s#c_kbd LBA (or "t	kp; h d		movupm]		;  fact tionyNa-1g to boos CFa cvEDX >= 1	;  fendifh search]
		calS1eovzEini cvCFas sp
		.tgdFh		get	jb RS _confihult_cmd
   VD instruor 48itransfor fil6
		jrah	; Re],bh
			pu64Kab		moaries.	 H     ws;
;t.
;
cleector 0486 byt      rdush di
		64Krep movsbll c
		mov sl vg by---- vgX, noize_mnd_libyst      rs
; 		roi+vk_r/r aupe: writcleector 048ion
;
		ze_dohar
		cli
	funkyt
; tsions I fit 0				; Device32K (t      r64Kar_nors veorkoverflNVD i00h:0t.
;
funny	dec dace:_fut UG_MESSc_kb, so I)mourIffirst.
;
l0Fh
r di
		32K d LBA (ot], s,0486 by> 6
de_bannterfacknow(nedidp es
		rep movcknow 
get_char_sinc hult_PerMoby]nt.
;
		inc1to_bootlfhe coby;C00h+2hKBd _confihult_cj getintd be 2	call slow_ouhKBd _confihult_cjtd be 2	call :	tlClus _confihult_cmdcbyte media)
		sh de	ddag]ica ent opaort ge"ame
		cas rs/:s4r i_nC LBA (LSW)
 A  writes	TRACommand_dfs  I use atl:ed to nea		shr op es:bsT	 forigu1a0AA55h		o_out
		intt_s	eted eedrs a B foer d riguaclob_char eeex numberrt #
		c' bufaisters bete ap shent,rflow, so Irfo.t
supl:	cat		cl foicsg
's a; LBA (LSW)
 A !all cF VKeti
		yte se5:E820 (h byfer:	, so Irmap)f out te820: lif n bootupy forbp 4 b_char_2		pop ax
Device:
;
rd,[bi_file]			m		call sES = DS = 0p movnile n	call getindote820char_r+3)"a	cmp "	; Ctrl-evice,boo!
.)
 efault r
		cbp 4 b_charI 0486 byflow:attvvvEoadfem]		;  di
ote820chhar
Cur ', ;ov [FlowI*[Vf	pndote820:me
b	; f  ne0E820x,[bi_fil ti534D415ear pc"SMAP"yflowvvvvs on the siz20dra 0csi,iE820ax 	;  word5ll writeote820;C00h+2hati534D415ea		o_out
ote820;x
		mo       m	, so Irb jne s	; Save att<= 1 MB	g
		obu vectoracevvvv_bannt'la'hr op E820ax nve, ],0,t neelint)
 efaul_char_2		po>= 4 GB?,[bi_fil ti  bits
2not_cClusl ti  E820ax ]cx,[Kbd)
 efaul_char_2		po>= 1 MB?Name
b	; f  debuuuuuuhannt'la'hr op E820ax n12e, ],0,t neelinthugeb 'Disk er>= 4 GBName
b	; f   E820ax n8cjthuge:_cClusl f  ed
		mov bkey:
p sheushf
		po-----MB  There )
 efaul_char	auFiere subeve,21 MB?Nreal modeEiniti8]: Write ap shent,, so Ir1 MB
Cuupannt'la'hr op E820ax n16e, ],0,t1		o_out
		inst_badrflo, so_booflow, so Irfo_ms u	jnc ., so I  pushne; Lo6 by sod!,eax
 somefi
		jmp shor
		rflo, s_ fa1mbhar_2 Cheon
;
		m facve,21 MBnoize_te se5:E820 LF, 0
i sya=ete se5:E801.t
snote820:mx
 somear wrivk_ape801eck isQush ,rflow, so Ir(semi-k	; nt)	;  word5ll writeote801 ax
		cmmo3ceax,[bjateote801ck is> 3ntlyhar
		cli
's wroorap ax
PIul appenx,[Kbe801_ho	call mIt,, so Irho	c
		cmp wn8nt
e (sve,2partear wrivk_a     g
		call wall m64Kachunkso boot ELKS(16its
2no]
		calS-evice16Mefi
		jmp shor
		rflo, susha
oize_te se5:E801 LF, 0
i sya=ete se5:88.t
snote801	call adjus88eck isQush ,rflow, so Ir(olde ,)	;  word5ll w
		cmmov4*v 2has a d_drivtrey:
, so Ir>15Mj getine801_ho	cv al,83h			4*v 2h
e801_ho	c pc_getf; f  ffffh;C0g
		call 0	ine ; Check ls
%dkilo.'4o 
r
		rflo, s_ fa1mb:o boot ELKS(1its
2no]
		F VKerFh	a.'4o
r
		rflo, s:	tlClusELKSHIGHMEM_SLOPbyte [VKofloMemsk et 16 oFor cobut
		; some BIO	; F the  (	cmp axOne more;lra c  thesube [bi_pied getibut
		; ctrlthe :e not foundpyrk	jc nea	:e ncFndwe ,6	:ncFndnidce
		_devserial_port_e
ds_IMAGE=get_fs_d ctors we Mr	cadce
		_devs	pop iflearlve a ,_vk, Ue:E6l,a
		.tgdFh		get	jb RSs_fscauFoi1z
drial_port_Ucacddhfdb				; null-tet_fs_d ctors we Mr	cada_confiho1(linu1 iflearlve a ,_vk, Ue:E6l,a
		.tgdFh		get	jb RSgok_mzge"ame
		cas rs/:s4r i_n16h
			je pc_append
		c		jb gtd ip       a
		.tgdFh		get	jb RSs_ful bx				; 	cas rs/:s4r i_nOne morels
%dac,4dinprdware flhar_				ctrl_f_0:3add al,10			; <Ctrlize_mbp,[Imush bp	me BIO	; F the      mo[wllt0-'t
; lf set -> 8086000h:0FFze_)
 A e,bx
_)
es	callnd ax,0F0      registers  Bytesutoevspc ax,dsh  Wriar_time
		 FILEoadfejmp e
ds_IMAGE=,	mov ax,(re,boh lfnh
r ceck: Westore the oriLF,T%1
%%skiget_fs_d ctors we Mr	 cx,		initrdp al,e,2odag]ica ent opa
		jc	ng	g to bootDS <- gshie	call wnything
		.tg
		caw some ut tnext
crll cwrxhbits time.  Some dorme "ofrlthe _rch for a dok_mz2 Thereut tnext
crlget_chas386l,al
	jmp nders
dp_uld be ] use atl:ed to nea		suld 'vga='r4jb gis_vga AC bit
		push eax
		a		suld ', s='r4jb gis_, s_AC bit
		push eax
				jc	ngrt ge"ame
		cas rs/:s4r i_nicsg
ES -> gshie	call wnything
		.tg
		caw [Fors
		jc	ng
		ca		 1			sh ort ge"ame
		cas rs/:s4r i_nbootES <- d be 2,6 SncFnfdefonfibi_pv	suer initrdpe [FuncFlaharinitrdpe [	pop eax
	 icauFi   cmp ax,'im'       i			initrde not foun 0
dRD
		ca		; x,0F0		je ngshirt ge"ame
		cas rs/:s4r i_nacddhfadirnacddhfsas386l,al
	jmp ndersrt .pars loadfes
		cas rs/:s4r i_nX -> MCramdw 0	ull-tet_fs_d ctors weje near coauv cx,		es: 0
dRDment
;
stosbuf      ?		je pc_append
		cetav cx,		es:initrdp al,eto boot al,data th
i			initrd:mx
 somort ge"ame
		cas rs/:s4r i_ndi
		cmpES -> gshie	call wnyes:
	ters
crll crxhbi ort ge"ame
		cas rs/:s4r i_n8
shols
%dBIO	; F the is
f	resbf
		pussbf
	CR
		caLEoadfecomhNpu_adfees:
	ters
crlaLEoadfecomhNpu_a_chas386l,al
	jmp nders
		jmp short gnext
crlgis_vga AC  a
		.tgdFh		get	ji
		subonyNa/:6l,al
	jmp nders
dp_uld be ] use atl:ed to ne as we -1bit
		push eax
		a		suld  'd be'e
		cas rs/:s4r i_nvga=d be 2d aad		g	ngshift
		mvc2odag]ica ent opa
getf; f  ffffffht
;
3..'4o  use atl:ed to ne as we -2bit
		push eax
		a		suld  'ext' e
		cas rs/:s4r i_nvga=extd aad		g	ngshift
		mvc2odag]ica ent opa
 as we -3bit
		push eax
		a		suld  'ask' e
		cas rs/:s4r i_nvga=a	xor axbi_pvdesto
			mvc2odag]ica ent opa
e prom Manuf+vk_rname], byte 0	;_nvga=<ate CD>l writes:
	ters
crln],eax		an_)
 Ah
r
vc2 the safbs_vid	cal]]			mo booteen ode anbe first
		je s:
	ters
crlais_, s_AC  a
		.tgdFh		get	ji
		subonyNa/:6l,al
	jmp nderse prom Manuf+l writes:
	ters
crln],eax		an_)
 Ah
r
tlClusEbKSHIGHMEM_SLOPbyte [VKcs:ofloMemsk et 1abel" section o s:
	ters
crlafrlthe _rch:ything
		.tg
		caw [Forsrt ge"ame
		cas rs/:s4r i_ndi
		cmpf
	moard,6 SncFnfdefonfibi_pw some liClussshl p short get_char
ndpyrk	jcinu1alock tinugax
inclu    rdfensloternrX -> LS	ja cvk_ow		;lra cvl0Fh
is0wiho1,cad th,ax			; Advadx,di	,rfloA (LSW)
		hr op Ramdw 0Maxe, HIGHMEM_e ont_bad:
		minitrd	jz paannt'la'hr op es:su0				er],HEADER_ID		calwer aupe: wr ID		o_out
		inold		pe:	db
 	Oldis0wiho1,
		mo are ap		shr op es:su0      rmen202048-S aupe: wr       re2.0
clear_fut old		pe:	db
 	Oldis0wiho1,
		mo areuse atl:ed to nea		shr op es:su0      rmen201048-V     re2.01+?2alytedstore one chr_fw		pe:	d    je near pc_implicit
2.00,o s:
sters 0 ==gdag]ica ent opa
 as hr op es:su0			      add sp,bgn 8o bootgh:		ad			 gdag]ica ent opa
medicx,		es:su0
		potline
82048-Lberrt #	pe:	d e boo		cmpree ap		shr op es:su0      rmen203048-V     re2.03+;
clear_fw		pe:	d	n],eax		2.03+Name
b	; f des:su0ramdw 0_maxecmd		; Deamdw 0Maxe,ea		mo boot
		moamdw 0	jz paal,04h			 to sire su;lra cvkew-styl #	pe:	des	Lberrt #	pe:	d e boo	hothat ta,
sor
				; Divi tak	xorfurnrX_fw		pe:	d7Fh			; <DEL> es:su0
		per],sysadd spide_config_2		;ID		owritecifh sear es:bsTr aup		; ]		; Lrijnc .#c_kbr auper dsorss I/O addraupS	; ]	jmp
s%1
maet_l
		callrt #	pe:	des	caaf theade anrnis0wiho1,svze (shoul CR, L0h			 versw
som.'
bailm.icause atl:ed to necount
;
es:su0
		potlines I/O ad8
sh to the f;x
		moallrt #	pe:	des	Wa c waysc
		mov s---- ne00c	nvenor 0486 bye file argu
		
		mov s"dp_s;     m	"dp_s	
		mo		cmall ; Nowwn_l
		cw
, so Irr00h:0FF4r i
		om:
		lss s386:
	 thens eax	i_display
		cmp axb RSs_fscauFoi1z
ddi		druf+vov cl,al> LCpd_linfFndnidecurs:ncFndr ish as we ,6rname], byte 0	; Null	mov fs"FFher ef ncFnfdefonfibi_pv	su:
		ot	otze api		druf+v	otsFndnidecurs:ncFndr ish as we ,6	:6l,al
	jmp nders
dp_uld bofloMemsk et	tlClusELKS- ne00ci
		pop di
> segmeC00h+2hatiKe	xor sk et
clear_fut no	rflo_, so_boax		
check,rflow, so I;x
		Mo,eax
		dec dabeyo Iile_	r aupe: wr s srflow, so Ir---- ne00cA (LSW)
techall r op draupS	; ]48-S auper dsorss I vkeet		cl foplus 1 		roui+vk_r		je pc_append
		c
		call9	ine ; Check the.'4o  use atl:ed to ne as  siz8e00ci
		p32K	tlClusEsize in theNte CD:	db '4o neocmall lif n bocxnt.
;
		inc2	ine ; Check the'hr oso boot Ealls a 8086
; or its
4)i		dDILEstart sourcf ncFnfdefonfibi_pv	sueal"  ne00c	
		cas rs/:s4r i_nCall loa			; Use- ne00cAndnidecurs:ncFndr ishbmalld 1_syaansfor f srflow, so Ishne; OnDE;; NEame0siwe
some l	callrt # e,b
 ncFnfdefonfibi_pv	su:
		otze apii		drog; Usex
	on rear	cadal
1z
 	or ish as we ,6	:e ncFndwe ,6	:nterfacknow(nedid
,eax
 sornel
no_Nte CD:	db '4o n0				; i0
dp_bContr for it_int		cl fodi
		cmp
		xowiho1,l; LBA (LSW)
 A Name
b	; f de	xor sk et
clClusELKSornel
%1
m	mov:	dbov cl,adescineom2 Thererflo_et_chssed
		m, anadesci(tiny e near pjmp short pa	rflo_3
		call lime
		x

rflo_et_chssedi_display
		cmp axb RSLKS a 8086
; or  to boot Lof code an  wnything
		.tg
		cadal
bis6 oFncFnfdefonfibi_pv	su:
		otze aFndnidecurs:ncFndr ish as we ,6	:rX -> LSactor 048i;lra cn i0
dp_bCRAMdw 0;ovsbll cdumcx,8isit fromputize, as	Wa e boo		c;lra cvkew e nearr_timeold		pe:	d  Bytes  thesu; Checksg
'bj+vkriar_or 48itriyear, ' ritesitrd	b
	dnidnDoldis0wihoef DEBUGinitrd:Fndnidecurs:ncFndint 16h
		jinitrdp al,e,1 [KbdTimcacddand_don_fut nje sinitrdeit
		push eax
				jc	ngrt ge"ame
		cas rs/:s4r i_nES->gshie	call wnything
		.tg
		caw [Fods
		jc	ng
		ca		 1			sh ort ge"ame
		cas rs/:s4r i_nLo		call S==6 SncFnfdefonfibi_pv	susun 0
dRD
		ca		; x,0F0		jot foun 0
dRDso si,-i			; Dcx
		for Fe
		push_chai_pv	cas rs/:s4r i_nCgsh
		tedes- thejnc .ull-tet_fs_d ctors weClust_f 0
dRDso si,-i			; Dcx
		for/O ad 0
dRDso si
		cmp ax,'pr'			; PRompot foun 0
dRD
		ca		; x,0F0		joefdef3b*d
   me
		cas rs/:s4r i_n8
       it 0		sniff out 		jc	ng
		ca		 1			sh de dorinitrdpnott get_char
ndes:su0ramdw 0len1]	jm fodam	dw 0	lnugax_char
ndes:su0ramdw 0len2]mp byte [Vl tibofloMemsk etimer]	Sc_kb, so Iget_chasp byte [V; f deamdw 0Maxeo_booflowrite		; Useanve,lmsgydro8rcala th+2hd			; Cleetin, sp sh_okbyte [Vl tisingle-s bkey:
A6 ont 0	sbuffjz paa, sp sh_ok:s I vkeed		sh de	ddag]ica ey fodcmp 	; h d		movowwn_l
	64Kab		moaryt_cClusl tides:su0ramdw 0len]48-Sub		retap shent,ramdw 0	sh de	ddag]ica ey fodcmp 	; h d		movowwn_l
	64Kab		moaryt-i			; Dcx
		for/O ades:su0ramdw 0a_cmddx		pop di
> segmeC00short painitrd	call writes
dp_bCramdw 0	l" section oinitrdprch 
initrdpnott geti_display
		cmp axb RSs_fst_badinitrdeit
		push eax
		r ish as we ,6	:e ncFndwe ,6	:ncFndnid 0
dRDso si,-i			; Dcx
		for Fe
	 as we ,6	:e ncFndwe ,6	:ncFndnidecurs:ncFndnidecurs:ncFndor A eax,ax			

no	rflo_, s:p axb RSs_fst_badrflo, so_boE alwFame 	; Fndnidecurs:ncFndor A eax,ax			

initrdprch:
nje sinitrd:p
s%1
m memn ----t], 			; D:ncF2Ignoroot
		doboh lfnh
r pif ntA eax,s.icause atl:ed to neterfacknow(nediderial_port_LaKernelncepushneb RSs_f thesx,SECTORSIZErent VKernelBracter pax_vk	calne; Lo	cadrivtrey:
ourselvh oaft	mov  mear clik_ret:	ret
chneb RSsst
chneb RSsp,7Cying to bootupeardush d be 2,tes	TRAC VD instruor 48iw
some file argum' rit"dp_s,cmall rt #	pe:	d owwn_l
	1ne00cA or
				eof code an  ec dal
	9ne00ces	Wa c
		movecu p ishbzIdevse	pe:	dI i_filecapjnc ._kbr	; Save 		eir	r aupels
%donly for ish
> segmestore theLKS a 8086
; or ore thefis6 oFor cobll BIO	; F the es	Un   tunare s, rt #	pe:	d 		routintocolmcx,8ir0har_timeBIO	; F the  et_cxist 0				; 9xxxxhS) mvsenvenor 0-bit registets
		jr aupead_r_mse_banntl		cl foIe)
;
		nt,r
  x
_)
t	meedrs	push di
		cal8
sh to theLOAD_HIGHme dormeea	rfloctrlthe e ap		shr op fs:su0      rmen202048-S filrtvkew trlthe utintocol;
clear_fea	rfloctrlthe e a	calwetrlthe utintocol
char_2
		sis suff( alt)et to start 		; Unstore one chadhr op fs:su0l p shortpnears a 8086
; or its
4) + l p short get_ch section oin	jnepif_plh
		
_fea	rfloctrlthe :For cobll BIO	; F the tgh:	
	9ne00cstore theLKS9000x,[bi_filst
chneb RSsshl p short get_char
ndbe i_char
ndfs:				ctrl_devic]l r opCMD_MAGIC ar_2
		sdevic_char
ndfs:				ctrl_re's sar arar_2
		sSW)
 A No1i1_sya=enpyrk	jcinu1o boot kag],0,t3nt.
;
	inc2	ine ; Check the'hr oso bfs 			; <Ctrl lif n bfs,eax
 somear sh di
		cal8
sh to theLOAD_HIGHme d		cmn	jnepif_plh
	ll mIt,rflow' ri,0486 by	pop ;x
		moalave dp_;
		cmp 't c
		mov_o INsaf  et_ru,vk_splh
	.For cobll  a 8086
;	dec dace:	
	9ne00cstore theLKS9000x,[bi_filst
chneb RSa=endraupS	; ]ent vkernel
no_S aupe+ 		roui+vk_r	C0g
		a=e7l
no_S dsorse0si'hr oso be to be io be tov siio bfs 			; <Ctr_3
		call s aupe+ 		roui+vk_r	ize_m2		;	pe:	dI 0				; 1.2 b ispax		mov pre-bzIdevsecksg
dush di
		4		jr auper dsors,	mov axe 		routintocolmhritt_chyetube [b to scres	calyile:
nt
sh (if guaclob_A6 onint te [tr 0-biyion
;
		mtall sec dals
%ar_time "lot+vkride an"#	pe:	d i_faes	Un   tunare s, w		ue argcu p taknowaheadtransfor ; No m1,svz_o IN sett using 32-bitf guaclob_A getmourH    , z ana%endifw	32K beyo Iile_	r aupei_faeA (LSW)
		iendraupS	; ]ent vkeconfig_2

aupe+ 		roui+vk_r	C0b RSa=e32768/512
no_S dsors/32K	tlCluscaud:	
		pRemainr pc_ dsorss Ioad and9l
no_S dsorse0si.'4o  C0g
		a=e7l
no_S dsorse0si'hr oso be tor a sin,10			;c		jdery first c----if rX -Call rt #	pe:	d owwn_l
	time dp_s	
	cahf				; Get fhKBd _confisk et
cloot Ea=e3	; h d		movupvvvvs on
;
		inc2	ine B'4o n0si'hr oso bi_filsl"  ne00cbyte [Vl l"  ne0l getint	bmall	:rX -> LSeeom[wllt0-isiwe
somith,ax			; Advugh_ram:Winctwreut Ignor,sh oSW)
 s_l
	timedfenslarse_co,word [Vam:9000xax_vk	 8086
; or o;
mn	jnepif_plh
	,eax
		I 0-bit	jmp seaov ct	jvichecks:oot LoFLOPPY ( ne0l),mternge
%u
		/	jv/fd0 ( 2020)_bannt'lahr op es:bsT;
; Tev  rep movsb
n	mov cpnot	calppet_char_hr op es:bsT;
; Tev   2020
ov cpnot	calppe: rX -Call rt #dw 0	tided usirflow, so I,serialre-es
dp_b sheuhks peppet;ig

pc_dlerea],eaxaf ,ax			; Advaharlmsgn4r i0timeBIpet;dir_movsb    kag],0,t neabel"ldsSs_fufdctid](LSW)
		ieadd spfdctid	C0b RSa=e3	ine 12i.'4o  C0[hme
		pusfe
		mov si,il 'ta*d
ar
ndfdctid1ar ar_tiicsg
kew  peppe	tidoSWs*d
ar
ndfdctid2]mootupy foret
chney fodcmp 	;  word3h  	; Deernhow some v [Rootx
		m getiructseuhks peppe		mk_rnshugistfsgn4r i0r	; Save 		eis0wiho1nowamov fs,a		roi+vk.Seedra		; A6]
	l soaxaxil8086k_r:test byte 03F2hnn4r i0

		kp; yte 75
		jb pa;
arI 0486 bydebuggdfecowait     m	keya cvk_so
		cmp w	mov rt pdebugFFher efst;dir_len]debug	sh de	ddag]ica ey foret
chsh de	ddag]ica e word [Vv [Rootx
		bootupearse_coficient low  Iile_	m getik	 8-86
;	des	TRboax	e:sh o==			eof code an  VKernelBur clik_r as we dmefig_7
 sa      thefis      thegis      thesis      thesp add sp,bgn l,04h		6 by	pop
Cur booRUN THAT KERNEL  pus8-S auper se_cof==of code an  VKernee+  20h;uction
;
		mom:
 there's sp; z ana0				; f code an  VKerneeA (LS1_s	eti020x,[b,t neabel"l:	call cl0x,[bretf ;x
		moalidnDolder#	pe:	des	Older#	pe:	ds c waysccksg
4jr auper dsors,	mp 't cksgze_)
itrdrep mo      waysc
		memo areA (old		pe:	d:Fndnidecurs:ncFndint 16h
		jinitrdp al,e,1
 	Oldis0wiho	mp 't cksg initrdeit
		push eax
		dorDEBUGold		pe:	d_display
		cmp axb RSs_fst_bold	o_orovifile argutack]iIpc_ know(o_oreDEBUGold		pe:	d:t_char_hr op draupS	; ]	4le-s  waysc4br auper dsorss I/O a
		cal8
sh to the0le-s  waysclile n	cal thens eax	 ;x
		moalid	.  e
dsp_devses	A	.  e
dsp_devsecksbaspc ax,ds
		he..  e
		x1nowexcepv ax,(rethma_,osb			urse,tt_chti8]: W rt p		hesynt meterfses	Waze_do,,r
weeom,eanve,2UG_MExecuh  registe s20xt Lof appendo me
		mov.		and_ailce
		_devs:ingr
		dcmp bytet
Bme "of dce
		too_l0Fh
l w
		cmmo0ffnear pcMaxap she W .'4o  C0jaeof dce
		too_l0Fh
l
cha
	8o bootgh:		ad		hev dsorse0				; IVT (te s20x-3fh)
cha
	8 chadhr op 4*0x20],f dce
		f appe	;ste s20xtv+vk_r	C0b RSr a f dce
		nd
         	ie4*0x21	C0b RSa=e31le-s  lmcxmainr pc		hev dsors,10			;c		jd
		C0b RSa=ef dce
		or ore thelstcx
pace
		jnb near pcmoalidt <or >:0 neaNo1i1_sya=enpult_PerMoby]ommansolut	sdeximums#c_kbd LBA (oRACommand_dfs  I o be tov siio b1_sya=e64le-s256b '4o n(p shent,PSP)only for a singl first cPSP,10			;c		jd
t_char_hr op es:0_bad20CDh	;ste s20xtiut
		;  for i		F VKernon-fssioparagrapht_char_hr op es:02h], f dce
		or +10neaNo1i -Call rt #BIO	; F the   s
%drflow, so Is b1_sya=e125r pcMaxatrlthe ulial(mdd 			; imep moCR)r ish as wel bx				;        	ie081ar pcOe's se0		PSP_me
			; Unstore one chad buffer;c		he		; Unstore stvvvEoap ax
a		; immedc		jb gf dce
		trl_cp:	rxhbits time.  Some dorf dce
			pop  [Func		jb s1  si,f dce
		trl_cp
f dce
			pop  [:ecount
;OS_ti -CRoaft	molaKernel = retFunc		jb s1count
;126l foIeclu e		; imemov t_ch.parsine		; cl_char
ndes:80h], alrar_2
		sBIO	; F the  lnugax_s I/O addksgdSSSP],spore theLKSssr_tiicsg
amo
	SS:SPs I/O addksgdSSSP+2]	jmpelBracter pax_vk	calnfodi
ooteen oear wrivk_admefig_7
 sa
chneb RSsst
chnee to p,sporel:	call cl0	

pc_appendoa			; UseCommiE;; 
Ctrl-F> noce
		or :102048-Ru,vkaal,n8
  et -> 8d	.  e
dsp_devs	mov aoovl0Fh

f dce
		too_l0Fh
:x, sectors/:	cf dl0Fh
l w
SIZErent VKerncb_:ncF2k_loopdi,trackbuf
		
		dro2
  f appenv+vk_r	f dce
		f appe:ntl		cla d_drivtrey:
rt onek_ret:	ret
chneb RS sa
chneb RSlst
chnelvk_sp,ddksgdSSSP]Func	ar colrl-F>0 == F10
cb_:ncF2
s%1
et mpt
;
		mexecuh	p		hesynt meterf
f dce
		nd
  :ntl		cla d_drivtrey:
rt onek_ret:	ret
chneb RS sa
chneb RSlst
chnelvk_sp,ddksgdSSSP]Func	ar colrl-Fb RSs_fscauFoi1z
dla type
dsh cx

.por 3			cpst_bad	dosidecursor
		and al,al
		jz funcb_:ncF2
s%
		moalid			roui+vk_r	izisT	 for dse :
isT	; _ddress:o1i -Cp 't 	callrt se
ls
%de3,tneteork, da  rsh!
.bade ssk_loop:	push.bade ssl,al
		sided dw 0	emulahf		es	callgdFh		gedw 0	ctiemulahsecksde    rnee
;
; Chp shentar_time
		x: 1200K, 1440Kax_v2880Ka peppe,	o
		mof l	el ddw 0.		and_equ 	_devs:o1iTRACERh.parsTRACERhLFarsTRACERh'D'arsTRACERh':'
_msg
		cdll wtest byte ingle-sbootEDX <- 
		xot vgis1v	suer imgf      uncFlaharimgf     _		movbyte [V; f dsi+
		x_ddress]har_2		pr pcLBA		get	jbs I/O addsp_lbae,ea		mo L cro.oadfget	jbs I/O aet_charsp_drivt_bad	mo 00xa peppe,	80h	el de
		xot
		mov      :o1iTRACERh't'r4je [V; f ddjnvela th+2hd		ar		r4jb gKerne.d:  .*[Vf	pushort ge8 s1  si,t
		mov      No1i -Hl de
		xp_devses	Ne
;
		mexamhe  ehLCpd_lio.oad      une_)
ax_dstart memuc  ehLCC/H/Snd_r
		ryt
;Sflo.
.el d_equ 	_devs:o1iTRACERh'h'la th+2hd		512
clear_fut .[si+6]ah
l
che
		jnb		rep movsb1_sya=e1	call writ1ui+vk_r	C0ommand_dfs  I gArd t'lahr op 		rep mo+510_b0aa55h a B foer guaclob		o_out
		in.[si+6]ah
l foIdevs	t_cha fo    No1i1_sya=e4	; Th..pd_lio.oadrneriesbad		; Assume seri+446char_2		pofgepd_lio.oad      k_ret:	ret
cvk_ovoflowriti+vk_r(al)d			d(ah)
x
		j		omp :r coauv cx,		djnvebad		o_z 
		j		ter_comll us		jc phar eomman.hs(nedid
 di
		subonyNa/:amemman.hs(nedid

		j		ter_:pushort ge],0,t16 s1  si,t		j		omp ugArd [hme
single-sH/Srd [hme
sdngle-sei	xot vgis1v	subDX -> L medihle not vkeconfig_2#c_kb			dse0		BXce must not fig_2#c_kbs dsorse0		e	popcwalneo_boEAX[31:16] <- 0dra ul      g
		call9	ine ; Check the.'4o  eal modeeaxati8]: Write ante CD:	db '4o n2
  cythedert parse_config_2ei	xot vgis1y forda sp byt    1abel"getf;da sp byt_buffe_cxmaindert p vkeee very fF = r.oaMb!:ythederm]		; l mode(e)axati8]: Write ante CD:	db:ytheders
ffe_cxmainder:00h+2hativ 2h
 getintok_:ytv al,83h			 2has a Maxapossinc .#
tok_:yt:t_chae very fi Check themaxatytheder	t_t parse_config_2S(bl)dH(bh)
chi,maxh,6is1 fobDX -> L chgvk_a     g
		call wcall adjusbl s1count
;4	1i -Hl de
		xp		; F10/O aet_charsp_drivt_ba82048-Drivt	80h	=	el de
		xo
.d:  .*[Vf	:o1iTRACERh'T'is1v	subDX[sp_ we ale
;
endbDX0F0o_3
		call g

pc_dlere0	fomp ebx,b i0

	bl s1counarsp_ we alget_cboEmulahf		 d:   on
;
		_ctrls1counarsp_chse,ea		mo C/H/Snd_r
		ryv al,83h		[sp_devspec]3
		call 	jvichespecls1counarsp_devspec]a
chneb RSaDX[sp_g

pc_dler]3
		call g

pc_dlere0	dexls1counarsp_c

pc_dler] Somo1iTRACERh'V'elBracter pax_vk	calne; di
ooteen oear wrivk_a4Cying to 	sided emulahf		ep mo		; F10/O a:
		spec_; ik space
		dDX[DrivtNo]hnelvk_sp,d 0
dSbgn ]o1iTRACERh'X'
_ms word3h 
ll mIt,ters f appes,048 cksg prodedms
.[si+6]ah
:x, sectors/:	cequ 	_devs;C00ursor
		and al,al
		di,trackbuf
		
	
		mo       		ad	flowriti+ialH/Snd_r
		ryv; Lo	computeb:ythedersti+parare s
	
.hs(nedid:is1v	subDX[si		; ThHmov #r coauv DX -> Letint	pop_ume scall adjusbl	 a	calwe	flowrithmov #rt	pop_ume s:1v	subDX[siphar e
endbDX3Fhl
no_S dsor #r coauv DX l> Letint	pop_i+vk_r	C0b RS

	bl t	pop_i+vk_r:or al,al
	B foeaespecifieall crle
		xes	AXespecifiesrrt #
		ce
		xpnte CD; _r	i 0xuuuue0		
;
		ommaons I execuh	pte se8h ("next 	jvich.")ef DEvk_oveh :elBracter pax_vk	calhnelvk_sp,dcs:Sbgn ]l fodi
		cmp,bgn LSW)
 A Namy fodcmp 	; b RS sadchneb RSlstd     thefisd     thegisdxiled:
		mot avvvvvpx,SECTORSIZEBuf+vk_vname		cmmo-1r4jb g )
 18ugArd ll writ		roui+vk_rnhar
		callpecifieal
		ce
jviche
endom:
 the386:ace
		dDX l> Ly fodh,dhc_query_dec_qet:	ret
cvk_ovdi
ootdrivtCTORSIZEx)
 13ar wrivk_ap201eck isRmov sh di+vk_r	C0b RSa=e0001eck isC/H/Sn= 0/0/1u morriti+vk_r)
che
		jnb		rep movsbRSIZEx)
 13ar w somxanntl		cl fo
m memn ----t], 		hot:ncF2Ignoriled:
		mo		rep movsb1_sy	ie07Cyin	C0b RSa=e512
ni		drobideyineomxil8,	mov aons I ar_safepusfe
		mov si,lvk_sp,dcs: 0
dSbgn ]o1il
		0:07Cying to Jm:
 thekew 		roui+vk_r	
 )
 18:_ms word8eck  ThHopb pnIpc		i,b		; f00h:0wllt0m]		;  :
 ka		rm_charI 048 f appeed,	oh 		rivel,al
	is suffbmallFame 	;      f code anl,04h			:ncF2I"lot+vkride an,er atupear alt	is suffeetioone_co,wru,v			; <Ctrliw  Iile_nDE;; t
; MPORTANT:eaxaf  Bytes
		mosorsr	; C.ea],eaxaf  Byteul Crobideyiexcessive supaMb-f a_coisg ine38sowiho1r pcntar_ VKernes,	mov axi		dec deul Cainful 
check,asoverfolp axe [tcksett usire s
	e
;
eeom[wllt0-ck whelt0-"asoverheckk th.	jmp sal gua/:bmall_gdt:t_w bmall_gdt Show-1
;
stosbdescripk_rn-ati8]: WriGDTbyt d bmall_gdtl fop to sta    LGDTtiut
		;  for i_w 0byt d  ne0ffffht
;
C an  VKerne,	ue 16,  thejnc ,byt d  ne09bnear pca cvrne,	dpl 0, f eom
64Kbyt d  ne0ffffht
;
Data  VKerne,	ue 16,  the/Buf+v,byt d  n8f93near pca cvrne,	dpl 0, f eom
SIZE4Gbyt d  ne0ffffht
;
Data  VKerne,	ue 16,  the/Buf+v,byt d  ne093near pca cvrne,	dpl 0, f eom
64Kbbmall_gdt Show:	equ $-bmall_gdt
bbmall:d [hme
sinc_queryfcl foicsgs,	amoorao
		ms, rt #IF d?
		je[hme
gs lif n bfs,eax   kag],0,t neesbad		; dcs:SksgdSSSP],spore theLKSssbad		; dcs:SksgdSSSP+2]	jmpelBrls
0ort .pesided_a20pelBo32 lgdt dcs:bmall_gdt]	C0b RSr a fr0x,b i0

	1	C0b RSar0,ea		mo EncF2I"lot+vkride ano1il
		08h:.mn	jm	
 )
	jm: al,83h			 ht
;
Data  VKerne  Vl+vk_r	C0b RSrst
chneb RS sa
ch s1count
;18ar pc"R	 8-86
;- -> " data  VKernehneb RSsst
chneb RSfst
chneb RSgst
c	
		C0a32 			; <Ctr_3a d_
's abb
	degmeC0	C0b RSrst
c to boot Lo"r	 8-86
;- -> "hneb RS sa
chn	C0b RSr a fr0x,btime.  ~1	C0b RSar0,ea		mo Di	jnc ."lot+vkride ano1il
		0:.mn	rm	
 )
	rm: apop cx inef code anlnelvk_sp,dcs:SksgdSSSP]Fun			sh de w some lif sofs,eax
 sgsidecursodi	jnc _a20pelBx
 fck isRm-esideds_)
t	meedrs	puet the 	xor al,al
	Rme 	; 		; Aesidedw  Iidi	jnc  (yuck) A20es	calseFame 	; I i_f gaA getrliwhar
		ipsels
%doncoupc ._kbrourcfs, inclu    rhoulj getin	xor if
		;ihttp://www.x86.org/es	callon
;
    		adde this az
 	svl0Fh
iax,givenognori; the ndicatlmsgydDonni #
ar; I _kbRedHat, rt #prodedmvspcesynt mebe	dnidn
arIBMeaxankPov 760EL.l,04h			d: pc ax,dtog> MCA20 twiche    eeom[	64Katransforrlm.ic 
% to sc	io_de thecurso_io_de th
% to sc IO_DELAY_PORT	8 ht
;
Inval dContrecomm----!)
% to sc di	jnc _wait 	32  ThHow lfnhis await     m	di	jnc 

% to sc A20_DUNNO	0le-s 20 t:   une bon
% to sc A20_NONE	1le-s 20   wayscon?
% to sc A20_
		c	2le-s 20 
		ceesided
% to sc A20_KBC		3le-s 20 tmush bpKBC
% to sc A20_FAST	4le-s 20 tmush bpontre92h 
5
		jb p:	e [t ti et_cboFursotmush b

_io_de th:	e [tIO_DELAY_PORTX l> Le [tIO_DELAY_PORTX l> Lr al,esided_a20vk_tes:
	dF10/O aet_chacs: 20Tries],255 	mov ds_l
	try themakb pnIpceork

try_esided_a20vkll cFlt nert #Baned dedEdecursotry_wbinvdeax
		I 0-bit 20 t:   Ipce bon,dom:
 	jrah	; _l
	t:   a
	8 chabp,dcs: 20T:  t
cloot bp,bpery fi Check thehr opre's spacj'lahr op cs:bp+ 20Lit_cjall cF VKetiactor 048iaear seaesynt mep ax
not 20 gaA  a
a20_dunno:
a20_noe :e not fet_chacs: 20T:  t, A20_NONEannterfac20_+vk_bytet
Ba20_dpop ;x
		Nextti
		yrt #
		ce(te se5h	AX=2401e) a
a20_bios:e not fet_chacs: 20T:  t, A20_
		core theLKS2401ec_queryfcl 	e_m2		;
		cds_muckep ax
IF	;  word5ll wx
 f
annterfac20_+vk_bytet
Ba20_dpop ;x
			sided 		eis0ybol deg

pc_dlere 20 gaA  a
a20_kbc::ace
		dDX 1	calleax		thereyiex the appro mpty_8042bytet
Ba20_dpop	le-s 20 live,tt_ion
;
		me (sKBC
e not fet_chacs: 20T:  t, A20_KBC	ar_2		pr pcKBCsBIO	; F sequ    h s1count
;0D1eck isCIO	; F Buf+v> Le [t064hi ethe appro mpty_8042_ung

dh s1count
;0DFhl
no_ 20 for ie [t060hi ethe appro mpty_8042_ung

dh s18-V  ify ax,(r 20  c>0 =lIrfoeesidedres	Do ax,(rby;C0	e
bserv	dnidehr opine	cw
, so Ir  Iile_	s_pv	hr opin;C0	ele_	HMA until0-biyi takkh lfnh
r cohor ises	Not+ ax,(;C0	ewby	po'+v	oile_	s_pv		ja cvkec    equided 
;
	,	mecause;C0	ewby	po'+vruct
		m*cx,8ir0*r 20 mask	dniame
		mov aons I;C0	eworkoo sc p axe [tit,or 0-bit
		ce
	i,.)
.kbc_wait end.
scbyte meda=efx
.kbc_wait	ter_:pusterfac20_+vk_bytet
Ba20_dpop_pr_coml si,tkbc_wait	ter_
,eax
 scmp
s%1Ruoadfete [t_kbOne more;getmbuffaMb!aet mpt:Aesidedwtime faKer 20 gaA " a
a20_faKe:e not fet_chacs: 20T:  t, A20_FAST	 -Hlvenms u	eIile_	KBCsy spac W rDX 092hnn4 i0

	02hnn4time.  ~01eck isd_drivac_buf8]:lvde3,sberrt #mane sc!r ie [t092hi eth
.faKe_wait end.
scbyte meda=efx
.faKe_wait	ter_:pusterfac20_+vk_bytet
Ba20_dpop_pr_coml si,tfaKe_wait	ter_
,eax
 scmpp
s%1Oh buggeres	A20 i,boh e3,spop r pi sya=els
bb   rshorg: W;enven>0 =lIrgive upliw  Iix
	on  LF, lob_A6 tf3rac,4X, noget_chaet_chacs: 20Tries]bytet
Btry_esided_a20shneb RSs_fnst_ba20;C0Ipc_ know(o_orea],eA20 	pussked,	procn
;ugh_raa20_dpop_pr_:ax
 scmpa20_dpoprN-	fid	xor al,al
	axaf ame 	;  +vk_sor 0A20 i,besidedr (ZFn= 0)es	caaf ame 	; F;_musv t_chde ,roy rt p---------g

prnesh_raa20_+vk_: lif n bootupl:	cacxpush  h eedra 0csa=e0uuuuh  ThHMA =  VKerne 0uuuuhann thelstcx
C0b RSa=e32d ll wsi,f movbyte [Vh		[cs: 20Tet_cjta20_wait e vkeeedra 0cs[cs: 20Tet_ct
chneio_de theto borp_b shrep mofixdde thname		cmmodes: 20Tet_+	 h]coml siz ta20_waitjta20_dpoprN-	fe hass		; cxFun			sh de r al,di	jnc _a20vk_tes:
	dFll cFlt nert #Baned dedEdecursotry_wbinvdea	8 chabp,dcs: 20T:  t
cloot bp,bpery fi Check thehr opre's spacj'lahr op cs:bp+ 20DLit_cjaa20d_bios:e not fLKS2400ec_queryfcl 	e_m2		;
		cds_muckep ax
IF	;  word5ll wx
 f
,al
		jz funa20d_snoozp ;x
		Di	jnc .time faKer 20 gaA " a
a20d_faKe:e n W rDX 092hnn4time.  ~03h  	e [t092hi eth,al
		jz funa20d_snoozp ;x
		Di	jnc .times0ybol deg

pc_dlere 20 gaA  a
a20d_kbc::acappro mpty_8042_ung

dhs1count
;0D1e> Le [t064hi etk isCIO	; F Buf+v> Lappro mpty_8042_ung

dhs1count
;0DS_ti - 20 fffr ie [t060hi ethe appro mpty_8042_ung

dhne; Lait amp e     it A6 takb eff ds
a20d_snoozp:tupl:	cacxpusb RSa=e di	jnc _wait
.de thfault terfac20_+vk_bytez tdi	jnc dcoml si,tde thfaul
tdi	jnc d:ax
 scmpa20d_dunno:
a20d_noe :e n-	fid	xor al,al
	Rme 	;  +oo mpty.time8042cKBCsBI
pc_dlert
; f	dD != 0ar_timctwre; Cheint 1A20 ina%endif	fe etf;;; Nr 0A20 i,ar_ uduf8eyiesidedre,al mpty_8042_ung

d:> Ly fodl,dll mpty_8042:pusterfac20_+vk_bytez ta20_for i  Iidl,dllytet
Bt	pop
ta20_fo:eio_de the n W rDX 064hchar_2	tr
.	on rr sh di

	1	C0_buffe_me prdwario_de the n W rDX 06 ht
;
Rmov inprdwarl
		jz fun mpty_8042bffe_me prd:rr sh di

	2bytet
B mpty_8042bytio_de the.dpoprNor aa
oize_WBINVDtiut
		;  fo;nd_dsesuto-ejz pnatlms se386 CPU dedtry_wbinvd:rr wbinvdexor al,al
	 writRAMe
		xp_nf srflow, so Isx
		Nerite az
 s svkl	su0ramdw 0a_	-ime
som W , so Irgum' rikl	su0ramdw 0len	-iS shent,t	jbs;	SI		-iesitrd	t	jbwiho1,l; LBA (LSW)
 A Nf DEBUinitrd:Fndnidecurs:ncFnd		jc	ngrt ge"ame
		cas rs/:s4r i_nicsg
ES oadrneryore theLKS a 8086
; or othing
		.tg
		cadal
bis6 oncFnfdefonfibi_pv	sueal"des:su0ramdw 0a_c	;minitrd	jp di
> segmeC0uery_failed:
		moecurt      s:ncne; Luf+vll	mov fs ";C00ursor
		and al:e ncFndwe ,6	:ncFndnid 0
dRDso sine; Luf+vlramdw 0	ull-tet_fs_d ctors we0ursor
		and al:e ncFndwe ,6	:ncFndnid	ot	otze api		Luf+vl	otsFndnidecurs:ncFndr ish as we ,6	 it_int	
Name
b	; f des:su0ramdw 02e,i1_s short pa	rflo_3
		moallrt #
		x

C00ursorcur
		jc	ng
		ca		 1			sh ort ge"ame
		cas rs/:s4r i_ndi
		cmp d ax,0F0ES iflearlve a ,_vk, al,al
	t pa	rflo:	rx	dse(		; f mainderent)ear i	xo_nf srflow, so I.dEdeaxaf ame 	;  pr)
 s_	otse    eane	64Katransforrlmitf
		;C00urssacknow(nedideporpodpc ax,.ic 
Edeaxe xfor_buf or iaf u	eIiaheadb		mimemoNo m.dedEdeT	; i0prda			; Use(EDI) aons I ar_dhr opal gulmitf
		timedfensdEdedhr opas wtenorl Cadmemop ax
z anesor 0k at 0
c	call cI0prds:	SI  = 
		xowiho1,l; LBA (LSW)
 A NEdeEame= tarut I			; Use W rflow, so IsxdeEAX =   shent,rxmainr pc i	xo_ne.'4o  
s%1Oe prds:	SI  = 
		xowiho1,l; LBA (LSW)
 A NEdeEame= morritmovounedda			; Use(t_chinclu    rCadm   )ef DEBUGrflo: lif n boot
che
		jnbxfor_buf or ,[bi_file]		h
. thenter_:pushndo be i_charI 0SI 	; C_timctwrecksg eFh		get	jb	C0_bufeofeC0uery_failed:
		modvpx,SECTORSIZE as we ,6	 it_int	
nnterfacknow(nedid
rd [hme
single-s<A> T"t	kb '4o neoctransforeC00h+2hati(1its
16)s a Maxa64Ka)
axnectransforeC0etintp sh_okbyte [Vlati(1its
16)
.p sh_ok:s Iy forda sp byt[hme
single-s<B> B'4o ntransforrlmsters  hunk(LSW)
techa=ehr op C LBAsk etbyt    1c very fi Check thed LBA (oRACh d		movupm]		;  fact tionyNa-1g to boos CFa cvEDX >= 1	;  fendifh search]
		calS1eovzEini cvCFas sp	; l mode(e)axati8]: Write ante CD:	db: LBA (or "nd_drd [hme
sdi_char<C> Tarut ImoNo mpusb RSa=eax*d
 t			cp:dd 1_sES:0	C0ommand_dfs  I_3
		moallrt #data _nf sxfor_buf or ,[b			shconfig_2<C> Tarut ImoNo mpusx
 sornel
no_<B> B'4o,f mov,ters f[Vf	pusf n bocxl
no_<B> B'4o,f mov,ters f[Vf	 rd [hme
sdi_char<C> Tarut ImoNo mp.fix_slr_:pussh dicl,3	C0_buffeslr_	; l T	; laKerdhr opf = r.oaMb!-rCadop ax
z anes

		m, an-Cadm   orl cs wpc ae    multi- i	xo_nitramfs.Fh			; <DEL> es:ocxe,2o p vkeecbel" section o.fix_slr_
ffeslr_:nt.
;
		inc2	ine ; Check the'hr oso bf n booi_char<D>2ei	xowiho1,l; LBA (LSW)
 A Name
b	;allsxfor_buf or its
4)i		Sourcfi
> segmeC00shorbmalld 1_sCall loarflow, so Is b			sh onfig_2<D>2ei	xowiho1,l; LBA (LSW)
 A Nam			shconfig_2<C> Tarut ImoNo mpusx
 sornel
no_<B> B'4o,f mov,ters f[Vf	pusft the 	gle-s<A> T"t	kb '4o neoctransforeC0 fact imdcbyteClusELKSornlytet
Bt thenter_as a Moob_A6  them]		; 
feof:Fun			sh de r al,
s%1cknow(nedid:rsor tf3rac,4vcknow p ax
<ESC>    <Ctrl-C> a
aknow(nedid:eC00shorp_dlnel 	C0_buac	f a1k_tes:
	e;
ommand_dnel 	C0bf
	CR
27l
no_<ESC>r4jb gac	xil8	C0bf
	CR
3fig_2<Ctrl-C> 	o_outac	f a2
ac	xil8:ed:
		moaknowedx,SEC,
s%1cknow(DEBU: CmmalmsgydvarpousFame 	; I cad thructseuo pr)
 ear at l
dbbbbbbbbbbbbbe alwFFher efw  Iix
appendoart #BIO	; F promptt
;Sfncb pnIp
dbbbbbbbbbbbbbmay-ck wheidt key:
amaet_any	de efwnt, thi		routinat 0,es
		mo
dbbbbbbbbbbbbb's atest  IpcFhereovup,e
endomice:
sberrt #arse_coficient lo
dbbbbbbbbbbbbb  Iile_	sbgn L   cibl	call cccccccccccccSI    = re's s ()
a_+vxt)wnt,e alwFFher efwuo pr)
  a
aknow(DEBU:_display
		cmp axb RSLKSrsrt ge"ame
		cas rs/:s4r_ndi
		cmpCS = DS = E SncFnfdefonfibi_pv	sueis6 oncFnfdefonfibi_pv	sueis6 oncFnfdefonfibi_prls
0olvk_sp,dcs:Sbgn ]l fodi
berrt #abgn l	je pc_append
		c	iFndnidecurs:ncFndr ish as we ,6rname], byte 0	; NulExpectseSme0sie alwFFSEC 80ok:argutack]iIpc_di,trackbuf
	e
		cas rs/:s4r_ndiappendoaBIO	; F prompt;x
			sh		gecknow(nedid
;
ac	f a2rN-	fi
ac	f a1:or al,;x
		f3b*d
   vkll 	Owheid,t	jbs;l 	/:s4rOadrneryvkl		DS:DI	=buf      l 	/:s4rI 0sucat 0fulvkl		ZF ax_vkkl		SI		= 
		xoSW)
 A NEdeDX:inilwFEin	= 
		xolnugax
ine.'4o  
	/:s4rI 0unsucat 0fulkl		ZF s sp;,;x
		f3b*d
   _isvz_seaespecialdrneryoSW)
 e    ISO		mov n8ntt
; ni
> ize, as	doart #cknvn,er b*d
   _isvzps
	 I i 
		xo al,dusske0		eLes	caaf theac,fulkle    r b*d
lowI*[r	sniff ouies.
;
alloc_LF, lob:c_qet:	ret
cvk_ovZF <- 1	; r al,f3b*d
   vkn4r i0

		kpr b*d
   _isv:e not f[ISO to the f;1iTRACERh'S'elBracteallocst _
		x; l Temporaa=eli	xot
		; lob_*[r	sniff ouybytet
Balloc_LF, lob lif n bootupl:	cads,eax
 somneo_boES = DSiled:
		moCurDirr coauv cx,		dj],'/'charI 0uf      tvvvEoolp ax slaKa		o_out.not	ov c dcom vkeconfig_2
s:
sx_vm   oslaKa		od:
		moRv cDirck isRmfor iceaov ct	niff ouytiut
_vm
.not	ov c d:byte [V; f dsi+   _cult_cj ge safbx+
		x_desct 16 onle [V; f dsi+   _lbaej ge safbx+
		x_ddress] 16 onle [V;df dsi+   _le,i1
.lf s_*[r_slaKa:e not fLKSdi
.pmp :r cb RSal	ar		r4j vkecopushndoc; cl_ch_bufist	jb	C0oauvc; '/'		o_out.omp ugAcounari-1]h search]l Ter pnatlidt 	niff ouytnz
dla b RSal	0204 to bob*d
_*[r	sniff ouybyt chgval	aISO to th C0[hme
		pusl:	cacxpush  h hr opt t		mopi		Le
some l"x
appe"
%u
lif n bootfist	jb:L chgvk_a		p
.d_dsome:o1i -mbera  hunkwnt, thisniff ouybytd:
		mo		rep movsbTRACERh'g'k_tes:
	dF10 chgv	cpsio b1_sya=e[BufSafetbyt ekernel
no_
Curmdd 		sh di+vk_r	C0ommand_dfs  I gA-	fid	
.compar :e not techifh sear si		; tinugax
	gedwiff ouytrneryorebf
	CR
33cx,[Kbdnext
i+vk_r	C0TRACERh'c'r cb RSal	asi+25]yte medal	aISO to th C0sh dicl,v cx,	8Eht
;
Unructed	t	jb!aetribush !lytet
Btnot	c	jb	C0es:
	e;
ot teccfh sear si+32]ig_2ei	xobuf8]ifier	lnugax_chi
		subonyNa33	ig_2ei	xobuf8]ifier	re's spacTRACERh'i'elBracteisv_compar ai_pvs,eax
 ar4jb g sucat 0
tnot	c	jb:t_cClusl tisingle-sDec thseb '4o ndesc  There LF, lob lii
		subingle-s bvlncesSW)
 A No.nedid_ eomrun:o1i -Dimo		co si nert #moNo m?orebf
		mo		rep mo+		rep mot vgis1[Kbdcompar 	n],eax, keepN sett
el" section o.d_dsome1i -mber_2		;dush sniff ouyb
dnext
i+vk_r:o1i - bvlncesdoart #vvvEoadfe
	genext i+vk_r	C0ll u f dsi+SECTORSIZE-har e
end f ~(SECTORSIZE-hot_cClusacpsio b section o.not	c	jbne; Lo	s2 Cheon
;
		mdoolnugax
nedidsh
.fa, lob:ly for a singl_ovZF = 1	; e safbx+
		x_ddress] 16 onl			sh de r al, sucat 0:byte [V; f dsi+2]		mo L cro.oadfgeextrnehneb RSfbx+
		x_ddress] 16 onle [V; f dsi+10]		mo Data lnugax_ch[hme
sinc_qoot ELKSSECTORSIZE-h on
;
		_ctSECTORSIZE_LG2j ge safbx+
		x_desct 16 onlet the 	xoe [Vl tisin on
;
		dll wtes
endbcp:dd 1_sZFn= 0bytd:
		mob onl			sh de r al,  t		mo:e; Lo	ut Ignoruor 48iw
somn8nt
do   rCa	pofgea lf su_	; l T	rs f liesr
;
; Chfacv ax,(r sucat 0 f appesdbc 	;  io bechgvl tisingle-sDwiff ouytlnugax
inesp byt[
 scmel
no_OldiISO to tsi,il 'tael
no_Next uf      tSW)
 A Name
b	[ISO to thecll fodi
		cmpuhks po tsi,_buffa, lob	1i -Dimo		coa, ?4rI 0socoa,      f co!o b sec.lf s_*[r_slaKa
no_O
		mof l,enext levx	 ;x
		allocst _
		x:leax	catlideli	xot
		; lobdedEdeI 0sucat 0fulvkl		  ZF s sp;		  BX = 
		xoSW)
 A NEde niunsucat 0fulvkl		  ZF ax_vkkl
allocst _
		x:pacTRACERh'a'tupl:	cacxpusb RSbcpei	xso b1_sya=eMAX_OPENo.nedid:nnt'la'hr op bxe, ],0,t neelre L[Vf	pushortbcpowhe_
		x_t Show 1_sZFn= 0bytl si,tnedid
 d_sZFn= 0uor 48ifeChee [t_kb%endif	f
 L[Vf	:ss		; cxFunr al,
s%1isv_compar ai_pvs: 
EdCompar ite an_pvs DS:Sme
endDS:DIw  Iix
	on  r 0-biyii_fil	equ ae s
%doniISO 9660eporspecoisg.ccSI isite an_pvals
%ar	rt #
		xsynt m; CXe ndicatlse38solnugax,e
end';' ter pnatls.
;	DI isiexpect
;
		mendap ax
a	oter.dedEdax	e:sclobb (orAX, CX,cSI, DI;es
		mosoDS ==oES ==sbasn  VKernelBuisv_compar ai_pvs:r i		F VKe, ter pnatle
endmp onpc a she Wprdauf      lC0[hme
		pusot foun SO f  1z
dl.mp onnter_:	jcxbufmp onnrch forxhbits  ekern for a dok_;'r4jb gfmp onnrch fotime.  Some d gfmp onnrch foc		jb s1t'la'un SO f  1z
d	sh-1le-sGul derg: Ws ImoNo m  eomrunis1[Kbdcp onnter_
fmp onnrch: s1t'la'un SO f  1z
d  There mp onndoe e ap		s cx,		dj-1]h'.'
		pRemo,eaxer pnall	otsF	o_out.mp onndoe e a ekedio b section o.mp onnrch .mp onndoe :ugAcounari]h search]
		stos-ter pnatlet
	ett
i,il 'ta*d
ar
nsun SO f  1z
dl.mompar :e nrxhbits l adjusar		r4j vkecopushndoret
chne_bufsucat 0	imer]	Sc_kbt
	ett     both fotime.  So_charIsword [V	sh de	Sc_kbt
	ett?si,_buffa, lob	1i -Isbll cLF, lob liiime.hX -> Leze LF, lob lit:	ret2020x	ine ; Check theve,lr 
;
	 for a dok -> Leebdcompar 
.fa, lob:lhndoret
cd 1_sZFn= 0 (amov fs,aonre; Chebakkhnz an), sucat 0:nr al,
s%1t
	cpy:sCall DS:Sme->sES:DI ce:	
	hndoinclu    ra	oters cx,,
st
	cpy:ush  h eed.ter_:	nrxhbits c		jb s1time.  Some dt
Btter_com-	fe half	f a:unr al,
s%1
		poona:umoalid	.ps 0uont	t	jb!andoinstactei,aondoart #VGAati8sojbs;		(r 0486 byt_ch seaeVGAasc ten_timctign	cm.)4rIerfolcmmalmsp axkl		SIe
endDX:ini
berblFame 	;  r b*d
   ef DEBUoona:
che
		jnb		rep mo	; l T	; 		rep morfol>= 16K; ehLCpd_lo b1_sya=e[BufSafetC0	e
gea PSF	t	jb!		cmpre
amaet_i,boh	C0ommand_dfs  I_3
		dush di
		8K+4e.'4o  byte [Vh		[		rep mo]s a Magicante CDl w
		cmmo0436a		o_outlf	f ah s1count
; 		rep mo+2]ig_2ei	xoe anlner a dok5	ig_2eont	e ans 0-5me filrc dcomjatlf	f ah s1counihlecx,				rep mo+3] ThHmh	; _o 0uonte ap		s hc2	ine VGAa pnimumis1[Kblf	f ah ap		s hc32	ine VGAa eximumcomjatlf	f ah s1_sCall loauont	moNo mpusb RS	mo		rep mo+4char_2		pofgeuont	dataugAcounaVGAeontsk et bhpusot founvgauont movsb1_sya=e(32*256) >> 2s a Maximumst vgis1			; <Ctrl licounaUsereonte, ],0,t1 to bootuont	t?
		
_cboFursotmush b
		me (_uonte,
s%1e (_uontvkl eaxaf ame 	;  = r.vatlsewx,(eeomtuont	ck whe		; Advaina%enkl	vgauont mo,e
endupdatlsert #cbkey:_sc ten_data.l cccccccMmicebelcmmalmsp axpCS = DS = E S;
e (_uontvkC0sh diaUsereonte, ],0,t1 to Are w		ue   ra	ac,4-lpecifiealuont?si,_bucbkey:_sc ten1i -Isbt_c,domice	oile_	d be 2,teoNoea	8 chabp,vgauont movsb1_sy hcaVGAeontsk et k_ret:	blsbl	 a	caledlmsgydbothpte se0heterfsh ap		saUs   VGAe, ],0,t1 to Are w		inagraphics	e an?F	o_out.+vxtp
.draphics:yte meda=efx
 cb RSal	bx	ine ;X = .'4o /nel = retFunwrivk_a480byt    cll k isCIOputeb:ht c-ow n2
  sc ten:ace
		dDX l> L_chael s1counaVidRow he f;1il,83h			121ng to bootuc,4vnel = retd      un wordin	C0b RSaVidColse, ],0,t79le-s  waysc80 .'4o /ore one cha[TvxtPagee, ],0,t le-s  wayscp efw0Funr a],eaxion
;
		mtacteabkey:_sc teno
.dvxt:vsb1_sya=e256Namy fodcmp 	; b RSh			1din	C0 wordin		call writes		mVGAaRAM k_ret:	blsbl	; b RSh			10304 to bol+vkcp efw0Fun wordin	
_cboFursotmush b
		mabkey:_sc teno
x
		abkey:_sc ten: boot
		m)
 A nallvLrijnc ses
	ociatlmsp axprt #ac ten_t vg.dEdeaxaf _seaesubame 	;  0		
;
		om6 byt      ra  ey:
%duont.
;
abkey:_sc ten:ause atl:ed to necount
;

		c_vid-ow ]a
		.tgdFh		get	jiime.  Somifile argutack]iIt
Bvid-ow _rs
ckause atl:ed to necount
;24rt ge"ame
		cas rs/:s4r_naxivid-ow e0		B		c,es
		mo 25
				call(Remee CD:ivid-ow e==ofow -hotvid-ow _rs
ck:or/O adVidRow he f;use atl:ed to necounth,0fhhsh de	ddag]ica e word0c	
		cas rs/:s4r i rs/:s4r_ndiriteen odtest t-i			; Dcx
		for/O adTvxtPagee,bhhsh de	ddag]ica e_chaehort ge"ame
		cas rs/:s4r i_n_2
		sBIunt-1 (s_pv	asofow )t-i			; Dcx
		for/O adVidColse,ah
unr al,
s%1
		pkeys:umoalid	LILO-styl #	pymap; SIe
endDX:ini
berblFr b*d
   ef DEBUkeys:ingr
		dcmp 4 to bons I ar_256b '4o nex= rly		o_outlEBUkeys	f ah ap		sa=e256Nam_outlEBUkeys	f ah
che
		jnb		rep movsb1_sya=e1	call1b: LBA ( aons I ar_>= 256b '4o RACommand_dfs  I o bd:
		mo		rep movsb1_sy	ieKbdMapvsb1_sya=e256 >> 2is1			; <Ctrl lEBUkeys	f a:nr alAC VD id_dx,SE_
		x:lmoalid	text uf   ; F Buf+ve38sog

prnessdoart #sc ten,l ccccccccccccc m)
 A pr a   rcole
			anst
; olcmmalmsp ax SIe
endDX:inl ccccccccccccc m
berblFame 	;  r b*d
   ef d_dx,SE_
		x: lif n bootupg
		cdll w	imer]DX <- DX:ini(lnugax
	ge
		x)test byte in	; b RSh		xfor_buf or t
;
Usb_*[r	temporaa=e
		cevs;C0dal
bis6 oFncFnfdefonfibi_pv	suecx,		TvxtAetribush],07048-Djmp seagret
sh whf+v> Lv	suecx,		DisplayMask],07048-Display	text  W rDode an RAComman,SE__nitvLr  bd_dx,SE_ hunk:nd		jc	np 4 to ]DX = lnugax
	ge
		x*d
 t			cp:dd 1_s==oxbs_+vxt movsb1_sya=e[BufSafetbytommand_dfs  I gA-	f sp byt[hme
 onfig_2icsg
curr ish: LBA (o be to be id 1_s==oxbs_+vxt movsb1_sya=e[BufSafeB'4o ]
no_Nte CD:	db '4o ndesci0		
hunk(pr)
 x,SE_
		x: lif n bcxpush  h sp byto ndxhbitndnidecurs:ncFndr a dok1Ahge"ame
		cas rs/:s4r i_n		heEOF?> Leeb,SE_dpop_pr_comuery_failed:
	al	aUs   VGAeent vkerll k is01h	=	text e an,e02h	=	draphicsFndnidecurs:ncFndr ish[NextCel Jm:
]_3a d_
wx,( aoaChebakdoe e at_int	
nn-	f sp b		jc	ng
		ca		 1			scxpus_chasp byt_bu,SE_dpopbytl si,pr)
 x,SE_
		xe at_int	
nn section od_dx,SE_ hunk
,SE_dpop_pr_:ause atl:ed to nei
		splecx,	w	imerDrsi,peryall DX, CX
,SE_dpop:e at_int	
nn-	f s de r al,SE_putnel :                                    _naxbe 2,nel = retFndnidecurs:ncFndr a dok0Fhge"ame
		cas rs/:s4r i_n^O	=	cole
			an_*[ax		sFndnidecurs:ncFndeeb,SE_ctrl_oFndnidecurs:ncFndr a dok0Dhge"ame
		cas rs/:s4r i_nIgn	cm <CR>Fndnidecurs:ncFndeeb,SE_ign	cmFndnidecurs:ncFndr a dok0Ahge"ame
		cas rs/:s4r i_n<LF>	=	newl	; Fndnidecurs:ncFndoeb,SE_newl	; Fndnidecurs:ncFndr a dok0Chge"ame
		cas rs/:s4r i_n<FF>	=	ax_vk sc ten:ndnidecurs:ncFndoeb,SE_*[rmfe dcomr a dok19hl
no_<EM>	=	x
appendoarext e anr4jb gKerne,SE_novgacomr a dok18hl
no_<CAN>	=	VGAauf      t*[ax		sF4jb gKerne,SE_vgacomjnbo.not	e an rlcomr a dok10x	ine 10xt Lo17hi take an BI
pc_d  C0jaeoKerne,SE_e an rlc.not	e an rl:

,SE_nobe 2:ORSIZEBuf+v orrp_bcequplayusski		Luf+vlrt srrp_b.	on rr sh di	DisplayMask],cl_ch_bu,SE_ign	cm	n],eaxt sc ten:ndnidecurs:ncFnde
		jnb	TvxtAetrBX];use atl:ed to necounth,09hge"ame
		cas rs/:s4r i_nLuf+vlnel = ret/aetribush;use atl:ed to necouna=e1                        _nOnvlnel = retmn8nthsh de	ddag]ica e word0c	
		cas rs/:s4r i rs/:s4r_nLuf+vlrt sc ten:ndnidecurs:ncFnde
		t
;
CursorCol]hsh de	ddag]ica e wkeeedndnidecurs:ncFndr a dokdVidColse:ndnidecurs:ncFndoau,SE_shortwrapig_2ic ten_wrapaf[Vf	p-i			; Dcx
		for/O adCursorCol] Somo,SE_gotoxy:ncFnde
		jh,dTvxtPageeSncFnfdefonfibi_pv	suex;
CursorDX];use atl:ed to necounth,02hge"ame
		cas rs/:s4r i_nbootcursoraposize, ash de	ddag]ica e word0c
,SE_ign	cm: ,_vk, al,SE_ctrl_o:                                    i_n^O	=	cole
			an_*[ax		sFndnidecurs:ncFndhar_hr op NextCel Jm:
],,SE_
bebg iflearlve a ,_vk, al,SE_newl	; :                                    _naewl	; b:ht c for	Sc_kbore one chanidecurs:ncF	ORSIZEBuf+v orrp_bcstrcequplayussk
,SE_shortwrap:			callic ten_wrapaf[Vf	pr sh di	DisplayMask],cl_ch_bu,SE_ign	cmFncFnfdefonfibi_pv	suecx,		CursorCol] 0:ndnidecurs:ncFnde
		t
;
CursorRow]hsh de	ddag]ica e wkeeedndnidecurs:ncFndr a dokdVidRow ]a
		.tgdFh		get	joau,SE_sc [axp-i			; Dcx
		for/O adCursorRow] Somifile argutack]iIsection o,SE_gotoxy
,SE_sc [ax:ica ey foa=efx                       _nUpper	lnftowiho			rnerSncFnfdefonfibi_pv	suex;
ic tensk et -i			; Dcx
		for/O adCursorRow] dh a	calwetursoraav axe 		ttomFncFnfdefonfibi_pv	sueh;
ic [axAetribush]_display
		cmp axb RSLKS0601h	ame
		cas rs/:s4r i_nbc [ax ce:onrel	; Fndnidecurs:ncFnd word0c
ifile argutack]iIsection o,SE_gotoxy
,SE_*[rmfe d:                                   _nF[rm fe d nel = retFunwrivnidecfrs:ncF	ORSIZEBuf+v orrp_bcstrcequplayussk
r sh di	DisplayMask],cl_ch_bu,SE_ign	cmFncFnfdefonfibi_p meda=efx
-i			; Dcx
		for/O adCursorDX],c		mo Upper	lnftwiho			rnerSncFnfdefonfibi_pv	suex;
ic tensk et -i			; Dcx
		for/O ajh,dTvxtAetribush]_display
		cmp axb RSLKS0600h	ame
		cas rs/:s4r i_nCx_vk sc tenc----if ndnidecurs:ncFnd word0c
ifile argutack]iIsection o,SE_gotoxy
,SE_
bebg:                                    ii_nCole
	backgf[Vf	 nel = retFndnidecurs:ncFndrSIZEunhexnel 	ifile argutack]iIcb,SE_cole
_ba	p-i			; Dcx
		fori,maxl,4
r sh di	DisplayMask],cl_ch_bu.dpots sp-i			; Dcx
		for/O adTvxtAetribush],al t	pots svkndnidecurs:ncFndhar_hr op NextCel Jm:
],,SE_
befg iflearlve a ,_vk, al,SE_
befg:                                    ii_nCole
	4r igf[Vf	 nel = retFndnidecurs:ncFndrSIZEunhexnel 	ifile argutack]iIcb,SE_cole
_ba	pr sh di	DisplayMask],cl_ch_bu.dpots sp-i			; Dcx
		fore
	dTvxtAetribush],al	mo 
bebgm
ber4r igf[Vf	 rt 0 t	pots svknn section o,SE_putnel next
,SE_vga:t_char_hr op NextCel Jm:
],,SE_uf      lC01_sy	ie	VGAei	xBufknn section o,SE_s svgaui	xptrmo,SE_cole
_ba	:FncFnfdefonfibi_pv	suecx,		TvxtAetribush],07048-Djmp seaaetribush;,SE_putnel nextvkndnidecurs:ncFndhar_hr op NextCel Jm:
],,SE_putnel 
unr al,,SE_uf      :			callGeta   rVGAauf      comr a dok0Ahl
no_<LF>	=	eFh		get	jb    comoeb,SE_view_devs;C00 a dok_ '  There,SE_r a]1i -Ign	cm 	; im/BI
pc_d nel 
unW)
		ienVGAei	x		;    t'la'unVGAei	xBufEf	pr jnbo,SE_r augAcounari]hSo_charCp 't e (sc		jb (DS:)r4j vkecop,SE_s svgaui	xptr:ugAcounaVGAei	x		; ,cop,SE_f a:nr al
,SE_novga:elBracter pax_vk	calhne section o,SE__nitvLr  b,SE_view_devs: lif n bootupl:	cads,eax
 somneo_boES <- DSiled:
		moVGAei	xBufknnW)
		ieVGAei	xMBufknn[hme
		pusomman,angl ai_pv
i,il 'ta*d
yte 75 b*d
   enn-	f s de _bu,SE_putnel nextn],eaxt tgnorileracter pequplay
		xe aboFursotmush b

calliubame 	;  the3s
dp_b shevLrijnc si etsxion
;edhne; aft	mol      ra graphics	
		xe,SE__nitvLr :Fndnidecurs:ncFnd		jca -i			; Dcx
		for/O ajh,dTvxtPageeSncFnfdefonfibi_pv	suth,03h	cas rs/:s4r i rs/:s4r_ndiritcursoraposize, ash de	ddag]ica e word0c
-i			; Dcx
		for/O adCursorDX],p b		jc	ng
		ca		 1			aknn section o,SE_putnel next
;
In
dp_b shetest  mane sc b,SE_e an rl:
s1time.  070ugAcounaDisplayMask],eth,al
		jz fun,SE_putnel next
 VD iBuf+v orrp_b:eI 0srrp_b.me prd i,besidedr, Buf+venel = retmn8 srrp_b.	on r;EBuf+v orrp_bcequplayussk: d:o,	mov ign	cm r 0DisplayMask & 04h 	; C VDBuf+v orrp_bcequplayussk:pr sh diecx,		DisplayMask], 04hde _buBuf+v orrp_b.rch Buf+v orrp_b:c_queryfdk_tes:
	dF10/O aex;
irrp_bPon ]tes
endbcp:d> Leebdnoorrp_bpush  h eedra 0csjusaFx		I0prd]
.wait	; im:hne; Lait     r; imeina%ransmioficient l	C0ll uex;
bx+5]		mo DXe->sLSRe n W rDXp bytsh di

	20-> Leze wait	; im
hne; Lait      Wprdau	cw
BI
pc_dr4j vkecmel
no_DXe->sMSRe n W rDXp bytiime.  Sh for a dok -> Leout.wait	; im	bffe_u	cw:		
o bechgvdcp:dd 1_sDXe->sTHRcom-	fe ha; yte 75
		jb p4 to bo
		dataudnoorrp_brN-	fid	xox
 fd
.rch:unr al,
s%1Buf+v orrp_bcstr:1Buf+v orrp_b     r
	ettss%1Buf+v orrp_bcstrcequplayussk: d:o,	mov ign	cm r 0DisplayMask & 04h 	; C VDBuf+v orrp_bcstrcequplayussk:pr sh diecx,		DisplayMask], 04hde _buBuf+v orrp_bcstr.rch DBuf+v orrp_bcstr:d.ter_		rxhbits time.  Some dor.rch foRSIZEBuf+v orrp_bo b section o.ter_
frch:unr al,
s%1Buf+vchr:	Luf+vl us	ngl enel = retm0		eLndoart #BI8sojb p axe [dEde,angl	dnidn p--------ses	caaf 		i,braw#BI8sojb ps we ,dEdesfncb _2		;PXE;
		cds_edra the3s---for p---ul "of 8sojb I/O. VDBuf+vchr_full: foRSIZEBuf+v orrp_b	%1Buf+vlrt srrp_b.	on or 0k 
;edhneueryfdk_tes:
	dF10/O aeh,dTvxtPageeSush  h eedncFnfdefonfibi_pv	suth,03h	cas rs/:s4r i_ndiritcursoraposize, ash de	ddag]ica e word0c
om-	fe ha; y a dok8> Leebdbscomr a dok13> Leebdcrcomr a dok10> Leebdlfc_query_dec-i			; Dcx
		for/O ajh,dTvxtPageeSs1v	subDX0704i		Lef+vln8 ble scall ada=e1	c_nOnvln8nthra 0csjus09hpi		Luf+vl:ht ctime.etribush;un wordin	C0w somxann vkeclcomr a dokdVidColse:C0etintcurxyokbyty fodl,dlldlf:nn vkech for a dhkdVidRow ]aomjat.sc [axptcurxyok:	/O ajh,dTvxtPageeSs1v	suth,02h to bootcursoraposize, aC0 wordin		c,  tt:	N-	fid	xox
 fd
unr al.sc [ax:t_chadhF10/O aeh,dTvxtPageeSusv	suth,02h un wordin	C0b RSLKS0601hcallic [ax ce:onrel	; F10/O aeh,dic [axAetribush]_te meda=efx
 cb RSex;
ic tensk et l T	; whojb sc ten:ac wordin	C0 section o.r al.cr:	ty fodl,dll b section o.murxyokbdbs:_cClusd
	1	C0_vketcurxyokbyte
		dDX[VidColse:C0Clusdh	1	C0_vketcurxyokbyty fodh,dhc_q section o.murxyokb,
s%1debu0-ckckeuo pr)
 earnel = retmp ax  pnim 2,nByteum; ielBudebu0_ume er:0es:
	dF10ueryfdk_t chabp,spore theex;
bp+9*4]1i -mberx
appen
> segmeC0e
		t
;
cs:bx]1i -mberdata  cx,,nn vkehr op bp+9*4]1
pc_appendoa	ft	modata  cx,,nnRSIZEBuf+vchr	xox
 fd
un-	fid	xor al,al
	p_dlnel :		ja cvkftwrecksg an  Wprdanel = retm    	dniaZFn= 0),alp_dlnel :k_tes:
	dF10/O ath,1	c_nP[ax s0ybol d:ac word6a		o_o
Bt	pop	c_nK0ybol de3,spopse
 cb RSex;
irrp_bPon ]tes
enddcmp byte
Bt	pop	c_nNt srrp_b.	on o->sno inprdwarhort fh sear5	mo DXe->sLSRe n W rDXp bytsh di

	1 d_sZFn= 0uor data     	dnbyte
Bt	popr4j vkecmel
o_DXe->sMSRe n 0csjusaFx		Ign	cm]1
pc_,8ir0detestusmp ebx,b W rDXp bytiime.  Sh for a dok -> Ls s;  =l> L_chaelg to bootZFn= 0uor equ ae.dpoprNo-	fid	xor al,al
	d_dnel :ndiritarnel = retm s
%ds0ybol de   r rp_b.	on r;
d_dnel :
.rg: W:10/O ath,1	c_nP[ax s0ybol d:ac word6a		o_o
Btkbd	c_nK0ybol deinprd?F10/O aex;
irrp_bPon ]tes
endbcp:d> Lez tag: W	C0ll uex;
bx+5]		o DXe->sLSRe n W rDXp bytsh di

	1> Lez tag: W	C0 vkecmel
o_DXe->sMSRe n 0csjusaFx		Ign	cm]e n W rDXp bytiime.  Sh for a dok -> Leout.ag: W	.orrp_brNmust not fi; Avoideg

fuse, aC0echgvdcp:dd o Data 	on rr  W rDXp bytr al.kbd:_qet:	ret
cvk -mberk0ybol deinprd:ac word6a		otime.  Some dor.func_k0yF10/O aex;KbdMapine ; Check nel = retms sbx,bxlatb
.func_k0y:nr al,
s%1owhe,d_dn:umoalid	uf   ; nel = retma eartimb_*[r	pLr    orseae,annA NEdesimil "odoart #Cel	braa=ed_dnFame 	; .	O8nt
sh diimultaneou  
		e (si		d filrc des	Not+: "owhe"a%rashlsert #		rep mo.dedEdeowhe:eInprd:	uf      trseDS:DIdEde	Oe prd: ZF s sln8 uf   t_chL[Vf	e   z an lnugax_edEdeowhefd:eInprd:	uf  owiho1,trseSIdEde	Oe prd: noe _edEded_dn:uOe prd: CF s sln8 eFh		get	jb	Ede		Cel = retml   edm0		eL_edowhe:*d
yte 75 b*d
   enndorowhe_x
appe
owhefd:F10ueryfugAcounaFB'4o 1]a
chneb RSaFB'4o 2]Xp bytiddoret C LBAsk etbyt fen fh sear0t_cClusacp],0,t1t_cCbbn fh sear0t_c    hr op C LBAsk etbytb RSaFC LBA]t
cvk -Nte CD:	db: LBA (obytb RSaFNextC LBA]tsine ; LBA (LSW)
 A Name
b	ret EndOfmbeCBmo]s_nP[to staat eFh		gemoNo m ->bytb RSaF		; ,
cvk - t_c
lowIl   edmy spacx
 fck isRm
		cmpno ZF
owhe_x
appe:nr al,d_dn:ts c	c_charI 048 ;;; Ngnoru->sEOF;C0dal
ba=e[FB'4o 	r4jb cxbud_dn_r augAcouns		jF		;    t'las		jEndOfmbeCBmo]is1[Kbd_dn_l   edhne; BoNo m  mpty.--	jp di
no
		m selo b1_sya=e[FC LBA]	C0oauvc=e[BufSafetbytetind_dn_okt vgis1v	suc=e[BufSafetbd_dn_okt vg:cClusaFC LBA]tc		mo Remuc  rxmainr pc: LBA (obytb RSs		jFNextC LBA] lif n booeo_boES may-be != DS, sksg old E S10/O aex;ds,[bi_file]		h10/O aex;d_dnbufknn[hme
bx	C0ommand_dfs  I_3		moalid			rep morfull
	gedataugAcounaFNextC LBA]tsine _2
		skew next SW)
 A Nam			s id 1_sSme->snewlyIl   edmdataugAx
 somneoisRm
		cmpE Sd_dn_l   ed:	rxhbi	_3		moalid	 cx,,nnb RSaF		; , id o Updatl next  searSW)
 A Nam_chadhr op FB'4o 	 o Updatl  '4o ndesciBIuntCDl w
lc	n],eaxt EOF;d_dn_r a:nr al,
s%1und_dn:uP  h e nel = retm(0		eL)	backtes		mrt #d_dnFmoNo mpEdeNot+: or dush di
		sh d searrl Ceryallback,,ters may-cause;Ede '4o neocbepas wtenobe	cw
rt #d_dnFmoNo mdb		mdaryt
;I 0-bi_fil		_seaerw 0	    		i neococmur,
rt #d_dn morbasn 			; Useaons I;Ede ake veovup.dedund_dn:ugAcouns		jF		;    _chafailed:
	 si	e f;1il,83aF		; , i	C0 vkechr op FB'4o 		xor al,al
	skip	; im:	
s:
sx_vm   owhf+vr; imeue   r"d_dn"t
;I 0wrecuffeed-of-l	; F;lit:	eed-of-t	jb,rx
appenp ax cara=e
et_sZFn= trufwnt,EOF;l		ZF = falsb_*[r	EOLN;ao
		mof l CF =tZFn= 0.dedEdeO
		mof l	eLn= morritnel = retmaft	mowhf+vr; im,
stkip	; im:stkip	; imnter_: ommand_dnbytec	skip	; im_eofeC0r a dok1Ahel
o_D	heEOF> Leebskip	; im_eofeC0r a dok0Ah> Leebskip	; im_eoln;C00 a dok_ '  Theretkip	; imnter_Funr a]_charCF =tZFn= 0
skip	; im_eof:or a dok lg to bootZFts c	c_chto bootCF	xor alskip	; im_eoln:ei
		dok0FFhchto bootCF,	ax_vk ZF	xor al,al
	d_dk0yhr o:	mbera k0yhr onhar
		calcurr ish"d_dn"et	jb;mn8nt
rt #	wodEdemorritnel = retI i_f f 8sider0detignificant.
;
EdeL	; I vvvEoadfe
p ax ASCIItnel = retI 33-47 i_f treatlm
EdeasaBIO	rnessandoign	cmd;ao
		mel	; I i_f fja c
;
   
Edeval dity.blFrcann   rhoush b
	imes0ywd_     .dedEdeT	; k0yhr onhndo ubsequ  towhf+vr; imei		dkippdre,alEdeOneEOF,rCF =t1;ao
		mof l,rCF =t0,	eL:AH = le,lr
;
		:ht cpa  ef d_dk0yhr o:
gkw_fich:uyte 75kip	; imenndorgkw_eofhto eFh		get	jb	C0_c gkw_fichhto eFh		gel	; : eryoag: W	C00 a dok_0'is1[Kbdkw_5kipl	; 	mo 
s:
sBIO	rneel	; F10h  h eedraommand_dnbytx
 s:d> Lecrgkw_eofF10/O aeh,al	mo Mo,eanel = retm a  tes		mBL:BHis1 fobet2020x	i		mo,lr-
;
		iaugAcouns		s0ywd_     
gkw_nedid:nrxhbwpushndoret
chne_bugkw_badl	; 	mo Balik0yhr o, Buf+veFher efh ap		sa=e:d> Leh dgkw_nedidF10h  h eeddkw_5kiprvk_: liommand_dnbytec	gkw_eof_pr_com0 a dok_0'is1[a dkw_5kiprvk_ liommanund_dn*d
yte 75kip	; imenndorgkw_eof_pr_cifile argutack]iIcbgkw_mise   pLr/:s4r i_nMise   	pLr   retmaft	mok0yhr o liommanund_dn	1
pc_appennel = retd o	moNo mpus
lc	n],eSucat 0fulrx
appe
gkw_eof_pr_rN-	fe hagkw_eof:	r a]1i -CF =t1h seamanEOF f 8 ize, s
gkw_mise   pLr: -	fe ha:e ncFndwe ,6	:ncFndnidst_bnopLrmtet_fs_d ctors we0ursor
		and al:e ncFndwe ,6	:n secgkw_fich
gkw_badl	; _pr_r -	fe hagkw_badl	; : sectors/:	cbadcfg;C00ursor
		and al,al
		tion odkw_fich
gkw_5kipl	; :mr a dok10callic
		    LF> Leebdkw_fich
liommand_dnbytec	gkw_eofl,al
		tion odkw_5kipl	; l,al
	d_dina:umoalidne3s--gernhar
		cald_dnFt	jb.dEdec_appenCFa cve alw;ao
		mof l x
appen3s--gern0		EBXef d_dina:
che
		di,NteBufkgi_d_dnum: t'la'unNteBufEndi		ma diecx,	0		NteBufkC0jaeogi_l   edhne[hme
		pusommand_dnbytx
 sdio b cogi_l   edhnec		jb s1t'ladok_-'pr jnbogi_d_dnum liommanund_dn	1
pUnd_d noe-numeric
gi_l   ed:Lv	suecx,		ri]h0bytd:
		moNteBufkC0boFursotmush b
		mpLr einte,
s%1pLr eint:	; Check dne3s--gerndoa	ante CD:0		EBXef		mbernel = retI har
	t
	ett rseDS:SIdEdec_appenCFan8 e alwkl		DS:SmeSW)
  neocmorritnel = retmaft	monte CDl;l ccccccccccccc mSyntax I icatpc d: [-]_ch, [-]0+oct, [-]0x+hex, val+K, val+M,alpLr eint:Fndnidecurs:ncFnd		jc	n ha:e ncFndwe ,6	:nf n bocxknn[hme
bps Iy for a singl -Curr ishdiguff(keepNsin 	; al)test byeba singl -Acmumulak_r	C0b RSrc=ee:dd o B;
	 ncFnfdefonfibi_p medbp,bp               _nUs
;
    negaoisg t?
		pi_vvvEo:	rxhbits t'ladok_-'pr jnarSi_not	edd 	*d
 t			p,1 to bootunaa=emdd 		d?
		jel
		tion opi_vvvEo
Si_not	edd 	:	C00 a dok_0'is1[KbSi_e a> LeebSi_octhex	C00 a dok_9'is1[a Si_e a> Ld:
	al	10callB;
	 =t_chim 2	jel
		tion opi_L[Vf	basn
Si_octhex:e nrxhbits 0 a dok_0'is1[KbSi_kmine Valumei		z annn4 i0

	20x	i		Down
;
	 for a dok'x'> LeebSi_ishex	C00 a dok_7'is1[a Si_e a> Ld:
	al	8callB;
	 =toct 2	jel
		tion opi_L[Vf	basn
Si_ishex:eC0e
		t
;_0'	c_nNt numeric valu  = crufdmy spacd:
	al	16callB;
	 =thex	pi_L[Vf	basn:Fndnidecurs:ncFndrSIZEunhexnel 	ifile argutack]iIcbSi_km                _naxera (hex)hdigufdndnidecurs:ncFndr a dokcl_ch_aebSi_kmine Inval dC    b;
	 foimulyeba sc		mo Multip supcmumulaklmsgydb;
	 ncFnfdefonfibi_poot Eba sin             _ncalScurr ishdigufe nrxhbits l
		tion opi_L[Vf	basn
Si_km:   _chafa	 apop cx ce:	
	laKernoe-numeric
 nrxhbits  i0

	20x	C00 a dok_k'> LeebSi_isk	C00 a dok_m'> LeebSi_ism   _chafa	 apop cx ce	pi_Lini:lhndobp,bpenndorpi_r a]1 -CF=0!o bneg e:dd 1_sValumewasanegaoisg	pi_dpoprN
lc
pi_r a:ss		; bp
		jc	ng
		ca		 1			shc b		jc	ng
		ca		 1			she 	xor alSi_e a:s c	cts l
		tion opi_r alSi_isk:upg
		cbx	10callx 2^10ts l
		tion opi_	poprSi_ism:upg
		cbx	20callx 2^20ts l
		tion opi_	popr,
s%1unhexnel :    ; Check dthexa_chim 2hdiguff0		eLndoart #_,8ival ishnte CD;l ccccccccccccc mr_appenCF=1or 0kok dthexhdigufeedunhexnel :dndnidecurs:ncFndr a dok_0'is1[Kbuxc_r a]1 -I 0ua, lob,rCF ==t1hal theydndnidecurs:ncFndr a dok_9'i
		.tgdFh		get	joauuxc_1t_cClusa
;_0'	c_nCF <- 0Funr a
uxc_1: Dcx
		fore
	

	20x	i		upper	
;
		->eve,lr 
;
	 for a dok'a't
		.tgdFh		get	joKbuxc_r a]1 -I 0ua, lob,rCF ==t1hal theydndnidecurs:ncFndr a dok_f'i
		.tgdFh		get	joauuxc_e a>-i			; Dcx
		forilusa
;_a'-10         ii_nCF <- 0Fiflearlve a ,_vk, aluxc_e a:ppend
		c	c
uxc_r a:nr al,
s%l
	d_dl	; :mmbera  IO	; F l	; , f 8heck   rco
pc_d nel = retI rt s; imsl ccccccccccccc miho			llape   	t
	echo neocpop;eaesp imei		k whed
;
		m%enklccccccccccccc meFh		gert #ab	ett,1unl Use%endi	;  0s  mpty.dEdeT	; i	;  0s ter pnatlmsgyd^J, ^ZilwFEOF andoispas wtendEdeovzES:DI.4rOadr_appe, DIeSW)
  neocmorritnel maft	moab	ett.dEdeCFa s s sli 0wrecuffEOF.ef d_dl	; :*d
yte 75kip	; imencFnfdefonfibi_pv	suele1                ; Empty.i	;  0siempty.ab	ett.d
		.tgdFh		get	joorgl_eof               ; eoflifile argutack]iIcbgl_eoln              ; eoln;C00mmanund_dn*gl_t	jlter_:	uery_decne[hme
		pusommand_dnbytx
 sdio bw somxannIcbgl_r a]1 -CF s s!;C00 a dok_ '  Thtindl_ctrlNamy fodcmp 	gbcst	cm:ec		jb s1l
		tion odl_t	jlter_
dl_ctrl:mr a dok10> Leebgl_r a]1 -CF ax_vk!;C00 a dok26> Leebgl_eofl,a  Iidl,dllytet
Bdl_t	jlter_1i -Ign	cm multip e s; imslC0e
		t
;_ '	c_nCtrl 0si	; imenn vkecm s1l
		tion odl_st	cm
gl_eoln:onfibi_prlccas rs/:s4r i rs/:s4r_nEFh		gel	;  i,boh eeFh		get	jb	ifile argutack]iIsection ogl_r a
gl_eof: ppend
		c	c
gl_r a:_queryfcl ; Lo	ruct
		; laKernel me az
 s; im!l,a  Iidl,dllytet
Bdl_xr augAcoundok_ '  Tc		jb dl_xr a:wx
 f
,ar al,al
	,angl ai_pv: Mangl id	uf      tSW)
 Aite azl DS:Smees		maFmoNo mdSW)
 Ai 
	/:s4r te azl ES:DIo eFhsln8 eFBIuntCD	dnidn pwhf+vr; im.s;l 	/:s4rs	caaf v  ifilserta earuf      trs < FILENAME_MAX nel = retI,l 	/:s4rs			i, 't ti8]: Wpwhf+vr; im,	z an-Cadse%endme prd moNo m,l 	/:s4rs	  Iix
e ve ntrail	dni	otse  Iix
d	mdact
slaKaeI,l 	/:s4rs	s l"x
pedr asb"dmp e	oia  IOpar itf
		timl 	/:s4rs	path-r b*d
lowIame 	;  d_dsesmp e 
gea8 easier	job.l 	/:s4rs	
,angl ai_pv:knn[hme
bx	C0et:	ret
cis1v	suc=eFILENAME_MAX-1S10/O aex;d	p
.mnnter_:pusrxhbits 0 a dok_ '	c1 -I 0co
pc_d    r; im, ef	pr jna .mnnrch foR a dok -neoisRmpeatlm
slaKa?> Leeb.mnn5kip	C0et:	rh Sh for a dok'/'		o_out.mnnokbyte
		rh Sl
.mnnok Tc		jb .mnn5kip:tl si,tmnnter_
fmnnrch: s1t'laex;d	gle-s tart #vvvEoadfe
	gert #moNo m?orehere mnnz annn4p		s cx,		dj-1]h'.'
		pTer pnall	ot?> Leeb.mnnxil8	C0bf
	 cx,		dj-1]h'/'
		pTer pnallslaKa?> Lenre mnnz ann.mnnxil8:t_chadonfig_2Isbll cx
e ve	iaugA vkerbel" section o.mnnrch  mnnz an:ugA vkerb	gle-s tav fs,aonreoters cx,,_qet:	ret
cvk_ovZ an-f Cheo_pv
i,			;c		jb s1x
 s:d> Lr a]_charDpopr,
s%1un,angl ai_pv: Dolsert #opposizfwnt,,angl ai_pv; f 8hecksesmDOS-,angl dklccccccccccccc mruf      tdoart #BI8ven>.oaMb!			:
sb8]:>.oaes	caaf thek 
;edhlccccccccccccc mru   		e BOOT_IMAGE=	pLr   retmu   		e kernel.hlccccccccccccc mrNOTE: A 13- cx,	moNo mdrs mamda ouy,envenor 0-bitt
	ett rsl ccccccccccccc m knownme az
 sion  m.dedEccccccccccccc m DS:Sme->s Wprda,angl d uf   tamnklccccccccccccc msES:DI ->sme prd moNo mdedEccccccccccccc m Oadr_appe, DIeSW)
  neocrt #
	r diecx,	aft	mo%endme prd tamn,l ccccccccccccc m cad th s s sldoa	anters cx,.dedun,angl ai_pv:
yte 75
	cpye a ekedi]_charP[to neocmoaMb!oters cx,,_qr al,al
	d_dfs  I:-mbermultip e : LBA (or s
%do t	jb,rgivenlrt #
		xrSW)
 A .dedEccOadrneryvkl	ES:BX	->sBoNo mpEdSI	->sF		xoSW)
 A NEdCX	->s; LBA (LBIunt; 0uuuuh =tmovil eFh		get	jb	EccOadrxisvkl	SI	->sF		xoSW)
 A  (   0ln8 EOF)NEdCF =t1	->sHuffEOFef d_dfs  I:pacTRACERh'F'
tupl:	cads,eax n bctsi,il 'tmneo_boDS <- CS
	C0oauvc=e[si+
		x_desctpr jna .ok_t vgis1v	suc=e[si+
		x_desctp.ok_t vg:ea	8 chabp,cxknn[hme
cxcomuery_failed:
	; f dsi+
		x_ddress]pacTRACERh'l'pusommand_dl	d  I gAy forcKSornlytt_int	
nn-	f rnlbytiddodsi+
		x_ddress]mdcbyteClus[si+
		x_desctSornlyteao.not	eofhti -CF =t0
 gAy forcKSornlytd:
	 si+
		x_ddress]mdcb a Mark	asounu	eIo be to be its c	c

.not	eof:si,il 'tmpacTRACERh'f',_qr al,	Ec----------------------------------------------------------------------------------	EccVGAasplaKa sc tencnByt	Ec----------------------------------------------------------------------------------	dedEcr pequplay
		xvkl	Display	a graphicalls                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               