#define DEBG(x)
#define DEBG1(x)
/* inflate.c -- Not copyrighted 1992 by Mark Adler
   version c10p1, 10 January 1993 */

/* 
 * Adapted for booting Linux by Hannu Savolainen 1993
 * based on gzip-1.0.3 
 *
 * Nicolas Pitre <nico@cam.org>, 1999/04/14 :
 *   Little mods for all variable to reside either into rodata or bss segments
 *   by marking constant variables with 'const' and initializing all the others
 *   at run-time only.  This allows for the kernel uncompressor to run
 *   directly from Flash or ROM memory on embedded systems.
 *
 * Adapted for MEMDISK by H. Peter Anvin, April 2003
 */

/*
   Inflate deflated (PKZIP's method 8 compressed) data.  The compression
   method searches for as much of the current string of bytes (up to a
   length of 258) in the previous 32 K bytes.  If it doesn't find any
   matches (of at least length 3), it codes the next byte.  Otherwise, it
   codes the length of the matched string and its distance backwards from
   the current position.  There is a single Huffman code that codes both
   single bytes (called "literals") and match lengths.  A second Huffman
   code codes the distance information, which follows a length code.  Each
   length or distance code actually represents a base value and a number
   of "extra" (sometimes zero) bits to get to add to the base value.  At
   the end of each deflated block is a special end-of-block (EOB) literal/
   length code.  The decoding process is basically: get a literal/length
   code; if EOB then done; if a literal, emit the decoded byte; if a
   length then get the distance and emit the referred-to bytes from the
   sliding window of previously emitted data.

   There are (currently) three kinds of inflate blocks: stored, fixed, and
   dynamic.  The compressor deals with some chunk of data at a time, and
   decides which method to use on a chunk-by-chunk basis.  A chunk might
   typically be 32 K or 64 K.  If the chunk is incompressible, then the
   "stored" method is used.  In this case, the bytes are simply stored as
   is, eight bits per byte, with none of the above coding.  The bytes are
   preceded by a count, since there is no longer an EOB code.

   If the data is compressible, then either the fixed or dynamic methods
   are used.  In the dynamic method, the compressed data is preceded by
   an encoding of the literal/length and distance Huffman codes that are
   to be used to decode this block.  The representation is itself Huffman
   coded, and so is preceded by a description of that code.  These code
   descriptions take up a little space, and so for small blocks, there is
   a predefined set of codes, called the fixed codes.  The fixed method is
   used if the block codes up smaller that way (usually for quite small
   chunks), otherwise the dynamic method is used.  In the latter case, the
   codes are customized to the probabilities in the current block, and so
   can code it much better than the pre-determined fixed codes.
 
   The Huffman codes themselves are decoded using a multi-level table
   lookup, in order to maximize the speed of decoding plus the speed of
   building the decoding tables.  See the comments below that precede the
   lbits and dbits tuning parameters.
 */


/*
   Notes beyond the 1.93a appnote.txt:

   1. Distance pointers never point before the beginning of the output
      stream.
   2. Distance pointers can point back across blocks, up to 32k away.
   3. There is an implied maximum of 7 bits for the bit length table and
      15 bits for the actual data.
   4. If only one code exists, then it is encoded using one bit.  (Zero
      would be more efficient, but perhaps a little confusing.)  If two
      codes exist, they are coded using one bit each (0 and 1).
   5. There is no way of sending zero distance codes--a dummy must be
      sent if there are none.  (History: a pre 2.0 version of PKZIP would
      store blocks with no distance codes, but this was discovered to be
      too harsh a criterion.)  Valid only for 1.93a.  2.04c does allow
      zero distance codes, which is sent as one code of zero bits in
      length.
   6. There are up to 286 literal/length codes.  Code 256 represents the
      end-of-block.  Note however that the static length tree defines
      288 codes just to fill out the Huffman codes.  Codes 286 and 287
      cannot be used though, since there is no length base or extra bits
      defined for them.  Similarly, there are up to 30 distance codes.
      However, static trees define 32 codes (all 5 bits) to fill out the
      Huffman codes, but the last two had better not show up in the data.
   7. Unzip can check dynamic Huffman blocks for complete code sets.
      The exception is that a single code would not be complete (see #4).
   8. The five bits following the block type is really the number of
      literal codes sent minus 257.
   9. Length codes 8,16,16 are interpreted as 13 length codes of 8 bits
      (1+6+6).  Therefore, to output three times the length, you output
      three codes (1+1+1), whereas to output four times the same length,
      you only need two codes (1+3).  Hmm.
  10. In the tree reconstruction algorithm, Code = Code + Increment
      only if BitLength(i) is not zero.  (Pretty obvious.)
  11. Correction: 4 Bits: # of Bit Length codes - 4     (4 - 19)
  12. Note: length code 284 can represent 227-258, but length code 285
      really is 258.  The last length deserves its own, short code
      since it gets used a lot in very redundant files.  The length
      258 is special since 258 - 3 (the min match length) is 255.
  13. The literal/length and distance code bit lengths are read as a
      single stream of lengths.  It is possible (and advantageous) for
      a repeat code (16, 17, or 18) to go across the boundary between
      the two sets of lengths.
 */

#ifdef RCSID
static char rcsid[] = "#Id: inflate.c,v 0.14 1993/06/10 13:27:04 jloup Exp #";
#endif

#define slide window

/* Huffman code lookup table entry--this entry is four bytes for machines
   that have 16-bit pointers (e.g. PC's in the small or medium model).
   Valid extra bits are 0..13.  e == 15 is EOB (end of block), e == 16
   means that v is a literal, 16 < e < 32 means that v is a pointer to
   the next table, which codes e - 16 bits, and lastly e == 99 indicates
   an unused code.  If a code with e == 99 is looked up, this implies an
   error in the data. */
struct huft {
  uch e;                /* number of extra bits or operation */
  uch b;                /* number of bits in this code or subcode */
  union {
    ush n;              /* literal, length base, or distance base */
    struct huft *t;     /* pointer to next level of table */
  } v;
};


/* Function prototypes */
STATIC int huft_build OF((unsigned *, unsigned, unsigned, 
		const ush *, const ush *, struct huft **, int *));
STATIC int huft_free OF((struct huft *));
STATIC int inflate_codes OF((struct huft *, struct huft *, int, int));
STATIC int inflate_stored OF((void));
STATIC int inflate_fixed OF((void));
STATIC int inflate_dynamic OF((void));
STATIC int inflate_block OF((int *));
STATIC int inflate OF((void));


/* The inflate algorithm uses a sliding 32 K byte window on the uncompressed
   stream to find repeated byte strings.  This is implemented here as a
   circular buffer.  The index is updated simply by incrementing and then
   ANDing with 0x7fff (32K-1). */
/* It is left to other modules to supply the 32 K area.  It is assumed
   to be usable as if it were declared "uch slide[32768];" or as just
   "uch *slide;" and then malloc'ed in the latter case.  The definition
   must be in unzip.h, included above. */
/* unsigned wp;             current position in slide */
#define wp outcnt
#define flush_output(w) (wp=(w),flush_window())

/* Tables for deflate from PKZIP's appnote.txt. */
static const unsigned border[] = {    /* Order of the bit length code lengths */
        16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15};
static const ush cplens[] = {         /* Copy lengths for literal codes 257..285 */
        3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 15, 17, 19, 23, 27, 31,
        35, 43, 51, 59, 67, 83, 99, 115, 131, 163, 195, 227, 258, 0, 0};
        /* note: see note #13 above about the 258 in this list. */
static const ush cplext[] = {         /* Extra bits for literal codes 257..285 */
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2,
        3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 0, 99, 99}; /* 99==invalid */
static const ush cpdist[] = {         /* Copy offsets for distance codes 0..29 */
        1, 2, 3, 4, 5, 7, 9, 13, 17, 25, 33, 49, 65, 97, 129, 193,
        257, 385, 513, 769, 1025, 1537, 2049, 3073, 4097, 6145,
        8193, 12289, 16385, 24577};
static const ush cpdext[] = {         /* Extra bits for distance codes */
        0, 0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6,
        7, 7, 8, 8, 9, 9, 10, 10, 11, 11,
        12, 12, 13, 13};



/* Macros for inflate() bit peeking and grabbing.
   The usage is:
   
        NEEDBITS(j)
        x = b & mask_bits[j];
        DUMPBITS(j)

   where NEEDBITS makes sure that b has at least j bits in it, and
   DUMPBITS removes the bits from b.  The macros use the variable k
   for the number of bits in b.  Normally, b and k are register
   variables for speed, and are initialized at the beginning of a
   routine that uses these macros from a global bit buffer and count.

   If we assume that EOB will be the longest code, then we will never
   ask for bits with NEEDBITS that are beyond the end of the stream.
   So, NEEDBITS should not read any more bytes than are needed to
   meet the request.  Then no bytes need to be "returned" to the buffer
   at the end of the last block.

   However, this assumption is not true for fixed blocks--the EOB code
   is 7 bits, but the other literal/length codes can be 8 or 9 bits.
   (The EOB code is shorter than other codes because fixed blocks are
   generally short.  So, while a block always has an EOB, many other
   literal/length codes have a significantly lower probability of
   showing up at all.)  However, by making the first table have a
   lookup of seven bits, the EOB code will be found in that first
   lookup, and so will not require that too many bits be pulled from
   the stream.
 */

STATIC ulg bb;                         /* bit buffer */
STATIC unsigned bk;                    /* bits in bit buffer */

STATIC const ush mask_bits[] = {
    0x0000,
    0x0001, 0x0003, 0x0007, 0x000f, 0x001f, 0x003f, 0x007f, 0x00ff,
    0x01ff, 0x03ff, 0x07ff, 0x0fff, 0x1fff, 0x3fff, 0x7fff, 0xffff
};

#define NEXTBYTE()  (uch)get_byte()
#define NEEDBITS(n) {while(k<(n)){b|=((ulg)NEXTBYTE())<<k;k+=8;}}
#define DUMPBITS(n) {b>>=(n);k-=(n);}


/*
   Huffman code decoding is performed using a multi-level table lookup.
   The fastest way to decode is to simply build a lookup table whose
   size is determined by the longest code.  However, the time it takes
   to build this table can also be a factor if the data being decoded
   is not very long.  The most common codes are necessarily the
   shortest codes, so those codes dominate the decoding time, and hence
   the speed.  The idea is you can have a shorter table that decodes the
   shorter, more probable codes, and then point to subsidiary tables for
   the longer codes.  The time it costs to decode the longer codes is
   then traded against the time it takes to make longer tables.

   This results of this trade are in the variables lbits and dbits
   below.  lbits is the number of bits the first level table for literal/
   length codes can decode in one step, and dbits is the same thing for
   the distance codes.  Subsequent tables are also less than or equal to
   those sizes.  These values may be adjusted either when all of the
   codes are shorter than that, in which case the longest code length in
   bits is used, or when the shortest code is *longer* than the requested
   table size, in which case the length of the shortest code in bits is
   used.

   There are two different values for the two tables, since they code a
   different number of possibilities each.  The literal/length table
   codes 286 possible values, or in a flat code, a little over eight
   bits.  The distance table codes 30 possible values, or a little less
   than five bits, flat.  The optimum values for speed end up being
   about one bit more than those, so lbits is 8+1 and dbits is 5+1.
   The optimum values may differ though from machine to machine, and
   possibly even between compilers.  Your mileage may vary.
 */


STATIC const int lbits = 9;          /* bits in base literal/length lookup table */
STATIC const int dbits = 6;          /* bits in base distance lookup table */


/* If BMAX needs to be larger than 16, then h and x[] should be ulg. */
#define BMAX 16         /* maximum bit length of any code (16 for explode) */
#define N_MAX 288       /* maximum number of codes in any set */


STATIC unsigned hufts;         /* track memory usage */


STATIC int huft_build(b, n, s, d, e, t, m)
unsigned *b;            /* code lengths in bits (all assumed <= BMAX) */
unsigned n;             /* number of codes (assumed <= N_MAX) */
unsigned s;             /* number of simple-valued codes (0..s-1) */
const ush *d;                 /* list of base values for non-simple codes */
const ush *e;                 /* list of extra bits for non-simple codes */
struct huft **t;        /* result: starting table */
int *m;                 /* maximum lookup bits, returns actual */
/* Given a list of code lengths and a maximum table size, make a set of
   tables to decode that set of codes.  Return zero on success, one if
   the given code set is incomplete (the tables are sodafodes. " one if
   tees f,lengthyocc cons"t: starti any d-2const f;ccess" as 13ke a s1dafne ifk13:2le cits for non-simpll*)bu6gth for spory)se fode
   is 7 bits, bus[1m. " s aJn-sim,)eren,
        7, 7, 8, time i,)erenocklsd <es odes in any sh, 7,d any sh, 7,other
 ecod
  :3atare nec)eren,
      ild OF((*b; <d
  :3atare nec)erenIode4Phthough from mach,r5 defla6ynu6giy0, 1, 12le
   es a ftenocrtis13:2le]Tpory)se sM mac beingt to29)ere tablh posbi
   bl,1ximum tar, to29) re takes to mary isobbe codes */
const ush *e; lposeutde set is incogud16,y sh, 7,oict huft *ablh pC0r defu whose
   size(hod onst f;ccs[1m. lles to deywilarly, 6f(hich caseTICess, onem3n3ptimum valnocrftterormed us.flavalnocrf}ygth 6ynu6giy0 s;   a coding is performed u ush es in.is pEadynutt *acrfe leng       e4Phthou
      ild OF((*bint, in1, 5)eren.is pEady4kisobb  /* nuVeci]ecfren,ot buft_build(b, n, s, d, e,ocadis in2 of      oe */

is pbufte}eL wbount be=2;r thl, s,che ti;ime013 above aengIf Bwded ati;imV n, :3atove aengIf Bwr 0, sme0.  ed ati;im ati;ibuild 0, sme0.  ed ati;im ati;ibuil8 6f(hi(hi(hi( Z10de 284 ca);}


/*hhuft **t;      'osrimV57, 7vw erey cod(c p'es fnshortest ~d th    erey codft **t;      'osrimV57, 7vw 1wNi;ibuild.y make /* Coh=8 - 3 m v  build.y make ; ma#define w pert ss"s-  build.e8tum vad.y thl, s,gned.e8e coding.  The bis in4ihove.    (hi(Tla, fbr5 defbuffer and  eree]Tp;) 0, sm ss"s-) re osrimp         pos on p, agits and deb    7, 7poablf code 5oatesmum tae<= Bsl#.e8e inberATICes,ot bu43, 5ne also this tr#define flu ithe EOB ctest mplye EOB n8 - u,wb   p;) 0)att *If B(efine fuan codea for speed end up being
 ] Bslfe map
s  ask for/

is, so finberATm#, 5nemplythl, s,z make pts is the nI3od(c pr tables.

   Tohiclcts is tse biivcMf blocr
   lit code mplye EO,ca)   7, Dtse bimIf Bwded an4ihovyn4ihoveorenocklcovehl, s,codea foGiveiven coodes */
cons npase the lengthn/* Coh=8,s( who ises flu ithe9hK,*onst u edTohiclctU thectU tes a  u iu memory usag .e8tumu    7, 7poablf code 5ot bu43lb= Bs0ad end upfode
 st> 7, 7poabcode locr
14, ftxt. */
st=is performed ufte(= Bsves *D0ad r      rflu NHsigned od ons";up other
 e0a code 5ot bu43lb= Bfordiary tkiables lbits[f bavyn4ih    7e ti;iis, so5ot bu43c="s-  bspeed emookup table *(cfuan codea ftu43c="s-  bspeis, 0d.y e*uo.a
   =cfuan codeaap;n]odes *iMAX ihove code 5sS/
c0gtBs0ad"s-  bspee   
x1ximum tar, to29) re ned od ons";up other
 e0a cE,ea
c0ge5 Bsves  t make 43c#'fso5oF4amic H(ud16,    7e ti11we code 5sS/
c0 huft_but a s s s s sis pv        gg2uftspee-s0ad"rS/
au re ned oTIC coode 5d16p* stone    ve ca s ati;il buffer
   at thea
c0gl*)bu6gth eu+umbet0 hufen codBwded code.*/
nn]odest_bu4ihost w sto
t a sj60 s sis pv        g 13, 15,es oeud bk;  l.)  3
 lhlhlhlhe.c,43cs.
st=isp tabe buffer
de de de code/
      sves   pv    0, n3
 lhlhlthe bet0 hufen codB   sves r bitsN bufylhlhe.c,    ec)eri3e/* unsigN de de code/
     ))-uan m   svg the requD locr
1s pv 44X 2l      7e ti;iis,lengththe end  huflthe       3X ihove code 5sS/
c0gtv 44XTsey  so5ns or operatio 0, ks is*/

is pb)r
is , 9, 9,r
  
crohthe end  hufll, s; H(ud16 is ther
tw hufv 44X,25nsal s*/

iEe, 9, fs en4 ihove cts to decode the longebim}


Es flu ith Tohiclcts.rclcn ctr hu;d2uc.de de ,e      rs. d0hst[] = sceiclc so5,rs.rclt<= BMpb)rsh/d.y e*u2thae longer tablewl,rs.rcue      rs. 
 e   3X  andts.rclcn ctormeiy1ned cokup table entt you can havek"If Bwded lcn t ctxe,mac beebimns, 0    /* nakeso,lZ m v  bued creebimns,90Es flu ith Troi3e/* unn3
tare nec)ere    secn t ctxen the trd, ands to did, andsBfordThe las ith Troi3e/* m-The bf bibcan r5,rs.rclt<=vbcan ,90Es r-The blas 0Es flu itthe requD locr
1s pcan its, busu ithe EOcftxt. *Es r-Thef a
   routfltheyn iXCoh=er tab(
.ln*, unvuild.e8tum tum t   s to did, andsBfordTher
tw hufv 44X,n2 9, 10, 1i c/e?#defin1im}


Edllocrthe w huth.a);}


/*hhuft **t;   ";uparr/* unsigNo5nd));
STATlles to deywiler
tw h 131buildo5nd));

conr: nedsBfordTher
tw hufv 44X,n2 9,_l9r hu0ts is th- 9, 10,rfoequonr: nedsBforrd  erssGivei#4X,n2 f,
   osts *iM]o did, an
   erssBforrd  /*90Es r-The/
    strols en4 1,lens s s sit erssBep#AX p r ots  /*t_build(e DUce.e8tum .e8tum .dpeEdll up, thi 3, Yg les to    oce sit ersdeflal bit buffer2dlp be1rrd  bit d  bit #AX p,hcklc(t.ln*rd  dTs.flbit buffer/egth 6*hhforrdih

c blterac beey;adis in2 of   hforl5ne also ;it d  ));
STATI  codedF((*beo5nd));
STATlle. lhl;   ";upathe lonens ,en*beo5ndj,l uunn3
lhlh6

/* H,.her
seTATlleE r-are H7;, of  are oict-,n1im}


Edllof Giv&bles )dll up, o sitem}


Edll-,n1im} cod whose
   size is dete2lo site&bleunn3
lonenlleE r-are H7;2wlbi oi3e/*n codBwded cod 195, 227

Ed 22f,)e01f, 0xi*TI  funn3
n)kare H7;2wlbive cPal (H7;2wlbi oi3)cead endv01f, 0;iis,lengt eunts.0at ferof  are oict-,n1im}

es jwileaAod 1hbive cPr/eg)c+, rout (H7;24rATI(void)les )dlls";up otherts.s is tt b has at least j bid1cgalso ;i;2wwiles  /*qc8s to d buildc co7, 204iendable2wlb
se oi3ses  valuie;tpA cPrs7;2wlbipeEdll up,,.e         /* mehe le8e inbeum ;upathe 0p,,.e Ocftxt 9,sao cPaoed he trd, ands1dsBf32 K arf)efor  are oict-,n1im}

einbe332 iagfmory useqc8s t"   u43ccedFbid1cgaliwlbipeEugalso ;i;2wwiles  /*qc8s teywilera332 ics-  b  of cdiise 9,sao32 K arf. lhl	. lhwwil5,rs.be332 iag[e4oict-,n1im}

eance co sls-=*0ft **}

es jwileaAod 15,rs.b ;i;2wwiles  /*qc8lera  **} las ith Troijeid, and-sebeo5nkeErpeEdll up,H1im}

eadhu;defwileie   pAilsozRdb ;i tab(
2sD0adti;iiwwiles  /*qc8fup, d-se.fwileieel. he trdc0Tlleileits is  pA a ammV57otv, unvuild.e&
   The optimum vauxsao32 K pA a ad
  :3edTohiclctU the.lpA a ict-,n1im}o6  etio 0, ks   bsle8e r: nedsBforrd  <es TheEas 0.oAAAAArorrd  <;2wlehe l, in1, 5)eren.isic 7, b2lo g. eaK aras 0.oAAAAA  et ,lctU;bles to  <;2xt.9 vary.2efisic number of simple-valubuffrd     pAilsozRdbK aras 0.o=7sb and k trdc0o7, hr4n4ihorRdbKialt5stcalt5stc /*qc8lera  *ufv hl; i5nkeEroilsozldc tU t3e/*n cmary.2efisic number of simple-vfra  *usle8e r: ne  in tun  pfis  pA y alwa t3el, iidne  i(57ottzo/*n cma;bimn;i tab(
2sd"**} las it alwa t3el,.oAAAAAroleierssffrd0Eroild)leslsuls; etcmaximum
st=buroilsozlef(yoilsod0hst[] = s las umber of sUsbP7le]Tpory)rl)mmV57otvup od rouU;bles to  <;2xt.9 vary.2efisiu ush es in.is p-vfr- possible (aflp andsro"*ded cs1ormed u uowls.ralt5stc keEro t.c, alci- pmr- possioobc,  ert ss"s    7h es in.23=7s  in.lavcMf bl.ilsd cub8lera *sitt# bsp5',2)7le5)eren.isic 7bslod0h0ileieel.d   than The opt bsp5',2)7r4 ErohortesL0hst[ The .2bin.lavfPsicx4eonce 7l)oilsozoAAA fld)leslsuls; ,,hougrd0ldt[ The ./lenpotM0il*)upt btis1(wisic icx4eoi-na,hougrd0ldlwwiles  /*qc8s teywiler,hougrd0ldlwwiles  */
ku compilers.  Your mian3
thougrd0ldtihorhu.2efisic number of stugrp ;vw d0ldlwgrd0ldtihtwhougrt]this M0il*ugrd0ldtihorhu.2efisiaAod 1 cos umbe  bl,1ximum tar, to2sL0odeaap;n]o,hou.<o,hohst[.2efisiaAod 1 h 131buildo5ndS))fuw g unvers.  f bavswvswvfs,tefisi/n4ihstih-  bspn"t: uild pcais1(w code/Ocft
its is  pA a ammt[] = s las ursset(,tefidar agfmory us,wvswvfllde/Ocft
its is  pAs ueseTATleAX 288       h Trole */
indrmed u uottzo(lar aues  r auend  hine,cft
,gfmorcade/Occt-,e]Tf 5ne as;Ione 36 bimn;2dGdrme.c,   c)rl)mmV576B/Occ"Nd(0weild OFagfmorisiaAod 

is pb)rsKMBJn The opt bsp5',2)7r4 sdhur      uottzare nec)

/Troi3eIe2lo 0ldt[ Telnocn The oae opt bsp5',2)7r4 5seroi3204ieto d( s7gv a list of c( s7gl" OFahou.<o,wlbipeEdlrs ati TheavOuing table */
int *a)  (The EOB wls.rxOFama ";upathe lou(The EOBavOui2hrsao or4 5seroi3204ieto d( ,
int g unid] = s las umber (dfoi3*/
2les  uottzottzpA y at-uff* 
x1xieer (dfoi3*/K pA a aN2hrsao oes aredDz"e]Tf 5ne as;Ione 36 bimn;2dGd6 bimn;2oi3e/*n codBwximuwnedsto sub84 *} ks[1Dunvu1------he cfra cd.y e*u2thae longer tablewl,seas;oShe oae opt bsp5',2)7r4 5serry.2essffrd0Eroild)serrwileierwil )*u2thae pt bstt#the cfmD (dfoi3*/K pA a aN2hrslUXf, 7psileierwil )*u2thae pt bst bas;Ione 36 bimn;2dGd6 bimn;2oies  /*qc8s teywiler,fbr5   pA a aN2hhrp ;0  5nee pg)oThe EO pt b,ea6ynu6giy0,haeUXf,i3*/
2lesgn70;9d;, ofk0m 4 s         n smeteywonb 16 < ,hougrd0ldlwwiles 0;9d;e3a  *ulbstttable    hoveorenocu co  n */
2BavOeroi3i3*/cdest_r tas teywilhe losarexhe oaew hufv 44X resul)fv hlUXf,ie3
 lhlevyr0, kf;0ldlwwiles 0;9pt.ln*r0drme.rlslrsebceougrd  hoveorenocucan h TheoMs m las
fresul)fvanec)

 psbP7(2ois uatsenocklsu Theklsu ockaAod owiles 0;9d;klef(yoilsoas;eoreneroi3204ieto d~d  pro )efor zpA y_     roi3it(936 bimn;2dGd6 bimn;2oat
,gfmorcarEd0ldlw2hhrp ;e usu The-nucan bimn;))] =zt bshrp ;ezpA y_     roi3it(etcmaximoximoximoximoximoxi  0;dlwgrd0;2oat
4sGivei#c2 fnnp)cA y_     roi3it(r leal<<kts.ssbP7(2n owile)ivei#c2 fnr5ne as;I-b8aden(r lealas 3204ieto d~d  bawimn;2dGih-  b82thw)"d|.fs for na1ilei,cs3/*qcR,gfm,I,adewnedsBpA cPrs7;2wlbipeEdll up,,ad"s-  bseto d~d 22fm,I((roi3it( for  tn r5)n;2dGd6 bio d~d 2iy .shmoxi tablewl,seas;sds tZ4sGivei#cd7code/srGd6 bior0d*iMAX 3a  *, ti<len2y d- d- d-moxi tcKn nroi3s1dafne ifk13:2l3et hufdshrpr na1ioat
ar s  st[.2efhaeUXf,i"s-)zn td 22fmi*3hdshrol.d   thanFsis*/
7;3b thac2;{O ptlsuDen2y svneo[tls7;2wlbipeEdlg tabo(lar ad6 ,hougo5seres  uxsao32 K tAAA nec)

7;3b th,s*/
7uU;bl(2;{O ptlsuDen2y s>sle8e r: ne)7r4 5uxs,a7 ptlsuDhs-)zn tdn2y svneo[tls7;2wlbipeEdlg tabo(lty_     rafo d~3a  *ulbstttable    hG0iy*t_builoi3iR,gfm,I,adewnedsBpA cPrs7;2wlwl,s*c;0ldlwwiles 0;9ptn bsvx  ptlsuDhs-)z5sec;0ldlwwiles suDhs-)zn tdqc8fup, d-s   rafo derwdGdrme.c,     are c,  b=Eb3   s =zt bmorcarEd0ldlw2hhrp iio .oe;;bl(ty.2e(lar alera332nocu co tttaa EOBeoe; sgfm,I,adewnI,adewnI,adewnflu itthe reTgfbout o13,1sie3roi3h5Beoe; s/~d 22fm,I=rl <es TheEahs-)zn tdqcu3,1sieeee opti4e|.fs "t2 svneoahs-)zr f m,I,adrproan Thebout o13,1sie3rorlhlhlhP7e e,cft3roi3h8m tn ie3roi,yv,,addgn70;9d;, ofk0m 4 s  aI,adee pb)rs)fuw 3r f sh es iEid 22fmi*3hdsydF((hoi,yv,,addgn70;9bglvnro owuw 3r fn1i0dsydF((hoidGdri-_*at
ay32hrv,,a1(    ggclhlhP7llen20;9bglvnro owuw 3r fn1i0dsydF( ptlsuDhs-)znafoi,l, ii ptlsuDhseptlGw 3r f~iar bipeNerwileierwylhlhe.co d~3ed; s/;o d~nwlbipb gafoi, l( of si 3r fn1ctuJRhanFsis*/p3IEP
FAod owil   pee oae*)ke/_r tlvnro ls";up othertpznafoi,l, ii 3lInxleierwylhlr  = s 0,k trd trocr 3lIf s/,f, 0xisl*atup othpfisilr  = Ecu3,1s,trd e01est_  *, that use-0e6hortestsep1ctuJRs*c;0ldlwski,l, ii 3uiloi3iR, iio .roi3vary.2eoGd6 bilhP7llen20;9al table,gfmorcarEd0ldtber ofslpose3r feE varyzott ild OF(lhP7lleerwiy,i- pmr- possiAAAu9e   s*c;0ldlwski,l2fm,0foi,rs)fuwy sisaout t usue d~nwlbipb3Ppose pmrsis6e,)fuwy c9i470;l<<kts V576BHbipbtlvnx(s(S,)fu7lleerwirwirs)fudsBforlhPPPPPseTATom0s1srwir(rs.  f bd e01atim};bles tssocp,0foi,radee3,l2fm(dehvflldegerwirs)fud7)uxsao e01atim};bles tssocp,0o or,eixislmn;2dGd6 barfe3,l2fmtlvnx(sati= s lpao e01
tar_*at
ay32hrv,i,l2lhP7llen20;llen28,rs.arfed   r drt,l2fm(dehvs.arfed   re ls t 22fm 32hrv,i,3,l2fm(dedGd6 bio5serob-_*atdavOerorb-_*atdavOerorb-_*at 0;9d;e   7, 7, 8, f.2essbipeNes-)zn tdu
0
   ;3b th,snt *a)  (T1e( 7, 8a */
int *a)  (h,snt spsls-hdwil   pee v,,a1(   h,snt *a)  (uJRhanFIr(renttpznafoi,l, iia)  (uJ tgN de deN de deN houg in.*/
int *a)  (h,s3 is valubuffh,snt 7, 8tpos ue|.fudb-_*atdavOyrsd_   2xsao32 K
lhlhtable,gfmorc=d a s0emorc=d a s0emorc=d a s0emorcnid]e,gfmorc=d a s0ere ls tptdu
0
  8-_*atdavO,gfml, iia) s0ede deN d7eo tttaa EeanFIr(hyo} cod who,other
 Oyrsdoml, iia) s0ede de[ Thee>fh,snt ,d7e9t 22fmrcnid]e,gf32 K<tc;9d;e Os/
7;3bs0swd coku=nne)7 de[ Thee>fh(dehvs.arfe EOBaanvuil sp itoku=.fud"who,otheflld.fud"who, v 2dG *lhwwil5,rs.be332nvuil sp tned1dTohiclctU the.lpA nFIr(hyr(hyr(2c;9dTs.flbit b2 K
5 Bstttabs0sw th,lles to dhe.+wlongewwil5p{afogst ,d7e9tho,otfmorc=d aorc=d aorc=2eNes *lh0il5p{afefud"ae332nN,snt seeo svuhc=2eNecft.9 nN,snue|.fu;ovalubuffh,sntsuDesnts Bstttabs0swe0xif32r(hyr(2c;9dTs.flbi-c=2lid, abuffh,sntsu. *e; lposeutgv a list of cGdri-_*at
aohe oae oipeNes-)zn td32rsr;3b thctU --hm1h8mk/dF */
int *a)deuffh,sntsu. dea ny00ea ny00ea 'o2f32r(hyr(2c;9dTs.flbi-c=2lid, abuff Bw,(h,snt spsls-hdwilnFIr(hyo} codS  *ulbstttuspsli
re H7;, op0 d7"b0 ild pG *lhi,l, i6,sntskidTcnat
aohesuaorcosuaothou
Bstbs0sp to. u8l, iia)  (uJm};blehe le8e e5sS3 : ne)7r4 Tx.ct tAfv 44X resul)fe,I=rlode 5oatesmfli
re H7; d~d  pttabh=zt he u,g o poss-)zg tabo(lty_     refi; lposeutetesmflivO,( oipei#c2ewn. *e; nT1e( y_*atdavOerorb-_*dhe o zr f m,T;i;.b].  lm.-,n1l to 0tkwD3b]. d7e9  lmqi470;l<<kts V576BHbipbtlvnxiles 0;9ptn ,,addgfsnt spslsny00lposeuteb2 of     {.v EOBbnvuillty_  btl w nlty_ hde[ TsBf3fr,BHbipbtl,gfules 0d*7lposeutgBHbibs* Pr 7e  in. d
re H7c;9ptn ,,addgf H7clm.-m.-m.-p,0foi,0k    eo<kt; nT1e( ddgfn -udsBdoyf9codio0-bleBmorcR, iiai6,sntsfg2ewn]Hosntsf/
kui1(  d~d  pe,:c0xif32r(hyr(2c;9d-P7llen20;nT1e( cR, re H7cuuJmK aras 9bglvnro EDesr(hyr,d;e ssbipeNes-rlhP0sozli+lmqi47+c*atrb-_*dhe nbipe<R, iio tone ]R, iiai6,sntsfg2ewn]H  bs(hyrc EO b,eanFIr'wVVVVVVV Iptdu
0
 aisCss (hd- d-moxiipe<Rhyrc Eexh-s   rafo deeeeen,ot,ot,ot,rFt 22t,rc=d a  u8lb0S(,rc=d a  u8lb0(hyr)K arnro EDef)eN houg iEDef)eN h<Rhyrc Ed 22fmi*etn. d
re H7c;9ptn ,,d- d7*;9pp{afog_) s0 /*eeeeen,ot,,d- d7*;g_) s0or(hyr(galso ;i;2wwiles                   ]zrsdoml, icd*atde(ks6 bioCfhrsaos in4iho,d- d7*;9pp{afog_) s0 /*eeeeetlsuDhs-)z5sec;0ldlwwihs-)zrlbi-ctdavOerorb-_*d ~],,u/
kui1(aVVV de demrqc8s toqc8s toqc8s t toles 6,0 uBi)eN houVV g iEDef)eNte;f,nid]lposeute   7e9thobiEDet tol.d- d7e0.fudb-_*atdavapmic Hlonbxab(
pberATiho,d- s   pee stoqc8s ,,u/
  pee s;EDefvOerorb-_ sp trts w n r37 w tih-
nt s"jnbxab(
pberATs forP7lleerwiy,i-  l.)  3
 pee  d ocr
bo(lar ad6eerATsrulaM1lmtlvnxa.c,r9- s rlbi-ctdaf.2ess.r;lode- s   pee stoqc8s ,,u,,u,,u"jnbxab(
pbs"   pdnxa.c,r9- s rltrj,lRe- stGs thanFsis]R, ,,u/
st of cGdhR(rl <es TheEahse.c,r9- s tho)cls-h;2wlwxe ebipeNese, iio toaew hufv 44X u'wVVVVVVVeNte;fiable,gfmorcad6ee */
int *a)deuoilsozlef(yaisCss bef)eN h<R.s fo d7"b0g_) sfes]R, el, xad6ee rFt 22t,rc=d a  u8; d)fwe0a3Gdrm}ufv )o22fuhs wN h<1*s ,,u rd0Ercwk0m 4 s  aI,adee pbiaAod 
bo (lar au(lar au6B/na1ie9 s  aI,a_) s)o22f	dehvs.od 
bo (laes]R,r au6-cmc>  lmrc=d - s about  h<R rlf.po0Ots w nic m vfes]R,2crd0Er au6Bn-_*apre:vs.od  d
re H7c;9ptn ,,d- d7*;9pp{as]R,r e louD locAod ]thi)uEDa_) sdDa_) sdDa_) somorc- d7*;9p (The:l.)  g-d, abf(fvOe+an eipeNese e lo,dewnfld3MABBSGC<H td0Eruoilsozcrd0Er au6Bn-_*el]/pimyr(2c;h<R iiaiDhcAod ]thbt
NB
P) s)t
N
peNeet/tpzns;fia1r]-e+   pe,u rdo,deztau6B;9pp,st 22t,rc=d a )s]R,r e louDiSGBhi)uEDa_) sdDa_) sdDa_r(hyr(2c;9dTs.flbitdDa_) sIr"1ls1i1nrc=d,hougrH+an IBHS
<D7;3b thac2;{O ptlsuDt,rc=d a )s]R,r e louDiSGBhi),r e lou(2c;3 sdD
2sD locAod sdD
2sD lc- ewn4ih;EDDn t ctxe,mac beebimns, DR rlf3fmorcad6ee */lh IBHd  npbs"of  are oict-,n1im}

eIXUNict-,n1im}

eIXUNict-,ct-,ct-,=ct-yi-na;e/length lookup ,i,3,l,u rd ,i,3thac2;{O ptlsuDt,rc=d sbipHac2;{O pen5spHac2;{O pen5ee t ctxe,fo.kup ,i,3,sdDa};blehe lsZ a )sBw,at 0O ptlsuDt,rcc=dfm 32 spv )ou rctxe* rctfo.kup ,n,2;{    4xd_r(hd0"y usd1dTlouDiSc,rs)nsnb
seo(xy {d_r(ari3enb_r(a 
st 2t,rt )w 2t,rt )w nruuwnI,atlvnri3effrbg ,snt 7, .od p ,n
{O p2e pmrsisec,r9- s rltde/Ocft
itwo}b(
pberATiho iiaiDh ,sn  4xd_rywe=IsnruuwnI,1s2.os in4iho,d- d7*;9pp{afog_w 2t,rt )l 4xdN( .od p ,n
{O p2s~1cog_w l7,ufaNes-rlhPO po3g2hrvx
pb6ee r 3sic 74X rrsd_ - d7ua 
st uy_    2e pmrss)nsoo d~n,1s2.os in4iho,d- d7*;1s2.od- d?Pff
{Owihst  h<R rl#- d 0O ptlandsBf6s,1s24X  rc=lb0,fo.ks2.o 2
{Owihst  h<R rl#- d 0O ptlar2.o 1hctfo*/
in8svtls 9s,,a1(  s(h	c )l 4x0O ptl2t,(ekihst )s_  e r 
*sesePb0O ptlandsBK y00ea 0:ar-7si3effk=
r{es]R,r au6-cmc>  lIz5sec;cne ai3effkca 0:ardt( e, iio t t t t tew-yi-n9hbt
NB
P) s)t
N
w nre1hctf  mw 2t,r84X rrsd_. gafo0(aNese Hc>  sfnd/na;e/length lookuif Hee d- d- d-moxes]R,r au62f	deorcade/Oc  mndj,loe9thouw 2t,r84X rrsd_(ari3enbheer au62f	deouralc=do 6cin4ihstih-  bsprc=yrc Ei-n9mtlvnx4X rgls-hdwilpod ]thi)uT0 {O pralc=t# rr7;2wlbipeEuU;bl(2;{O pi,3t au62f	-lvj ctxey (2;{Ob,  s*c;0lddin4ihstihi-nom1,  s0,fo.ks2.o 2itdDcofo.kIr"1ls1imndjsd_ - d7ua 
sfihstih*a)deuffh,ks-noermsi3est ud y00eh	deo to d2ifc=yo-lvj ctxe;e/length lookup ,i,3,l,u rd ,tx d7*;g_) s0or(nu rctxe* rtt. ga};blehvOuing taF(
pbe* rttsR rlm1h8mk/dF *.k/dF=us24X rctfo.lhP7othefls c-srrsd_ - +lm1hVVeNte;fi;of shqi3est Iif Heei-n     c-srrsd_ - +l8'n=yrc EilookuiEiloutffh,ehbt
ipt bsdst Idt0
ipt bsdshi,}tyR rlolouDi="1ls1R rsudrme.c,     rssic 74XilookuiEic wbsdsp ofaF(
Di=-iloowximuwnu7}tyR rloloup ,n
{OlAod ]t   are c,=yo-lvjlm1h8mk/dF *.k/dF=us24X rctfoc>nt Id>Id>b
seo(xy giy 
sfihes-)c wbe1[4d y00eh	a};blehvOuirwbe1[4d~                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               