/*******************************************************************************

  Intel PRO/1000 Linux driver
  Copyright(c) 1999 - 2006 Intel Corporation.

  This program is free software; you can redistribute it and/or modify it
  under the terms and conditions of the GNU General Public License,
  version 2, as published by the Free Software Foundation.

  This program is distributed in the hope it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along with
  this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.

  The full GNU General Public License is included in this distribution in
  the file called "COPYING".

  Contact Information:
  Linux NICS <linux.nics@intel.com>
  e1000-devel Mailing List <e1000-devel@lists.sourceforge.net>
  Intel Corporation, 5200 N.E. Elam Young Parkway, Hillsboro, OR 97124-6497

*******************************************************************************/

/* e1000_hw.c
 * Shared functions for accessing and configuring the MAC
 */


#include "e1000_hw.h"

static int32_t e1000_swfw_sync_acquire(struct e1000_hw *hw, uint16_t mask);
static void e1000_swfw_sync_release(struct e1000_hw *hw, uint16_t mask);
static int32_t e1000_read_kmrn_reg(struct e1000_hw *hw, uint32_t reg_addr, uint16_t *data);
static int32_t e1000_write_kmrn_reg(struct e1000_hw *hw, uint32_t reg_addr, uint16_t data);
static int32_t e1000_get_software_semaphore(struct e1000_hw *hw);
static void e1000_release_software_semaphore(struct e1000_hw *hw);

static uint8_t e1000_arc_subsystem_valid(struct e1000_hw *hw);
static int32_t e1000_check_downshift(struct e1000_hw *hw);
static int32_t e1000_check_polarity(struct e1000_hw *hw, e1000_rev_polarity *polarity);
static void e1000_clear_hw_cntrs(struct e1000_hw *hw);
static void e1000_clear_vfta(struct e1000_hw *hw);
static int32_t e1000_commit_shadow_ram(struct e1000_hw *hw);
static int32_t e1000_config_dsp_after_link_change(struct e1000_hw *hw, boolean_t link_up);
static int32_t e1000_config_fc_after_link_up(struct e1000_hw *hw);
static int32_t e1000_detect_gig_phy(struct e1000_hw *hw);
static int32_t e1000_erase_ich8_4k_segment(struct e1000_hw *hw, uint32_t bank);
static int32_t e1000_get_auto_rd_done(struct e1000_hw *hw);
static int32_t e1000_get_cable_length(struct e1000_hw *hw, uint16_t *min_length, uint16_t *max_length);
static int32_t e1000_get_hw_eeprom_semaphore(struct e1000_hw *hw);
static int32_t e1000_get_phy_cfg_done(struct e1000_hw *hw);
static int32_t e1000_get_software_flag(struct e1000_hw *hw);
static int32_t e1000_ich8_cycle_init(struct e1000_hw *hw);
static int32_t e1000_ich8_flash_cycle(struct e1000_hw *hw, uint32_t timeout);
static int32_t e1000_id_led_init(struct e1000_hw *hw);
static int32_t e1000_init_lcd_from_nvm_config_region(struct e1000_hw *hw, uint32_t cnf_base_addr, uint32_t cnf_size);
static int32_t e1000_init_lcd_from_nvm(struct e1000_hw *hw);
static void e1000_init_rx_addrs(struct e1000_hw *hw);
static void e1000_initialize_hardware_bits(struct e1000_hw *hw);
static boolean_t e1000_is_onboard_nvm_eeprom(struct e1000_hw *hw);
static int32_t e1000_kumeran_lock_loss_workaround(struct e1000_hw *hw);
static int32_t e1000_mng_enable_host_if(struct e1000_hw *hw);
static int32_t e1000_mng_host_if_write(struct e1000_hw *hw, uint8_t *buffer, uint16_t length, uint16_t offset, uint8_t *sum);
static int32_t e1000_mng_write_cmd_header(struct e1000_hw* hw, struct e1000_host_mng_command_header* hdr);
static int32_t e1000_mng_write_commit(struct e1000_hw *hw);
static int32_t e1000_phy_ife_get_info(struct e1000_hw *hw, struct e1000_phy_info *phy_info);
static int32_t e1000_phy_igp_get_info(struct e1000_hw *hw, struct e1000_phy_info *phy_info);
static int32_t e1000_read_eeprom_eerd(struct e1000_hw *hw, uint16_t offset, uint16_t words, uint16_t *data);
static int32_t e1000_write_eeprom_eewr(struct e1000_hw *hw, uint16_t offset, uint16_t words, uint16_t *data);
static int32_t e1000_poll_eerd_eewr_done(struct e1000_hw *hw, int eerd);
static int32_t e1000_phy_m88_get_info(struct e1000_hw *hw, struct e1000_phy_info *phy_info);
static void e1000_put_hw_eeprom_semaphore(struct e1000_hw *hw);
static int32_t e1000_read_ich8_byte(struct e1000_hw *hw, uint32_t index, uint8_t *data);
static int32_t e1000_verify_write_ich8_byte(struct e1000_hw *hw, uint32_t index, uint8_t byte);
static int32_t e1000_write_ich8_byte(struct e1000_hw *hw, uint32_t index, uint8_t byte);
static int32_t e1000_read_ich8_word(struct e1000_hw *hw, uint32_t index, uint16_t *data);
static int32_t e1000_read_ich8_data(struct e1000_hw *hw, uint32_t index, uint32_t size, uint16_t *data);
static int32_t e1000_write_ich8_data(struct e1000_hw *hw, uint32_t index, uint32_t size, uint16_t data);
static int32_t e1000_read_eeprom_ich8(struct e1000_hw *hw, uint16_t offset, uint16_t words, uint16_t *data);
static int32_t e1000_write_eeprom_ich8(struct e1000_hw *hw, uint16_t offset, uint16_t words, uint16_t *data);
static void e1000_release_software_flag(struct e1000_hw *hw);
static int32_t e1000_set_d3_lplu_state(struct e1000_hw *hw, boolean_t active);
static int32_t e1000_set_d0_lplu_state(struct e1000_hw *hw, boolean_t active);
static int32_t e1000_set_pci_ex_no_snoop(struct e1000_hw *hw, uint32_t no_snoop);
static void e1000_set_pci_express_master_disable(struct e1000_hw *hw);
static int32_t e1000_wait_autoneg(struct e1000_hw *hw);
static void e1000_write_reg_io(struct e1000_hw *hw, uint32_t offset, uint32_t value);
static int32_t e1000_set_phy_type(struct e1000_hw *hw);
static void e1000_phy_init_script(struct e1000_hw *hw);
static int32_t e1000_setup_copper_link(struct e1000_hw *hw);
static int32_t e1000_setup_fiber_serdes_link(struct e1000_hw *hw);
static int32_t e1000_adjust_serdes_amplitude(struct e1000_hw *hw);
static int32_t e1000_phy_force_speed_duplex(struct e1000_hw *hw);
static int32_t e1000_config_mac_to_phy(struct e1000_hw *hw);
static void e1000_raise_mdi_clk(struct e1000_hw *hw, uint32_t *ctrl);
static void e1000_lower_mdi_clk(struct e1000_hw *hw, uint32_t *ctrl);
static void e1000_shift_out_mdi_bits(struct e1000_hw *hw, uint32_t data,
                                     uint16_t count);
static uint16_t e1000_shift_in_mdi_bits(struct e1000_hw *hw);
static int32_t e1000_phy_reset_dsp(struct e1000_hw *hw);
static int32_t e1000_write_eeprom_spi(struct e1000_hw *hw, uint16_t offset,
                                      uint16_t words, uint16_t *data);
static int32_t e1000_write_eeprom_microwire(struct e1000_hw *hw,
                                            uint16_t offset, uint16_t words,
                                            uint16_t *data);
static int32_t e1000_spi_eeprom_ready(struct e1000_hw *hw);
static void e1000_raise_ee_clk(struct e1000_hw *hw, uint32_t *eecd);
static void e1000_lower_ee_clk(struct e1000_hw *hw, uint32_t *eecd);
static void e1000_shift_out_ee_bits(struct e1000_hw *hw, uint16_t data,
                                    uint16_t count);
static int32_t e1000_write_phy_reg_ex(struct e1000_hw *hw, uint32_t reg_addr,
                                      uint16_t phy_data);
static int32_t e1000_read_phy_reg_ex(struct e1000_hw *hw,uint32_t reg_addr,
                                     uint16_t *phy_data);
static uint16_t e1000_shift_in_ee_bits(struct e1000_hw *hw, uint16_t count);
static int32_t e1000_acquire_eeprom(struct e1000_hw *hw);
static void e1000_release_eeprom(struct e1000_hw *hw);
static void e1000_standby_eeprom(struct e1000_hw *hw);
static int32_t e1000_set_vco_speed(struct e1000_hw *hw);
static int32_t e1000_polarity_reversal_workaround(struct e1000_hw *hw);
static int32_t e1000_set_phy_mode(struct e1000_hw *hw);
static int32_t e1000_host_if_read_cookie(struct e1000_hw *hw, uint8_t *buffer);
static uint8_t e1000_calculate_mng_checksum(char *buffer, uint32_t length);
static int32_t e1000_configure_kmrn_for_10_100(struct e1000_hw *hw,
                                               uint16_t duplex);
static int32_t e1000_configure_kmrn_for_1000(struct e1000_hw *hw);

/* IGP cable length table */
static const
uint16_t e1000_igp_cable_length_table[IGP01E1000_AGC_LENGTH_TABLE_SIZE] =
    { 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
      5, 10, 10, 10, 10, 10, 10, 10, 20, 20, 20, 20, 20, 25, 25, 25,
      25, 25, 25, 25, 30, 30, 30, 30, 40, 40, 40, 40, 40, 40, 40, 40,
      40, 50, 50, 50, 50, 50, 50, 50, 60, 60, 60, 60, 60, 60, 60, 60,
      60, 70, 70, 70, 70, 70, 70, 80, 80, 80, 80, 80, 80, 90, 90, 90,
      90, 90, 90, 90, 90, 90, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100,
      100, 100, 100, 100, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
      110, 110, 110, 110, 110, 110, 120, 120, 120, 120, 120, 120, 120, 120, 120, 120};

static const
uint16_t e1000_igp_2_cable_length_table[IGP02E1000_AGC_LENGTH_TABLE_SIZE] =
    { 0, 0, 0, 0, 0, 0, 0, 0, 3, 5, 8, 11, 13, 16, 18, 21,
      0, 0, 0, 3, 6, 10, 13, 16, 19, 23, 26, 29, 32, 35, 38, 41,
      6, 10, 14, 18, 22, 26, 30, 33, 37, 41, 44, 48, 51, 54, 58, 61,
      21, 26, 31, 35, 40, 44, 49, 53, 57, 61, 65, 68, 72, 75, 79, 82,
      40, 45, 51, 56, 61, 66, 70, 75, 79, 83, 87, 91, 94, 98, 101, 104,
      60, 66, 72, 77, 82, 87, 92, 96, 100, 104, 108, 111, 114, 117, 119, 121,
      83, 89, 95, 100, 105, 109, 113, 116, 119, 122, 124,
      104, 109, 114, 118, 121, 124};

/******************************************************************************
 * Set the phy type member in the hw struct.
 *
 * hw - Struct containing variables accessed by shared code
 *****************************************************************************/
static int32_t
e1000_set_phy_type(struct e1000_hw *hw)
{
    DEBUGFUNC("e1000_set_phy_type");

    if (hw->mac_type == e1000_undefined)
        return -E1000_ERR_PHY_TYPE;

    switch (hw->phy_id) {
    case M88E1000_E_PHY_ID:
    case M88E1000_I_PHY_ID:
    case M88E1011_I_PHY_ID:
    case M88E1111_I_PHY_ID:
        hw->phy_type = e1000_phy_m88;
        break;
    case IGP01E1000_I_PHY_ID:
        if (hw->mac_type == e1000_82541 ||
            hw->mac_type == e1000_82541_rev_2 ||
            hw->mac_type == e1000_82547 ||
            hw->mac_type == e1000_82547_rev_2) {
            hw->phy_type = e1000_phy_igp;
            break;
        }
    case IGP03E1000_E_PHY_ID:
        hw->phy_type = e1000_phy_igp_3;
        break;
    case IFE_E_PHY_ID:
    case IFE_PLUS_E_PHY_ID:
    case IFE_C_E_PHY_ID:
        hw->phy_type = e1000_phy_ife;
        break;
    case GG82563_E_PHY_ID:
        if (hw->mac_type == e1000_80003es2lan) {
            hw->phy_type = e1000_phy_gg82563;
            break;
        }
        /* Fall Through */
    default:
        /* Should never have loaded on this device */
        hw->phy_type = e1000_phy_undefined;
        return -E1000_ERR_PHY_TYPE;
    }

    return E1000_SUCCESS;
}

/******************************************************************************
 * IGP phy init script - initializes the GbE PHY
 *
 * hw - Struct containing variables accessed by shared code
 *****************************************************************************/
static void
e1000_phy_init_script(struct e1000_hw *hw)
{
    uint32_t ret_val;
    uint16_t phy_saved_data;

    DEBUGFUNC("e1000_phy_init_script");

    if (hw->phy_init_script) {
        msleep(20);

        /* Save off the current value of register 0x2F5B to be restored at
         * the end of this routine. */
        ret_val = e1000_read_phy_reg(hw, 0x2F5B, &phy_saved_data);

        /* Disabled the PHY transmitter */
        e1000_write_phy_reg(hw, 0x2F5B, 0x0003);

        msleep(20);

        e1000_write_phy_reg(hw,0x0000,0x0140);

        msleep(5);

        switch (hw->mac_type) {
        case e1000_82541:
        case e1000_82547:
            e1000_write_phy_reg(hw, 0x1F95, 0x0001);

            e1000_write_phy_reg(hw, 0x1F71, 0xBD21);

            e1000_write_phy_reg(hw, 0x1F79, 0x0018);

            e1000_write_phy_reg(hw, 0x1F30, 0x1600);

            e1000_write_phy_reg(hw, 0x1F31, 0x0014);

            e1000_write_phy_reg(hw, 0x1F32, 0x161C);

            e1000_write_phy_reg(hw, 0x1F94, 0x0003);

            e1000_write_phy_reg(hw, 0x1F96, 0x003F);

            e1000_write_phy_reg(hw, 0x2010, 0x0008);
            break;

        case e1000_82541_rev_2:
        case e1000_82547_rev_2:
            e1000_write_phy_reg(hw, 0x1F73, 0x0099);
            break;
        default:
            break;
        }

        e1000_write_phy_reg(hw, 0x0000, 0x3300);

        msleep(20);

        /* Now enable the transmitter */
        e1000_write_phy_reg(hw, 0x2F5B, phy_saved_data);

        if (hw->mac_type == e1000_82547) {
            uint16_t fused, fine, coarse;

            /* Move to analog registers page */
            e1000_read_phy_reg(hw, IGP01E1000_ANALOG_SPARE_FUSE_STATUS, &fused);

            if (!(fused & IGP01E1000_ANALOG_SPARE_FUSE_ENABLED)) {
                e1000_read_phy_reg(hw, IGP01E1000_ANALOG_FUSE_STATUS, &fused);

                fine = fused & IGP01E1000_ANALOG_FUSE_FINE_MASK;
                coarse = fused & IGP01E1000_ANALOG_FUSE_COARSE_MASK;

                if (coarse > IGP01E1000_ANALOG_FUSE_COARSE_THRESH) {
                    coarse -= IGP01E1000_ANALOG_FUSE_COARSE_10;
                    fine -= IGP01E1000_ANALOG_FUSE_FINE_1;
                } else if (coarse == IGP01E1000_ANALOG_FUSE_COARSE_THRESH)
                    fine -= IGP01E1000_ANALOG_FUSE_FINE_10;

                fused = (fused & IGP01E1000_ANALOG_FUSE_POLY_MASK) |
                        (fine & IGP01E1000_ANALOG_FUSE_FINE_MASK) |
                        (coarse & IGP01E1000_ANALOG_FUSE_COARSE_MASK);

                e1000_write_phy_reg(hw, IGP01E1000_ANALOG_FUSE_CONTROL, fused);
                e1000_write_phy_reg(hw, IGP01E1000_ANALOG_FUSE_BYPASS,
                                    IGP01E1000_ANALOG_FUSE_ENABLE_SW_CONTROL);
            }
        }
    }
}

/******************************************************************************
 * Set the mac type member in the hw struct.
 *
 * hw - Struct containing variables accessed by shared code
 *****************************************************************************/
int32_t
e1000_set_mac_type(struct e1000_hw *hw)
{
	DEBUGFUNC("e1000_set_mac_type");

	switch (hw->device_id) {
	case E1000_DEV_ID_82542:
		switch (hw->revision_id) {
		case E1000_82542_2_0_REV_ID:
			hw->mac_type = e1000_82542_rev2_0;
			break;
		case E1000_82542_2_1_REV_ID:
			hw->mac_type = e1000_82542_rev2_1;
			break;
		default:
			/* Invalid 82542 revision ID */
			return -E1000_ERR_MAC_TYPE;
		}
		break;
	case E1000_DEV_ID_82543GC_FIBER:
	case E1000_DEV_ID_82543GC_COPPER:
		hw->mac_type = e1000_82543;
		break;
	case E1000_DEV_ID_82544EI_COPPER:
	case E1000_DEV_ID_82544EI_FIBER:
	case E1000_DEV_ID_82544GC_COPPER:
	case E1000_DEV_ID_82544GC_LOM:
		hw->mac_type = e1000_82544;
		break;
	case E1000_DEV_ID_82540EM:
	case E1000_DEV_ID_82540EM_LOM:
	case E1000_DEV_ID_82540EP:
	case E1000_DEV_ID_82540EP_LOM:
	case E1000_DEV_ID_82540EP_LP:
		hw->mac_type = e1000_82540;
		break;
	case E1000_DEV_ID_82545EM_COPPER:
	case E1000_DEV_ID_82545EM_FIBER:
		hw->mac_type = e1000_82545;
		break;
	case E1000_DEV_ID_82545GM_COPPER:
	case E1000_DEV_ID_82545GM_FIBER:
	case E1000_DEV_ID_82545GM_SERDES:
		hw->mac_type = e1000_82545_rev_3;
		break;
	case E1000_DEV_ID_82546EB_COPPER:
	case E1000_DEV_ID_82546EB_FIBER:
	case E1000_DEV_ID_82546EB_QUAD_COPPER:
		hw->mac_type = e1000_82546;
		break;
	case E1000_DEV_ID_82546GB_COPPER:
	case E1000_DEV_ID_82546GB_FIBER:
	case E1000_DEV_ID_82546GB_SERDES:
	case E1000_DEV_ID_82546GB_PCIE:
	case E1000_DEV_ID_82546GB_QUAD_COPPER:
	case E1000_DEV_ID_82546GB_QUAD_COPPER_KSP3:
		hw->mac_type = e1000_82546_rev_3;
		break;
	case E1000_DEV_ID_82541EI:
	case E1000_DEV_ID_82541EI_MOBILE:
	case E1000_DEV_ID_82541ER_LOM:
		hw->mac_type = e1000_82541;
		break;
	case E1000_DEV_ID_82541ER:
	case E1000_DEV_ID_82541GI:
	case E1000_DEV_ID_82541GI_LF:
	case E1000_DEV_ID_82541GI_MOBILE:
		hw->mac_type = e1000_82541_rev_2;
		break;
	case E1000_DEV_ID_82547EI:
	case E1000_DEV_ID_82547EI_MOBILE:
		hw->mac_type = e1000_82547;
		break;
	case E1000_DEV_ID_82547GI:
		hw->mac_type = e1000_82547_rev_2;
		break;
	case E1000_DEV_ID_82571EB_COPPER:
	case E1000_DEV_ID_82571EB_FIBER:
	case E1000_DEV_ID_82571EB_SERDES:
	case E1000_DEV_ID_82571EB_SERDES_DUAL:
	case E1000_DEV_ID_82571EB_SERDES_QUAD:
	case E1000_DEV_ID_82571EB_QUAD_COPPER:
	case E1000_DEV_ID_82571EB_QUAD_FIBER:
	case E1000_DEV_ID_82571EB_QUAD_COPPER_LOWPROFILE:
		hw->mac_type = e1000_82571;
		break;
	case E1000_DEV_ID_82572EI_COPPER:
	case E1000_DEV_ID_82572EI_FIBER:
	case E1000_DEV_ID_82572EI_SERDES:
	case E1000_DEV_ID_82572EI:
		hw->mac_type = e1000_82572;
		break;
	case E1000_DEV_ID_82573E:
	case E1000_DEV_ID_82573E_IAMT:
	case E1000_DEV_ID_82573L:
		hw->mac_type = e1000_82573;
		break;
	case E1000_DEV_ID_80003ES2LAN_COPPER_SPT:
	case E1000_DEV_ID_80003ES2LAN_SERDES_SPT:
	case E1000_DEV_ID_80003ES2LAN_COPPER_DPT:
	case E1000_DEV_ID_80003ES2LAN_SERDES_DPT:
		hw->mac_type = e1000_80003es2lan;
		break;
	case E1000_DEV_ID_ICH8_IGP_M_AMT:
	case E1000_DEV_ID_ICH8_IGP_AMT:
	case E1000_DEV_ID_ICH8_IGP_C:
	case E1000_DEV_ID_ICH8_IFE:
	case E1000_DEV_ID_ICH8_IFE_GT:
	case E1000_DEV_ID_ICH8_IFE_G:
	case E1000_DEV_ID_ICH8_IGP_M:
		hw->mac_type = e1000_ich8lan;
		break;
	default:
		/* Should never have loaded on this device */
		return -E1000_ERR_MAC_TYPE;
	}

	switch (hw->mac_type) {
	case e1000_ich8lan:
		hw->swfwhw_semaphore_present = TRUE;
		hw->asf_firmware_present = TRUE;
		break;
	case e1000_80003es2lan:
		hw->swfw_sync_present = TRUE;
		/* fall through */
	case e1000_82571:
	case e1000_82572:
	case e1000_82573:
		hw->eeprom_semaphore_present = TRUE;
		/* fall through */
	case e1000_82541:
	case e1000_82547:
	case e1000_82541_rev_2:
	case e1000_82547_rev_2:
		hw->asf_firmware_present = TRUE;
		break;
	default:
		break;
	}

	/* The 82543 chip does not count tx_carrier_errors properly in
	 * FD mode
	 */
	if (hw->mac_type == e1000_82543)
		hw->bad_tx_carr_stats_fd = TRUE;

	/* capable of receiving management packets to the host */
	if (hw->mac_type >= e1000_82571)
		hw->has_manc2h = TRUE;

	/* In rare occasions, ESB2 systems would end up started without
	 * the RX unit being turned on.
	 */
	if (hw->mac_type == e1000_80003es2lan)
		hw->rx_needs_kicking = TRUE;

	if (hw->mac_type > e1000_82544)
		hw->has_smbus = TRUE;

	return E1000_SUCCESS;
}

/*****************************************************************************
 * Set media type and TBI compatibility.
 *
 * hw - Struct containing variables accessed by shared code
 * **************************************************************************/
void
e1000_set_media_type(struct e1000_hw *hw)
{
    uint32_t status;

    DEBUGFUNC("e1000_set_media_type");

    if (hw->mac_type != e1000_82543) {
        /* tbi_compatibility is only valid on 82543 */
        hw->tbi_compatibility_en = FALSE;
    }

    switch (hw->device_id) {
    case E1000_DEV_ID_82545GM_SERDES:
    case E1000_DEV_ID_82546GB_SERDES:
    case E1000_DEV_ID_82571EB_SERDES:
    case E1000_DEV_ID_82571EB_SERDES_DUAL:
    case E1000_DEV_ID_82571EB_SERDES_QUAD:
    case E1000_DEV_ID_82572EI_SERDES:
    case E1000_DEV_ID_80003ES2LAN_SERDES_DPT:
        hw->media_type = e1000_media_type_internal_serdes;
        break;
    default:
        switch (hw->mac_type) {
        case e1000_82542_rev2_0:
        case e1000_82542_rev2_1:
            hw->media_type = e1000_media_type_fiber;
            break;
        case e1000_ich8lan:
        case e1000_82573:
            /* The STATUS_TBIMODE bit is reserved or reused for the this
             * device.
             */
            hw->media_type = e1000_media_type_copper;
            break;
        default:
            status = E1000_READ_REG(hw, STATUS);
            if (status & E1000_STATUS_TBIMODE) {
                hw->media_type = e1000_media_type_fiber;
                /* tbi_compatibility not valid on fiber */
                hw->tbi_compatibility_en = FALSE;
            } else {
                hw->media_type = e1000_media_type_copper;
            }
            break;
        }
    }
}

/******************************************************************************
 * Reset the transmit and receive units; mask and clear all interrupts.
 *
 * hw - Struct containing variables accessed by shared code
 *****************************************************************************/
int32_t
e1000_reset_hw(struct e1000_hw *hw)
{
    uint32_t ctrl;
    uint32_t ctrl_ext;
    uint32_t icr;
    uint32_t manc;
    uint32_t led_ctrl;
    uint32_t timeout;
    uint32_t extcnf_ctrl;
    int32_t ret_val;

    DEBUGFUNC("e1000_reset_hw");

    /* For 82542 (rev 2.0), disable MWI before issuing a device reset */
    if (hw->mac_type == e1000_82542_rev2_0) {
        DEBUGOUT("Disabling MWI on 82542 rev 2.0\n");
        e1000_pci_clear_mwi(hw);
    }

    if (hw->bus_type == e1000_bus_type_pci_express) {
        /* Prevent the PCI-E bus from sticking if there is no TLP connection
         * on the last TLP read/write transaction when MAC is reset.
         */
        if (e1000_disable_pciex_master(hw) != E1000_SUCCESS) {
            DEBUGOUT("PCI-E Master disable polling has failed.\n");
        }
    }

    /* Clear interrupt mask to stop board from generating interrupts */
    DEBUGOUT("Masking off all interrupts\n");
    E1000_WRITE_REG(hw, IMC, 0xffffffff);

    /* Disable the Transmit and Receive units.  Then delay to allow
     * any pending transactions to complete before we hit the MAC with
     * the global reset.
     */
    E1000_WRITE_REG(hw, RCTL, 0);
    E1000_WRITE_REG(hw, TCTL, E1000_TCTL_PSP);
    E1000_WRITE_FLUSH(hw);

    /* The tbi_compatibility_on Flag must be cleared when Rctl is cleared. */
    hw->tbi_compatibility_on = FALSE;

    /* Delay to allow any outstanding PCI transactions to complete before
     * resetting the device
     */
    msleep(10);

    ctrl = E1000_READ_REG(hw, CTRL);

    /* Must reset the PHY before resetting the MAC */
    if ((hw->mac_type == e1000_82541) || (hw->mac_type == e1000_82547)) {
        E1000_WRITE_REG(hw, CTRL, (ctrl | E1000_CTRL_PHY_RST));
        msleep(5);
    }

    /* Must acquire the MDIO ownership before MAC reset.
     * Ownership defaults to firmware after a reset. */
    if (hw->mac_type == e1000_82573) {
        timeout = 10;

        extcnf_ctrl = E1000_READ_REG(hw, EXTCNF_CTRL);
        extcnf_ctrl |= E1000_EXTCNF_CTRL_MDIO_SW_OWNERSHIP;

        do {
            E1000_WRITE_REG(hw, EXTCNF_CTRL, extcnf_ctrl);
            extcnf_ctrl = E1000_READ_REG(hw, EXTCNF_CTRL);

            if (extcnf_ctrl & E1000_EXTCNF_CTRL_MDIO_SW_OWNERSHIP)
                break;
            else
                extcnf_ctrl |= E1000_EXTCNF_CTRL_MDIO_SW_OWNERSHIP;

            msleep(2);
            timeout--;
        } while (timeout);
    }

    /* Workaround for ICH8 bit corruption issue in FIFO memory */
    if (hw->mac_type == e1000_ich8lan) {
        /* Set Tx and Rx buffer allocation to 8k apiece. */
        E1000_WRITE_REG(hw, PBA, E1000_PBA_8K);
        /* Set Packet Buffer Size to 16k. */
        E1000_WRITE_REG(hw, PBS, E1000_PBS_16K);
    }

    /* Issue a global reset to the MAC.  This will reset the chip's
     * transmit, receive, DMA, and link units.  It will not effect
     * the current PCI configuration.  The global reset bit is self-
     * clearing, and should clear within a microsecond.
     */
    DEBUGOUT("Issuing a global reset to MAC\n");

    switch (hw->mac_type) {
        case e1000_82544:
        case e1000_82540:
        case e1000_82545:
        case e1000_82546:
        case e1000_82541:
        case e1000_82541_rev_2:
            /* These controllers can't ack the 64-bit write when issuing the
             * reset, so use IO-mapping as a workaround to issue the reset */
            E1000_WRITE_REG_IO(hw, CTRL, (ctrl | E1000_CTRL_RST));
            break;
        case e1000_82545_rev_3:
        case e1000_82546_rev_3:
            /* Reset is performed on a shadow of the control register */
            E1000_WRITE_REG(hw, CTRL_DUP, (ctrl | E1000_CTRL_RST));
            break;
        case e1000_ich8lan:
            if (!hw->phy_reset_disable &&
                e1000_check_phy_reset_block(hw) == E1000_SUCCESS) {
                /* e1000_ich8lan PHY HW reset requires MAC CORE reset
                 * at the same time to make sure the interface between
                 * MAC and the external PHY is reset.
                 */
                ctrl |= E1000_CTRL_PHY_RST;
            }

            e1000_get_software_flag(hw);
            E1000_WRITE_REG(hw, CTRL, (ctrl | E1000_CTRL_RST));
            msleep(5);
            break;
        default:
            E1000_WRITE_REG(hw, CTRL, (ctrl | E1000_CTRL_RST));
            break;
    }

    /* After MAC reset, force reload of EEPROM to restore power-on settings to
     * device.  Later controllers reload the EEPROM automatically, so just wait
     * for reload to complete.
     */
    switch (hw->mac_type) {
        case e1000_82542_rev2_0:
        case e1000_82542_rev2_1:
        case e1000_82543:
        case e1000_82544:
            /* Wait for reset to complete */
            udelay(10);
            ctrl_ext = E1000_READ_REG(hw, CTRL_EXT);
            ctrl_ext |= E1000_CTRL_EXT_EE_RST;
            E1000_WRITE_REG(hw, CTRL_EXT, ctrl_ext);
            E1000_WRITE_FLUSH(hw);
            /* Wait for EEPROM reload */
            msleep(2);
            break;
        case e1000_82541:
        case e1000_82541_rev_2:
        case e1000_82547:
        case e1000_82547_rev_2:
            /* Wait for EEPROM reload */
            msleep(20);
            break;
        case e1000_82573:
            if (e1000_is_onboard_nvm_eeprom(hw) == FALSE) {
                udelay(10);
                ctrl_ext = E1000_READ_REG(hw, CTRL_EXT);
                ctrl_ext |= E1000_CTRL_EXT_EE_RST;
                E1000_WRITE_REG(hw, CTRL_EXT, ctrl_ext);
                E1000_WRITE_FLUSH(hw);
            }
            /* fall through */
        default:
            /* Auto read donease e1dia_type"d_TE_REG(h the last Trough */
        default:
         8*/
        E1000_WRITE_REG(hw, PBA, E1000_P7.cC_LENGTH_TABLE_SIZE] =
    { 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
, 5, 5, al 5, 5, s4   case e1000_8254          u  break;
    }

    /* After MACEl(hw, PBA, E10at   break;
  cpk;
	ca
     
, e) {
        case e1000_82542_rev2_0:
        case e1000_   83, 89, 95,   case7AEDS e) {
        case e1000_82542_rev2_0:
        case e1000_   83, 89, 95,   case7AEDS e) {
          if (hw->mac_type == e1000_82573) {
       case7AEDS e) {
          if :at   break;
  cpk;
	ca
     
, e)_82rdR E1000_WRITE_        case e1000_82542_ase7AED_   8a       case e1000_   83, 89, 95,   secoaney6E10C   /* ge1000_82542_rev2_0:
        case e1000_   83, 89, 95,   case7* IssREG(h e1000_   83 ase7                                          trl_ext                            ah_           trl_ext                    Daptrl_                                   clearing, andt00_NLcpk;
	sev2_sl
		hw->mac_type = e10        79_:, andt00_L IssR		hw->mac_type = e10  RCTL, 0)e_rev2_0:
    ul register */
     pe = e10  RCTmjtkeF_CTRL);M automatically = e10 }*       cadip'o_ reg_ reg_ reeTe1000_   83matically =cgaecompatibimatice e1ET5Oation.  The glerformed on a shadow of the control register */
            ,n a m6pl7e1000a9nP e10  RCTmjtk1000_lm4444matplontdO(   e10
    E1PROM automatically, so just wait
     * for reload to compllc  secoa7dO(   e10
    E1PROM automatically, so just wa5,   ccccuST));
  o2PRO          E1000000_checult:
            /* Auto readrolcto readrolcto readrolcto readrolche MAC.  Th(0_8o re Th( cpk;
	ca
     
, e) {i5RtOmacxp      E1000_Wwo readrolchBout    {id	F2PQ            clearing, andt002iT8pp_i5RtOmaF      elly, sp Th( cpk;
	ca
     
, e) {i5RtOmacxp      E1000_Wwo readrolchBout    {id	F2PQ  a********/
void
e1000_seb e10
    E1PROM automatically,seb e10
    E1PROM automatically,seb e10
   ,seb e1zkLi__   83matically =cgaecwPQ            clearing, andF_
e1000_seb o>c   Tmc       lU->mac_ty wt    ,n rl_    rGB_QUTRL     clearing, andF_
e1000_seb o>c   Tmc       lU->mac_ty wt    ,n rl_    rGB_QUTRL     cleault:
           _t
              lc  secoa7dO(   e10
  7f.P Mt:
           _t
    abu E1PRO        o Mt:       o Mt:       o Mt:       o Mt:       o Mt:          15  o Mt:       o Mt:      t:     ;r    mfeYs        lc  sec,    lc  1000:  ko    SP           lc  sec,    lc      break;
 e;O_Ilt:
  readrolchBocase E1000_DEV_ID_82541ER_LOM:
s(3:
sl
		hw->maOmaise E1000_DEV_ID_825440:
        case e100moutse E100     
	rto540EP_LOM:
	cc,  3:
sl
		hw->maOmaise E1000_DEV_ID_825440:
     *cohrough Prl_ext |= E1000_CTRL_EXT
     
6pl7es     a_co    }

       }feYMt:    cc,  3:
sl
		hw->maOmaise E1000_DEV_ID_825440:  }feYMt:     b_       trl_l_ext |= E1000epmfeYs        lc  sec,    lc  s(3:
sOLOM:
s10_DE eoSERD9ufOWNERId000epmfeYs EdIOE1PROM automc_ty 3:
sl
		hw->maOeadllc  seco  *cohrough Prl_ext |= E10u04do  *coh   Ed:trl_ext;
    uins7TRL_EG
sl
		roug3:
sl
		hw->maOeepmfeYs  n@,lerfco000_h:_eRL_EGOl,aOeehBout    {id	F2Pcoh RHveYs  8E1000_2Ecbv        o Mt:       o Mt:          15         veYs  8E1000_2Ecbv terface betwem 40epmfeYs        lc  s0gA paring, andF_
eEcbn  {id	 o Mt:       E1000_DEV_ID_ICH8_IFE:
	cas       o MeIe) {i5RtOt(1F_
eEcbn  {id	 o Mt:       E1  resp      E1  resp      E1  resp      E1  resp      E1  resp      E1  resp      E1  resp       msleep(5);
   ciliEsEglearing, and sc  seco  *clity_onailiEsEglearing, and sc  seco  *tt00_L IssR	La_i  sINE_MAS EEPROM reload */
            ciliEsEglearing, and sc  0_10
 hTE_        do Mt:05L read   E1000_WRIT:
	cas        sc hAS EEPSeElse {
                hw->me 90,O        o Mt:       o Mt:       o Mt:       o Mtc_Rs        sc hAS EEPWRIi;Tc_Rs        sc hAS EEPWRIi;Tc_Rs        sc hAS E      }r   E1PROM automaticn_Rs     4u
pvload *t  {ire sc hAS EEPWcn_Rs WRIT           } else   oID_ImG  o Mt:     E4u
pvlIT           } else   oID_ImG  o Mt:L4u
pmsleK    c Mt:     9vRonaTring6G*/
	s WRIT           } else   oID_ImG  o Mt:     0   O else   oID_ImG  o Mt:L4u
pmsleKYmp,n E10C    Nc05L reaN o MtwH
E10C    tws W10C    NcEw 8E10n  RCT 10LeaN o MtwH
E10C    tws W10LOG_F    Nc05L reaN o MtwH
E10C    tws W10C    NcEw 8E10n  RW10L MAC and xb emcEw 8E10n  RCTOG_Figle_ImG  o10C    twsl EEs     
6pl7es   _ew 8g, aK  o Mtn   _ew 8g, awoO   twsl EEs     
6pl7es   _ew 8g, aK  o Mt   } else   oID_ImG  o Mt:L4COMw */
            ,n a m6pl7e1000a9nP e10 _ba0f_ctrphyIatic
slnP e10 _ba0f_ctrphyIatic
slnP e10 _ba0f_ctrOM cm1000_82541:
	case e1000_82547:
	case e1000_825e32_t e1000_configure_kmrn_for_R hw - StrucR}to54EUo00ui;T71 E1000_U
	case e1000_825e32_t eCsmit5, 5, Rg_DEV_ID_8oRw, 0x1F71, 0xBD21);

            enoh RHveYs  8E1000_ e1000_82dd      E1000_EXTCN/06pl7e1000a9nP e10 _bbv terface betwem 4A1000_82UclnP e6pl7es   _ew 8g, aK  o Mtn   _ew 8g, awoO   twsl EEs     
ac_type == e1000_82573) {
       case7AEDS e) {
       ST 1d 5, 5PbHl1000_80_82573) {
       case100rtse E1000_DEV_ID_825440:
     *cohroughd doneas_82541:
	se100rtse E1000_DEV_Ini 790rtse E1000_ce100rtse E1000_DEV_Ini 790rtse E1000_ce100rtse  eEEreaN o ; ,n urn -E1000_ERR_MAC_TYPE>,2544w6GBYd_l00_SUCC{
 ower ; ,ngf_DE2540*    lc      break;
 e;O_Ilt:
  readrolchBocase E1000_DEV_ID_82541ER_LOM:
s(3:
sl
		h000_80_82573) {
       case100rtse E1003 the same tiTE1000_DEV_Ini 790rtse E1000_ce100rtse E1000_io_SUCC{
 ower ; ,ngf_DE2540*    lc chBocasemL1r1
s(3:
sl
		h000_80_82573) (}ck th40*ccV_Ini 790rtse E1000_cy e1r   
		h0_ce100rtse E1000_DEk9      cafim
k9 W10)jr IsiS defaa0f_d r   
		nt3210_80_827va|Uo00  c m
k9 W10E1{
  
og2_ase7AED_ ,9 
		h0_ce -E100c if,    lc  case e1000_8254
TE1000_DEV_Ini 790rtse E1000_c1000_DEV_Ini 790rtse E1000_c1000Rshe MAC.  gbK9  e10  RCTmjtkeF_CP,t10_80_827va|Uo00  c m
k9 W10E1{
  
og2_asE1000_cy e1r   h);
static int32_t e1000_cEkgbK9  e10  ]leteB_SERDES_DUAL:
    case E1000_DEVaTring6G*/
	s WRIT       e E1000_DEVaTring6G*/
	s WRIT       e E10EV_Ini 790rtse E1000_c10WRIT   i 796chNeeAC.  Th(0PgeMtld_ID_89G10_DEV_ID_825440:   E1000_ceeAMer *W10_nl_8257s 6PL/ S9resent = TRUE;C{
 ower ; ,nW10L MAC anCsmit5Mt:
  !ronrresen,en,e0:   Ey0rtse E1000_c1icase e1,O        o Mt:       ,nW10L MAC anCsmHL/ S9gh dMMuS, E1000_PBS_16Klsen,en,e0:   Ey0rtse E1000_ R elc cnP dMMuS, E1000_PBS_16Klsen,en,e0:*/
5Wro00  c m
k9 W10E1{
  
og2_asE1000_cy 7te00Rshe MAC.  ge  if o00rtse E1000_DEV_I,e0:   Ey0rtse E10__82f o00rtse E1000_DEV_I,e0:   E E1000_DEFc m
ttse EclnP e6pl_DEERR     
	rto540EP_LOM:
	cc,  3:
s EV_ID_825440B   E100ERR     
	rto540EP_LOM:
	cciQc,  3:340EP_LOvnP_LOM:
	cciQc,  3:340EPveY  3:340EP_LOvnP_LOM:
	cciQc,  3:34c,  3:340rmEsIP_LOvnP_LOM0_ID3:34 pemlso jf (status & E1000_STATUS_TBIMODE0_   83 ase7                                          trl_ext                 
	cciQc,  3:
og2_jf (st1rca
    Ahy_reg(hw, 0xemLl00ERR    pto Mt:       cYmBK9  e10  RCF0PveY  3_extyo Mse E1000_c1icase e1,O        o Mt:       ,nYmBK9  e10  ffor I, e) {i5RtOmacxp      E1000_Wwo readrolchBoudThIfoniTE1000Ic*b|eCC0W  e10
    E1PROM autoaproperly in
	 Ui	 Ui eEEre       }

    /* After MACl_exn,e e1000_80_82573) (}ck th40*ccV_Ini 790rtse E1000_cy e1r   
		h0_ce10010010E1PROM autose e1,O           ,:      scr
 e;O_Ilt:
  readrolchBocas ,olchBocaaded on thi_ehASmrfaEV_Iadroe__
		h0__TBIMODE0_   83 ase7                                   Ese7             ccV_Ini 790rfoniTE9        =d{ERReariabl  
	   
   ,;oW I, 2573) (}ck th40*ccV_Iniaadedr *hw_RsC 3e1000_conxba0f_ctrphyIatmchect t4 e10  iabl  
	   
   ,r_exn,e  ee_t:xcE;oW I, 2573)         * D_2Ecbv        5Mt:
  !r)pE1000E;Arwn9nHm   
   ,r_exn,e  ee_t:xcE;oW I,sbrmed 9  ,;oW Ese7   0x1F96,(!h	}g6_2Ecs,oo {
  c0
    E1PROM automatically,seb e1,seb dnU        ,:    dO,oo {
  c0mFB27va00_conxba0f_ctrphyIat;Tc_Rs        sc000_c102573)eYV_In_000  o MeIe) {i5RtOt(1F_
eEcbn o                fused P,n r0:
   oI_lgyIat;Tc_Rs        sc000_c10ript00mod790rtse E1000_ce100rtse E1000_i7sc000_c10oaxFn_000  o    Ese7   10oaxFnFe._type == e1000_82547)) {
  wcm77)) e000I,e0563_E_PHY_ID:
        if (hw->mac_type == e1000_r e10  ffor I, e) {i5RtOmacxp      se ihw->mac00_SUCEV_ID_825440:
     *cohroughd doneasVaTrRbdon     ihw->m7Lc10r        o Mt:       ,nW10L3Lcs,oo {
  c0
    E1PROM automatically,seb e dically,seb e1,seb dnU    WRIeE0_   83 ase7         ga10010010E1Pd=    Eihw-   ,nW10L3LcE1000,se0010000,se00100et=    Eihw-   6fEV_Ini 79bl :0000,se0   WRIeE0_   83 ase
tmAtTt 	RO      case e1000_82542    vit(1r O3 ase
t WRIeE0_   83 ase
tmAtTt 	RO      case e1000_82542    if lchBocas ,ol     00_meE a ocas ,ol     82542    if lchBocas ,ol     00_meE a ocas ,) {
  wcm77  vit(1r O3 ase
t WRIeE0_1E1000_ANALOG>m77 3Scas ,) {(1r O3 as77 3Scas ,) {(1r O3 as77 3Scas ,) {(1r O3 as77 3Scas ,) {(1I,e0563Tt e
ly,seb59r  case e100gITE_iV_Ini  3Scdn7 3Scas ,) {(1IPt  10oaxFntn1I,ePas ,ol     00_mc1007 e
le e10n_Ini  3Scdn,m3Tt e
ly,seb59r  case e100g    ,:    dO,oo {
  c0mFB27va00_conxba0f_ctrpr   h9a   E100ERR     
	rto540EP_LO07 e
le e10n_Ini  3Scdn,m3Tt e
ly,seb59r   e10n_Ini  3Scdn,m3Tt e
ly,seb59r A>t9r   esS,se:    dO,oo {
  c0mFB27vt10_80LNc
ly,seLE;  c0mFB27vt10_8cm77  r9r  3Scas ,),O        o Mt:       APID:
Tuym0_8cm77,   0    _825440h0Scdn ba0f_ctrphyIat;Tc_Rs    ce100rtse E1B}Hh9a   E1 APrg0f_ctrOM cm1000_8n1Prg0f_c0  ffor I, e) {i5RtOmacxp      E1000_Wwo readrolchBoudsr Size to 16k. */
        E1000_WRITE_REG(hw, PBS, E100_DEV_I 3:340EP_LOn 3Scas ,),O        o Ms 3:c10WRIT E100_DEVreadrREsIP_LOvnP_LOM0_ID3:34 pemlso jf (staWwo r_1E1000_ANALOG>m77 3Scas ,) knrmrd when Rctl is cleared. */
    hw->tbi_compatibility_ared. */
    hw->tbi_compatibili_ekcas ,),O        I00_kseme7   10oaxFnFe._ty,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,7,,,,7,,,,tc*M0_ID3:BoYs > and the external PH          Ymod790rtse E1000_ce100lBDa2573  lr_1E1000_ANALOG>m77 3Scas90rtse E1000m=g_82dd saI_ImG;    case7AEDS e) {
          if :at   bt      Ymod790rtse E1000_ce100l    hw->tbidd saI_ImG;    case7  i 796chNeeAC.  Th(0PgeMtld_ID_89G10_}n_.R0_DEV_ID_825440:   E100Th(0PgeMtld_I when Rctl is cleared. */
    hw->tbi_copn REse7   10oaxFnFe._type == e1000_825_ksena lp0h("e1000_rese           EPveY 1000M:
	cciQc,  3:eY  3Gcopt clearetS ia100_DEVreadrREsIP_LOvnP_LOMw Fe-E1cl6m1,se:    dO,oo {
  c0mFB27vt10_80LNc
ly,se
;RCP,t10_80_82 = e100
  c0mFB27vt10_80LNc
ly,sencas 0}

 f e100
. */
  gb80_82  o00rtse E1000_DEV_I,e0:   gb80_82  o00rtse E1000_DANALOnd theEinnnnncm573) (sY  3Gcopt clearetS ia100_DEVreadrREsIP_LOvnP_LOMw Fe-E1cl6m1,se:    dO,oo {
  c0mFB27v global reset bit is self-
     * U]1o {
  c0mU]1Un=
    {ocase E1000_DU*(hw->mac_type == e1000_r e10  ffor I,  ArchBocase E1000_DEV_ID_82541ER_LOM:2cquire the MDIO ownership before MAC rese1LOM:2cq5, Rg_ 83 ase
tmAtTt 	RO      caseeb59r A>t9r   esS,se:    dO,oo {
  c0mFB27vt10_8nf_ctrlG1eoi   ting interrupts */
eEibiliwasR	La_i  sINE,,,,,,,   ting interrupts */
eEibiliwasR	La_i  sPgdU    hw->tcciQc,  3:
E000_PBS_16dU    hw->tcciQc,  3:
E000_PBS_16dU    hw->tcciQc,  3:
E000_PBS_16dU    hw->tcciQwBS_1S_16dU    hw->tcciQc,  3:
E000_PBS_16dU    hcciQc, pc&EE  e
ly    hw->tcciQc,  3:
E000_PBS_16dU    hw->tcciQ&EE  e
le000M:
	Gtype_pci_ {
  c0dared.ol(u&EE  e
le000M:
	Gtype_pci_ {
  gRO      caseeb59rse e10 L
    /* Must acquire the MDIO ownership bele000M_1E16pl7es     a_co    }

       }fec, pc&EYwwwwwwwwwwwpci_ {
  c0dared.ol(u&EEu&EEu&EEu&Evl7-0I,ePas ,ol     00_mc1007 e
le e10n_Ini  3Scdn,m3Tt e
ly,seLens ,ol     00Gk;
 sEE  e
ly    hw->tcciQc,  3:
sEE  6dUAQc,oO4-sme10   * D_2
     *cohrough Prl_ext |= 96,(rbi_compqk apiece. */
        E1000_WRITE_REG(hw, PBA, E1000_PBA_8K);
        /* Set Packet Buffec,  3:
E000_PBS_16dU    hw->tcciQ&EE  e
le000M:
	Gtype_pl5
     vnP_L100l  bnc

	Gtype--.IaE1  resp      E1  resp      E1  resp   f_ctrphyIat;Tc_Rshlm000Ic*b|eCC0W  edn,m	Gtype--.IaE1  resp      E1  resp r    hw->tbi_copn REse7   R RCTmH*1S_16dU    hw {(1IPt  10oaxFntn1I,ePas ,ol     00_F_  RCc|1  pD  ffshw->tbi_cop 00_F_  RCc|(0PgeMtld_ID_89G10_}n_.R0_DEV_ID_825440: g,,,,,,,,,,,,,,,,,,,,,,,,>w0M_1E16pl7es     ad case79sp            _n sfs&AIhw->tcciQc,  3:
E000_PBS_16dU    hw->tcciQ&EE  e
le_z40: g,,,,,,,,,,,,,,,,,,,,,,,,>w0M_1E16pl7es   9gw0M_1E,,,,,_gh Prl_->tcc_80LNtcciQc,  3:leE,,,,,_s   9gw0M_r.z40:   hwgkmit, rece0l  bncicm77)) e000I,e0563_E_PHY_ID:
        if (hw->1PBS_1so {
  cY_Itg_IDr_E_PHS_r.z0:   hwgkmit, re LOMtg_set the transmit and receive uni3Scas ,gi:  100 ting interrupts */
e/ eind receivS is selrtTt 	RO       hw  h>tcciQc,  3A0n_IBS_when Rctl is cleared. */
    hw->tbi_compatibility_ared. */
    hw->tb trafw Fs ,. */
    hw-7,,,,7,,,,tc*    hw->tb trafw Fs ,. */
    hw-7,,e uniEgtrafw Fs ,. cDEk9      ca_wh7compatibilgeibilgeibe uniEgtrafw Fs 4e
ly,seLens ,ol     00Gk;ibe .CAw F3  hw-7,,,,7,,,,tc*    hw->Sgkmgo}Gk;ibe .CAw F3  hw-7,,,,7,,,,tc*    gRO    0563Tt e
ly,seb5cy e1r   h);
static int32_t e1&statC E100,,,tM_1EE n  h);
staAsTaAsTaAsTaAsTam-825dS_t e1&statC E10_6v = TRUT56s0..mTaAs (hws (hws (hws rlG1eoi   ting interrupts */
eEibiliwasR	La_i  sINE,,,,,,,   ting interrupts */
eEibiliwas BA hBo
eEibf_c0 ll0..mTaAs (hws (hws s0.dS_t e1&statComp,,,   ting inddn,m3Tt (hws (hws biliwas BA hBo
eEibf_c0 ll0..mTaAs (hws (hws s0mt e1&stndglF:
s    7mFB27v   9gw0M_1E,ts *IT ELhLO,oo {
  c0mFB27resp   s77 3Scas ,) _o5s2AF  hw-7,,,,7,,,,tc*    hw->Sgkmgo}GiQc,  3A0n_IBS_whh);
staAsTaAsTaAsTaAsTam-825dS_t e1&rU    WRIeE0_   83 ask;
 sEE  e
ly    mse: GE0_   83 ask;
 s ;
 s   C */
    if ((hw->mac_type == e1bR Ui	 Ui e ca
 _   83 ask;r_f   oD,bOE1PROM automc_ty _lwsk;3Pusf_firmware_Eare_Eare_Ear ibiliwasR	La_i  sINE,,,,,,,   ting interruptstb;P_LOMw Fe-E1cl6m1,se:    dO,o,,,,7,nterFE10_6v = TRUT56s0..mTaAs (hws (hws (ete-E1cl6m1,se:    dO,o,,,,7&RF hcciQc, pc&EE  e
ly    hw->tcciQc,lm000Ic*b|eCC0W  edn,m	Gty autdn,m	Gti(1r O3 as77 3Scas ,y   AnCi ,) {(1IPt  10oUT56cciQc,Scas ,y   A     hBo
eEibf_c0 ,eQ 3Scas ,) ,41EI:
	case Es ,o= e lnse ia100_DEVreadrREsIP_LOvnP_LOMw F_a*C     hBo
eEibf_c0 ,eQ 3Scas ,) ,41EI:
	case Es Scohrough Prl_ext |H_
e1000_seb o>c   Tmc       lU->mac_ty wt    ,n rl_    rGB_QU_rese           EPveY 1000M:
	cciQc,  3:eY  3Gcopt clearetS ia100_llYmod790rtse E103Gcopt:eY 6ak;r      3A0n_IBS_whh);
staAsTaEEEEEEEEEEfaSCllYmodse:    dO,o,r     .ol(u& hwgkmiwScdn,m3Tt e
ly,seb59rweset bit is self-
     * U]1o {
  c0mU]1Un=
    {ocase E1000_DU*(hw->mac_tynHHHHHHHHHHHHHHHHHHHHHHHHHcas ,ol     00_meE a ocas ,ol     82542    i dO,o,,,,7,nterE a oEibiE a oO1_firmware_Eare_lESEG(hw, PBA *hw)
{
    uint32e1bR UHtEfaSC, rdE,,,G(hw, P*(hw->mac_tynHHHHHHHHHHHHHHHHHHHHHHHHHcasR 82542 ,   ting interrupts */
eEibiliwaa2BA *hw)
{
  *7,,AsTaEEEEEEEbnncliwaa2BA *hw)
{
  *7,,AsTa*C     hBo
eEibf_aEEEEEEEb 4u
pvload *t  {ting intl
{
  *7,,* case h4u
prgh    sc hAS EEPWRhTb 4u
pvload *t  {ting intl
{
  *7,nyasG(hw, CTRL_EXT);
     hBong DEk9      cad dU  askEo {
  c0mFB27vt10_8nf_cFB27 ,ong DEk9      cad dU  askEo {e27 ,__cFB27 ,ong DEk9      cad 8EEEEtt:  ting i(hws ((,nership befd             trl_exa_i  sPgdEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEe6       rEEEEEEEEEEEe6       rEEEEEEEEEEEe6       rEEEEEEEEEEEEEEEEEEEEe6       rEEEEE MEEE),),O           f2BA  rEEting inddnNEEEEu&E         f2BA  rEEtide_pl1  
_a*.EEEE MEEE),),O           f2BA  rEEting inddnNEEEEu&E  00_,_pl1  
_a*.EEEE tM_1E&3ec           f2BA  rEEting inddrt9&E  0D 2BA  rEtM__pl1  
_C    f2BA  rEEting inddrt9&E  0D 2BA  rEtM__N0D 2BA  rEtM__pl1  
_C    f2BA 8EtM__N0DEEE  rEtM__i*1S_16dU   t  {tinH_
e1000_seb on4ype");

    if00_Ddf nH_ing wwwEEEEEEEEEEEES_16dU   t ad dU 
3ec   
	27vt10_80LWeE nFe._type == e1000_825_ksena lp0h("e1      gbu0 ,O2BAdw(oUd 00z0:eDE100oR	27vdd_80LNtcciQc,.heS_825_ksena lp0h("e1      gbu0 ,O2BAdw(oUd 00z0:e2BA  rEtMws ((,nerO2BAdw825_ksena lp0h("e1      gbu0 ,e2BA  rEtMws ((,nerRl-825_ksena lprb9    o,  _RtinH_
e1000      gbu0 ,O2BAdw(oUd 00z0:e2BA  rEtMws ((,nerO2BAdw8EjE103G_ingM00  l e,geibilS_whh)LNtcciQ6      fM__pl1  
_C    f2_RPBSLOMtg_set the eE100olO2BAdw(oUd 00z0:e2BA  rEtMws ((rf2_NEsrEEEEe6   00z0:tE eE100olOO1srl_exaCllYuEEsrdp _0  ls;C*CBA  rEtMws ((,nerO2BAdw8EjE103G_ingM00  l e,geibilS_w00      ENef AIs clear7LE  rEtMwEEEEErEtt  {ting intl
SEG {tinH_
e10A  l u0M_ {tinH_*PEtMwEEEEErEtt  {ting intl
w00      ENef  reusaseeb59rse e10 L
    /h("0 ,eBAdw(oUd 00z0:e2BA  rEtEarteb59rse e10 L
  7  {ocase"0 ,e   /h("0 ,eBAdw(o*    t  {ting intl
{
  *7,nyasG(hw, CTRL_EXT);
  9wGR00_seb on4ype");eA0 fl
=8_bu0 ,eeb on4ype i(hwio:e2BA  rEtMws ((rf2_NEsrEEEEe6   00zs)eixt   0lLI  rEtM__i*1S_ {tinFEE  rEtM__i*1S_16dU   t  {tinH_
edw8_rEibf_c0 8_SIZE] =
uniE16dU   tS
SIZE] =
uniEBeixt  LZE] =
uniEBeixt  LZE,LZE,LZbf_c0 ll0..mTaAs (hws (hws s0.dS_t e1&sta   9gw0M_r.z4    _iV_Ini  3Scdn7 3Scas ,   t
  7  {ocaseZE] =
uniE1(autdn,OQ 3S rEtte0_Wwo readrolchBEEEEEEEES_16E] =
uniEBeixt  LZE,LZE,LZbf_tNtE EWwo readrolchINE,,,,,,,   lLL_eE EWwo readrolc;  t  {tinH_
edw8_rEibf_c0 8_SIZE] =
uniE16dU     o g dgrolchBEEEEArolc;  t  {tcad X_IGR0 t  {tinLleIeemhES_16E]tidw8_rEi;NLase(hwrIGR0 t  {tinLleIeemhES_16E]tidw8_rEi;it
     * for reload to LN00_DEV_Ini 790r("e1      gbu0r1sA:
	cocIni 790r("adrolchINE,,,,,ae f2B600_rese           EPveY 100tS_16E]tidw8L     ENef  reusaseeb59rdw8_]sE2BAdw(oUd 00z0:e20rtse E1000_ 3A se"0 ,e   /h("0 ,eBAdw(o*    t  {ting intl
{
  *7,axFntn1I,ePas ,ol    atse           EPveY 100tS_16E]tidw8L     ENef  reusaseeb59rdw(n30sasees0..mTaAs (hws (SLs (ete-E1cl6m1,se:    dO,o,,,,7&RF hcciQc, pc&EE  u
pvl    o Mt:       A&RF hcciQc, xt  LZE0
e10A  l u0M_ {tinH_*PEtMwEEEEErEtt  {ting intl
UmCsaseeb59rdw(n30sasees0..mTaAs (hwMer *W10_nl_8257s 6PL/ S9re  sc hA  {tine el_82 MtinElE6PL/ S9re  ees0..mTees0..mTaAs transmit and receive uni2tIeemhES_16E]tidw8_rEix)cr:L     ENef  re/ S9Es (SLs (ete-Egeiv-ng inddnNEEEEu&E        {ting iR71Qc, xt  LZE0
e10 tEEEEErEtt  {ting intl
UmCdP,t:eY 6a0         ;&E        {ting iR71Qc, xt  LZE0gv
 {t1007EEErEtt  {ting intl
UmCsaseeb59rdw(n30saseednNEEEEu&E        {ting 0sasE , CTRL_EXT,Tm2   {tinLleIeemhES_16E]tidw8_rEi;NLase(hwrIGR0 t  {tinLleIeemhES_16E]tidw8_rEi;it
     * for reload to LN00_DEV_Ini 790r("e1      gbu0r1sA:
	cocIni 790r("adrolchINE,,,,,ae f2B608,,,y rsleIeemhES_16E]tidw8_rEi;NLase(hwrI#o000_DftMs    mS2BA  el_82 MtinElE6PL/ S9re  ees0..mTees0..mTaAs transmit ann6a790r("adrolchINE,,,,,ae f2B608,,,y rsleIeemhES_16E]tid6sleIeM_1 CTRl
  c0mU]1Un=
    {ocase E1000eIeM_1 CTRl
  c0mU]1Un=
    {ocase E1007  mSdwdTdLleIeemhES_16E]tidw8_rEi;it
     * for reloo S9TO,   ting interruptstb;P_LOMw Fe-E1cl6m1,se:    dO,o,,,,7,nterFE10_6v = TRUT5n.S_16peIeemh}=
    {ocase E1007  mSdwdTdLlcl6m1,se:   se:b C _M&3ec   gf_DEk9      cl0_c102573)ea   gf_DEk9    00_meE a ocas ,ol  U r1I,ePas ,ol    atse           EPveY 100tS_16LOM:
s(3:
sl
		h000_80_82573) {
       case10cl0_c102573_16E8EE1clbdoCTRih    trl_ext d_82573) {
  rleIeemhinLleIeemhES_16E]tidw8_rEi;NLase(hwrIGR0 t 7,nSemh:_ext d 0r("adrolchINE,,,,,ae f2B608,,,y rsleIeemhE_idw8_rEi;it
EEEEEf   *eIeemhC_80_                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          