/* ----------------------------------------------------------------------- *
 *
 *   Copyright 2007-2008 H. Peter Anvin - All Rights Reserved
 *
 *   Permission is hereby granted, free of charge, to any person
 *   obtaining a copy of this software and associated documentation
 *   files (the "Software"), to deal in the Software without
 *   restriction, including without limitation the rights to use,
 *   copy, modify, merge, publish, distribute, sublicense, and/or
 *   sell copies of the Software, and to permit persons to whom
 *   the Software is furnished to do so, subject to the following
 *   conditions:
 *
 *   The above copyright notice and this permission notice shall
 *   be included in all copies or substantial portions of the Software.
 *
 *   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 *   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 *   OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 *   NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 *   HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 *   WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 *   FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 *   OTHER DEALINGS IN THE SOFTWARE.
 *
 * ----------------------------------------------------------------------- */

/*
 * linux.c
 *
 * Sample module to load Linux kernels.  This module can also create
 * a file out of the DHCP return data if running under PXELINUX.
 *
 * If -dhcpinfo is specified, the DHCP info is written into the file
 * /dhcpinfo.dat in the initramfs.
 *
 * Usage: linux.c32 [-dhcpinfo] kernel arguments...
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <console.h>
#include <syslinux/loadfile.h>
#include <syslinux/linux.h>
#include <syslinux/pxe.h>

const char *progname = "linux.c32";

/* Find the last instance of a particular command line argument
   (which should include the final =; do not use for boolean arguments) */
static char *find_argument(char **argv, const char *argument)
{
  int la = strlen(argument);
  char **arg;
  char *ptr = NULL;

  for (arg = argv; *arg; arg++) {
    if (!memcmp(*arg, argument, la))
      ptr = *arg + la;
  }

  return ptr;
}

/* Stitch together the command line from a set of argv's */
static char *make_cmdline(char **argv)
{
  char **arg;
  size_t bytes;
  char *cmdline, *p;

  bytes = 1;			/* Just in case we have a zero-entry cmdline */
  for (arg = argv; *arg; arg++) {
    bytes += strlen(*arg)+1;
  }

  p = cmdline = malloc(bytes);
  if (!cmdline)
    return NULL;

  for (arg = argv; *arg; arg++) {
    int len = strlen(*arg);
    memcpy(p, *arg, len);
    p[len] = ' ';
    p += len+1;
  }

  if (p > cmdline)
    p--;			/* Remove the last space */
  *p = '\0';

  return cmdline;
}

int main(int argc, char *argv[])
{
  const char *kernel_name;
  struct initramfs *initramfs;
  char *cmdline;
  char *boot_image;
  void *kernel_data;
  size_t kernel_len;
  int opt_dhcpinfo = 0;
  void *dhcpdata;
  size_t dhcplen;
  char **argp, *arg, *p;

  openconsole(&dev_null_r, &dev_stdcon_w);

  (void)argc;
  argp = argv+1;

  while ((arg = *argp) && arg[0] == '-') {
    if (!strcmp("-dhcpinfo", arg)) {
      opt_dhcpinfo = 1;
    } else {
      fprintf(stderr, "%s: unknown option: %s\n", progname, arg);
      return 1;
    }
    argp++;
  }

  if (!arg) {
    fprintf(stderr, "%s: missing kernel name\n", progname);
    return 1;
  }

  kernel_name = arg;

  printf("Loading %s... ", kernel_name);
  if (loadfile(kernel_name, &kernel_data, &kernel_len)) {
    printf("failed!\n");
    goto bailument, d*argp, * uSe\n", progname)t iurnel_natoduAGl_n)"d%ETl_n+_natr"d%Ee,  )rp = 1oO)rping } else {Nurgp) &PI%ETl_R printf(int_n)"d%ETl_Roc(bytes);
      reFng } eawLr"d%Ee,  )%ETingl_nEe,  )!stryrnl Re  int   retu goto bailvWAB "SP inwXDtnt     fprintf(_ todptrgl_nEe,  profo", arg)  inwpC.enl R} in eRargp, * pDe", progname);
    re}.enNpehe}.enNpehe
2e,Vv), sole(&deR plfor (arg = areY+dA(!cmdlg; arg++ eaname)l"_re}.eleaname)a}nt     5,d_lntf(Vv), RPT;
      reFng } IRlea}nt   fo &#R} in eRae f ,	m =)Fngl_RmO cng   plfor RRe&oO)rpin&C,]nc_(e
2etu =Rlea}nt   fo]nc_(e
2?d;
  p%t of argv's *(g,Rlesole  ,llea}ntOrg+ltKg } IRlouat mae
2engl_f argv'/
lntf(VS_m"_Hn {
_m"_H Nsyslinux/linux.hp arg=   ;r * D P M ING enNp:Ngl_[e UsSEe,  )%ETingldR)} IRlouat EenNpNn: %s\n", ip arg= a
  pla_ IRlouate
2sepp ,p = Rlou;

  (v2se UsSEe,cng   plcaon: 


 Rles DA

)"d%"adfilo bCK plaOEey, mr"d%Ee,  )%ETingpPyA[ els&;CAansreLAGAoAaon: 


=
  +Ainu
)" initramfs.
A

)"d%"aA7sib                                                                                                                                                                                                                                                                                                                                                        