#ifndef A3XX_XML
#define A3XX_XML

/* Autogenerated file, DO NOT EDIT manually!

This file was generated by the rules-ng-ng headergen tool in this git repository:
http://github.com/freedreno/envytools/
git clone https://github.com/freedreno/envytools.git

The rules-ng-ng source files this header was generated from are:
- /home/robclark/src/freedreno/envytools/rnndb/adreno.xml               (    364 bytes, from 2013-11-30 14:47:15)
- /home/robclark/src/freedreno/envytools/rnndb/freedreno_copyright.xml  (   1453 bytes, from 2013-03-31 16:51:27)
- /home/robclark/src/freedreno/envytools/rnndb/adreno/a2xx.xml          (  32840 bytes, from 2014-01-05 14:44:21)
- /home/robclark/src/freedreno/envytools/rnndb/adreno/adreno_common.xml (   9009 bytes, from 2014-01-11 16:56:35)
- /home/robclark/src/freedreno/envytools/rnndb/adreno/adreno_pm4.xml    (  12362 bytes, from 2014-01-07 14:47:36)
- /home/robclark/src/freedreno/envytools/rnndb/adreno/a3xx.xml          (  55460 bytes, from 2014-01-14 23:57:14)
- /home/robclark/src/freedreno/envytools/rnndb/adreno/a4xx.xml          (   8344 bytes, from 2013-11-30 14:49:47)

Copyright (C) 2013-2014 by the following authors:
- Rob Clark <robdclark@gmail.com> (robclark)

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice (including the
next paragraph) shall be included in all copies or substantial
portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE COPYRIGHT OWNER(S) AND/OR ITS SUPPLIERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/


enum a3xx_render_mode {
	RB_RENDERING_PASS = 0,
	RB_TILING_PASS = 1,
	RB_RESOLVE_PASS = 2,
};

enum a3xx_tile_mode {
	LINEAR = 0,
	TILE_32X32 = 2,
};

enum a3xx_threadmode {
	MULTI = 0,
	SINGLE = 1,
};

enum a3xx_instrbuffermode {
	BUFFER = 1,
};

enum a3xx_threadsize {
	TWO_QUADS = 0,
	FOUR_QUADS = 1,
};

enum a3xx_state_block_id {
	HLSQ_BLOCK_ID_TP_TEX = 2,
	HLSQ_BLOCK_ID_TP_MIPMAP = 3,
	HLSQ_BLOCK_ID_SP_VS = 4,
	HLSQ_BLOCK_ID_SP_FS = 6,
};

enum a3xx_cache_opcode {
	INVALIDATE = 1,
};

enum a3xx_vtx_fmt {
	VFMT_FLOAT_32 = 0,
	VFMT_FLOAT_32_32 = 1,
	VFMT_FLOAT_32_32_32 = 2,
	VFMT_FLOAT_32_32_32_32 = 3,
	VFMT_FLOAT_16 = 4,
	VFMT_FLOAT_16_16 = 5,
	VFMT_FLOAT_16_16_16 = 6,
	VFMT_FLOAT_16_16_16_16 = 7,
	VFMT_FIXED_32 = 8,
	VFMT_FIXED_32_32 = 9,
	VFMT_FIXED_32_32_32 = 10,
	VFMT_FIXED_32_32_32_32 = 11,
	VFMT_SHORT_16 = 16,
	VFMT_SHORT_16_16 = 17,
	VFMT_SHORT_16_16_16 = 18,
	VFMT_SHORT_16_16_16_16 = 19,
	VFMT_USHORT_16 = 20,
	VFMT_USHORT_16_16 = 21,
	VFMT_USHORT_16_16_16 = 22,
	VFMT_USHORT_16_16_16_16 = 23,
	VFMT_NORM_SHORT_16 = 24,
	VFMT_NORM_SHORT_16_16 = 25,
	VFMT_NORM_SHORT_16_16_16 = 26,
	VFMT_NORM_SHORT_16_16_16_16 = 27,
	VFMT_NORM_USHORT_16 = 28,
	VFMT_NORM_USHORT_16_16 = 29,
	VFMT_NORM_USHORT_16_16_16 = 30,
	VFMT_NORM_USHORT_16_16_16_16 = 31,
	VFMT_UBYTE_8 = 40,
	VFMT_UBYTE_8_8 = 41,
	VFMT_UBYTE_8_8_8 = 42,
	VFMT_UBYTE_8_8_8_8 = 43,
	VFMT_NORM_UBYTE_8 = 44,
	VFMT_NORM_UBYTE_8_8 = 45,
	VFMT_NORM_UBYTE_8_8_8 = 46,
	VFMT_NORM_UBYTE_8_8_8_8 = 47,
	VFMT_BYTE_8 = 48,
	VFMT_BYTE_8_8 = 49,
	VFMT_BYTE_8_8_8 = 50,
	VFMT_BYTE_8_8_8_8 = 51,
	VFMT_NORM_BYTE_8 = 52,
	VFMT_NORM_BYTE_8_8 = 53,
	VFMT_NORM_BYTE_8_8_8 = 54,
	VFMT_NORM_BYTE_8_8_8_8 = 55,
	VFMT_UINT_10_10_10_2 = 60,
	VFMT_NORM_UINT_10_10_10_2 = 61,
	VFMT_INT_10_10_10_2 = 62,
	VFMT_NORM_INT_10_10_10_2 = 63,
};

enum a3xx_tex_fmt {
	TFMT_NORM_USHORT_565 = 4,
	TFMT_NORM_USHORT_5551 = 6,
	TFMT_NORM_USHORT_4444 = 7,
	TFMT_NORM_UINT_X8Z24 = 10,
	TFMT_NORM_UINT_NV12_UV_TILED = 17,
	TFMT_NORM_UINT_NV12_Y_TILED = 19,
	TFMT_NORM_UINT_NV12_UV = 21,
	TFMT_NORM_UINT_NV12_Y = 23,
	TFMT_NORM_UINT_I420_Y = 24,
	TFMT_NORM_UINT_I420_U = 26,
	TFMT_NORM_UINT_I420_V = 27,
	TFMT_NORM_UINT_2_10_10_10 = 41,
	TFMT_NORM_UINT_A8 = 44,
	TFMT_NORM_UINT_L8_A8 = 47,
	TFMT_NORM_UINT_8 = 48,
	TFMT_NORM_UINT_8_8 = 49,
	TFMT_NORM_UINT_8_8_8 = 50,
	TFMT_NORM_UINT_8_8_8_8 = 51,
	TFMT_FLOAT_16 = 64,
	TFMT_FLOAT_16_16 = 65,
	TFMT_FLOAT_16_16_16_16 = 67,
	TFMT_FLOAT_32 = 84,
	TFMT_FLOAT_32_32 = 85,
	TFMT_FLOAT_32_32_32_32 = 87,
};

enum a3xx_tex_fetchsize {
	TFETCH_DISABLE = 0,
	TFETCH_1_BYTE = 1,
	TFETCH_2_BYTE = 2,
	TFETCH_4_BYTE = 3,
	TFETCH_8_BYTE = 4,
	TFETCH_16_BYTE = 5,
};

enum a3xx_color_fmt {
	RB_R8G8B8_UNORM = 4,
	RB_R8G8B8A8_UNORM = 8,
	RB_Z16_UNORM = 12,
	RB_A8_UNORM = 20,
};

enum a3xx_color_swap {
	WZYX = 0,
	WXYZ = 1,
	ZYXW = 2,
	XYZW = 3,
};

enum a3xx_msaa_samples {
	MSAA_ONE = 0,
	MSAA_TWO = 1,
	MSAA_FOUR = 2,
};

enum a3xx_sp_perfcounter_select {
	SP_FS_CFLOW_INSTRUCTIONS = 12,
	SP_FS_FULL_ALU_INSTRUCTIONS = 14,
	SP0_ICL1_MISSES = 26,
	SP_ALU_ACTIVE_CYCLES = 29,
};

enum a3xx_rop_code {
	ROP_CLEAR = 0,
	ROP_NOR = 1,
	ROP_AND_INVERTED = 2,
	ROP_COPY_INVERTED = 3,
	ROP_AND_REVERSE = 4,
	ROP_INVERT = 5,
	ROP_XOR = 6,
	ROP_NAND = 7,
	ROP_AND = 8,
	ROP_EQUIV = 9,
	ROP_NOOP = 10,
	ROP_OR_INVERTED = 11,
	ROP_COPY = 12,
	ROP_OR_REVERSE = 13,
	ROP_OR = 14,
	ROP_SET = 15,
};

enum adreno_rb_copy_control_mode {
	RB_COPY_RESOLVE = 1,
	RB_COPY_DEPTH_STENCIL = 5,
};

enum a3xx_tex_filter {
	A3XX_TEX_NEAREST = 0,
	A3XX_TEX_LINEAR = 1,
};

enum a3xx_tex_clamp {
	A3XX_TEX_REPEAT = 0,
	A3XX_TEX_CLAMP_TO_EDGE = 1,
	A3XX_TEX_MIRROR_REPEAT = 2,
	A3XX_TEX_CLAMP_NONE = 3,
};

enum a3xx_tex_swiz {
	A3XX_TEX_X = 0,
	A3XX_TEX_Y = 1,
	A3XX_TEX_Z = 2,
	A3XX_TEX_W = 3,
	A3XX_TEX_ZERO = 4,
	A3XX_TEX_ONE = 5,
};

enum a3xx_tex_type {
	A3XX_TEX_1D = 0,
	A3XX_TEX_2D = 1,
	A3XX_TEX_CUBE = 2,
	A3XX_TEX_3D = 3,
};

#define A3XX_INT0_RBBM_GPU_IDLE					0x00000001
#define A3XX_INT0_RBBM_AHB_ERROR				0x00000002
#define A3XX_INT0_RBBM_REG_TIMEOUT				0x00000004
#define A3XX_INT0_RBBM_ME_MS_TIMEOUT				0x00000008
#define A3XX_INT0_RBBM_PFP_MS_TIMEOUT				0x00000010
#define A3XX_INT0_RBBM_ATB_BUS_OVERFLOW				0x00000020
#define A3XX_INT0_VFD_ERROR					0x00000040
#define A3XX_INT0_CP_SW_INT					0x00000080
#define A3XX_INT0_CP_T0_PACKET_IN_IB				0x00000100
#define A3XX_INT0_CP_OPCODE_ERROR				0x00000200
#define A3XX_INT0_CP_RESERVED_BIT_ERROR				0x00000400
#define A3XX_INT0_CP_HW_FAULT					0x00000800
#define A3XX_INT0_CP_DMA					0x00001000
#define A3XX_INT0_CP_IB2_INT					0x00002000
#define A3XX_INT0_CP_IB1_INT					0x00004000
#define A3XX_INT0_CP_RB_INT					0x00008000
#define A3XX_INT0_CP_REG_PROTECT_FAULT				0x00010000
#define A3XX_INT0_CP_RB_DONE_TS					0x00020000
#define A3XX_INT0_CP_VS_DONE_TS					0x00040000
#define A3XX_INT0_CP_PS_DONE_TS					0x00080000
#define A3XX_INT0_CACHE_FLUSH_TS				0x00100000
#define A3XX_INT0_CP_AHB_ERROR_HALT				0x00200000
#define A3XX_INT0_MISC_HANG_DETECT				0x01000000
#define A3XX_INT0_UCHE_OOB_ACCESS				0x02000000
#define REG_A3XX_RBBM_HW_VERSION				0x00000000

#define REG_A3XX_RBBM_HW_RELEASE				0x00000001

#define REG_A3XX_RBBM_HW_CONFIGURATION				0x00000002

#define REG_A3XX_RBBM_CLOCK_CTL					0x00000010

#define REG_A3XX_RBBM_SP_HYST_CNT				0x00000012

#define REG_A3XX_RBBM_SW_RESET_CMD				0x00000018

#define REG_A3XX_RBBM_AHB_CTL0					0x00000020

#define REG_A3XX_RBBM_AHB_CTL1					0x00000021

#define REG_A3XX_RBBM_AHB_CMD					0x00000022

#define REG_A3XX_RBBM_AHB_ERROR_STATUS				0x00000027

#define REG_A3XX_RBBM_GPR0_CTL					0x0000002e

#define REG_A3XX_RBBM_STATUS					0x00000030
#define A3XX_RBBM_STATUS_HI_BUSY				0x00000001
#define A3XX_RBBM_STATUS_CP_ME_BUSY				0x00000002
#define A3XX_RBBM_STATUS_CP_PFP_BUSY				0x00000004
#define A3XX_RBBM_STATUS_CP_NRT_BUSY				0x00004000
#define A3XX_RBBM_STATUS_VBIF_BUSY				0x00008000
#define A3XX_RBBM_STATUS_TSE_BUSY				0x00010000
#define A3XX_RBBM_STATUS_RAS_BUSY				0x00020000
#define A3XX_RBBM_STATUS_RB_BUSY				0x00040000
#define A3XX_RBBM_STATUS_PC_DCALL_BUSY				0x00080000
#define A3XX_RBBM_STATUS_PC_VSD_BUSY				0x00100000
#define A3XX_RBBM_STATUS_VFD_BUSY				0x00200000
#define A3XX_RBBM_STATUS_VPC_BUSY				0x00400000
#define A3XX_RBBM_STATUS_UCHE_BUSY				0x00800000
#define A3XX_RBBM_STATUS_SP_BUSY				0x01000000
#define A3XX_RBBM_STATUS_TPL1_BUSY				0x02000000
#define A3XX_RBBM_STATUS_MARB_BUSY				0x04000000
#define A3XX_RBBM_STATUS_VSC_BUSY				0x08000000
#define A3XX_RBBM_STATUS_ARB_BUSY				0x10000000
#define A3XX_RBBM_STATUS_HLSQ_BUSY				0x20000000
#define A3XX_RBBM_STATUS_GPU_BUSY_NOHC				0x40000000
#define A3XX_RBBM_STATUS_GPU_BUSY				0x80000000

#define REG_A3XX_RBBM_NQWAIT_UNTIL				0x00000040

#define REG_A3XX_RBBM_WAIT_IDLE_CLOCKS_CTL			0x00000033

#define REG_A3XX_RBBM_INTERFACE_HANG_INT_CTL			0x00000050

#define REG_A3XX_RBBM_INTERFACE_HANG_MASK_CTL0			0x00000051

#define REG_A3XX_RBBM_INTERFACE_HANG_MASK_CTL1			0x00000054

#define REG_A3XX_RBBM_INTERFACE_HANG_MASK_CTL2			0x00000057

#define REG_A3XX_RBBM_INTERFACE_HANG_MASK_CTL3			0x0000005a

#define REG_A3XX_RBBM_INT_SET_CMD				0x00000060

#define REG_A3XX_RBBM_INT_CLEAR_CMD				0x00000061

#define REG_A3XX_RBBM_INT_0_MASK				0x00000063

#define REG_A3XX_RBBM_INT_0_STATUS				0x00000064

#define REG_A3XX_RBBM_PERFCTR_CTL				0x00000080

#define REG_A3XX_RBBM_PERFCTR_LOAD_CMD0				0x00000081

#define REG_A3XX_RBBM_PERFCTR_LOAD_CMD1				0x00000082

#define REG_A3XX_RBBM_PERFCTR_LOAD_VALUE_LO			0x00000084

#define REG_A3XX_RBBM_PERFCTR_LOAD_VALUE_HI			0x00000085

#define REG_A3XX_RBBM_PERFCOUNTER0_SELECT			0x00000086

#define REG_A3XX_RBBM_PERFCOUNTER1_SELECT			0x00000087

#define REG_A3XX_RBBM_GPU_BUSY_MASKED				0x00000088

#define REG_A3XX_RBBM_PERFCTR_CP_0_LO				0x00000090

#define REG_A3XX_RBBM_PERFCTR_CP_0_HI				0x00000091

#define REG_A3XX_RBBM_PERFCTR_RBBM_0_LO				0x00000092

#define REG_A3XX_RBBM_PERFCTR_RBBM_0_HI				0x00000093

#define REG_A3XX_RBBM_PERFCTR_RBBM_1_LO				0x00000094

#define REG_A3XX_RBBM_PERFCTR_RBBM_1_HI				0x00000095

#define REG_A3XX_RBBM_PERFCTR_PC_0_LO				0x00000096

#define REG_A3XX_RBBM_PERFCTR_PC_0_HI				0x00000097

#define REG_A3XX_RBBM_PERFCTR_PC_1_LO				0x00000098

#define REG_A3XX_RBBM_PERFCTR_PC_1_HI				0x00000099

#define REG_A3XX_RBBM_PERFCTR_PC_2_LO				0x0000009a

#define REG_A3XX_RBBM_PERFCTR_PC_2_HI				0x0000009b

#define REG_A3XX_RBBM_PERFCTR_PC_3_LO				0x0000009c

#define REG_A3XX_RBBM_PERFCTR_PC_3_HI				0x0000009d

#define REG_A3XX_RBBM_PERFCTR_VFD_0_LO				0x0000009e

#define REG_A3XX_RBBM_PERFCTR_VFD_0_HI				0x0000009f

#define REG_A3XX_RBBM_PERFCTR_VFD_1_LO				0x000000a0

#define REG_A3XX_RBBM_PERFCTR_VFD_1_HI				0x000000a1

#define REG_A3XX_RBBM_PERFCTR_HLSQ_0_LO				0x000000a2

#define REG_A3XX_RBBM_PERFCTR_HLSQ_0_HI				0x000000a3

#define REG_A3XX_RBBM_PERFCTR_HLSQ_1_LO				0x000000a4

#define REG_A3XX_RBBM_PERFCTR_HLSQ_1_HI				0x000000a5

#define REG_A3XX_RBBM_PERFCTR_HLSQ_2_LO				0x000000a6

#define REG_A3XX_RBBM_PERFCTR_HLSQ_2_HI				0x000000a7

#define REG_A3XX_RBBM_PERFCTR_HLSQ_3_LO				0x000000a8

#define REG_A3XX_RBBM_PERFCTR_HLSQ_3_HI				0x000000a9

#define REG_A3XX_RBBM_PERFCTR_HLSQ_4_LO				0x000000aa

#define REG_A3XX_RBBM_PERFCTR_HLSQ_4_HI				0x000000ab

#define REG_A3XX_RBBM_PERFCTR_HLSQ_5_LO				0x000000ac

#define REG_A3XX_RBBM_PERFCTR_HLSQ_5_HI				0x000000ad

#define REG_A3XX_RBBM_PERFCTR_VPC_0_LO				0x000000ae

#define REG_A3XX_RBBM_PERFCTR_VPC_0_HI				0x000000af

#define REG_A3XX_RBBM_PERFCTR_VPC_1_LO				0x000000b0

#define REG_A3XX_RBBM_PERFCTR_VPC_1_HI				0x000000b1

#define REG_A3XX_RBBM_PERFCTR_TSE_0_LO				0x000000b2

#define REG_A3XX_RBBM_PERFCTR_TSE_0_HI				0x000000b3

#define REG_A3XX_RBBM_PERFCTR_TSE_1_LO				0x000000b4

#define REG_A3XX_RBBM_PERFCTR_TSE_1_HI				0x000000b5

#define REG_A3XX_RBBM_PERFCTR_RAS_0_LO				0x000000b6

#define REG_A3XX_RBBM_PERFCTR_RAS_0_HI				0x000000b7

#define REG_A3XX_RBBM_PERFCTR_RAS_1_LO				0x000000b8

#define REG_A3XX_RBBM_PERFCTR_RAS_1_HI				0x000000b9

#define REG_A3XX_RBBM_PERFCTR_UCHE_0_LO				0x000000ba

#define REG_A3XX_RBBM_PERFCTR_UCHE_0_HI				0x000000bb

#define REG_A3XX_RBBM_PERFCTR_UCHE_1_LO				0x000000bc

#define REG_A3XX_RBBM_PERFCTR_UCHE_1_HI				0x000000bd

#define REG_A3XX_RBBM_PERFCTR_UCHE_2_LO				0x000000be

#define REG_A3XX_RBBM_PERFCTR_UCHE_2_HI				0x000000bf

#define REG_A3XX_RBBM_PERFCTR_UCHE_3_LO				0x000000c0

#define REG_A3XX_RBBM_PERFCTR_UCHE_3_HI				0x000000c1

#define REG_A3XX_RBBM_PERFCTR_UCHE_4_LO				0x000000c2

#define REG_A3XX_RBBM_PERFCTR_UCHE_4_HI				0x000000c3

#define REG_A3XX_RBBM_PERFCTR_UCHE_5_LO				0x000000c4

#define REG_A3XX_RBBM_PERFCTR_UCHE_5_HI				0x000000c5

#define REG_A3XX_RBBM_PERFCTR_TP_0_LO				0x000000c6

#define REG_A3XX_RBBM_PERFCTR_TP_0_HI				0x000000c7

#define REG_A3XX_RBBM_PERFCTR_TP_1_LO				0x000000c8

#define REG_A3XX_RBBM_PERFCTR_TP_1_HI				0x000000c9

#define REG_A3XX_RBBM_PERFCTR_TP_2_LO				0x000000ca

#define REG_A3XX_RBBM_PERFCTR_TP_2_HI				0x000000cb

#define REG_A3XX_RBBM_PERFCTR_TP_3_LO				0x000000cc

#define REG_A3XX_RBBM_PERFCTR_TP_3_HI				0x000000cd

#define REG_A3XX_RBBM_PERFCTR_TP_4_LO				0x000000ce

#define REG_A3XX_RBBM_PERFCTR_TP_4_HI				0x000000cf

#define REG_A3XX_RBBM_PERFCTR_TP_5_LO				0x000000d0

#define REG_A3XX_RBBM_PERFCTR_TP_5_HI				0x000000d1

#define REG_A3XX_RBBM_PERFCTR_SP_0_LO				0x000000d2

#define REG_A3XX_RBBM_PERFCTR_SP_0_HI				0x000000d3

#define REG_A3XX_RBBM_PERFCTR_SP_1_LO				0x000000d4

#define REG_A3XX_RBBM_PERFCTR_SP_1_HI				0x000000d5

#define REG_A3XX_RBBM_PERFCTR_SP_2_LO				0x000000d6

#define REG_A3XX_RBBM_PERFCTR_SP_2_HI				0x000000d7

#define REG_A3XX_RBBM_PERFCTR_SP_3_LO				0x000000d8

#define REG_A3XX_RBBM_PERFCTR_SP_3_HI				0x000000d9

#define REG_A3XX_RBBM_PERFCTR_SP_4_LO				0x000000da

#define REG_A3XX_RBBM_PERFCTR_SP_4_HI				0x000000db

#define REG_A3XX_RBBM_PERFCTR_SP_5_LO				0x000000dc

#define REG_A3XX_RBBM_PERFCTR_SP_5_HI				0x000000dd

#define REG_A3XX_RBBM_PERFCTR_SP_6_LO				0x000000de

#define REG_A3XX_RBBM_PERFCTR_SP_6_HI				0x000000df

#define REG_A3XX_RBBM_PERFCTR_SP_7_LO				0x000000e0

#define REG_A3XX_RBBM_PERFCTR_SP_7_HI				0x000000e1

#define REG_A3XX_RBBM_PERFCTR_RB_0_LO				0x000000e2

#define REG_A3XX_RBBM_PERFCTR_RB_0_HI				0x000000e3

#define REG_A3XX_RBBM_PERFCTR_RB_1_LO				0x000000e4

#define REG_A3XX_RBBM_PERFCTR_RB_1_HI				0x000000e5

#define REG_A3XX_RBBM_PERFCTR_PWR_0_LO				0x000000ea

#define REG_A3XX_RBBM_PERFCTR_PWR_0_HI				0x000000eb

#define REG_A3XX_RBBM_PERFCTR_PWR_1_LO				0x000000ec

#define REG_A3XX_RBBM_PERFCTR_PWR_1_HI				0x000000ed

#define REG_A3XX_RBBM_RBBM_CTL					0x00000100

#define REG_A3XX_RBBM_DEBUG_BUS_CTL				0x00000111

#define REG_A3XX_RBBM_DEBUG_BUS_DATA_STATUS			0x00000112

#define REG_A3XX_CP_PFP_UCODE_ADDR				0x000001c9

#define REG_A3XX_CP_PFP_UCODE_DATA				0x000001ca

#define REG_A3XX_CP_ROQ_ADDR					0x000001cc

#define REG_A3XX_CP_ROQ_DATA					0x000001cd

#define REG_A3XX_CP_MERCIU_ADDR					0x000001d1

#define REG_A3XX_CP_MERCIU_DATA					0x000001d2

#define REG_A3XX_CP_MERCIU_DATA2				0x000001d3

#define REG_A3XX_CP_MEQ_ADDR					0x000001da

#define REG_A3XX_CP_MEQ_DATA					0x000001db

#define REG_A3XX_CP_PERFCOUNTER_SELECT				0x00000445

#define REG_A3XX_CP_HW_FAULT					0x0000045c

#define REG_A3XX_CP_PROTECT_CTRL				0x0000045e

#define REG_A3XX_CP_PROTECT_STATUS				0x0000045f

static inline uint32_t REG_A3XX_CP_PROTECT(uint32_t i0) { return 0x00000460 + 0x1*i0; }

static inline uint32_t REG_A3XX_CP_PROTECT_REG(uint32_t i0) { return 0x00000460 + 0x1*i0; }

#define REG_A3XX_CP_AHB_FAULT					0x0000054d

#define REG_A3XX_GRAS_CL_CLIP_CNTL				0x00002040
#define A3XX_GRAS_CL_CLIP_CNTL_IJ_PERSP_CENTER			0x00001000
#define A3XX_GRAS_CL_CLIP_CNTL_CLIP_DISABLE			0x00010000
#define A3XX_GRAS_CL_CLIP_CNTL_ZFAR_CLIP_DISABLE		0x00020000
#define A3XX_GRAS_CL_CLIP_CNTL_VP_CLIP_CODE_IGNORE		0x00080000
#define A3XX_GRAS_CL_CLIP_CNTL_VP_XFORM_DISABLE			0x00100000
#define A3XX_GRAS_CL_CLIP_CNTL_PERSP_DIVISION_DISABLE		0x00200000
#define A3XX_GRAS_CL_CLIP_CNTL_ZCLIP_DISABLE			0x02000000

#define REG_A3XX_GRAS_CL_GB_CLIP_ADJ				0x00002044
#define A3XX_GRAS_CL_GB_CLIP_ADJ_HORZ__MASK			0x000003ff
#define A3XX_GRAS_CL_GB_CLIP_ADJ_HORZ__SHIFT			0
static inline uint32_t A3XX_GRAS_CL_GB_CLIP_ADJ_HORZ(uint32_t val)
{
	return ((val) << A3XX_GRAS_CL_GB_CLIP_ADJ_HORZ__SHIFT) & A3XX_GRAS_CL_GB_CLIP_ADJ_HORZ__MASK;
}
#define A3XX_GRAS_CL_GB_CLIP_ADJ_VERT__MASK			0x000ffc00
#define A3XX_GRAS_CL_GB_CLIP_ADJ_VERT__SHIFT			10
static inline uint32_t A3XX_GRAS_CL_GB_CLIP_ADJ_VERT(uint32_t val)
{
	return ((val) << A3XX_GRAS_CL_GB_CLIP_ADJ_VERT__SHIFT) & A3XX_GRAS_CL_GB_CLIP_ADJ_VERT__MASK;
}

#define REG_A3XX_GRAS_CL_VPORT_XOFFSET				0x00002048
#define A3XX_GRAS_CL_VPORT_XOFFSET__MASK			0xffffffff
#define A3XX_GRAS_CL_VPORT_XOFFSET__SHIFT			0
static inline uint32_t A3XX_GRAS_CL_VPORT_XOFFSET(float val)
{
	return ((fui(val)) << A3XX_GRAS_CL_VPORT_XOFFSET__SHIFT) & A3XX_GRAS_CL_VPORT_XOFFSET__MASK;
}

#define REG_A3XX_GRAS_CL_VPORT_XSCALE				0x00002049
#define A3XX_GRAS_CL_VPORT_XSCALE__MASK				0xffffffff
#define A3XX_GRAS_CL_VPORT_XSCALE__SHIFT			0
static inline uint32_t A3XX_GRAS_CL_VPORT_XSCALE(float val)
{
	return ((fui(val)) << A3XX_GRAS_CL_VPORT_XSCALE__SHIFT) & A3XX_GRAS_CL_VPORT_XSCALE__MASK;
}

#define REG_A3XX_GRAS_CL_VPORT_YOFFSET				0x0000204a
#define A3XX_GRAS_CL_VPORT_YOFFSET__MASK			0xffffffff
#define A3XX_GRAS_CL_VPORT_YOFFSET__SHIFT			0
static inline uint32_t A3XX_GRAS_CL_VPORT_YOFFSET(float val)
{
	return ((fui(val)) << A3XX_GRAS_CL_VPORT_YOFFSET__SHIFT) & A3XX_GRAS_CL_VPORT_YOFFSET__MASK;
}

#define REG_A3XX_GRAS_CL_VPORT_YSCALE				0x0000204b
#define A3XX_GRAS_CL_VPORT_YSCALE__MASK				0xffffffff
#define A3XX_GRAS_CL_VPORT_YSCALE__SHIFT			0
static inline uint32_t A3XX_GRAS_CL_VPORT_YSCALE(float val)
{
	return ((fui(val)) << A3XX_GRAS_CL_VPORT_YSCALE__SHIFT) & A3XX_GRAS_CL_VPORT_YSCALE__MASK;
}

#define REG_A3XX_GRAS_CL_VPORT_ZOFFSET				0x0000204c
#define A3XX_GRAS_CL_VPORT_ZOFFSET__MASK			0xffffffff
#define A3XX_GRAS_CL_VPORT_ZOFFSET__SHIFT			0
static inline uint32_t A3XX_GRAS_CL_VPORT_ZOFFSET(float val)
{
	return ((fui(val)) << A3XX_GRAS_CL_VPORT_ZOFFSET__SHIFT) & A3XX_GRAS_CL_VPORT_ZOFFSET__MASK;
}

#define REG_A3XX_GRAS_CL_VPORT_ZSCALE				0x0000204d
#define A3XX_GRAS_CL_VPORT_ZSCALE__MASK				0xffffffff
#define A3XX_GRAS_CL_VPORT_ZSCALE__SHIFT			0
static inline uint32_t A3XX_GRAS_CL_VPORT_ZSCALE(float val)
{
	return ((fui(val)) << A3XX_GRAS_CL_VPORT_ZSCALE__SHIFT) & A3XX_GRAS_CL_VPORT_ZSCALE__MASK;
}

#define REG_A3XX_GRAS_SU_POINT_MINMAX				0x00002068

#define REG_A3XX_GRAS_SU_POINT_SIZE				0x00002069

#define REG_A3XX_GRAS_SU_POLY_OFFSET_SCALE			0x0000206c
#define A3XX_GRAS_SU_POLY_OFFSET_SCALE_VAL__MASK		0x00ffffff
#define A3XX_GRAS_SU_POLY_OFFSET_SCALE_VAL__SHIFT		0
static inline uint32_t A3XX_GRAS_SU_POLY_OFFSET_SCALE_VAL(float val)
{
	return ((((uint32_t)(val * 40.0))) << A3XX_GRAS_SU_POLY_OFFSET_SCALE_VAL__SHIFT) & A3XX_GRAS_SU_POLY_OFFSET_SCALE_VAL__MASK;
}

#define REG_A3XX_GRAS_SU_POLY_OFFSET_OFFSET			0x0000206d
#define A3XX_GRAS_SU_POLY_OFFSET_OFFSET__MASK			0xffffffff
#define A3XX_GRAS_SU_POLY_OFFSET_OFFSET__SHIFT			0
static inline uint32_t A3XX_GRAS_SU_POLY_OFFSET_OFFSET(float val)
{
	return ((((uint32_t)(val * 44.0))) << A3XX_GRAS_SU_POLY_OFFSET_OFFSET__SHIFT) & A3XX_GRAS_SU_POLY_OFFSET_OFFSET__MASK;
}

#define REG_A3XX_GRAS_SU_MODE_CONTROL				0x00002070
#define A3XX_GRAS_SU_MODE_CONTROL_CULL_FRONT			0x00000001
#define A3XX_GRAS_SU_MODE_CONTROL_CULL_BACK			0x00000002
#define A3XX_GRAS_SU_MODE_CONTROL_FRONT_CW			0x00000004
#define A3XX_GRAS_SU_MODE_CONTROL_LINEHALFWIDTH__MASK		0x000007f8
#define A3XX_GRAS_SU_MODE_CONTROL_LINEHALFWIDTH__SHIFT		3
static inline uint32_t A3XX_GRAS_SU_MODE_CONTROL_LINEHALFWIDTH(float val)
{
	return ((((uint32_t)(val * 4.0))) << A3XX_GRAS_SU_MODE_CONTROL_LINEHALFWIDTH__SHIFT) & A3XX_GRAS_SU_MODE_CONTROL_LINEHALFWIDTH__MASK;
}
#define A3XX_GRAS_SU_MODE_CONTROL_POLY_OFFSET			0x00000800

#define REG_A3XX_GRAS_SC_CONTROL				0x00002072
#define A3XX_GRAS_SC_CONTROL_RENDER_MODE__MASK			0x000000f0
#define A3XX_GRAS_SC_CONTROL_RENDER_MODE__SHIFT			4
static inline uint32_t A3XX_GRAS_SC_CONTROL_RENDER_MODE(enum a3xx_render_mode val)
{
	return ((val) << A3XX_GRAS_SC_CONTROL_RENDER_MODE__SHIFT) & A3XX_GRAS_SC_CONTROL_RENDER_MODE__MASK;
}
#define A3XX_GRAS_SC_CONTROL_MSAA_SAMPLES__MASK			0x00000f00
#define A3XX_GRAS_SC_CONTROL_MSAA_SAMPLES__SHIFT		8
static inline uint32_t A3XX_GRAS_SC_CONTROL_MSAA_SAMPLES(enum a3xx_msaa_samples val)
{
	return ((val) << A3XX_GRAS_SC_CONTROL_MSAA_SAMPLES__SHIFT) & A3XX_GRAS_SC_CONTROL_MSAA_SAMPLES__MASK;
}
#define A3XX_GRAS_SC_CONTROL_RASTER_MODE__MASK			0x0000f000
#define A3XX_GRAS_SC_CONTROL_RASTER_MODE__SHIFT			12
static inline uint32_t A3XX_GRAS_SC_CONTROL_RASTER_MODE(uint32_t val)
{
	return ((val) << A3XX_GRAS_SC_CONTROL_RASTER_MODE__SHIFT) & A3XX_GRAS_SC_CONTROL_RASTER_MODE__MASK;
}

#define REG_A3XX_GRAS_SC_SCREEN_SCISSOR_TL			0x00002074
#define A3XX_GRAS_SC_SCREEN_SCISSOR_TL_WINDOW_OFFSET_DISABLE	0x80000000
#define A3XX_GRAS_SC_SCREEN_SCISSOR_TL_X__MASK			0x00007fff
#define A3XX_GRAS_SC_SCREEN_SCISSOR_TL_X__SHIFT			0
static inline uint32_t A3XX_GRAS_SC_SCREEN_SCISSOR_TL_X(uint32_t val)
{
	return ((val) << A3XX_GRAS_SC_SCREEN_SCISSOR_TL_X__SHIFT) & A3XX_GRAS_SC_SCREEN_SCISSOR_TL_X__MASK;
}
#define A3XX_GRAS_SC_SCREEN_SCISSOR_TL_Y__MASK			0x7fff0000
#define A3XX_GRAS_SC_SCREEN_SCISSOR_TL_Y__SHIFT			16
static inline uint32_t A3XX_GRAS_SC_SCREEN_SCISSOR_TL_Y(uint32_t val)
{
	return ((val) << A3XX_GRAS_SC_SCREEN_SCISSOR_TL_Y__SHIFT) & A3XX_GRAS_SC_SCREEN_SCISSOR_TL_Y__MASK;
}

#define REG_A3XX_GRAS_SC_SCREEN_SCISSOR_BR			0x00002075
#define A3XX_GRAS_SC_SCREEN_SCISSOR_BR_WINDOW_OFFSET_DISABLE	0x80000000
#define A3XX_GRAS_SC_SCREEN_SCISSOR_BR_X__MASK			0x00007fff
#define A3XX_GRAS_SC_SCREEN_SCISSOR_BR_X__SHIFT			0
static inline uint32_t A3XX_GRAS_SC_SCREEN_SCISSOR_BR_X(uint32_t val)
{
	return ((val) << A3XX_GRAS_SC_SCREEN_SCISSOR_BR_X__SHIFT) & A3XX_GRAS_SC_SCREEN_SCISSOR_BR_X__MASK;
}
#define A3XX_GRAS_SC_SCREEN_SCISSOR_BR_Y__MASK			0x7fff0000
#define A3XX_GRAS_SC_SCREEN_SCISSOR_BR_Y__SHIFT			16
static inline uint32_t A3XX_GRAS_SC_SCREEN_SCISSOR_BR_Y(uint32_t val)
{
	return ((val) << A3XX_GRAS_SC_SCREEN_SCISSOR_BR_Y__SHIFT) & A3XX_GRAS_SC_SCREEN_SCISSOR_BR_Y__MASK;
}

#define REG_A3XX_GRAS_SC_WINDOW_SCISSOR_TL			0x00002079
#define A3XX_GRAS_SC_WINDOW_SCISSOR_TL_WINDOW_OFFSET_DISABLE	0x80000000
#define A3XX_GRAS_SC_WINDOW_SCISSOR_TL_X__MASK			0x00007fff
#define A3XX_GRAS_SC_WINDOW_SCISSOR_TL_X__SHIFT			0
static inline uint32_t A3XX_GRAS_SC_WINDOW_SCISSOR_TL_X(uint32_t val)
{
	return ((val) << A3XX_GRAS_SC_WINDOW_SCISSOR_TL_X__SHIFT) & A3XX_GRAS_SC_WINDOW_SCISSOR_TL_X__MASK;
}
#define A3XX_GRAS_SC_WINDOW_SCISSOR_TL_Y__MASK			0x7fff0000
#define A3XX_GRAS_SC_WINDOW_SCISSOR_TL_Y__SHIFT			16
static inline uint32_t A3XX_GRAS_SC_WINDOW_SCISSOR_TL_Y(uint32_t val)
{
	return ((val) << A3XX_GRAS_SC_WINDOW_SCISSOR_TL_Y__SHIFT) & A3XX_GRAS_SC_WINDOW_SCISSOR_TL_Y__MASK;
}

#define REG_A3XX_GRAS_SC_WINDOW_SCISSOR_BR			0x0000207a
#define A3XX_GRAS_SC_WINDOW_SCISSOR_BR_WINDOW_OFFSET_DISABLE	0x80000000
#define A3XX_GRAS_SC_WINDOW_SCISSOR_BR_X__MASK			0x00007fff
#define A3XX_GRAS_SC_WINDOW_SCISSOR_BR_X__SHIFT			0
static inline uint32_t A3XX_GRAS_SC_WINDOW_SCISSOR_BR_X(uint32_t val)
{
	return ((val) << A3XX_GRAS_SC_WINDOW_SCISSOR_BR_X__SHIFT) & A3XX_GRAS_SC_WINDOW_SCISSOR_BR_X__MASK;
}
#define A3XX_GRAS_SC_WINDOW_SCISSOR_BR_Y__MASK			0x7fff0000
#define A3XX_GRAS_SC_WINDOW_SCISSOR_BR_Y__SHIFT			16
static inline uint32_t A3XX_GRAS_SC_WINDOW_SCISSOR_BR_Y(uint32_t val)
{
	return ((val) << A3XX_GRAS_SC_WINDOW_SCISSOR_BR_Y__SHIFT) & A3XX_GRAS_SC_WINDOW_SCISSOR_BR_Y__MASK;
}

#define REG_A3XX_RB_MODE_CONTROL				0x000020c0
#define A3XX_RB_MODE_CONTROL_GMEM_BYPASS			0x00000080
#define A3XX_RB_MODE_CONTROL_RENDER_MODE__MASK			0x00000700
#define A3XX_RB_MODE_CONTROL_RENDER_MODE__SHIFT			8
static inline uint32_t A3XX_RB_MODE_CONTROL_RENDER_MODE(enum a3xx_render_mode val)
{
	return ((val) << A3XX_RB_MODE_CONTROL_RENDER_MODE__SHIFT) & A3XX_RB_MODE_CONTROL_RENDER_MODE__MASK;
}
#define A3XX_RB_MODE_CONTROL_MARB_CACHE_SPLIT_MODE		0x00008000
#define A3XX_RB_MODE_CONTROL_PACKER_TIMER_ENABLE		0x00010000

#define REG_A3XX_RB_RENDER_CONTROL				0x000020c1
#define A3XX_RB_RENDER_CONTROL_BIN_WIDTH__MASK			0x00000ff0
#define A3XX_RB_RENDER_CONTROL_BIN_WIDTH__SHIFT			4
static inline uint32_t A3XX_RB_RENDER_CONTROL_BIN_WIDTH(uint32_t val)
{
	return ((val >> 5) << A3XX_RB_RENDER_CONTROL_BIN_WIDTH__SHIFT) & A3XX_RB_RENDER_CONTROL_BIN_WIDTH__MASK;
}
#define A3XX_RB_RENDER_CONTROL_DISABLE_COLOR_PIPE		0x00001000
#define A3XX_RB_RENDER_CONTROL_ENABLE_GMEM			0x00002000
#define A3XX_RB_RENDER_CONTROL_ALPHA_TEST			0x00400000
#define A3XX_RB_RENDER_CONTROL_ALPHA_TEST_FUNC__MASK		0x07000000
#define A3XX_RB_RENDER_CONTROL_ALPHA_TEST_FUNC__SHIFT		24
static inline uint32_t A3XX_RB_RENDER_CONTROL_ALPHA_TEST_FUNC(enum adreno_compare_func val)
{
	return ((val) << A3XX_RB_RENDER_CONTROL_ALPHA_TEST_FUNC__SHIFT) & A3XX_RB_RENDER_CONTROL_ALPHA_TEST_FUNC__MASK;
}

#define REG_A3XX_RB_MSAA_CONTROL				0x000020c2
#define A3XX_RB_MSAA_CONTROL_DISABLE				0x00000400
#define A3XX_RB_MSAA_CONTROL_SAMPLES__MASK			0x0000f000
#define A3XX_RB_MSAA_CONTROL_SAMPLES__SHIFT			12
static inline uint32_t A3XX_RB_MSAA_CONTROL_SAMPLES(enum a3xx_msaa_samples val)
{
	return ((val) << A3XX_RB_MSAA_CONTROL_SAMPLES__SHIFT) & A3XX_RB_MSAA_CONTROL_SAMPLES__MASK;
}
#define A3XX_RB_MSAA_CONTROL_SAMPLE_MASK__MASK			0xffff0000
#define A3XX_RB_MSAA_CONTROL_SAMPLE_MASK__SHIFT			16
static inline uint32_t A3XX_RB_MSAA_CONTROL_SAMPLE_MASK(uint32_t val)
{
	return ((val) << A3XX_RB_MSAA_CONTROL_SAMPLE_MASK__SHIFT) & A3XX_RB_MSAA_CONTROL_SAMPLE_MASK__MASK;
}

#define REG_A3XX_RB_ALPHA_REF					0x000020c3
#define A3XX_RB_ALPHA_REF_UINT__MASK				0x0000ff00
#define A3XX_RB_ALPHA_REF_UINT__SHIFT				8
static inline uint32_t A3XX_RB_ALPHA_REF_UINT(uint32_t val)
{
	return ((val) << A3XX_RB_ALPHA_REF_UINT__SHIFT) & A3XX_RB_ALPHA_REF_UINT__MASK;
}
#define A3XX_RB_ALPHA_REF_FLOAT__MASK				0xffff0000
#define A3XX_RB_ALPHA_REF_FLOAT__SHIFT				16
static inline uint32_t A3XX_RB_ALPHA_REF_FLOAT(float val)
{
	return ((util_float_to_half(val)) << A3XX_RB_ALPHA_REF_FLOAT__SHIFT) & A3XX_RB_ALPHA_REF_FLOAT__MASK;
}

static inline uint32_t REG_A3XX_RB_MRT(uint32_t i0) { return 0x000020c4 + 0x4*i0; }

static inline uint32_t REG_A3XX_RB_MRT_CONTROL(uint32_t i0) { return 0x000020c4 + 0x4*i0; }
#define A3XX_RB_MRT_CONTROL_READ_DEST_ENABLE			0x00000008
#define A3XX_RB_MRT_CONTROL_BLEND				0x00000010
#define A3XX_RB_MRT_CONTROL_BLEND2				0x00000020
#define A3XX_RB_MRT_CONTROL_ROP_CODE__MASK			0x00000f00
#define A3XX_RB_MRT_CONTROL_ROP_CODE__SHIFT			8
static inline uint32_t A3XX_RB_MRT_CONTROL_ROP_CODE(enum a3xx_rop_code val)
{
	return ((val) << A3XX_RB_MRT_CONTROL_ROP_CODE__SHIFT) & A3XX_RB_MRT_CONTROL_ROP_CODE__MASK;
}
#define A3XX_RB_MRT_CONTROL_DITHER_MODE__MASK			0x00003000
#define A3XX_RB_MRT_CONTROL_DITHER_MODE__SHIFT			12
static inline uint32_t A3XX_RB_MRT_CONTROL_DITHER_MODE(enum adreno_rb_dither_mode val)
{
	return ((val) << A3XX_RB_MRT_CONTROL_DITHER_MODE__SHIFT) & A3XX_RB_MRT_CONTROL_DITHER_MODE__MASK;
}
#define A3XX_RB_MRT_CONTROL_COMPONENT_ENABLE__MASK		0x0f000000
#define A3XX_RB_MRT_CONTROL_COMPONENT_ENABLE__SHIFT		24
static inline uint32_t A3XX_RB_MRT_CONTROL_COMPONENT_ENABLE(uint32_t val)
{
	return ((val) << A3XX_RB_MRT_CONTROL_COMPONENT_ENABLE__SHIFT) & A3XX_RB_MRT_CONTROL_COMPONENT_ENABLE__MASK;
}

static inline uint32_t REG_A3XX_RB_MRT_BUF_INFO(uint32_t i0) { return 0x000020c5 + 0x4*i0; }
#define A3XX_RB_MRT_BUF_INFO_COLOR_FORMAT__MASK			0x0000003f
#define A3XX_RB_MRT_BUF_INFO_COLOR_FORMAT__SHIFT		0
static inline uint32_t A3XX_RB_MRT_BUF_INFO_COLOR_FORMAT(enum a3xx_color_fmt val)
{
	return ((val) << A3XX_RB_MRT_BUF_INFO_COLOR_FORMAT__SHIFT) & A3XX_RB_MRT_BUF_INFO_COLOR_FORMAT__MASK;
}
#define A3XX_RB_MRT_BUF_INFO_COLOR_TILE_MODE__MASK		0x000000c0
#define A3XX_RB_MRT_BUF_INFO_COLOR_TILE_MODE__SHIFT		6
static inline uint32_t A3XX_RB_MRT_BUF_INFO_COLOR_TILE_MODE(enum a3xx_tile_mode val)
{
	return ((val) << A3XX_RB_MRT_BUF_INFO_COLOR_TILE_MODE__SHIFT) & A3XX_RB_MRT_BUF_INFO_COLOR_TILE_MODE__MASK;
}
#define A3XX_RB_MRT_BUF_INFO_COLOR_SWAP__MASK			0x00000c00
#define A3XX_RB_MRT_BUF_INFO_COLOR_SWAP__SHIFT			10
static inline uint32_t A3XX_RB_MRT_BUF_INFO_COLOR_SWAP(enum a3xx_color_swap val)
{
	return ((val) << A3XX_RB_MRT_BUF_INFO_COLOR_SWAP__SHIFT) & A3XX_RB_MRT_BUF_INFO_COLOR_SWAP__MASK;
}
#define A3XX_RB_MRT_BUF_INFO_COLOR_BUF_PITCH__MASK		0xfffe0000
#define A3XX_RB_MRT_BUF_INFO_COLOR_BUF_PITCH__SHIFT		17
static inline uint32_t A3XX_RB_MRT_BUF_INFO_COLOR_BUF_PITCH(uint32_t val)
{
	return ((val >> 5) << A3XX_RB_MRT_BUF_INFO_COLOR_BUF_PITCH__SHIFT) & A3XX_RB_MRT_BUF_INFO_COLOR_BUF_PITCH__MASK;
}

static inline uint32_t REG_A3XX_RB_MRT_BUF_BASE(uint32_t i0) { return 0x000020c6 + 0x4*i0; }
#define A3XX_RB_MRT_BUF_BASE_COLOR_BUF_BASE__MASK		0xfffffff0
#define A3XX_RB_MRT_BUF_BASE_COLOR_BUF_BASE__SHIFT		4
static inline uint32_t A3XX_RB_MRT_BUF_BASE_COLOR_BUF_BASE(uint32_t val)
{
	return ((val >> 5) << A3XX_RB_MRT_BUF_BASE_COLOR_BUF_BASE__SHIFT) & A3XX_RB_MRT_BUF_BASE_COLOR_BUF_BASE__MASK;
}

static inline uint32_t REG_A3XX_RB_MRT_BLEND_CONTROL(uint32_t i0) { return 0x000020c7 + 0x4*i0; }
#define A3XX_RB_MRT_BLEND_CONTROL_RGB_SRC_FACTOR__MASK		0x0000001f
#define A3XX_RB_MRT_BLEND_CONTROL_RGB_SRC_FACTOR__SHIFT		0
static inline uint32_t A3XX_RB_MRT_BLEND_CONTROL_RGB_SRC_FACTOR(enum adreno_rb_blend_factor val)
{
	return ((val) << A3XX_RB_MRT_BLEND_CONTROL_RGB_SRC_FACTOR__SHIFT) & A3XX_RB_MRT_BLEND_CONTROL_RGB_SRC_FACTOR__MASK;
}
#define A3XX_RB_MRT_BLEND_CONTROL_RGB_BLEND_OPCODE__MASK	0x000000e0
#define A3XX_RB_MRT_BLEND_CONTROL_RGB_BLEND_OPCODE__SHIFT	5
static inline uint32_t A3XX_RB_MRT_BLEND_CONTROL_RGB_BLEND_OPCODE(enum adreno_rb_blend_opcode val)
{
	return ((val) << A3XX_RB_MRT_BLEND_CONTROL_RGB_BLEND_OPCODE__SHIFT) & A3XX_RB_MRT_BLEND_CONTROL_RGB_BLEND_OPCODE__MASK;
}
#define A3XX_RB_MRT_BLEND_CONTROL_RGB_DEST_FACTOR__MASK		0x00001f00
#define A3XX_RB_MRT_BLEND_CONTROL_RGB_DEST_FACTOR__SHIFT	8
static inline uint32_t A3XX_RB_MRT_BLEND_CONTROL_RGB_DEST_FACTOR(enum adreno_rb_blend_factor val)
{
	return ((val) << A3XX_RB_MRT_BLEND_CONTROL_RGB_DEST_FACTOR__SHIFT) & A3XX_RB_MRT_BLEND_CONTROL_RGB_DEST_FACTOR__MASK;
}
#define A3XX_RB_MRT_BLEND_CONTROL_ALPHA_SRC_FACTOR__MASK	0x001f0000
#define A3XX_RB_MRT_BLEND_CONTROL_ALPHA_SRC_FACTOR__SHIFT	16
static inline uint32_t A3XX_RB_MRT_BLEND_CONTROL_ALPHA_SRC_FACTOR(enum adreno_rb_blend_factor val)
{
	return ((val) << A3XX_RB_MRT_BLEND_CONTROL_ALPHA_SRC_FACTOR__SHIFT) & A3XX_RB_MRT_BLEND_CONTROL_ALPHA_SRC_FACTOR__MASK;
}
#define A3XX_RB_MRT_BLEND_CONTROL_ALPHA_BLEND_OPCODE__MASK	0x00e00000
#define A3XX_RB_MRT_BLEND_CONTROL_ALPHA_BLEND_OPCODE__SHIFT	21
static inline uint32_t A3XX_RB_MRT_BLEND_CONTROL_ALPHA_BLEND_OPCODE(enum adreno_rb_blend_opcode val)
{
	return ((val) << A3XX_RB_MRT_BLEND_CONTROL_ALPHA_BLEND_OPCODE__SHIFT) & A3XX_RB_MRT_BLEND_CONTROL_ALPHA_BLEND_OPCODE__MASK;
}
#define A3XX_RB_MRT_BLEND_CONTROL_ALPHA_DEST_FACTOR__MASK	0x1f000000
#define A3XX_RB_MRT_BLEND_CONTROL_ALPHA_DEST_FACTOR__SHIFT	24
static inline uint32_t A3XX_RB_MRT_BLEND_CONTROL_ALPHA_DEST_FACTOR(enum adreno_rb_blend_factor val)
{
	return ((val) << A3XX_RB_MRT_BLEND_CONTROL_ALPHA_DEST_FACTOR__SHIFT) & A3XX_RB_MRT_BLEND_CONTROL_ALPHA_DEST_FACTOR__MASK;
}
#define A3XX_RB_MRT_BLEND_CONTROL_CLAMP_ENABLE			0x20000000

#define REG_A3XX_RB_BLEND_RED					0x000020e4
#define A3XX_RB_BLEND_RED_UINT__MASK				0x000000ff
#define A3XX_RB_BLEND_RED_UINT__SHIFT				0
static inline uint32_t A3XX_RB_BLEND_RED_UINT(uint32_t val)
{
	return ((val) << A3XX_RB_BLEND_RED_UINT__SHIFT) & A3XX_RB_BLEND_RED_UINT__MASK;
}
#define A3XX_RB_BLEND_RED_FLOAT__MASK				0xffff0000
#define A3XX_RB_BLEND_RED_FLOAT__SHIFT				16
static inline uint32_t A3XX_RB_BLEND_RED_FLOAT(float val)
{
	return ((util_float_to_half(val)) << A3XX_RB_BLEND_RED_FLOAT__SHIFT) & A3XX_RB_BLEND_RED_FLOAT__MASK;
}

#define REG_A3XX_RB_BLEND_GREEN					0x000020e5
#define A3XX_RB_BLEND_GREEN_UINT__MASK				0x000000ff
#define A3XX_RB_BLEND_GREEN_UINT__SHIFT				0
static inline uint32_t A3XX_RB_BLEND_GREEN_UINT(uint32_t val)
{
	return ((val) << A3XX_RB_BLEND_GREEN_UINT__SHIFT) & A3XX_RB_BLEND_GREEN_UINT__MASK;
}
#define A3XX_RB_BLEND_GREEN_FLOAT__MASK				0xffff0000
#define A3XX_RB_BLEND_GREEN_FLOAT__SHIFT			16
static inline uint32_t A3XX_RB_BLEND_GREEN_FLOAT(float val)
{
	return ((util_float_to_half(val)) << A3XX_RB_BLEND_GREEN_FLOAT__SHIFT) & A3XX_RB_BLEND_GREEN_FLOAT__MASK;
}

#define REG_A3XX_RB_BLEND_BLUE					0x000020e6
#define A3XX_RB_BLEND_BLUE_UINT__MASK				0x000000ff
#define A3XX_RB_BLEND_BLUE_UINT__SHIFT				0
static inline uint32_t A3XX_RB_BLEND_BLUE_UINT(uint32_t val)
{
	return ((val) << A3XX_RB_BLEND_BLUE_UINT__SHIFT) & A3XX_RB_BLEND_BLUE_UINT__MASK;
}
#define A3XX_RB_BLEND_BLUE_FLOAT__MASK				0xffff0000
#define A3XX_RB_BLEND_BLUE_FLOAT__SHIFT				16
static inline uint32_t A3XX_RB_BLEND_BLUE_FLOAT(float val)
{
	return ((util_float_to_half(val)) << A3XX_RB_BLEND_BLUE_FLOAT__SHIFT) & A3XX_RB_BLEND_BLUE_FLOAT__MASK;
}

#define REG_A3XX_RB_BLEND_ALPHA					0x000020e7
#define A3XX_RB_BLEND_ALPHA_UINT__MASK				0x000000ff
#define A3XX_RB_BLEND_ALPHA_UINT__SHIFT				0
static inline uint32_t A3XX_RB_BLEND_ALPHA_UINT(uint32_t val)
{
	return ((val) << A3XX_RB_BLEND_ALPHA_UINT__SHIFT) & A3XX_RB_BLEND_ALPHA_UINT__MASK;
}
#define A3XX_RB_BLEND_ALPHA_FLOAT__MASK				0xffff0000
#define A3XX_RB_BLEND_ALPHA_FLOAT__SHIFT			16
static inline uint32_t A3XX_RB_BLEND_ALPHA_FLOAT(float val)
{
	return ((util_float_to_half(val)) << A3XX_RB_BLEND_ALPHA_FLOAT__SHIFT) & A3XX_RB_BLEND_ALPHA_FLOAT__MASK;
}

#define REG_A3XX_RB_CLEAR_COLOR_DW0				0x000020e8

#define REG_A3XX_RB_CLEAR_COLOR_DW1				0x000020e9

#define REG_A3XX_RB_CLEAR_COLOR_DW2				0x000020ea

#define REG_A3XX_RB_CLEAR_COLOR_DW3				0x000020eb

#define REG_A3XX_RB_COPY_CONTROL				0x000020ec
#define A3XX_RB_COPY_CONTROL_MSAA_RESOLVE__MASK			0x00000003
#define A3XX_RB_COPY_CONTROL_MSAA_RESOLVE__SHIFT		0
static inline uint32_t A3XX_RB_COPY_CONTROL_MSAA_RESOLVE(enum a3xx_msaa_samples val)
{
	return ((val) << A3XX_RB_COPY_CONTROL_MSAA_RESOLVE__SHIFT) & A3XX_RB_COPY_CONTROL_MSAA_RESOLVE__MASK;
}
#define A3XX_RB_COPY_CONTROL_MODE__MASK				0x00000070
#define A3XX_RB_COPY_CONTROL_MODE__SHIFT			4
static inline uint32_t A3XX_RB_COPY_CONTROL_MODE(enum adreno_rb_copy_control_mode val)
{
	return ((val) << A3XX_RB_COPY_CONTROL_MODE__SHIFT) & A3XX_RB_COPY_CONTROL_MODE__MASK;
}
#define A3XX_RB_COPY_CONTROL_GMEM_BASE__MASK			0xffffc000
#define A3XX_RB_COPY_CONTROL_GMEM_BASE__SHIFT			14
static inline uint32_t A3XX_RB_COPY_CONTROL_GMEM_BASE(uint32_t val)
{
	return ((val >> 14) << A3XX_RB_COPY_CONTROL_GMEM_BASE__SHIFT) & A3XX_RB_COPY_CONTROL_GMEM_BASE__MASK;
}

#define REG_A3XX_RB_COPY_DEST_BASE				0x000020ed
#define A3XX_RB_COPY_DEST_BASE_BASE__MASK			0xfffffff0
#define A3XX_RB_COPY_DEST_BASE_BASE__SHIFT			4
static inline uint32_t A3XX_RB_COPY_DEST_BASE_BASE(uint32_t val)
{
	return ((val >> 5) << A3XX_RB_COPY_DEST_BASE_BASE__SHIFT) & A3XX_RB_COPY_DEST_BASE_BASE__MASK;
}

#define REG_A3XX_RB_COPY_DEST_PITCH				0x000020ee
#define A3XX_RB_COPY_DEST_PITCH_PITCH__MASK			0xffffffff
#define A3XX_RB_COPY_DEST_PITCH_PITCH__SHIFT			0
static inline uint32_t A3XX_RB_COPY_DEST_PITCH_PITCH(uint32_t val)
{
	return ((val >> 5) << A3XX_RB_COPY_DEST_PITCH_PITCH__SHIFT) & A3XX_RB_COPY_DEST_PITCH_PITCH__MASK;
}

#define REG_A3XX_RB_COPY_DEST_INFO				0x000020ef
#define A3XX_RB_COPY_DEST_INFO_TILE__MASK			0x00000003
#define A3XX_RB_COPY_DEST_INFO_TILE__SHIFT			0
static inline uint32_t A3XX_RB_COPY_DEST_INFO_TILE(enum a3xx_tile_mode val)
{
	return ((val) << A3XX_RB_COPY_DEST_INFO_TILE__SHIFT) & A3XX_RB_COPY_DEST_INFO_TILE__MASK;
}
#define A3XX_RB_COPY_DEST_INFO_FORMAT__MASK			0x000000fc
#define A3XX_RB_COPY_DEST_INFO_FORMAT__SHIFT			2
static inline uint32_t A3XX_RB_COPY_DEST_INFO_FORMAT(enum a3xx_color_fmt val)
{
	return ((val) << A3XX_RB_COPY_DEST_INFO_FORMAT__SHIFT) & A3XX_RB_COPY_DEST_INFO_FORMAT__MASK;
}
#define A3XX_RB_COPY_DEST_INFO_SWAP__MASK			0x00000300
#define A3XX_RB_COPY_DEST_INFO_SWAP__SHIFT			8
static inline uint32_t A3XX_RB_COPY_DEST_INFO_SWAP(enum a3xx_color_swap val)
{
	return ((val) << A3XX_RB_COPY_DEST_INFO_SWAP__SHIFT) & A3XX_RB_COPY_DEST_INFO_SWAP__MASK;
}
#define A3XX_RB_COPY_DEST_INFO_COMPONENT_ENABLE__MASK		0x0003c000
#define A3XX_RB_COPY_DEST_INFO_COMPONENT_ENABLE__SHIFT		14
static inline uint32_t A3XX_RB_COPY_DEST_INFO_COMPONENT_ENABLE(uint32_t val)
{
	return ((val) << A3XX_RB_COPY_DEST_INFO_COMPONENT_ENABLE__SHIFT) & A3XX_RB_COPY_DEST_INFO_COMPONENT_ENABLE__MASK;
}
#define A3XX_RB_COPY_DEST_INFO_ENDIAN__MASK			0x001c0000
#define A3XX_RB_COPY_DEST_INFO_ENDIAN__SHIFT			18
static inline uint32_t A3XX_RB_COPY_DEST_INFO_ENDIAN(enum adreno_rb_surface_endian val)
{
	return ((val) << A3XX_RB_COPY_DEST_INFO_ENDIAN__SHIFT) & A3XX_RB_COPY_DEST_INFO_ENDIAN__MASK;
}

#define REG_A3XX_RB_DEPTH_CONTROL				0x00002100
#define A3XX_RB_DEPTH_CONTROL_FRAG_WRITES_Z			0x00000001
#define A3XX_RB_DEPTH_CONTROL_Z_ENABLE				0x00000002
#define A3XX_RB_DEPTH_CONTROL_Z_WRITE_ENABLE			0x00000004
#define A3XX_RB_DEPTH_CONTROL_EARLY_Z_DISABLE			0x00000008
#define A3XX_RB_DEPTH_CONTROL_ZFUNC__MASK			0x00000070
#define A3XX_RB_DEPTH_CONTROL_ZFUNC__SHIFT			4
static inline uint32_t A3XX_RB_DEPTH_CONTROL_ZFUNC(enum adreno_compare_func val)
{
	return ((val) << A3XX_RB_DEPTH_CONTROL_ZFUNC__SHIFT) & A3XX_RB_DEPTH_CONTROL_ZFUNC__MASK;
}
#define A3XX_RB_DEPTH_CONTROL_BF_ENABLE				0x00000080
#define A3XX_RB_DEPTH_CONTROL_Z_TEST_ENABLE			0x80000000

#define REG_A3XX_RB_DEPTH_CLEAR					0x00002101

#define REG_A3XX_RB_DEPTH_INFO					0x00002102
#define A3XX_RB_DEPTH_INFO_DEPTH_FORMAT__MASK			0x00000001
#define A3XX_RB_DEPTH_INFO_DEPTH_FORMAT__SHIFT			0
static inline uint32_t A3XX_RB_DEPTH_INFO_DEPTH_FORMAT(enum adreno_rb_depth_format val)
{
	return ((val) << A3XX_RB_DEPTH_INFO_DEPTH_FORMAT__SHIFT) & A3XX_RB_DEPTH_INFO_DEPTH_FORMAT__MASK;
}
#define A3XX_RB_DEPTH_INFO_DEPTH_BASE__MASK			0xfffff800
#define A3XX_RB_DEPTH_INFO_DEPTH_BASE__SHIFT			11
static inline uint32_t A3XX_RB_DEPTH_INFO_DEPTH_BASE(uint32_t val)
{
	return ((val >> 10) << A3XX_RB_DEPTH_INFO_DEPTH_BASE__SHIFT) & A3XX_RB_DEPTH_INFO_DEPTH_BASE__MASK;
}

#define REG_A3XX_RB_DEPTH_PITCH					0x00002103
#define A3XX_RB_DEPTH_PITCH__MASK				0xffffffff
#define A3XX_RB_DEPTH_PITCH__SHIFT				0
static inline uint32_t A3XX_RB_DEPTH_PITCH(uint32_t val)
{
	return ((val >> 3) << A3XX_RB_DEPTH_PITCH__SHIFT) & A3XX_RB_DEPTH_PITCH__MASK;
}

#define REG_A3XX_RB_STENCIL_CONTROL				0x00002104
#define A3XX_RB_STENCIL_CONTROL_STENCIL_ENABLE			0x00000001
#define A3XX_RB_STENCIL_CONTROL_STENCIL_ENABLE_BF		0x00000002
#define A3XX_RB_STENCIL_CONTROL_STENCIL_READ			0x00000004
#define A3XX_RB_STENCIL_CONTROL_FUNC__MASK			0x00000700
#define A3XX_RB_STENCIL_CONTROL_FUNC__SHIFT			8
static inline uint32_t A3XX_RB_STENCIL_CONTROL_FUNC(enum adreno_compare_func val)
{
	return ((val) << A3XX_RB_STENCIL_CONTROL_FUNC__SHIFT) & A3XX_RB_STENCIL_CONTROL_FUNC__MASK;
}
#define A3XX_RB_STENCIL_CONTROL_FAIL__MASK			0x00003800
#define A3XX_RB_STENCIL_CONTROL_FAIL__SHIFT			11
static inline uint32_t A3XX_RB_STENCIL_CONTROL_FAIL(enum adreno_stencil_op val)
{
	return ((val) << A3XX_RB_STENCIL_CONTROL_FAIL__SHIFT) & A3XX_RB_STENCIL_CONTROL_FAIL__MASK;
}
#define A3XX_RB_STENCIL_CONTROL_ZPASS__MASK			0x0001c000
#define A3XX_RB_STENCIL_CONTROL_ZPASS__SHIFT			14
static inline uint32_t A3XX_RB_STENCIL_CONTROL_ZPASS(enum adreno_stencil_op val)
{
	return ((val) << A3XX_RB_STENCIL_CONTROL_ZPASS__SHIFT) & A3XX_RB_STENCIL_CONTROL_ZPASS__MASK;
}
#define A3XX_RB_STENCIL_CONTROL_ZFAIL__MASK			0x000e0000
#define A3XX_RB_STENCIL_CONTROL_ZFAIL__SHIFT			17
static inline uint32_t A3XX_RB_STENCIL_CONTROL_ZFAIL(enum adreno_stencil_op val)
{
	return ((val) << A3XX_RB_STENCIL_CONTROL_ZFAIL__SHIFT) & A3XX_RB_STENCIL_CONTROL_ZFAIL__MASK;
}
#define A3XX_RB_STENCIL_CONTROL_FUNC_BF__MASK			0x00700000
#define A3XX_RB_STENCIL_CONTROL_FUNC_BF__SHIFT			20
static inline uint32_t A3XX_RB_STENCIL_CONTROL_FUNC_BF(enum adreno_compare_func val)
{
	return ((val) << A3XX_RB_STENCIL_CONTROL_FUNC_BF__SHIFT) & A3XX_RB_STENCIL_CONTROL_FUNC_BF__MASK;
}
#define A3XX_RB_STENCIL_CONTROL_FAIL_BF__MASK			0x03800000
#define A3XX_RB_STENCIL_CONTROL_FAIL_BF__SHIFT			23
static inline uint32_t A3XX_RB_STENCIL_CONTROL_FAIL_BF(enum adreno_stencil_op val)
{
	return ((val) << A3XX_RB_STENCIL_CONTROL_FAIL_BF__SHIFT) & A3XX_RB_STENCIL_CONTROL_FAIL_BF__MASK;
}
#define A3XX_RB_STENCIL_CONTROL_ZPASS_BF__MASK			0x1c000000
#define A3XX_RB_STENCIL_CONTROL_ZPASS_BF__SHIFT			26
static inline uint32_t A3XX_RB_STENCIL_CONTROL_ZPASS_BF(enum adreno_stencil_op val)
{
	return ((val) << A3XX_RB_STENCIL_CONTROL_ZPASS_BF__SHIFT) & A3XX_RB_STENCIL_CONTROL_ZPASS_BF__MASK;
}
#define A3XX_RB_STENCIL_CONTROL_ZFAIL_BF__MASK			0xe0000000
#define A3XX_RB_STENCIL_CONTROL_ZFAIL_BF__SHIFT			29
static inline uint32_t A3XX_RB_STENCIL_CONTROL_ZFAIL_BF(enum adreno_stencil_op val)
{
	return ((val) << A3XX_RB_STENCIL_CONTROL_ZFAIL_BF__SHIFT) & A3XX_RB_STENCIL_CONTROL_ZFAIL_BF__MASK;
}

#define REG_A3XX_RB_STENCIL_CLEAR				0x00002105

#define REG_A3XX_RB_STENCIL_BUF_INFO				0x00002106

#define REG_A3XX_RB_STENCIL_BUF_PITCH				0x00002107

#define REG_A3XX_RB_STENCILREFMASK				0x00002108
#define A3XX_RB_STENCILREFMASK_STENCILREF__MASK			0x000000ff
#define A3XX_RB_STENCILREFMASK_STENCILREF__SHIFT		0
static inline uint32_t A3XX_RB_STENCILREFMASK_STENCILREF(uint32_t val)
{
	return ((val) << A3XX_RB_STENCILREFMASK_STENCILREF__SHIFT) & A3XX_RB_STENCILREFMASK_STENCILREF__MASK;
}
#define A3XX_RB_STENCILREFMASK_STENCILMASK__MASK		0x0000ff00
#define A3XX_RB_STENCILREFMASK_STENCILMASK__SHIFT		8
static inline uint32_t A3XX_RB_STENCILREFMASK_STENCILMASK(uint32_t val)
{
	return ((val) << A3XX_RB_STENCILREFMASK_STENCILMASK__SHIFT) & A3XX_RB_STENCILREFMASK_STENCILMASK__MASK;
}
#define A3XX_RB_STENCILREFMASK_STENCILWRITEMASK__MASK		0x00ff0000
#define A3XX_RB_STENCILREFMASK_STENCILWRITEMASK__SHIFT		16
static inline uint32_t A3XX_RB_STENCILREFMASK_STENCILWRITEMASK(uint32_t val)
{
	return ((val) << A3XX_RB_STENCILREFMASK_STENCILWRITEMASK__SHIFT) & A3XX_RB_STENCILREFMASK_STENCILWRITEMASK__MASK;
}

#define REG_A3XX_RB_STENCILREFMASK_BF				0x00002109
#define A3XX_RB_STENCILREFMASK_BF_STENCILREF__MASK		0x000000ff
#define A3XX_RB_STENCILREFMASK_BF_STENCILREF__SHIFT		0
static inline uint32_t A3XX_RB_STENCILREFMASK_BF_STENCILREF(uint32_t val)
{
	return ((val) << A3XX_RB_STENCILREFMASK_BF_STENCILREF__SHIFT) & A3XX_RB_STENCILREFMASK_BF_STENCILREF__MASK;
}
#define A3XX_RB_STENCILREFMASK_BF_STENCILMASK__MASK		0x0000ff00
#define A3XX_RB_STENCILREFMASK_BF_STENCILMASK__SHIFT		8
static inline uint32_t A3XX_RB_STENCILREFMASK_BF_STENCILMASK(uint32_t val)
{
	return ((val) << A3XX_RB_STENCILREFMASK_BF_STENCILMASK__SHIFT) & A3XX_RB_STENCILREFMASK_BF_STENCILMASK__MASK;
}
#define A3XX_RB_STENCILREFMASK_BF_STENCILWRITEMASK__MASK	0x00ff0000
#define A3XX_RB_STENCILREFMASK_BF_STENCILWRITEMASK__SHIFT	16
static inline uint32_t A3XX_RB_STENCILREFMASK_BF_STENCILWRITEMASK(uint32_t val)
{
	return ((val) << A3XX_RB_STENCILREFMASK_BF_STENCILWRITEMASK__SHIFT) & A3XX_RB_STENCILREFMASK_BF_STENCILWRITEMASK__MASK;
}

#define REG_A3XX_RB_LRZ_VSC_CONTROL				0x0000210c
#define A3XX_RB_LRZ_VSC_CONTROL_BINNING_ENABLE			0x00000002

#define REG_A3XX_RB_WINDOW_OFFSET				0x0000210e
#define A3XX_RB_WINDOW_OFFSET_X__MASK				0x0000ffff
#define A3XX_RB_WINDOW_OFFSET_X__SHIFT				0
static inline uint32_t A3XX_RB_WINDOW_OFFSET_X(uint32_t val)
{
	return ((val) << A3XX_RB_WINDOW_OFFSET_X__SHIFT) & A3XX_RB_WINDOW_OFFSET_X__MASK;
}
#define A3XX_RB_WINDOW_OFFSET_Y__MASK				0xffff0000
#define A3XX_RB_WINDOW_OFFSET_Y__SHIFT				16
static inline uint32_t A3XX_RB_WINDOW_OFFSET_Y(uint32_t val)
{
	return ((val) << A3XX_RB_WINDOW_OFFSET_Y__SHIFT) & A3XX_RB_WINDOW_OFFSET_Y__MASK;
}

#define REG_A3XX_RB_SAMPLE_COUNT_CONTROL			0x00002110

#define REG_A3XX_RB_SAMPLE_COUNT_ADDR				0x00002111

#define REG_A3XX_RB_Z_CLAMP_MIN					0x00002114

#define REG_A3XX_RB_Z_CLAMP_MAX					0x00002115

#define REG_A3XX_VGT_BIN_BASE					0x000021e1

#define REG_A3XX_VGT_BIN_SIZE					0x000021e2

#define REG_A3XX_PC_VSTREAM_CONTROL				0x000021e4
#define A3XX_PC_VSTREAM_CONTROL_SIZE__MASK			0x003f0000
#define A3XX_PC_VSTREAM_CONTROL_SIZE__SHIFT			16
static inline uint32_t A3XX_PC_VSTREAM_CONTROL_SIZE(uint32_t val)
{
	return ((val) << A3XX_PC_VSTREAM_CONTROL_SIZE__SHIFT) & A3XX_PC_VSTREAM_CONTROL_SIZE__MASK;
}
#define A3XX_PC_VSTREAM_CONTROL_N__MASK				0x07c00000
#define A3XX_PC_VSTREAM_CONTROL_N__SHIFT			22
static inline uint32_t A3XX_PC_VSTREAM_CONTROL_N(uint32_t val)
{
	return ((val) << A3XX_PC_VSTREAM_CONTROL_N__SHIFT) & A3XX_PC_VSTREAM_CONTROL_N__MASK;
}

#define REG_A3XX_PC_VERTEX_REUSE_BLOCK_CNTL			0x000021ea

#define REG_A3XX_PC_PRIM_VTX_CNTL				0x000021ec
#define A3XX_PC_PRIM_VTX_CNTL_STRIDE_IN_VPC__MASK		0x0000001f
#define A3XX_PC_PRIM_VTX_CNTL_STRIDE_IN_VPC__SHIFT		0
static inline uint32_t A3XX_PC_PRIM_VTX_CNTL_STRIDE_IN_VPC(uint32_t val)
{
	return ((val) << A3XX_PC_PRIM_VTX_CNTL_STRIDE_IN_VPC__SHIFT) & A3XX_PC_PRIM_VTX_CNTL_STRIDE_IN_VPC__MASK;
}
#define A3XX_PC_PRIM_VTX_CNTL_POLYMODE_FRONT_PTYPE__MASK	0x000000e0
#define A3XX_PC_PRIM_VTX_CNTL_POLYMODE_FRONT_PTYPE__SHIFT	5
static inline uint32_t A3XX_PC_PRIM_VTX_CNTL_POLYMODE_FRONT_PTYPE(enum adreno_pa_su_sc_draw val)
{
	return ((val) << A3XX_PC_PRIM_VTX_CNTL_POLYMODE_FRONT_PTYPE__SHIFT) & A3XX_PC_PRIM_VTX_CNTL_POLYMODE_FRONT_PTYPE__MASK;
}
#define A3XX_PC_PRIM_VTX_CNTL_POLYMODE_BACK_PTYPE__MASK		0x00000700
#define A3XX_PC_PRIM_VTX_CNTL_POLYMODE_BACK_PTYPE__SHIFT	8
static inline uint32_t A3XX_PC_PRIM_VTX_CNTL_POLYMODE_BACK_PTYPE(enum adreno_pa_su_sc_draw val)
{
	return ((val) << A3XX_PC_PRIM_VTX_CNTL_POLYMODE_BACK_PTYPE__SHIFT) & A3XX_PC_PRIM_VTX_CNTL_POLYMODE_BACK_PTYPE__MASK;
}
#define A3XX_PC_PRIM_VTX_CNTL_PROVOKING_VTX_LAST		0x02000000

#define REG_A3XX_PC_RESTART_INDEX				0x000021ed

#define REG_A3XX_HLSQ_CONTROL_0_REG				0x00002200
#define A3XX_HLSQ_CONTROL_0_REG_FSTHREADSIZE__MASK		0x00000010
#define A3XX_HLSQ_CONTROL_0_REG_FSTHREADSIZE__SHIFT		4
static inline uint32_t A3XX_HLSQ_CONTROL_0_REG_FSTHREADSIZE(enum a3xx_threadsize val)
{
	return ((val) << A3XX_HLSQ_CONTROL_0_REG_FSTHREADSIZE__SHIFT) & A3XX_HLSQ_CONTROL_0_REG_FSTHREADSIZE__MASK;
}
#define A3XX_HLSQ_CONTROL_0_REG_FSSUPERTHREADENABLE		0x00000040
#define A3XX_HLSQ_CONTROL_0_REG_SPSHADERRESTART			0x00000200
#define A3XX_HLSQ_CONTROL_0_REG_RESERVED2			0x00000400
#define A3XX_HLSQ_CONTROL_0_REG_CHUNKDISABLE			0x04000000
#define A3XX_HLSQ_CONTROL_0_REG_CONSTSWITCHMODE			0x08000000
#define A3XX_HLSQ_CONTROL_0_REG_LAZYUPDATEDISABLE		0x10000000
#define A3XX_HLSQ_CONTROL_0_REG_SPCONSTFULLUPDATE		0x20000000
#define A3XX_HLSQ_CONTROL_0_REG_TPFULLUPDATE			0x40000000
#define A3XX_HLSQ_CONTROL_0_REG_SINGLECONTEXT			0x80000000

#define REG_A3XX_HLSQ_CONTROL_1_REG				0x00002201
#define A3XX_HLSQ_CONTROL_1_REG_VSTHREADSIZE__MASK		0x00000040
#define A3XX_HLSQ_CONTROL_1_REG_VSTHREADSIZE__SHIFT		6
static inline uint32_t A3XX_HLSQ_CONTROL_1_REG_VSTHREADSIZE(enum a3xx_threadsize val)
{
	return ((val) << A3XX_HLSQ_CONTROL_1_REG_VSTHREADSIZE__SHIFT) & A3XX_HLSQ_CONTROL_1_REG_VSTHREADSIZE__MASK;
}
#define A3XX_HLSQ_CONTROL_1_REG_VSSUPERTHREADENABLE		0x00000100
#define A3XX_HLSQ_CONTROL_1_REG_RESERVED1			0x00000200

#define REG_A3XX_HLSQ_CONTROL_2_REG				0x00002202
#define A3XX_HLSQ_CONTROL_2_REG_PRIMALLOCTHRESHOLD__MASK	0xfc000000
#define A3XX_HLSQ_CONTROL_2_REG_PRIMALLOCTHRESHOLD__SHIFT	26
static inline uint32_t A3XX_HLSQ_CONTROL_2_REG_PRIMALLOCTHRESHOLD(uint32_t val)
{
	return ((val) << A3XX_HLSQ_CONTROL_2_REG_PRIMALLOCTHRESHOLD__SHIFT) & A3XX_HLSQ_CONTROL_2_REG_PRIMALLOCTHRESHOLD__MASK;
}

#define REG_A3XX_HLSQ_CONTROL_3_REG				0x00002203

#define REG_A3XX_HLSQ_VS_CONTROL_REG				0x00002204
#define A3XX_HLSQ_VS_CONTROL_REG_CONSTLENGTH__MASK		0x00000fff
#define A3XX_HLSQ_VS_CONTROL_REG_CONSTLENGTH__SHIFT		0
static inline uint32_t A3XX_HLSQ_VS_CONTROL_REG_CONSTLENGTH(uint32_t val)
{
	return ((val) << A3XX_HLSQ_VS_CONTROL_REG_CONSTLENGTH__SHIFT) & A3XX_HLSQ_VS_CONTROL_REG_CONSTLENGTH__MASK;
}
#define A3XX_HLSQ_VS_CONTROL_REG_CONSTSTARTOFFSET__MASK		0x00fff000
#define A3XX_HLSQ_VS_CONTROL_REG_CONSTSTARTOFFSET__SHIFT	12
static inline uint32_t A3XX_HLSQ_VS_CONTROL_REG_CONSTSTARTOFFSET(uint32_t val)
{
	return ((val) << A3XX_HLSQ_VS_CONTROL_REG_CONSTSTARTOFFSET__SHIFT) & A3XX_HLSQ_VS_CONTROL_REG_CONSTSTARTOFFSET__MASK;
}
#define A3XX_HLSQ_VS_CONTROL_REG_INSTRLENGTH__MASK		0xff000000
#define A3XX_HLSQ_VS_CONTROL_REG_INSTRLENGTH__SHIFT		24
static inline uint32_t A3XX_HLSQ_VS_CONTROL_REG_INSTRLENGTH(uint32_t val)
{
	return ((val) << A3XX_HLSQ_VS_CONTROL_REG_INSTRLENGTH__SHIFT) & A3XX_HLSQ_VS_CONTROL_REG_INSTRLENGTH__MASK;
}

#define REG_A3XX_HLSQ_FS_CONTROL_REG				0x00002205
#define A3XX_HLSQ_FS_CONTROL_REG_CONSTLENGTH__MASK		0x00000fff
#define A3XX_HLSQ_FS_CONTROL_REG_CONSTLENGTH__SHIFT		0
static inline uint32_t A3XX_HLSQ_FS_CONTROL_REG_CONSTLENGTH(uint32_t val)
{
	return ((val) << A3XX_HLSQ_FS_CONTROL_REG_CONSTLENGTH__SHIFT) & A3XX_HLSQ_FS_CONTROL_REG_CONSTLENGTH__MASK;
}
#define A3XX_HLSQ_FS_CONTROL_REG_CONSTSTARTOFFSET__MASK		0x00fff000
#define A3XX_HLSQ_FS_CONTROL_REG_CONSTSTARTOFFSET__SHIFT	12
static inline uint32_t A3XX_HLSQ_FS_CONTROL_REG_CONSTSTARTOFFSET(uint32_t val)
{
	return ((val) << A3XX_HLSQ_FS_CONTROL_REG_CONSTSTARTOFFSET__SHIFT) & A3XX_HLSQ_FS_CONTROL_REG_CONSTSTARTOFFSET__MASK;
}
#define A3XX_HLSQ_FS_CONTROL_REG_INSTRLENGTH__MASK		0xff000000
#define A3XX_HLSQ_FS_CONTROL_REG_INSTRLENGTH__SHIFT		24
static inline uint32_t A3XX_HLSQ_FS_CONTROL_REG_INSTRLENGTH(uint32_t val)
{
	return ((val) << A3XX_HLSQ_FS_CONTROL_REG_INSTRLENGTH__SHIFT) & A3XX_HLSQ_FS_CONTROL_REG_INSTRLENGTH__MASK;
}

#define REG_A3XX_HLSQ_CONST_VSPRESV_RANGE_REG			0x00002206
#define A3XX_HLSQ_CONST_VSPRESV_RANGE_REG_STARTENTRY__MASK	0x0000ffff
#define A3XX_HLSQ_CONST_VSPRESV_RANGE_REG_STARTENTRY__SHIFT	0
static inline uint32_t A3XX_HLSQ_CONST_VSPRESV_RANGE_REG_STARTENTRY(uint32_t val)
{
	return ((val) << A3XX_HLSQ_CONST_VSPRESV_RANGE_REG_STARTENTRY__SHIFT) & A3XX_HLSQ_CONST_VSPRESV_RANGE_REG_STARTENTRY__MASK;
}
#define A3XX_HLSQ_CONST_VSPRESV_RANGE_REG_ENDENTRY__MASK	0xffff0000
#define A3XX_HLSQ_CONST_VSPRESV_RANGE_REG_ENDENTRY__SHIFT	16
static inline uint32_t A3XX_HLSQ_CONST_VSPRESV_RANGE_REG_ENDENTRY(uint32_t val)
{
	return ((val) << A3XX_HLSQ_CONST_VSPRESV_RANGE_REG_ENDENTRY__SHIFT) & A3XX_HLSQ_CONST_VSPRESV_RANGE_REG_ENDENTRY__MASK;
}

#define REG_A3XX_HLSQ_CONST_FSPRESV_RANGE_REG			0x00002207
#define A3XX_HLSQ_CONST_FSPRESV_RANGE_REG_STARTENTRY__MASK	0x0000ffff
#define A3XX_HLSQ_CONST_FSPRESV_RANGE_REG_STARTENTRY__SHIFT	0
static inline uint32_t A3XX_HLSQ_CONST_FSPRESV_RANGE_REG_STARTENTRY(uint32_t val)
{
	return ((val) << A3XX_HLSQ_CONST_FSPRESV_RANGE_REG_STARTENTRY__SHIFT) & A3XX_HLSQ_CONST_FSPRESV_RANGE_REG_STARTENTRY__MASK;
}
#define A3XX_HLSQ_CONST_FSPRESV_RANGE_REG_ENDENTRY__MASK	0xffff0000
#define A3XX_HLSQ_CONST_FSPRESV_RANGE_REG_ENDENTRY__SHIFT	16
static inline uint32_t A3XX_HLSQ_CONST_FSPRESV_RANGE_REG_ENDENTRY(uint32_t val)
{
	return ((val) << A3XX_HLSQ_CONST_FSPRESV_RANGE_REG_ENDENTRY__SHIFT) & A3XX_HLSQ_CONST_FSPRESV_RANGE_REG_ENDENTRY__MASK;
}

#define REG_A3XX_HLSQ_CL_NDRANGE_0_REG				0x0000220a

#define REG_A3XX_HLSQ_CL_NDRANGE_1_REG				0x0000220b

#define REG_A3XX_HLSQ_CL_NDRANGE_2_REG				0x0000220c

#define REG_A3XX_HLSQ_CL_CONTROL_0_REG				0x00002211

#define REG_A3XX_HLSQ_CL_CONTROL_1_REG				0x00002212

#define REG_A3XX_HLSQ_CL_KERNEL_CONST_REG			0x00002214

#define REG_A3XX_HLSQ_CL_KERNEL_GROUP_X_REG			0x00002215

#define REG_A3XX_HLSQ_CL_KERNEL_GROUP_Y_REG			0x00002216

#define REG_A3XX_HLSQ_CL_KERNEL_GROUP_Z_REG			0x00002217

#define REG_A3XX_HLSQ_CL_WG_OFFSET_REG				0x0000221a

#define REG_A3XX_VFD_CONTROL_0					0x00002240
#define A3XX_VFD_CONTROL_0_TOTALATTRTOVS__MASK			0x0003ffff
#define A3XX_VFD_CONTROL_0_TOTALATTRTOVS__SHIFT			0
static inline uint32_t A3XX_VFD_CONTROL_0_TOTALATTRTOVS(uint32_t val)
{
	return ((val) << A3XX_VFD_CONTROL_0_TOTALATTRTOVS__SHIFT) & A3XX_VFD_CONTROL_0_TOTALATTRTOVS__MASK;
}
#define A3XX_VFD_CONTROL_0_PACKETSIZE__MASK			0x003c0000
#define A3XX_VFD_CONTROL_0_PACKETSIZE__SHIFT			18
static inline uint32_t A3XX_VFD_CONTROL_0_PACKETSIZE(uint32_t val)
{
	return ((val) << A3XX_VFD_CONTROL_0_PACKETSIZE__SHIFT) & A3XX_VFD_CONTROL_0_PACKETSIZE__MASK;
}
#define A3XX_VFD_CONTROL_0_STRMDECINSTRCNT__MASK		0x07c00000
#define A3XX_VFD_CONTROL_0_STRMDECINSTRCNT__SHIFT		22
static inline uint32_t A3XX_VFD_CONTROL_0_STRMDECINSTRCNT(uint32_t val)
{
	return ((val) << A3XX_VFD_CONTROL_0_STRMDECINSTRCNT__SHIFT) & A3XX_VFD_CONTROL_0_STRMDECINSTRCNT__MASK;
}
#define A3XX_VFD_CONTROL_0_STRMFETCHINSTRCNT__MASK		0xf8000000
#define A3XX_VFD_CONTROL_0_STRMFETCHINSTRCNT__SHIFT		27
static inline uint32_t A3XX_VFD_CONTROL_0_STRMFETCHINSTRCNT(uint32_t val)
{
	return ((val) << A3XX_VFD_CONTROL_0_STRMFETCHINSTRCNT__SHIFT) & A3XX_VFD_CONTROL_0_STRMFETCHINSTRCNT__MASK;
}

#define REG_A3XX_VFD_CONTROL_1					0x00002241
#define A3XX_VFD_CONTROL_1_MAXSTORAGE__MASK			0x0000ffff
#define A3XX_VFD_CONTROL_1_MAXSTORAGE__SHIFT			0
static inline uint32_t A3XX_VFD_CONTROL_1_MAXSTORAGE(uint32_t val)
{
	return ((val) << A3XX_VFD_CONTROL_1_MAXSTORAGE__SHIFT) & A3XX_VFD_CONTROL_1_MAXSTORAGE__MASK;
}
#define A3XX_VFD_CONTROL_1_REGID4VTX__MASK			0x00ff0000
#define A3XX_VFD_CONTROL_1_REGID4VTX__SHIFT			16
static inline uint32_t A3XX_VFD_CONTROL_1_REGID4VTX(uint32_t val)
{
	return ((val) << A3XX_VFD_CONTROL_1_REGID4VTX__SHIFT) & A3XX_VFD_CONTROL_1_REGID4VTX__MASK;
}
#define A3XX_VFD_CONTROL_1_REGID4INST__MASK			0xff000000
#define A3XX_VFD_CONTROL_1_REGID4INST__SHIFT			24
static inline uint32_t A3XX_VFD_CONTROL_1_REGID4INST(uint32_t val)
{
	return ((val) << A3XX_VFD_CONTROL_1_REGID4INST__SHIFT) & A3XX_VFD_CONTROL_1_REGID4INST__MASK;
}

#define REG_A3XX_VFD_INDEX_MIN					0x00002242

#define REG_A3XX_VFD_INDEX_MAX					0x00002243

#define REG_A3XX_VFD_INSTANCEID_OFFSET				0x00002244

#define REG_A3XX_VFD_INDEX_OFFSET				0x00002245

static inline uint32_t REG_A3XX_VFD_FETCH(uint32_t i0) { return 0x00002246 + 0x2*i0; }

static inline uint32_t REG_A3XX_VFD_FETCH_INSTR_0(uint32_t i0) { return 0x00002246 + 0x2*i0; }
#define A3XX_VFD_FETCH_INSTR_0_FETCHSIZE__MASK			0x0000007f
#define A3XX_VFD_FETCH_INSTR_0_FETCHSIZE__SHIFT			0
static inline uint32_t A3XX_VFD_FETCH_INSTR_0_FETCHSIZE(uint32_t val)
{
	return ((val) << A3XX_VFD_FETCH_INSTR_0_FETCHSIZE__SHIFT) & A3XX_VFD_FETCH_INSTR_0_FETCHSIZE__MASK;
}
#define A3XX_VFD_FETCH_INSTR_0_BUFSTRIDE__MASK			0x0001ff80
#define A3XX_VFD_FETCH_INSTR_0_BUFSTRIDE__SHIFT			7
static inline uint32_t A3XX_VFD_FETCH_INSTR_0_BUFSTRIDE(uint32_t val)
{
	return ((val) << A3XX_VFD_FETCH_INSTR_0_BUFSTRIDE__SHIFT) & A3XX_VFD_FETCH_INSTR_0_BUFSTRIDE__MASK;
}
#define A3XX_VFD_FETCH_INSTR_0_SWITCHNEXT			0x00020000
#define A3XX_VFD_FETCH_INSTR_0_INDEXCODE__MASK			0x00fc0000
#define A3XX_VFD_FETCH_INSTR_0_INDEXCODE__SHIFT			18
static inline uint32_t A3XX_VFD_FETCH_INSTR_0_INDEXCODE(uint32_t val)
{
	return ((val) << A3XX_VFD_FETCH_INSTR_0_INDEXCODE__SHIFT) & A3XX_VFD_FETCH_INSTR_0_INDEXCODE__MASK;
}
#define A3XX_VFD_FETCH_INSTR_0_STEPRATE__MASK			0xff000000
#define A3XX_VFD_FETCH_INSTR_0_STEPRATE__SHIFT			24
static inline uint32_t A3XX_VFD_FETCH_INSTR_0_STEPRATE(uint32_t val)
{
	return ((val) << A3XX_VFD_FETCH_INSTR_0_STEPRATE__SHIFT) & A3XX_VFD_FETCH_INSTR_0_STEPRATE__MASK;
}

static inline uint32_t REG_A3XX_VFD_FETCH_INSTR_1(uint32_t i0) { return 0x00002247 + 0x2*i0; }

static inline uint32_t REG_A3XX_VFD_DECODE(uint32_t i0) { return 0x00002266 + 0x1*i0; }

static inline uint32_t REG_A3XX_VFD_DECODE_INSTR(uint32_t i0) { return 0x00002266 + 0x1*i0; }
#define A3XX_VFD_DECODE_INSTR_WRITEMASK__MASK			0x0000000f
#define A3XX_VFD_DECODE_INSTR_WRITEMASK__SHIFT			0
static inline uint32_t A3XX_VFD_DECODE_INSTR_WRITEMASK(uint32_t val)
{
	return ((val) << A3XX_VFD_DECODE_INSTR_WRITEMASK__SHIFT) & A3XX_VFD_DECODE_INSTR_WRITEMASK__MASK;
}
#define A3XX_VFD_DECODE_INSTR_CONSTFILL				0x00000010
#define A3XX_VFD_DECODE_INSTR_FORMAT__MASK			0x00000fc0
#define A3XX_VFD_DECODE_INSTR_FORMAT__SHIFT			6
static inline uint32_t A3XX_VFD_DECODE_INSTR_FORMAT(enum a3xx_vtx_fmt val)
{
	return ((val) << A3XX_VFD_DECODE_INSTR_FORMAT__SHIFT) & A3XX_VFD_DECODE_INSTR_FORMAT__MASK;
}
#define A3XX_VFD_DECODE_INSTR_REGID__MASK			0x000ff000
#define A3XX_VFD_DECODE_INSTR_REGID__SHIFT			12
static inline uint32_t A3XX_VFD_DECODE_INSTR_REGID(uint32_t val)
{
	return ((val) << A3XX_VFD_DECODE_INSTR_REGID__SHIFT) & A3XX_VFD_DECODE_INSTR_REGID__MASK;
}
#define A3XX_VFD_DECODE_INSTR_SHIFTCNT__MASK			0x1f000000
#define A3XX_VFD_DECODE_INSTR_SHIFTCNT__SHIFT			24
static inline uint32_t A3XX_VFD_DECODE_INSTR_SHIFTCNT(uint32_t val)
{
	return ((val) << A3XX_VFD_DECODE_INSTR_SHIFTCNT__SHIFT) & A3XX_VFD_DECODE_INSTR_SHIFTCNT__MASK;
}
#define A3XX_VFD_DECODE_INSTR_LASTCOMPVALID			0x20000000
#define A3XX_VFD_DECODE_INSTR_SWITCHNEXT			0x40000000

#define REG_A3XX_VFD_VS_THREADING_THRESHOLD			0x0000227e
#define A3XX_VFD_VS_THREADING_THRESHOLD_REGID_THRESHOLD__MASK	0x0000000f
#define A3XX_VFD_VS_THREADING_THRESHOLD_REGID_THRESHOLD__SHIFT	0
static inline uint32_t A3XX_VFD_VS_THREADING_THRESHOLD_REGID_THRESHOLD(uint32_t val)
{
	return ((val) << A3XX_VFD_VS_THREADING_THRESHOLD_REGID_THRESHOLD__SHIFT) & A3XX_VFD_VS_THREADING_THRESHOLD_REGID_THRESHOLD__MASK;
}
#define A3XX_VFD_VS_THREADING_THRESHOLD_REGID_VTXCNT__MASK	0x0000ff00
#define A3XX_VFD_VS_THREADING_THRESHOLD_REGID_VTXCNT__SHIFT	8
static inline uint32_t A3XX_VFD_VS_THREADING_THRESHOLD_REGID_VTXCNT(uint32_t val)
{
	return ((val) << A3XX_VFD_VS_THREADING_THRESHOLD_REGID_VTXCNT__SHIFT) & A3XX_VFD_VS_THREADING_THRESHOLD_REGID_VTXCNT__MASK;
}

#define REG_A3XX_VPC_ATTR					0x00002280
#define A3XX_VPC_ATTR_TOTALATTR__MASK				0x00000fff
#define A3XX_VPC_ATTR_TOTALATTR__SHIFT				0
static inline uint32_t A3XX_VPC_ATTR_TOTALATTR(uint32_t val)
{
	return ((val) << A3XX_VPC_ATTR_TOTALATTR__SHIFT) & A3XX_VPC_ATTR_TOTALATTR__MASK;
}
#define A3XX_VPC_ATTR_THRDASSIGN__MASK				0x0ffff000
#define A3XX_VPC_ATTR_THRDASSIGN__SHIFT				12
static inline uint32_t A3XX_VPC_ATTR_THRDASSIGN(uint32_t val)
{
	return ((val) << A3XX_VPC_ATTR_THRDASSIGN__SHIFT) & A3XX_VPC_ATTR_THRDASSIGN__MASK;
}
#define A3XX_VPC_ATTR_LMSIZE__MASK				0xf0000000
#define A3XX_VPC_ATTR_LMSIZE__SHIFT				28
static inline uint32_t A3XX_VPC_ATTR_LMSIZE(uint32_t val)
{
	return ((val) << A3XX_VPC_ATTR_LMSIZE__SHIFT) & A3XX_VPC_ATTR_LMSIZE__MASK;
}

#define REG_A3XX_VPC_PACK					0x00002281
#define A3XX_VPC_PACK_NUMFPNONPOSVAR__MASK			0x0000ff00
#define A3XX_VPC_PACK_NUMFPNONPOSVAR__SHIFT			8
static inline uint32_t A3XX_VPC_PACK_NUMFPNONPOSVAR(uint32_t val)
{
	return ((val) << A3XX_VPC_PACK_NUMFPNONPOSVAR__SHIFT) & A3XX_VPC_PACK_NUMFPNONPOSVAR__MASK;
}
#define A3XX_VPC_PACK_NUMNONPOSVSVAR__MASK			0x00ff0000
#define A3XX_VPC_PACK_NUMNONPOSVSVAR__SHIFT			16
static inline uint32_t A3XX_VPC_PACK_NUMNONPOSVSVAR(uint32_t val)
{
	return ((val) << A3XX_VPC_PACK_NUMNONPOSVSVAR__SHIFT) & A3XX_VPC_PACK_NUMNONPOSVSVAR__MASK;
}

static inline uint32_t REG_A3XX_VPC_VARYING_INTERP(uint32_t i0) { return 0x00002282 + 0x1*i0; }

static inline uint32_t REG_A3XX_VPC_VARYING_INTERP_MODE(uint32_t i0) { return 0x00002282 + 0x1*i0; }

static inline uint32_t REG_A3XX_VPC_VARYING_PS_REPL(uint32_t i0) { return 0x00002286 + 0x1*i0; }

static inline uint32_t REG_A3XX_VPC_VARYING_PS_REPL_MODE(uint32_t i0) { return 0x00002286 + 0x1*i0; }

#define REG_A3XX_VPC_VARY_CYLWRAP_ENABLE_0			0x0000228a

#define REG_A3XX_VPC_VARY_CYLWRAP_ENABLE_1			0x0000228b

#define REG_A3XX_SP_SP_CTRL_REG					0x000022c0
#define A3XX_SP_SP_CTRL_REG_RESOLVE				0x00010000
#define A3XX_SP_SP_CTRL_REG_CONSTMODE__MASK			0x00040000
#define A3XX_SP_SP_CTRL_REG_CONSTMODE__SHIFT			18
static inline uint32_t A3XX_SP_SP_CTRL_REG_CONSTMODE(uint32_t val)
{
	return ((val) << A3XX_SP_SP_CTRL_REG_CONSTMODE__SHIFT) & A3XX_SP_SP_CTRL_REG_CONSTMODE__MASK;
}
#define A3XX_SP_SP_CTRL_REG_BINNING				0x00080000
#define A3XX_SP_SP_CTRL_REG_SLEEPMODE__MASK			0x00300000
#define A3XX_SP_SP_CTRL_REG_SLEEPMODE__SHIFT			20
static inline uint32_t A3XX_SP_SP_CTRL_REG_SLEEPMODE(uint32_t val)
{
	return ((val) << A3XX_SP_SP_CTRL_REG_SLEEPMODE__SHIFT) & A3XX_SP_SP_CTRL_REG_SLEEPMODE__MASK;
}
#define A3XX_SP_SP_CTRL_REG_L0MODE__MASK			0x00c00000
#define A3XX_SP_SP_CTRL_REG_L0MODE__SHIFT			22
static inline uint32_t A3XX_SP_SP_CTRL_REG_L0MODE(uint32_t val)
{
	return ((val) << A3XX_SP_SP_CTRL_REG_L0MODE__SHIFT) & A3XX_SP_SP_CTRL_REG_L0MODE__MASK;
}

#define REG_A3XX_SP_VS_CTRL_REG0				0x000022c4
#define A3XX_SP_VS_CTRL_REG0_THREADMODE__MASK			0x00000001
#define A3XX_SP_VS_CTRL_REG0_THREADMODE__SHIFT			0
static inline uint32_t A3XX_SP_VS_CTRL_REG0_THREADMODE(enum a3xx_threadmode val)
{
	return ((val) << A3XX_SP_VS_CTRL_REG0_THREADMODE__SHIFT) & A3XX_SP_VS_CTRL_REG0_THREADMODE__MASK;
}
#define A3XX_SP_VS_CTRL_REG0_INSTRBUFFERMODE__MASK		0x00000002
#define A3XX_SP_VS_CTRL_REG0_INSTRBUFFERMODE__SHIFT		1
static inline uint32_t A3XX_SP_VS_CTRL_REG0_INSTRBUFFERMODE(enum a3xx_instrbuffermode val)
{
	return ((val) << A3XX_SP_VS_CTRL_REG0_INSTRBUFFERMODE__SHIFT) & A3XX_SP_VS_CTRL_REG0_INSTRBUFFERMODE__MASK;
}
#define A3XX_SP_VS_CTRL_REG0_CACHEINVALID			0x00000004
#define A3XX_SP_VS_CTRL_REG0_HALFREGFOOTPRINT__MASK		0x000003f0
#define A3XX_SP_VS_CTRL_REG0_HALFREGFOOTPRINT__SHIFT		4
static inline uint32_t A3XX_SP_VS_CTRL_REG0_HALFREGFOOTPRINT(uint32_t val)
{
	return ((val) << A3XX_SP_VS_CTRL_REG0_HALFREGFOOTPRINT__SHIFT) & A3XX_SP_VS_CTRL_REG0_HALFREGFOOTPRINT__MASK;
}
#define A3XX_SP_VS_CTRL_REG0_FULLREGFOOTPRINT__MASK		0x0003fc00
#define A3XX_SP_VS_CTRL_REG0_FULLREGFOOTPRINT__SHIFT		10
static inline uint32_t A3XX_SP_VS_CTRL_REG0_FULLREGFOOTPRINT(uint32_t val)
{
	return ((val) << A3XX_SP_VS_CTRL_REG0_FULLREGFOOTPRINT__SHIFT) & A3XX_SP_VS_CTRL_REG0_FULLREGFOOTPRINT__MASK;
}
#define A3XX_SP_VS_CTRL_REG0_INOUTREGOVERLAP__MASK		0x000c0000
#define A3XX_SP_VS_CTRL_REG0_INOUTREGOVERLAP__SHIFT		18
static inline uint32_t A3XX_SP_VS_CTRL_REG0_INOUTREGOVERLAP(uint32_t val)
{
	return ((val) << A3XX_SP_VS_CTRL_REG0_INOUTREGOVERLAP__SHIFT) & A3XX_SP_VS_CTRL_REG0_INOUTREGOVERLAP__MASK;
}
#define A3XX_SP_VS_CTRL_REG0_THREADSIZE__MASK			0x00100000
#define A3XX_SP_VS_CTRL_REG0_THREADSIZE__SHIFT			20
static inline uint32_t A3XX_SP_VS_CTRL_REG0_THREADSIZE(enum a3xx_threadsize val)
{
	return ((val) << A3XX_SP_VS_CTRL_REG0_THREADSIZE__SHIFT) & A3XX_SP_VS_CTRL_REG0_THREADSIZE__MASK;
}
#define A3XX_SP_VS_CTRL_REG0_SUPERTHREADMODE			0x00200000
#define A3XX_SP_VS_CTRL_REG0_PIXLODENABLE			0x00400000
#define A3XX_SP_VS_CTRL_REG0_LENGTH__MASK			0xff000000
#define A3XX_SP_VS_CTRL_REG0_LENGTH__SHIFT			24
static inline uint32_t A3XX_SP_VS_CTRL_REG0_LENGTH(uint32_t val)
{
	return ((val) << A3XX_SP_VS_CTRL_REG0_LENGTH__SHIFT) & A3XX_SP_VS_CTRL_REG0_LENGTH__MASK;
}

#define REG_A3XX_SP_VS_CTRL_REG1				0x000022c5
#define A3XX_SP_VS_CTRL_REG1_CONSTLENGTH__MASK			0x000003ff
#define A3XX_SP_VS_CTRL_REG1_CONSTLENGTH__SHIFT			0
static inline uint32_t A3XX_SP_VS_CTRL_REG1_CONSTLENGTH(uint32_t val)
{
	return ((val) << A3XX_SP_VS_CTRL_REG1_CONSTLENGTH__SHIFT) & A3XX_SP_VS_CTRL_REG1_CONSTLENGTH__MASK;
}
#define A3XX_SP_VS_CTRL_REG1_CONSTFOOTPRINT__MASK		0x000ffc00
#define A3XX_SP_VS_CTRL_REG1_CONSTFOOTPRINT__SHIFT		10
static inline uint32_t A3XX_SP_VS_CTRL_REG1_CONSTFOOTPRINT(uint32_t val)
{
	return ((val) << A3XX_SP_VS_CTRL_REG1_CONSTFOOTPRINT__SHIFT) & A3XX_SP_VS_CTRL_REG1_CONSTFOOTPRINT__MASK;
}
#define A3XX_SP_VS_CTRL_REG1_INITIALOUTSTANDING__MASK		0x3f000000
#define A3XX_SP_VS_CTRL_REG1_INITIALOUTSTANDING__SHIFT		24
static inline uint32_t A3XX_SP_VS_CTRL_REG1_INITIALOUTSTANDING(uint32_t val)
{
	return ((val) << A3XX_SP_VS_CTRL_REG1_INITIALOUTSTANDING__SHIFT) & A3XX_SP_VS_CTRL_REG1_INITIALOUTSTANDING__MASK;
}

#define REG_A3XX_SP_VS_PARAM_REG				0x000022c6
#define A3XX_SP_VS_PARAM_REG_POSREGID__MASK			0x000000ff
#define A3XX_SP_VS_PARAM_REG_POSREGID__SHIFT			0
static inline uint32_t A3XX_SP_VS_PARAM_REG_POSREGID(uint32_t val)
{
	return ((val) << A3XX_SP_VS_PARAM_REG_POSREGID__SHIFT) & A3XX_SP_VS_PARAM_REG_POSREGID__MASK;
}
#define A3XX_SP_VS_PARAM_REG_PSIZEREGID__MASK			0x0000ff00
#define A3XX_SP_VS_PARAM_REG_PSIZEREGID__SHIFT			8
static inline uint32_t A3XX_SP_VS_PARAM_REG_PSIZEREGID(uint32_t val)
{
	return ((val) << A3XX_SP_VS_PARAM_REG_PSIZEREGID__SHIFT) & A3XX_SP_VS_PARAM_REG_PSIZEREGID__MASK;
}
#define A3XX_SP_VS_PARAM_REG_TOTALVSOUTVAR__MASK		0xfff00000
#define A3XX_SP_VS_PARAM_REG_TOTALVSOUTVAR__SHIFT		20
static inline uint32_t A3XX_SP_VS_PARAM_REG_TOTALVSOUTVAR(uint32_t val)
{
	return ((val) << A3XX_SP_VS_PARAM_REG_TOTALVSOUTVAR__SHIFT) & A3XX_SP_VS_PARAM_REG_TOTALVSOUTVAR__MASK;
}

static inline uint32_t REG_A3XX_SP_VS_OUT(uint32_t i0) { return 0x000022c7 + 0x1*i0; }

static inline uint32_t REG_A3XX_SP_VS_OUT_REG(uint32_t i0) { return 0x000022c7 + 0x1*i0; }
#define A3XX_SP_VS_OUT_REG_A_REGID__MASK			0x000001ff
#define A3XX_SP_VS_OUT_REG_A_REGID__SHIFT			0
static inline uint32_t A3XX_SP_VS_OUT_REG_A_REGID(uint32_t val)
{
	return ((val) << A3XX_SP_VS_OUT_REG_A_REGID__SHIFT) & A3XX_SP_VS_OUT_REG_A_REGID__MASK;
}
#define A3XX_SP_VS_OUT_REG_A_COMPMASK__MASK			0x00001e00
#define A3XX_SP_VS_OUT_REG_A_COMPMASK__SHIFT			9
static inline uint32_t A3XX_SP_VS_OUT_REG_A_COMPMASK(uint32_t val)
{
	return ((val) << A3XX_SP_VS_OUT_REG_A_COMPMASK__SHIFT) & A3XX_SP_VS_OUT_REG_A_COMPMASK__MASK;
}
#define A3XX_SP_VS_OUT_REG_B_REGID__MASK			0x01ff0000
#define A3XX_SP_VS_OUT_REG_B_REGID__SHIFT			16
static inline uint32_t A3XX_SP_VS_OUT_REG_B_REGID(uint32_t val)
{
	return ((val) << A3XX_SP_VS_OUT_REG_B_REGID__SHIFT) & A3XX_SP_VS_OUT_REG_B_REGID__MASK;
}
#define A3XX_SP_VS_OUT_REG_B_COMPMASK__MASK			0x1e000000
#define A3XX_SP_VS_OUT_REG_B_COMPMASK__SHIFT			25
static inline uint32_t A3XX_SP_VS_OUT_REG_B_COMPMASK(uint32_t val)
{
	return ((val) << A3XX_SP_VS_OUT_REG_B_COMPMASK__SHIFT) & A3XX_SP_VS_OUT_REG_B_COMPMASK__MASK;
}

static inline uint32_t REG_A3XX_SP_VS_VPC_DST(uint32_t i0) { return 0x000022d0 + 0x1*i0; }

static inline uint32_t REG_A3XX_SP_VS_VPC_DST_REG(uint32_t i0) { return 0x000022d0 + 0x1*i0; }
#define A3XX_SP_VS_VPC_DST_REG_OUTLOC0__MASK			0x000000ff
#define A3XX_SP_VS_VPC_DST_REG_OUTLOC0__SHIFT			0
static inline uint32_t A3XX_SP_VS_VPC_DST_REG_OUTLOC0(uint32_t val)
{
	return ((val) << A3XX_SP_VS_VPC_DST_REG_OUTLOC0__SHIFT) & A3XX_SP_VS_VPC_DST_REG_OUTLOC0__MASK;
}
#define A3XX_SP_VS_VPC_DST_REG_OUTLOC1__MASK			0x0000ff00
#define A3XX_SP_VS_VPC_DST_REG_OUTLOC1__SHIFT			8
static inline uint32_t A3XX_SP_VS_VPC_DST_REG_OUTLOC1(uint32_t val)
{
	return ((val) << A3XX_SP_VS_VPC_DST_REG_OUTLOC1__SHIFT) & A3XX_SP_VS_VPC_DST_REG_OUTLOC1__MASK;
}
#define A3XX_SP_VS_VPC_DST_REG_OUTLOC2__MASK			0x00ff0000
#define A3XX_SP_VS_VPC_DST_REG_OUTLOC2__SHIFT			16
static inline uint32_t A3XX_SP_VS_VPC_DST_REG_OUTLOC2(uint32_t val)
{
	return ((val) << A3XX_SP_VS_VPC_DST_REG_OUTLOC2__SHIFT) & A3XX_SP_VS_VPC_DST_REG_OUTLOC2__MASK;
}
#define A3XX_SP_VS_VPC_DST_REG_OUTLOC3__MASK			0xff000000
#define A3XX_SP_VS_VPC_DST_REG_OUTLOC3__SHIFT			24
static inline uint32_t A3XX_SP_VS_VPC_DST_REG_OUTLOC3(uint32_t val)
{
	return ((val) << A3XX_SP_VS_VPC_DST_REG_OUTLOC3__SHIFT) & A3XX_SP_VS_VPC_DST_REG_OUTLOC3__MASK;
}

#define REG_A3XX_SP_VS_OBJ_OFFSET_REG				0x000022d4
#define A3XX_SP_VS_OBJ_OFFSET_REG_CONSTOBJECTOFFSET__MASK	0x01ff0000
#define A3XX_SP_VS_OBJ_OFFSET_REG_CONSTOBJECTOFFSET__SHIFT	16
static inline uint32_t A3XX_SP_VS_OBJ_OFFSET_REG_CONSTOBJECTOFFSET(uint32_t val)
{
	return ((val) << A3XX_SP_VS_OBJ_OFFSET_REG_CONSTOBJECTOFFSET__SHIFT) & A3XX_SP_VS_OBJ_OFFSET_REG_CONSTOBJECTOFFSET__MASK;
}
#define A3XX_SP_VS_OBJ_OFFSET_REG_SHADEROBJOFFSET__MASK		0xfe000000
#define A3XX_SP_VS_OBJ_OFFSET_REG_SHADEROBJOFFSET__SHIFT	25
static inline uint32_t A3XX_SP_VS_OBJ_OFFSET_REG_SHADEROBJOFFSET(uint32_t val)
{
	return ((val) << A3XX_SP_VS_OBJ_OFFSET_REG_SHADEROBJOFFSET__SHIFT) & A3XX_SP_VS_OBJ_OFFSET_REG_SHADEROBJOFFSET__MASK;
}

#define REG_A3XX_SP_VS_OBJ_START_REG				0x000022d5

#define REG_A3XX_SP_VS_PVT_MEM_PARAM_REG			0x000022d6

#define REG_A3XX_SP_VS_PVT_MEM_ADDR_REG				0x000022d7

#define REG_A3XX_SP_VS_PVT_MEM_SIZE_REG				0x000022d8

#define REG_A3XX_SP_VS_LENGTH_REG				0x000022df
#define A3XX_SP_VS_LENGTH_REG_SHADERLENGTH__MASK		0xffffffff
#define A3XX_SP_VS_LENGTH_REG_SHADERLENGTH__SHIFT		0
static inline uint32_t A3XX_SP_VS_LENGTH_REG_SHADERLENGTH(uint32_t val)
{
	return ((val) << A3XX_SP_VS_LENGTH_REG_SHADERLENGTH__SHIFT) & A3XX_SP_VS_LENGTH_REG_SHADERLENGTH__MASK;
}

#define REG_A3XX_SP_FS_CTRL_REG0				0x000022e0
#define A3XX_SP_FS_CTRL_REG0_THREADMODE__MASK			0x00000001
#define A3XX_SP_FS_CTRL_REG0_THREADMODE__SHIFT			0
static inline uint32_t A3XX_SP_FS_CTRL_REG0_THREADMODE(enum a3xx_threadmode val)
{
	return ((val) << A3XX_SP_FS_CTRL_REG0_THREADMODE__SHIFT) & A3XX_SP_FS_CTRL_REG0_THREADMODE__MASK;
}
#define A3XX_SP_FS_CTRL_REG0_INSTRBUFFERMODE__MASK		0x00000002
#define A3XX_SP_FS_CTRL_REG0_INSTRBUFFERMODE__SHIFT		1
static inline uint32_t A3XX_SP_FS_CTRL_REG0_INSTRBUFFERMODE(enum a3xx_instrbuffermode val)
{
	return ((val) << A3XX_SP_FS_CTRL_REG0_INSTRBUFFERMODE__SHIFT) & A3XX_SP_FS_CTRL_REG0_INSTRBUFFERMODE__MASK;
}
#define A3XX_SP_FS_CTRL_REG0_CACHEINVALID			0x00000004
#define A3XX_SP_FS_CTRL_REG0_HALFREGFOOTPRINT__MASK		0x000003f0
#define A3XX_SP_FS_CTRL_REG0_HALFREGFOOTPRINT__SHIFT		4
static inline uint32_t A3XX_SP_FS_CTRL_REG0_HALFREGFOOTPRINT(uint32_t val)
{
	return ((val) << A3XX_SP_FS_CTRL_REG0_HALFREGFOOTPRINT__SHIFT) & A3XX_SP_FS_CTRL_REG0_HALFREGFOOTPRINT__MASK;
}
#define A3XX_SP_FS_CTRL_REG0_FULLREGFOOTPRINT__MASK		0x0003fc00
#define A3XX_SP_FS_CTRL_REG0_FULLREGFOOTPRINT__SHIFT		10
static inline uint32_t A3XX_SP_FS_CTRL_REG0_FULLREGFOOTPRINT(uint32_t val)
{
	return ((val) << A3XX_SP_FS_CTRL_REG0_FULLREGFOOTPRINT__SHIFT) & A3XX_SP_FS_CTRL_REG0_FULLREGFOOTPRINT__MASK;
}
#define A3XX_SP_FS_CTRL_REG0_INOUTREGOVERLAP__MASK		0x000c0000
#define A3XX_SP_FS_CTRL_REG0_INOUTREGOVERLAP__SHIFT		18
static inline uint32_t A3XX_SP_FS_CTRL_REG0_INOUTREGOVERLAP(uint32_t val)
{
	return ((val) << A3XX_SP_FS_CTRL_REG0_INOUTREGOVERLAP__SHIFT) & A3XX_SP_FS_CTRL_REG0_INOUTREGOVERLAP__MASK;
}
#define A3XX_SP_FS_CTRL_REG0_THREADSIZE__MASK			0x00100000
#define A3XX_SP_FS_CTRL_REG0_THREADSIZE__SHIFT			20
static inline uint32_t A3XX_SP_FS_CTRL_REG0_THREADSIZE(enum a3xx_threadsize val)
{
	return ((val) << A3XX_SP_FS_CTRL_REG0_THREADSIZE__SHIFT) & A3XX_SP_FS_CTRL_REG0_THREADSIZE__MASK;
}
#define A3XX_SP_FS_CTRL_REG0_SUPERTHREADMODE			0x00200000
#define A3XX_SP_FS_CTRL_REG0_PIXLODENABLE			0x00400000
#define A3XX_SP_FS_CTRL_REG0_LENGTH__MASK			0xff000000
#define A3XX_SP_FS_CTRL_REG0_LENGTH__SHIFT			24
static inline uint32_t A3XX_SP_FS_CTRL_REG0_LENGTH(uint32_t val)
{
	return ((val) << A3XX_SP_FS_CTRL_REG0_LENGTH__SHIFT) & A3XX_SP_FS_CTRL_REG0_LENGTH__MASK;
}

#define REG_A3XX_SP_FS_CTRL_REG1				0x000022e1
#define A3XX_SP_FS_CTRL_REG1_CONSTLENGTH__MASK			0x000003ff
#define A3XX_SP_FS_CTRL_REG1_CONSTLENGTH__SHIFT			0
static inline uint32_t A3XX_SP_FS_CTRL_REG1_CONSTLENGTH(uint32_t val)
{
	return ((val) << A3XX_SP_FS_CTRL_REG1_CONSTLENGTH__SHIFT) & A3XX_SP_FS_CTRL_REG1_CONSTLENGTH__MASK;
}
#define A3XX_SP_FS_CTRL_REG1_CONSTFOOTPRINT__MASK		0x000ffc00
#define A3XX_SP_FS_CTRL_REG1_CONSTFOOTPRINT__SHIFT		10
static inline uint32_t A3XX_SP_FS_CTRL_REG1_CONSTFOOTPRINT(uint32_t val)
{
	return ((val) << A3XX_SP_FS_CTRL_REG1_CONSTFOOTPRINT__SHIFT) & A3XX_SP_FS_CTRL_REG1_CONSTFOOTPRINT__MASK;
}
#define A3XX_SP_FS_CTRL_REG1_INITIALOUTSTANDING__MASK		0x00f00000
#define A3XX_SP_FS_CTRL_REG1_INITIALOUTSTANDING__SHIFT		20
static inline uint32_t A3XX_SP_FS_CTRL_REG1_INITIALOUTSTANDING(uint32_t val)
{
	return ((val) << A3XX_SP_FS_CTRL_REG1_INITIALOUTSTANDING__SHIFT) & A3XX_SP_FS_CTRL_REG1_INITIALOUTSTANDING__MASK;
}
#define A3XX_SP_FS_CTRL_REG1_HALFPRECVAROFFSET__MASK		0x3f000000
#define A3XX_SP_FS_CTRL_REG1_HALFPRECVAROFFSET__SHIFT		24
static inline uint32_t A3XX_SP_FS_CTRL_REG1_HALFPRECVAROFFSET(uint32_t val)
{
	return ((val) << A3XX_SP_FS_CTRL_REG1_HALFPRECVAROFFSET__SHIFT) & A3XX_SP_FS_CTRL_REG1_HALFPRECVAROFFSET__MASK;
}

#define REG_A3XX_SP_FS_OBJ_OFFSET_REG				0x000022e2
#define A3XX_SP_FS_OBJ_OFFSET_REG_CONSTOBJECTOFFSET__MASK	0x01ff0000
#define A3XX_SP_FS_OBJ_OFFSET_REG_CONSTOBJECTOFFSET__SHIFT	16
static inline uint32_t A3XX_SP_FS_OBJ_OFFSET_REG_CONSTOBJECTOFFSET(uint32_t val)
{
	return ((val) << A3XX_SP_FS_OBJ_OFFSET_REG_CONSTOBJECTOFFSET__SHIFT) & A3XX_SP_FS_OBJ_OFFSET_REG_CONSTOBJECTOFFSET__MASK;
}
#define A3XX_SP_FS_OBJ_OFFSET_REG_SHADEROBJOFFSET__MASK		0xfe000000
#define A3XX_SP_FS_OBJ_OFFSET_REG_SHADEROBJOFFSET__SHIFT	25
static inline uint32_t A3XX_SP_FS_OBJ_OFFSET_REG_SHADEROBJOFFSET(uint32_t val)
{
	return ((val) << A3XX_SP_FS_OBJ_OFFSET_REG_SHADEROBJOFFSET__SHIFT) & A3XX_SP_FS_OBJ_OFFSET_REG_SHADEROBJOFFSET__MASK;
}

#define REG_A3XX_SP_FS_OBJ_START_REG				0x000022e3

#define REG_A3XX_SP_FS_PVT_MEM_PARAM_REG			0x000022e4

#define REG_A3XX_SP_FS_PVT_MEM_ADDR_REG				0x000022e5

#define REG_A3XX_SP_FS_PVT_MEM_SIZE_REG				0x000022e6

#define REG_A3XX_SP_FS_FLAT_SHAD_MODE_REG_0			0x000022e8

#define REG_A3XX_SP_FS_FLAT_SHAD_MODE_REG_1			0x000022e9

#define REG_A3XX_SP_FS_OUTPUT_REG				0x000022ec
#define A3XX_SP_FS_OUTPUT_REG_DEPTH_ENABLE			0x00000080
#define A3XX_SP_FS_OUTPUT_REG_DEPTH_REGID__MASK			0x0000ff00
#define A3XX_SP_FS_OUTPUT_REG_DEPTH_REGID__SHIFT		8
static inline uint32_t A3XX_SP_FS_OUTPUT_REG_DEPTH_REGID(uint32_t val)
{
	return ((val) << A3XX_SP_FS_OUTPUT_REG_DEPTH_REGID__SHIFT) & A3XX_SP_FS_OUTPUT_REG_DEPTH_REGID__MASK;
}

static inline uint32_t REG_A3XX_SP_FS_MRT(uint32_t i0) { return 0x000022f0 + 0x1*i0; }

static inline uint32_t REG_A3XX_SP_FS_MRT_REG(uint32_t i0) { return 0x000022f0 + 0x1*i0; }
#define A3XX_SP_FS_MRT_REG_REGID__MASK				0x000000ff
#define A3XX_SP_FS_MRT_REG_REGID__SHIFT				0
static inline uint32_t A3XX_SP_FS_MRT_REG_REGID(uint32_t val)
{
	return ((val) << A3XX_SP_FS_MRT_REG_REGID__SHIFT) & A3XX_SP_FS_MRT_REG_REGID__MASK;
}
#define A3XX_SP_FS_MRT_REG_HALF_PRECISION			0x00000100

static inline uint32_t REG_A3XX_SP_FS_IMAGE_OUTPUT(uint32_t i0) { return 0x000022f4 + 0x1*i0; }

static inline uint32_t REG_A3XX_SP_FS_IMAGE_OUTPUT_REG(uint32_t i0) { return 0x000022f4 + 0x1*i0; }
#define A3XX_SP_FS_IMAGE_OUTPUT_REG_MRTFORMAT__MASK		0x0000003f
#define A3XX_SP_FS_IMAGE_OUTPUT_REG_MRTFORMAT__SHIFT		0
static inline uint32_t A3XX_SP_FS_IMAGE_OUTPUT_REG_MRTFORMAT(enum a3xx_color_fmt val)
{
	return ((val) << A3XX_SP_FS_IMAGE_OUTPUT_REG_MRTFORMAT__SHIFT) & A3XX_SP_FS_IMAGE_OUTPUT_REG_MRTFORMAT__MASK;
}

#define REG_A3XX_SP_FS_LENGTH_REG				0x000022ff
#define A3XX_SP_FS_LENGTH_REG_SHADERLENGTH__MASK		0xffffffff
#define A3XX_SP_FS_LENGTH_REG_SHADERLENGTH__SHIFT		0
static inline uint32_t A3XX_SP_FS_LENGTH_REG_SHADERLENGTH(uint32_t val)
{
	return ((val) << A3XX_SP_FS_LENGTH_REG_SHADERLENGTH__SHIFT) & A3XX_SP_FS_LENGTH_REG_SHADERLENGTH__MASK;
}

#define REG_A3XX_TPL1_TP_VS_TEX_OFFSET				0x00002340
#define A3XX_TPL1_TP_VS_TEX_OFFSET_SAMPLEROFFSET__MASK		0x000000ff
#define A3XX_TPL1_TP_VS_TEX_OFFSET_SAMPLEROFFSET__SHIFT		0
static inline uint32_t A3XX_TPL1_TP_VS_TEX_OFFSET_SAMPLEROFFSET(uint32_t val)
{
	return ((val) << A3XX_TPL1_TP_VS_TEX_OFFSET_SAMPLEROFFSET__SHIFT) & A3XX_TPL1_TP_VS_TEX_OFFSET_SAMPLEROFFSET__MASK;
}
#define A3XX_TPL1_TP_VS_TEX_OFFSET_MEMOBJOFFSET__MASK		0x0000ff00
#define A3XX_TPL1_TP_VS_TEX_OFFSET_MEMOBJOFFSET__SHIFT		8
static inline uint32_t A3XX_TPL1_TP_VS_TEX_OFFSET_MEMOBJOFFSET(uint32_t val)
{
	return ((val) << A3XX_TPL1_TP_VS_TEX_OFFSET_MEMOBJOFFSET__SHIFT) & A3XX_TPL1_TP_VS_TEX_OFFSET_MEMOBJOFFSET__MASK;
}
#define A3XX_TPL1_TP_VS_TEX_OFFSET_BASETABLEPTR__MASK		0xffff0000
#define A3XX_TPL1_TP_VS_TEX_OFFSET_BASETABLEPTR__SHIFT		16
static inline uint32_t A3XX_TPL1_TP_VS_TEX_OFFSET_BASETABLEPTR(uint32_t val)
{
	return ((val) << A3XX_TPL1_TP_VS_TEX_OFFSET_BASETABLEPTR__SHIFT) & A3XX_TPL1_TP_VS_TEX_OFFSET_BASETABLEPTR__MASK;
}

#define REG_A3XX_TPL1_TP_VS_BORDER_COLOR_BASE_ADDR		0x00002341

#define REG_A3XX_TPL1_TP_FS_TEX_OFFSET				0x00002342
#define A3XX_TPL1_TP_FS_TEX_OFFSET_SAMPLEROFFSET__MASK		0x000000ff
#define A3XX_TPL1_TP_FS_TEX_OFFSET_SAMPLEROFFSET__SHIFT		0
static inline uint32_t A3XX_TPL1_TP_FS_TEX_OFFSET_SAMPLEROFFSET(uint32_t val)
{
	return ((val) << A3XX_TPL1_TP_FS_TEX_OFFSET_SAMPLEROFFSET__SHIFT) & A3XX_TPL1_TP_FS_TEX_OFFSET_SAMPLEROFFSET__MASK;
}
#define A3XX_TPL1_TP_FS_TEX_OFFSET_MEMOBJOFFSET__MASK		0x0000ff00
#define A3XX_TPL1_TP_FS_TEX_OFFSET_MEMOBJOFFSET__SHIFT		8
static inline uint32_t A3XX_TPL1_TP_FS_TEX_OFFSET_MEMOBJOFFSET(uint32_t val)
{
	return ((val) << A3XX_TPL1_TP_FS_TEX_OFFSET_MEMOBJOFFSET__SHIFT) & A3XX_TPL1_TP_FS_TEX_OFFSET_MEMOBJOFFSET__MASK;
}
#define A3XX_TPL1_TP_FS_TEX_OFFSET_BASETABLEPTR__MASK		0xffff0000
#define A3XX_TPL1_TP_FS_TEX_OFFSET_BASETABLEPTR__SHIFT		16
static inline uint32_t A3XX_TPL1_TP_FS_TEX_OFFSET_BASETABLEPTR(uint32_t val)
{
	return ((val) << A3XX_TPL1_TP_FS_TEX_OFFSET_BASETABLEPTR__SHIFT) & A3XX_TPL1_TP_FS_TEX_OFFSET_BASETABLEPTR__MASK;
}

#define REG_A3XX_TPL1_TP_FS_BORDER_COLOR_BASE_ADDR		0x00002343

#define REG_A3XX_VBIF_CLKON					0x00003001

#define REG_A3XX_VBIF_FIXED_SORT_EN				0x0000300c

#define REG_A3XX_VBIF_FIXED_SORT_SEL0				0x0000300d

#define REG_A3XX_VBIF_FIXED_SORT_SEL1				0x0000300e

#define REG_A3XX_VBIF_ABIT_SORT					0x0000301c

#define REG_A3XX_VBIF_ABIT_SORT_CONF				0x0000301d

#define REG_A3XX_VBIF_GATE_OFF_WRREQ_EN				0x0000302a

#define REG_A3XX_VBIF_IN_RD_LIM_CONF0				0x0000302c

#define REG_A3XX_VBIF_IN_RD_LIM_CONF1				0x0000302d

#define REG_A3XX_VBIF_IN_WR_LIM_CONF0				0x00003030

#define REG_A3XX_VBIF_IN_WR_LIM_CONF1				0x00003031

#define REG_A3XX_VBIF_OUT_RD_LIM_CONF0				0x00003034

#define REG_A3XX_VBIF_OUT_WR_LIM_CONF0				0x00003035

#define REG_A3XX_VBIF_DDR_OUT_MAX_BURST				0x00003036

#define REG_A3XX_VBIF_ARB_CTL					0x0000303c

#define REG_A3XX_VBIF_ROUND_ROBIN_QOS_ARB			0x00003049

#define REG_A3XX_VBIF_OUT_AXI_AMEMTYPE_CONF0			0x00003058

#define REG_A3XX_VBIF_OUT_AXI_AOOO_EN				0x0000305e

#define REG_A3XX_VBIF_OUT_AXI_AOOO				0x0000305f

#define REG_A3XX_VSC_BIN_SIZE					0x00000c01
#define A3XX_VSC_BIN_SIZE_WIDTH__MASK				0x0000001f
#define A3XX_VSC_BIN_SIZE_WIDTH__SHIFT				0
static inline uint32_t A3XX_VSC_BIN_SIZE_WIDTH(uint32_t val)
{
	return ((val >> 5) << A3XX_VSC_BIN_SIZE_WIDTH__SHIFT) & A3XX_VSC_BIN_SIZE_WIDTH__MASK;
}
#define A3XX_VSC_BIN_SIZE_HEIGHT__MASK				0x000003e0
#define A3XX_VSC_BIN_SIZE_HEIGHT__SHIFT				5
static inline uint32_t A3XX_VSC_BIN_SIZE_HEIGHT(uint32_t val)
{
	return ((val >> 5) << A3XX_VSC_BIN_SIZE_HEIGHT__SHIFT) & A3XX_VSC_BIN_SIZE_HEIGHT__MASK;
}

#define REG_A3XX_VSC_SIZE_ADDRESS				0x00000c02

static inline uint32_t REG_A3XX_VSC_PIPE(uint32_t i0) { return 0x00000c06 + 0x3*i0; }

static inline uint32_t REG_A3XX_VSC_PIPE_CONFIG(uint32_t i0) { return 0x00000c06 + 0x3*i0; }
#define A3XX_VSC_PIPE_CONFIG_X__MASK				0x000003ff
#define A3XX_VSC_PIPE_CONFIG_X__SHIFT				0
static inline uint32_t A3XX_VSC_PIPE_CONFIG_X(uint32_t val)
{
	return ((val) << A3XX_VSC_PIPE_CONFIG_X__SHIFT) & A3XX_VSC_PIPE_CONFIG_X__MASK;
}
#define A3XX_VSC_PIPE_CONFIG_Y__MASK				0x000ffc00
#define A3XX_VSC_PIPE_CONFIG_Y__SHIFT				10
static inline uint32_t A3XX_VSC_PIPE_CONFIG_Y(uint32_t val)
{
	return ((val) << A3XX_VSC_PIPE_CONFIG_Y__SHIFT) & A3XX_VSC_PIPE_CONFIG_Y__MASK;
}
#define A3XX_VSC_PIPE_CONFIG_W__MASK				0x00f00000
#define A3XX_VSC_PIPE_CONFIG_W__SHIFT				20
static inline uint32_t A3XX_VSC_PIPE_CONFIG_W(uint32_t val)
{
	return ((val) << A3XX_VSC_PIPE_CONFIG_W__SHIFT) & A3XX_VSC_PIPE_CONFIG_W__MASK;
}
#define A3XX_VSC_PIPE_CONFIG_H__MASK				0x0f000000
#define A3XX_VSC_PIPE_CONFIG_H__SHIFT				24
static inline uint32_t A3XX_VSC_PIPE_CONFIG_H(uint32_t val)
{
	return ((val) << A3XX_VSC_PIPE_CONFIG_H__SHIFT) & A3XX_VSC_PIPE_CONFIG_H__MASK;
}

static inline uint32_t REG_A3XX_VSC_PIPE_DATA_ADDRESS(uint32_t i0) { return 0x00000c07 + 0x3*i0; }

static inline uint32_t REG_A3XX_VSC_PIPE_DATA_LENGTH(uint32_t i0) { return 0x00000c08 + 0x3*i0; }

#define REG_A3XX_VSC_BIN_CONTROL				0x00000c3c
#define A3XX_VSC_BIN_CONTROL_BINNING_ENABLE			0x00000001

#define REG_A3XX_UNKNOWN_0C3D					0x00000c3d

#define REG_A3XX_PC_PERFCOUNTER0_SELECT				0x00000c48

#define REG_A3XX_PC_PERFCOUNTER1_SELECT				0x00000c49

#define REG_A3XX_PC_PERFCOUNTER2_SELECT				0x00000c4a

#define REG_A3XX_PC_PERFCOUNTER3_SELECT				0x00000c4b

#define REG_A3XX_GRAS_TSE_DEBUG_ECO				0x00000c81

#define REG_A3XX_GRAS_PERFCOUNTER0_SELECT			0x00000c88

#define REG_A3XX_GRAS_PERFCOUNTER1_SELECT			0x00000c89

#define REG_A3XX_GRAS_PERFCOUNTER2_SELECT			0x00000c8a

#define REG_A3XX_GRAS_PERFCOUNTER3_SELECT			0x00000c8b

static inline uint32_t REG_A3XX_GRAS_CL_USER_PLANE(uint32_t i0) { return 0x00000ca0 + 0x4*i0; }

static inline uint32_t REG_A3XX_GRAS_CL_USER_PLANE_X(uint32_t i0) { return 0x00000ca0 + 0x4*i0; }

static inline uint32_t REG_A3XX_GRAS_CL_USER_PLANE_Y(uint32_t i0) { return 0x00000ca1 + 0x4*i0; }

static inline uint32_t REG_A3XX_GRAS_CL_USER_PLANE_Z(uint32_t i0) { return 0x00000ca2 + 0x4*i0; }

static inline uint32_t REG_A3XX_GRAS_CL_USER_PLANE_W(uint32_t i0) { return 0x00000ca3 + 0x4*i0; }

#define REG_A3XX_RB_GMEM_BASE_ADDR				0x00000cc0

#define REG_A3XX_RB_DEBUG_ECO_CONTROLS_ADDR			0x00000cc1

#define REG_A3XX_RB_PERFCOUNTER0_SELECT				0x00000cc6

#define REG_A3XX_RB_PERFCOUNTER1_SELECT				0x00000cc7

#define REG_A3XX_RB_FRAME_BUFFER_DIMENSION			0x00000ce0
#define A3XX_RB_FRAME_BUFFER_DIMENSION_WIDTH__MASK		0x00003fff
#define A3XX_RB_FRAME_BUFFER_DIMENSION_WIDTH__SHIFT		0
static inline uint32_t A3XX_RB_FRAME_BUFFER_DIMENSION_WIDTH(uint32_t val)
{
	return ((val) << A3XX_RB_FRAME_BUFFER_DIMENSION_WIDTH__SHIFT) & A3XX_RB_FRAME_BUFFER_DIMENSION_WIDTH__MASK;
}
#define A3XX_RB_FRAME_BUFFER_DIMENSION_HEIGHT__MASK		0x0fffc000
#define A3XX_RB_FRAME_BUFFER_DIMENSION_HEIGHT__SHIFT		14
static inline uint32_t A3XX_RB_FRAME_BUFFER_DIMENSION_HEIGHT(uint32_t val)
{
	return ((val) << A3XX_RB_FRAME_BUFFER_DIMENSION_HEIGHT__SHIFT) & A3XX_RB_FRAME_BUFFER_DIMENSION_HEIGHT__MASK;
}

#define REG_A3XX_HLSQ_PERFCOUNTER0_SELECT			0x00000e00

#define REG_A3XX_HLSQ_PERFCOUNTER1_SELECT			0x00000e01

#define REG_A3XX_HLSQ_PERFCOUNTER2_SELECT			0x00000e02

#define REG_A3XX_HLSQ_PERFCOUNTER3_SELECT			0x00000e03

#define REG_A3XX_HLSQ_PERFCOUNTER4_SELECT			0x00000e04

#define REG_A3XX_HLSQ_PERFCOUNTER5_SELECT			0x00000e05

#define REG_A3XX_UNKNOWN_0E43					0x00000e43

#define REG_A3XX_VFD_PERFCOUNTER0_SELECT			0x00000e44

#define REG_A3XX_VFD_PERFCOUNTER1_SELECT			0x00000e45

#define REG_A3XX_VPC_VPC_DEBUG_RAM_SEL				0x00000e61

#define REG_A3XX_VPC_VPC_DEBUG_RAM_READ				0x00000e62

#define REG_A3XX_VPC_PERFCOUNTER0_SELECT			0x00000e64

#define REG_A3XX_VPC_PERFCOUNTER1_SELECT			0x00000e65

#define REG_A3XX_UCHE_CACHE_MODE_CONTROL_REG			0x00000e82

#define REG_A3XX_UCHE_PERFCOUNTER0_SELECT			0x00000e84

#define REG_A3XX_UCHE_PERFCOUNTER1_SELECT			0x00000e85

#define REG_A3XX_UCHE_PERFCOUNTER2_SELECT			0x00000e86

#define REG_A3XX_UCHE_PERFCOUNTER3_SELECT			0x00000e87

#define REG_A3XX_UCHE_PERFCOUNTER4_SELECT			0x00000e88

#define REG_A3XX_UCHE_PERFCOUNTER5_SELECT			0x00000e89

#define REG_A3XX_UCHE_CACHE_INVALIDATE0_REG			0x00000ea0
#define A3XX_UCHE_CACHE_INVALIDATE0_REG_ADDR__MASK		0x0fffffff
#define A3XX_UCHE_CACHE_INVALIDATE0_REG_ADDR__SHIFT		0
static inline uint32_t A3XX_UCHE_CACHE_INVALIDATE0_REG_ADDR(uint32_t val)
{
	return ((val) << A3XX_UCHE_CACHE_INVALIDATE0_REG_ADDR__SHIFT) & A3XX_UCHE_CACHE_INVALIDATE0_REG_ADDR__MASK;
}

#define REG_A3XX_UCHE_CACHE_INVALIDATE1_REG			0x00000ea1
#define A3XX_UCHE_CACHE_INVALIDATE1_REG_ADDR__MASK		0x0fffffff
#define A3XX_UCHE_CACHE_INVALIDATE1_REG_ADDR__SHIFT		0
static inline uint32_t A3XX_UCHE_CACHE_INVALIDATE1_REG_ADDR(uint32_t val)
{
	return ((val) << A3XX_UCHE_CACHE_INVALIDATE1_REG_ADDR__SHIFT) & A3XX_UCHE_CACHE_INVALIDATE1_REG_ADDR__MASK;
}
#define A3XX_UCHE_CACHE_INVALIDATE1_REG_OPCODE__MASK		0x30000000
#define A3XX_UCHE_CACHE_INVALIDATE1_REG_OPCODE__SHIFT		28
static inline uint32_t A3XX_UCHE_CACHE_INVALIDATE1_REG_OPCODE(enum a3xx_cache_opcode val)
{
	return ((val) << A3XX_UCHE_CACHE_INVALIDATE1_REG_OPCODE__SHIFT) & A3XX_UCHE_CACHE_INVALIDATE1_REG_OPCODE__MASK;
}
#define A3XX_UCHE_CACHE_INVALIDATE1_REG_ENTIRE_CACHE		0x80000000

#define REG_A3XX_UNKNOWN_0EA6					0x00000ea6

#define REG_A3XX_SP_PERFCOUNTER0_SELECT				0x00000ec4

#define REG_A3XX_SP_PERFCOUNTER1_SELECT				0x00000ec5

#define REG_A3XX_SP_PERFCOUNTER2_SELECT				0x00000ec6

#define REG_A3XX_SP_PERFCOUNTER3_SELECT				0x00000ec7

#define REG_A3XX_SP_PERFCOUNTER4_SELECT				0x00000ec8

#define REG_A3XX_SP_PERFCOUNTER5_SELECT				0x00000ec9

#define REG_A3XX_SP_PERFCOUNTER6_SELECT				0x00000eca

#define REG_A3XX_SP_PERFCOUNTER7_SELECT				0x00000ecb

#define REG_A3XX_UNKNOWN_0EE0					0x00000ee0

#define REG_A3XX_UNKNOWN_0F03					0x00000f03

#define REG_A3XX_TP_PERFCOUNTER0_SELECT				0x00000f04

#define REG_A3XX_TP_PERFCOUNTER1_SELECT				0x00000f05

#define REG_A3XX_TP_PERFCOUNTER2_SELECT				0x00000f06

#define REG_A3XX_TP_PERFCOUNTER3_SELECT				0x00000f07

#define REG_A3XX_TP_PERFCOUNTER4_SELECT				0x00000f08

#define REG_A3XX_TP_PERFCOUNTER5_SELECT				0x00000f09

#define REG_A3XX_VGT_CL_INITIATOR				0x000021f0

#define REG_A3XX_VGT_EVENT_INITIATOR				0x000021f9

#define REG_A3XX_VGT_DRAW_INITIATOR				0x000021fc
#define A3XX_VGT_DRAW_INITIATOR_PRIM_TYPE__MASK			0x0000003f
#define A3XX_VGT_DRAW_INITIATOR_PRIM_TYPE__SHIFT		0
static inline uint32_t A3XX_VGT_DRAW_INITIATOR_PRIM_TYPE(enum pc_di_primtype val)
{
	return ((val) << A3XX_VGT_DRAW_INITIATOR_PRIM_TYPE__SHIFT) & A3XX_VGT_DRAW_INITIATOR_PRIM_TYPE__MASK;
}
#define A3XX_VGT_DRAW_INITIATOR_SOURCE_SELECT__MASK		0x000000c0
#define A3XX_VGT_DRAW_INITIATOR_SOURCE_SELECT__SHIFT		6
static inline uint32_t A3XX_VGT_DRAW_INITIATOR_SOURCE_SELECT(enum pc_di_src_sel val)
{
	return ((val) << A3XX_VGT_DRAW_INITIATOR_SOURCE_SELECT__SHIFT) & A3XX_VGT_DRAW_INITIATOR_SOURCE_SELECT__MASK;
}
#define A3XX_VGT_DRAW_INITIATOR_VIS_CULL__MASK			0x00000600
#define A3XX_VGT_DRAW_INITIATOR_VIS_CULL__SHIFT			9
static inline uint32_t A3XX_VGT_DRAW_INITIATOR_VIS_CULL(enum pc_di_vis_cull_mode val)
{
	return ((val) << A3XX_VGT_DRAW_INITIATOR_VIS_CULL__SHIFT) & A3XX_VGT_DRAW_INITIATOR_VIS_CULL__MASK;
}
#define A3XX_VGT_DRAW_INITIATOR_INDEX_SIZE__MASK		0x00000800
#define A3XX_VGT_DRAW_INITIATOR_INDEX_SIZE__SHIFT		11
static inline uint32_t A3XX_VGT_DRAW_INITIATOR_INDEX_SIZE(enum pc_di_index_size val)
{
	return ((val) << A3XX_VGT_DRAW_INITIATOR_INDEX_SIZE__SHIFT) & A3XX_VGT_DRAW_INITIATOR_INDEX_SIZE__MASK;
}
#define A3XX_VGT_DRAW_INITIATOR_NOT_EOP				0x00001000
#define A3XX_VGT_DRAW_INITIATOR_SMALL_INDEX			0x00002000
#define A3XX_VGT_DRAW_INITIATOR_PRE_DRAW_INITIATOR_ENABLE	0x00004000
#define A3XX_VGT_DRAW_INITIATOR_NUM_INDICES__MASK		0xffff0000
#define A3XX_VGT_DRAW_INITIATOR_NUM_INDICES__SHIFT		16
static inline uint32_t A3XX_VGT_DRAW_INITIATOR_NUM_INDICES(uint32_t val)
{
	return ((val) << A3XX_VGT_DRAW_INITIATOR_NUM_INDICES__SHIFT) & A3XX_VGT_DRAW_INITIATOR_NUM_INDICES__MASK;
}

#define REG_A3XX_VGT_IMMED_DATA					0x000021fd

#define REG_A3XX_TEX_SAMP_0					0x00000000
#define A3XX_TEX_SAMP_0_MIPFILTER_LINEAR			0x00000002
#define A3XX_TEX_SAMP_0_XY_MAG__MASK				0x0000000c
#define A3XX_TEX_SAMP_0_XY_MAG__SHIFT				2
static inline uint32_t A3XX_TEX_SAMP_0_XY_MAG(enum a3xx_tex_filter val)
{
	return ((val) << A3XX_TEX_SAMP_0_XY_MAG__SHIFT) & A3XX_TEX_SAMP_0_XY_MAG__MASK;
}
#define A3XX_TEX_SAMP_0_XY_MIN__MASK				0x00000030
#define A3XX_TEX_SAMP_0_XY_MIN__SHIFT				4
static inline uint32_t A3XX_TEX_SAMP_0_XY_MIN(enum a3xx_tex_filter val)
{
	return ((val) << A3XX_TEX_SAMP_0_XY_MIN__SHIFT) & A3XX_TEX_SAMP_0_XY_MIN__MASK;
}
#define A3XX_TEX_SAMP_0_WRAP_S__MASK				0x000001c0
#define A3XX_TEX_SAMP_0_WRAP_S__SHIFT				6
static inline uint32_t A3XX_TEX_SAMP_0_WRAP_S(enum a3xx_tex_clamp val)
{
	return ((val) << A3XX_TEX_SAMP_0_WRAP_S__SHIFT) & A3XX_TEX_SAMP_0_WRAP_S__MASK;
}
#define A3XX_TEX_SAMP_0_WRAP_T__MASK				0x00000e00
#define A3XX_TEX_SAMP_0_WRAP_T__SHIFT				9
static inline uint32_t A3XX_TEX_SAMP_0_WRAP_T(enum a3xx_tex_clamp val)
{
	return ((val) << A3XX_TEX_SAMP_0_WRAP_T__SHIFT) & A3XX_TEX_SAMP_0_WRAP_T__MASK;
}
#define A3XX_TEX_SAMP_0_WRAP_R__MASK				0x00007000
#define A3XX_TEX_SAMP_0_WRAP_R__SHIFT				12
static inline uint32_t A3XX_TEX_SAMP_0_WRAP_R(enum a3xx_tex_clamp val)
{
	return ((val) << A3XX_TEX_SAMP_0_WRAP_R__SHIFT) & A3XX_TEX_SAMP_0_WRAP_R__MASK;
}
#define A3XX_TEX_SAMP_0_UNNORM_COORDS				0x80000000

#define REG_A3XX_TEX_SAMP_1					0x00000001
#define A3XX_TEX_SAMP_1_MAX_LOD__MASK				0x003ff000
#define A3XX_TEX_SAMP_1_MAX_LOD__SHIFT				12
static inline uint32_t A3XX_TEX_SAMP_1_MAX_LOD(float val)
{
	return ((((uint32_t)(val * 12.0))) << A3XX_TEX_SAMP_1_MAX_LOD__SHIFT) & A3XX_TEX_SAMP_1_MAX_LOD__MASK;
}
#define A3XX_TEX_SAMP_1_MIN_LOD__MASK				0xffc00000
#define A3XX_TEX_SAMP_1_MIN_LOD__SHIFT				22
static inline uint32_t A3XX_TEX_SAMP_1_MIN_LOD(float val)
{
	return ((((uint32_t)(val * 12.0))) << A3XX_TEX_SAMP_1_MIN_LOD__SHIFT) & A3XX_TEX_SAMP_1_MIN_LOD__MASK;
}

#define REG_A3XX_TEX_CONST_0					0x00000000
#define A3XX_TEX_CONST_0_TILED					0x00000001
#define A3XX_TEX_CONST_0_SWIZ_X__MASK				0x00000070
#define A3XX_TEX_CONST_0_SWIZ_X__SHIFT				4
static inline uint32_t A3XX_TEX_CONST_0_SWIZ_X(enum a3xx_tex_swiz val)
{
	return ((val) << A3XX_TEX_CONST_0_SWIZ_X__SHIFT) & A3XX_TEX_CONST_0_SWIZ_X__MASK;
}
#define A3XX_TEX_CONST_0_SWIZ_Y__MASK				0x00000380
#define A3XX_TEX_CONST_0_SWIZ_Y__SHIFT				7
static inline uint32_t A3XX_TEX_CONST_0_SWIZ_Y(enum a3xx_tex_swiz val)
{
	return ((val) << A3XX_TEX_CONST_0_SWIZ_Y__SHIFT) & A3XX_TEX_CONST_0_SWIZ_Y__MASK;
}
#define A3XX_TEX_CONST_0_SWIZ_Z__MASK				0x00001c00
#define A3XX_TEX_CONST_0_SWIZ_Z__SHIFT				10
static inline uint32_t A3XX_TEX_CONST_0_SWIZ_Z(enum a3xx_tex_swiz val)
{
	return ((val) << A3XX_TEX_CONST_0_SWIZ_Z__SHIFT) & A3XX_TEX_CONST_0_SWIZ_Z__MASK;
}
#define A3XX_TEX_CONST_0_SWIZ_W__MASK				0x0000e000
#define A3XX_TEX_CONST_0_SWIZ_W__SHIFT				13
static inline uint32_t A3XX_TEX_CONST_0_SWIZ_W(enum a3xx_tex_swiz val)
{
	return ((val) << A3XX_TEX_CONST_0_SWIZ_W__SHIFT) & A3XX_TEX_CONST_0_SWIZ_W__MASK;
}
#define A3XX_TEX_CONST_0_MIPLVLS__MASK				0x000f0000
#define A3XX_TEX_CONST_0_MIPLVLS__SHIFT				16
static inline uint32_t A3XX_TEX_CONST_0_MIPLVLS(uint32_t val)
{
	return ((val) << A3XX_TEX_CONST_0_MIPLVLS__SHIFT) & A3XX_TEX_CONST_0_MIPLVLS__MASK;
}
#define A3XX_TEX_CONST_0_FMT__MASK				0x1fc00000
#define A3XX_TEX_CONST_0_FMT__SHIFT				22
static inline uint32_t A3XX_TEX_CONST_0_FMT(enum a3xx_tex_fmt val)
{
	return ((val) << A3XX_TEX_CONST_0_FMT__SHIFT) & A3XX_TEX_CONST_0_FMT__MASK;
}
#define A3XX_TEX_CONST_0_TYPE__MASK				0xc0000000
#define A3XX_TEX_CONST_0_TYPE__SHIFT				30
static inline uint32_t A3XX_TEX_CONST_0_TYPE(enum a3xx_tex_type val)
{
	return ((val) << A3XX_TEX_CONST_0_TYPE__SHIFT) & A3XX_TEX_CONST_0_TYPE__MASK;
}

#define REG_A3XX_TEX_CONST_1					0x00000001
#define A3XX_TEX_CONST_1_HEIGHT__MASK				0x00003fff
#define A3XX_TEX_CONST_1_HEIGHT__SHIFT				0
static inline uint32_t A3XX_TEX_CONST_1_HEIGHT(uint32_t val)
{
	return ((val) << A3XX_TEX_CONST_1_HEIGHT__SHIFT) & A3XX_TEX_CONST_1_HEIGHT__MASK;
}
#define A3XX_TEX_CONST_1_WIDTH__MASK				0x0fffc000
#define A3XX_TEX_CONST_1_WIDTH__SHIFT				14
static inline uint32_t A3XX_TEX_CONST_1_WIDTH(uint32_t val)
{
	return ((val) << A3XX_TEX_CONST_1_WIDTH__SHIFT) & A3XX_TEX_CONST_1_WIDTH__MASK;
}
#define A3XX_TEX_CONST_1_FETCHSIZE__MASK			0xf0000000
#define A3XX_TEX_CONST_1_FETCHSIZE__SHIFT			28
static inline uint32_t A3XX_TEX_CONST_1_FETCHSIZE(enum a3xx_tex_fetchsize val)
{
	return ((val) << A3XX_TEX_CONST_1_FETCHSIZE__SHIFT) & A3XX_TEX_CONST_1_FETCHSIZE__MASK;
}

#define REG_A3XX_TEX_CONST_2					0x00000002
#define A3XX_TEX_CONST_2_INDX__MASK				0x000000ff
#define A3XX_TEX_CONST_2_INDX__SHIFT				0
static inline uint32_t A3XX_TEX_CONST_2_INDX(uint32_t val)
{
	return ((val) << A3XX_TEX_CONST_2_INDX__SHIFT) & A3XX_TEX_CONST_2_INDX__MASK;
}
#define A3XX_TEX_CONST_2_PITCH__MASK				0x3ffff000
#define A3XX_TEX_CONST_2_PITCH__SHIFT				12
static inline uint32_t A3XX_TEX_CONST_2_PITCH(uint32_t val)
{
	return ((val) << A3XX_TEX_CONST_2_PITCH__SHIFT) & A3XX_TEX_CONST_2_PITCH__MASK;
}
#define A3XX_TEX_CONST_2_SWAP__MASK				0xc0000000
#define A3XX_TEX_CONST_2_SWAP__SHIFT				30
static inline uint32_t A3XX_TEX_CONST_2_SWAP(enum a3xx_color_swap val)
{
	return ((val) << A3XX_TEX_CONST_2_SWAP__SHIFT) & A3XX_TEX_CONST_2_SWAP__MASK;
}

#define REG_A3XX_TEX_CONST_3					0x00000003


#endif /* A3XX_XML */
