# Copyright 2015 VMware Inc.
#
#    Licensed under the Apache License, Version 2.0 (the "License");
#    you may not use this file except in compliance with the License.
#    You may obtain a copy of the License at
#
#        http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS,
#    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#    See the License for the specific language governing permissions and
#    limitations under the License.

"""Module for MKS consoles."""

from oslo_config import cfg


mks_opts = [
    cfg.StrOpt('mksproxy_base_url',
               default='http://127.0.0.1:6090/',
               help='Location of MKS web console proxy, in the form '
                    '"http://127.0.0.1:6090/"'),
    cfg.BoolOpt('enabled',
                default=False,
                help='Enable MKS related features'),
    ]

CONF = cfg.CONF
CONF.register_opts(mks_opts, group='mks')
