/*
 * Copyright (C) 2008 Instituto Nokia de Tecnologia. All rights reserved.
 *
 * This file is part of QZion.
 *
 * QZion is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * QZion is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with QZion.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __QZIONCUSTOMOBJECT_H__
#define __QZIONCUSTOMOBJECT_H__

#include "qzionobject.h"

class QZionCustomObjectPrivate;


/*!
    \brief The QZionCustomObject is the base class to extend QZion
    widgets. It creates the internal data necessary for the backend.

    To create a new widget that can blit on canvas, you must inherit
    QZionCustomObject.
*/
class QZionCustomObject : public QZionObject
{
    Q_OBJECT

public:
    QZionCustomObject(QZionAbstractCanvas *canvas = NULL);

    virtual ~QZionCustomObject();

    virtual QSize size() const;
    virtual void setSize(const QSize &size);

protected:
    QZionCustomObjectPrivate *_QZionCustomObject_data;

private:
    friend class QZionCustomObjectPrivate;
};

#endif
