/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.ResizeLayoutPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeaderPanel
extends Panel
implements RequiresResize {
    private Widget content;
    private final Element contentContainer;
    private Widget footer;
    private final Element footerContainer;
    private final ResizeLayoutPanel.Impl footerImpl = (ResizeLayoutPanel.Impl)GWT.create(ResizeLayoutPanel.Impl.class);
    private Widget header;
    private final Element headerContainer;
    private final ResizeLayoutPanel.Impl headerImpl = (ResizeLayoutPanel.Impl)GWT.create(ResizeLayoutPanel.Impl.class);
    private final Scheduler.ScheduledCommand layoutCmd = new Scheduler.ScheduledCommand(){

        public void execute() {
            HeaderPanel.this.layoutScheduled = false;
            HeaderPanel.this.forceLayout();
        }
    };
    private boolean layoutScheduled = false;

    public HeaderPanel() {
        Element elem = (Element)Document.get().createDivElement().cast();
        elem.getStyle().setPosition(Style.Position.RELATIVE);
        elem.getStyle().setOverflow(Style.Overflow.HIDDEN);
        this.setElement(elem);
        ResizeLayoutPanel.Impl.Delegate resizeDelegate = new ResizeLayoutPanel.Impl.Delegate(){

            public void onResize() {
                HeaderPanel.this.scheduledLayout();
            }
        };
        this.headerContainer = this.createContainer();
        this.headerContainer.getStyle().setTop(0.0, Style.Unit.PX);
        this.headerImpl.init(this.headerContainer, resizeDelegate);
        elem.appendChild(this.headerContainer);
        this.footerContainer = this.createContainer();
        this.footerContainer.getStyle().setBottom(0.0, Style.Unit.PX);
        this.footerImpl.init(this.footerContainer, resizeDelegate);
        elem.appendChild(this.footerContainer);
        this.contentContainer = this.createContainer();
        this.contentContainer.getStyle().setOverflow(Style.Overflow.HIDDEN);
        this.contentContainer.getStyle().setTop(0.0, Style.Unit.PX);
        this.contentContainer.getStyle().setHeight(0.0, Style.Unit.PX);
        elem.appendChild(this.contentContainer);
    }

    @Override
    public void add(Widget w) {
        if (this.header == null) {
            this.setHeaderWidget(w);
        } else if (this.content == null) {
            this.setContentWidget(w);
        } else if (this.footer == null) {
            this.setFooterWidget(w);
        } else {
            throw new IllegalStateException("HeaderPanel already contains header, content, and footer widgets.");
        }
    }

    public Widget getContentWidget() {
        return this.content;
    }

    public Widget getFooterWidget() {
        return this.footer;
    }

    public Widget getHeaderWidget() {
        return this.header;
    }

    @Override
    public Iterator<Widget> iterator() {
        return new Iterator<Widget>(){
            private int index = -1;

            @Override
            public boolean hasNext() {
                switch (this.index) {
                    case -1: {
                        if (HeaderPanel.this.header != null) {
                            return true;
                        }
                    }
                    case 0: {
                        if (HeaderPanel.this.content != null) {
                            return true;
                        }
                    }
                    case 1: {
                        if (HeaderPanel.this.footer == null) break;
                        return true;
                    }
                }
                return false;
            }

            @Override
            public Widget next() {
                switch (this.index) {
                    case -1: {
                        ++this.index;
                        if (HeaderPanel.this.header != null) {
                            return HeaderPanel.this.header;
                        }
                    }
                    case 0: {
                        ++this.index;
                        if (HeaderPanel.this.content != null) {
                            return HeaderPanel.this.content;
                        }
                    }
                    case 1: {
                        ++this.index;
                        if (HeaderPanel.this.footer == null) break;
                        return HeaderPanel.this.footer;
                    }
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                switch (this.index) {
                    case 0: {
                        this.doRemove(HeaderPanel.this.header, "Header");
                        break;
                    }
                    case 1: {
                        this.doRemove(HeaderPanel.this.content, "Content");
                        break;
                    }
                    case 2: {
                        this.doRemove(HeaderPanel.this.footer, "Footer");
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }

            private void doRemove(Widget widget, String position) {
                if (widget == null) {
                    throw new IllegalStateException(position + " was already removed.");
                }
                HeaderPanel.this.remove(widget);
            }
        };
    }

    @Override
    public void onAttach() {
        super.onAttach();
        this.headerImpl.onAttach();
        this.footerImpl.onAttach();
        this.scheduledLayout();
    }

    @Override
    public void onDetach() {
        super.onDetach();
        this.headerImpl.onDetach();
        this.footerImpl.onDetach();
    }

    @Override
    public void onResize() {
        this.scheduledLayout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Widget w) {
        if (w.getParent() != this) {
            return false;
        }
        try {
            this.orphan(w);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            w.getElement().removeFromParent();
            if (w == this.content) {
                this.content = null;
                this.contentContainer.getStyle().setDisplay(Style.Display.NONE);
            } else if (w == this.header) {
                this.header = null;
                this.headerContainer.getStyle().setDisplay(Style.Display.NONE);
            } else if (w == this.footer) {
                this.footer = null;
                this.footerContainer.getStyle().setDisplay(Style.Display.NONE);
            }
            throw throwable;
        }
        w.getElement().removeFromParent();
        if (w == this.content) {
            this.content = null;
            this.contentContainer.getStyle().setDisplay(Style.Display.NONE);
        } else if (w == this.header) {
            this.header = null;
            this.headerContainer.getStyle().setDisplay(Style.Display.NONE);
        } else if (w == this.footer) {
            this.footer = null;
            this.footerContainer.getStyle().setDisplay(Style.Display.NONE);
        }
        return true;
    }

    public void setContentWidget(Widget w) {
        this.contentContainer.getStyle().clearDisplay();
        this.add(w, this.content, this.contentContainer);
        this.content = w;
        this.scheduledLayout();
    }

    public void setFooterWidget(Widget w) {
        this.footerContainer.getStyle().clearDisplay();
        this.add(w, this.footer, this.footerContainer);
        this.footer = w;
        this.scheduledLayout();
    }

    public void setHeaderWidget(Widget w) {
        this.headerContainer.getStyle().clearDisplay();
        this.add(w, this.header, this.headerContainer);
        this.header = w;
        this.scheduledLayout();
    }

    private void add(Widget w, Widget toReplace, Element container) {
        if (w == toReplace) {
            return;
        }
        if (w != null) {
            w.removeFromParent();
        }
        if (toReplace != null) {
            this.remove(toReplace);
        }
        if (w != null) {
            container.appendChild(w.getElement());
            this.adopt(w);
        }
    }

    private Element createContainer() {
        Element container = (Element)Document.get().createDivElement().cast();
        container.getStyle().setPosition(Style.Position.ABSOLUTE);
        container.getStyle().setDisplay(Style.Display.NONE);
        container.getStyle().setLeft(0.0, Style.Unit.PX);
        container.getStyle().setWidth(100.0, Style.Unit.PCT);
        return container;
    }

    private void forceLayout() {
        if (!this.isAttached() || this.content == null) {
            return;
        }
        int remainingHeight = this.getElement().getClientHeight();
        if (this.header != null) {
            int height = Math.max(0, this.headerContainer.getOffsetHeight());
            remainingHeight -= height;
            this.contentContainer.getStyle().setTop(height, Style.Unit.PX);
        } else {
            this.contentContainer.getStyle().setTop(0.0, Style.Unit.PX);
        }
        if (this.footer != null) {
            remainingHeight -= this.footerContainer.getOffsetHeight();
        }
        this.contentContainer.getStyle().setHeight(Math.max(0, remainingHeight), Style.Unit.PX);
        if (this.content instanceof RequiresResize) {
            ((RequiresResize)((Object)this.content)).onResize();
        }
    }

    private void scheduledLayout() {
        if (this.isAttached() && !this.layoutScheduled) {
            this.layoutScheduled = true;
            Scheduler.get().scheduleDeferred(this.layoutCmd);
        }
    }
}

