/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.DockLayoutPanel;
import com.google.gwt.user.client.ui.Widget;

public class SplitLayoutPanel
extends DockLayoutPanel {
    private static final int DEFAULT_SPLITTER_SIZE = 8;
    private static Element glassElem = null;
    private final int splitterSize;

    public SplitLayoutPanel() {
        this(8);
    }

    public SplitLayoutPanel(int splitterSize) {
        super(Style.Unit.PX);
        this.splitterSize = splitterSize;
        this.setStyleName("gwt-SplitLayoutPanel");
        if (glassElem == null) {
            glassElem = Document.get().createDivElement();
            glassElem.getStyle().setPosition(Style.Position.ABSOLUTE);
            glassElem.getStyle().setTop(0.0, Style.Unit.PX);
            glassElem.getStyle().setLeft(0.0, Style.Unit.PX);
            glassElem.getStyle().setMargin(0.0, Style.Unit.PX);
            glassElem.getStyle().setPadding(0.0, Style.Unit.PX);
            glassElem.getStyle().setBorderWidth(0.0, Style.Unit.PX);
            glassElem.getStyle().setProperty("background", "white");
            glassElem.getStyle().setOpacity(0.0);
        }
    }

    public int getSplitterSize() {
        return this.splitterSize;
    }

    public void insert(Widget child, DockLayoutPanel.Direction direction, double size, Widget before) {
        super.insert(child, direction, size, before);
        if (direction != DockLayoutPanel.Direction.CENTER) {
            this.insertSplitter(child, before);
        }
    }

    public boolean remove(Widget child) {
        assert (!(child instanceof Splitter)) : "Splitters may not be directly removed";
        int idx = this.getWidgetIndex(child);
        if (super.remove(child)) {
            if (idx < this.getWidgetCount()) {
                super.remove(this.getWidget(idx));
            }
            return true;
        }
        return false;
    }

    public void setWidgetMinSize(Widget child, int minSize) {
        this.assertIsChild(child);
        Splitter splitter = this.getAssociatedSplitter(child);
        if (splitter != null) {
            splitter.setMinSize(minSize);
        }
    }

    private Splitter getAssociatedSplitter(Widget child) {
        int idx = this.getWidgetIndex(child);
        if (idx > -1 && idx < this.getWidgetCount() - 1) {
            Widget splitter = this.getWidget(idx + 1);
            assert (splitter instanceof Splitter) : "Expected child widget to be splitter";
            return (Splitter)splitter;
        }
        return null;
    }

    private void insertSplitter(Widget widget, Widget before) {
        assert (this.getChildren().size() > 0) : "Can't add a splitter before any children";
        DockLayoutPanel.LayoutData layout = (DockLayoutPanel.LayoutData)widget.getLayoutData();
        Splitter splitter = null;
        switch (this.getResolvedDirection(layout.direction)) {
            case WEST: {
                splitter = new HSplitter(widget, false);
                break;
            }
            case EAST: {
                splitter = new HSplitter(widget, true);
                break;
            }
            case NORTH: {
                splitter = new VSplitter(widget, false);
                break;
            }
            case SOUTH: {
                splitter = new VSplitter(widget, true);
                break;
            }
            default: {
                assert (false) : "Unexpected direction";
                break;
            }
        }
        super.insert((Widget)splitter, layout.direction, (double)this.splitterSize, before);
    }

    class VSplitter
    extends Splitter {
        public VSplitter(Widget target, boolean reverse) {
            super(target, reverse);
            this.getElement().getStyle().setPropertyPx("height", SplitLayoutPanel.this.splitterSize);
            this.setStyleName("gwt-SplitLayoutPanel-VDragger");
        }

        protected int getAbsolutePosition() {
            return this.getAbsoluteTop();
        }

        protected double getCenterSize() {
            return SplitLayoutPanel.this.getCenterHeight();
        }

        protected int getEventPosition(Event event) {
            return event.getClientY();
        }

        protected int getTargetPosition() {
            return this.target.getAbsoluteTop();
        }

        protected int getTargetSize() {
            return this.target.getOffsetHeight();
        }
    }

    abstract class Splitter
    extends Widget {
        protected final Widget target;
        private int offset;
        private boolean mouseDown;
        private Scheduler.ScheduledCommand layoutCommand;
        private final boolean reverse;
        private int minSize;
        private double centerSize;
        private double syncedCenterSize;

        public Splitter(Widget target, boolean reverse) {
            this.target = target;
            this.reverse = reverse;
            this.setElement(Document.get().createDivElement());
            this.sinkEvents(78);
        }

        public void onBrowserEvent(Event event) {
            switch (event.getTypeInt()) {
                case 4: {
                    this.mouseDown = true;
                    int width = Math.max(Window.getClientWidth(), Document.get().getScrollWidth());
                    int height = Math.max(Window.getClientHeight(), Document.get().getScrollHeight());
                    glassElem.getStyle().setHeight(height, Style.Unit.PX);
                    glassElem.getStyle().setWidth(width, Style.Unit.PX);
                    Document.get().getBody().appendChild(glassElem);
                    this.offset = this.getEventPosition(event) - this.getAbsolutePosition();
                    Event.setCapture(this.getElement());
                    event.preventDefault();
                    break;
                }
                case 8: {
                    this.mouseDown = false;
                    glassElem.removeFromParent();
                    Event.releaseCapture(this.getElement());
                    event.preventDefault();
                    break;
                }
                case 64: {
                    if (!this.mouseDown) break;
                    int size = this.reverse ? this.getTargetPosition() + this.getTargetSize() - this.getEventPosition(event) - this.offset : this.getEventPosition(event) - this.getTargetPosition() - this.offset;
                    this.setAssociatedWidgetSize(size);
                    event.preventDefault();
                }
            }
        }

        public void setMinSize(int minSize) {
            this.minSize = minSize;
            DockLayoutPanel.LayoutData layout = (DockLayoutPanel.LayoutData)this.target.getLayoutData();
            this.setAssociatedWidgetSize((int)layout.size);
        }

        protected abstract int getAbsolutePosition();

        protected abstract double getCenterSize();

        protected abstract int getEventPosition(Event var1);

        protected abstract int getTargetPosition();

        protected abstract int getTargetSize();

        private double getMaxSize() {
            double newCenterSize = this.getCenterSize();
            if (this.syncedCenterSize != newCenterSize) {
                this.syncedCenterSize = newCenterSize;
                this.centerSize = newCenterSize;
            }
            return Math.max(((DockLayoutPanel.LayoutData)this.target.getLayoutData()).size + this.centerSize, 0.0);
        }

        private void setAssociatedWidgetSize(double size) {
            double maxSize = this.getMaxSize();
            if (size > maxSize) {
                size = maxSize;
            }
            if (size < (double)this.minSize) {
                size = this.minSize;
            }
            DockLayoutPanel.LayoutData layout = (DockLayoutPanel.LayoutData)this.target.getLayoutData();
            if (size == layout.size) {
                return;
            }
            this.centerSize += layout.size - size;
            layout.size = size;
            if (this.layoutCommand == null) {
                this.layoutCommand = new Command(){

                    public void execute() {
                        Splitter.this.layoutCommand = null;
                        SplitLayoutPanel.this.forceLayout();
                    }
                };
                Scheduler.get().scheduleDeferred(this.layoutCommand);
            }
        }
    }

    class HSplitter
    extends Splitter {
        public HSplitter(Widget target, boolean reverse) {
            super(target, reverse);
            this.getElement().getStyle().setPropertyPx("width", SplitLayoutPanel.this.splitterSize);
            this.setStyleName("gwt-SplitLayoutPanel-HDragger");
        }

        protected int getAbsolutePosition() {
            return this.getAbsoluteLeft();
        }

        protected double getCenterSize() {
            return SplitLayoutPanel.this.getCenterWidth();
        }

        protected int getEventPosition(Event event) {
            return event.getClientX();
        }

        protected int getTargetPosition() {
            return this.target.getAbsoluteLeft();
        }

        protected int getTargetSize() {
            return this.target.getOffsetWidth();
        }
    }
}

