/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.wave;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.WaveModule;
import edu.harvard.hul.ois.jhove.module.iff.Chunk;
import edu.harvard.hul.ois.jhove.module.iff.ChunkHeader;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;

public class PeakEnvelopeChunk
extends Chunk {
    public PeakEnvelopeChunk(ModuleBase moduleBase, ChunkHeader chunkHeader, DataInputStream dataInputStream) {
        super(moduleBase, chunkHeader, dataInputStream);
    }

    @Override
    public boolean readChunk(RepInfo repInfo) throws IOException {
        WaveModule waveModule = (WaveModule)this._module;
        long l = waveModule.readUnsignedInt(this._dstream);
        long l2 = waveModule.readUnsignedInt(this._dstream);
        long l3 = waveModule.readUnsignedInt(this._dstream);
        long l4 = waveModule.readUnsignedInt(this._dstream);
        long l5 = waveModule.readUnsignedInt(this._dstream);
        long l6 = waveModule.readUnsignedInt(this._dstream);
        long l7 = waveModule.readUnsignedInt(this._dstream);
        long l8 = waveModule.readUnsignedInt(this._dstream);
        byte[] byArray = new byte[28];
        ModuleBase.readByteBuf((DataInputStream)this._dstream, (byte[])byArray, (ModuleBase)waveModule);
        String string = this.byteBufString(byArray);
        waveModule.skipBytes(this._dstream, 60, waveModule);
        Property property = null;
        if (this.bytesLeft > 120L) {
            int n = (int)(this.bytesLeft - 120L);
            int n2 = 0;
            int n3 = 0;
            if (l2 == 1L) {
                n2 = n;
            } else if (l2 == 2L) {
                n2 = n / 2;
            } else {
                repInfo.setValid(false);
                repInfo.setMessage((Message)new ErrorMessage("Invalid format value in Peak Envelope Chunk"));
            }
            if (l3 == 1L) {
                n3 = n2;
            } else if (l3 == 2L) {
                n3 = n2 / 2;
            } else {
                repInfo.setValid(false);
                repInfo.setMessage((Message)new ErrorMessage("Invalid pointsPerValue in Peak Envelope Chunk"));
            }
            if (repInfo.getValid() == 0) {
                waveModule.skipBytes(this._dstream, (int)this.bytesLeft - 120, waveModule);
                return true;
            }
            if (l3 == 2L) {
                Property[] propertyArray = new Property[n3];
                for (int i = 0; i < n3; ++i) {
                    int[] nArray = new int[2];
                    propertyArray[i] = new Property("Point", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)nArray);
                    if (l2 == 1L) {
                        nArray[0] = ModuleBase.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)waveModule);
                        nArray[1] = ModuleBase.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)waveModule);
                        continue;
                    }
                    nArray[0] = waveModule.readUnsignedShort(this._dstream);
                    nArray[1] = waveModule.readUnsignedShort(this._dstream);
                }
                property = new Property("PeakEnvelopeData", PropertyType.PROPERTY, PropertyArity.ARRAY, (Object)propertyArray);
            } else {
                int[] nArray = new int[n3];
                for (int i = 0; i < n3; ++i) {
                    nArray[i] = l2 == 1L ? ModuleBase.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)waveModule) : waveModule.readUnsignedShort(this._dstream);
                }
                property = new Property("PeakEnvelopeData", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)nArray);
            }
        }
        ArrayList<Property> arrayList = new ArrayList<Property>(20);
        arrayList.add(new Property("Version", PropertyType.LONG, (Object)new Long(l)));
        arrayList.add(new Property("Format", PropertyType.LONG, (Object)new Long(l2)));
        arrayList.add(new Property("PointsPerValue", PropertyType.LONG, (Object)new Long(l3)));
        arrayList.add(new Property("BlockSize", PropertyType.LONG, (Object)new Long(l4)));
        arrayList.add(new Property("PeakChannels", PropertyType.LONG, (Object)new Long(l5)));
        arrayList.add(new Property("NumPeakFrames", PropertyType.LONG, (Object)new Long(l6)));
        arrayList.add(new Property("PosPeakOfPeaks", PropertyType.LONG, (Object)new Long(l7)));
        arrayList.add(new Property("OffsetToPeaks", PropertyType.LONG, (Object)new Long(l8)));
        if (string.length() > 0) {
            arrayList.add(new Property("Timestamp", PropertyType.STRING, (Object)string));
        }
        if (property != null) {
            arrayList.add(property);
        }
        waveModule.addWaveProperty(new Property("PeakEnvelope", PropertyType.PROPERTY, PropertyArity.LIST, arrayList));
        return true;
    }
}

