/* Gumbo */

#define NUM_GUMBO_TRI_PATCHES 10
#define NUM_GUMBO_QUAD_PATCHES 118
#define NUM_GUMBO_VERTS 1276

const int gumboTriPatches[NUM_GUMBO_TRI_PATCHES][10] = {
{ 318,319,320,243,317,322,240,316,237,234},
{ 198,488,489,490,496,492,493,497,495,498},
{ 599,600,601,279,607,603,604,608,606,609},
{ 522,661,662,498,666,664,659,667,660,609},
{ 507,504,501,498,516,669,662,519,661,522},
{ 616,625,628,522,613,672,666,610,667,609},
{ 694,695,696,697,703,699,700,702,702,702},
{ 724,725,726,727,733,729,730,732,732,732},
{ 793,792,791,790,796,795,799,798,798,798},
{ 823,822,821,820,826,825,829,828,828,828},
};

const int gumboQuadPatches[NUM_GUMBO_QUAD_PATCHES][16] = {
{0,1010,1014,1,1011,2,3,1012,1016,5,6,1017,4,1013,1015,7},
{0,1018,8,9,1019,10,11,12,1021,13,14,15,1,1020,16,17},
{1,1022,16,17,1023,18,19,20,1025,21,22,23,7,1024,24,25},
{7,1026,24,25,1027,26,27,28,1029,29,30,31,4,1028,32,33},
{4,1030,32,33,1031,34,35,36,1033,37,38,39,0,1032,8,9},
{40,1034,1038,41,1035,42,43,1036,1040,45,46,1041,44,1037,1039,47},
{40,1042,48,49,1043,50,51,52,1045,53,54,55,41,1044,56,57},
{41,1046,56,57,1047,58,59,60,1049,61,62,63,47,1048,64,65},
{47,1050,64,65,1051,66,67,68,1053,69,70,71,44,1052,72,73},
{44,1054,72,73,1055,74,75,76,1057,77,78,79,40,1056,48,49},
{80,1058,1062,81,1059,82,83,1060,1064,85,86,1065,84,1061,1063,87},
{80,1066,88,89,1067,90,91,92,1069,93,94,95,81,1068,96,97},
{81,1070,96,97,1071,98,99,100,1073,101,102,103,87,1072,104,105},
{87,1074,104,105,1075,106,107,108,1077,109,110,111,84,1076,112,113},
{84,1078,112,113,1079,114,115,116,1081,117,118,119,80,1080,88,89},
{120,1082,1086,121,1083,122,123,1084,1088,125,126,1089,124,1085,1087,127},
{120,1090,128,129,1091,130,131,132,1093,133,134,135,121,1092,136,137},
{121,1094,136,137,1095,138,139,140,1097,141,142,143,127,1096,144,145},
{127,1098,144,145,1099,146,147,148,1101,149,150,151,124,1100,152,153},
{124,1102,152,153,1103,154,155,156,1105,157,158,159,120,1104,128,129},
{17,160,161,49,20,162,163,79,23,164,165,76,25,166,167,73},
{25,166,167,73,168,169,170,171,172,173,174,175,137,176,177,89},
{137,176,177,89,140,178,179,119,143,180,181,116,145,182,183,113},
{33,31,28,25,184,185,186,168,187,188,189,172,129,132,135,137},
{73,71,68,65,171,190,191,192,175,193,194,195,89,92,95,97},
{9,196,197,198,12,199,200,201,15,202,203,204,17,205,206,207},
{17,205,206,207,160,208,209,210,161,211,212,213,49,214,215,216},
{49,214,215,216,52,217,218,219,55,220,221,222,57,223,224,225},
{57,223,224,225,60,226,227,228,63,229,230,231,65,232,233,234},
{65,232,233,234,192,235,236,237,195,238,239,240,97,241,242,243},
{97,241,242,243,100,244,245,246,103,247,248,249,105,250,251,252},
{105,250,251,252,108,253,254,255,111,256,257,258,113,259,260,261},
{113,259,260,261,183,262,263,264,182,265,266,267,145,268,269,270},
{145,268,269,270,148,271,272,273,151,274,275,276,153,277,278,279},
{198,280,281,282,201,283,284,285,204,286,287,288,207,289,290,291},
{207,289,290,291,210,292,293,294,213,295,296,297,216,298,299,300},
{216,298,299,300,219,301,302,303,222,304,305,306,225,307,308,309},
{225,307,308,309,228,310,311,312,231,313,314,315,234,316,317,318},
{243,320,319,318,246,324,325,326,249,327,328,329,252,330,331,332},
{252,330,331,332,255,333,334,335,258,336,337,338,261,339,340,341},
{261,339,340,341,264,342,343,344,267,345,346,347,270,348,349,350},
{270,348,349,350,273,351,352,353,276,354,355,356,279,357,358,359},
{282,360,361,362,285,363,364,365,288,366,367,368,291,369,370,371},
{291,369,370,371,294,372,373,374,297,375,376,377,300,378,379,380},
{300,378,379,380,303,381,382,383,306,384,385,1107,309,387,1106,386},
{309,387,1109,386,312,388,389,1108,315,390,391,392,318,326,329,332},
{332,392,1111,386,335,393,394,1110,338,395,396,383,341,397,398,380},
{341,397,398,380,344,399,400,377,347,401,402,374,350,403,404,371},
{350,403,404,371,353,405,406,368,356,407,408,365,359,409,410,362},
{362,361,360,282,411,412,413,414,415,416,417,1113,419,420,1112,418},
{419,420,1115,418,421,422,423,1114,424,425,426,427,428,429,430,431},
{428,429,430,431,432,433,434,435,436,437,438,439,440,441,442,443},
{440,441,442,443,444,445,446,447,448,449,450,451,452,453,454,455},
{452,453,454,455,456,457,458,459,460,461,462,463,464,465,466,467},
{464,465,466,467,468,469,470,471,1118,473,474,1119,472,1116,1117,475},
{472,1120,1124,475,1121,476,477,1122,1126,479,480,1127,478,1123,1125,481},
{9,39,36,33,196,482,483,484,197,485,486,487,198,488,489,490},
{198,496,497,498,280,499,500,501,281,502,503,504,282,505,506,507},
{282,505,506,507,414,508,509,510,1129,511,512,513,418,1128,427,431},
{431,513,510,507,435,514,515,516,439,517,518,519,443,520,521,522},
{443,520,521,522,447,523,524,525,451,526,527,528,455,529,530,531},
{455,529,530,531,459,532,533,534,463,535,536,537,467,538,539,540},
{467,538,539,540,471,541,542,543,1132,544,545,1133,475,1130,1131,481},
{359,409,410,362,546,547,548,411,1135,550,551,415,549,1134,552,419},
{549,1136,552,419,1137,553,554,421,555,556,557,424,558,559,560,428},
{558,559,560,428,561,562,563,432,564,565,566,436,567,568,569,440},
{567,568,569,440,570,571,572,444,573,574,575,448,576,577,578,452},
{576,577,578,452,579,580,581,456,582,583,584,460,585,586,587,464},
{585,586,587,464,588,589,590,468,1140,591,592,1141,478,1138,1139,472},
{129,159,156,153,593,594,595,277,596,597,598,278,599,600,601,279},
{609,606,604,279,610,611,612,357,613,614,615,358,616,617,618,359},
{616,617,618,359,619,620,621,546,622,623,624,1143,558,555,1142,549},
{616,619,622,558,625,626,627,561,628,629,630,564,522,631,632,567},
{522,631,632,567,525,633,634,570,528,635,636,573,531,637,638,576},
{531,637,638,576,534,639,640,579,537,641,642,582,540,643,644,585},
{540,643,644,585,543,645,646,588,1146,647,648,1147,481,1144,1145,478},
{33,184,187,129,484,649,650,593,487,651,652,596,490,653,654,599},
{490,653,654,599,493,655,656,607,495,657,658,608,498,659,660,609},
{674,675,1149,676,677,678,679,1148,680,681,682,1151,684,685,1150,683},
{674,677,680,684,686,687,688,689,690,691,692,693,694,695,696,697},
{704,705,706,707,708,709,710,711,1154,713,714,1155,712,1152,1153,715},
{707,706,705,704,716,717,718,719,720,721,722,723,724,725,726,727},
{674,734,735,704,675,736,737,708,1158,738,739,1159,676,1156,1157,712},
{676,1160,1164,712,1161,740,741,1162,1166,742,743,1167,683,1163,1165,715},
{683,1168,1171,715,1169,744,745,1170,685,746,747,711,684,748,749,707},
{684,748,749,707,689,750,751,716,693,752,753,720,697,754,755,724},
{697,754,755,724,700,756,757,733,1174,758,759,1175,702,1172,1173,732},
{702,1176,1179,732,1177,760,761,1178,703,762,763,730,694,764,765,727},
{694,764,765,727,690,766,767,723,686,768,769,719,674,734,735,704},
{772,1180,771,770,1181,775,774,773,1183,778,777,776,779,1182,781,780},
{780,776,773,770,785,784,783,782,789,788,787,786,793,792,791,790},
{803,802,801,800,807,806,805,804,1186,810,809,1187,811,1184,1185,808},
{800,801,802,803,815,814,813,812,819,818,817,816,823,822,821,820},
{800,831,830,770,804,833,832,771,1190,835,834,1191,808,1188,1189,772},
{808,1192,1196,772,1193,837,836,1194,1198,839,838,1199,811,1195,1197,779},
{811,1200,1203,779,1201,841,840,1202,807,843,842,781,803,845,844,780},
{803,845,844,780,812,847,846,785,816,849,848,789,820,851,850,793},
{820,851,850,793,829,853,852,797,1206,855,854,1207,828,1204,1205,798},
{828,1208,1211,798,1209,857,856,1210,826,859,858,799,823,861,860,790},
{790,860,861,823,786,862,863,819,782,864,865,815,770,830,831,800},
{866,1212,867,868,869,870,871,872,873,874,875,876,877,1213,878,879},
{877,1214,878,879,880,881,882,883,884,885,886,887,888,1215,889,890},
{888,1216,889,890,891,892,893,894,895,896,897,898,899,1217,900,901},
{899,1218,900,901,902,903,904,905,906,907,908,909,866,1219,867,868},
{868,910,1221,911,872,912,913,1220,876,914,915,1223,879,917,1222,916},
{879,917,1225,916,883,918,919,1224,887,920,921,1227,890,923,1226,922},
{890,923,1229,922,894,924,925,1228,898,926,927,1231,901,929,1230,928},
{901,929,1233,928,905,930,931,1232,909,932,933,1235,868,910,1234,911},
{916,1236,1240,911,1237,934,935,1238,1242,936,937,1243,922,1239,1241,928},
{938,1244,939,940,941,942,943,944,945,946,947,948,949,1245,950,951},
{949,1246,950,951,952,953,954,955,956,957,958,959,960,1247,961,962},
{960,1248,961,962,963,964,965,966,967,968,969,970,971,1249,972,973},
{971,1250,972,973,974,975,976,977,978,979,980,981,938,1251,939,940},
{940,982,1253,983,944,984,985,1252,948,986,987,1255,951,989,1254,988},
{951,989,1257,988,955,990,991,1256,959,992,993,1259,962,995,1258,994},
{962,995,1261,994,966,996,997,1260,970,998,999,1263,973,1001,1262,1000},
{973,1001,1265,1000,977,1002,1003,1264,981,1004,1005,1267,940,982,1266,983},
{988,1268,1272,983,1269,1006,1007,1270,1274,1008,1009,1275,994,1271,1273,1000},
};

const float gumboVerts[NUM_GUMBO_VERTS][3] = {
{-0.16062,-0.332671,-0.466414},
{-0.0131587,-0.332671,-0.466414},
{-0.152225,-0.324275,-0.5},
{-0.0215566,-0.324275,-0.5},
{-0.16062,-0.18521,-0.466414},
{-0.152225,-0.193607,-0.5},
{-0.0215566,-0.193606,-0.5},
{-0.0131587,-0.18521,-0.466414},
{-0.151466,-0.329549,-0.269715},
{-0.16062,-0.332671,-0.171492},
{-0.141903,-0.38952,-0.390155},
{-0.113156,-0.36786,-0.269715},
{-0.122309,-0.370982,-0.171492},
{-0.0318383,-0.389563,-0.389983},
{-0.0762904,-0.326057,-0.273305},
{-0.0656327,-0.355673,-0.180119},
{-0.0301204,-0.29875,-0.284564},
{-0.0131587,-0.332671,-0.171492},
{0.0437315,-0.313995,-0.389983},
{0.0123557,-0.273628,-0.294922},
{0.0554473,-0.279071,-0.222949},
{0.0437055,-0.203911,-0.390081},
{-0.0296706,-0.273168,-0.275959},
{0.0249302,-0.26139,-0.209582},
{-0.0652898,-0.237341,-0.275754},
{-0.0131587,-0.18521,-0.171492},
{-0.0318604,-0.128343,-0.390081},
{-0.100308,-0.202124,-0.275553},
{-0.0773263,-0.153128,-0.203574},
{-0.141855,-0.12841,-0.390348},
{-0.105119,-0.158499,-0.28488},
{-0.109679,-0.126418,-0.197214},
{-0.137892,-0.20174,-0.280708},
{-0.16062,-0.18521,-0.171492},
{-0.21742,-0.203978,-0.390348},
{-0.170991,-0.24541,-0.276495},
{-0.198609,-0.242733,-0.18358},
{-0.217469,-0.313952,-0.390155},
{-0.190835,-0.290179,-0.269715},
{-0.19999,-0.293301,-0.171492},
{0.134302,-0.332671,-0.466414},
{0.281763,-0.332671,-0.466414},
{0.142696,-0.324275,-0.5},
{0.273365,-0.324275,-0.5},
{0.134302,-0.18521,-0.466414},
{0.142696,-0.193606,-0.5},
{0.273365,-0.193607,-0.5},
{0.281763,-0.18521,-0.466414},
{0.156879,-0.287516,-0.284381},
{0.134302,-0.332671,-0.171492},
{0.15297,-0.389567,-0.389966},
{0.201939,-0.316392,-0.271689},
{0.190514,-0.355158,-0.182736},
{0.263065,-0.389543,-0.390063},
{0.245314,-0.36093,-0.269744},
{0.243357,-0.371077,-0.171492},
{0.28372,-0.322525,-0.269744},
{0.281763,-0.332671,-0.171492},
{0.338632,-0.313975,-0.390063},
{0.322411,-0.283833,-0.269744},
{0.320453,-0.293979,-0.171492},
{0.338635,-0.203903,-0.390049},
{0.289302,-0.243466,-0.274487},
{0.312855,-0.243024,-0.179266},
{0.261086,-0.197025,-0.281205},
{0.281763,-0.18521,-0.171492},
{0.263069,-0.128335,-0.390049},
{0.232511,-0.149999,-0.288007},
{0.237702,-0.120495,-0.199806},
{0.153,-0.128343,-0.390081},
{0.222532,-0.201582,-0.276096},
{0.19955,-0.152585,-0.204118},
{0.186492,-0.2374,-0.275872},
{0.134302,-0.18521,-0.171492},
{0.0774338,-0.203911,-0.390081},
{0.151116,-0.272555,-0.275653},
{0.0965186,-0.260777,-0.209276},
{0.0774044,-0.313999,-0.389966},
{0.11911,-0.263311,-0.295021},
{0.0763133,-0.274685,-0.229479},
{0.134302,-0.11148,-0.466414},
{0.281763,-0.11148,-0.466414},
{0.142696,-0.103083,-0.5},
{0.273365,-0.103084,-0.5},
{0.134302,0.0359809,-0.466414},
{0.142696,0.0275836,-0.5},
{0.273365,0.0275836,-0.5},
{0.281763,0.0359809,-0.466414},
{0.186488,-0.05929,-0.275872},
{0.134302,-0.11148,-0.171492},
{0.153,-0.168348,-0.390081},
{0.222532,-0.0951086,-0.276096},
{0.19955,-0.144105,-0.204118},
{0.263069,-0.168355,-0.390049},
{0.232511,-0.146692,-0.288007},
{0.237702,-0.176195,-0.199806},
{0.261086,-0.0996647,-0.281205},
{0.281763,-0.11148,-0.171492},
{0.338635,-0.0927872,-0.390049},
{0.289302,-0.0532246,-0.274487},
{0.312855,-0.0536666,-0.179266},
{0.338632,0.0172835,-0.390063},
{0.322411,-0.0128579,-0.269744},
{0.320453,-0.00271258,-0.171492},
{0.28372,0.0258326,-0.269744},
{0.281763,0.0359809,-0.171492},
{0.263065,0.0928495,-0.390063},
{0.245314,0.0642387,-0.269744},
{0.243357,0.0743836,-0.171492},
{0.15297,0.0928756,-0.389966},
{0.201939,0.0197013,-0.271689},
{0.190547,0.0584798,-0.182742},
{0.156879,-0.00917501,-0.284381},
{0.134302,0.0359809,-0.171492},
{0.0774044,0.0173087,-0.389966},
{0.11911,-0.0333808,-0.295021},
{0.0763536,-0.0219673,-0.229438},
{0.0774338,-0.0927795,-0.390081},
{0.151116,-0.0241349,-0.275653},
{0.0965152,-0.0359134,-0.209276},
{-0.16062,-0.11148,-0.466414},
{-0.0131587,-0.11148,-0.466414},
{-0.152225,-0.103083,-0.5},
{-0.0215566,-0.103084,-0.5},
{-0.16062,0.0359809,-0.466414},
{-0.152225,0.0275836,-0.5},
{-0.0215566,0.0275836,-0.5},
{-0.0131587,0.0359809,-0.466414},
{-0.137892,-0.0949501,-0.280708},
{-0.16062,-0.11148,-0.171492},
{-0.141855,-0.16828,-0.390348},
{-0.105119,-0.138191,-0.28488},
{-0.109679,-0.170272,-0.197214},
{-0.0318604,-0.168348,-0.390081},
{-0.100308,-0.0945656,-0.275553},
{-0.0773263,-0.143562,-0.203574},
{-0.065216,-0.0594249,-0.275603},
{-0.0131587,-0.11148,-0.171492},
{0.0437055,-0.0927795,-0.390081},
{-0.0299766,-0.0241349,-0.275653},
{0.0246241,-0.0359134,-0.209276},
{0.0437357,0.0173087,-0.389966},
{0.00202974,-0.0333808,-0.295021},
{0.0447857,-0.0219673,-0.229438},
{-0.0357349,-0.00916763,-0.284362},
{-0.0131587,0.0359809,-0.171492},
{-0.0318309,0.0928756,-0.389966},
{-0.0807031,0.019661,-0.27167},
{-0.0693265,0.0584471,-0.182726},
{-0.141903,0.0928269,-0.390155},
{-0.113133,0.0711876,-0.269715},
{-0.122291,0.0743098,-0.171492},
{-0.151466,0.0328586,-0.269715},
{-0.16062,0.0359809,-0.171492},
{-0.217469,0.0172609,-0.390155},
{-0.190835,-0.00651335,-0.269715},
{-0.19999,-0.00339086,-0.171492},
{-0.21742,-0.0927127,-0.390348},
{-0.170991,-0.0512806,-0.276495},
{-0.198609,-0.053957,-0.18358},
{0.0572092,-0.301823,-0.159925},
{0.0687187,-0.306439,-0.158377},
{0.0730762,-0.281297,-0.193505},
{0.0540208,-0.28061,-0.195334},
{0.0548426,-0.254937,-0.173215},
{0.0666028,-0.254324,-0.172909},
{0.0310279,-0.207304,-0.149398},
{0.0901122,-0.207304,-0.149398},
{-0.0242072,-0.163116,-0.160445},
{0.0199797,-0.185211,-0.138351},
{0.10116,-0.18521,-0.138351},
{0.145347,-0.163116,-0.160445},
{-0.0242072,-0.133574,-0.160445},
{0.0199797,-0.11148,-0.138351},
{0.10116,-0.11148,-0.138352},
{0.145347,-0.133574,-0.160445},
{0.0310279,-0.0893856,-0.149398},
{0.0901122,-0.089386,-0.149399},
{0.0545365,-0.0423663,-0.172909},
{0.0666028,-0.0423663,-0.172909},
{0.0670011,-0.0160356,-0.195357},
{0.054139,-0.0160356,-0.195357},
{0.0523879,0.00975927,-0.158383},
{0.068774,0.00977017,-0.158388},
{-0.135724,-0.147512,-0.163571},
{-0.110324,-0.121888,-0.184835},
{-0.0710297,-0.139706,-0.183856},
{-0.135724,-0.149178,-0.163571},
{-0.110324,-0.174802,-0.184835},
{-0.0710297,-0.156985,-0.183856},
{0.193253,-0.139163,-0.184399},
{0.238376,-0.116667,-0.188364},
{0.254991,-0.135433,-0.1648},
{0.193253,-0.157528,-0.184399},
{0.238376,-0.180023,-0.188364},
{0.254991,-0.161257,-0.1648},
{-0.165366,-0.33429,-0.120572},
{-0.1848,-0.350886,-0.0999558},
{-0.197485,-0.351104,-0.0240316},
{-0.127057,-0.3726,-0.120572},
{-0.136838,-0.385094,-0.0775709},
{-0.139157,-0.389235,-0.0274637},
{-0.0599407,-0.371497,-0.130329},
{-0.0747715,-0.359268,-0.0762696},
{-0.0747715,-0.359268,-0.0240316},
{-0.0108694,-0.349987,-0.122263},
{-0.0131587,-0.369536,-0.0762696},
{-0.0131587,-0.369536,-0.0240316},
{0.0357913,-0.329533,-0.114592},
{0.0369009,-0.37788,-0.0762696},
{0.0369009,-0.37788,-0.0240316},
{0.0872659,-0.339026,-0.11175},
{0.0835457,-0.406402,-0.08031},
{0.0835457,-0.406402,-0.0240316},
{0.134302,-0.35784,-0.121157},
{0.134302,-0.406402,-0.08031},
{0.134302,-0.406402,-0.0240316},
{0.183883,-0.377672,-0.131073},
{0.186997,-0.406402,-0.08031},
{0.186997,-0.406402,-0.0240316},
{0.242351,-0.376288,-0.121024},
{0.251298,-0.407184,-0.0743231},
{0.2445,-0.406799,-0.0240316},
{0.280757,-0.337883,-0.121024},
{0.288561,-0.369922,-0.0743231},
{0.281763,-0.369536,-0.0240316},
{0.319447,-0.299191,-0.121024},
{0.325437,-0.333044,-0.0743194},
{0.318639,-0.332658,-0.0240316},
{0.325433,-0.242787,-0.128403},
{0.307705,-0.285414,-0.0761295},
{0.312158,-0.273827,-0.0240279},
{0.299698,-0.194931,-0.121968},
{0.314171,-0.233663,-0.0761369},
{0.318629,-0.222076,-0.0240316},
{0.287363,-0.171998,-0.118885},
{0.320291,-0.184701,-0.0761405},
{0.324748,-0.173113,-0.024039},
{0.287363,-0.124692,-0.118885},
{0.320291,-0.11199,-0.0761405},
{0.324748,-0.123577,-0.024039},
{0.299698,-0.101759,-0.121968},
{0.314171,-0.063027,-0.0761369},
{0.318629,-0.0746145,-0.0240316},
{0.325433,-0.0539029,-0.128403},
{0.307705,-0.0112764,-0.0761295},
{0.312158,-0.0228631,-0.0240279},
{0.319447,0.00250013,-0.121024},
{0.325437,0.0363499,-0.0743231},
{0.318639,0.0359666,-0.0240316},
{0.280757,0.0411905,-0.121024},
{0.288561,0.0732297,-0.0743231},
{0.281763,0.0728464,-0.0240316},
{0.242351,0.0795966,-0.121024},
{0.251718,0.110073,-0.0743231},
{0.24492,0.109689,-0.0240316},
{0.183883,0.0811741,-0.130682},
{0.186002,0.103245,-0.0807487},
{0.186002,0.103245,-0.0240316},
{0.134302,0.0613446,-0.120766},
{0.134302,0.109712,-0.0807487},
{0.134302,0.109712,-0.0240316},
{0.0873875,0.0425767,-0.111383},
{0.0852716,0.115838,-0.0807487},
{0.0852716,0.115838,-0.0240316},
{0.033756,0.0426497,-0.111233},
{0.0355808,0.117833,-0.0809146},
{0.0355808,0.117833,-0.0240316},
{-0.0131587,0.0614183,-0.120616},
{-0.0131587,0.109712,-0.0809146},
{-0.0131587,0.109712,-0.0240316},
{-0.0626466,0.081211,-0.130513},
{-0.0775512,0.09898,-0.0809146},
{-0.0775512,0.09898,-0.0240316},
{-0.127028,0.0759284,-0.12064},
{-0.143315,0.100333,-0.0744005},
{-0.145896,0.0972331,-0.0236187},
{-0.16536,0.0375961,-0.12064},
{-0.191939,0.0603642,-0.095469},
{-0.197485,0.0544141,-0.0240316},
{-0.194578,-0.35784,0.0185146},
{-0.17816,-0.37039,0.0756114},
{-0.16062,-0.332671,0.12343},
{-0.141634,-0.393656,0.0260498},
{-0.126353,-0.364663,0.0826492},
{-0.119946,-0.332582,0.123356},
{-0.0747715,-0.359268,0.0287082},
{-0.0623554,-0.369965,0.0861329},
{-0.0623554,-0.332671,0.12343},
{-0.0131587,-0.369536,0.0287082},
{-0.0131587,-0.369965,0.0861329},
{-0.0131587,-0.332671,0.12343},
{0.0369009,-0.37788,0.0287082},
{0.0360714,-0.369965,0.0861329},
{0.0360714,-0.332671,0.12343},
{0.0835457,-0.406402,0.0338323},
{0.0916604,-0.376859,0.0944388},
{0.085618,-0.33221,0.130747},
{0.134302,-0.406402,0.0338323},
{0.140344,-0.37732,0.0871175},
{0.134302,-0.332671,0.12343},
{0.186997,-0.406402,0.0338323},
{0.179591,-0.377692,0.0812152},
{0.173549,-0.333043,0.117527},
{0.23883,-0.406478,0.0178991},
{0.233757,-0.385012,0.0731492},
{0.216191,-0.356879,0.0994261},
{0.276093,-0.369215,0.0178991},
{0.26246,-0.360804,0.0602862},
{0.244897,-0.332671,0.086564},
{0.312969,-0.332337,0.0178991},
{0.309626,-0.321027,0.0391518},
{0.292063,-0.292894,0.0654295},
{0.315561,-0.264977,0.0157681},
{0.293077,-0.238491,0.0788041},
{0.281103,-0.203742,0.0967685},
{0.322028,-0.213225,0.0157605},
{0.312169,-0.183093,0.0501672},
{0.300195,-0.148345,0.0681316},
{0.312169,-0.113597,0.0501672},
{0.322028,-0.0834651,0.0157605},
{0.324143,-0.148345,0.0322028},
{0.32815,-0.132428,0.0157572},
{0.32815,-0.164263,0.0157572},
{0.315561,-0.0317144,0.0157681},
{0.293077,-0.0581995,0.0788041},
{0.281103,-0.0929479,0.0967685},
{0.312969,0.0356454,0.0178991},
{0.309626,0.0243356,0.0391518},
{0.292063,-0.00379643,0.0654295},
{0.276093,0.0725219,0.0178991},
{0.26246,0.0641129,0.0602862},
{0.244897,0.0359809,0.086564},
{0.23925,0.109365,0.0178991},
{0.233757,0.0883226,0.0731492},
{0.216191,0.0601872,0.0994261},
{0.186002,0.103245,0.0337543},
{0.179584,0.0809418,0.081263},
{0.173549,0.0363499,0.117527},
{0.134302,0.109712,0.0337543},
{0.140333,0.0805694,0.0871653},
{0.134302,0.0359809,0.12343},
{0.0852716,0.115838,0.0337543},
{0.0916126,0.080109,0.0944941},
{0.0855777,0.0355163,0.130754},
{0.0355808,0.117833,0.0335371},
{0.0355515,0.0857379,0.0859962},
{0.0357393,0.0420383,0.123473},
{-0.0131587,0.109712,0.0335371},
{-0.0133467,0.0796813,0.0859484},
{-0.0131587,0.0359809,0.12343},
{-0.0775512,0.09898,0.0335371},
{-0.063771,0.0734326,0.085904},
{-0.063583,0.0297322,0.123382},
{-0.148778,0.0937712,0.0331245},
{-0.12392,0.0379869,0.0738972},
{-0.11717,0.0031785,0.118069},
{-0.19881,0.0523787,0.0254048},
{-0.178335,0.0439328,0.0665978},
{-0.16062,-0.000884013,0.12343},
{-0.160487,-0.2811,0.188913},
{-0.161432,-0.218193,0.197363},
{-0.16062,-0.148345,0.19716},
{-0.111312,-0.289345,0.178222},
{-0.113624,-0.218193,0.185411},
{-0.112813,-0.148345,0.185204},
{-0.0623554,-0.284023,0.172076},
{-0.0623959,-0.217144,0.199268},
{-0.0623959,-0.148345,0.199268},
{-0.0131587,-0.284023,0.172076},
{-0.0131587,-0.217144,0.19716},
{-0.0131587,-0.148345,0.19716},
{0.0360714,-0.284023,0.172076},
{0.0239096,-0.217144,0.195571},
{0.0239096,-0.148345,0.195571},
{0.0785248,-0.279797,0.17337},
{0.061051,-0.216271,0.193373},
{0.061051,-0.148345,0.193373},
{0.127209,-0.280259,0.166049},
{0.0974369,-0.216271,0.1861},
{0.0974369,-0.148345,0.1861},
{0.166456,-0.280631,0.160147},
{0.123221,-0.216271,0.180943},
{0.123221,-0.148345,0.180943},
{0.186684,-0.309619,0.143565},
{0.177973,-0.210488,0.155698},
{0.171167,-0.148345,0.160294},
{0.215391,-0.285411,0.130703},
{0.262557,-0.245634,0.109568},
{0.228371,-0.148345,0.121678},
{0.262011,-0.148345,0.125405},
{0.262557,-0.0510565,0.109568},
{0.215391,-0.0112801,0.130703},
{0.186684,0.012926,0.143565},
{0.177973,-0.0862023,0.155698},
{0.166456,-0.0160615,0.160147},
{0.123221,-0.0804185,0.180943},
{0.127209,-0.0164338,0.166049},
{0.0974369,-0.0804185,0.1861},
{0.0784846,-0.0168946,0.173378},
{0.061051,-0.0804185,0.193373},
{0.0359607,-0.00985339,0.167974},
{0.0239096,-0.0799861,0.195571},
{-0.0129375,-0.0159103,0.167929},
{-0.0131587,-0.0799861,0.19716},
{-0.0633617,-0.0221589,0.167881},
{-0.0623959,-0.0799861,0.199268},
{-0.110332,-0.0320794,0.162808},
{-0.112138,-0.090339,0.185038},
{-0.160535,-0.040502,0.173736},
{-0.159949,-0.090339,0.19699},
{-0.214135,-0.148345,0.210538},
{-0.214947,-0.218193,0.210741},
{-0.210028,-0.272794,0.199685},
{-0.2392,-0.306236,0.157352},
{-0.252919,-0.148345,0.27089},
{-0.252919,-0.205393,0.27089},
{-0.261343,-0.278543,0.222501},
{-0.30808,-0.295806,0.19716},
{-0.30808,-0.148345,0.27089},
{-0.30808,-0.205393,0.27089},
{-0.355674,-0.148345,0.27089},
{-0.355674,-0.205393,0.27089},
{-0.328896,-0.268205,0.219482},
{-0.395563,-0.148345,0.238762},
{-0.395563,-0.211599,0.238762},
{-0.368604,-0.262461,0.18822},
{-0.334434,-0.299232,0.149732},
{-0.418676,-0.148345,0.19716},
{-0.418677,-0.211599,0.19716},
{-0.379116,-0.259034,0.161917},
{-0.344946,-0.295806,0.12343},
{-0.463082,-0.148345,0.117229},
{-0.463082,-0.211599,0.117229},
{-0.406591,-0.250079,0.0931632},
{-0.372421,-0.286851,0.0546757},
{-0.5,-0.148345,0.0302228},
{-0.5,-0.199634,0.0302228},
{-0.473341,-0.280156,0.00469392},
{-0.422881,-0.280795,-0.00446356},
{-0.492406,-0.148345,-0.0608968},
{-0.492406,-0.199634,-0.0608968},
{-0.469137,-0.258301,-0.0664856},
{-0.418676,-0.25894,-0.0756429},
{-0.486308,-0.148345,-0.134078},
{-0.486308,-0.199634,-0.134078},
{-0.466008,-0.242035,-0.119464},
{-0.415547,-0.242675,-0.128622},
{-0.429602,-0.148345,-0.189468},
{-0.429602,-0.175168,-0.189468},
{-0.396226,-0.208142,-0.184957},
{-0.377259,-0.208142,-0.16599},
{-0.381811,-0.148345,-0.245223},
{-0.381811,-0.175168,-0.245223},
{-0.363912,-0.192583,-0.227325},
{-0.344946,-0.192583,-0.208358},
{-0.352382,-0.148345,-0.279557},
{-0.352382,-0.175168,-0.279557},
{-0.343548,-0.182778,-0.254027},
{-0.32458,-0.182778,-0.23506},
{-0.314529,-0.148345,-0.305959},
{-0.314529,-0.168766,-0.305959},
{-0.304898,-0.186895,-0.293208},
{-0.304898,-0.186895,-0.272786},
{-0.271215,-0.148345,-0.318953},
{-0.271215,-0.168766,-0.318953},
{-0.271215,-0.18521,-0.302509},
{-0.271215,-0.18521,-0.282088},
{-0.245575,-0.148345,-0.326646},
{-0.245575,-0.168766,-0.326646},
{-0.246562,-0.183978,-0.309318},
{-0.246562,-0.183978,-0.288897},
{-0.197485,-0.148345,-0.300521},
{-0.210937,-0.164937,-0.310609},
{-0.212477,-0.192707,-0.288211},
{-0.197485,-0.18521,-0.263656},
{-0.181557,-0.148345,-0.288575},
{-0.181028,-0.176981,-0.269578},
{-0.197485,-0.11148,-0.263656},
{-0.181028,-0.119708,-0.269578},
{-0.193806,-0.148345,-0.246143},
{-0.197485,-0.148345,-0.245223},
{-0.204737,-0.294919,-0.120572},
{-0.206846,-0.241934,-0.155868},
{-0.176623,-0.196173,-0.146252},
{-0.215309,-0.329126,-0.114195},
{-0.175418,-0.265794,-0.106209},
{-0.175446,-0.215194,-0.119678},
{-0.244143,-0.312307,-0.0945731},
{-0.197457,-0.272677,-0.0842951},
{-0.197485,-0.222076,-0.097762},
{-0.265333,-0.299945,-0.0801515},
{-0.216603,-0.278656,-0.065258},
{-0.216631,-0.228054,-0.0787248},
{-0.222489,-0.268916,-0.0637207},
{-0.239521,-0.222532,-0.0778953},
{-0.254516,-0.310892,-0.0465526},
{-0.237605,-0.286224,-0.0467589},
{-0.271215,-0.222076,-0.0608968},
{-0.235444,-0.330195,0.012697},
{-0.255949,-0.307229,-0.0261735},
{-0.280389,-0.261091,-0.0362008},
{-0.22229,-0.375268,0.0696168},
{-0.2243,-0.315857,0.0406152},
{-0.252002,-0.288453,0.00981462},
{-0.239883,-0.350471,0.101185},
{-0.243514,-0.330581,0.0804998},
{-0.271215,-0.303179,0.0496993},
{-0.256884,-0.326508,0.131691},
{-0.258329,-0.341937,0.111257},
{-0.286031,-0.314533,0.080452},
{-0.27743,-0.33394,0.16668},
{-0.315,-0.320146,0.127842},
{-0.325511,-0.31672,0.101539},
{-0.352986,-0.307764,0.0327848},
{-0.332315,-0.268751,0.0289883},
{-0.3175,-0.257395,-0.00176869},
{-0.369109,-0.281477,-0.0142218},
{-0.305069,-0.259482,-0.0829496},
{-0.264026,-0.239283,-0.0545892},
{-0.364905,-0.259622,-0.0854048},
{-0.356035,-0.211085,-0.118159},
{-0.326513,-0.148345,-0.097762},
{-0.361775,-0.243356,-0.138382},
{-0.372144,-0.195788,-0.129289},
{-0.372144,-0.148345,-0.129289},
{-0.358812,-0.208142,-0.147544},
{-0.318028,-0.174433,-0.144967},
{-0.318028,-0.148345,-0.144967},
{-0.326499,-0.192583,-0.189911},
{-0.30808,-0.174433,-0.171492},
{-0.30808,-0.148345,-0.171492},
{-0.306134,-0.182778,-0.216613},
{-0.298194,-0.174433,-0.197857},
{-0.298194,-0.148345,-0.197857},
{-0.304898,-0.186895,-0.252541},
{-0.294643,-0.16859,-0.229604},
{-0.294643,-0.148345,-0.229604},
{-0.271215,-0.18521,-0.261844},
{-0.271215,-0.16859,-0.245223},
{-0.271215,-0.148345,-0.245223},
{-0.246562,-0.183978,-0.268652},
{-0.250615,-0.16859,-0.258957},
{-0.250615,-0.148345,-0.258957},
{-0.21015,-0.191542,-0.258808},
{-0.219664,-0.163982,-0.239678},
{-0.236563,-0.0191581,0.146975},
{-0.211744,-0.0490945,0.18488},
{-0.21346,-0.090339,0.210368},
{-0.30808,-0.000884013,0.19716},
{-0.256223,-0.0283191,0.224592},
{-0.252919,-0.0912152,0.27089},
{-0.30808,-0.0912152,0.27089},
{-0.324721,-0.0246437,0.220916},
{-0.355674,-0.0912152,0.27089},
{-0.334328,0.00257393,0.149998},
{-0.368498,-0.0341954,0.188485},
{-0.395563,-0.0850908,0.238762},
{-0.344946,-0.000884013,0.12343},
{-0.379116,-0.0376572,0.161917},
{-0.418676,-0.0850908,0.19716},
{-0.372421,-0.00984231,0.0546757},
{-0.406591,-0.0466113,0.0931632},
{-0.463082,-0.0850908,0.117229},
{-0.422881,-0.0158956,-0.00446356},
{-0.473341,-0.016537,0.00469392},
{-0.5,-0.0970566,0.0302228},
{-0.418676,-0.0377492,-0.0756429},
{-0.469137,-0.0383889,-0.0664856},
{-0.492406,-0.0970566,-0.0608968},
{-0.415547,-0.0540157,-0.128622},
{-0.466008,-0.0546549,-0.119464},
{-0.486308,-0.0970566,-0.134078},
{-0.377259,-0.0885484,-0.16599},
{-0.396226,-0.0885484,-0.184957},
{-0.429602,-0.121522,-0.189468},
{-0.344946,-0.104107,-0.208358},
{-0.363912,-0.104107,-0.227325},
{-0.381811,-0.121522,-0.245223},
{-0.324581,-0.113912,-0.23506},
{-0.343548,-0.113912,-0.254027},
{-0.352382,-0.121522,-0.279557},
{-0.304898,-0.109796,-0.272786},
{-0.304898,-0.109796,-0.293208},
{-0.314529,-0.127924,-0.305959},
{-0.271215,-0.11148,-0.282088},
{-0.271215,-0.11148,-0.302509},
{-0.271215,-0.127924,-0.318953},
{-0.246562,-0.112712,-0.288897},
{-0.246562,-0.112712,-0.309318},
{-0.245575,-0.127924,-0.326646},
{-0.212477,-0.103984,-0.288211},
{-0.210937,-0.131754,-0.310609},
{-0.176623,-0.100518,-0.146252},
{-0.206846,-0.0547552,-0.155868},
{-0.20473,-0.00177624,-0.12064},
{-0.175446,-0.0814969,-0.119678},
{-0.175417,-0.0306601,-0.106147},
{-0.224296,0.0337652,-0.109485},
{-0.197485,-0.0746145,-0.097762},
{-0.197457,-0.023781,-0.0842325},
{-0.252365,0.0100209,-0.0859283},
{-0.216603,-0.0178015,-0.0651952},
{-0.268616,-0.00373001,-0.0722882},
{-0.259895,0.00299417,-0.0450116},
{-0.222227,-0.0272796,-0.0636101},
{-0.237316,-0.00991603,-0.0466373},
{-0.216631,-0.0686361,-0.0787248},
{-0.239481,-0.0741574,-0.0779175},
{-0.271215,-0.0746145,-0.0608968},
{-0.28045,-0.0353419,-0.0360349},
{-0.255748,0.0112923,-0.0259007},
{-0.239384,0.0188132,0.0191486},
{-0.251844,-0.00872525,0.00970727},
{-0.222521,0.0134124,0.0408324},
{-0.216042,0.0480505,0.06154},
{-0.271215,0.0064886,0.0496993},
{-0.241892,0.0286227,0.0808202},
{-0.234595,0.0251608,0.0906859},
{-0.286118,0.0181901,0.0804596},
{-0.256794,0.0403275,0.111585},
{-0.253733,0.00155272,0.120753},
{-0.325428,0.0201181,0.101443},
{-0.31481,0.02358,0.128015},
{-0.272863,0.0287191,0.167553},
{-0.321376,-0.031379,-0.00354559},
{-0.336278,-0.0196779,0.0272188},
{-0.352903,0.0111631,0.0326892},
{-0.264352,-0.057881,-0.054814},
{-0.305395,-0.0376829,-0.0831744},
{-0.369109,-0.0152135,-0.0142218},
{-0.356021,-0.0856324,-0.11815},
{-0.364905,-0.0370709,-0.0854048},
{-0.372144,-0.100902,-0.129289},
{-0.361776,-0.0533341,-0.138382},
{-0.318028,-0.122258,-0.144967},
{-0.358812,-0.0885484,-0.147544},
{-0.30808,-0.122258,-0.171492},
{-0.326499,-0.104107,-0.189911},
{-0.298194,-0.122258,-0.197857},
{-0.306134,-0.113912,-0.216613},
{-0.294643,-0.1281,-0.229604},
{-0.304898,-0.109796,-0.252541},
{-0.271215,-0.1281,-0.245223},
{-0.271215,-0.11148,-0.261844},
{-0.250615,-0.1281,-0.258957},
{-0.246562,-0.112712,-0.268652},
{-0.219664,-0.132708,-0.239678},
{-0.21015,-0.105147,-0.258808},
{-0.161979,-0.173998,-0.141592},
{-0.161979,-0.122692,-0.141592},
{-0.175472,-0.167241,-0.132441},
{-0.175472,-0.12945,-0.132441},
{-0.197511,-0.174123,-0.110525},
{-0.197511,-0.122567,-0.110525},
{-0.216657,-0.180102,-0.0914875},
{-0.216657,-0.116588,-0.0914875},
{-0.256798,-0.175482,-0.0922764},
{-0.256798,-0.121208,-0.0922764},
{-0.285798,-0.153289,-0.0877236},
{-0.285798,-0.143402,-0.0877236},
{-0.264867,-0.231482,-0.0551716},
{-0.297629,-0.173011,-0.0713296},
{-0.286903,-0.148345,-0.070397},
{-0.29792,-0.144011,-0.0858214},
{-0.29792,-0.15268,-0.085825},
{-0.265154,-0.0655939,-0.0553707},
{-0.297651,-0.123719,-0.071337},
{-0.298286,-0.242671,-0.0416495},
{-0.29706,-0.229621,-0.0430393},
{-0.262941,-0.238749,-0.0538408},
{-0.302005,-0.046591,-0.0435333},
{-0.263267,-0.0584148,-0.0540656},
{-0.297121,-0.0668123,-0.0428771},
{-0.30808,-0.25894,0.19716},
{-0.301748,-0.273091,0.232185},
{-0.271215,-0.332671,0.27089},
{-0.314628,-0.266842,0.115876},
{-0.308296,-0.280992,0.150905},
{-0.294689,-0.346488,0.250393},
{-0.271513,-0.40765,0.132214},
{-0.268718,-0.408442,0.171955},
{-0.27129,-0.432515,0.219463},
{-0.252783,-0.443266,0.234025},
{-0.23435,-0.480132,0.12343},
{-0.231554,-0.480924,0.163167},
{-0.316325,-0.24052,0.151561},
{-0.322873,-0.248421,0.0702768},
{-0.276339,-0.406283,0.0636298},
{-0.239176,-0.478765,0.0548418},
{-0.311335,-0.244659,0.0973622},
{-0.324594,-0.306163,0.0920906},
{-0.290209,-0.404905,-0.00401741},
{-0.269212,-0.460899,-0.0242712},
{-0.30808,-0.25894,0.0496993},
{-0.32134,-0.320444,0.0444234},
{-0.310645,-0.350409,-0.0406467},
{-0.289648,-0.406402,-0.0608968},
{-0.318364,-0.333503,0.000837705},
{-0.318419,-0.329679,-0.0545781},
{-0.297422,-0.385672,-0.0748319},
{-0.309813,-0.328251,-0.0340478},
{-0.289648,-0.332671,-0.0608968},
{-0.305105,-0.272,0.00610953},
{-0.271215,-0.25894,0.19716},
{-0.233783,-0.331369,0.189256},
{-0.188119,-0.46461,0.203309},
{-0.197485,-0.480132,0.12343},
{-0.261155,-0.272959,0.23317},
{-0.223723,-0.345388,0.225266},
{-0.181434,-0.465352,0.244071},
{-0.190799,-0.480874,0.164191},
{-0.215917,-0.332671,0.27089},
{-0.201755,-0.333777,0.243669},
{-0.181115,-0.429057,0.221837},
{-0.197485,-0.443266,0.234025},
{-0.208622,-0.478895,0.0555202},
{-0.199256,-0.463372,0.135399},
{-0.246175,-0.314103,0.144904},
{-0.283607,-0.241674,0.152804},
{-0.240006,-0.46305,-0.0239542},
{-0.227205,-0.44079,0.0328184},
{-0.252853,-0.300523,0.0794381},
{-0.274852,-0.244832,0.0966729},
{-0.252783,-0.406402,-0.0608968},
{-0.23998,-0.384142,-0.00412433},
{-0.249216,-0.314632,0.0324603},
{-0.271215,-0.25894,0.0496993},
{-0.244593,-0.363692,-0.0174622},
{-0.245878,-0.327583,-0.0106606},
{-0.267877,-0.271892,0.00657414},
{-0.241589,-0.325654,-0.0314931},
{-0.252783,-0.332671,-0.0608968},
{-0.257395,-0.385951,-0.0742346},
{-0.306362,-0.256867,0.218494},
{-0.281042,-0.239927,0.199231},
{-0.300029,-0.271017,0.253519},
{-0.270982,-0.253944,0.235246},
{-0.275669,-0.306993,0.26849},
{-0.235801,-0.285789,0.263775},
{-0.255413,-0.373705,0.282038},
{-0.208138,-0.354392,0.277051},
{-0.252775,-0.423458,0.26177},
{-0.207293,-0.418803,0.268306},
{-0.239406,-0.476459,0.208957},
{-0.200232,-0.474139,0.212758},
{-0.221773,-0.5,0.160851},
{-0.193265,-0.48496,0.143163},
{-0.22457,-0.499208,0.121114},
{-0.199951,-0.484218,0.102402},
{-0.229395,-0.497841,0.0525305},
{-0.211088,-0.482981,0.0344923},
{-0.262342,-0.479218,-0.0308959},
{-0.24425,-0.470429,-0.0427738},
{-0.282778,-0.424721,-0.0675251},
{-0.257027,-0.413781,-0.0797202},
{-0.290552,-0.403991,-0.0814565},
{-0.261639,-0.393331,-0.0930543},
{-0.286374,-0.351541,-0.0761516},
{-0.252392,-0.346671,-0.0741166},
{-0.292128,-0.298283,-0.037292},
{-0.259344,-0.294292,-0.0356404},
{-0.301171,-0.253753,0.0076761},
{-0.274491,-0.25515,0.0117569},
{-0.304147,-0.240694,0.0512616},
{-0.277829,-0.242199,0.0548787},
{-0.307401,-0.226413,0.0989246},
{-0.281465,-0.228091,0.101856},
{-0.314606,-0.238446,0.172895},
{-0.293433,-0.22266,0.154879},
{-0.30808,-0.0377492,0.19716},
{-0.301748,-0.0235967,0.232185},
{-0.271215,0.0359809,0.27089},
{-0.314628,-0.029849,0.115876},
{-0.308296,-0.0156965,0.150905},
{-0.294689,0.0497982,0.250393},
{-0.271513,0.110962,0.132214},
{-0.268718,0.11175,0.171955},
{-0.27129,0.135827,0.219463},
{-0.252783,0.146577,0.234025},
{-0.23435,0.183442,0.12343},
{-0.231554,0.184235,0.163167},
{-0.316325,-0.0561697,0.151561},
{-0.322873,-0.0482687,0.0702768},
{-0.276339,0.109594,0.0636298},
{-0.239176,0.182074,0.0548418},
{-0.311335,-0.0520305,0.0973622},
{-0.324594,0.00947162,0.0920906},
{-0.290209,0.108215,-0.00401741},
{-0.269212,0.16421,-0.0242712},
{-0.30808,-0.0377492,0.0496993},
{-0.32134,0.0237527,0.0444234},
{-0.310645,0.0537205,-0.0406467},
{-0.289648,0.109712,-0.0608968},
{-0.318364,0.0368145,0.000837705},
{-0.318419,0.0329878,-0.0545781},
{-0.297422,0.0889826,-0.0748319},
{-0.309813,0.0315613,-0.0340478},
{-0.289648,0.0359809,-0.0608968},
{-0.305105,-0.0246916,0.00610953},
{-0.271215,-0.0377492,0.19716},
{-0.233783,0.0346801,0.189256},
{-0.188119,0.167918,0.203309},
{-0.197485,0.183442,0.12343},
{-0.261155,-0.0237294,0.23317},
{-0.223723,0.0486963,0.225266},
{-0.181434,0.168663,0.244071},
{-0.190799,0.184183,0.164191},
{-0.215917,0.0359809,0.27089},
{-0.201755,0.037087,0.243669},
{-0.181115,0.132369,0.221837},
{-0.197485,0.146577,0.234025},
{-0.208622,0.182204,0.0555202},
{-0.199256,0.166683,0.135399},
{-0.246175,0.0174118,0.144904},
{-0.283607,-0.0550151,0.152804},
{-0.240006,0.166358,-0.0239542},
{-0.227205,0.144099,0.0328184},
{-0.252853,0.00383431,0.0794381},
{-0.274852,-0.051858,0.0966729},
{-0.252783,0.109712,-0.0608968},
{-0.23998,0.0874521,-0.00412433},
{-0.249216,0.0179427,0.0324603},
{-0.271215,-0.0377492,0.0496993},
{-0.244593,0.0670037,-0.0174622},
{-0.245878,0.0308937,-0.0106606},
{-0.267877,-0.0247985,0.00657414},
{-0.241589,0.0289657,-0.0314931},
{-0.252783,0.0359809,-0.0608968},
{-0.257395,0.0892627,-0.0742346},
{-0.306362,-0.0398229,0.218494},
{-0.281042,-0.0567633,0.199231},
{-0.300029,-0.0256722,0.253519},
{-0.270982,-0.0427452,0.235246},
{-0.275669,0.0103044,0.26849},
{-0.235801,-0.0109003,0.263775},
{-0.255413,0.0770161,0.282038},
{-0.208138,0.0577024,0.277051},
{-0.252775,0.126769,0.26177},
{-0.207293,0.122113,0.268306},
{-0.239406,0.17977,0.208957},
{-0.200232,0.177448,0.212758},
{-0.221773,0.203309,0.160851},
{-0.193265,0.188271,0.143163},
{-0.22457,0.20252,0.121114},
{-0.199951,0.187526,0.102402},
{-0.229395,0.201152,0.0525305},
{-0.211088,0.186292,0.0344923},
{-0.262342,0.182528,-0.0308959},
{-0.24425,0.173739,-0.0427738},
{-0.282778,0.12803,-0.0675251},
{-0.257027,0.117092,-0.0797202},
{-0.290552,0.107301,-0.0814565},
{-0.261639,0.0966427,-0.0930543},
{-0.286374,0.0548527,-0.0761516},
{-0.252392,0.0499827,-0.0741166},
{-0.292128,0.00159331,-0.037292},
{-0.259344,-0.00239918,-0.0356404},
{-0.301171,-0.0429365,0.0076761},
{-0.274491,-0.0415394,0.0117569},
{-0.304147,-0.0559958,0.0512616},
{-0.277829,-0.0544905,0.0548787},
{-0.307401,-0.070277,0.0989246},
{-0.281465,-0.0685992,0.101856},
{-0.314606,-0.0582437,0.172895},
{-0.293433,-0.0740294,0.154879},
{-0.277686,-0.283069,-0.0658367},
{-0.320316,-0.298541,-0.130924},
{-0.351247,-0.306971,-0.15306},
{-0.277162,-0.292893,-0.0551053},
{-0.301745,-0.30088,-0.0842546},
{-0.322012,-0.309807,-0.1221},
{-0.352944,-0.318235,-0.144236},
{-0.289867,-0.297021,-0.0446392},
{-0.314398,-0.304992,-0.0737296},
{-0.331683,-0.313109,-0.105347},
{-0.360784,-0.320782,-0.129957},
{-0.295217,-0.288765,-0.0339078},
{-0.339676,-0.304993,-0.0965234},
{-0.368778,-0.312667,-0.121133},
{-0.305386,-0.281204,-0.0274048},
{-0.329917,-0.289175,-0.0564951},
{-0.347628,-0.296919,-0.0877457},
{-0.376729,-0.304593,-0.112356},
{-0.310391,-0.265799,-0.0274048},
{-0.334923,-0.273769,-0.0564951},
{-0.353804,-0.277914,-0.0877457},
{-0.381857,-0.288811,-0.112356},
{-0.306609,-0.253705,-0.0339078},
{-0.352116,-0.266708,-0.0965234},
{-0.380169,-0.277606,-0.121133},
{-0.307133,-0.243881,-0.0446392},
{-0.331665,-0.251851,-0.0737296},
{-0.350419,-0.255443,-0.105347},
{-0.378473,-0.266341,-0.129957},
{-0.294428,-0.239752,-0.0551053},
{-0.319011,-0.247739,-0.0842546},
{-0.340654,-0.252432,-0.1221},
{-0.370633,-0.263793,-0.144236},
{-0.289078,-0.248008,-0.0658367},
{-0.33266,-0.260548,-0.130924},
{-0.362639,-0.27191,-0.15306},
{-0.27891,-0.255569,-0.0723398},
{-0.303493,-0.263557,-0.101489},
{-0.324675,-0.268655,-0.139739},
{-0.354654,-0.280017,-0.161874},
{-0.273904,-0.270975,-0.0723398},
{-0.298487,-0.278963,-0.101489},
{-0.318621,-0.287289,-0.139739},
{-0.349552,-0.295718,-0.161874},
{-0.381207,-0.315135,-0.1745},
{-0.453951,-0.33065,-0.192395},
{-0.382904,-0.326399,-0.165676},
{-0.420667,-0.330807,-0.178588},
{-0.388476,-0.328084,-0.153377},
{-0.429379,-0.334134,-0.160682},
{-0.462716,-0.333498,-0.176431},
{-0.39647,-0.319968,-0.144553},
{-0.404422,-0.311894,-0.135776},
{-0.437187,-0.32621,-0.15207},
{-0.408552,-0.299181,-0.135775},
{-0.443474,-0.306858,-0.15207},
{-0.468413,-0.315968,-0.176431},
{-0.406865,-0.287975,-0.144553},
{-0.405168,-0.276711,-0.153377},
{-0.441815,-0.295859,-0.160682},
{-0.39967,-0.274799,-0.165676},
{-0.432812,-0.293429,-0.178588},
{-0.459647,-0.31312,-0.192395},
{-0.391676,-0.282915,-0.1745},
{-0.383691,-0.291022,-0.183315},
{-0.425216,-0.301125,-0.186959},
{-0.379512,-0.303882,-0.183315},
{-0.419046,-0.320116,-0.186959},
{-0.464667,-0.333795,-0.177882},
{-0.457615,-0.331059,-0.193554},
{-0.470166,-0.316874,-0.177882},
{-0.462852,-0.314943,-0.193554},
{-0.277686,-0.0689185,-0.0658367},
{-0.321268,-0.0563791,-0.130924},
{-0.351247,-0.0450173,-0.15306},
{-0.283037,-0.0771744,-0.0551053},
{-0.30762,-0.0691868,-0.0842546},
{-0.329262,-0.0644953,-0.1221},
{-0.359241,-0.0531335,-0.144236},
{-0.295742,-0.0730463,-0.0446392},
{-0.320273,-0.0650756,-0.0737296},
{-0.339027,-0.0614834,-0.105347},
{-0.367081,-0.0505861,-0.129957},
{-0.295217,-0.0632224,-0.0339078},
{-0.340724,-0.0502186,-0.0965234},
{-0.368778,-0.0393212,-0.121133},
{-0.298999,-0.0511284,-0.0274048},
{-0.32353,-0.0431578,-0.0564951},
{-0.342412,-0.039013,-0.0877457},
{-0.370464,-0.0281164,-0.112356},
{-0.293994,-0.0357217,-0.0274048},
{-0.318525,-0.0277514,-0.0564951},
{-0.336236,-0.0200061,-0.0877457},
{-0.365337,-0.0123344,-0.112356},
{-0.283825,-0.0281606,-0.0339078},
{-0.328284,-0.0119325,-0.0965234},
{-0.357385,-0.00426095,-0.121133},
{-0.278475,-0.0199065,-0.0446392},
{-0.303006,-0.0119362,-0.0737296},
{-0.320291,-0.00381857,-0.105347},
{-0.349391,0.00385695,-0.129957},
{-0.26577,-0.0240355,-0.0551053},
{-0.290353,-0.0160467,-0.0842546},
{-0.31062,-0.00712162,-0.1221},
{-0.341552,0.00130943,-0.144236},
{-0.266294,-0.0338563,-0.0658367},
{-0.308924,-0.018384,-0.130924},
{-0.339855,-0.00995662,-0.15306},
{-0.262512,-0.0459518,-0.0723398},
{-0.287095,-0.0379642,-0.101489},
{-0.307229,-0.0296389,-0.139739},
{-0.33816,-0.0212078,-0.161874},
{-0.267518,-0.0613574,-0.0723398},
{-0.292101,-0.0533702,-0.101489},
{-0.313283,-0.0482717,-0.139739},
{-0.343262,-0.0369088,-0.161874},
{-0.380284,-0.0340111,-0.1745},
{-0.448255,-0.00380749,-0.192395},
{-0.388278,-0.0421281,-0.165676},
{-0.42142,-0.0234972,-0.178588},
{-0.393776,-0.0402159,-0.153377},
{-0.430423,-0.0210678,-0.160682},
{-0.45702,-0.000957818,-0.176431},
{-0.395473,-0.0289495,-0.144553},
{-0.397161,-0.0177462,-0.135776},
{-0.432083,-0.0100672,-0.15207},
{-0.39303,-0.0050314,-0.135775},
{-0.425795,0.00928376,-0.15207},
{-0.451324,0.0165715,-0.176431},
{-0.385078,0.00304206,-0.144553},
{-0.377084,0.0111564,-0.153377},
{-0.417987,0.0172055,-0.160682},
{-0.371511,0.00947162,-0.165676},
{-0.409275,0.0138803,-0.178588},
{-0.442559,0.0137218,-0.192395},
{-0.369815,-0.00179091,-0.1745},
{-0.36812,-0.0130459,-0.183315},
{-0.407654,0.0031894,-0.186959},
{-0.372299,-0.0259045,-0.183315},
{-0.413824,-0.0157997,-0.186959},
{-0.458774,-5.09122e-005,-0.177882},
{-0.45146,-0.00198263,-0.193554},
{-0.453275,0.0168701,-0.177882},
{-0.446223,0.0141344,-0.193554},
{-0.151403,-0.332671,-0.466414},
{-0.16062,-0.323455,-0.466414},
{-0.0131587,-0.323455,-0.466414},
{-0.151403,-0.18521,-0.466414},
{-0.022375,-0.332671,-0.466414},
{-0.022375,-0.18521,-0.466414},
{-0.16062,-0.194426,-0.466414},
{-0.0131587,-0.194426,-0.466414},
{-0.16062,-0.332671,-0.447982},
{-0.151403,-0.332671,-0.466414},
{-0.0131587,-0.332671,-0.447982},
{-0.022375,-0.332671,-0.466414},
{-0.0131587,-0.332671,-0.447982},
{-0.0131587,-0.323455,-0.466414},
{-0.0131587,-0.18521,-0.447982},
{-0.0131587,-0.194426,-0.466414},
{-0.0131587,-0.18521,-0.447982},
{-0.022375,-0.18521,-0.466414},
{-0.16062,-0.18521,-0.447982},
{-0.151403,-0.18521,-0.466414},
{-0.16062,-0.18521,-0.447982},
{-0.16062,-0.194426,-0.466414},
{-0.16062,-0.332671,-0.447982},
{-0.16062,-0.323455,-0.466414},
{0.143519,-0.332671,-0.466414},
{0.134302,-0.323455,-0.466414},
{0.281763,-0.323455,-0.466414},
{0.143519,-0.18521,-0.466414},
{0.272547,-0.332671,-0.466414},
{0.272547,-0.18521,-0.466414},
{0.134302,-0.194426,-0.466414},
{0.281763,-0.194426,-0.466414},
{0.134302,-0.332671,-0.447982},
{0.143519,-0.332671,-0.466414},
{0.281763,-0.332671,-0.447982},
{0.272547,-0.332671,-0.466414},
{0.281763,-0.332671,-0.447982},
{0.281763,-0.323455,-0.466414},
{0.281763,-0.18521,-0.447982},
{0.281763,-0.194426,-0.466414},
{0.281763,-0.18521,-0.447982},
{0.272547,-0.18521,-0.466414},
{0.134302,-0.18521,-0.447982},
{0.143519,-0.18521,-0.466414},
{0.134302,-0.18521,-0.447982},
{0.134302,-0.194426,-0.466414},
{0.134302,-0.332671,-0.447982},
{0.134302,-0.323455,-0.466414},
{0.143519,-0.11148,-0.466414},
{0.134302,-0.102263,-0.466414},
{0.281763,-0.102263,-0.466414},
{0.143519,0.0359809,-0.466414},
{0.272547,-0.11148,-0.466414},
{0.272547,0.0359809,-0.466414},
{0.134302,0.0267646,-0.466414},
{0.281763,0.0267646,-0.466414},
{0.134302,-0.11148,-0.447982},
{0.143519,-0.11148,-0.466414},
{0.281763,-0.11148,-0.447982},
{0.272547,-0.11148,-0.466414},
{0.281763,-0.11148,-0.447982},
{0.281763,-0.102263,-0.466414},
{0.281763,0.0359809,-0.447982},
{0.281763,0.0267646,-0.466414},
{0.281763,0.0359809,-0.447982},
{0.272547,0.0359809,-0.466414},
{0.134302,0.0359809,-0.447982},
{0.143519,0.0359809,-0.466414},
{0.134302,0.0359809,-0.447982},
{0.134302,0.0267646,-0.466414},
{0.134302,-0.11148,-0.447982},
{0.134302,-0.102263,-0.466414},
{-0.151403,-0.11148,-0.466414},
{-0.16062,-0.102263,-0.466414},
{-0.0131587,-0.102263,-0.466414},
{-0.151403,0.0359809,-0.466414},
{-0.022375,-0.11148,-0.466414},
{-0.022375,0.0359809,-0.466414},
{-0.16062,0.0267646,-0.466414},
{-0.0131587,0.0267646,-0.466414},
{-0.16062,-0.11148,-0.447982},
{-0.151403,-0.11148,-0.466414},
{-0.0131587,-0.11148,-0.447982},
{-0.022375,-0.11148,-0.466414},
{-0.0131587,-0.11148,-0.447982},
{-0.0131587,-0.102263,-0.466414},
{-0.0131587,0.0359809,-0.447982},
{-0.0131587,0.0267646,-0.466414},
{-0.0131587,0.0359809,-0.447982},
{-0.022375,0.0359809,-0.466414},
{-0.16062,0.0359809,-0.447982},
{-0.151403,0.0359809,-0.466414},
{-0.16062,0.0359809,-0.447982},
{-0.16062,0.0267646,-0.466414},
{-0.16062,-0.11148,-0.447982},
{-0.16062,-0.102263,-0.466414},
{0.175775,-0.159865,0.155686},
{0.166559,-0.148345,0.161907},
{0.175775,-0.136825,0.155686},
{0.175775,-0.159865,0.155686},
{0.166559,-0.148345,0.161907},
{0.175775,-0.136825,0.155686},
{-0.30808,-0.28659,0.201768},
{-0.298864,-0.29811,0.192552},
{-0.310384,-0.295806,0.192552},
{-0.30808,-0.28659,0.201768},
{-0.197485,-0.150649,-0.298217},
{-0.197485,-0.182906,-0.26596},
{-0.202093,-0.148345,-0.301673},
{-0.202093,-0.18521,-0.264808},
{-0.197485,-0.150649,-0.298217},
{-0.197485,-0.146041,-0.298217},
{-0.197485,-0.182906,-0.262504},
{-0.197485,-0.113784,-0.262504},
{-0.197485,-0.182906,-0.26596},
{-0.197485,-0.146041,-0.246375},
{-0.197485,-0.113784,-0.26596},
{-0.197485,-0.150649,-0.246375},
{-0.310384,-0.295806,0.192552},
{-0.298864,-0.29811,0.192552},
{-0.197485,-0.182906,-0.262504},
{-0.197485,-0.150649,-0.246375},
{-0.202093,-0.18521,-0.264808},
{-0.202093,-0.148345,-0.245223},
{-0.30808,-0.0101003,0.201768},
{-0.298864,-0.000884013,0.192552},
{-0.30808,-0.0101003,0.201768},
{-0.310384,-0.000884013,0.192552},
{-0.197485,-0.113784,-0.26596},
{-0.197485,-0.146041,-0.298217},
{-0.202093,-0.11148,-0.264808},
{-0.202093,-0.148345,-0.301673},
{-0.310384,-0.000884013,0.192552},
{-0.298864,-0.000884013,0.192552},
{-0.197485,-0.146041,-0.246375},
{-0.197485,-0.113784,-0.262504},
{-0.202093,-0.148345,-0.245223},
{-0.202093,-0.11148,-0.264808},
{-0.270063,-0.339584,0.268586},
{-0.273519,-0.328063,0.266282},
{-0.251631,-0.44557,0.227112},
{-0.253935,-0.436354,0.236329},
{-0.214765,-0.339584,0.268586},
{-0.198637,-0.436354,0.236329},
{-0.219374,-0.328063,0.266282},
{-0.197485,-0.44557,0.227112},
{-0.267759,-0.332671,0.27089},
{-0.219374,-0.332671,0.27089},
{-0.273519,-0.328063,0.266282},
{-0.219374,-0.328063,0.266282},
{-0.267759,-0.332671,0.27089},
{-0.270063,-0.339584,0.268586},
{-0.214765,-0.339584,0.268586},
{-0.249327,-0.443266,0.234025},
{-0.219374,-0.332671,0.27089},
{-0.200941,-0.443266,0.234025},
{-0.253935,-0.436354,0.236329},
{-0.198637,-0.436354,0.236329},
{-0.249327,-0.443266,0.234025},
{-0.251631,-0.44557,0.227112},
{-0.197485,-0.44557,0.227112},
{-0.200941,-0.443266,0.234025},
{-0.287344,-0.332671,-0.0608968},
{-0.255087,-0.332671,-0.0608968},
{-0.289648,-0.337279,-0.0608968},
{-0.252783,-0.337279,-0.0608968},
{-0.287344,-0.332671,-0.0608968},
{-0.2908,-0.328063,-0.0539846},
{-0.253935,-0.328063,-0.0539846},
{-0.255087,-0.332671,-0.0608968},
{-0.273519,0.0313727,0.266282},
{-0.270063,0.0428931,0.268586},
{-0.251631,0.148881,0.227112},
{-0.253935,0.139664,0.236329},
{-0.198637,0.139664,0.236329},
{-0.214765,0.0428931,0.268586},
{-0.197485,0.148881,0.227112},
{-0.219374,0.0313727,0.266282},
{-0.219374,0.0359809,0.27089},
{-0.267759,0.0359809,0.27089},
{-0.219374,0.0313727,0.266282},
{-0.273519,0.0313727,0.266282},
{-0.219374,0.0359809,0.27089},
{-0.214765,0.0428931,0.268586},
{-0.270063,0.0428931,0.268586},
{-0.200941,0.146577,0.234025},
{-0.267759,0.0359809,0.27089},
{-0.249327,0.146577,0.234025},
{-0.198637,0.139664,0.236329},
{-0.253935,0.139664,0.236329},
{-0.200941,0.146577,0.234025},
{-0.197485,0.148881,0.227112},
{-0.251631,0.148881,0.227112},
{-0.249327,0.146577,0.234025},
{-0.255087,0.0359809,-0.0608968},
{-0.287344,0.0359809,-0.0608968},
{-0.252783,0.0405891,-0.0608968},
{-0.289648,0.0405891,-0.0608968},
{-0.255087,0.0359809,-0.0608968},
{-0.253935,0.0313727,-0.0539846},
{-0.2908,0.0313727,-0.0539846},
{-0.287344,0.0359809,-0.0608968},
{-0.282284,-0.284563,-0.0712882},
{-0.299815,-0.290259,-0.0393594},
{-0.299815,-0.290259,-0.0393594},
{-0.311207,-0.255198,-0.0393594},
{-0.311207,-0.255198,-0.0393594},
{-0.293676,-0.249502,-0.0712882},
{-0.293676,-0.249502,-0.0712882},
{-0.282284,-0.284563,-0.0712882},
{-0.454498,-0.330828,-0.191397},
{-0.447532,-0.32917,-0.189936},
{-0.456845,-0.332196,-0.172975},
{-0.462168,-0.33332,-0.177429},
{-0.463072,-0.332403,-0.176431},
{-0.456845,-0.332196,-0.172975},
{-0.462898,-0.313571,-0.172975},
{-0.468057,-0.317064,-0.176431},
{-0.467865,-0.31579,-0.177429},
{-0.462898,-0.313571,-0.172975},
{-0.453584,-0.310545,-0.189936},
{-0.460194,-0.313298,-0.191397},
{-0.459291,-0.314216,-0.192395},
{-0.453584,-0.310545,-0.189936},
{-0.447532,-0.32917,-0.189936},
{-0.454307,-0.329555,-0.192395},
{-0.462168,-0.33332,-0.177429},
{-0.463072,-0.332403,-0.176431},
{-0.454307,-0.329555,-0.192395},
{-0.467865,-0.31579,-0.177429},
{-0.454498,-0.330828,-0.191397},
{-0.460194,-0.313298,-0.191397},
{-0.468057,-0.317064,-0.176431},
{-0.459291,-0.314216,-0.192395},
{-0.282284,-0.0674246,-0.0712882},
{-0.299815,-0.0617285,-0.0393594},
{-0.299815,-0.0617285,-0.0393594},
{-0.288423,-0.0266669,-0.0393594},
{-0.288423,-0.0266669,-0.0393594},
{-0.270892,-0.0323626,-0.0712882},
{-0.270892,-0.0323626,-0.0712882},
{-0.282284,-0.0674246,-0.0712882},
{-0.448802,-0.00362939,-0.191397},
{-0.442192,-0.00638311,-0.189936},
{-0.451505,-0.00335553,-0.172975},
{-0.456472,-0.00113592,-0.177429},
{-0.456664,0.000137764,-0.176431},
{-0.451505,-0.00335553,-0.172975},
{-0.445453,0.0152695,-0.172975},
{-0.45168,0.0154759,-0.176431},
{-0.450776,0.0163934,-0.177429},
{-0.445453,0.0152695,-0.172975},
{-0.43614,0.0122419,-0.189936},
{-0.443107,0.0138999,-0.191397},
{-0.442915,0.0126262,-0.192395},
{-0.43614,0.0122419,-0.189936},
{-0.442192,-0.00638311,-0.189936},
{-0.447899,-0.00271191,-0.192395},
{-0.456472,-0.00113592,-0.177429},
{-0.456664,0.000137764,-0.176431},
{-0.447899,-0.00271191,-0.192395},
{-0.450776,0.0163934,-0.177429},
{-0.448802,-0.00362939,-0.191397},
{-0.443107,0.0138999,-0.191397},
{-0.45168,0.0154759,-0.176431},
{-0.442915,0.0126262,-0.192395},
};

