/*###############################################################################
# Linux Management Providers (LMP), OS provider package
# Copyright (C) 2007 Ilsoo Byun, ETRI <widepis@etri.re.kr ,widepis@empal.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
###############################################################################*/

#include "OpenDRIM_OperatingSystemDefaultRunLevelAccess.h"

string _InstanceID;
const string _ElementName = "DefaultRunLevel";

int OS_OpenDRIM_OperatingSystemDefaultRunLevel_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	CF_assert(CF_getSystemName(_InstanceID, errorMessage));
	_InstanceID = "OpenDRIM_OperatingSystem:" + _InstanceID + ":DefaultRunLevel";
	_L_;
	return OK;
}

int OS_OpenDRIM_OperatingSystemDefaultRunLevel_unload(string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int OS_OpenDRIM_OperatingSystemDefaultRunLevel_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_OperatingSystemDefaultRunLevel>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	OpenDRIM_OperatingSystemDefaultRunLevel instance;
	instance.setInstanceID(_InstanceID);
	if (discriminant == "ei") {
		CF_assert(OS_OpenDRIM_OperatingSystemDefaultRunLevel_getInstanceInfo(instance, errorMessage));
	}
	result.push_back(instance);
	_L_;
	return OK;
}

int OS_OpenDRIM_OperatingSystemDefaultRunLevel_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_OperatingSystemDefaultRunLevel& instance, const char** properties, string& errorMessage) {
	_E_;
	string InstanceID;
	instance.getInstanceID(InstanceID);
	if (!CF_strCmpNoCase(InstanceID, _InstanceID))
		return NOT_FOUND;
	CF_assert(OS_OpenDRIM_OperatingSystemDefaultRunLevel_getInstanceInfo(instance, errorMessage));
	_L_;
	return OK;
}

int OS_OpenDRIM_OperatingSystemDefaultRunLevel_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_OperatingSystemDefaultRunLevel& newInstance, const OpenDRIM_OperatingSystemDefaultRunLevel& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	unsigned char oldValue, newValue;
	oldInstance.getValue(oldValue);
	if (newInstance.getValue(newValue) != NOT_FOUND && oldValue != newValue) {
		CF_assert(OS_OpenDRIM_OperatingSystemDefaultRunLevel_setValue(newValue, errorMessage));
	}
	_L_;
	return OK;
}

int OS_OpenDRIM_OperatingSystemDefaultRunLevel_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_OperatingSystemDefaultRunLevel& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int OS_OpenDRIM_OperatingSystemDefaultRunLevel_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_OperatingSystemDefaultRunLevel& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int OS_OpenDRIM_OperatingSystemDefaultRunLevel_populate(OpenDRIM_OperatingSystemDefaultRunLevel& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int OS_OpenDRIM_OperatingSystemDefaultRunLevel_getInstanceInfo(OpenDRIM_OperatingSystemDefaultRunLevel& instance, string& errorMessage) {
	_E_;
	instance.setElementName(_ElementName);
	instance.setChangeableType(2);
	unsigned char Value;
	CF_assert(OS_OpenDRIM_OperatingSystemDefaultRunLevel_getValue(Value, errorMessage));
	instance.setValue(Value);
	_L_;
	return OK;
}

int OS_OpenDRIM_OperatingSystemDefaultRunLevel_getValue(unsigned char& Value, string& errorMessage) {
	_E_;
	string inittab;
	CF_assert(CF_readTextFile("/etc/inittab", inittab, errorMessage));
	vector<string> inittab_lines;
	CF_splitText(inittab_lines, inittab, '\n');
	for (size_t i=0; i < inittab_lines.size(); i++) {
		if (inittab_lines[i].size()==0 || inittab_lines[i].substr(0, 1) == "#" || inittab_lines[i].find(":initdefault:") == string::npos)
			continue;
		vector<string> inittab_line;
		CF_splitText(inittab_line, inittab_lines[i], ':');
		if (inittab_line.size() < 4) {
			errorMessage = "Wrong format (at line " + CF_intToStr((unsigned long) i) + "): /etc/inittab";
			return FAILED;	
		}
		Value = atoi(inittab_line[1].c_str());
		break;
	}
	_L_;
	return OK;
}

int OS_OpenDRIM_OperatingSystemDefaultRunLevel_setValue(const unsigned char& newValue, string& errorMessage) {
	_E_;
	if (newValue > 5 || newValue < 1) {
		errorMessage = "Invalid property value (1 <= Value <= 5): Value";
		return FAILED;
	}
	string inittab, updated_inittab;
	CF_assert(CF_readTextFile("/etc/inittab", inittab, errorMessage));
	vector<string> inittab_lines;
	CF_splitText(inittab_lines, inittab, '\n');
	for (size_t i=0; i < inittab_lines.size(); i++) {
		if (inittab_lines[i].size()==0 || inittab_lines[i].substr(0, 1) == "#" || inittab_lines[i].find(":initdefault:") == string::npos) {
			updated_inittab += inittab_lines[i] + "\n";
			continue;
		}
		updated_inittab += "id:" + CF_intToStr(newValue) + ":initdefault:\n";
	}
	CF_assert(CF_writeTextFile("/etc/inittab", updated_inittab, errorMessage));
	_L_;
	return OK;
}
