/*###############################################################################
# Linux Management Providers (LMP), Power Supply provider package
# Copyright (C) 2009 Shakhrom RUSTAMOV, TUIT <shahrombek@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#ifndef OPENDRIM_POWERSUPPLYISSPAREACCESS_H_
#define OPENDRIM_POWERSUPPLYISSPAREACCESS_H_

#include "PowerSupply_Common.h"

#include "OpenDRIM_PowerSupplyIsSpare.h"
#include "assocOpenDRIM_PowerSupplyIsSpare.h"

int PowerSupply_OpenDRIM_PowerSupplyIsSpare_load(const CMPIBroker* broker, string& errorMessage);

int PowerSupply_OpenDRIM_PowerSupplyIsSpare_unload(string& errorMessage);

int PowerSupply_OpenDRIM_PowerSupplyIsSpare_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_PowerSupplyIsSpare>& instances, const char** properties, string& errorMessage, const string& discriminant);

int PowerSupply_OpenDRIM_PowerSupplyIsSpare_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_PowerSupplyIsSpare& instance, const char** properties, string& errorMessage);

int PowerSupply_OpenDRIM_PowerSupplyIsSpare_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PowerSupplyIsSpare& newInstance, const OpenDRIM_PowerSupplyIsSpare& oldInstance, const char** properties, string& errorMessage);

int PowerSupply_OpenDRIM_PowerSupplyIsSpare_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PowerSupplyIsSpare& instance, string& errorMessage);

int PowerSupply_OpenDRIM_PowerSupplyIsSpare_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PowerSupplyIsSpare& instance, string& errorMessage);

int PowerSupply_OpenDRIM_PowerSupplyIsSpare_associatorAntecedentToDependent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Antecedent_instance, const char** properties, vector<Instance>& Dependent_associatedInstances, string& errorMessage, const string& discriminant);

int PowerSupply_OpenDRIM_PowerSupplyIsSpare_associatorDependentToAntecedent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Dependent_instance, const char** properties, vector<Instance>& Antecedent_associatedInstances, string& errorMessage, const string& discriminant);

int PowerSupply_OpenDRIM_PowerSupplyIsSpare_referenceAntecedentToDependent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Antecedent_instance, const vector<Instance>& Dependent_instances, vector<OpenDRIM_PowerSupplyIsSpare>& OpenDRIM_PowerSupplyIsSpare_instances, const char** properties, string& errorMessage, const string& discriminant);

int PowerSupply_OpenDRIM_PowerSupplyIsSpare_referenceDependentToAntecedent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Dependent_instance, const vector<Instance>& Antecedent_instances, vector<OpenDRIM_PowerSupplyIsSpare>& OpenDRIM_PowerSupplyIsSpare_instances, const char** properties, string& errorMessage, const string& discriminant);

int PowerSupply_OpenDRIM_PowerSupplyIsSpare_populate(OpenDRIM_PowerSupplyIsSpare& instance, string& errorMessage);

#endif /*OPENDRIM_POWERSUPPLYISSPAREACCESS_H_*/
