/*###############################################################################
# Linux Management Providers (LMP), Software Inventory provider package
# Copyright (C) 2009 Nazarov Nodir, TUIT <nazarov.nodir@gmail.com, nodir2000@yahoo.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_SOFTWAREINVENTORYIDENTITY_H_
#define OPENDRIM_SOFTWAREINVENTORYIDENTITY_H_

#include <Association.h>

// Direct Invocation includes, may have to be adjusted
/*
#include "cmpiCIM_SoftwareIdentity.h"
#include "CIM_SoftwareIdentityAccess.h"
#include "cmpiCIM_ManagedElement.h"
#include "CIM_ManagedElementAccess.h"
*/

const static char* OpenDRIM_SoftwareInventoryIdentity_classnames[] = {"OpenDRIM_SoftwareInventoryIdentity"};
static string OpenDRIM_SoftwareInventoryIdentity_NAMESPACE = _NAMESPACE;
const static string Antecedent_role = "Antecedent";
const static char* Antecedent_classnames[] = {"OpenDRIM_SoftwareIdentity"};
const static string Antecedent_NAMESPACE = _NAMESPACE;

const static string Dependent_role = "Dependent";
const static char* Dependent_classnames[] = {"CIM_ManagedElement"};
const static string Dependent_NAMESPACE = _NAMESPACE;

class OpenDRIM_SoftwareInventoryIdentity {

public:
	
	Objectpath Antecedent;
	bool Antecedent_isNULL;
	
	Objectpath Dependent;
	bool Dependent_isNULL;
	
	unsigned short UpgradeCondition;
	bool UpgradeCondition_isNULL;
	
	string OtherUpgradeCondition;
	bool OtherUpgradeCondition_isNULL;
	
	vector<unsigned short> ElementSoftwareStatus;
	bool ElementSoftwareStatus_isNULL;
	
	OpenDRIM_SoftwareInventoryIdentity() {
		Antecedent_isNULL = true;
		Dependent_isNULL = true;
		UpgradeCondition_isNULL = true;
		OtherUpgradeCondition_isNULL = true;
		ElementSoftwareStatus_isNULL = true;
	}
	
	~OpenDRIM_SoftwareInventoryIdentity() {}
	
	string getKeys() const {
		return CF_toLowCase(".Antecedent=\"" + CF_quoteString(Antecedent.toString()) + "\""".Dependent=\"" + CF_quoteString(Dependent.toString()) + "\"");
	}

	int getAntecedent(Objectpath& value) const {
		if (Antecedent_isNULL==true)
			return NOT_FOUND;
		value = Antecedent;
		return OK;
	}
	
	int setAntecedent(const Objectpath& newValue) {
		Antecedent = newValue;
		Antecedent.setNamespace(Antecedent_NAMESPACE);
		Antecedent_isNULL = false;
		return OK;
	}

	int getDependent(Objectpath& value) const {
		if (Dependent_isNULL==true)
			return NOT_FOUND;
		value = Dependent;
		return OK;
	}
	
	int setDependent(const Objectpath& newValue) {
		Dependent = newValue;
		Dependent.setNamespace(Dependent_NAMESPACE);
		Dependent_isNULL = false;
		return OK;
	}

	int getUpgradeCondition(unsigned short& value) const {
		if (UpgradeCondition_isNULL==true)
			return NOT_FOUND;
		value = UpgradeCondition;
		return OK;
	}
	
	int setUpgradeCondition(const unsigned short& newValue) {
		UpgradeCondition = newValue;
		UpgradeCondition_isNULL = false;
		return OK;
	}

	int getOtherUpgradeCondition(string& value) const {
		if (OtherUpgradeCondition_isNULL==true)
			return NOT_FOUND;
		value = OtherUpgradeCondition;
		return OK;
	}
	
	int setOtherUpgradeCondition(const string& newValue) {
		OtherUpgradeCondition = newValue;
		OtherUpgradeCondition_isNULL = false;
		return OK;
	}

	int getElementSoftwareStatus(vector<unsigned short>& value) const {
		if (ElementSoftwareStatus_isNULL==true)
			return NOT_FOUND;
		value = ElementSoftwareStatus;
		return OK;
	}
	
	int setElementSoftwareStatus(const vector<unsigned short>& newValue) {
		ElementSoftwareStatus = newValue;
		ElementSoftwareStatus_isNULL = false;
		return OK;
	}

};

#endif /*OPENDRIM_SOFTWAREINVENTORYIDENTITY_H_*/
