#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Hob
###

script_version=20230322.1

GAME_ID='hob-game'
GAME_NAME='Hob'

ARCHIVE_BASE_0='setup_hob_1.17.3.0_(16560).exe'
ARCHIVE_BASE_0_MD5='e99ca23c70ea3bfd4335fee7ca5a618e'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1='setup_hob_1.17.3.0_(16560)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='25455a965280f7ac6f94f4ff7d96b852'
ARCHIVE_BASE_0_SIZE='2800000'
ARCHIVE_BASE_0_VERSION='1.17.3.0-gog16560'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/hob'

CONTENT_PATH_DEFAULT='app'
CONTENT_GAME_BIN_FILES='
*.cfg
*.dll
hob.exe
hoblauncher.exe'
CONTENT_GAME_DATA_FILES='
audiobanks
media
music
paks'

WINE_DIRECT3D_RENDERER='dxvk'

APP_WINE_LINK_DIRS='
userdata:users/${USER}/Documents/My Games/Runic Games/HOB'
USER_PERSISTENT_DIRECTORIES='
userdata'

APP_MAIN_EXE='hob.exe'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID"

# Load common functions

target_version='2.22'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'

# Include game icons

PKG='PKG_DATA'
icons_inclusion

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build package

write_metadata
build_pkg

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
