#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2017 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Little Inferno expansions:
# - Ho Ho Holiday
###

script_version=20230921.1

PLAYIT_COMPATIBILITY_LEVEL='2.26'

GAME_ID='little-inferno'
GAME_NAME='Little Inferno'

EXPANSION_ID_HOHOHOLIDAY='ho-ho-holiday'
EXPANSION_NAME_HOHOHOLIDAY='Ho Ho Holiday'

# Archives

## Ho Ho Holiday

ARCHIVE_BASE_HOHOHOLIDAY_0_NAME='LittleInfernoHoHoHoliday-Linux-2022-12-07.sh'
ARCHIVE_BASE_HOHOHOLIDAY_0_MD5='7124105953b1a899f239a0fdbd492458'
ARCHIVE_BASE_HOHOHOLIDAY_0_SIZE='430'
ARCHIVE_BASE_HOHOHOLIDAY_0_VERSION='1.0-humble.2022.12.07'
ARCHIVE_BASE_HOHOHOLIDAY_0_URL='http://tomorrowcorporation.com/littleinferno#hohoholiday'


CONTENT_PATH_DEFAULT='data/noarch'
CONTENT_GAME_MAIN_FILES='
.tcgame-4097.info'

PKG_MAIN_DEPS="$GAME_ID"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_default

# Build packages

packages_generation

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
