/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.btree;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.store.access.BackingStoreHashtable;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.store.access.btree.BTreeRowPosition;
import org.apache.derby.impl.store.access.btree.BTreeScan;
import org.apache.derby.impl.store.access.btree.ControlRow;

public class BTreeForwardScan
extends BTreeScan {
    protected void positionAtStartPosition(BTreeRowPosition bTreeRowPosition) throws StandardException {
        this.positionAtStartForForwardScan(bTreeRowPosition);
    }

    protected int fetchRows(BTreeRowPosition bTreeRowPosition, DataValueDescriptor[][] dataValueDescriptorArray, RowLocation[] rowLocationArray, BackingStoreHashtable backingStoreHashtable, long l, int[] nArray) throws StandardException {
        int n = 0;
        Object[] objectArray = null;
        if (l == -1L) {
            l = Long.MAX_VALUE;
        }
        if (this.scan_state == 2) {
            if (!this.reposition(bTreeRowPosition, true)) {
                // empty if block
            }
        } else if (this.scan_state == 1) {
            this.positionAtStartPosition(bTreeRowPosition);
        } else if (this.scan_state == 5) {
            this.reopen();
            this.scan_state = 2;
            if (!this.reposition(bTreeRowPosition, true)) {
                // empty if block
            }
        } else if (this.scan_state == 4) {
            this.reopen();
            this.positionAtStartForForwardScan(this.scan_position);
        } else {
            return 0;
        }
        while (bTreeRowPosition.current_leaf != null) {
            while (bTreeRowPosition.current_slot + 1 < bTreeRowPosition.current_leaf.page.recordCount()) {
                int n2;
                if (bTreeRowPosition.current_rh != null) {
                    this.getLockingPolicy().unlockScanRecordAfterRead(bTreeRowPosition, this.init_forUpdate);
                    bTreeRowPosition.current_rh = null;
                }
                if (objectArray == null) {
                    if (backingStoreHashtable == null) {
                        if (dataValueDescriptorArray[n] == null) {
                            dataValueDescriptorArray[n] = this.runtime_mem.get_row_for_export(this.getRawTran());
                        }
                        objectArray = dataValueDescriptorArray[n];
                    } else {
                        objectArray = this.runtime_mem.get_row_for_export(this.getRawTran());
                    }
                }
                ++bTreeRowPosition.current_slot;
                ++this.stat_numrows_visited;
                RecordHandle recordHandle = bTreeRowPosition.current_leaf.page.fetchFromSlot(null, bTreeRowPosition.current_slot, objectArray, this.init_fetchDesc, true);
                bTreeRowPosition.current_rh_qualified = true;
                if (this.init_stopKeyValue != null) {
                    n2 = ControlRow.compareIndexRowToKey((DataValueDescriptor[])objectArray, this.init_stopKeyValue, objectArray.length, 0, this.getConglomerate().ascDescInfo);
                    if (n2 == 0 && this.init_stopSearchOperator == 1) {
                        n2 = 1;
                    }
                    if (n2 > 0) {
                        bTreeRowPosition.current_leaf.release();
                        bTreeRowPosition.current_leaf = null;
                        this.positionAtDoneScan(bTreeRowPosition);
                        return n;
                    }
                }
                n2 = !this.getLockingPolicy().lockScanRow(this, this.getConglomerate(), bTreeRowPosition, false, this.init_lock_fetch_desc, bTreeRowPosition.current_lock_template, bTreeRowPosition.current_lock_row_loc, false, this.init_forUpdate, this.lock_operation) ? 1 : 0;
                bTreeRowPosition.current_rh = recordHandle;
                if (n2 != 0) {
                    if (this.getConglomerate().isUnique()) {
                        while (n2 != 0) {
                            if (!this.reposition(bTreeRowPosition, false)) {
                                // empty if block
                            }
                            bTreeRowPosition.current_leaf.page.fetchFromSlot(null, bTreeRowPosition.current_slot, objectArray, this.init_fetchDesc, true);
                            n2 = !this.getLockingPolicy().lockScanRow(this, this.getConglomerate(), bTreeRowPosition, false, this.init_lock_fetch_desc, bTreeRowPosition.current_lock_template, bTreeRowPosition.current_lock_row_loc, false, this.init_forUpdate, this.lock_operation) ? 1 : 0;
                        }
                    } else if (!this.reposition(bTreeRowPosition, false)) {
                        // empty if block
                    }
                }
                if (bTreeRowPosition.current_leaf.page.isDeletedAtSlot(bTreeRowPosition.current_slot)) {
                    ++this.stat_numdeleted_rows_visited;
                    bTreeRowPosition.current_rh_qualified = false;
                } else if (this.init_qualifier != null) {
                    bTreeRowPosition.current_rh_qualified = this.process_qualifier((DataValueDescriptor[])objectArray);
                }
                if (!bTreeRowPosition.current_rh_qualified) continue;
                ++n;
                ++this.stat_numrows_qualified;
                if (backingStoreHashtable != null) {
                    if (backingStoreHashtable.putRow(false, (DataValueDescriptor[])objectArray)) {
                        objectArray = null;
                    }
                } else {
                    objectArray = null;
                }
                if (l > (long)n) continue;
                bTreeRowPosition.current_slot = -1;
                bTreeRowPosition.current_leaf.release();
                bTreeRowPosition.current_leaf = null;
                return n;
            }
            this.positionAtNextPage(bTreeRowPosition);
            ++this.stat_numpages_visited;
        }
        this.positionAtDoneScan(bTreeRowPosition);
        --this.stat_numpages_visited;
        return n;
    }
}

