!{\src2tex{textfont=tt}}
!!****f* ABINIT/findq
!! NAME
!! findq
!!
!! FUNCTION
!! Identify the q-points by which the k-points in BZ differ
!!
!! COPYRIGHT
!! Copyright (C) 1999-2007 ABINIT group (GMR, VO, LR, RWG, MT, MG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  b1(3),b2(3),b3(3)=the three primitive vectors in reciprocal space
!!  kbz(3,nkbz)=coordinates of k points in BZ
!!  ninv=1 if inversion is not to be taken into account; 2 if inversion is to be taken into account
!!  nkbz=number of k points in Brillouin zone
!!  nop=number of symmetry operations
!!  nq=number of q points by which k points differ (computed in findnq)
!!  op(3,3,nop)=symmetry operations in reciprocal space
!!
!! OUTPUT
!!  q(3,nq)=coordinates of q points by which k points differ
!!
!! PARENTS
!!      mrgscr,screening
!!
!! CHILDREN
!!      bz1,dosym,wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine findq(nkbz,kbz,nop,op,nq,q,ninv,b1,b2,b3)

 use defs_basis

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
 use interfaces_15gw, except_this_one => findq
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: ninv,nkbz,nop,nq
!arrays
 real(dp),intent(in) :: b1(3),b2(3),b3(3),kbz(3,nkbz),op(3,3,nop)
 real(dp),intent(out) :: q(3,nq)

!Local variables ------------------------------
!scalars
 integer :: i,iinv,ik,iop,iq,iqp,j
 logical :: found
 character(len=500) :: message
!arrays
 integer :: gtemp(3)
 real(dp) :: qposs(3),qrot(3)

! *************************************************************************
!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifndef HAVE_FORTRAN_INTERFACES
 integer :: icmpk2
 integer :: itst0
#endif
!End of the abilint section

 write(message,'(a)')' find q-points q = k - k1 and translate in first BZ'
 call wrtout(6,message,'COLL') ; call wrtout(ab_out,message,'COLL')

 !zero no. of q-points found
 iq=0

 !loop over all k-points in BZ, forming k-k1
 do ik=1,nkbz
  qposs(1)=kbz(1,ik)-kbz(1,1)
  qposs(2)=kbz(2,ik)-kbz(2,1)
  qposs(3)=kbz(3,ik)-kbz(3,1)

  !check whether this q (or its equivalent) has already been found
  found=.false.
  do iqp=1,iq
   do iinv=1,ninv
    do iop=1,nop
     call dosym(op(1,1,iop),iinv,q(1,iqp),qrot)
     if(icmpk2(qrot,qposs)==1) found=.true.
    end do
   end do
  end do
  if(.not.found) then
   iq=iq+1
   if(iq>nq) stop '**bug: iq>nq'
   q(1,iq)=qposs(1)
   q(2,iq)=qposs(2)
   q(3,iq)=qposs(3)
  end if
 end do !ik

 if(iq/=nq) stop '**bug: iq !=nq'

 !translate q-points (calculated for info) to 1st BZ
 do iq=1,nq
  call bz1(q(:,iq),gtemp,b1,b2,b3)
 end do

 write(message,'(a)')' q-points [reduced coordinates]'
 call wrtout(6,message,'COLL') ; call wrtout(ab_out,message,'COLL')
 do j=1,nq
  if(itst0(q(:,j))==1) then
   q(1,j)=0.000010
   q(2,j)=0.000020
   q(3,j)=0.000030
  end if
  !if(mpi_enreg%me==0)then ! only master should write
   write(6,'(3f12.6)') (q(i,j),i=1,3)
   write(ab_out,'(3f12.6)') (q(i,j),i=1,3)
  !end if
 end do
 
 !if(mpi_enreg%me==0)then ! only master should write
  write(6,*)
  write(ab_out,*)
 !end if 

end subroutine findq
!!***
