!{\src2tex{textfont=tt}}
!!****f* ABINIT/vlngth
!! NAME
!! vlngth
!!
!! FUNCTION
!! Calculate the length of a vector expressed in terms of the
!! reciprocal-space basis vectors b1-b3
!!
!! COPYRIGHT
!! Copyright (C) 1999-2007 ABINIT group (GMR, VO, LR, RWG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! PARENTS
!!
!! INPUTS
!!  v(3)=vector
!!  b1(3),b2(3),b3(3)=the three primitive vectors in reciprocal space
!!
!! OUTPUT
!!  function vlngth=length of the vector
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

function vlngth(v,b1,b2,b3)

 use defs_basis

 implicit none

!Arguments ------------------------------------
!scalars
 real(dp) :: vlngth
!arrays
 real(dp),intent(in) :: b1(3),b2(3),b3(3),v(3)

!Local variables-------------------------------
!scalars
 integer :: ii

! *************************************************************************

 vlngth=zero
 do ii=1,3
   vlngth=vlngth+(v(1)*b1(ii)+v(2)*b2(ii)+v(3)*b3(ii))**2
 end do
 vlngth=sqrt(vlngth)
 end function vlngth
!!***
