!{\src2tex{textfont=tt}}
!!****f* ABINIT/scale_phi
!! NAME
!! scale_phi
!! 
!! FUNCTION
!! Scale wave functions (Phi) in order to get normalized occupancies
!! Scale pseudo wave functions (Phi) and projectors (tproj) according to Phi
!!
!! COPYRIGHT
!! Copyright (C) 1998-2005 ABINIT group (FJ,MT)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~ABINIT/Infos/copyright
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~ABINIT/Infos/contributors .
!!
!! INPUTS
!!  pshead
!!    %basis_size= Number of elements for the paw nl basis
!!    %prj_meshsz= Dimension of radial mesh for tProj
!!    %sph_meshsz= Dimension of radial mesh for spheres
!!    %wav_meshsz=Mesh size for partial waves and projectors inherited from uspp
!!  usdata
!!    %lval(nval)= l angular momentum for each valence state
!!    %nval= Number of valence states
!!    %snl(wav_meshsz,nval)= Radial part of atomic eigenfunction
!!                           for each valence state
!!  un_log= Unit number for log file (comments)
!!
!! SIDE EFFECTS
!!  pawps
!!    %phi(wav_meshsz,basis_size)= atomic partial waves
!!    %tphi(wav_meshsz,basis_size)= atomic pseudo partial waves
!!    %tproj(prj_msz_max,basis_size)= projectors on partial waves
!!
!! PARENTS
!!      uspp2abinit
!!
!! CHILDREN
!!
!! SOURCE

 subroutine scale_phi(pawps,pshead,usdata,un_log)

 use defs_basis
 use defs_pawps

 implicit none

!Arguments ---------------------------------------------
 integer :: un_log
!These types are defined in defs_pawps
 type(pawps_type)    :: pawps
 type(pshead_type)   :: pshead
 type(usdata_type)   :: usdata

!Local variables ---------------------------------------
 integer :: ib,ir,ival
 real(dp) :: factor
 logical :: found

!--------------------------------------------------------

!Scale Phi, tPhi, tProj
 do ib=1,pshead%basis_size
  found=.false.
  do ival=1,usdata%nval
   if (pshead%orbitals(ib)==usdata%lval(ival)) then
    found=.true.
    factor=usdata%snl(pshead%sph_meshsz,ival)/pawps%phi(pshead%sph_meshsz,ib)
    do ir=1,pshead%wav_meshsz
     pawps%phi  (ir,ib)=pawps%phi  (ir,ib)*factor
     pawps%tphi (ir,ib)=pawps%tphi (ir,ib)*factor
    enddo
    do ir=1,pshead%prj_meshsz
     pawps%tproj(ir,ib)=pawps%tproj(ir,ib)/factor
    enddo
   endif
  enddo
  if (.not.found) then
   factor=1.d0/pawps%phi(pshead%sph_meshsz,ib)
   do ir=1,pshead%wav_meshsz
    pawps%phi  (ir,ib)=pawps%phi  (ir,ib)*factor
    pawps%tphi (ir,ib)=pawps%tphi (ir,ib)*factor
   enddo
   do ir=1,pshead%prj_meshsz
    pawps%tproj(ir,ib)=pawps%tproj(ir,ib)/factor
   enddo
  endif
 enddo

 end subroutine
!!***
