###########################################################
#
# amuleadunanza
#
###########################################################
#
# AMULEADUNANZA_VERSION, AMULEADUNANZA_SITE and AMULEADUNANZA_SOURCE define
# the upstream location of the source code for the package.
# AMULEADUNANZA_DIR is the directory which is created when the source
# archive is unpacked.
# AMULEADUNANZA_UNZIP is the command used to unzip the source.
# It is usually "zcat" (for .gz) or "bzcat" (for .bz2)
#
# You should change all these variables to suit your package.
# Please make sure that you add a description, and that you
# list all your packages' dependencies, seperated by commas.
# 
# If you list yourself as MAINTAINER, please give a valid email
# address, and indicate your irc nick if it cannot be easily deduced
# from your name or email address.  If you leave MAINTAINER set to
# "NSLU2 Linux" other developers will feel free to edit.
# http://developer.berlios.de/projects/amule/

#AMULEADUNANZA_SITE=http://download.berlios.de/amule
AMULEADUNANZA_VERSION=2012.1
#AMULEADUNANZA_SITE=http://$(SOURCEFORGE_MIRROR)/sourceforge/amule
# AMULEADUNANZA_SITE=http://$(SOURCEFORGE_MIRROR)/project/amule/aMule/$(AMULEADUNANZA_VERSION)
AMULEADUNANZA_SITE=ftp://192.168.1.1/AdunanzA/testoptware/src
AMULEADUNANZA_SOURCE=aMuleAdunanzA-$(AMULEADUNANZA_VERSION).tar.bz2
AMULEADUNANZA_DIR=aMuleAdunanzA-$(AMULEADUNANZA_VERSION)
AMULEADUNANZA_UNZIP=bzcat
AMULEADUNANZA_MAINTAINER=NSLU2 Linux <nslu2-linux@yahoogroups.com>
AMULEADUNANZA_DESCRIPTION=non-gui part of aMuleiAdunanzA ed2k client (amuled,amulweb,amulecmd of MOD AdunanzA for Italian ISP Fastweb) 
AMULEADUNANZA_SECTION=net
AMULEADUNANZA_PRIORITY=optional
# AMULEADUNANZA_DEPENDS=libstdc++, wxbase, zlib, libcurl, libpng, libgd, libupnp, readline, ncurses
AMULEADUNANZA_DEPENDS=libstdc++, wxbase, zlib, libpng, libgd, libupnp
AMULEADUNANZA_SUGGESTS=
AMULEADUNANZA_CONFLICTS=

#
# AMULEADUNANZA_IPK_VERSION should be incremented when the ipk changes.
#
AMULEADUNANZA_IPK_VERSION=1

#
# AMULEADUNANZA_CONFFILES should be a list of user-editable files
## AMULEADUNANZA_CONFFILES=/opt/etc/amule.conf /opt/etc/init.d/SXXamule

#
# AMULEADUNANZA_PATCHES should list any patches, in the the order in
# which they should be applied to the source code.
#
AMULEADUNANZA_PATCHES=#$(AMULEADUNANZA_SOURCE_DIR)/uintptr_t.patch \
#$(AMULEADUNANZA_SOURCE_DIR)/libupnp-cross.patch

# ifeq ($(LIBC_STYLE), uclibc)
# AMULEADUNANZA_PATCHES+=$(AMULEADUNANZA_SOURCE_DIR)/amule-1gb-uclibc-mipsel.patch
# endif

#
# If the compilation of the package requires additional
# compilation or linking flags, then list them here.
#
AMULEADUNANZA_CPPFLAGS=
ifeq ($(OPTWARE_TARGET), ts101)
AMULEADUNANZA_CPPFLAGS+= -fno-builtin-log -fno-builtin-exp
endif
AMULEADUNANZA_LDFLAGS=
AMULEADUNANZA_CONFIGURE_OPTS = ac_cv_func_malloc_0_nonnull=yes ac_cv_func_realloc_0_nonnull=yes
ifeq ($(LIBC_STYLE), uclibc)
ifdef TARGET_GXX
AMULEADUNANZA_CONFIGURE_OPTS += CXX=$(TARGET_GXX)
endif
endif

AMULEADUNANZA_CONFIGURE_ARGS = \
		--build=$(GNU_HOST_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--target=$(GNU_TARGET_NAME) \
		--prefix=/opt \
		--disable-debug \
		--enable-optimize \
		--enable-alcc \
		--enable-amule-daemon \
		--enable-webserver \
		--enable-amulecmd \
		--enable-upnp \
		--disable-monolithic \
		--disable-alc \
		--disable-amulecmdgui \
		--disable-cas \
		--disable-wxcas \
		--disable-systray \
		--enable-adu-nslu2 \
		--with-curl-config=$(STAGING_DIR)/bin/curl-config \
		--with-gdlib-prefix=$(STAGING_PREFIX) \
		--with-libpng-prefix=$(STAGING_PREFIX) \
		--with-libupnp-prefix=$(STAGING_PREFIX) \
		--with-wxbase-config=$(STAGING_DIR)/opt/bin/wx-config \
		--with-wx-config=$(STAGING_DIR)/opt/bin/wx-config \
		--with-wx-prefix=$(STAGING_PREFIX) \
		--with-crypto-prefix=$(STAGING_PREFIX) \
		--with-zlib=$(STAGING_PREFIX) \
		--disable-nls \
		--disable-static

#
# AMULEADUNANZA_BUILD_DIR is the directory in which the build is done.
# AMULEADUNANZA_SOURCE_DIR is the directory which holds all the
# patches and ipkg control files.
# AMULEADUNANZA_IPK_DIR is the directory in which the ipk is built.
# AMULEADUNANZA_IPK is the name of the resulting ipk files.
#
# You should not change any of these variables.
#
AMULEADUNANZA_BUILD_DIR=$(BUILD_DIR)/amuleadunanza
AMULEADUNANZA_SOURCE_DIR=$(SOURCE_DIR)/amuleadunanza
AMULEADUNANZA_IPK_DIR=$(BUILD_DIR)/amuleadunanza-$(AMULEADUNANZA_VERSION)-ipk
AMULEADUNANZA_IPK=$(BUILD_DIR)/amuleadunanza_$(AMULEADUNANZA_VERSION)-$(AMULEADUNANZA_IPK_VERSION)_$(TARGET_ARCH).ipk

.PHONY: amuleadunanza-source amuleadunanza-unpack amuleadunanza amuleadunanza-stage amuleadunanza-ipk amuleadunanza-clean amuleadunanza-dirclean amuleadunanza-check

#
# This is the dependency on the source code.  If the source is missing,
# then it will be fetched from the site using wget.
#
$(DL_DIR)/$(AMULEADUNANZA_SOURCE):
	$(WGET) -P $(@D) $(AMULEADUNANZA_SITE)/$(@F) || \
	$(WGET) -P $(@D) $(SOURCES_NLO_SITE)/$(@F)

#
# The source code depends on it existing within the download directory.
# This target will be called by the top level Makefile to download the
# source code's archive (.tar.gz, .bz2, etc.)
#
amuleadunanza-source: $(DL_DIR)/$(AMULEADUNANZA_SOURCE) $(AMULEADUNANZA_PATCHES)

#
# This target unpacks the source code in the build directory.
# If the source archive is not .tar.gz or .tar.bz2, then you will need
# to change the commands here.  Patches to the source code are also
# applied in this target as required.
#
# This target also configures the build within the build directory.
# Flags such as LDFLAGS and CPPFLAGS should be passed into configure
# and NOT $(MAKE) below.  Passing it to configure causes configure to
# correctly BUILD the Makefile with the right paths, where passing it
# to Make causes it to override the default search paths of the compiler.
#
# If the compilation of the package requires other packages to be staged
# first, then do that first (e.g. "$(MAKE) <bar>-stage <baz>-stage").
#
# If the package uses  GNU libtool, you should invoke $(PATCH_LIBTOOL) as
# shown below to make various patches to it.
#
#
$(AMULEADUNANZA_BUILD_DIR)/.configured: $(DL_DIR)/$(AMULEADUNANZA_SOURCE) $(AMULEADUNANZA_PATCHES)
	$(MAKE) libstdc++-stage crypto++-stage ncurses-stage
	$(MAKE) wxbase-stage libcurl-stage zlib-stage libpng-stage libgd-stage libupnp-stage readline-stage
	rm -rf $(BUILD_DIR)/$(AMULEADUNANZA_DIR) $(@D)
	$(AMULEADUNANZA_UNZIP) $(DL_DIR)/$(AMULEADUNANZA_SOURCE) | tar -C $(BUILD_DIR) -xvf -
	if test -n "$(AMULEADUNANZA_PATCHES)" ; \
		then cat $(AMULEADUNANZA_PATCHES) | \
		patch -bd $(BUILD_DIR)/$(AMULEADUNANZA_DIR) -p1 ; \
	fi
	if test "$(BUILD_DIR)/$(AMULEADUNANZA_DIR)" != "$(@D)" ; \
		then mv $(BUILD_DIR)/$(AMULEADUNANZA_DIR) $(@D) ; \
	fi
	(cd $(@D); \
		$(TARGET_CONFIGURE_OPTS) \
		CPPFLAGS="$(STAGING_CPPFLAGS) $(AMULEADUNANZA_CPPFLAGS)" \
		LDFLAGS="$(STAGING_LDFLAGS) $(AMULEADUNANZA_LDFLAGS)" \
		$(AMULEADUNANZA_CONFIGURE_OPTS) \
		./configure \
		$(AMULEADUNANZA_CONFIGURE_ARGS) \
	)
##	$(PATCH_LIBTOOL) $(@D)/libtool
	touch $@


amuleadunanza-unpack: $(AMULEADUNANZA_BUILD_DIR)/.configured


#
# This builds the actual binary.
#
$(AMULEADUNANZA_BUILD_DIR)/.built: $(AMULEADUNANZA_BUILD_DIR)/.configured
	rm -f $@
	$(MAKE) -C $(@D) HOSTCC=$(HOSTCC)
	touch $@

#
# This is the build convenience target.
#
amuleadunanza: $(AMULEADUNANZA_BUILD_DIR)/.built

#
# If you are building a library, then you need to stage it too.
#
$(AMULEADUNANZA_BUILD_DIR)/.staged: $(AMULEADUNANZA_BUILD_DIR)/.built
	rm -f $(AMULEADUNANZA_BUILD_DIR)/.staged
	$(MAKE) -C $(AMULEADUNANZA_BUILD_DIR) DESTDIR=$(STAGING_DIR) install
	touch $(AMULEADUNANZA_BUILD_DIR)/.staged

# amuleadunanza-stage: $(AMULEADUNANZA_BUILD_DIR)/.staged

#
# This rule creates a control file for ipkg.  It is no longer
# necessary to create a seperate control file under sources/amule
#
$(AMULEADUNANZA_IPK_DIR)/CONTROL/control:
	@install -d $(@D)
	@rm -f $@
	@echo "Package: amule" >>$@
	@echo "Architecture: $(TARGET_ARCH)" >>$@
	@echo "Priority: $(AMULEADUNANZA_PRIORITY)" >>$@
	@echo "Section: $(AMULEADUNANZA_SECTION)" >>$@
	@echo "Version: $(AMULEADUNANZA_VERSION)-$(AMULEADUNANZA_IPK_VERSION)" >>$@
	@echo "Maintainer: $(AMULEADUNANZA_MAINTAINER)" >>$@
	@echo "Source: $(AMULEADUNANZA_SITE)/$(AMULEADUNANZA_SOURCE)" >>$@
	@echo "Description: $(AMULEADUNANZA_DESCRIPTION)" >>$@
	@echo "Depends: $(AMULEADUNANZA_DEPENDS)" >>$@
	@echo "Suggests: $(AMULEADUNANZA_SUGGESTS)" >>$@
	@echo "Conflicts: $(AMULEADUNANZA_CONFLICTS)" >>$@

#
# This builds the IPK file.
#
# Binaries should be installed into $(AMULEADUNANZA_IPK_DIR)/opt/sbin or $(AMULEADUNANZA_IPK_DIR)/opt/bin
# (use the location in a well-known Linux distro as a guide for choosing sbin or bin).
# Libraries and include files should be installed into $(AMULEADUNANZA_IPK_DIR)/opt/{lib,include}
# Configuration files should be installed in $(AMULEADUNANZA_IPK_DIR)/opt/etc/amule/...
# Documentation files should be installed in $(AMULEADUNANZA_IPK_DIR)/opt/doc/amule/...
# Daemon startup scripts should be installed in $(AMULEADUNANZA_IPK_DIR)/opt/etc/init.d/S??amule
#
# You may need to patch your application to make it use these locations.
#
$(AMULEADUNANZA_IPK): $(AMULEADUNANZA_BUILD_DIR)/.built
	rm -rf $(AMULEADUNANZA_IPK_DIR) $(BUILD_DIR)/amuleadunanza_*_$(TARGET_ARCH).ipk
	$(MAKE) -C $(AMULEADUNANZA_BUILD_DIR) DESTDIR=$(AMULEADUNANZA_IPK_DIR) program_transform_name=s/^$(GNU_TARGET_NAME)-// install-strip
#	install -d $(AMULEADUNANZA_IPK_DIR)/opt/etc/
#	install -m 644 $(AMULEADUNANZA_SOURCE_DIR)/amule.conf $(AMULEADUNANZA_IPK_DIR)/opt/etc/amule.conf
	install -d $(AMULEADUNANZA_IPK_DIR)/opt/etc/init.d
	install -m 755 $(AMULEADUNANZA_SOURCE_DIR)/platforms/Optware/rc.amuledadunanza $(AMULEADUNANZA_IPK_DIR)/opt/etc/init.d/S57amuledadunanza
	$(MAKE) $(AMULEADUNANZA_IPK_DIR)/CONTROL/control
#	install -m 755 $(AMULEADUNANZA_SOURCE_DIR)/postinst $(AMULEADUNANZA_IPK_DIR)/CONTROL/postinst
#	install -m 755 $(AMULEADUNANZA_SOURCE_DIR)/prerm $(AMULEADUNANZA_IPK_DIR)/CONTROL/prerm
	echo $(AMULEADUNANZA_CONFFILES) | sed -e 's/ /\n/g' > $(AMULEADUNANZA_IPK_DIR)/CONTROL/conffiles
	cd $(BUILD_DIR); $(IPKG_BUILD) $(AMULEADUNANZA_IPK_DIR)
	$(WHAT_TO_DO_WITH_IPK_DIR) $(AMULEADUNANZA_IPK_DIR)

#
# This is called from the top level makefile to create the IPK file.
#
amuleadunanza-ipk: $(AMULEADUNANZA_IPK)

#
# This is called from the top level makefile to clean all of the built files.
#
amuleadunanza-clean:
	rm -f $(AMULEADUNANZA_BUILD_DIR)/.built
	-$(MAKE) -C $(AMULEADUNANZA_BUILD_DIR) clean

#
# This is called from the top level makefile to clean all dynamically created
# directories.
#
amuleadunanza-dirclean:
	rm -rf $(BUILD_DIR)/$(AMULEADUNANZA_DIR) $(AMULEADUNANZA_BUILD_DIR)
	rm -rf $(AMULEADUNANZA_IPK_DIR) $(AMULEADUNANZA_IPK)
#
#
# Some sanity check for the package.
#
amuleadunanza-check: $(AMULEADUNANZA_IPK)
	perl scripts/optware-check-package.pl --target=$(OPTWARE_TARGET) $^
