# D.9 Why does political power become concentrated under capitalism?

Under capitalism, political power tends to become concentrated in the
executive branch of government, along with a corresponding decline in the
effectiveness of parliamentary institutions. As Kropotkin discussed in his
account of _"Representative Government,"_ parliaments grew out of the struggle
of capitalists against the power of centralised monarchies during the early
modern period. This meant that the function of parliaments was to check and
control the exercise of executive power when it was controlled by another
class (namely the aristocracy and landlords). The role of Parliaments
flourished and reached the peak of their prestige in the struggle against the
monarchy and immediately afterwards.

With the end of absolute monarchy, legislatures become battlegrounds of
contending parties, divided by divergent class and group interests. This
reduces their capacity for positive action, particularly when struggle outside
parliament is pressurising representatives to take some interest in public
concerns. The ruling class also needs a strong centralised state that can
protect its interests internally and externally and which can ignore both
popular demands and the vested interests of specific sections of the dominant
economic and social elites in order to pursue policies required to keep the
system as a whole going. This means that there will be a tendency for
Parliaments to give up its prerogatives, building up a centralised and
uncontrolled authority in the form of an empowered executive against which,
ironically, it had fought against at its birth.

This process can be seen clearly in the history of the United States. Since
World War II, power has become centralised in the hands of the president to
such an extent that some scholars now refer to an _"imperial presidency,"_
following Arthur Schlesinger's 1973 book of that title. In the UK, Prime
Minister Tony Blair has been repeatedly criticised for his _"presidential"_
form of government, while Parliament has been repeatedly side-tracked. This
builds on tendencies which flow back to, at least, the Thatcher government
which started the neo-liberal transformation of the UK with its associated
rise in inequality, social polarisation and increases in state centralisation
and authority.

Contemporary US presidents' appropriation of congressional authority,
especially in matters relating to national security, has paralleled the rise
of the United States as the world's strongest and most imperialistic military
power. In the increasingly dangerous and interdependent world of the 20th
century, the perceived need for a leader who can act quickly and decisively,
without possibly disastrous obstruction by Congress, has provided an impetus
for ever greater concentration of power in the White House. This concentration
has taken place in both foreign and domestic policy, but it has been catalysed
above all by a series of foreign policy decisions in which modern US
presidents have seized the most vital of all government powers, the power to
make war. For example, President Truman decided to commit troops in Korea
without prior congressional approval while the Eisenhower Administration
established a system of pacts and treaties with nations all over the globe,
making it difficult for Congress to limit the President's deployment of troops
according to the requirements of treaty obligations and national security,
both of which were left to presidential judgement. The CIA, a secretive agency
accountable to Congress only after the fact, was made the primary instrument
of US intervention in the internal affairs of other nations for national
security reasons. This process of executive control over war reached a peak
post-911, with Bush's nonsense of a _"pre-emptive"_ war and public
acknowledgement of a long standing US policy that the Commander-in-Chief was
authorised to take "defensive" war measures without congressional approval or
UN authorisation.

And as they have continued to commit troops to war without congressional
authorisation or genuine public debate, the President's unilateral policy-
making has spilled over into domestic affairs as well. Most obviously, thanks
to Bush I and Clinton, important economic treaties (like GATT and NAFTA) can
be rammed through Congress as _"fast-track"_ legislation, which limits the
time allowed for debate and forbids amendments. Thanks to Jimmy Carter, who
reformed the Senior Executive Service to give the White House more control
over career bureaucrats, and Ronald Reagan, who politicised the upper levels
of the executive branch to an unprecedented degree, presidents can now pack
government with their spoilsmen and reward partisan bureaucrats (the lack of
response by FEMA during the Katrina hurricane is an example of this). Thanks
to the first Bush, presidents now have a powerful new technique to enhance
presidential prerogatives and erode the intent of Congress even further --
namely, signing laws while announcing that they will not obey them. Fifth,
thanks also to Bush, yet another new instrument of arbitrary presidential
power has been created: the "tsar," a presidential appointee with vague,
sweeping charges that overlap with or supersede the powers of department
heads. [Michael Lind, _"The Case for Congressional Power: the Out-of-Control
Presidency,"_ **The New Republic**, Aug. 14, 1995]

Thus we find administrations bypassing or weakening official government
agencies or institutions to implement policies that are not officially
permitted. In the US, the Reagan Administration's Iran-Contra affair is an
example. During that episode the National Security Council, an arm of the
executive branch, secretly funded the Contras, a mercenary counter-
revolutionary force in Central America, in direct violation of the Boland
Amendment which Congress had passed for the specific purpose of prohibiting
such funding. Then there is the weakening of government agencies to the point
where they can no longer effectively carry out their mandate. Reagan's tenure
in the White House again provides a number of examples. The Environmental
Protection Agency, for instance, was for all practical purposes neutralised
when employees dedicated to genuine environmental protection were removed and
replaced with people loyal to corporate polluters. Such detours around the law
are deliberate policy tools that allow presidents to exercise much more actual
power than they appear to have on paper. Finally, the President's authority to
determine foreign and domestic policy through National Security Directives
that are kept secret from Congress and the American people. Such NSDs cover a
virtually unlimited field of actions, shaping policy that may be radically
different from what is stated publicly by the White House and involving such
matters as interference with First Amendment rights, initiation of activities
that could lead to war, escalation of military conflicts, and even the
commitment of billions of dollars in loan guarantees -- all without
congressional approval or even knowledge.

President Clinton's use of an Executive Order to bail out Mexico from its debt
crisis after Congress failed to appropriate the money falls right into the
authoritarian tradition of running the country by fiat, a process which
accelerated with his successor George Bush (in keeping with the general
tendencies of Republican administrations in particular). The second Bush took
this disdain for democracy and the law even further. His administration has
tried to roll back numerous basic liberties and rights as well. He has sought
to strip people accused of crimes of rights that date as far back as the Magna
Carta in Anglo-American jurisprudence: elimination of presumption of
innocence, keeping suspects in indefinite imprisonment, ending trial by
impartial jury, restricting access to lawyers and knowledge of evidence and
charges against the accused. He has regularly stated when signing legislation
that he will assert the right to ignore those parts of laws with which he
disagrees. His administration has adopted policies which have ignored the
Geneva Convention (labelled as _"quaint"_) and publicly tolerated torture of
suspects and prisoners of war. That this underlying authoritarianism of
politicians is often belied by their words should go without saying (an
obvious fact, somehow missed by the mainstream media, which made satire
redundant in the case the second Bush).

Not that this centralisation of powers has bothered the representatives whom
are being disempowered by it. Quite the reverse. This is unsurprising, for
under a leader which _"guarantees 'order' -- that is to say internal
exploitation and external expansion -- than the parliament submits to all his
caprices and arms him with ever new powers . . . That is understandable: all
government has tendency to become personal since that is its origin and its
essence . . . it will always search for the man on whom it can unload the
cares of government and to whom in turn it will submit. As long as we confide
to a small group all the economic, political, military, financial and
industrial prerogatives with which we arm them today, this small group will
necessarily be inclined . . . to submit to a single chief."_ [Kropotkin, **Op.
Cit.**, p. 128] As such, there are institutional forces at work within the
government organisational structure which encourage these tendencies and as
long as they find favour with business interests they will not be challenged.

This is a key factor, of course. If increased authoritarianism and
concentration of decision making were actually harming the interests of the
economically dominant elite then more concern would be expressed about them in
what passes for public discourse. However, the reduction of democratic
processes fits in well with the neo-liberal agenda (and, indeed, this agenda
dependent on it). As Chomsky notes, _"democracy reduces to empty form"_ when
the votes of the general public votes no impact or role in determining
economic and social development. In other words, _"neoliberal reforms are
antithetical to promotion of democracy. They are not designed to shrink the
state, as often asserted, but to strengthen state institutions to serve even
more than before the needs of the substantial people."_ This has seen
_"extensive gerrymandering to prevent competition for seats in the House, the
most democratic of government institutions and therefore the most worrisome,"_
while congress has been _"geared to implementing the pro-business policies"_
and the White House has been reconstructed into top-down systems, in a similar
way to that of a corporation (_"In structure, the political counterpart to a
corporation is a totalitarian state."_) [**Op. Cit.**, p. 218, p. 237 and p.
238]

The aim is to exclude the general politic from civil society, creating Locke's
system of rule by property owners only. As one expert (and critic) on Locke
argues in his scheme, the _"labouring class, being without estate, are subject
to, but not full members of civil society"_ and the _"right to rule (more
accurately, the right to control any government) is given to men of estate
only."_ The working class will be in but not part of civil society in the same
way that they are in but not part of a company. The labouring class may do the
actual work in a capitalist firm, but they _"cannot take part in the operation
of the company at the same level as the owners."_ Thus the ideal (classical)
"liberal" state is a _"joint-stock company of owners whose majority decision
binds not only themselves but also their employees."_ [C. B. MacPherson, **The
Political Theory of Possessive Individualism**, p. 248, p. 249 and p. 251] The
aim of significant sections of the right and the ruling class is to achieve
this goal within the context of a nominally democratic state which, on paper,
allows significant civil liberties but which, in practice, operates like a
corporation. Liberty for the many will be reduced to market forms, the ability
to buy and sell, within the rules designed by and for the property owners.
Centralised state power within an overall authoritarian social culture is the
best way to achieve this aim.

It should be stressed that the rise of inequality and centralised state power
has came about by design, not by accident. Both trends delight the rich and
the right, whose aim has always been to exclude the general population from
the public sphere, eliminate taxation on wealth and income derived from owning
it and roll back the limited reforms the general population have won over the
years. In his book **Post-Conservative America** Kevin Phillips, one of the
most knowledgeable and serious conservative ideologues, discusses the
possibility of fundamental alterations that he regards as desirable in the US
government. His proposals leave no doubt about the direction in which the
Right wishes to proceed. _"Governmental power is too diffused to make
difficult and necessary economic and technical decisions,"_ Phillips
maintains. _"[A]ccordingly, the nature of that power must be re-thought. Power
at the federal level must be augmented, and lodged for the most part in the
executive branch."_ [p. 218] He assures us that all the changes he envisions
can be accomplished without altering the Constitution.

As one moderate British Conservative MP has documented, the "free-market"
Conservative Thatcher government of the 1980s increased centralisation of
power and led a sustained _"assault on local government."_ One key reason was
_"dislike of opposition"_ which applied to _"intermediate institutions"_
between the individual and the state. These _"were despised and disliked
because they got in the way of 'free-market forces' . . . and were liable to
disagree with Thatcherite policies."_ Indeed, they simply abolished elected
local governments (like the Greater London Council) which were opposed to the
policies of the central government. They controlled the rest by removing their
power to raise their own funds, which destroyed their local autonomy. The net
effect of neo-liberal reforms was that Britain became _"ever more
centralised"_ and local government was _"fragmenting and weakening."_
[**Dancing with Dogma**, p. 261, p. 262 and p. 269]

This reversal of what, traditionally, conservatives and even liberals had
argued had its roots in the "free market" capitalist ideology. For _"[n]othing
is to stand in the way of the free market, and no such fripperies as
democratic votes are to be allowed to upset it. The unadulterated free market
is unalterable, and those who dislike it or suffer from it must learn to put
up with it. In Rousseau's language, they must be forced to be free."_ as such
there was _"no paradox"_ to the _"Thatcherite devotion to both the free market
and a strong state"_ as the _"establishment of individualism and a free-market
state is an unbending if not dictatorial venture which demands the prevention
of collective action and the submission of dissenting institutions and
individuals."_ Thus rhetoric about "liberty" and rolling back the state can
easily be _"combined in practice with centralisation and the expansion of the
state's frontiers."_ [**Op. Cit.**, pp. 273-4 and p. 273] A similar process
occurred under Reagan in America.

As Chomsky stresses, the _"antidemocratic thrust has precedents, of course,
but is reaching new heights"_ under the current set of _"reactionary
statists"_ who _"are dedicated warriors. With consistency and passion that
approach caricature, their policies serve the serve the substantial people --
in fact, an unusually narrow sector of them -- and disregard or harm the
underlying population and future generations. They are also seeking to use
their current opportunities to institutionalise these arrangements, so that it
will be no small task to reconstruct a more humane and democratic society."_
[**Op. Cit.**, p. 238 and p. 236] As we noted in [section D.1](secD1.md),
the likes of Reagan, Thatcher and Bush do not appear by accident. They and the
policies they implement reflect the interests of significant sectors of the
ruling elite and their desires. These will not disappear if different, more
progressive sounding, politicians are elected. Nor will the nature of the
state machine and its bureaucracy, nor will the workings and needs of the
capitalist economy.

This helps explains why the distinctions between the two major parties in the
US have been, to a large extent, virtually obliterated. Each is controlled by
the corporate elite, albeit by different factions within it. Despite many
tactical and verbal disagreements, virtually all members of this elite share a
basic set of principles, attitudes, ideals, and values. Whether Democrat or
Republican, most of them have graduated from the same Ivy League schools,
belong to the same exclusive social clubs, serve on the same interlocking
boards of directors of the same major corporations, and send their children to
the same private boarding schools (see G. William Domhoff, **Who Rules America
Now?** and C. Wright Mills, **The Power Elite**). Perhaps most importantly,
they share the same psychology, which means that they have the same priorities
and interests: namely, those of corporate America. That the Democrats are
somewhat more dependent and responsive to progressive working class people
while the Republicans are beholden to the rich and sections of the religious
right come election time should not make us confuse rhetoric with the reality
of policies pursued and underlying common assumptions and interests.

This means that in the USA there is really only one party -- the Business
Party -- which wears two different masks to hide its real face from the
public. Similar remarks apply to the liberal democratic regimes in the rest of
the advanced capitalist states. In the UK, Blair's "New Labour" has taken over
the mantle of Thatcherism and have implemented policies based on its
assumptions. Unsurprisingly, it received the backing of numerous right-wing
newspapers as well as funding from wealthy individuals. In other words, the UK
system has mutated into a more US style one of two Business parties one of
which gets more trade union support than the other (needless to say, it is
unlikely that Labour will be changing its name to "Capital" unless forced to
by the trading standards office nor does it look likely that the trade union
bureaucracy will reconsider their funding in spite of the fact New Labour
simply ignored them when not actually attacking them!). The absence of a true
opposition party, which itself is a main characteristic of authoritarian
regimes, is thus an accomplished fact already, and has been so for many years.

Besides the reasons noted above, another cause of increasing political
centralisation under capitalism is that industrialisation forces masses of
people into alienated wage slavery, breaking their bonds to other people, to
the land, and to tradition, which in turn encourages strong central
governments to assume the role of surrogate parent and to provide direction
for their citizens in political, intellectual, moral, and even spiritual
matters. (see Hannah Arendt, **The Origins of Totalitarianism**). And as
Marilyn French emphasises in **Beyond Power**, the growing concentration of
political power in the capitalist state can also be attributed to the form of
the corporation, which is a microcosm of the authoritarian state, since it is
based on centralised authority, bureaucratic hierarchy, antidemocratic
controls, and lack of individual initiative and autonomy. Thus the millions of
people who work for large corporations tend automatically to develop the
psychological traits needed to survive and "succeed" under authoritarian rule:
notably, obedience, conformity, efficiency, subservience, and fear of
responsibility. The political system naturally tends to reflect the
psychological conditions created at the workplace, where most people spend
about half their time.

Reviewing such trends, Marxist Ralph Miliband concludes that _"it points in
the direction of a regime in which democratic forms have ceased to provide
effective constraints upon state power."_ The _"distribution of power"_ will
become _"more unequal"_ and so _"[h]owever strident the rhetoric of democracy
and popular sovereignty may be, and despite the 'populist' overtones which
politics must now incorporate, the trend is toward the ever-greater
appropriation of power at the top."_ [**Divided Societies**, p. 166 and p.
204] As such, this reduction in genuine liberty, democracy and growth in
executive power does not flow simply from the intentions of a few bad apples.
Rather, they reflect economic developments, the needs of the system as a whole
plus the pressures associated with the way specific institutions are
structured and operate as well as the need to exclude, control and marginalise
the general population. Thus while we can struggle and resist specific
manifestations of this process, we need to fight and eliminate their root
causes within capitalism and statism themselves if we want to turn them back
and, eventually, end them.

This increase in centralised and authoritarian rule may not result in obvious
elimination of such basic rights as freedom of speech. However, this is due to
the success of the project to reduce genuine freedom and democracy rather than
its failure. If the general population are successfully marginalised and
excluded from the public sphere (i.e. turned into Locke's system of being
within but not part of a society) then a legal framework which recognises
civil liberties would still be maintained. That most basic liberties would
remain relatively intact and that most radicals will remain unmolested would
be a testimony to the lack of power possessed by the public at large in the
existing system. That is, countercultural movements need not be a concern to
the government until they become broader-based and capable of challenging the
existing socio-economic order -- only then is it "necessary" for the
repressive, authoritarian forces to work on undermining the movement. So long
as there is no effective organising and no threat to the interests of the
ruling elite, people are permitted to say whatever they want. This creates the
illusion that the system is open to all ideas, when, in fact, it is not. But,
as the decimation of the Wobblies and anarchist movement after the First World
War first illustrated, the government will seek to eradicate any movement that
poses a significant threat.

## D.9.1 What is the relationship between wealth polarisation and
authoritarian government?

We have previously noted the recent increase in the rate of wealth
polarisation, with its erosion of working-class living standards (see [section
B.7](secB7.md)). This process has been referred to by Noam Chomsky as
"Third-Worldisation." It is appearing in a particularly acute form in the US
-- the "richest" industrialised nation which also has the highest level of
poverty, since it is the most polarised -- but the process can be seen in
other "advanced" industrial nations as well, particularly in the UK. As neo-
liberalism has spread, so has inequality soared.

Third World governments are typically authoritarian, since harsh measures are
required to suppress rebellions among their impoverished and discontented
masses. Hence "Third-Worldisation" implies not only economic polarisation but
also increasingly authoritarian governments. As Philip Slater puts it, a
large, educated, and alert "middle class" (i.e. average income earners) has
always been the backbone of democracy, and anything that concentrates wealth
tends to weaken democratic institutions. [**A Dream Deferred**, p. 68] This
analysis is echoed by left-liberal economist James K. Galbraith:



> _"As polarisation of wages, incomes and wealth develops, the common
interests and common social programs of society fall into decline. We have
seen this too, in this country over thirty years, beginning with the erosion
of public services and public investments, particularly in the cities, with
the assault on the poor and on immigrants and the disabled that led to the
welfare bill of 1996, and continuing now manufactured crises of Medicare and
the social security system. The haves are on the march. With growing
inequality, so grows their power. And so also diminish the voices of
solidarity and mutual reinforcement, the voices of civil society, the voices
of a democratic and egalitarian middle class."_ [**Created Unequal: The Crisis
in American Pay**, p. 265]



If this is true, then along with increasing wealth polarisation in the US we
should expect to see signs of growing authoritarianism. This hypothesis is
confirmed by numerous facts, including the following: continuing growth of an
_"imperial presidency"_ (concentration of political power); extralegal
operations by the executive branch (e.g. the Iran-Contra scandal, the Grenada
and Panama invasions); skyrocketing incarceration rates; more official secrecy
and censorship; the rise of the Far Right; more police and prisons; FBI
requests for massive wiretapping capability; and so on. Public support for
draconian measures to deal with crime reflect the increasingly authoritarian
mood of citizens beginning to panic in the face of an ongoing social
breakdown, which has been brought about, quite simply, by ruling-class greed
that has gotten out of hand -- a fact that is carefully obscured by the media.
The 911 attacks have been used to bolster these authoritarian trends, as would
be expected.

One might think that representative democracy and constitutionally guaranteed
freedoms would make an authoritarian government impossible in the United
States and other liberal democratic nations with similar constitutional
"protections" for civil rights. In reality, however, the declaration of a
"national emergency" would allow the central government to ignore
constitutional guarantees with impunity and set up what Hannah Arendt calls
_"invisible government"_ \-- mechanisms allowing an administration to
circumvent constitutional structures while leaving them nominally in place.
The erosion of civil liberties and increase in state powers post-911 in both
the US and UK should show that such concerns are extremely valid.

In response to social breakdown or "terrorism," voters may turn to martial-
style leaders (aided by the media). Once elected, and with the support of
willing legislatures and courts, administrations could easily create much more
extensive mechanisms of authoritarian government than already exist, giving
the executive branch virtually dictatorial powers. Such administrations could
escalate foreign militarism, further expand the funding and scope of the
police, national guard units, secret police and foreign intelligence agencies,
and authorise more widespread surveillance of citizens as well as the
infiltration of dissident political groups (all of which happened in post-911
America). There would be a corresponding rise of government secrecy (as
_"popular understanding of the workings of government is not conducive to
instilling proper reverence for powerful leaders and their nobility."_
[Chomsky, **Failed States**, p.238]). These developments would not occur all
at once, but so gradually, imperceptibly, and logically -- given the need to
maintain "law and order" -- that most people would not even be aware that an
authoritarian take-over was underway. Indeed, there is substantial evidence
that this is already underway in the US (see **Friendly Fascism** by Bertram
Gross for details).

We will examine some of the symptoms of growing authoritarianism listed above,
again referring primarily to the example of the United States. The general
trend has been a hollowing out of even the limited democratic structures
associated with representative states in favour of a purely formal appearance
of elections which are used to justify ignoring the popular will,
authoritarianism and "top-down" rule by the executive. While these have always
been a feature of the state (and must be, if it is to do its function as we
discussed in [section B.2](secB2.md)) the tendencies are increasing and
should be of concern for all those who seek to protect, never mind, expand
what human rights and civil liberties we have. While anarchists have no
illusions about the nature of even so-called democratic states, we are not
indifferent to the form of state we have to endure and how it changes. As
Malatesta put it:

> _"there is no doubt that the worst of democracies is always preferable, if
only from an educational point of view, than the best of dictatorships. Of
course democracy, so-called government of the people, is a lie; but the lie
always slightly binds the liar and limits the extent of his arbitrary power .
. . Democracy is a lie, it is oppression and is in reality, oligarchy; that
is, government by the few to the advantage of a privileged class. But we can
still fight it in the name of freedom and equality, unlike those who have
replaced it or want to replace it with something worse."_ [**The Anarchist
Revolution**, p. 77]

We must stress that as long as governments exist, then this struggle against
authoritarianism will continue. As Kropotkin argued, these tendencies _"do not
depend on individuals; they are inherent in the institution."_ We must always
remember that _"[o]f its own accord, representative government does not offer
real liberties, and it can accommodate itself remarkably well to despotism.
Freedoms have to be seized from it, as much as they do from absolute kings;
and once they have been gained they must be defended against parliament as
much as they were against a king."_ [**Words of a Rebel**, p. 137 and p. 123]

So we cannot assume that legal rights against and restrictions on state or
economic power are enough in themselves. Liberty needs to be continually
defended by the mass of the population who cannot leave it to others to act
for them. _"If we want . . . to leave the gates wide open to reaction,"_
Kropotkin put it, _"we have only to confide our affairs to a representative
government."_ Only _"extra-parliamentary agitation"_ will stop the state
_"imping[ing] continually on the country's political rights"_ or
_"suppress[ing] them with a strike of the pen."_ The state must always _"find
itself faced by a mass of people ready to rebel."_ [**Op. Cit.** p. 129 and p.
124]

## D.9.2 Why is government surveillance of citizens on the increase?

Authoritarian governments are characterised by fully developed secret police
forces, extensive government surveillance of civilians, a high level of
official secrecy and censorship, and an elaborate system of state coercion to
intimidate and silence dissenters. All of these phenomena have existed in the
US since suppression of the anarchist inspired No-Conscription League and the
IWW for its unionising and anti-war activity. The post-World War I Red Scare
and Palmer raids continued this process of wartime jailings and intimidation,
combined with the deportation of aliens (the arrest, trial and subsequent
deportation of Alexander Berkman and Emma Goldman is but one example of this
war on radicals). [Howard Zinn, **A People's History of America**, pp. 363-7]

However, since World War II these systems have taken more extreme forms,
especially during the 1980s and 2000s. Indeed, one of the most disturbing
revelations to emerge from the Iran-Contra affair was the Reagan
administration's contingency plan for imposing martial law. Alfonso Chardy, a
reporter for the Miami Herald, revealed in July 1987 that Lt. Col. Oliver
North, while serving on the National Security Council's staff, had worked with
the Federal Emergency Management Agency on a plan to suspend the Bill of
Rights by imposing martial law in the event of _"national opposition to a US
military invasion abroad."_ [Richard O. Curry (ed.), **Freedom at Risk:
Secrecy, Censorship, and Repression in the 1980s**] However, this rise in
authoritarian-style government policies is not limited to just possibilities
and so in this section we will examine the operations of the secret police in
the USA since the 1950s. First, however, we must stress that these tendencies
are hardly US specific. For example, the secret services in the UK have
regularly spied on left-wing groups as well as being heavily involved in
undermining the 1984-5 Miners strike. [S. Milne, **The Enemy Within**]

The creation of an elaborate US "national security" apparatus has come about
gradually since 1945 through congressional enactments, numerous executive
orders and national security directives, and a series of Supreme Court
decisions that have eroded First Amendment rights. The policies of the Reagan
administration, however, reflected radical departures from the past, as
revealed not only by their comprehensive scope but by their
institutionalisation of secrecy, censorship, and repression in ways that will
be difficult, if not impossible, to eradicate. As Richard Curry points out,
the Reagan administration's success stems _"from major structural and
technological changes that have occurred in American society during the
twentieth century -- especially the emergence of the modern bureaucratic State
and the invention of sophisticated electronic devices that make surveillance
possible in new and insidious ways."_ [**Op. Cit.**, p. 4]

The FBI has used _"countersubversive"_ surveillance techniques and kept lists
of people and groups judged to be potential national security threats since
the days of the Red Scare in the 1920s. Such activities were expanded in the
late 1930s when Franklin Roosevelt instructed the FBI to gather information
about Fascist and Communist activities in the US and to conduct investigations
into possible espionage and sabotage (although for most of the 1920s and
1930s, fascists and fascist sympathisers were, at best, ignored and, at worse,
publicly praised while anti-fascists like anarchist Carol Tresca were spied on
and harassed by the authorities. [Nunzio Pernicone, **Carlo Tresca**]). FBI
chief J. Edgar Hoover interpreted these directives as authorising open-ended
inquiries into a very broad category of potential "subversives"; and by
repeatedly misinforming a succession of careless or indifferent presidents and
attorneys general about the precise scope of Roosevelt's directives, Hoover
managed for more than 30 years to elicit tacit executive approval for
continuous FBI investigations into an ever-expanding class of political
dissidents. [Geoffrey R. Stone, _"The Reagan Administration, the First
Amendment, and FBI Domestic Security Investigations,"_ Curry (ed.), **Op.
Cit.**]

The advent of the Cold War, ongoing conflicts with the Soviet Union, and fears
of the "international Communist conspiracy" provided justification not only
for covert CIA operations and American military intervention in countries all
over the globe, but also contributed to the FBI's rationale for expanding its
domestic surveillance activities. Thus in 1957, without authorisation from
Congress or any president, Hoover launched a highly secret operation called
COINTELPRO:

> _"From 1957 to 1974, the bureau opened investigative files on more than half
a million 'subversive' Americans. In the course of these investigations, the
bureau, in the name of 'national security,' engaged in widespread wire-
tapping, bugging, mail-openings, and break-ins. Even more insidious was the
bureau's extensive use of informers and undercover operative to infiltrate and
report on the activities and membership of 'subversive' political associations
ranging from the Socialist Workers Party to the NAACP to the Medical Committee
for Human Rights to a Milwaukee Boy Scout troop."_ [Stone, **Op. Cit.**, p.
274]

But COINTELPRO involved much more than just investigation and surveillance. As
Chomsky notes, it was _"one of its major programs of repression"_ and was used
to discredit, weaken, and ultimately destroy the New Left and Black radical
movements of the sixties and early seventies, i.e. to silence the major
sources of political dissent and opposition. It's aim was to _"disrupt"_ a
wide range of popular movements _"by instigating violence in the ghetto,
direct participation in police assassination of a Black Panther organiser,
burglaries and harassment of the Socialist Workers Party over many years, and
other methods of defamation and disruption."_ [**Necessary Illusions**, p.
189]

The FBI fomented violence through the use of agents provocateurs and destroyed
the credibility of movement leaders by framing them, bringing false charges
against them, distributing offensive materials published in their name,
spreading false rumours, sabotaging equipment, stealing money, and other dirty
tricks. By such means the Bureau exacerbated internal frictions within
movements, turning members against each other as well as other groups. For
example, during the civil rights movement, while the government was making
concessions and verbally supporting the movement, the FBI was harassing and
breaking up black groups. Between 1956 and 1971, the FBI took 295 actions
against black groups as part of COLINTELPRO. [Zinn, **Op. Cit.**, p. 455]

Government documents show the FBI and police involved in creating acrimonious
disputes which ultimately led to the break-up of such groups as Students for a
Democratic Society, the Black Panther Party, and the Liberation News Service.
The Bureau also played a part in the failure of such groups to form alliances
across racial, class, and regional lines. The FBI is implicated in the
assassination of Malcolm X, who was killed in a "factional dispute" that the
Bureau bragged of having "developed" in the Nation of Islam. Martin Luther
King, Jr., was the target of an elaborate FBI plot to drive him to suicide
before he was conveniently killed by a lone sniper. Other radicals were
portrayed as "Communists", criminals, adulterers, or government agents, while
still others were murdered in phoney "shoot-outs" where the only shooting was
done by the police.

These activities finally came to public attention because of the Watergate
investigations, congressional hearings, and information obtained under the
Freedom of Information Act (FOIA). In response to the revelations of FBI
abuse, Attorney General Edward Levi in 1976 set forth a set of public
guidelines governing the initiation and scope of the bureau's domestic
security investigations, severely restricting its ability to investigate
political dissidents.

The Levi guidelines, however, proved to be only a temporary reversal of the
trend. Although throughout his presidency Ronald Reagan professed to be
against the increase of state power in regard to domestic policy, he in fact
expanded the power of the national bureaucracy for "national security"
purposes in systematic and unprecedented ways. One of the most significant of
these was his immediate elimination of the safeguards against FBI abuse that
the Levi guidelines had been designed to prevent. This was accomplished
through two interrelated executive branch initiatives: Executive Order 12333,
issued in 1981, and Attorney General William French Smith's guidelines, which
replaced Levi's in 1983. The Smith guidelines permitted the FBI to launch
domestic security investigations if the facts _"reasonably indicated"_ that
groups or individuals were involved in criminal activity. More importantly,
however, the new guidelines also authorised the FBI to _"anticipate or prevent
crime."_ As a result, the FBI could now investigate groups or individuals
whose statements _"advocated"_ criminal activity or indicated an **apparent
intent** to engage in crime, particularly crimes of violence.

As Curry notes, the language of the Smith guidelines provided FBI officials
with sufficient interpretative latitude to investigate virtually any group or
individual it chose to target, including political activists who opposed the
administration's foreign policy. Not surprisingly, under the new guidelines
the Bureau immediately began investigating a wide variety of political
dissidents, quickly making up for the time it had lost since 1976.
Congressional sources show that in 1985 alone the FBI conducted 96
investigations of groups and individuals opposed to the Reagan
Administration's Central American policies, including religious organisations
who expressed solidarity with Central American refugees.

Since the 1980s, the state has used the threat of "terrorism" (both domestic
and international) to bolster its means of repression. The aim has been to
allow the President, on his own initiative and by his own definition, to
declare any person or organisation "terrorist" and so eliminate any rights
they may, in theory, have. The 911 attacks were used to pass in effect a
"wish-list" (in the form of the PATRIOT act) of measures long sought by both
the secret state and the right but which they had difficulty in passing
previously due to public scrutiny. Post-911, as after the Oklahoma bombing,
much opposition was muted while those that did raise their voices were
dismissed as, at best, naive or, at worse, pro-terrorist.

Post-911, presidential rulings are considered as conclusive while the Attorney
General was handed new enforcement powers, e.g. suspects would be considered
guilty unless proven innocent, and the source or nature of the evidence
brought against suspects would not have to be revealed if the Justice
Department claimed a _"national security"_ interest in suppressing such facts,
as of course it would. Security agencies were given massive new powers to
gather information on and act against suspected "terrorists" (i.e., any enemy
of the state, dissident or critic of capitalism). As intended, the ability to
abuse these powers is staggering. They greatly increased the size and funding
of the FBI and gave it the power to engage in "anti-terrorist" activities all
over the country, without judicial oversight. Unsurprisingly, during the run-
up to the Iraq invasion of 2003, the anti-war movement was targeted with these
new powers of surveillance. That the secret state, for example, seriously
argued that potential "terrorists" could exist within Quaker peace groups says
it all. Unsurprisingly, given the history of the secret state the new measures
were turned against the Left, as COINTELPRO and similar laws were in the past.

If, as the Bush Administration continually asserted, the terrorists hate the
west for our freedoms (rather than their self-proclaimed hatred of US foreign
policy) then that government is the greatest appeaser the world has ever seen
(not to mention the greatest recruiting agent they ever had). It has done more
to undermine freedom and increase state power (along with the threat of
terrorism) that the terrorists ever dreamed. However, it would be a mistake to
draw the conclusion that it is simply incompetence, arrogance and ignorance
which was at work (tempting as that may be). Rather, there are institutional
factors at work as well (a fact that becomes obvious when looking at the
history of the secret state and its activities). The fact that such draconian
measures were even considered says volumes about the direction in which the US
-- and by implication the other "advanced" capitalist states -- are headed.

## D.9.3 What causes justifications for racism to appear?

The tendency toward social breakdown which is inherent in the growth of wealth
polarisation, as discussed above, is also producing a growth in racism in the
countries affected. As we have seen, social breakdown leads to the
increasingly authoritarian government prompted by the need of the ruling class
to contain protest and civil unrest among those at the bottom of the wealth
pyramid. In the US those in the lowest economic strata belong mostly to racial
minorities, while in several European countries there are growing populations
of impoverished minorities from the Third World, often from former colonies.
The desire of the more affluent strata to justify their superior economic
positions is, as one would expect, causing racially based theories of
privilege to become more popular.

That racist feelings are gaining strength in America is evidenced by the
increasing political influence of the right, whose thinly disguised racism
reflects the darkening vision of a growing segment of the conservative
community. Further evidence can be seen in the growth of ultraconservative
extremist groups preaching avowedly racist philosophies, such as the Ku Klux
Klan, the Aryan Nations, the White Aryan Resistance, and others (see James
Ridgeway's **Blood in the Face: The Ku Klux Klan, Aryan Nations, Nazi
Skinheads, and the Rise of a New White Culture**). Much the same can be said
of Europe, with the growth of parties like the BNP in Britain, the FN in
France and similar organisations elsewhere.

Most conservative politicians have taken pains to distance themselves
officially from the extreme right. Yet they are dependent on getting votes of
those influenced by the right-wing media personalities and the extreme right.
This means that this racism cannot help seep into their election campaigns
and, unsurprisingly, mainstream conservative politicians have used, and
continue to use, code words and innuendo ("welfare queens," "quotas," etc.) to
convey a thinly veiled racist message. This allows mainstream right-wingers to
exploit the budding racism of lower- and middle-class white youths, who must
compete for increasingly scarce jobs with desperate minorities who are willing
to work at very low wages. As Lorenzo Lom'boa Ervin notes:

> _"Basing themselves on alienated white social forces, the Nazis and Klan are
trying to build a mass movement which can hire itself out to the Capitalists
at the proper moment and assume state power . . . Fascism is the ultimate
authoritarian society when in power, even though it has changed its face to a
mixture of crude racism and smoother racism in the modern democratic state.  
>  _

>

> _"So in addition to the Nazis and the Klan, there are other Right-Wing
forces that have been on the rise . . . They include ultra-conservative
rightist politicians and Christian fundamentalist preachers, along with the
extreme right section of the Capitalist ruling class itself, small business
owners, talk show hosts . . . along with the professors, economists,
philosophers and others in academia who are providing the ideological weapons
for the Capitalist offensive against the workers and oppresses people. So not
all racists wear sheets. These are the 'respectable' racists, the New Right
conservatives . . . The Capitalist class has already shown their willingness
to use this conservative movement as a smoke screen for an attack on the Labor
movement, Black struggle, and the entire working class."_ [**Anarchism and the
Black Revolution**, p. 18]

The expanding popularity of such racist groups in the US is matched by a
similar phenomenon in Europe, where xenophobia and a weak economy have
propelled extreme right-wing politicians into the limelight on promises to
deport foreigners. This poisons the whole mainstream political spectrum, with
centre and centre-left politicians pandering to racism and introducing aspects
of the right's agenda under the rhetoric of "addressing concerns" and raising
the prospect that by not doing what the right wants, the right will expand in
influence. How legitimising the right by implementing its ideas is meant to
undercut their support is never explained, but the "greater evil" argument
does have its utility for every opportunistic politician (particularly one
under pressure from the right-wing media whipping up scare stories about
immigration and such like to advance the interests of their wealthy backers).

What easier way is there to divert people's anger than onto scapegoats? Anger
about bad housing, no housing, boring work, no work, bad wages and conditions,
job insecurity, no future, and so on. Instead of attacking the real causes of
these (and other) problems, people are encouraged to direct their anger
against people who face the same problems just because they have a different
skin colour or come from a different part of the world! Little wonder
politicians and their rich backers like to play the racist card -- it diverts
attention away from them and the system they run (i.e. the **real** causes of
our problems).

Racism, in other words, tries to turn **class** issues into "race" issues.
Little wonder that sections of the ruling elite will turn to it, as and when
required. Their class interests (and, often, their personal bigotry) requires
them to do so -- a divided working class will never challenge their position
in society. This means that justifications for racism appear for two reasons.
Firstly, to try and justify the existing inequalities within society (for
example, the infamous -- and highly inaccurate -- _"Bell Curve"_ and related
works). Secondly, to divide the working class and divert anger about living
conditions and social problems away from the ruling elite and their system
onto scapegoats in our own class. After all, _"for the past fifty years
American business has been organising a major class war, and they needed
troops -- there **are** votes after all, and you can't just come before the
electorate and say, 'Vote for me, I'm trying to screw you.' So what they've
had to do is appeal to the population on some other grounds. Well, there
aren't a lot of other grounds, and everybody picks the same ones . . . --
jingoism, racism, fear, religious fundamentalism: These are ways of appealing
to people if you're trying to organise a mass base of support for policies
that are really intended to crush them."_ [Chomsky, **Understanding Power**,
pp. 294-5]

Part of the right-wing resurgence in the US and elsewhere has been the
institutionalisation of the Reagan-Bush brand of conservatism, whose hallmark
was the reinstatement, to some degree, of laissez-faire economic policies
(and, to an even larger degree, of laissez-faire rhetoric). A "free market,"
Reagan's economic "experts" argued, necessarily produced inequality; but by
allowing unhindered market forces to select the economically fittest and to
weed out the unfit, the economy would become healthy again. The wealth of
those who survived and prospered in the harsh new climate would ultimately
benefit the less fortunate, through a "trickle-down" effect which was supposed
to create millions of new high-paying jobs.

All this would be accomplished by deregulating business, reducing taxes on the
wealthy, and dismantling or drastically cutting back federal programmes
designed to promote social equality, fairness, and compassion. The aptly named
Laffer Curve (although invented without the burden of any empirical research
or evidence) alleged to illustrate how cutting taxes actually **raises**
government revenue. When this program of pro-business policies was applied the
results were, unsurprisingly, the opposite of that proclaimed, with wealth
flooding upwards and the creation of low-paying, dead-end jobs (the biggest
"Laffers" in this scenario were the ruling class, who saw unprecedented gains
in wealth at the expense of the rest of us).

The Reaganites' doctrine of inequality gave the official seal of approval to
ideas of racial superiority that right-wing extremists had used for years to
rationalise the exploitation of minorities. If, on average, blacks and
Hispanics earn only about half as much as whites; if more than a third of all
blacks and a quarter of all Hispanics lived below the poverty line; if the
economic gap between whites and non-whites was growing -- well, that just
proved that there was a racial component in the Social-Darwinian selection
process, showing that minorities "deserved" their poverty and lower social
status because they were "less fit." By focusing on individuals, laissez-faire
economics hides the social roots of inequality and the effect that economic
institutions and social attitudes have on inequality. In the words of left-
liberal economist James K. Galbraith:

> _"What the economists did, in effect, was to reason backward, from the
troublesome effect to a cause that would rationalise and justify it . . . [I]t
is the work of the efficient market [they argued], and the fundamental
legitimacy of the outcome is not supposed to be questioned.  
>  _

>

> _"The **apologia** is a dreadful thing. It has distorted our understanding,
twisted our perspective, and crabbed our politics. On the right, as one might
expect, the winners on the expanded scale of wealth and incomes are given a
reason for self-satisfaction and an excuse for gloating. Their gains are due
to personal merit, the application of high intelligence, and the smiles of
fortune. Those on the loosing side are guilty of sloth, self-indulgence, and
whining. Perhaps they have bad culture. Or perhaps they have bad genes. While
no serious economist would make that last leap into racist fantasy, the
underlying structure of the economists' argument has undoubtedly helped to
legitimise, before a larger public, those who promote such ideas."_ [**Op.
Cit.**, p. 264]

The logical corollary of this social Darwinism is that whites who are "less
fit" (i.e., poor) also deserve their poverty. But philosophies of racial
hatred are not necessarily consistent. Thus the ranks of white supremacist
organisations have been swollen in recent years by undereducated and
underemployed white youths frustrated by a declining industrial labour market
and a noticeably eroding social status. [Ridgeway, **Op. Cit.**, p.186] Rather
than drawing the logical Social-Darwinian conclusion -- that they, too, are
"inferior" -- they have instead blamed blacks, Hispanics, Asians, and Jews for
"unfairly" taking their jobs. Thus the neo-Nazi skinheads, for example, have
been mostly recruited from disgruntled working-class whites below the age of
30. This has provided leaders of right-wing extremist groups with a growing
base of potential storm troopers.

Therefore, laissez-faire ideology helps create a social environment in which
racist tendencies can increase. Firstly, it does so by increasing poverty, job
insecurity, inequality and so on which right-wing groups can use to gather
support by creating scapegoats in our own class to blame (for example, by
blaming poverty on blacks "taking our jobs" rather than capitalists moving
their capital to other, more profitable, countries or them cutting wages and
conditions for **all** workers -- and as we point out in [section
B.1.4](secB1.md#secb14), racism, by dividing the working class, makes
poverty and inequality **worse** and so is self-defeating). Secondly, it abets
racists by legitimising the notions that inequalities in pay and wealth are
due to racial differences rather than a hierarchical system which harms
**all** working class people (and uses racism to divide, and so weaken, the
oppressed). By pointing to individuals rather than to institutions,
organisations, customs, history and above all power -- the relative power
between workers and capitalists, citizens and the state, the market power of
big business, etc. -- laissez-faire ideology points analysis into a dead-end
as well as apologetics for the wealthy, apologetics which can be, and are,
utilised by racists to justify their evil politics.

[‹ D.8 What causes militarism and what are its effects?](secD8.md "Go to
previous page" ) [up](secDcon.md "Go to parent page" ) [D.10 How does
capitalism affect technology? ›](secD10.md "Go to next page" )

