/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.internal.tools.build;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.ArrayList;
import org.aspectj.internal.tools.build.HTMLSamplesRenderer;
import org.aspectj.internal.tools.build.Sample;
import org.aspectj.internal.tools.build.Samples;

public class SampleGatherer {
    public static final String EOL = "\n";
    static final String START = "START-SAMPLE";
    static final String END = "END-SAMPLE";
    static final String AUTHOR = "@author";
    static final String FLAG = "XXX";

    public static void main(String[] args) throws IOException {
        if (null == args || 0 == args.length) {
            String cname = SampleGatherer.class.getName();
            System.err.println("java " + cname + " [dir|file]");
            return;
        }
        Samples result = new Samples();
        for (int i = 0; i < args.length; ++i) {
            result = SampleGatherer.gather(new File(args[i]), result);
        }
        StringBuffer sb = HTMLSamplesRenderer.ME.render(result, null);
        File out = new File("../docs/dist/doc/sample-code.html");
        FileOutputStream fos = new FileOutputStream(out);
        fos.write(sb.toString().getBytes());
        fos.close();
        System.out.println("see file:///" + out);
    }

    public static Samples gather(File source, Samples sink) throws IOException {
        if (null == sink) {
            sink = new Samples();
        }
        if (null == source) {
            source = new File(".");
        }
        SampleGatherer.doGather(source, sink);
        return sink;
    }

    private static String trimCommentEnd(String line, int start) {
        if (null == line) {
            return "";
        }
        if (start > 0 && start < line.length()) {
            line = line.substring(start);
        }
        if ((line = line.trim()).endsWith("*/")) {
            line = line.substring(0, line.length() - 2).trim();
        } else if (line.endsWith("-->")) {
            line = line.substring(0, line.length() - 3).trim();
        }
        return line;
    }

    private static void doGather(File source, Samples sink) throws IOException {
        if (source.isFile()) {
            if (SampleGatherer.isSource(source)) {
                SampleGatherer.gatherFromFile(source, sink);
            }
        } else if (source.isDirectory() && source.canRead()) {
            File[] files = source.listFiles();
            for (int i = 0; i < files.length; ++i) {
                SampleGatherer.doGather(files[i], sink);
            }
        }
    }

    private static boolean isSource(File file) {
        if (null == file || !file.isFile() || !file.canRead()) {
            return false;
        }
        String path = file.getName().toLowerCase();
        String[] suffixes = Sample.Kind.SOURCE_SUFFIXES;
        for (int i = 0; i < suffixes.length; ++i) {
            if (!path.endsWith(suffixes[i])) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void gatherFromFile(File source, Samples sink) throws IOException {
        Reader reader = null;
        try {
            String line;
            String author = null;
            StringBuffer sampleCode = new StringBuffer();
            String anchorName = null;
            String anchorTitle = null;
            ArrayList<String> flags = new ArrayList<String>();
            int startLine = -1;
            int endLine = Integer.MAX_VALUE;
            reader = new FileReader(source);
            LineNumberReader lineReader = new LineNumberReader(reader);
            while (null != (line = lineReader.readLine())) {
                int lineNumber;
                int loc = line.indexOf(START);
                if (-1 != loc) {
                    lineNumber = lineReader.getLineNumber();
                    if (-1 != startLine) {
                        SampleGatherer.abort("unexpected START-SAMPLE", source, line, lineNumber);
                    }
                    startLine = lineNumber;
                    endLine = -1;
                    anchorName = SampleGatherer.trimCommentEnd(line, loc + START.length());
                    if (-1 == (loc = anchorName.indexOf(" "))) {
                        anchorTitle = null;
                        continue;
                    }
                    anchorTitle = anchorName.substring(1 + loc).trim();
                    anchorName = anchorName.substring(0, loc);
                    continue;
                }
                loc = line.indexOf(END);
                if (-1 != loc) {
                    String newtag;
                    lineNumber = lineReader.getLineNumber();
                    if (Integer.MAX_VALUE == endLine) {
                        SampleGatherer.abort("unexpected END-SAMPLE", source, line, lineNumber);
                    }
                    if ((newtag = SampleGatherer.trimCommentEnd(line, loc + END.length())).length() > 0 && !newtag.equals(anchorName)) {
                        String m = "expected " + anchorName + " got " + newtag;
                        SampleGatherer.abort(m, source, line, lineNumber);
                    }
                    endLine = lineNumber;
                    Sample sample = new Sample(anchorName, anchorTitle, author, sampleCode.toString(), source, startLine, endLine, flags.toArray(new String[flags.size()]));
                    sink.addSample(sample);
                    sampleCode.setLength(0);
                    startLine = -1;
                    endLine = Integer.MAX_VALUE;
                    continue;
                }
                loc = line.indexOf(AUTHOR);
                if (-1 != loc) {
                    author = SampleGatherer.trimCommentEnd(line, loc + AUTHOR.length());
                }
                if (-1 != (loc = line.indexOf(FLAG))) {
                    flags.add(SampleGatherer.trimCommentEnd(line, loc + FLAG.length()));
                }
                if (-1 == startLine || -1 != endLine) continue;
                sampleCode.append(line);
                sampleCode.append(EOL);
            }
            if (-1 == endLine) {
                SampleGatherer.abort("incomplete sample", source, "", lineReader.getLineNumber());
            }
        }
        finally {
            if (null != reader) {
                reader.close();
            }
        }
    }

    private static void abort(String why, File file, String line, int lineNumber) throws Abort {
        throw new Abort(why + " at " + file + ":" + lineNumber + ": " + line);
    }

    static class Abort
    extends IOException {
        private static final long serialVersionUID = -1L;

        Abort(String s) {
            super(s);
        }
    }
}

