//
// BAGEL - Brilliantly Advanced General Electronic Structure Library
// Filename: _breitroot_12.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/breitrootlist.h>

using namespace std;
using namespace bagel;

void BreitRootList::breitroot12(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[12] = {7.778935822585290e-01,1.937296445047622e-01,1.761674062095619e+00,3.161287998144161e+00,5.001574999064721e+00,
    7.318757585657917e+00,1.016522452511489e+01,1.361818771226726e+01,1.779666564426749e+01,2.289929101819602e+01,2.930745858720969e+01,3.799825464121894e+01
    };
  constexpr double aw[12] = {1.583955754340995e-01,7.034110081601171e-02,1.354533484618175e-01,6.083297780644745e-02,1.558345083894831e-02,
    2.306020771185211e-03,1.922851122223677e-04,8.520944310255042e-06,1.809988968805279e-07,1.538749556641047e-09,3.689266812234077e-12,1.030483602539409e-15
    };
  constexpr double x[4608] = {  2.907326061095377e-02, -5.512804066293672e-04,  7.726550089856604e-06, -9.436503632218625e-08,  1.052113566593385e-09,
 -1.087328602018583e-11,  1.041503825953468e-13, -9.122194973305781e-16,  7.035412501944907e-18, -4.277468252583174e-20,  1.050960899722452e-22,  2.359594712614998e-24,
  1.147198632747022e-01, -2.084137995071522e-03,  2.670807641096085e-05, -2.769535178732359e-07,  2.300456611516345e-09, -1.298490391953411e-11, -5.414407155085109e-15,
  1.431023063206354e-15, -2.421892396158952e-17,  2.640404416109162e-19, -1.867472366140853e-21,  1.786528567658592e-24,  2.522777677855296e-01, -4.259887703371825e-03,
  4.632907084173871e-05, -3.331672174989076e-07,  6.725856146485465e-10,  2.271038725136164e-11, -3.978799293632426e-13,  3.221400196435738e-15,  4.811683167018981e-19,
 -4.222035337481195e-19,  6.503650750031758e-21, -4.452894249035259e-23,  4.341713176646328e-01, -6.591157735600711e-03,  5.464500160904480e-05, -1.258928709071182e-07,
 -3.457066956892858e-09,  5.007723806685371e-11, -1.504669594848289e-13, -4.639048510475599e-15,  7.444920459647581e-17, -2.338673535076181e-19, -8.016002743211469e-21,
  1.329863415936446e-22,  6.502119149798795e-01, -8.544435612678904e-03,  4.433870422020175e-05,  2.650592637096170e-07, -5.763603826145187e-09,  9.749287407922842e-12,
  6.480277524186900e-13, -6.029874209230071e-15, -4.761706167491947e-17,  1.260544850075165e-18, -2.342991708822243e-21, -1.822234962618898e-22,  8.880348277778621e-01,
 -9.658065090241938e-03,  1.675695006979811e-05,  5.803704863238229e-07, -2.880356295757785e-09, -5.962514591651616e-11,  5.179150618673370e-13,  6.979421949641359e-15,
 -9.475889300781519e-17, -8.245802604292417e-19,  1.738266692460557e-20,  8.789192513184139e-23,  1.133682138589678e+00, -9.652263764610088e-03, -1.812581012949049e-05,
  5.817966570300283e-07,  2.995561044132870e-09, -6.034615384545129e-11, -5.313285346585191e-13,  7.188153879811303e-15,  9.687433866175571e-17, -8.759676936815349e-19,
 -1.785941818265894e-20,  9.932539165796436e-23,  1.372335137187046e+00, -8.505507767198222e-03, -4.620978710771836e-05,  2.571322981762330e-07,  6.007100845342118e-09,
  1.197248200219352e-11, -6.810224579339245e-13, -6.637401954163955e-15,  5.001413387300651e-17,  1.395665232012988e-18,  2.837895420122207e-21, -2.055086976552733e-22,
  1.589184476098794e+00, -6.474626112476154e-03, -5.634617584772519e-05, -1.548964748037021e-07,  3.438055657426202e-09,  5.461872165658247e-11,  2.048211167537967e-13,
 -4.799234291228726e-15, -8.629350805114056e-17, -3.539260026923293e-19,  8.665086268516769e-21,  1.637911040980102e-22,  1.770402278038568e+00, -4.045926549405015e-03,
 -4.638460501362495e-05, -3.621307105160630e-07, -1.089655643776910e-09,  2.068973739495090e-11,  4.313927714932022e-13,  4.097927313704772e-15,  8.578621982050546e-18,
 -4.160906453127657e-19, -7.939014648912915e-21, -7.034992820002146e-23,  1.904150393426074e+00, -1.821576395601714e-03, -2.462862172988410e-05, -2.734881566174587e-07,
 -2.511746575593133e-09, -1.741446052175339e-11, -4.957867435552859e-14,  9.997928832756898e-16,  2.376010087188320e-17,  3.183688171116603e-19,  3.013398477466192e-21,
  1.652470347068362e-23,  1.981546938823111e+00, -3.655214615718923e-04, -5.379433481052697e-06, -6.947700582206541e-08, -8.273771378661107e-10, -9.260896000670881e-12,
 -9.809298467167599e-14, -9.825603743615031e-16, -9.233909903725102e-18, -7.987918705667690e-20, -6.083238184577084e-22, -3.568961034344099e-24,  2.698497532572030e-02,
 -4.937270391151545e-04,  6.688413452847392e-06, -7.914337745753492e-08,  8.577005835999015e-10, -8.656132149253850e-12,  8.153535745140311e-14, -7.107517902720171e-16,
  5.590013909557511e-18, -3.715190239086152e-20,  1.626288010916122e-22,  5.013361865112906e-25,  1.067904494207339e-01, -1.883161149756039e-03,  2.359691879039523e-05,
 -2.422187018805788e-07,  2.042287446400273e-09, -1.271332745607379e-11,  2.513196146139387e-14,  7.939828810424231e-16, -1.601828364843951e-17,  1.930911563801638e-19,
 -1.639374079155413e-21,  7.444157891019002e-24,  2.359544611204218e-01, -3.905032919030579e-03,  4.240902417353180e-05, -3.192604851019911e-07,  1.038563932907444e-09,
  1.423305309939960e-11, -3.094149232175338e-13,  3.039877322072277e-15, -1.052237161458094e-17, -2.025905603450046e-19,  4.475230831355531e-21, -4.500353297405971e-23,
  4.086702098806675e-01, -6.160906260093944e-03,  5.283471486629087e-05, -1.734292325716650e-07, -2.500804500576971e-09,  4.516680260809052e-11, -2.486498454996952e-13,
 -2.442272677293432e-15,  6.159734880936532e-17, -4.456956567642602e-19, -2.824080095360726e-21,  9.934372811026725e-23,  6.167615491698721e-01, -8.178550821230649e-03,
  4.697511806366396e-05,  1.751865422503198e-07, -5.427482625993278e-09,  2.314465799159082e-11,  4.644690719263476e-13, -6.859687534868005e-15, -5.606938117738955e-18,
  1.034179380455297e-18, -8.260116424392542e-21, -8.487225326129604e-23,  8.497135671277171e-01, -9.497021101933069e-03,  2.340788281759699e-05,  5.254800999339834e-07,
 -3.934599587505113e-09, -4.521524039774063e-11,  6.674115654841226e-13,  3.611243031373178e-15, -1.114055622383259e-16, -9.673040076459665e-20,  1.792863531755191e-20,
 -5.943227990303919e-23,  1.094828311249525e+00, -9.768625077176313e-03, -1.089854793688827e-05,  6.194517106467978e-07,  1.679091467107517e-09, -7.036632723899732e-11,
 -2.923214757673569e-13,  9.656929678262990e-15,  5.393795171121868e-17, -1.459267946321488e-18, -1.032256490456672e-20,  2.330836212318919e-22,  1.337595614666548e+00,
 -8.861197652182537e-03, -4.254265616254458e-05,  3.542141197594733e-07,  6.069184491471894e-09, -6.374632450144476e-12, -8.368642579884781e-13, -4.230423135391725e-15,
  9.988457994654610e-17,  1.303229855190050e-18, -7.947419199243742e-21, -2.713995048340386e-22,  1.562374092254164e+00, -6.931810893284264e-03, -5.783810530981584e-05,
 -9.093292917123400e-08,  4.567049743534038e-09,  5.760082466609553e-11,  3.042839944306428e-14, -7.683068869512414e-15, -9.099893892734251e-17,  1.425595240278276e-19,
  1.618558491621292e-20,  1.666146260024005e-22,  1.753448524103075e+00, -4.434646751527742e-03, -5.081919554559873e-05, -3.756529362483023e-07, -5.629394075718164e-10,
  3.243490717603283e-11,  5.472544547405034e-13,  4.065527107710341e-15, -1.284526686400750e-17, -7.931376139268112e-19, -1.078596432402294e-20, -5.238773452300706e-23,
  1.896448244923383e+00, -2.032442832008122e-03, -2.816328020420426e-05, -3.165158582770866e-07, -2.869175031368264e-09, -1.817104627067416e-11, -9.043297112560589e-15,
  1.968085138467177e-15,  3.755049064005908e-17,  4.515385901646892e-19,  3.574123717264223e-21,  6.593638267630915e-24,  1.979993164410509e+00, -4.121318288900107e-04,
 -6.299139374450213e-06, -8.433468707365851e-08, -1.038550296010188e-09, -1.198149039614870e-11, -1.302090463232336e-13, -1.329061440686274e-15, -1.258563796524147e-17,
 -1.073641491522868e-19, -7.641618522739963e-22, -3.305226697126400e-24,  2.511137972883457e-02, -4.437978177745106e-04,  5.815645891240349e-06, -6.670524523068192e-08,
  7.026338292094337e-10, -6.919072892985904e-12,  6.394667757482140e-14, -5.519903686139888e-16,  4.372260354220805e-18, -3.048992922057121e-20,  1.648323217102825e-22,
 -2.812190866735619e-25,  9.961770597113109e-02, -1.705475872710469e-03,  2.087808763925591e-05, -2.115368684771282e-07,  1.795579632665863e-09, -1.189531721866925e-11,
  4.114595088963588e-14,  3.806363979055549e-16, -1.016363696091420e-17,  1.345423440848638e-19, -1.282236938942209e-21,  8.288781514408185e-24,  2.209890342352853e-01,
 -3.580783586028295e-03,  3.868576459639396e-05, -3.007414705711972e-07,  1.255638812795617e-09,  7.784847622979101e-12, -2.298842499615632e-13,  2.617283224461328e-15,
 -1.504908576377114e-17, -6.072481622410529e-20,  2.689084900918964e-21, -3.538087969062478e-23,  3.848578870860587e-01, -5.747166916007790e-03,  5.054219232759242e-05,
 -2.065590946549934e-07, -1.661597464534107e-09,  3.858593134701494e-11, -2.919596138826868e-13, -7.418887185974431e-16,  4.445688542867012e-17, -4.839346187404068e-19,
  5.985630860050963e-22,  5.655733460710733e-23,  5.848102287411912e-01, -7.795778407344145e-03,  4.857337723188903e-05,  9.259038114553290e-08, -4.868642256264438e-09,
  3.199875759836789e-11,  2.749942680984794e-13, -6.512810100371199e-15,  2.503062072720420e-17,  6.566813633199856e-19, -9.978544426910927e-21,  2.083610285016366e-24,
  8.121383511307808e-01, -9.285668137289704e-03,  2.930897603858318e-05,  4.561895102903602e-07, -4.672613424561537e-09, -2.838526333960582e-11,  7.190398255456292e-13,
  1.217276394799117e-16, -1.029256033184969e-16,  5.343591379829193e-19,  1.291676257859517e-20, -1.563482102980824e-22,  1.055627013712046e+00, -9.825732030604507e-03,
 -3.351352932357304e-06,  6.347721720145798e-07,  2.243029961130249e-10, -7.399314123970416e-11, -6.105744401393049e-15,  1.048416419926994e-14, -3.354206256386684e-18,
 -1.646424542095386e-18,  1.273163945807888e-21,  2.750507606629928e-22,  1.301499370483157e+00, -9.182902756612155e-03, -3.771728042588731e-05,  4.491766129455033e-07,
  5.733290565807852e-09, -2.747903666222873e-11, -9.040876113108298e-13, -3.681553004112933e-16,  1.382130945584611e-16,  7.496304323413866e-19, -1.942627035238622e-20,
 -2.290106418218320e-22,  1.533716397126382e+00, -7.397550854613328e-03, -5.845293248760482e-05, -8.683278237331909e-09,  5.707280755132806e-09,  5.543009131100135e-11,
 -2.237240462266694e-13, -1.037456945732020e-14, -7.259833157111619e-17,  9.184083954962332e-19,  2.196158113563358e-20,  7.760579434055002e-23,  1.734868135244974e+00,
 -4.859330651459833e-03, -5.535725137918953e-05, -3.787192615416560e-07,  2.259572561595122e-10,  4.685912707251991e-11,  6.504266263120854e-13,  3.110759485119647e-15,
 -4.957656663437033e-17, -1.254018067507319e-18, -1.172201958265646e-20,  2.168572376007502e-23,  1.887842667758392e+00, -2.273749843412947e-03, -3.224888488195653e-05,
 -3.653204374796344e-07, -3.229533632022102e-09, -1.757501264006821e-11,  6.552756075798101e-14,  3.457554854388242e-15,  5.638737397914307e-17,  5.931391521310455e-19,
  3.278055545690046e-21, -2.500382339332387e-23,  1.978237017144188e+00, -4.668748758497597e-04, -7.419350881078180e-06, -1.030518421666482e-07, -1.312695731470550e-09,
 -1.560237069954304e-11, -1.736857740705490e-13, -1.799801913719602e-15, -1.703188175285643e-17, -1.403462252330316e-19, -8.671211840086913e-22, -8.078211874207196e-25,
  2.342442579087938e-02, -4.002933862264654e-04,  5.078325617634832e-06, -5.649175221286391e-08,  5.784252281537962e-10, -5.554980752431816e-12,  5.029360662476185e-14,
 -4.283986924418040e-16,  3.389324817688750e-18, -2.424802979750613e-20,  1.453436244369041e-22, -5.490012327008488e-25,  9.311444120294678e-02, -1.548134260423067e-03,
  1.850435218113988e-05, -1.846541743575594e-07,  1.568239420642191e-09, -1.081253332692394e-11,  4.791210078624568e-14,  1.236980821906825e-16, -6.157488826264386e-18,
  9.030307462198273e-20, -9.378481267281223e-22,  7.195082381755527e-24,  2.072625112317819e-01, -3.285381521040655e-03,  3.520164092505504e-05, -2.796815246602371e-07,
  1.361812205718698e-09,  3.091265906836843e-12, -1.635395830340228e-13,  2.118653028670489e-15, -1.564328546321760e-17,  1.909809916497524e-20,  1.385345055556767e-21,
 -2.400008911448284e-23,  3.626616321354566e-01, -5.353140015334206e-03,  4.792819053172667e-05, -2.273559946660230e-07, -9.608682957685010e-10,  3.147455750079345e-11,
 -2.953771054020495e-13,  4.107910771466709e-16,  2.796302098760440e-17, -4.213631137210535e-19,  2.275419502771379e-21,  2.167257839878108e-23,  5.544095231517031e-01,
 -7.404020654342760e-03,  4.923918796988688e-05,  2.011037811128315e-08, -4.176889020126027e-09,  3.651994201689038e-11,  1.068607070683790e-13, -5.409307221256996e-15,
  4.167722436979166e-17,  2.773203213946477e-19, -8.616861446064491e-21,  5.326168353992209e-23,  7.754974490826885e-01, -9.030607257784531e-03,  3.431896983337850e-05,
  3.778184041078053e-07, -5.069309235730678e-09, -1.143859453849075e-11,  6.798584914983987e-13, -2.778621514864732e-15, -7.615885186122660e-17,  9.022269790743596e-19,
  5.339629919059991e-21, -1.754498308983679e-22,  1.016318645013026e+00, -9.822124808471409e-03,  4.238855629303240e-06,  6.266130531463652e-07, -1.233539071074006e-09,
 -7.068296862549880e-11,  2.772418891394627e-13,  9.461334678933177e-15, -5.890118963549940e-17, -1.366987842284981e-18,  1.217001970430868e-20,  2.031818162144961e-22,
  1.264200557282975e+00, -9.461570475072904e-03, -3.179870755382162e-05,  5.353394357411848e-07,  4.968561589373125e-09, -4.878193409090822e-11, -8.495917967723988e-13,
  4.319070065892312e-15,  1.491443953953398e-16, -1.877346897523819e-19, -2.621487518186444e-20, -6.154405512026373e-23,  1.503192586530223e+00, -7.863956881136166e-03,
 -5.797387428103670e-05,  9.110725515775156e-08,  6.737454663858853e-09,  4.634906736785783e-11, -5.405323754019168e-13, -1.199542376590700e-14, -2.335594516422555e-17,
  1.813569576205481e-18,  2.132651480751157e-20, -1.234246518252914e-22,  1.714516501729225e+00, -5.320228858411032e-03, -5.984644427097021e-05, -3.667325049582478e-07,
  1.325182374232720e-09,  6.329045006385186e-11,  7.079073580025222e-13,  7.156151185790555e-16, -1.025817676224610e-16, -1.664190802516884e-18, -7.646310173800363e-21,
  1.781960238537844e-22,  1.878202647429484e+00, -2.550180716264475e-03, -3.695398874331884e-05, -4.196826843936181e-07, -3.556324971015817e-09, -1.461615201499995e-11,
  1.909739038487321e-13,  5.625766228473629e-15,  7.968123568714623e-17,  6.846281527529493e-19,  7.690594336768099e-22, -9.781310202229098e-23,  1.976242438781477e+00,
 -5.315585014117733e-04, -8.793072609674582e-06, -1.267961437114239e-07, -1.670848656695068e-09, -2.044205780378907e-11, -2.325177239342322e-13, -2.432327183038805e-15,
 -2.270174056216472e-17, -1.739374975494182e-19, -7.540240543235022e-22,  7.325622692948113e-24,  2.190042357886424e-02, -3.622290905998690e-04,  4.452488931403134e-06,
 -4.806403042467741e-08,  4.784845296484990e-10, -4.480388026112911e-12,  3.969334866766044e-14, -3.328338811165738e-16,  2.615004321417115e-18, -1.893894608708010e-20,
  1.198558070071894e-22, -5.861181124115557e-25,  8.720452113118048e-02, -1.408552307014293e-03,  1.643212151432117e-05, -1.612290585101339e-07,  1.363664986413491e-09,
 -9.640586017544665e-12,  4.905764464477760e-14, -2.797552646726763e-17, -3.509748832771838e-18,  5.865471848271048e-20, -6.564174566238806e-22,  5.577168715528848e-24,
  1.946634831092564e-01, -3.016819284645702e-03,  3.197759873032499e-05, -2.575920190455016e-07,  1.388904720788815e-09, -1.774128893716893e-13, -1.110569438740312e-13,
  1.637880205555457e-15, -1.418524978137460e-17,  5.638186988259163e-20,  5.481634545889756e-22, -1.449490134066493e-23,  3.419983350481142e-01, -4.980843569908201e-03,
  4.512721546041916e-05, -2.380735730771122e-07, -4.008704712083665e-10,  2.461129638946224e-11, -2.734941854400534e-13,  1.081873369053378e-15,  1.459309236676793e-17,
 -3.186626348385091e-19,  2.700328818246681e-21, -2.302379224002499e-25,  5.255812660333586e-01, -7.010221794923808e-03,  4.910395173524509e-05, -4.078599863058450e-08,
 -3.432302179961237e-09,  3.742474520316393e-11, -2.487310916458908e-14, -3.977392051186989e-15,  4.608637128475419e-17, -1.382228209980147e-20, -5.834089500708711e-21,
  6.805776964405444e-23,  7.399508753028893e-01, -8.739310844814600e-03,  3.836137590381295e-05,  2.957348055240086e-07, -5.142508717480959e-09,  3.700121916053397e-12,
  5.730294988211863e-13, -4.669414215639892e-15, -4.161628656819554e-17,  9.707459594576137e-19, -1.594977477008395e-21, -1.323274995811052e-22,  9.771449782167867e-01,
 -9.758576719128855e-03,  1.159454851219290e-05,  5.960143702800013e-07, -2.560482280159792e-09, -6.110486286029710e-11,  5.091332937296707e-13,  6.898248061323302e-15,
 -9.755054625906026e-17, -7.410516054224988e-19,  1.806496462260456e-20,  5.867062727092110e-23,  1.225887983255958e+00, -9.688993497070680e-03, -2.493330177874603e-05,
  6.059741127286393e-07,  3.801550675647611e-09, -6.719516223236560e-11, -6.643112829076166e-13,  8.779847626457078e-15,  1.234651278063140e-16, -1.223459871222380e-18,
 -2.387384693612589e-20,  1.695096351780077e-22,  1.470818774770850e+00, -8.321476838543746e-03, -5.620579828061957e-05,  2.055026382002025e-07,  7.507342489304443e-09,
  2.932723981144527e-11, -8.759625012851101e-13, -1.154869466237491e-14,  5.528933069792759e-17,  2.481921358369932e-18,  1.017774513198451e-20, -3.837630812236589e-22,
  1.692250814781801e+00, -5.816140920135610e-03, -6.407525395787338e-05, -3.344805908735033e-07,  2.760353933799839e-09,  8.009271771575092e-11,  6.726676179246638e-13,
 -3.565521412379773e-15, -1.655330887282844e-16, -1.749205456062232e-18,  5.077232713468220e-21,  4.076161473593634e-22,  1.867377372329471e+00, -2.866945026109393e-03,
 -4.234026868651639e-05, -4.786144053978668e-07, -3.788469317200132e-09, -7.831652328166772e-12,  3.878816275755465e-13,  8.565429323932274e-15,  1.035339105172547e-16,
  5.941881658189394e-19, -6.293162837961529e-21, -2.356293719667189e-22,  1.973965193906342e+00, -6.084769310631964e-04, -1.048956870878249e-05, -1.571283632037963e-07,
 -2.141460080743623e-09, -2.692780813592829e-11, -3.117711581424784e-13, -3.263889832924994e-15, -2.938604755081883e-17, -1.927315778819667e-19, -3.239356433130301e-23,
  2.861182025051370e-23,  2.051926933763404e-02, -3.287925937918991e-04,  3.918857424645794e-06, -4.107638611767788e-08,  3.976946179051385e-10, -3.630722128596829e-12,
  3.144933203315287e-14, -2.591871035557994e-16,  2.013383828015226e-18, -1.464866862185970e-20,  9.504208336353791e-23, -5.344776570060973e-25,  8.182147728744912e-02,
 -1.284477653074244e-03,  1.462212785737401e-05, -1.408894126801098e-07,  1.182505718486517e-09, -8.483512302093539e-12,  4.698591270708283e-14, -1.111183281202338e-16,
 -1.815966242533342e-18,  3.683548369052818e-20, -4.458391022326859e-22,  4.028785311216614e-24,  1.830888024456193e-01, -2.772986266423163e-03,  2.901928359593586e-05,
 -2.355280527699567e-07,  1.362160832306969e-09, -2.341747252086613e-12, -7.122254160797320e-14,  1.219546560803042e-15, -1.189437493192927e-17,  6.772574943293114e-20,
  6.767769186384408e-23, -7.810592817834773e-24,  3.227787951587501e-01, -4.631327267832885e-03,  4.224696737996440e-05, -2.408952092770308e-07,  2.840097473105338e-11,
  1.845385424214654e-11, -2.382413270206262e-13,  1.385886996382462e-15,  5.027021002489151e-18, -2.146639029941227e-19,  2.423004292629862e-21, -1.081462538531385e-23,
  4.983216988604407e-01, -6.620224996157479e-03,  4.830951772520619e-05, -8.978219594252458e-08, -2.697943635849799e-09,  3.565610926556339e-11, -1.159556473629932e-13,
 -2.549833241953397e-15,  4.209891079686031e-17, -1.887699902931174e-19, -2.982040501885067e-21,  5.885007273147719e-23,  7.056279283098634e-01, -8.419613080671897e-03,
  4.142124820184448e-05,  2.147471629258096e-07, -4.942212579723143e-09,  1.576501205304471e-11,  4.287473841510413e-13, -5.464532058875599e-15, -9.044122256125577e-18,
  8.100919720637585e-19, -5.935905424818912e-21, -6.398045142386107e-23,  9.383403813284970e-01, -9.637996359133838e-03,  1.846289959734781e-05,  5.459928445486309e-07,
 -3.646651533697839e-09, -4.694018475076930e-11,  6.555812091622107e-13,  3.491586813184784e-15, -1.110095177761906e-16, -1.146088197947785e-20,  1.736750269760627e-20,
 -8.409895830612073e-23,  1.186780449061053e+00, -9.858446451205385e-03, -1.734357196379992e-05,  6.552724694090609e-07,  2.320237405632302e-09, -7.978900963679625e-11,
 -3.709955357025897e-13,  1.186003667330887e-14,  6.458940495855231e-17, -1.969064694060178e-18, -1.210527290591852e-20,  3.464413091643558e-22,  1.436652124443939e+00,
 -8.759180472236417e-03, -5.300369522655540e-05,  3.290649525127518e-07,  7.858854803296622e-09,  4.708178252004892e-12, -1.160775440168413e-12, -8.308358007803644e-15,
  1.472916936706343e-16,  2.486842158559740e-18, -1.125135535706866e-20, -5.620814044790422e-22,  1.667936853912989e+00, -6.343919978905426e-03, -6.776844478365678e-05,
 -2.766683712110157e-07,  4.512229649429434e-09,  9.438431976163026e-11,  4.897107276967704e-13, -9.791677358948964e-15, -2.198980266646314e-16, -1.119460739213978e-18,
  2.793122641012677e-20,  6.129938956267438e-22,  1.855194307430972e+00, -3.229679315685319e-03, -4.845062555634895e-05, -5.398886711233222e-07, -3.830573784586502e-09,
  4.747334733608638e-12,  6.768324580183068e-13,  1.214856050955109e-14,  1.173802069760178e-16,  7.756023105392644e-20, -2.108598467478293e-20, -4.473739558150055e-22,
  1.971350631518263e+00, -7.005618532159018e-04, -1.259986819042049e-05, -1.961397889885883e-07, -2.762819997245490e-09, -3.561959002776930e-11, -4.173524145858281e-13,
 -4.312382055103567e-15, -3.594063290073260e-17, -1.569499940251474e-19,  2.184384224035045e-21,  7.892282798738712e-23,  1.926382463598130e-02, -2.993104919903637e-04,
  3.461849600147345e-06, -3.525552031299066e-08,  3.320758289726939e-10, -2.956206787905097e-12,  2.501978122994772e-14, -2.025074974185931e-16,  1.548981967326031e-18,
 -1.129671508607154e-20,  7.306435141878414e-23, -4.650511500936970e-25,  7.690725070126254e-02, -1.173954183023222e-03,  1.303957166168961e-05, -1.232665749596877e-07,
  1.023830916073432e-09, -7.398642318246068e-12,  4.323774885576055e-14, -1.511316120430878e-16, -7.718703461282048e-19,  2.214480883156520e-20, -2.981743590585381e-22,
  2.727351757778306e-24,  1.724437834689204e-01, -2.551770944697073e-03,  2.632189792859105e-05, -2.141901680113714e-07,  1.300785705821335e-09, -3.682074190203880e-12,
 -4.203712880354390e-14,  8.778725596773234e-16, -9.477508364171417e-18,  6.493520739344860e-20, -1.774022535784527e-22, -3.707778922909718e-24,  3.049111749556775e-01,
 -4.304880675762811e-03,  3.937016122492412e-05, -2.377854080861466e-07,  3.435093329773225e-10,  1.321340156461296e-11, -1.982186224109959e-13,  1.440791509937049e-15,
 -1.083959207803602e-18, -1.285998253063900e-19,  1.857382011401773e-21, -1.400568941475794e-23,  4.726059617854717e-01, -6.238739135213591e-03,  4.699611209708594e-05,
 -1.274171459638521e-07, -2.017676339240829e-09,  3.216167684496368e-11, -1.696486048229450e-13, -1.329667724217133e-15,  3.373223701489593e-17, -2.616099458652477e-19,
 -8.015506433446343e-22,  3.956571459298430e-23,  6.726266747854204e-01, -8.079252177410106e-03,  4.353583484531204e-05,  1.387009675267444e-07, -4.536467534880225e-09,
  2.421135691494443e-11,  2.757201055773225e-13, -5.337493824418581e-15,  1.534333158192948e-17,  5.354891866375091e-19, -7.353443806179947e-21, -3.718937001045431e-24,
  9.001238105222048e-01, -9.465143054212812e-03,  2.463659735717095e-05,  4.810169269382426e-07, -4.422256207168786e-09, -3.043027542966444e-11,  7.044559609498593e-13,
  5.763991306375781e-17, -1.000891552716462e-16,  5.795514739914486e-19,  1.158479101376820e-20, -1.660186272906106e-22,  1.147119694627485e+00, -9.965234691559155e-03,
 -9.311470638370548e-06,  6.792624920786944e-07,  6.632362442346001e-10, -8.454244816194939e-11, -2.112123415816061e-14,  1.273051644597275e-14, -1.113505294359408e-17,
 -2.128484796572655e-18,  4.309830052639791e-21,  3.703888995449538e-22,  1.400795366787067e+00, -9.165280335686676e-03, -4.830245227071797e-05,  4.539777926667626e-07,
  7.658677316314712e-09, -2.533102804016701e-11, -1.314866612763595e-12, -2.298373137285794e-15,  2.226994952814674e-16,  1.540020439554519e-18, -3.560688435807293e-20,
 -4.948116938914010e-22,  1.641457778518133e+00, -6.897973201824959e-03, -7.059121900961006e-05, -1.888405359585550e-07,  6.491003999686363e-09,  1.020240309404139e-10,
  1.128216287911482e-13, -1.720336285567381e-14, -2.333895200465482e-16,  5.544417745907162e-19,  5.557800406464190e-20,  5.832322119597405e-22,  1.841457895153710e+00,
 -3.644227337224613e-03, -5.529069817933097e-05, -5.994124301843981e-07, -3.543454310531988e-09,  2.549340528226039e-11,  1.068593823621086e-12,  1.574387831111964e-14,
  9.960317820173038e-17, -1.229902802127315e-18, -4.596461337217383e-20, -6.743516054919638e-22,  1.968330742571809e+00, -8.115848867633484e-04, -1.524416613744329e-05,
 -2.466317223620415e-07, -3.585847857877435e-09, -4.721939258487931e-11, -5.548831391377940e-13, -5.527734043597071e-15, -3.894763965977978e-17,  2.657972991895982e-20,
  7.792884834430239e-21,  1.897569750930340e-22,  1.811941469076745e-02, -2.732219261836349e-04,  3.068812187889079e-06, -3.038450606369758e-08,  2.785245767942630e-10,
 -2.418530016343807e-12,  1.998617262482614e-14, -1.589218174814463e-16,  1.190146866960515e-18, -8.764595400672874e-21,  5.400270024668339e-23, -4.009745218879675e-25,
  7.241107763276906e-02, -1.075286810261316e-03,  1.165395602936114e-05, -1.080141613673628e-07,  8.858807820254599e-10, -6.413847878972153e-12,  3.876496423146557e-14,
 -1.651629154073486e-16, -1.633912420301233e-19,  1.229612011320434e-20, -2.016550623409700e-22,  1.714966215394466e-24,  1.626420633261558e-01, -2.351128989430138e-03,
  2.387390501667566e-05, -1.940137771015383e-07,  1.218878175244554e-09, -4.428166733229106e-12, -2.136256675908903e-14,  6.103539650873435e-16, -7.299775961398871e-18,
  5.533490841410913e-20, -2.865606230589758e-22, -1.485011731363489e-24,  2.883036594955459e-01, -4.001221178315230e-03,  3.655763399168894e-05, -2.304199957623818e-07,
  5.634359709247571e-10,  8.932545937127883e-12, -1.589628303524594e-13,  1.345161391876517e-15, -4.525037778603385e-18, -6.661890042640009e-20,  1.247047932036011e-21,
 -1.328982286694703e-23,  4.483925471223940e-01, -5.869387675246435e-03,  4.529388997696795e-05, -1.547858978235509e-07, -1.417581247168531e-09,  2.775647196887313e-11,
 -1.932092575925930e-13, -4.040658319501459e-16,  2.410219848846304e-17, -2.648069804054598e-19,  4.995086013640081e-22,  2.013830994894965e-23,  6.410150898634375e-01,
 -7.725502881698023e-03,  4.478175373126319e-05,  7.030123655589614e-08, -3.997818057361008e-09,  2.910651279446076e-11,  1.356394777239507e-13, -4.594369253169577e-15,
  2.940419317292110e-17,  2.505690312226543e-19, -6.631286891001421e-21,  3.219748988552745e-23,  8.626922295117743e-01, -9.246204625193702e-03,  2.996714194603030e-05,
  4.063049068660536e-07, -4.863439742359843e-09, -1.384377614815767e-11,  6.649186935970376e-13, -2.736755072504844e-15, -7.271602838318642e-17,  8.900660434969501e-19,
  3.904275154164439e-21, -1.714185439535840e-22,  1.107161482041194e+00, -1.000706954459396e-02, -1.152209827269766e-06,  6.764395193222726e-07, -1.004310750241705e-09,
 -8.088102009745076e-11,  3.192394380239708e-13,  1.121169841763729e-14, -8.099160069744606e-17, -1.660978484582908e-18,  1.804876811873494e-20,  2.323190422404801e-22,
  1.363398784596540e+00, -9.527875550112395e-03, -4.214178189797815e-05,  5.707422383701693e-07,  6.835616308298024e-09, -5.681436757830638e-11, -1.273300233420505e-12,
  5.402445171268774e-15,  2.480184526217533e-16, -2.320252396723770e-19, -5.034022168785118e-20, -1.328626451007061e-22,  1.612724771468426e+00, -7.469846587646114e-03,
 -7.216683984578226e-05, -6.869207100388133e-08,  8.515320849324773e-09,  9.814241017138456e-11, -4.671077599351333e-13, -2.387892535845025e-14, -1.681425583663792e-16,
  3.182862457754374e-18,  7.219980797093251e-20,  8.249099391113789e-23,  1.825949482031609e+00, -4.116239967577136e-03, -6.280205585611175e-05, -6.504796066684074e-07,
 -2.739779771909148e-09,  5.673468182656163e-11,  1.544509868485572e-12,  1.780743584370295e-14,  1.473565985955474e-17, -3.695380099659805e-18, -7.751312867024164e-20,
 -6.947666855271961e-22,  1.964820274510040e+00, -9.464286350400367e-04, -1.858164663849929e-05, -3.123390803046210e-07, -4.676659365275793e-09, -6.253124507244130e-11,
 -7.264256002329473e-13, -6.679097685060646e-15, -2.987578146676106e-17,  5.612971937539934e-19,  2.059148426350753e-20,  4.174523822493257e-22,  1.707342106977521e-02,
 -2.500576403388237e-04,  2.729420710925904e-06, -2.629045477199622e-08,  2.346112791085238e-10, -1.988233502393410e-12,  1.602489282011874e-14, -1.255017114527084e-16,
  9.094746091133018e-19, -6.931559863514702e-21,  3.847058194193546e-23, -2.850373546207724e-25,  6.828851234094854e-02, -9.870083106641751e-04,  1.043875694021064e-05,
 -9.481731326375533e-08,  7.665313169356999e-10, -5.539217530421888e-12,  3.412344124855003e-14, -1.647309350383181e-16,  1.503554913150447e-19,  5.538955229782178e-21,
 -1.398860920197168e-22,  1.221238788231246e-24,  1.536052437818057e-01, -2.169125760532561e-03,  2.165975395391510e-05, -1.752427313120211e-07,  1.126443203226376e-09,
 -4.760426482974455e-12, -7.259860680462596e-15,  4.063213166243388e-16, -5.525644349781827e-18,  4.302033752546371e-20, -3.177372332432976e-22,  1.220479073414931e-25,
  2.728664176462501e-01, -3.719654718564286e-03,  3.385194214322132e-05, -2.201706140727842e-07,  7.068938333043923e-10,  5.551150312048019e-12, -1.236238543198644e-13,
  1.170513305823395e-15, -6.159738189660978e-18, -2.766627891185605e-20,  7.245159938997364e-22, -9.969581601015908e-24,  4.256274441274864e-01, -5.514811320773347e-03,
  4.331786758011000e-05, -1.732804969987762e-07, -9.093247832501253e-10,  2.306220417063909e-11, -1.951223181644374e-13,  2.199835204684501e-16,  1.510017421725276e-17,
 -2.316186595978224e-19,  1.063818319696638e-21,  7.047446733792035e-24,  6.108334536500368e-01, -7.364916617029240e-03,  4.526124657002241e-05,  1.112832744896212e-08,
 -3.392975906876426e-09,  3.093105754175032e-11,  2.117907394616858e-14, -3.557188563737257e-15,  3.404187808303076e-17,  1.891364592465437e-20, -4.852678781203530e-21,
  4.604373055379811e-23,  8.262158760682750e-01, -8.988303266275225e-03,  3.436950060457386e-05,  3.271115231863915e-07, -4.988172237620623e-09,  9.621126181797203e-13,
  5.606623810153628e-13, -4.534946453734923e-15, -3.957650627018317e-17,  9.074618928057867e-19, -2.653135086151174e-21, -1.194772761983103e-22,  1.067165634193040e+00,
 -9.984211027152357e-03,  6.816895082597638e-06,  6.479466835258176e-07, -2.521614038238118e-09, -6.979484896166892e-11,  5.889850422629835e-13,  7.818955868845938e-15,
 -1.258817117536563e-16, -7.958050796326321e-19,  2.365667898594975e-20,  2.129927610932733e-23,  1.324658888116263e+00, -9.835851715349009e-03, -3.467935289801834e-05,
  6.694287469099415e-07,  5.410540813060526e-09, -8.468325286960237e-11, -1.014969597743818e-12,  1.281402130968593e-14,  2.033400293464412e-16, -2.215861994864059e-18,
 -4.515260756407977e-20,  3.703466516578655e-22,  1.581688955235772e+00, -8.048018307151536e-03, -7.211151708645365e-05,  8.241002478870196e-08,  1.030928517165860e-08,
  7.842620715708493e-11, -1.189878025814572e-12, -2.687671810099295e-14, -3.023525717417208e-18,  5.882823338546919e-18,  5.570240696124604e-20, -8.830990459740885e-22,
  1.808429331945052e+00, -4.650524494442832e-03, -7.082639946034576e-05, -6.830558029763894e-07, -1.194345138860233e-09,  9.969380730339704e-11,  2.025136332895165e-12,
  1.549839741270350e-14, -1.804679457079424e-16, -7.284364482844180e-18, -9.724988621868135e-20, -4.113483162201246e-23,  1.960711586558231e+00, -1.111447659671283e-03,
 -2.282319171108134e-05, -3.981831142628728e-07, -6.117229806933888e-09, -8.229231217114725e-11, -9.224156758515275e-13, -7.110769728836666e-15,  1.053810672547231e-17,
  1.860400676096431e-18,  4.745928473853474e-20,  8.437059450450056e-22,  1.611494943560282e-02, -2.294232942659494e-04,  2.435210263130417e-06, -2.283503366883993e-08,
  1.984240002163083e-10, -1.642736474856133e-12,  1.288277171417800e-14, -1.001143620606493e-16,  6.852924113706088e-19, -5.564427029502088e-21,  3.247660476848417e-23,
  7.514516252430162e-26,  6.450057669568876e-02, -9.078491279168157e-04,  9.371020184307000e-06, -8.339614648581611e-08,  6.635664420648056e-10, -4.774912559705084e-12,
  2.960123552153866e-14, -1.577003304721749e-16,  2.626674347264365e-19,  1.115173616750412e-21, -7.590907017261407e-23,  1.979273014836723e-24,  1.452624013139262e-01,
 -2.003960267001299e-03,  1.966181692069109e-05, -1.579872489808816e-07,  1.030316336650272e-09, -4.816775582106119e-12,  1.857244714893888e-15,  2.518793060340030e-16,
 -4.197889607581988e-18,  3.117011193821425e-20, -2.509795364676156e-22,  3.437010615266413e-24,  2.585129781975150e-01, -3.459207651703954e-03,  3.128092761506206e-05,
 -2.081226016160636e-07,  7.907834854257442e-10,  2.954456957234832e-12, -9.372336554494058e-14,  9.623051888492195e-16, -6.723486839618344e-18, -5.584755439641823e-21,
  4.370746327298278e-22, -2.001338697691435e-24,  4.042478103785324e-01, -5.176799764802057e-03,  4.116561117271551e-05, -1.843911994476275e-07, -4.941605239703899e-10,
  1.850038735579278e-11, -1.833898560493786e-13,  5.784997981211535e-16,  7.589208286072460e-18, -1.841155924701542e-19,  1.308864830338791e-21,  6.826212365577383e-24,
  5.820975719947373e-01, -7.003168338704040e-03,  4.508947756492258e-05, -3.821435444834763e-08, -2.776705192644816e-09,  3.036662558040051e-11, -6.331261019682618e-14,
 -2.490329262747812e-15,  3.173617926173905e-17, -1.325486266222879e-19, -2.661347376415257e-21,  5.452713525060378e-23,  7.908355276696885e-01, -8.698996702311869e-03,
  3.781885424482892e-05,  2.481404393029717e-07, -4.845271200133429e-09,  1.278038267011599e-11,  4.206658015061770e-13, -5.308108519206974e-15, -9.876920493224243e-18,
  7.194458874128322e-19, -6.123960967347934e-21, -3.396940715076890e-23,  1.027386002880549e+00, -9.899361067677337e-03,  1.430678667177750e-05,  5.972676917067286e-07,
 -3.760862282889622e-09, -5.350718649905041e-11,  7.485100354110587e-13,  3.513488703371803e-15, -1.377705627402550e-16,  1.159232713317265e-19,  2.081064644469717e-20,
 -1.306722190738378e-22,  1.284813386102073e+00, -1.007981895321432e-02, -2.618661132589382e-05,  7.412587180223052e-07,  3.505790082963248e-09, -1.040869661627709e-10,
 -5.793338100389132e-13,  1.773586377745759e-14,  9.618672825654010e-17, -3.567220143101124e-18, -1.962953880893140e-20,  7.501084145649252e-22,  1.548353462589758e+00,
 -8.618042771872222e-03, -7.008686400970339e-05,  2.581017565167302e-07,  1.153210501693837e-08,  4.103646161140431e-11, -1.909407678459588e-12, -2.324925516578535e-14,
  2.367399897184919e-16,  7.035769038756888e-18, -4.671676424953666e-21, -1.774967488941309e-21,  1.788641862927895e+00, -5.250077865760397e-03, -7.906300655931478e-05,
 -6.834410984658715e-07,  1.316216531169798e-09,  1.525831810830648e-10,  2.333566991183125e-12,  4.798521230047427e-15, -5.092106447916656e-16, -1.075674496569873e-17,
 -6.258670910965450e-20,  1.852535857431611e-21,  1.955867838758676e+00, -1.314943098479232e-03, -2.824703365013931e-05, -5.104944634744536e-07, -8.000069440120416e-09,
 -1.067044276644614e-10, -1.103643451351819e-12, -5.252383539629151e-15,  1.222612196517482e-16,  4.684119957785726e-18,  9.871465806198836e-20,  1.526673728579571e-21,
  1.523455719488415e-02, -2.109861148242476e-04,  2.179206272036122e-06, -1.990719915318460e-08,  1.684461316165399e-10, -1.364886123484955e-12,  1.035834737916099e-14,
 -8.112123017507427e-17,  5.109769108541788e-19, -3.991436733448839e-21,  5.225706950106550e-23,  9.082947887912408e-25,  6.101302394732679e-02, -8.367105058698826e-04,
  8.430938337972370e-06, -7.350595332313249e-08,  5.748198283952863e-10, -4.116499383394611e-12,  2.530632605080573e-14, -1.490306210335390e-16,  2.750764275029872e-19,
  5.048709183613894e-22,  6.649385405956822e-23,  4.866642274956179e-24,  1.375495283074524e-01, -1.853976168467695e-03,  1.786171499655607e-05, -1.422683123786759e-07,
  9.349235524513107e-10, -4.701773049838369e-12,  7.186311255545102e-15,  1.339643547949718e-16, -3.203602160110032e-18,  2.602776394156725e-20,  4.885182156908927e-23,
  1.097014160951605e-23,  2.451611337495283e-01, -3.218731282101543e-03,  2.886094964007994e-05, -1.951108454635597e-07,  8.294355258917847e-10,  1.004053391883870e-12,
 -6.979698008270561e-14,  7.473717090299050e-16, -6.594868555171929e-18,  1.424115595298341e-20,  6.719618500348956e-22,  1.412690725068816e-23,  3.841850927623464e-01,
 -4.856433468660292e-03,  3.891692905865964e-05, -1.895709199321826e-07, -1.667370934858375e-10,  1.431510442585688e-11, -1.647118697861714e-13,  7.262104810517572e-16,
  2.010162463825890e-18, -1.216962576936097e-19,  1.948391397480008e-21,  2.545962936373895e-23,  5.548024197804859e-01, -6.644996559657341e-03,  4.438405620917914e-05,
 -7.788724311030670e-08, -2.189643684557951e-09,  2.812010804011892e-11, -1.196592731433698e-13, -1.566679508218199e-15,  2.567273345499941e-17, -1.856400092794750e-19,
  1.781897160866264e-22,  7.809684930799713e-23,  7.566616704110197e-01, -8.385830303449710e-03,  4.034146643951844e-05,  1.731586233204350e-07, -4.500831863667657e-09,
  2.107932440341952e-11,  2.711623363682372e-13, -5.258173385581669e-15,  1.152869778421831e-17,  4.750923876747644e-19, -5.303438918843882e-21,  7.427199555144387e-23,
  9.880613162892954e-01, -9.757335739191124e-03,  2.108087319045560e-05,  5.295333914713454e-07, -4.645933341467543e-09, -3.485128965880705e-11,  7.868692361376905e-13,
 -6.799223223800743e-16, -1.201271211985225e-16,  8.218206665733570e-19,  1.451669425614855e-20, -1.263392107619675e-22,  1.244132592667041e+00, -1.025294011248434e-02,
 -1.702562235543274e-05,  7.801155367167081e-07,  1.326515203048700e-09, -1.118063288779657e-10, -5.963289872518253e-14,  1.867555706745275e-14, -3.791734531658373e-17,
 -3.642201220853166e-18,  1.658488739073380e-20,  8.477167023557869e-22,  1.512784006346440e+00, -9.163166894160057e-03, -6.586410335023198e-05,  4.464884252100279e-07,
  1.184724717690684e-08, -1.151617895284849e-11, -2.417423064373130e-12, -1.181571048505971e-14,  4.670524420509219e-16,  5.219209919871705e-18, -8.533624017601946e-20,
 -1.652671001244376e-21,  1.766325438041467e+00, -5.914777307743560e-03, -8.702734626769532e-05, -6.349175136649872e-07,  4.927737190944659e-09,  2.079895489769787e-10,
  2.179303811362469e-12, -1.796632480236609e-14, -9.142571491330420e-16, -1.078078228242736e-17,  8.383714812750330e-20,  4.903764450867995e-21,  1.950114018351588e+00,
 -1.567770869724346e-03, -3.521617312159479e-05, -6.570471924196766e-07, -1.040788834747172e-08, -1.343280013036572e-10, -1.164322800387390e-12,  2.265667231306990e-15,
  3.803065965007117e-16,  1.021190384479035e-17,  1.833117605090790e-19,  2.286232523694988e-21,  1.442402914291056e-02, -1.944641834350285e-04,  1.955631606156805e-06,
 -1.741767611512255e-08,  1.434594750975650e-10, -1.141810880546907e-12,  8.297693622631610e-15, -6.656793174060880e-17,  4.175147662981075e-19, -7.752645533983473e-22,
  1.164902386012335e-22,  1.975143269356198e-24,  5.779570322772064e-02, -7.726409835857096e-04,  7.601435773448004e-06, -6.493587691086083e-08,  4.982306735488905e-10,
 -3.558180320654343e-12,  2.126587646668915e-14, -1.389326560844959e-16,  4.038015263795949e-19,  8.665284785570909e-21,  3.713454312971725e-22,  8.865930718145142e-24,
  1.304089483535280e-01, -1.717664108571028e-03,  1.624117810163896e-05, -1.280513699233189e-07,  8.428605763012107e-10, -4.494967863626033e-12,  9.651990871256830e-15,
  4.794015272852881e-17, -2.088000615235228e-18,  4.061357760283016e-20,  7.528945980509416e-22,  2.070158137758826e-23,  2.327334752026279e-01, -2.996982430650269e-03,
  2.659963158306811e-05, -1.817635496547786e-07,  8.343399149620524e-10, -4.431082361717780e-13, -5.170217248664871e-14,  5.513092642166973e-16, -5.392647229161614e-18,
  5.969375219328139e-20,  1.750027474600884e-21,  3.422934445883537e-23,  3.653675853076410e-01, -4.554222394625306e-03,  3.663484258791758e-05, -1.901560827710974e-07,
  8.170374038972192e-11,  1.060984846705787e-11, -1.440135677748446e-13,  7.381918354246074e-16, -6.184431493368221e-19, -1.255334703408792e-20,  3.729057409291784e-21,
  5.501329411195410e-23,  5.289258731807163e-01, -6.294216619458256e-03,  4.325722042778350e-05, -1.085916822959860e-07, -1.659058661225934e-09,  2.480876598681540e-11,
 -1.529777255489576e-13, -8.433425815368123e-16,  2.004421215872455e-17, -9.895519867157174e-20,  4.425172150459998e-21,  1.140526796476729e-22,  7.237752892343817e-01,
 -8.055977091233407e-03,  4.200221324965928e-05,  1.048224828150300e-07, -4.025814153417548e-09,  2.587669745823310e-11,  1.314246330075107e-13, -4.648127266393169e-15,
  2.590801174833682e-17,  3.617676697480124e-19,  4.230017360178659e-22,  1.806230059832679e-22,  9.494076662830172e-01, -9.564581214893973e-03,  2.696955051261330e-05,
  4.506344288279528e-07, -5.157767684747984e-09, -1.659815123141105e-11,  7.192078672395577e-13, -3.947408478577044e-15, -8.111269042585042e-17,  1.327608211855332e-18,
  1.184412671654437e-20,  1.758212346087365e-23,  1.202907996783984e+00, -1.035150831681258e-02, -7.610457939959321e-06,  7.835468381216216e-07, -8.827674034455187e-10,
 -1.072144353090030e-10,  4.279126360029555e-13,  1.556379796236564e-14, -1.483517412985861e-16, -2.262938636391395e-18,  5.123640168484084e-20,  6.915282730550280e-22,
  1.475115946176300e+00, -9.665464238424766e-03, -5.938694826104601e-05,  6.309693372926154e-07,  1.101931293668143e-08, -7.166865307041740e-11, -2.516199980074072e-12,
  5.355678659763302e-15,  5.792165637056304e-16,  7.277989237719415e-19, -1.274080169027801e-19, -4.556900608279989e-23,  1.741227968518511e+00, -6.639798272596398e-03,
 -9.402743509556091e-05, -5.201883719874425e-07,  9.551326857991213e-09,  2.506261582125314e-10,  1.215631210773234e-12, -5.231108191085274e-14, -1.182258265347974e-15,
 -2.290899057531349e-18,  3.566870510450613e-19,  7.027212128242142e-21,  1.943225262537676e+00, -1.884083283944028e-03, -4.419334222738881e-05, -8.465329661454218e-07,
 -1.335999828962819e-08, -1.597399994329657e-10, -8.639752685858208e-13,  2.193618615972253e-14,  9.050644607746992e-16,  1.963305811697483e-17,  2.864918014301726e-19,
  2.064688524372450e-21,  1.367619165658159e-02, -1.796178263525837e-04,  1.759671390464536e-06, -1.529480060666030e-08,  1.224715522356695e-10, -9.635125488976553e-13,
  6.624090512460774e-15, -5.257483173565637e-17,  4.957689654218053e-19,  5.741796888446984e-21,  2.083547968151602e-22,  1.789113897294043e-24,  5.482201154818201e-02,
 -7.148161354596959e-04,  6.867773282931080e-06, -5.750705579903892e-08,  4.318649840032936e-10, -3.092610138251089e-12,  1.762860890473601e-14, -1.173542545961708e-16,
  1.081936513938905e-18,  3.173378291591447e-20,  7.763493214514094e-22,  7.884506062406142e-24,  1.237887336204926e-01, -1.593658640235428e-03,  1.478255133168609e-05,
 -1.152718691073624e-07,  7.553540418233710e-10, -4.253157682035764e-12,  1.033091590144208e-14,  1.219999259230685e-17,  1.476644639417529e-19,  8.999361848812887e-20,
  1.704785348299814e-21,  1.869615124500396e-23,  2.211576445325524e-01, -2.792684174720782e-03,  2.449806833997215e-05, -1.685474995483845e-07,  8.142292526958730e-10,
 -1.515674650048845e-12, -3.824394531950254e-14,  4.297813711513386e-16, -1.593477882158738e-18,  1.623021170181189e-19,  3.372127972423495e-21,  3.225375701590088e-23,
  3.477224524900788e-01, -4.270233980849266e-03,  3.436722645597096e-05, -1.873320477810834e-07,  2.610024874694297e-10,  7.400054010771016e-12, -1.234549676710141e-13,
  7.449924850531810e-16,  2.238935853558295e-18,  1.887249180506090e-19,  6.314799176081823e-21,  5.083602143269629e-23,  5.044322802251148e-01, -5.953786142112880e-03,
  4.181055935437826e-05, -1.313734540902220e-07, -1.201144828350832e-09,  2.092459637033683e-11, -1.678450744223062e-13, -2.146574621529290e-16,  2.091482326182707e-17,
  1.813106794698472e-19,  9.489014698949936e-21,  9.823765437468202e-23,  6.922298898778888e-01, -7.715982693796695e-03,  4.289112213768771e-05,  4.467869943085519e-08,
 -3.486743281894239e-09,  2.757535800492368e-11,  1.496054360019953e-14, -3.590819273169061e-15,  4.130107514554986e-17,  5.518789946029462e-19,  9.134971213381506e-21,
  1.845404777181332e-22,  9.116130960275636e-01, -9.328616613016788e-03,  3.187398703235958e-05,  3.663500308247944e-07, -5.327389805816765e-09, -9.092775131517662e-13,
  5.802006488879365e-13, -5.682762965109871e-15, -2.422134315018758e-17,  1.856632693502354e-18,  1.525569576361085e-20,  1.004859950114296e-22,  1.161439197322551e+00,
 -1.037518049198637e-02,  1.638784232210803e-06,  7.529639501550044e-07, -2.892094236307730e-09, -9.231129155526646e-11,  7.881290655030577e-13,  9.962744525809631e-15,
 -1.864397772016885e-16,  2.981466041219463e-19,  7.387261675184753e-20,  2.825740740356694e-22,  1.435555913150134e+00, -1.010740589060153e-02, -5.081516190257769e-05,
  7.926188713512468e-07,  9.004999388431651e-09, -1.281738362547060e-10, -2.109658121546640e-12,  2.336101124323455e-14,  5.190799641669218e-16, -3.765803870820853e-18,
 -8.202785191419442e-20,  2.006123923193437e-21,  1.713128981701450e+00, -7.414000368633672e-03, -9.918376591350576e-05, -3.262565800176152e-07,  1.471494887482393e-08,
  2.579867708760701e-10, -7.680524820282345e-13, -8.811892746081083e-14, -9.361805111924793e-16,  1.775293611624447e-17,  6.219212987641824e-19,  3.722014090331189e-21,
  1.934912041427618e+00, -2.282146340602035e-03, -5.574264326602100e-05, -1.086701079678813e-06, -1.669241575356535e-08, -1.690962931969102e-10,  2.785635302497771e-13,
  6.455454836596439e-14,  1.833196732824411e-15,  3.207536886976683e-17,  3.034238457777986e-19, -2.472977528641626e-21,  1.298475785459985e-02, -1.662427041591555e-04,
  1.587281830666447e-06, -1.348124518830704e-08,  1.046821382694401e-10, -8.201552532144472e-13,  5.417328346449728e-15, -3.168414602119840e-17,  8.644033837080250e-19,
  1.480344678877829e-20,  2.143382641144213e-22, -2.422372458962905e-24,  5.206842066296492e-02, -6.625213772237848e-04,  6.217178143146124e-06, -5.107007706151040e-08,
  3.740030122376744e-10, -2.703758703541576e-12,  1.504494912966222e-14, -5.796240486192986e-17,  2.837753113840720e-18,  6.622977269308336e-20,  8.236301012299322e-22,
 -9.412850577969998e-24,  1.176421408626034e-01, -1.480732199512054e-03,  1.346903987810987e-05, -1.038530691756200e-07,  6.728152619368248e-10, -3.997085765557739e-12,
  1.132690577910295e-14,  8.311551584958489e-17,  4.745932807973752e-18,  1.665784273411187e-19,  1.835938094358428e-21, -2.128774393849935e-23,  2.103663765602056e-01,
 -2.604571045288960e-03,  2.255251356609798e-05, -1.558081429590419e-07,  7.757086626818658e-10, -2.288499312766673e-12, -2.584740000265040e-14,  5.003376039648305e-16,
  6.898377037802338e-18,  3.110157326636934e-19,  3.536850974026613e-21, -4.075388757331989e-23,  3.311772687355231e-01, -4.004206876509899e-03,  3.214868062401569e-05,
 -1.821256484010559e-07,  3.811391356727938e-10,  4.703656095688015e-12, -1.002036663153074e-13,  9.772323534988161e-16,  1.391851048617414e-17,  4.619641480584707e-19,
  6.475714007592302e-21, -6.998423490543095e-23,  4.812756991204701e-01, -5.625903925332467e-03,  4.013186717273618e-05, -1.474632844233782e-07, -8.229960013735536e-10,
  1.690864157575334e-11, -1.629429057330861e-13,  6.386932430530333e-16,  3.498247614310346e-17,  6.074657670095975e-19,  1.040594148659597e-20, -9.758562803577066e-23,
  6.620543289564199e-01, -7.371615649908104e-03,  4.311071573748512e-05, -6.708862309987965e-09, -2.938929524734674e-09,  2.689846340637392e-11, -6.351155416799937e-14,
 -1.867794814294643e-15,  6.923228412057897e-17,  1.022821008774233e-18,  1.232613430408466e-20, -1.045722459596810e-22,  8.748344142906392e-01, -9.057485704057506e-03,
  3.576045882430031e-05,  2.816680492356143e-07, -5.219390371075903e-09,  1.108468771312423e-11,  4.211582681854921e-13, -5.264584827484520e-15,  5.422950106396257e-17,
  2.499403544240740e-18,  1.446785111731728e-20, -2.360096694385576e-22,  1.120020634534186e+00, -1.032684781160459e-02,  1.033934483271890e-05,  6.930314028481116e-07,
 -4.529940128741546e-09, -7.069218969481245e-11,  9.893216997147134e-13,  4.750667667371977e-15, -1.214536385447264e-16,  3.280356248746279e-18,  6.854683041741554e-20,
 -6.420954260005183e-22,  1.394376666078888e+00, -1.047364358228705e-02, -4.053207635482288e-05,  9.136944297415465e-07,  5.997288976521147e-09, -1.692225764036411e-10,
 -1.246796083361072e-12,  3.736148621732901e-14,  3.484849171938884e-16, -5.017547444523253e-18,  2.075510491689457e-20,  2.156870029695183e-21,  1.681867398485768e+00,
 -8.218747093367947e-03, -1.015216015380513e-04, -5.143155938317490e-08,  1.947615095536522e-08,  2.073275567850616e-10, -3.523407021767781e-12, -1.028916955596357e-13,
  1.647383591625828e-16,  4.298530279763045e-17,  5.519153539788578e-19, -8.248581351496279e-21,  1.924802243061698e+00, -2.785040556691567e-03, -7.049395738814598e-05,
 -1.379723649602832e-06, -1.982201201233595e-08, -1.329495771543233e-10,  3.095497410378437e-12,  1.436283770804514e-13,  3.149532908365772e-15,  3.846592225434194e-17,
 -9.973498715186344e-20, -1.853241474864385e-20,  1.234419758325658e-02, -1.541642777272119e-04,  1.435037280039887e-06, -1.193073018968670e-08,  8.952576721991940e-11,
 -6.971157527277979e-13,  5.007428377204075e-15,  5.804457255780803e-18,  1.503340568226391e-18,  1.867373773919985e-20, -9.523258160446216e-23, -1.259305017921965e-23,
  4.951406703556088e-02, -6.151375710961001e-04,  5.638519579052744e-06, -4.549934861681624e-08,  3.234702803832420e-10, -2.349494300574107e-12,  1.508952005803622e-14,
  7.594856931293372e-17,  5.622781214447371e-18,  8.038549824054237e-20, -4.196556674676605e-22, -5.094060226002761e-23,  1.119270743477147e-01, -1.377787796222315e-03,
  1.228480615058348e-05, -9.371161299467307e-08,  5.958943435008468e-10, -3.674174198167353e-12,  1.676562314713167e-14,  3.418992683599489e-16,  1.162456711698860e-17,
  1.969219113457869e-19, -1.023506424957340e-21, -1.176178974738335e-22,  2.002973842189432e-01, -2.431422406406174e-03,  2.075567869502253e-05, -1.437913161709172e-07,
  7.250460284028782e-10, -2.704589592517972e-12, -6.902194459044013e-15,  9.214852734319946e-16,  1.981336115048947e-17,  3.716034596764834e-19, -1.812083368962130e-21,
 -2.190754401981710e-22,  3.156611333459173e-01, -3.755649441565489e-03,  3.000247141426289e-05, -1.753950814330958e-07,  4.537108694114413e-10,  2.694376908383584e-12,
 -6.380434301010036e-14,  1.728472838885623e-15,  3.381351134101923e-17,  5.847938594507459e-19, -2.497456735520019e-21, -3.656680744125767e-22,  4.594027022487603e-01,
 -5.312126719422569e-03,  3.829379428549809e-05, -1.581296746180051e-07, -5.217319676669611e-10,  1.336186026238185e-11, -1.256079745562439e-13,  2.173281493391014e-15,
  6.226778322669204e-17,  8.195317588623018e-19, -3.222848915996102e-21, -5.651087981202310e-22,  6.332560525288433e-01, -7.027811059012980e-03,  4.276552013852942e-05,
 -4.952361089720843e-08, -2.418989853455112e-09,  2.503397062020158e-11, -7.868116959487732e-14,  1.012755186034002e-15,  1.122332485690234e-16,  1.243413296927545e-18,
 -6.528342723218237e-21, -8.196229950142520e-22,  8.391960677678540e-01, -8.759281455193335e-03,  3.864838274869708e-05,  2.004350511701620e-07, -4.907180255381131e-09,
  1.970606235477142e-11,  3.121832957098659e-13, -2.012073971781039e-15,  1.499534073831592e-16,  2.622365497562241e-18, -1.568441467417032e-20, -1.242346965461005e-21,
  1.078929472827463e+00, -1.021219856208228e-02,  1.817847741658008e-05,  6.105705802871484e-07, -5.697315733586727e-09, -4.566521655603719e-11,  1.089010420996356e-12,
  3.201848858280662e-15,  3.520311727314478e-17,  5.008235086683035e-18,  5.285986905240332e-21, -2.359911845482392e-21,  1.351904972090088e+00, -1.075267752830379e-02,
 -2.910793489070349e-05,  9.813259223500705e-07,  2.404180238779370e-09, -1.854893458091150e-10, -6.967264661020316e-14,  4.593034576297439e-14,  1.995202428556413e-16,
 -3.015591922157537e-18,  5.502989380630755e-20, -1.156159587829598e-21,  1.647372006615143e+00, -9.027810571665145e-03, -1.001497244055265e-04,  2.878155643136380e-07,
  2.255335544066079e-08,  9.034933091539268e-11, -6.073044244340092e-12, -6.958954755796273e-14,  1.979542471357415e-15,  5.313734033101922e-17, -1.565616080957659e-19,
 -2.338964254703594e-20,  1.912421482802436e+00, -3.420778720808605e-03, -8.902396185526031e-05, -1.712523263402769e-06, -2.134830049897506e-08,  2.193662331751383e-12,
  8.719095508824062e-12,  2.637011275685356e-13,  4.187624477774912e-15,  9.274338909729116e-18, -1.615597927205222e-18, -5.346488626511239e-20,  1.174962736848559e-02,
 -1.432333200225688e-04,  1.300024449205260e-06, -1.060316623205188e-08,  7.682893530490414e-11, -5.689872906542336e-13,  5.931863521495469e-15,  6.261832826996585e-17,
  1.938462792603052e-18, -6.036794745880957e-23, -9.344425047073237e-22, -2.511700877657762e-23,  4.714039478545916e-02, -5.721288374857840e-04,  5.122096541213847e-06,
 -4.067894552642757e-08,  2.803897340826039e-10, -1.939062855367895e-12,  2.011703331746862e-14,  2.936169653280947e-16,  7.531423704091526e-18,  3.092976452027809e-21,
 -3.824305826430301e-21, -1.020441240644247e-22,  1.066055796416336e-01, -1.283850844378495e-03,  1.121512940187195e-05, -8.473921900600308e-08,  5.274531201192860e-10,
 -3.108909523642853e-12,  3.248668912662735e-14,  8.071091417783307e-16,  1.639785992629040e-17,  1.607924423551786e-20, -8.899596585946896e-21, -2.363073724733450e-22,
  1.908931302963709e-01, -2.272085867642182e-03,  1.909800053598327e-05, -1.326221037956710e-07,  6.718068223255349e-10, -2.477658564764048e-12,  2.955810382109373e-14,
  1.732668374697215e-15,  2.894757065499285e-17,  3.876853849923994e-20, -1.646604028386560e-20, -4.395442380832809e-22,  3.011054241508833e-01, -3.523921578446429e-03,
  2.794284623310915e-05, -1.677689178873259e-07,  4.969146150316163e-10,  1.883969592562124e-12,  2.553564788595550e-15,  3.089881998694669e-15,  4.816822918890729e-17,
  5.093718440523765e-20, -2.691346488447395e-20, -7.319021023499555e-22,  4.387547034621399e-01, -5.013489134411132e-03,  3.635450718781595e-05, -1.644782111715339e-07,
 -2.784400177221173e-10,  1.132762414541947e-11, -3.293579842985067e-14,  4.553812048030604e-15,  8.184832425914139e-17,  1.667741400538616e-20, -4.120018916220623e-20,
 -1.141980117725810e-21,  6.058244133525506e-01, -6.688684532154592e-03,  4.195524886413248e-05, -8.430717444170474e-08, -1.932637121924107e-09,  2.392925721416187e-11,
  5.838273506870337e-15,  5.183255208995621e-15,  1.411328907002338e-16, -1.026590244367298e-20, -6.273813924712752e-20, -1.707006978009752e-21,  8.047907075357965e-01,
 -8.441775717536007e-03,  4.059681217479511e-05,  1.254718752639005e-07, -4.439551471412266e-09,  2.714445444224824e-11,  3.356178975303667e-13,  4.045234752656255e-15,
  2.162832953176159e-16,  5.051308894735948e-19, -9.985944638671449e-20, -2.546916625847377e-21,  1.038415670125635e+00, -1.003907304183732e-02,  2.493293640780761e-05,
  5.135620387416507e-07, -6.340643816363754e-09, -1.816350540413026e-11,  1.220471651982023e-12,  7.014034302406225e-15,  1.886940406196440e-16,  2.531553980578973e-18,
 -1.437266647396195e-19, -4.328952807140161e-21,  1.308503669234555e+00, -1.093806374072314e-02, -1.722271635759677e-05,  9.904727286501671e-07, -1.214812531795469e-09,
 -1.710966614115079e-10,  1.291454164672957e-12,  5.081341821165150e-14,  1.045708567381537e-16, -3.350556222922473e-18, -1.098418847955632e-19, -6.292253529095037e-21,
  1.609689016158933e+00, -9.808975516806564e-03, -9.449828988540706e-05,  6.546939783300031e-07,  2.278914911903008e-08, -6.995653365962747e-11, -6.868256128959896e-12,
  2.097609515768079e-14,  3.508044853717618e-15,  2.394142051348858e-17, -1.327911471455289e-18, -2.658356239172249e-20,  1.897175748970893e+00, -4.220887499888916e-03,
 -1.115778874677466e-04, -2.039593943056009e-06, -1.853623456199398e-08,  3.149326530732271e-10,  1.790969041790183e-11,  3.852216266742585e-13,  2.677986111813409e-15,
 -1.146199687829352e-16, -4.841765196807794e-18, -8.785244714326084e-20,  1.119671706852198e-02, -1.333219900808963e-04,  1.179813483195485e-06, -9.456486847858227e-09,
  6.704995337127266e-11, -3.988892714850281e-13,  8.488688728960541e-15,  1.151158018043319e-16,  9.801615529121712e-19, -6.109347507727539e-20, -2.111792403712766e-21,
 -2.378811348766290e-23,  4.493084539803169e-02, -5.330311496423946e-04,  4.659680597848797e-06, -3.647345286820889e-08,  2.472390967939023e-10, -1.331545457807898e-12,
  3.146514835650340e-14,  4.975948011663703e-16,  3.737631046063735e-18, -2.460440295956374e-19, -8.611852972939862e-21, -9.682594418141142e-23,  1.016433748639432e-01,
 -1.198058232324159e-03,  1.024700313780421e-05, -7.674630292883835e-08,  4.752003321165485e-10, -2.001194538129365e-12,  6.190527129090202e-14,  1.250886126743741e-15,
  7.900838847692375e-18, -5.627403728771419e-19, -1.999755187496940e-20, -2.247878791489973e-22,  1.821005289873613e-01, -2.125488419065023e-03,  1.756956787913031e-05,
 -1.222127338596264e-07,  6.338040305148247e-10, -1.085649327845783e-12,  9.011435700574977e-14,  2.514183929854818e-15,  1.352346931246055e-17, -1.034531027322218e-18,
 -3.712572697359109e-20, -4.193018834124274e-22,  2.874442677500034e-01, -3.308293512013882e-03,  2.597866502107552e-05, -1.594810338578644e-07,  5.430897733028148e-10,
  3.150264056600807e-12,  1.090601222218546e-13,  4.386183090326333e-15,  2.235590225055363e-17, -1.716390175789340e-18, -6.134988825611670e-20, -7.009208148074073e-22,
  4.192698344112820e-01, -4.730606591288876e-03,  3.436150654724545e-05, -1.671152274949447e-07, -4.798175055555995e-11,  1.234984138391754e-11,  1.284621280657498e-13,
  6.760396832521368e-15,  3.986657055861517e-17, -2.711095858822166e-18, -9.508621682711636e-20, -1.101841927971048e-21,  5.797338580867398e-01, -6.357578259327138e-03,
  4.077400409761107e-05, -1.113347524731537e-07, -1.438334457721060e-09,  2.629980712840682e-11,  2.097901622351342e-13,  9.053228440351443e-15,  7.621936119251615e-17,
 -4.140605405610538e-18, -1.437793818740992e-19, -1.667908351785206e-21,  7.716810430152941e-01, -8.112141777065068e-03,  4.169574966163768e-05,  5.927229102097774e-08,
 -3.802944969723011e-09,  3.732410290779127e-11,  5.416769255813189e-13,  1.025354709613001e-14,  1.336635511732771e-16, -5.908032334074650e-18, -2.208549960418147e-19,
 -2.496243846957207e-21,  9.986948779400261e-01, -9.816700112813386e-03,  3.048035984946651e-05,  4.108767343652840e-07, -6.391384571365720e-09,  1.420178177051417e-11,
  1.504934227466422e-12,  1.300958378989809e-14,  1.278639424613903e-16, -7.261978410042454e-18, -3.450453855839005e-19, -4.118266829934048e-21,  1.264550334107945e+00,
 -1.102887991225847e-02, -5.559800108125670e-06,  9.458330254151979e-07, -4.210228001724179e-09, -1.228067660038692e-10,  2.733433238446378e-12,  5.077544247736312e-14,
 -1.712219565942211e-16, -1.422007485052544e-17, -4.443935710052360e-19, -7.615985840425487e-21,  1.568999438077193e+00, -1.052750045662594e-02, -8.452827745146209e-05,
  9.996051990759109e-07,  1.985664137025113e-08, -2.146848412111740e-10, -4.665111418996344e-12,  1.346925427406774e-13,  3.165604241595663e-15, -4.853571355125176e-17,
 -2.153851505924014e-18, -7.146544253239254e-21,  1.878345670767765e+00, -5.215803835522157e-03, -1.375386832682116e-04, -2.258652124769597e-06, -7.037169426009053e-09,
  8.785498655559127e-10,  2.896598748977219e-11,  3.602100571124821e-13, -5.813967102940239e-15, -3.774558949557384e-16, -7.762832426462855e-18, -1.033083101065320e-20,
  1.068161247614350e-02, -1.243196848014151e-04,  1.072548104727951e-06, -8.435313055480456e-09,  6.137796744540610e-11, -1.555948615115754e-13,  1.169465178427492e-14,
  9.343931447178339e-17, -2.910868169367848e-18, -1.566776216185017e-19, -2.302804827325294e-21,  2.694062936622366e-23,  4.287059634314013e-02, -4.974389148733139e-04,
  4.245001455735607e-06, -3.268479334849536e-08,  2.293142629866404e-10, -4.064080172327944e-13,  4.522789588584532e-14,  4.026847427966284e-16, -1.201804852606493e-17,
 -6.358419650930687e-19, -9.396439464713964e-21,  1.093247729531260e-22,  9.700944046641116e-02, -1.119639232425500e-03,  9.370640570565319e-06, -6.937043904116821e-08,
  4.529175139818451e-10, -9.123886137015417e-14,  9.623329196206180e-14,  1.010520218245125e-15, -2.837949731162030e-17, -1.468326538178754e-18, -2.185610047596983e-20,
  2.519089078170563e-22,  1.738706425431770e-01, -1.990626458753246e-03,  1.616359071448334e-05, -1.121037967883004e-07,  6.394875748377031e-10,  1.925355565180996e-12,
  1.587591826098702e-13,  2.036980901699452e-15, -5.349166288327166e-17, -2.718245438255594e-18, -4.072046325099625e-20,  4.630086644290425e-22,  2.746148480634126e-01,
 -3.107965638558337e-03,  2.411968472084112e-05, -1.501030377143030e-07,  6.423270611367687e-10,  7.247024483851812e-12,  2.289401199723021e-13,  3.593206075548943e-15,
 -8.872408281898102e-17, -4.506487155424962e-18, -6.768951351485404e-20,  7.559185374492845e-22,  4.008844994851049e-01, -4.463728935570151e-03,  3.236039011192497e-05,
 -1.656739225583120e-07,  2.454388199018814e-10,  1.773018142626267e-11,  3.152609266897512e-13,  5.667570998823011e-15, -1.343076420692846e-16, -7.050728032709084e-18,
 -1.056949872192990e-19,  1.153963517309291e-21,  5.549469708341384e-01, -6.037079327953204e-03,  3.931839373256969e-05, -1.297776011853530e-07, -8.407704459166196e-10,
  3.447184626302162e-11,  4.664253354098326e-13,  7.886317221512562e-15, -1.887394948856423e-16, -1.071420759722155e-17, -1.606792807287053e-19,  1.706106236258610e-21,
  7.399027334636182e-01, -7.776703279858651e-03,  4.206913726499449e-05,  5.206531812934161e-09, -2.901778274584878e-09,  5.399088390598788e-11,  8.435085932626541e-13,
  9.256120205746269e-15, -2.566507349043695e-16, -1.598302804759619e-17, -2.469204859561531e-19,  2.517421052014676e-21,  9.599445808813964e-01, -9.554838635984619e-03,
  3.481338743542801e-05,  3.129773801616818e-07, -5.715665979738778e-09,  5.480949686156929e-11,  1.866495328762860e-12,  9.976033461953469e-15, -4.133242583563139e-16,
 -2.319129846080852e-17, -3.956530119195465e-19,  3.654683775928533e-21,  1.220415910149063e+00, -1.102926468902706e-02,  5.317785946827457e-06,  8.628495555905394e-07,
 -5.900881650321265e-09, -4.137307944894993e-11,  3.973718495564047e-12,  3.312630888595836e-14, -1.066201545252022e-15, -3.651204990856880e-17, -5.835061961290777e-19,
  4.477961272842917e-21,  1.525620107394966e+00, -1.115070335140317e-02, -7.078423253913497e-05,  1.278340233478058e-06,  1.479892545754744e-08, -2.721573568112017e-10,
  1.425964708263581e-13,  1.913924011742162e-13, -1.153196358255940e-16, -1.304915398370693e-16, -1.648207925827163e-18,  3.352219065587432e-20,  1.855109564602621e+00,
 -6.424847051902021e-03, -1.646078152852447e-04, -2.190037723825541e-06,  1.813304868862346e-08,  1.659101795807742e-09,  3.399410391005725e-11, -9.943848233541546e-14,
 -2.436669674346257e-14, -6.113244375862683e-16, -1.170891537766440e-18,  3.667318450224698e-19,  1.020087680913287e-02, -1.161276342123355e-04,  9.771651562063300e-07,
 -7.462283069339507e-09,  6.120615820625999e-11,  1.401897910578459e-13,  1.205451897137159e-14, -1.035746731851757e-16, -9.637350009921761e-18, -1.925934719794997e-19,
  1.434135434863880e-21,  1.524947741485458e-22,  4.094636440579897e-02, -4.649856195532766e-04,  3.874728873190463e-06, -2.901905514113255e-08,  2.326314334276212e-10,
  7.475293964185385e-13,  4.725129557602271e-14, -4.037869568738328e-16, -3.934982644530673e-17, -7.832908954410657e-19,  5.798770499505252e-21,  6.205522707737053e-22,
  9.267571644354064e-02, -1.047879980841922e-03,  8.582042023447302e-06, -6.200577337078160e-08,  4.757236252474699e-10,  2.401247624940954e-12,  1.028736622872655e-13,
 -8.730951051488385e-16, -9.160598904191892e-17, -1.814535680112960e-18,  1.330129924309254e-20,  1.437848062154337e-21,  1.661584854824783e-01, -1.866520425304596e-03,
  1.488171917409821e-05, -1.013422613457919e-07,  7.192973260959927e-10,  6.126480387035445e-12,  1.752642337845181e-13, -1.482814152569312e-15, -1.707498607589358e-16,
 -3.370930518621592e-18,  2.436171640392128e-20,  2.667884292435400e-21,  2.625577564245235e-01, -2.922025299381156e-03,  2.238593679241804e-05, -1.383413917880554e-07,
  8.480082844099958e-10,  1.346205805018092e-11,  2.623210546569599e-13, -2.245926978788597e-15, -2.833803559609972e-16, -5.606141622530988e-18,  3.973802515145923e-20,
  4.418782182345666e-21,  3.835348921820372e-01, -4.212701561687163e-03,  3.040901806221687e-05, -1.584570152218117e-07,  6.849598961689051e-10,  2.645532830208202e-11,
  3.707828805609626e-13, -3.325239580448287e-15, -4.390815437364336e-16, -8.794874716748130e-18,  6.069439474763412e-20,  6.875034217787636e-21,  5.314176363029942e-01,
 -5.728933537962584e-03,  3.770523497643309e-05, -1.370483713959756e-07, -2.668815331602710e-11,  4.723850240343369e-11,  5.373116075893295e-13, -5.293432975385747e-15,
 -6.525793845325315e-16, -1.342531478377500e-17,  8.901729795357372e-20,  1.037046686087090e-20,  7.094684255765799e-01, -7.440599995430905e-03,  4.189242638250820e-05,
 -3.141943584329000e-08, -1.605799305054316e-09,  7.582599776085746e-11,  8.897672114075793e-13, -9.665559201865095e-15, -9.539733954800254e-16, -2.032501446566203e-17,
  1.260147794788411e-19,  1.556947111927684e-20,  9.223039621604399e-01, -9.262763835090396e-03,  3.806464162662054e-05,  2.327873803126517e-07, -4.160247043402421e-09,
  1.005950614403774e-10,  1.816580509824605e-12, -1.906009873274316e-14, -1.449339446026951e-15, -3.067538617584850e-17,  1.705499930351522e-19,  2.390248766459575e-20,
  1.176447207597184e+00, -1.094693865892783e-02,  1.509563254158002e-05,  7.672264807096425e-07, -5.725130741954384e-09,  5.991365335932046e-11,  4.198398552408110e-12,
 -2.566764875631226e-14, -2.679094687617400e-15, -4.743965160068116e-17,  2.861473337570882e-19,  3.832163411245912e-20,  1.479987049786434e+00, -1.165199523343598e-02,
 -5.419764303190357e-05,  1.473518990763794e-06,  9.802129739390394e-09, -2.095505121841173e-10,  4.674471641967531e-12,  1.036814065319158e-13, -5.492945538821807e-15,
 -1.499718444590103e-16,  1.133324767572712e-18,  9.611173902167330e-20,  1.826620644763751e+00, -7.839101395759961e-03, -1.879158605607890e-04, -1.592912436666290e-06,
  5.870833880036012e-08,  2.333737791874868e-09,  1.715006843442167e-11, -1.199317593412560e-12, -4.190197947723507e-14, -1.816218739105129e-16,  2.592823312220847e-17,
  7.907392640547575e-19,  9.751457684711803e-03, -1.086515469677289e-04,  8.936326248320443e-07, -6.446523368544191e-09,  6.646345855182699e-11,  3.542062048186608e-13,
  3.960916779676686e-15, -4.964371996732113e-16, -1.358706505100140e-17,  3.344687762803393e-20,  1.039017958439984e-20,  2.168856181716677e-22,  3.914630343724968e-02,
 -4.353159214681545e-04,  3.549508447648485e-06, -2.512244210568245e-08,  2.571712164340914e-10,  1.580643437079576e-12,  1.475233089995019e-14, -2.006716193715197e-15,
 -5.542935267814289e-17,  1.355508828583988e-19,  4.228421206882040e-20,  8.846489883746304e-22,  8.861698525957477e-02, -9.820660714800757e-04,  7.885622952355311e-06,
 -5.389082977100542e-08,  5.445144627204685e-10,  4.192396555303159e-12,  2.912428135372480e-14, -4.601643651019300e-15, -1.289286280746735e-16,  3.111040642403136e-19,
  9.800398381309025e-20,  2.058148171909116e-21,  1.589230994896768e-01, -1.752124774345149e-03,  1.373938015657771e-05, -8.865126716824036e-08,  8.769055908394406e-10,
  9.118212891828713e-12,  4.187901693439423e-14, -8.430426051108374e-15, -2.403289311787110e-16,  5.661047535188429e-19,  1.819852079982557e-19,  3.842120829203992e-21,
  2.512176714549741e-01, -2.749325037650448e-03,  2.081713425019501e-05, -1.223192773635236e-07,  1.169099644142216e-09,  1.781361735182492e-11,  4.686858625492101e-14,
 -1.378858249770364e-14, -3.997731582844253e-16,  9.035943797539840e-19,  3.018802465195001e-19,  6.417603235056086e-21,  3.671589071453248e-01, -3.976805976796971e-03,
  2.859215387305960e-05, -1.428449770448714e-07,  1.286179872117590e-09,  3.238999764686990e-11,  4.067138969190569e-14, -2.127477301693877e-14, -6.233564130233636e-16,
  1.315960990534766e-18,  4.707907346067102e-19,  1.009746660397251e-20,  5.090948598544975e-01, -5.433801325742521e-03,  3.609128795538171e-05, -1.293146967313290e-07,
  1.021110517319918e-09,  5.559886202198701e-11,  3.497036117135929e-14, -3.216540601527184e-14, -9.376303128955660e-16,  1.778109953790401e-18,  7.119351850565954e-19,
  1.545062353108700e-20,  6.803734604739053e-01, -7.107283438208246e-03,  4.141462148230099e-05, -4.398190851600430e-08,  8.189397289229524e-11,  8.987984743673332e-11,
  9.770433219757383e-14, -4.933593105329229e-14, -1.392677897181669e-15,  2.292883637703610e-18,  1.069216512560137e-18,  2.361061907296958e-20,  8.858782547672022e-01,
 -8.948037527013390e-03,  4.053202295024479e-05,  1.843995666368535e-07, -1.786652475841110e-09,  1.316331363302909e-10,  4.908641421651003e-13, -7.933663681339774e-14,
 -2.118451021936922e-15,  3.349602253769812e-18,  1.636096240009926e-18,  3.712840895397916e-20,  1.132957256318372e+00, -1.079077931237827e-02,  2.380888641261509e-05,
  6.902479379311148e-07, -3.633630899206363e-09,  1.409588444127878e-10,  2.060997535818648e-12, -1.325303924037549e-13, -3.672499724512260e-15,  8.456065741612940e-18,
  2.698658300922157e-18,  6.227649682970572e-20,  1.432627291977333e+00, -1.201245696023313e-02, -3.569126223913662e-05,  1.603491141295646e-06,  6.846181372574020e-09,
 -8.683873022616240e-11,  4.420886482541294e-12, -1.403504508877925e-13, -8.893923692127871e-15, -3.217584281368283e-18,  6.460338146624440e-18,  1.270144553934632e-19,
  1.792163845593058e+00, -9.399294605225190e-03, -1.998198615475576e-04, -2.719548091264123e-07,  1.060017080558786e-07,  2.193596355752207e-09, -3.438157356195946e-11,
 -2.380732458193964e-12, -2.217955689937283e-14,  1.436318655289484e-15,  4.843057331936322e-17, -1.210331755617432e-19,  9.330685924418146e-03, -1.017932959880835e-04,
  8.228903965449916e-07, -5.326834266849228e-09,  7.313487495554463e-11,  2.377244321152233e-13, -1.518005455385908e-14, -8.162883092162459e-16, -3.137957271253517e-18,
  5.729004801586783e-19,  1.387692930071912e-20, -1.543306741425262e-22,  3.746002452734643e-02, -4.080533618781282e-04,  3.273772621498863e-06, -2.075808666570498e-08,
  2.868046614874975e-10,  1.077861795099339e-12, -6.282593630794730e-14, -3.312833139640636e-15, -1.289989736676476e-17,  2.333112638535252e-18,  5.658229280486413e-20,
 -6.263729833174656e-22,  8.481101273962122e-02, -9.214133707664060e-04,  7.293957382613750e-06, -4.452160228579555e-08,  6.226614541068000e-10,  2.920313686090669e-12,
 -1.495158273809858e-13, -7.644497644608179e-15, -3.036585827166404e-17,  5.413047974056802e-18,  1.315693939311695e-19, -1.444997063901605e-21,  1.521280478716015e-01,
 -1.646212720552053e-03,  1.276568750954627e-05, -7.320235235247398e-08,  1.045996018993062e-09,  6.497998779046080e-12, -2.870988673821450e-13, -1.411472211524063e-14,
 -5.745562082624493e-17,  1.006278116222024e-17,  2.454544550771417e-19, -2.664755583299761e-21,  2.405446334047088e-01, -2.588314573297315e-03,  1.947307285168228e-05,
 -1.008583604715291e-07,  1.498347883445679e-09,  1.298548920450114e-11, -4.940222281687854e-13, -2.326910684897535e-14, -9.710481433834012e-17,  1.670739596687265e-17,
  4.097079787256911e-19, -4.378521725731623e-21,  3.516988593038085e-01, -3.754527050356185e-03,  2.702238968470800e-05, -1.172717601540364e-07,  1.884562427208576e-09,
  2.415668447505558e-11, -7.968590266728196e-13, -3.610088496048625e-14, -1.534904427357132e-16,  2.606524360229185e-17,  6.441317741637405e-19, -6.743648047550101e-21,
  4.879277890038775e-01, -5.150917337727823e-03,  3.467340364483540e-05, -1.043997956130747e-07,  2.052070333687119e-09,  4.252529804057493e-11, -1.230160338238456e-12,
 -5.452803986722653e-14, -2.323076744747429e-16,  3.940985149684209e-17,  9.843194746424760e-19, -1.003960752919280e-20,  6.526038273833532e-01, -6.777920564154308e-03,
  4.095294105346213e-05, -2.871946067582728e-08,  1.766566433403843e-09,  7.102870571159296e-11, -1.825989170669840e-12, -8.260161131196879e-14, -3.418413722586511e-16,
  5.924129023628676e-17,  1.499116621993097e-18, -1.481358249232724e-20,  8.507482091354676e-01, -8.615216182037982e-03,  4.265986809062883e-05,  1.766278551482379e-07,
  7.466443650101396e-10,  1.097311983581932e-10, -2.555026590354576e-12, -1.298322368220081e-13, -5.044422251573418e-16,  9.145193151340423e-17,  2.337504124668260e-18,
 -2.236016060594412e-20,  1.090226440508519e+00, -1.056794014602238e-02,  3.184077355511716e-05,  6.558620874306692e-07, -6.847237540060450e-10,  1.337599667221802e-10,
 -3.073117615539992e-12, -2.197254242385280e-13, -8.912226625431982e-16,  1.548618019215571e-16,  3.899372663216314e-18, -3.744836229534621e-20,  1.384130760534191e+00,
 -1.221926079222148e-02, -1.583578245767725e-05,  1.703004034589541e-06,  5.692721595864536e-09, -5.813932543974606e-11, -3.100474697857403e-12, -3.678739377931330e-13,
 -3.325439028997678e-15,  3.273633832172445e-16,  8.422670296469377e-18, -1.001215744224001e-19,  1.751393473280650e+00, -1.097914774982467e-02, -1.916684228095535e-04,
  1.706843150760385e-06,  1.360565497803362e-07,  5.484690358270985e-10, -1.007954909715355e-10, -1.939881441275836e-12,  5.692804594050112e-14,  2.578767078348746e-15,
 -8.785948547574934e-18, -2.419820043854544e-18,  8.936302498679315e-03, -9.544577389632695e-05,  7.660609871343441e-07, -4.146132776286278e-09,  7.242927759958840e-11,
 -3.898808508859915e-13, -3.571389023646731e-14, -5.049643482521826e-16,  2.399979196736006e-17,  7.908231006547809e-19, -7.647719871640183e-21, -7.660175075229606e-22,
  3.587872525929350e-02, -3.827806082153906e-04,  3.052569095139310e-06, -1.610992595250545e-08,  2.859083648339468e-10, -1.498735096266304e-12, -1.461776636158783e-13,
 -2.048210456854178e-15,  9.767605071237361e-17,  3.223606125497446e-18, -3.111692961344168e-20, -3.124459240752518e-21,  8.123892185199108e-02, -8.650265728483070e-04,
  6.820571583536806e-06, -3.435886445505555e-08,  6.281590108239682e-10, -3.135237303221641e-12, -3.419123525477055e-13, -4.721811445682605e-15,  2.264226259719102e-16,
  7.491337374196486e-18, -7.209280011065847e-20, -7.269450778573047e-21,  1.457422954193654e-01, -1.547309643365040e-03,  1.199038528830245e-05, -5.593434236092104e-08,
  1.075603743517025e-09, -4.949826012069274e-12, -6.424621062801484e-13, -8.706147553645493e-15,  4.205997667169986e-16,  1.396063638572395e-17, -1.337885432298601e-19,
 -1.357326132408187e-20,  2.304958738190092e-01, -2.436949186194844e-03,  1.841249466776374e-05, -7.567105014735953e-08,  1.587624278280643e-09, -6.387678488811774e-12,
 -1.080030869501360e-12, -1.432566793494662e-14,  6.982694550452573e-16,  2.325946026616707e-17, -2.217599301261847e-19, -2.268283781586551e-20,  3.371049581834332e-01,
 -3.543436112584058e-03,  2.580768835787677e-05, -8.463379512909284e-08,  2.095954999017936e-09, -6.632782385279274e-12, -1.706062016919330e-12, -2.217210914359506e-14,
  1.090957027139846e-15,  3.645658397712002e-17, -3.456625141868414e-19, -3.572133801286561e-20,  4.678718166755674e-01, -4.877931491888600e-03,  3.363906209720885e-05,
 -6.688179042514883e-08,  2.485764075503025e-09, -4.614692524560656e-12, -2.602809421571951e-12, -3.339416830122971e-14,  1.656461256487011e-15,  5.544947488055815e-17,
 -5.233791985431115e-19, -5.473305167813635e-20,  6.261460059685017e-01, -6.451106465244560e-03,  4.081492421496555e-05,  7.749386996394710e-09,  2.564871032394651e-09,
  5.431520169597576e-13, -3.902749390114733e-12, -5.044898701928943e-14,  2.510244900453055e-15,  8.390433699323663e-17, -7.923322417086282e-19, -8.377880048104371e-20,
  8.169837978972065e-01, -8.265116984288176e-03,  4.490935080964184e-05,  2.015752428733559e-07,  2.039168709666562e-09,  6.563924462039905e-12, -5.814163780442672e-12,
 -7.927994961937148e-14,  3.912621633143423e-15,  1.299979754457400e-16, -1.248402657731530e-18, -1.321234912968951e-19,  1.048513937503876e+00, -1.028175190427852e-02,
  3.971499410270530e-05,  6.602264597035519e-07,  7.632650600303757e-10, -1.096364702567404e-11, -8.608316340394962e-12, -1.357789367290732e-13,  6.542007991518353e-15,
  2.171739219261008e-16, -2.229064783118058e-18, -2.264274476861039e-19,  1.335131787951255e+00, -1.226278679515231e-02,  5.085554455785325e-06,  1.777183411807853e-06,
  2.942909289307915e-09, -2.553236713777436e-10, -1.274363241793723e-11, -2.371263302076943e-13,  1.227314716263461e-14,  4.460532418408387e-16, -5.497858498727888e-18,
 -4.916648094147112e-19,  1.704592087096279e+00, -1.239365256457025e-02, -1.582279234279949e-04,  3.826333294848079e-06,  1.198369137658386e-07, -2.238656646778737e-09,
 -1.174102895737831e-10,  1.079313488416146e-12,  1.164683218783119e-13,  3.819530888806468e-17, -1.087269223859773e-16, -1.090741724036834e-18,  8.566487902876835e-03,
 -8.949751125046110e-05,  7.228437195639375e-07, -3.099159094472691e-09,  5.546217752200884e-11, -1.307358460726783e-12, -3.562757511563702e-14,  5.934407065271332e-16,
  3.896093910337747e-17, -1.516373337563601e-19, -3.543087394841692e-20, -2.118384497048367e-22,  3.439532472069761e-02, -3.590591479521905e-04,  2.885055311142318e-06,
 -1.197771465684700e-08,  2.184330176625435e-10, -5.250110089504105e-12, -1.456084253615053e-13,  2.424454002485876e-15,  1.586697498800880e-16, -6.187007528141840e-19,
 -1.445123329615290e-19, -8.652277044732456e-22,  7.788556452432821e-02, -8.119481818645364e-04,  6.464973950541039e-06, -2.528316234157737e-08,  4.778518865799963e-10,
 -1.189533706296143e-11, -3.397726493452873e-13,  5.654696254708741e-15,  3.681859615724838e-16, -1.440916129914001e-18, -3.362008749194306e-19, -2.017239493483391e-21,
  1.397410479091492e-01, -1.453792093392244e-03,  1.141630170505735e-05, -4.040459372962317e-08,  8.122723488324852e-10, -2.137518916016972e-11, -6.364565628957996e-13,
  1.058902748560921e-14,  6.847874257350016e-16, -2.697150992453125e-18, -6.276392405271509e-19, -3.775639219059145e-21,  2.210375107406337e-01, -2.292868925825477e-03,
  1.764783246675090e-05, -5.278148665338460e-08,  1.184123808199225e-09, -3.393350250921845e-11, -1.066094760435864e-12,  1.774304863023836e-14,  1.138249731384740e-15,
 -4.532097188591510e-18, -1.048531156345477e-18, -6.322376596750555e-21,  3.233384770489185e-01, -3.340492174001100e-03,  2.498133540478169e-05, -5.451059125513886e-08,
  1.528494804981675e-09, -5.004330500029276e-11, -1.677896741422268e-12,  2.797645674299906e-14,  1.779668917161362e-15, -7.216792772795140e-18, -1.650238238083166e-18,
 -9.957463899926380e-21,  4.488941488780357e-01, -4.611383324089968e-03,  3.306051166903225e-05, -3.143086879475438e-08,  1.730931833434009e-09, -7.073149328854650e-11,
 -2.552143701745953e-12,  4.276616677972959e-14,  2.700583026060108e-15, -1.129655543948101e-17, -2.525778783066267e-18, -1.517823051575981e-20,  6.009961502119420e-01,
 -6.123551302049069e-03,  4.113716952774610e-05,  4.350022649147254e-08,  1.582027635683375e-09, -9.860624895272664e-11, -3.822665881688773e-12,  6.481911105624714e-14,
  4.078676748056777e-15, -1.799974620437613e-17, -3.858885065598994e-18, -2.280747369412623e-20,  7.846579303044229e-01, -7.895653730199216e-03,  4.750244731631380e-05,
  2.272200120426786e-07,  6.845291274453571e-10, -1.417733586355838e-10, -5.713230537728120e-12,  9.969339609623854e-14,  6.303263636976811e-15, -3.057704163917836e-17,
 -6.066172190030075e-18, -3.405515248760073e-20,  1.008072720831709e+00, -9.932227464395083e-03,  4.766506251139742e-05,  6.586748312383125e-07, -1.680862257584778e-09,
 -2.334108892296634e-10, -8.540988721990896e-12,  1.618662019339620e-13,  1.038563919269598e-14, -5.990351975902016e-17, -1.032886143098903e-17, -4.879040076331866e-20,
  1.286297548874957e+00, -1.213650051356416e-02,  2.646805473645691e-05,  1.765508262143611e-06, -5.476421808803154e-09, -5.841907971822264e-10, -1.201619203228010e-11,
  3.287047714848677e-13,  1.940314743140182e-14, -1.619553461554098e-16, -2.154424228577921e-17, -3.528348065310776e-20,  1.652817007309012e+00, -1.344753285705819e-02,
 -1.027352948211490e-04,  5.250001580162806e-06,  5.140298564837017e-08, -4.302174086890667e-09, -4.090608056007547e-11,  3.982553422382488e-12,  4.140578070954846e-14,
 -3.789649245196996e-15, -4.666887747431144e-17,  3.617207275111580e-18,  8.219846164453027e-03, -8.385068661811281e-05,  6.899860343491775e-07, -2.459376784696696e-09,
  2.278133465019466e-11, -1.836936561607292e-12, -4.305007533439405e-15,  1.487247253141262e-15,  9.735079718594029e-18, -1.317790163161019e-18, -1.258251436479032e-20,
  1.139825862875374e-21,  3.300441069781547e-02, -3.365032813594261e-04,  2.758298726168730e-06, -9.479930992795400e-09,  8.671582660511955e-11, -7.416698239430553e-12,
 -1.785016874262758e-14,  6.062242888138187e-15,  3.946686467687113e-17, -5.373783458741187e-18, -5.119904239804301e-20,  4.654677998385930e-21,  7.473944632644519e-02,
 -7.613326062056901e-04,  6.198365223585680e-06, -1.990759297218718e-08,  1.775632903050781e-10, -1.695899912387235e-11, -4.258226358215459e-14,  1.408669576169964e-14,
  9.085219128396289e-17, -1.249757077458189e-17, -1.185999519871343e-19,  1.085189339190410e-20,  1.341057327129747e-01, -1.364217372348586e-03,  1.099300543398257e-05,
 -3.151570571420465e-08,  2.678195123144502e-10, -3.087848523243718e-11, -8.191825557192572e-14,  2.624497438491890e-14,  1.669284850192932e-16, -2.332001106573724e-17,
 -2.198872883213898e-19,  2.032370939611054e-20,  2.121447656496578e-01, -2.153957182778349e-03,  1.710186102794002e-05, -4.041687378590618e-08,  3.094084427899029e-10,
 -4.988147304134271e-11, -1.409079091084032e-13,  4.370111835755680e-14,  2.725963914406889e-16, -3.893411663594957e-17, -3.634448446059856e-19,  3.410681711045754e-20,
  3.103725378065119e-01, -3.142930761503731e-03,  2.443481844459566e-05, -3.987503053243841e-08,  2.189627508747848e-10, -7.517145780873499e-11, -2.260357553084627e-13,
  6.841345079066497e-14,  4.154337929242416e-16, -6.122887188220004e-17, -5.625859310258250e-19,  5.401842101279769e-20,  4.309756939874772e-01, -4.348063535604647e-03,
  3.279355864098704e-05, -1.780985147536692e-08, -1.528859386426946e-10, -1.089182895392429e-10, -3.431592646229183e-13,  1.037905947890683e-13,  6.068967543921297e-16,
 -9.361942426651036e-17, -8.382832432139760e-19,  8.340637336277155e-20,  5.771638197790177e-01, -5.792113808163139e-03,  4.173210673963189e-05,  4.891518279821978e-08,
 -1.090723230407430e-09, -1.554804828052795e-10, -4.871141697331383e-13,  1.561851415530572e-13,  8.632148426695134e-16, -1.428181870296549e-16, -1.222817493938877e-18,
  1.290190288507732e-19,  7.538525486510548e-01, -7.504799015627231e-03,  5.018061786481348e-05,  2.093683727611673e-07, -3.188607186708344e-09, -2.252779341813099e-10,
 -5.909648787416856e-13,  2.387842113251987e-13,  1.198969025933378e-15, -2.238385105306729e-16, -1.757851833047999e-18,  2.064995057584876e-19,  9.691553192964960e-01,
 -9.520164690459005e-03,  5.522339440730306e-05,  5.854611420695572e-07, -7.856444808517259e-09, -3.512469837954836e-10, -2.320229102079504e-13,  3.841118810082778e-13,
  1.543959413613586e-15, -3.776288236544017e-16, -2.417262706760843e-18,  3.610435633150740e-19,  1.238305836984313e+00, -1.184247078919471e-02,  4.670341855692659e-05,
  1.573011719909399e-06, -1.897978471627112e-08, -7.030418950938889e-10,  3.890590306864646e-12,  7.052754403834864e-13,  4.503390929631196e-16, -7.570163133878394e-16,
 -1.919240770982390e-18,  7.820406949615761e-19,  1.597793027653274e+00, -1.401012603778637e-02, -3.770638949202883e-05,  5.369691087586641e-06, -3.520736856856159e-08,
 -3.926851733828563e-09,  6.798444698890939e-11,  3.093408226470446e-12, -8.836300267926281e-14, -2.395806086391729e-15,  1.020588030364711e-16,  1.752878354630885e-18,
  7.895301389195959e-03, -7.844540965617511e-05,  6.614689135147630e-07, -2.380182459850565e-09, -1.162607185688243e-11, -1.450105139968401e-12,  3.446969852194473e-14,
  1.045123310544899e-15, -3.422278394190863e-17, -8.049348635834766e-19,  3.398635896768231e-20,  5.826969984318730e-22,  3.170182847480122e-02, -3.148794773419043e-04,
  2.648052604832068e-06, -9.244491874789485e-09, -5.219205266087024e-11, -5.847981230372101e-12,  1.401016921135897e-13,  4.253246747157679e-15, -1.396530512166226e-16,
 -3.274209835745356e-18,  1.387985956114590e-19,  2.370680452713705e-21,  7.179181133038229e-02, -7.126784192620150e-04,  5.965516122553468e-06, -1.970098564224331e-08,
 -1.399954196459015e-10, -1.334358368024183e-11,  3.240427291885603e-13,  9.855273749961320e-15, -3.251612120086612e-16, -7.580929046218782e-18,  3.236298530933486e-19,
  5.490307973324074e-21,  1.288223977285085e-01, -1.277759615968494e-03,  1.062048843669775e-05, -3.202743268722820e-08, -3.101344385077616e-10, -2.421372250438602e-11,
  6.000086522862979e-13,  1.828236639267775e-14, -6.077242665257229e-16, -1.404919706535073e-17,  6.061901147747261e-19,  1.017638406138127e-20,  2.037995148944118e-01,
 -2.019073080500327e-03,  1.661418718181155e-05, -4.321431971632202e-08, -6.234471802454626e-10, -3.891346607724204e-11,  9.918927351492427e-13,  3.025229036773028e-14,
 -1.016744886745695e-15, -2.322081711973257e-17,  1.017459004251039e-18,  1.681597322353777e-20,  2.981886763440479e-01, -2.949419582577225e-03,  2.392855699292056e-05,
 -4.804214549116293e-08, -1.184611296906386e-09, -5.817908114119040e-11,  1.541407959623069e-12,  4.693372228999517e-14, -1.602989603040138e-15, -3.598309054470330e-17,
  1.611662073510526e-18,  2.602720286726894e-20,  4.141065085987762e-01, -4.086775062981201e-03,  3.249453379251234e-05, -3.714355231976463e-08, -2.180332839354836e-09,
 -8.324641064086294e-11,  2.325323132506920e-12,  7.026204883970912e-14, -2.458075792577223e-15, -5.381635508147981e-17,  2.488409765043350e-18,  3.879400866458498e-20,
  5.546660692095882e-01, -5.456438764707531e-03,  4.211376749859754e-05,  7.432682038355886e-09, -3.967350547050447e-09, -1.163746127733692e-10,  3.499201207885608e-12,
  1.035671904560894e-13, -3.761597503111797e-15, -7.928836332465315e-17,  3.847334766986389e-18,  5.666441344616754e-20,  7.246504860270202e-01, -7.094507854461148e-03,
  5.224194049066902e-05,  1.237902736568340e-07, -7.303929649588686e-09, -1.623715657574842e-10,  5.429826223515059e-12,  1.528294453076294e-13, -5.914422356317259e-15,
 -1.170236587342502e-16,  6.145796158856009e-18,  8.177771592322460e-20,  9.319990286068448e-01, -9.052930213850655e-03,  6.127178712154259e-05,  4.068519332247196e-07,
 -1.409026117410490e-08, -2.346178046281838e-10,  9.220153203695893e-12,  2.285234646869079e-13, -1.001854111847415e-14, -1.746896334687791e-16,  1.067178545894565e-17,
  1.138812682230585e-19,  1.191794141301910e+00, -1.139950468965180e-02,  6.332765265163694e-05,  1.168350653416515e-06, -3.060240781356793e-08, -3.951488875109855e-10,
  2.001481364805434e-11,  3.328998951330174e-13, -2.053422366353316e-14, -2.406636430550970e-16,  2.251115407513213e-17,  1.021407793247100e-19,  1.541536801665275e+00,
 -1.406888102354441e-02,  2.111043327415438e-05,  4.289703051682197e-06, -9.229235771633514e-08, -1.624927821002953e-09,  1.080662350816210e-10, -2.709974257118164e-13,
 -9.693613285255868e-14,  1.680710746739214e-15,  6.897567507811822e-17, -2.575922963268574e-18,  7.591915405183353e-03, -7.327294206680293e-05,  6.310004277343657e-07,
 -2.745789250739015e-09, -3.070166335565558e-11, -4.121033706087018e-13,  4.606515781195458e-14, -2.297495159307368e-16, -3.688369937178558e-17,  5.976145292756349e-19,
  2.570539533410141e-20, -7.979950145587402e-22,  3.048394675674775e-02, -2.941605298348791e-04,  2.528926916915364e-06, -1.080213650188984e-08, -1.288034275345932e-10,
 -1.629151939745766e-12,  1.871532025860579e-13, -9.430127388542115e-16, -1.501523323939331e-16,  2.445251391577576e-18,  1.045897081523553e-19, -3.263364906081969e-21,
  6.903497205169455e-02, -6.659551817809038e-04,  5.708426995544020e-06, -2.358295885033708e-08, -3.135434989473324e-10, -3.587170914431373e-12,  4.324949913470683e-13,
 -2.218566930773031e-15, -3.481474104711074e-16,  5.720054919320372e-18,  2.422723116785342e-19, -7.626621056723255e-21,  1.238786926265074e-01, -1.194448415317739e-03,
  1.019331057040735e-05, -3.995108942920802e-08, -6.216311028412987e-10, -6.155987287395055e-12,  7.995350311436279e-13, -4.213617381534297e-15, -6.465796831678348e-16,
  1.076555047296502e-17,  4.492749409608975e-19, -1.433369648994676e-20,  1.959854598721291e-01, -1.888453057384727e-03,  1.601488329871889e-05, -5.790730155009400e-08,
 -1.116237021706865e-09, -9.091530188511011e-12,  1.317924549033462e-12, -7.217731485561338e-15, -1.071976586384843e-15,  1.818851804489706e-17,  7.431844466332255e-19,
 -2.416924448148099e-20,  2.867696508457451e-01, -2.760692981642587e-03,  2.320738696536964e-05, -7.396274870065281e-08, -1.905120357212517e-09, -1.193396104337691e-11,
  2.037614040832774e-12, -1.177295412800013e-14, -1.668481319244378e-15,  2.906450570135571e-17,  1.152785455807754e-18, -3.851635961724603e-20,  3.982755219282009e-01,
 -3.829298954544287e-03,  3.179578579517166e-05, -8.182288859796200e-08, -3.178708987238640e-09, -1.377893492221914e-11,  3.046053383172954e-12, -1.896054943744735e-14,
 -2.511684855961964e-15,  4.539993304776575e-17,  1.726028245109485e-18, -5.993446673343489e-20,  5.335129846681533e-01, -5.120394402193763e-03,  4.176212071473732e-05,
 -6.938346121982065e-08, -5.297554288499989e-09, -1.271289347932673e-11,  4.508597647840095e-12, -3.117298975105328e-14, -3.738885802885997e-15,  7.129087298350777e-17,
  2.545824941543419e-18, -9.358550696506642e-20,  6.971146683702606e-01, -6.672812328946602e-03,  5.294499229276753e-05, -1.093385836003275e-08, -9.022178763648129e-09,
 -4.211392632571757e-12,  6.779180015400675e-12, -5.459099279556821e-14, -5.622343682210384e-15,  1.163380076343113e-16,  3.760705894861328e-18, -1.513266642398787e-19,
  8.967928044781688e-01, -8.547330094711628e-03,  6.468971635033268e-05,  1.573710540636694e-07, -1.625236060969253e-08,  2.443056224950291e-11,  1.078438623220012e-11,
 -1.095390330549692e-13, -8.767854730281824e-15,  2.084783435998065e-16,  5.616996052712048e-18, -2.662972579761403e-19,  1.147285842557525e+00, -1.084554741459206e-02,
  7.423911563303160e-05,  6.433788188851791e-07, -3.334221962569437e-08,  1.208868917826779e-10,  2.003259726539383e-11, -2.985417331266615e-13, -1.461351960142284e-14,
  4.667289338965662e-16,  7.859604937683207e-18, -5.639827205723454e-19,  1.485887475929479e+00, -1.372078516922848e-02,  6.309044737740180e-05,  2.685926952144250e-06,
 -1.009929090394037e-07,  5.963513348321733e-10,  6.861697046983171e-11, -2.100364462084283e-12, -1.454444650260127e-14,  2.202066801516177e-15, -3.291219860903353e-17,
 -1.330460328049051e-18,  7.308698816488784e-03, -6.836534306005140e-05,  5.950151045464681e-07, -3.247160286251923e-09, -2.899410676659218e-11,  5.080441174094003e-13,
  2.732958314629627e-14, -9.414160054810493e-16, -5.984110784167956e-18,  8.769376811231889e-19, -9.796649423822811e-21, -5.608912819314106e-22,  2.934689568116183e-02,
 -2.744836222494057e-04,  2.386606134362918e-06, -1.289708728555980e-08, -1.209881285171764e-10,  2.105479704236615e-12,  1.107230979361264e-13, -3.834518267093243e-15,
 -2.407441986578640e-17,  3.571559892449132e-18, -4.023014137758517e-20, -2.280529918153646e-21,  6.646057065229358e-02, -6.215070068174617e-04,  5.394684791314400e-06,
 -2.865044233204666e-08, -2.920308975062348e-10,  5.028128649276288e-12,  2.546187760407933e-13, -8.899840646425490e-15, -5.465349053566401e-17,  8.287510151040296e-18,
 -9.469336204366607e-20, -5.275969395119034e-21,  1.192607127172703e-01, -1.114991601176182e-03,  9.653336311402644e-06, -4.991618237968128e-08, -5.726357095260217e-10,
  9.728560146231568e-12,  4.672324828932057e-13, -1.655714831035977e-14, -9.821958721642866e-17,  1.540947621661370e-17, -1.798383411105558e-19, -9.764694403976212e-21,
  1.886830513151445e-01, -1.763420404074138e-03,  1.521206795865429e-05, -7.563228651655726e-08, -1.015030269193242e-09,  1.699259712225125e-11,  7.620795201862602e-13,
 -2.752741040055356e-14, -1.550170348547729e-16,  2.558995945427650e-17, -3.075987510960032e-19, -1.610556140319752e-20,  2.760918410613905e-01, -2.579104114117229e-03,
  2.213713738654399e-05, -1.039028636711968e-07, -1.707671905937440e-09,  2.817790190679922e-11,  1.160873000463775e-12, -4.304139169329865e-14, -2.239980480393110e-16,
  3.992164788905346e-17, -4.995378037067100e-19, -2.487407924971125e-20,  3.834596226228353e-01, -3.579721394661557e-03,  3.051169058882589e-05, -1.312357574863833e-07,
 -2.805464639304999e-09,  4.572554836817109e-11,  1.699165505149422e-12, -6.528748633532881e-14, -2.997816443756170e-16,  6.029162051727194e-17, -7.967658196372048e-19,
 -3.699819862830422e-20,  5.136923133965852e-01, -4.791052243233845e-03,  4.043028845274808e-05, -1.508035619792816e-07, -4.598368539507151e-09,  7.436572025500230e-11,
  2.438067349844684e-12, -9.847332468620025e-14, -3.629296159733570e-16,  9.016708149048108e-17, -1.285145962239851e-18, -5.399416539040974e-20,  6.712663026643513e-01,
 -6.252184086038121e-03,  5.197133579440325e-05, -1.479508412984978e-07, -7.689152281038192e-09,  1.243924942647044e-10,  3.491093648151373e-12, -1.517485146731205e-13,
 -3.439863813247005e-16,  1.365380064407031e-16, -2.170290839299057e-18, -7.827255063385126e-20,  8.636443942352668e-01, -8.026557846740124e-03,  6.507561331254846e-05,
 -8.620869489622853e-08, -1.355454854706904e-08,  2.226625396201649e-10,  5.094386885480168e-12, -2.492967181661908e-13,  4.512200337125469e-17,  2.153987015990238e-16,
 -4.059071783989269e-18, -1.123482735542360e-19,  1.105128007226755e+00, -1.022948516639604e-02,  7.891361662640664e-05,  1.517858481248108e-07, -2.699677853136982e-08,
  4.650679205423154e-10,  7.820825692860024e-12, -4.814144957602801e-13,  2.517705303987336e-15,  3.677700191718915e-16, -9.498088944924680e-18, -1.380423473771634e-19,
  1.432180936775286e+00, -1.311321956615290e-02,  8.625460420895836e-05,  1.234823704062933e-06, -7.736208948556106e-08,  1.547040172921050e-09,  1.296274684999037e-11,
 -1.619901506459331e-12,  3.381046930509911e-14,  4.475279402853068e-16, -4.002531414892563e-17,  6.600673885899996e-19,  7.044501023048607e-03, -6.376801343200569e-05,
  5.536918179777891e-07, -3.603153329658407e-09, -1.441018656473326e-11,  8.515502610426700e-13,  2.290475820698297e-15, -7.366330406957015e-16,  1.486149292289591e-17,
  2.382146480600733e-19, -1.662504064607152e-20,  1.762575031088701e-22,  2.828612543040195e-02, -2.560387864895631e-04,  2.221983065005855e-06, -1.438832692744357e-08,
 -6.100020438609558e-11,  3.491364583607461e-12,  8.852795112259951e-15, -2.992997952810710e-15,  6.065455205732993e-17,  9.629810414078819e-19, -6.771686339940476e-20,
  7.250466270633746e-22,  6.405858028499120e-02, -5.797948060388401e-04,  5.027005580105264e-06, -3.227149275685855e-08, -1.505198339377554e-10,  8.191965455778666e-12,
  1.865642491893592e-14, -6.916699816870595e-15,  1.412632168807736e-16,  2.205327540886236e-18, -1.571578139156559e-19,  1.711512165599345e-21,  1.149512096933708e-01,
 -1.040298686108858e-03,  9.007330558061536e-06, -5.707058134765578e-08, -3.033739606285455e-10,  1.547090598465484e-11,  2.958741579182032e-14, -1.278399941173570e-14,
  2.641294317773645e-16,  4.018932368784404e-18, -2.922784761557055e-19,  3.263589533848859e-21,  1.818666655523733e-01, -1.645599320601317e-03,  1.422075312687612e-05,
 -8.842249765540975e-08, -5.543914773145637e-10,  2.621315299750458e-11,  3.762864578910609e-14, -2.105707337280587e-14,  4.421585848053295e-16,  6.481741396602764e-18,
 -4.855015157915093e-19,  5.611195826159786e-21,  2.661211328091529e-01, -2.407408213390992e-03,  2.074874653699427e-05, -1.256123763739209e-07, -9.623071828782082e-10,
  4.191735408581230e-11,  3.505975808486048e-14, -3.249595303667705e-14,  6.976532891879817e-16,  9.692912431878187e-18, -7.575938010454487e-19,  9.170162513496746e-21,
  3.696179788834948e-01, -3.342609458226187e-03,  2.870319858337894e-05, -1.672093942430321e-07, -1.629312660007066e-09,  6.521226126628264e-11,  6.270344095188893e-15,
 -4.838429765581380e-14,  1.070846199933236e-15,  1.374816304272634e-17, -1.144304060515887e-18,  1.473235934439041e-20,  4.951619315949944e-01, -4.475970200939311e-03,
  3.823603922944076e-05, -2.102265518428821e-07, -2.744880141714948e-09,  1.010412107513643e-10, -8.303723500343542e-14, -7.102116319802640e-14,  1.640332287555183e-15,
  1.862639154604219e-17, -1.710923603564460e-18,  2.394307873765126e-20,  6.470751886929356e-01, -5.845394918176878e-03,  4.955072452365774e-05, -2.479378189270878e-07,
 -4.697332954646213e-09,  1.597735705841025e-10, -3.182136188808759e-13, -1.049239832278884e-13,  2.579768136214967e-15,  2.368264052235752e-17, -2.587582743781802e-18,
  4.069179267817166e-20,  8.325681024137203e-01, -7.513407677574582e-03,  6.290204612728022e-05, -2.631033232300332e-07, -8.417405331664269e-09,  2.672171946730079e-10,
 -9.570469261892043e-13, -1.603026942330117e-13,  4.353946241271408e-15,  2.499853343634302e-17, -4.064852091467263e-18,  7.613251996580491e-20,  1.065474842437793e+00,
 -9.597482101643545e-03,  7.847149531357278e-05, -1.998429731411792e-07, -1.682132889594105e-08,  5.095949259097648e-10, -3.089892518431605e-12, -2.658133321354241e-13,
  8.693588157914023e-15, -4.574307249118549e-18, -6.835838286677890e-18,  1.738233141699577e-19,  1.381175428050668e+00, -1.238255962736935e-02,  9.468490773226035e-05,
  2.483327233828832e-07, -4.632435090145837e-08,  1.441525955630115e-09, -1.665873150897542e-11, -5.248338222617946e-13,  2.909633021071950e-14, -4.881188647235904e-16,
 -7.524003018738475e-18,  5.922923072082817e-19,  6.798010358679750e-03, -5.951406672233437e-05,  5.096256018811988e-07, -3.700467281091970e-09,  1.796016567645125e-12,
  7.165675155976694e-13, -1.118842971446359e-14, -2.318441779310627e-16,  1.406533936752725e-17, -2.013930345234194e-19, -4.793311182820546e-21,  2.632797894465463e-22,
  2.729641201538186e-02, -2.389648963730583e-04,  2.045741015666471e-06, -1.481847331266523e-08,  5.371253567229329e-12,  2.932821500158914e-12, -4.582331731058597e-14,
 -9.367615389321772e-16,  5.720342149289642e-17, -8.236358920179389e-19, -1.938165612416593e-20,  1.071987865038127e-21,  6.181733898108461e-02, -5.411564121303461e-04,
  4.630626728436878e-06, -3.340087537015176e-08,  4.917842618540721e-12,  6.861116611905728e-12, -1.073373076606863e-13, -2.143801626864967e-15,  1.324116187140963e-16,
 -1.924956051171522e-18, -4.440628738235706e-20,  2.486229784844989e-21,  1.109297090482123e-01, -9.710387115536602e-04,  8.303406549002710e-06, -5.951417073449127e-08,
 -1.061169792900827e-11,  1.290242120015965e-11, -2.022876786869209e-13, -3.904414661303114e-15,  2.453176823114954e-16, -3.617573320104572e-18, -8.098655152317075e-20,
  4.619093181101134e-21,  1.755049191890217e-01, -1.536189079711609e-03,  1.312344629337098e-05, -9.321972689183803e-08, -6.011784742472014e-11,  2.173636327991265e-11,
 -3.419873573985607e-13, -6.297042086810391e-15,  4.053811630946020e-16, -6.097714294243569e-18, -1.307782575265122e-19,  7.661117448835270e-21,  2.568136465668823e-01,
 -2.247646714303011e-03,  1.917609926715185e-05, -1.345185101959273e-07, -1.755261348173976e-10,  3.450009084900163e-11, -5.458302920130669e-13, -9.432806395078650e-15,
  6.282550911501464e-16, -9.707973470148587e-18, -1.959781352837408e-19,  1.192807514116435e-20,  3.566935869722707e-01, -3.121355910016221e-03,  2.658225462051352e-05,
 -1.832241635833928e-07, -4.123758258676166e-10,  5.315695612724458e-11, -8.483826252059408e-13, -1.345772136244378e-14,  9.405817173454745e-16, -1.507347632070467e-17,
 -2.790113892656085e-19,  1.795660397362198e-20,  4.778529942075532e-01, -4.180769398541879e-03,  3.551456688660952e-05, -2.386519652811516e-07, -8.733064665077411e-10,
  8.132370436250486e-11, -1.315982892500156e-12, -1.852956077962209e-14,  1.390519343589252e-15, -2.342969168656153e-17, -3.808341233432786e-19,  2.670781447023497e-20,
  6.244660851358035e-01, -5.461931913767384e-03,  4.622631719964977e-05, -2.987735276629997e-07, -1.766933955958845e-09,  1.263821336596287e-10, -2.091435644029220e-12,
 -2.466248600562384e-14,  2.073706562170097e-15, -3.753404152699558e-17, -4.929758262641248e-19,  4.003684470465630e-20,  8.034981937343874e-01, -7.024718159395566e-03,
  5.910557180619434e-05, -3.575168636855182e-07, -3.584947390126013e-09,  2.060151105776205e-10, -3.542222876161639e-12, -3.081997397479562e-14,  3.208823773417677e-15,
 -6.480127467649479e-17, -5.557190004920942e-19,  6.183951582174148e-20,  1.028319786103651e+00, -8.983139918335485e-03,  7.477622413133943e-05, -3.934607501968877e-07,
 -7.817717652800591e-09,  3.758939140710059e-10, -6.952116508435924e-12, -2.814103216689603e-14,  5.415643825478145e-15, -1.324950626508527e-16, -1.524475612591222e-19,
  9.983746691816454e-20,  1.333163921851394e+00, -1.162372851006265e-02,  9.408922987786274e-05, -2.872588144777286e-07, -2.221143896795184e-08,  9.533469362695600e-10,
 -2.112904418600067e-11,  1.079266498536829e-13,  1.086589925201641e-14, -4.330488332824535e-16,  6.521017209254263e-18,  8.680725860715313e-20,  6.567828862855871e-03,
 -5.561320899420507e-05,  4.658140530241532e-07, -3.573056769920712e-09,  1.314756549012502e-11,  4.134858933400612e-13, -1.261713409280092e-14,  8.464252676498474e-17,
  5.653197167642503e-18, -2.175865941153936e-19,  2.522927307637729e-21,  6.887583996387538e-23,  2.637216549552068e-02, -2.233047548072946e-04,  1.870160831942290e-06,
 -1.432861883351737e-08,  5.184544843313555e-11,  1.694453927152892e-12, -5.148021962512311e-14,  3.486307124867483e-16,  2.290737961825829e-17, -8.852935009312466e-19,
  1.033572067749945e-20,  2.782314157820240e-22,  5.972427930076873e-02, -5.057038525825651e-04,  4.234326293584160e-06, -3.237707598898262e-08,  1.136906643340526e-10,
  3.971948820212325e-12, -1.198178603406312e-13,  8.245109773394601e-16,  5.268713303608188e-17, -2.050703785161698e-18,  2.422637056866046e-20,  6.363989424348095e-22,
  1.071739050978673e-01, -9.074532533903892e-04,  7.595812098082746e-06, -5.790625383246484e-08,  1.940535404356086e-10,  7.488790232982312e-12, -2.237288192280533e-13,
  1.575435688392973e-15,  9.667983370259771e-17, -3.803250069101772e-18,  4.571875397513593e-20,  1.157681568752425e-21,  1.695630698894923e-01, -1.435662466654041e-03,
  1.201183322915463e-05, -9.118615573696667e-08,  2.848816915124610e-10,  1.265430405364398e-11, -3.735593934528945e-13,  2.712859479770680e-15,  1.575951857681653e-16,
 -6.293473325720497e-18,  7.748982871410382e-20,  1.862571524794738e-21,  2.481196494380525e-01, -2.100695031225684e-03,  1.756533438214684e-05, -1.325720894133808e-07,
  3.723297765506694e-10,  2.014800757847941e-11, -5.866494052591875e-13,  4.433491999824350e-15,  2.396224869040389e-16, -9.770896721225812e-18,  1.242376887306206e-19,
  2.776527302765166e-21,  3.446194929822826e-01, -2.917531599468302e-03,  2.437525882211346e-05, -1.824971859254933e-07,  4.319088444886301e-10,  3.113042047875617e-11,
 -8.930205787285184e-13,  7.100402058982736e-15,  3.492114361865819e-16, -1.466092643592653e-17,  1.945775300417343e-19,  3.922758137122319e-21,  4.616798250395246e-01,
 -3.908233779217497e-03,  3.261473349497970e-05, -2.414256668226565e-07,  4.177652259388362e-10,  4.770757770899657e-11, -1.348220235824377e-12,  1.143920936779179e-14,
  4.963466662357022e-16, -2.173342933838967e-17,  3.055965803845166e-19,  5.291849909886684e-21,  6.033348233781642e-01, -5.106769405052509e-03,  4.254563398118787e-05,
 -3.096671676054192e-07,  2.360304850188051e-10,  7.408871829934494e-11, -2.066370020972304e-12,  1.908592384011544e-14,  6.961662506674783e-16, -3.251692024023607e-17,
  4.954367719891373e-19,  6.714465633283803e-21,  7.763168365141967e-01, -6.569727073678585e-03,  5.459186140518388e-05, -3.866455171748749e-07, -3.340519652490758e-10,
  1.200519831323253e-10, -3.323469263869413e-12,  3.447869315643617e-14,  9.667615383600797e-16, -5.049237272839750e-17,  8.658974340351377e-19,  7.243704750021004e-21,
  9.935514199491043e-01, -8.405430292653972e-03,  6.952291329469318e-05, -4.674377906841671e-07, -1.949252795589073e-09,  2.148934381374514e-10, -6.000285809402760e-12,
  7.409433680519341e-14,  1.270783355110024e-15, -8.537125776304382e-17,  1.781227920640685e-18,  1.015050641268850e-21,  1.288145768596993e+00, -1.088956713589460e-02,
  8.905392961622149e-05, -5.160902263129600e-07, -7.821884065583190e-09,  5.092907061806398e-10, -1.520505437432959e-11,  2.591851285443750e-13,  1.876259067037995e-16,
 -1.681748751175749e-16,  5.536033181527749e-18, -8.025209341823852e-20,  6.352563248359491e-03, -5.205410035549839e-05,  4.244220441624514e-07, -3.311902170803239e-09,
  1.865893981248520e-11,  1.531133125153707e-13, -8.731629489855455e-15,  1.630819687257878e-16, -7.264843654702287e-21, -9.516129286343872e-20,  2.880707488285738e-21,
 -3.035664506196545e-23,  2.550780285538413e-02, -2.090149791490956e-04,  1.704107352152403e-06, -1.329064577172900e-08,  7.448481634356181e-11,  6.327015954744763e-13,
 -3.559146066621568e-14,  6.651601433700828e-16, -9.194460470923359e-20, -3.859023055520579e-19,  1.172225075033209e-20, -1.244552003991881e-22,  5.776680285245537e-02,
 -4.733473456774175e-04,  3.858859000211202e-06, -3.006827936816564e-08,  1.669658714583409e-10,  1.503244358352478e-12, -8.269520605236418e-14,  1.547240099127223e-15,
 -4.626813806051723e-19, -8.887686935852012e-19,  2.715940235866948e-20, -2.920770007422381e-22,  1.036613114541363e-01, -8.494038919009346e-04,  6.923616624925916e-06,
 -5.387512783183320e-08,  2.950288364878325e-10,  2.885969168598349e-12, -1.540153103125178e-13,  2.886985739166299e-15, -1.543799320918585e-18, -1.634133945337747e-18,
  5.038489550559208e-20, -5.521388189953671e-22,  1.640058101696908e-01, -1.343851017478807e-03,  1.095181179135741e-05, -8.505685153946174e-08,  4.566096409072790e-10,
  4.984881768582786e-12, -2.562286500126286e-13,  4.816683410210484e-15, -4.132886611551351e-18, -2.671248438085839e-18,  8.340532311243448e-20, -9.378610979034904e-22,
  2.399880165902168e-01, -1.966408628365848e-03,  1.602117715438829e-05, -1.241021202814150e-07,  6.477856869207677e-10,  8.137587432694542e-12, -4.003825555188590e-13,
  7.559263990482742e-15, -9.744325596009127e-18, -4.077409095032082e-18,  1.295431075727590e-19, -1.507480408366075e-21,  3.333257201431067e-01, -2.731131754138828e-03,
  2.224375670379043e-05, -1.716856355578771e-07,  8.609657031956659e-10,  1.291759236542651e-11, -6.052812103123871e-13,  1.150346887802212e-14, -2.140030514475828e-17,
 -5.974478367297568e-18,  1.944516396539709e-19, -2.367506463770427e-21,  4.465506197283256e-01, -3.658728975388963e-03,  2.978387993999015e-05, -2.287334710535010e-07,
  1.080825689010511e-09,  2.035665704321743e-11, -9.049481652659673e-13,  1.737503871111049e-14, -4.564204985659371e-17, -8.558935662474518e-18,  2.883265629316516e-19,
 -3.728077136064540e-21,  5.835651595216085e-01, -4.781108006199788e-03,  3.889303520121351e-05, -2.965164863166360e-07,  1.274106857674834e-09,  3.248861783213261e-11,
 -1.367235271743151e-12,  2.668161163352988e-14, -9.843458870922810e-17, -1.215469399213300e-17,  4.312827586182351e-19, -6.053645659414321e-21,  7.508820919948714e-01,
 -6.151485889166647e-03,  4.998624834773459e-05, -3.767438140800104e-07,  1.359382614162484e-09,  5.393413493951423e-11, -2.149584231692324e-12,  4.311906593126685e-14,
 -2.265940078744398e-16, -1.727218699502634e-17,  6.685673554914333e-19, -1.056081552039603e-20,  9.610061627560841e-01, -7.871934667439144e-03,  6.384507257867564e-05,
 -4.713108326762480e-07,  1.090044933153461e-09,  9.801673010316595e-11, -3.723636782456034e-12,  7.867402735634595e-14, -6.175727194028856e-16, -2.416198337530219e-17,
  1.122887066486017e-18, -2.143398271122108e-20,  1.245971009570031e+00, -1.020337818475197e-02,  8.238849434718292e-05, -5.771596312238494e-07, -7.126839892961307e-10,
  2.278924223747885e-10, -8.510303144694210e-12,  2.039862963676490e-13, -2.747800929746364e-15, -1.769600762450803e-17,  2.140253848809266e-18, -6.196964686133146e-20,
  6.150893283024230e-03, -4.881245372942052e-05,  3.865388158773391e-07, -2.998728282795977e-09,  1.998457951609490e-11, -4.119634977930933e-15, -4.542231541953396e-15,
  1.272729489701015e-16, -1.734364813741616e-18, -1.158745459888036e-20,  1.284622676081840e-21, -3.351580501411443e-23,  2.469802809535572e-02, -1.959991203497740e-04,
  1.552054378669378e-06, -1.203787633555615e-08,  8.006012131012940e-11, -8.231005335480414e-15, -1.852175721799085e-14,  5.181571473091957e-16, -7.078614606943624e-18,
 -4.629564605710581e-20,  5.210567656269189e-21, -1.363718623594220e-22,  5.593293635711565e-02, -4.438726801292952e-04,  3.514750694490457e-06, -2.724975171859143e-08,
  1.805840220361357e-10,  1.399529495487061e-14, -4.305917922420738e-14,  1.201496382657096e-15, -1.648473501123883e-17, -1.038336338698959e-19,  1.200483251839535e-20,
 -3.159124032949682e-22,  1.003704968372314e-01, -7.965175013246878e-04,  6.306765629675178e-06, -4.886693353480654e-08,  3.221191695095395e-10,  1.122869077948443e-13,
 -8.025071777292628e-14,  2.231448713934953e-15, -3.081225599209417e-17, -1.832043668729365e-19,  2.208471233105336e-20, -5.859199920361727e-22,  1.587993536334564e-01,
 -1.260189424693818e-03,  9.977294394897499e-06, -7.724298164672884e-08,  5.053591137121772e-10,  3.708132399235624e-13, -1.335992135209764e-13,  3.699055496973025e-15,
 -5.153404304882065e-17, -2.815680465332059e-19,  3.612842370521285e-20, -9.695346687617352e-22,  2.323695503612957e-01, -1.844010588435007e-03,  1.459801069989156e-05,
 -1.128877174055613e-07,  7.309513412740244e-10,  9.296953101366893e-13, -2.088524680313337e-13,  5.755006102121277e-15, -8.115183677235754e-17, -3.915522840464957e-19,
  5.520426799284099e-20, -1.504953846742840e-21,  3.227443958112271e-01, -2.561173390847654e-03,  2.027244199251945e-05, -1.565265964679776e-07,  9.990746530240342e-10,
  2.028113196834298e-12, -3.156836683577522e-13,  8.655983309796736e-15, -1.240707038219085e-16, -4.945422054096237e-19,  8.100615777079196e-20, -2.256882345601234e-21,
  4.323753093109037e-01, -3.431119083798827e-03,  2.715288875150016e-05, -2.092037375599931e-07,  1.308379468473538e-09,  4.097307566109273e-12, -4.713277525326604e-13,
  1.286698888959565e-14, -1.886097770005710e-16, -5.423334402286739e-19,  1.162921500019121e-19, -3.341233507201773e-21,  5.650410220696035e-01, -4.483810939018520e-03,
  3.547348839390864e-05, -2.724719826348630e-07,  1.653091741413048e-09,  7.985357380241998e-12, -7.094354600377323e-13,  1.931705845256722e-14, -2.922828208033335e-16,
 -3.997111822120458e-19,  1.657001506716632e-19, -4.984321059002460e-21,  7.270479054180694e-01, -5.769244127188003e-03,  4.562341337822102e-05, -3.487772630605741e-07,
  2.013885171746289e-09,  1.559999704992243e-11, -1.105754475291141e-12,  3.016714920231035e-14, -4.786736931890135e-16,  3.757279958201987e-19,  2.369647269187661e-19,
 -7.686308494619854e-21,  9.305047051959754e-01, -7.383379547923788e-03,  5.834488205984007e-05, -4.423418627168011e-07,  2.321173163728846e-09,  3.231273906287990e-11,
 -1.876676796455649e-12,  5.190707543156628e-14, -8.914235360500916e-16,  3.714270583160349e-18,  3.375693855723314e-19, -1.275563766579176e-20,  1.206431951690764e+00,
 -9.571884541017494e-03,  7.551349178996915e-05, -5.614367266029782e-07,  2.213250472443390e-09,  8.213248479226194e-11, -4.034854289837753e-12,  1.178053016825919e-13,
 -2.387254418667510e-15,  2.573562798233277e-17,  3.157531710032717e-19, -2.336835626195216e-20  };
  constexpr double w[4608] = {  3.442465393653664e-03, -1.210298795175669e-04,  3.010813711966053e-06, -6.456217737576152e-08,  1.266800787752804e-09,
 -2.334269079821682e-11,  4.096902013137839e-13, -6.910568632371031e-15,  1.127240248739431e-16, -1.786219504272633e-18,  2.759095505550824e-20, -4.164767946378918e-22,
  1.277995614453423e-02, -6.873771152252260e-04,  2.596608715403702e-05, -8.159832509394941e-07,  2.267257116039867e-08, -5.749794236551812e-10,  1.356664897829017e-11,
 -3.016287609441882e-13,  6.375742827453551e-15, -1.289748571878381e-16,  2.509447809859902e-18, -4.713290664134862e-20,  2.545986474131717e-02, -2.131485094977980e-03,
  1.161174606970996e-04, -5.009531838888274e-06,  1.848059258200304e-07, -6.067423142079385e-09,  1.816090185639845e-10, -5.035678072391779e-12,  1.308187650536283e-13,
 -3.210715008847343e-15,  7.492608266049370e-17, -1.670176474737832e-18,  3.836131832374645e-02, -4.726072454893269e-03,  3.516807498922642e-04, -1.988171062573441e-05,
  9.337758311701842e-07, -3.817502654666037e-08,  1.397528752495466e-09, -4.668450485761463e-11,  1.442179098627608e-12, -4.161098144794732e-14,  1.129925628776134e-15,
 -2.903437576518959e-17,  4.880448901197451e-02, -8.281213243682129e-03,  8.039937052604345e-04, -5.735006810902856e-05,  3.316604189472679e-06, -1.637859197164290e-07,
  7.129588410235513e-09, -2.794368000916973e-10,  1.001164965936372e-11, -3.316100531078355e-13,  1.024298599643253e-14, -2.968842789578119e-16,  5.512435687863824e-02,
 -1.212540800654328e-02,  1.473551290769358e-03, -1.282167375707516e-04,  8.865820198497469e-06, -5.150881239446434e-07,  2.602295422423269e-08, -1.170048266385488e-09,
  4.760230853353624e-11, -1.774284892942912e-12,  6.117398762050664e-14, -1.964309131254596e-15,  5.671826416272518e-02, -1.534252886621104e-02,  2.246441990262676e-03,
 -2.310709228722333e-04,  1.859151383170501e-05, -1.240191226707468e-06,  7.112418943730751e-08, -3.594156723676776e-09,  1.629052198312630e-10, -6.711675112282427e-12,
  2.539777756227977e-13, -8.891976101917307e-15,  5.376608558778177e-02, -1.709025784075178e-02,  2.910510442218864e-03, -3.435792090589002e-04,  3.134334766453300e-05,
 -2.345628934247266e-06,  1.495127458938125e-07, -8.328376215462698e-09,  4.130425494063235e-10, -1.849694510552238e-11,  7.562340281363095e-13, -2.844482455414151e-14,
  4.688325546331266e-02, -1.683750761816913e-02,  3.228240494420688e-03, -4.251959428559925e-04,  4.289480987785155e-05, -3.521119669453310e-06,  2.443869735563275e-07,
 -1.472556649886691e-08,  7.852870607068322e-10, -3.761018941525670e-11,  1.636408438505031e-12, -6.520117656426254e-14,  3.686474423127336e-02, -1.445829059774389e-02,
  3.027744711180748e-03, -4.330956628054658e-04,  4.715607651671491e-05, -4.153190525938851e-06,  3.075951882442695e-07, -1.967933754934875e-08,  1.109250158085931e-09,
 -5.591973060516371e-11,  2.551277331753641e-12, -1.062103870208966e-13,  2.455292339577977e-02, -1.020683375035477e-02,  2.269187202203192e-03, -3.434544642406056e-04,
  3.941151859271960e-05, -3.643860811267478e-06,  2.822621539065276e-07, -1.882331031638492e-08,  1.102465314928158e-09, -5.758353541190285e-11,  2.714798958050632e-12,
 -1.164935220028529e-13,  1.080763514108249e-02, -4.635965991169205e-03,  1.065022860561001e-03, -1.663003126776273e-04,  1.964577048911651e-05, -1.865988943394858e-06,
  1.481923573468325e-07, -1.011296842773841e-08,  6.050645117787016e-10, -3.223237300607926e-11,  1.547556276907187e-12, -6.753272273093017e-14,  3.002055848809051e-03,
 -9.973009378619357e-05,  2.343841188317832e-06, -4.755310712741707e-08,  8.844790319675982e-10, -1.547706891518459e-11,  2.583615529204605e-13, -4.150506970392826e-15,
  6.455375035917521e-17, -9.763435885614877e-19,  1.440781519806998e-20, -2.079510687242682e-22,  1.039157356374236e-02, -5.134204504070076e-04,  1.802171905799711e-05,
 -5.300334944389585e-07,  1.384806252303771e-08, -3.313585854729807e-10,  7.397111066037295e-12, -1.559540906691547e-13,  3.132162405362152e-15, -6.030639503480496e-17,
  1.118563944294082e-18, -2.005687370542577e-20,  1.847156982091328e-02, -1.400627258723439e-03,  7.039394121073232e-05, -2.827225331847259e-06,  9.767951668071864e-08,
 -3.016948669318992e-09,  8.525919760312842e-11, -2.238769809854852e-12,  5.521986152989896e-14, -1.289711905249194e-15,  2.869978192777528e-17, -6.112038069504296e-19,
  2.386759265662830e-02, -2.661026561737828e-03,  1.824285267493771e-04, -9.592628685867174e-06,  4.218439423283885e-07, -1.623008461760889e-08,  5.614608250204182e-10,
 -1.778475539526134e-11,  5.225217235745732e-13, -1.437613857351272e-14,  3.731233364965605e-16, -9.183871153266130e-18,  2.519292121746971e-02, -3.899483076674960e-03,
  3.502422941975089e-04, -2.331988404853877e-05,  1.267086190234726e-06, -5.909390066605854e-08,  2.439598406601644e-09, -9.100791954442068e-11,  3.113077707293644e-12,
 -9.871635736712105e-14,  2.926363005628067e-15, -8.158531096454983e-17,  2.304999488565438e-02, -4.687285808781422e-03,  5.316831798768699e-04, -4.350386898639066e-05,
  2.845305170720954e-06, -1.570992757776075e-07,  7.572745284828706e-09, -3.259717595500466e-10,  1.273418744112091e-11, -4.569550762901815e-13,  1.520354132980638e-14,
 -4.721288855406799e-16,  1.897718279294509e-02, -4.823039287820881e-03,  6.672100975124518e-04, -6.520563727858679e-05,  5.008131121493277e-06, -3.201829367483992e-07,
  1.765850157662420e-08, -8.606859834191187e-10,  3.772453549444728e-11, -1.506489281626953e-12,  5.537058045185600e-14, -1.886541834346845e-15,  1.441590352673728e-02,
 -4.377975731276989e-03,  7.141801588480930e-04, -8.106232666259798e-05,  7.134977046360889e-06, -5.167472833241429e-07,  3.196109119958887e-08, -1.731585288664694e-09,
  8.369898551015813e-11, -3.659936191370253e-12,  1.463536148922393e-13, -5.392609350951260e-15,  1.023959750096158e-02, -3.568355561691813e-03,  6.643519449452256e-04,
 -8.516129133233123e-05,  8.380269264533167e-06, -6.723987868296564e-07,  4.570001594577971e-08, -2.700949973406089e-09,  1.414877374807550e-10, -6.665255780972336e-12,
  2.855901332162079e-13, -1.121841517162296e-14,  6.765554668084490e-03, -2.608069935705095e-03,  5.367669739925741e-04, -7.554586797758637e-05,  8.103448835795508e-06,
 -7.039388335168120e-07,  5.147833727482999e-08, -3.255170400177388e-09,  1.815081962515474e-10, -9.059070584091881e-12,  4.094904025758477e-13, -1.690115083832798e-14,
  3.957266849528070e-03, -1.632064899203371e-03,  3.598767778740021e-04, -5.404822922830297e-05,  6.157407299986051e-06, -5.654939205504335e-07,  4.353351647495673e-08,
 -2.886475016762141e-09,  1.681573876359872e-10, -8.739590928625655e-12,  4.101288222997435e-13, -1.752322764955083e-14,  1.614937204859688e-03, -6.909017163153886e-04,
  1.582733178180040e-04, -2.464637774764072e-05,  2.904017993112998e-06, -2.751509914091611e-07,  2.180113108756557e-08, -1.484495659084463e-09,  8.863413098613761e-11,
 -4.712363400745441e-12,  2.258315954254517e-13, -9.837565083742355e-15,  2.637334057220647e-03, -8.304285187843781e-05,  1.848891655163553e-06, -3.557656350602367e-08,
  6.286128178429407e-10, -1.046643743823889e-11,  1.664838177402069e-13, -2.551622195526722e-15,  3.790285622046865e-17, -5.480247560752143e-19,  7.737689253830582e-21,
 -1.069388685510797e-22,  8.590681179661851e-03, -3.913692536594834e-04,  1.279966316960775e-05, -3.531399173379161e-07,  8.693515774081471e-09, -1.966377822922366e-10,
  4.160071481276449e-12, -8.329688209447917e-14,  1.591714522729037e-15, -2.920622312789124e-17,  5.170053247785467e-19, -8.859429688742864e-21,  1.381275393535054e-02,
 -9.505700818230690e-04,  4.416277299982805e-05, -1.654088377323313e-06,  5.360027466216835e-08, -1.559390728107772e-09,  4.165205773415579e-11, -1.036695407541035e-12,
  2.429676756580306e-14, -5.403738834365889e-16,  1.147275824089815e-17, -2.335282535581495e-19,  1.554787560535706e-02, -1.567937082849091e-03,  9.908138644598426e-05,
 -4.848360580150042e-06,  1.997131657367944e-07, -7.233164305670191e-09,  2.364908340901246e-10, -7.103663695922565e-12,  1.984856807742529e-13, -5.206638315909672e-15,
  1.291342193219925e-16, -3.043666552532011e-18,  1.381631437904431e-02, -1.945010161215190e-03,  1.613890507727698e-04, -1.001947206537196e-05,  5.110139143196383e-07,
 -2.248674438640120e-08,  8.796190898304420e-10, -3.120297868681361e-11,  1.018089422618238e-12, -3.087757429856024e-14,  8.775948816930335e-16, -2.351055980021099e-17,
  1.034462720664871e-02, -1.935328832631042e-03,  2.042483196177284e-04, -1.567504604716852e-05,  9.675193645516880e-07, -5.066384952625788e-08,  2.325683903368104e-09,
 -9.566840398152216e-11,  3.582377158935773e-12, -1.235524928392124e-13,  3.960445508074106e-15, -1.187532507095424e-16,  6.834786419225464e-03, -1.622649281065495e-03,
  2.111629913599529e-04, -1.953598696783262e-05,  1.427804310611629e-06, -8.723712067878452e-08,  4.614778179043802e-09, -2.164228736493188e-10,  9.152556054437070e-12,
 -3.535150375055037e-13,  1.259496402228634e-14, -4.168138471913969e-16,  4.136862470826493e-03, -1.193633496857033e-03,  1.856605378529377e-04, -2.018224905681874e-05,
  1.708005716274555e-06, -1.193426973956624e-07,  7.142318825558492e-09, -3.753888735246903e-10,  1.764279549575549e-11, -7.516449057930971e-13,  2.933775951109761e-14,
 -1.056918712434715e-15,  2.361339428698684e-03, -7.949266249257340e-04,  1.431464387666882e-04, -1.779651367973960e-05,  1.702983842102340e-06, -1.331901139796989e-07,
  8.842397531005699e-09, -5.114370150370511e-10,  2.626282655451700e-11, -1.214608216040313e-12,  5.116161855619792e-14, -1.978145285037811e-15,  1.287457636706676e-03,
 -4.864120083552542e-04,  9.812012162184145e-05, -1.355460804594057e-05,  1.429242615167543e-06, -1.222201634103319e-07,  8.809656502228569e-09, -5.497100932783915e-10,
  3.027822509770599e-11, -1.494156720260696e-12,  6.683432873145451e-14, -2.731845362440412e-15,  6.497294797522341e-04, -2.654806817817844e-04,  5.798299623299366e-05,
 -8.630221458961142e-06,  9.750288455565903e-07, -8.885933620237297e-08,  6.792193979918778e-09, -4.474024933769059e-10,  2.590611547368814e-11, -1.338828503052319e-12,
  6.249937199133945e-14, -2.657385386342123e-15,  2.428836905566195e-04, -1.035970172329760e-04,  2.365620285641191e-05, -3.672369180062640e-06,  4.314396763605448e-07,
 -4.076553310090064e-08,  3.221609314510100e-09, -2.188318145866354e-10,  1.303560450409533e-11, -6.915504198398110e-13,  3.307322147687312e-14, -1.437924935512424e-15,
  2.332263150651886e-03, -6.980302086970719e-05,  1.476054195283236e-06, -2.699833330548901e-08,  4.540911821074659e-10, -7.207415208144441e-12,  1.094309867733884e-13,
 -1.602768798065168e-15,  2.277411464797898e-17, -3.152593822763888e-19,  4.264973369715188e-21, -5.651956274341958e-23,  7.206144440430586e-03, -3.038252290450608e-04,
  9.282410854357319e-06, -2.407815892462103e-07,  5.596348205082818e-09, -1.198738162940552e-10,  2.407364842612128e-12, -4.584745052742988e-14,  8.347146350101022e-16,
 -1.461464094235971e-17,  2.471919227810880e-19, -4.052432040313776e-21,  1.060921631660208e-02, -6.641455560003507e-04,  2.858247145338449e-05, -1.000163535533226e-06,
  3.044562370892971e-08, -8.354571154969762e-10,  2.111659477224298e-11, -4.986867445682487e-13,  1.111526797153761e-14, -2.355832341014544e-16,  4.775153750652251e-18,
 -9.295215838754428e-20,  1.055731759742032e-02, -9.629662418301305e-04,  5.614065575891185e-05, -2.558499605097990e-06,  9.878255621344764e-08, -3.369603564168654e-09,
  1.041644461893124e-10, -2.967856913788261e-12,  7.887675070804808e-14, -1.972849935203979e-15,  4.675624279535072e-17, -1.055185869505709e-18,  8.016047691567338e-03,
 -1.023809503752150e-03,  7.841020845226984e-05, -4.536043790026065e-06,  2.170308807806309e-07, -9.005734074179820e-09,  3.335900302187964e-10, -1.124531635496500e-11,
  3.497352563734937e-13, -1.013761969865796e-14,  2.760345318488835e-16, -7.100121525649298e-18,  4.970230153549653e-03, -8.516149881606177e-04,  8.339120962465489e-05,
 -5.989577497429088e-06,  3.482329711750545e-07, -1.726410752709590e-08,  7.534528238766161e-10, -2.957200127465934e-11,  1.059819757246614e-12, -3.507871800251343e-14,
  1.081744460011678e-15, -3.127449092343472e-17,  2.650660532125421e-03, -5.844599373297757e-04,  7.124939061915181e-05, -6.218679085811208e-06,  4.311937705446770e-07,
 -2.510988396857356e-08,  1.270906901866954e-09, -5.721737817285241e-11,  2.329637847829893e-12, -8.685393253068483e-14,  2.993718497578795e-15, -9.605273940755554e-17,
  1.274827960896841e-03, -3.474019902195427e-04,  5.127685162218639e-05, -5.316820454335408e-06,  4.311008383450793e-07, -2.896879774980129e-08,  1.672731445920252e-09,
 -8.506387513090115e-11,  3.877800627108494e-12, -1.605989458603584e-13,  6.105579708854958e-15, -2.146374871210489e-16,  5.779252502004862e-04, -1.869954970701300e-04,
  3.242730283061943e-05, -3.895154665840760e-06,  3.612461135412024e-07, -2.745718883458331e-08,  1.775783717852513e-09, -1.002696524254555e-10,  5.036092922207823e-12,
 -2.281883007092968e-13,  9.431088172110489e-15, -3.582974412787040e-16,  2.552745425830466e-04, -9.420052557438841e-05,  1.856641632823701e-05, -2.510411918235362e-06,
  2.595621819371727e-07, -2.180128768864216e-08,  1.545804556171298e-09, -9.500991662598802e-11,  5.160920336956890e-12, -2.514332191245228e-13,  1.111417850272059e-14,
 -4.493419199659386e-16,  1.089900895113398e-04, -4.404754540141454e-05,  9.513436259819772e-06, -1.401245553684112e-06,  1.567890615891232e-07, -1.416257835250354e-08,
  1.073736171859454e-09, -7.019602410045712e-11,  4.036401177415646e-12, -2.072629799513471e-13,  9.617944455594403e-15, -4.066892900131849e-16,  3.680023538299533e-05,
 -1.564194484500271e-05,  3.558730385497572e-06, -5.505121202768953e-07,  6.446126865493674e-08, -6.071821738183566e-09,  4.784429825500519e-10, -3.240988056134839e-11,
  1.925660772816095e-12, -1.019107888082262e-13,  4.862740982647914e-15, -2.109635141379154e-16,  2.074777070455920e-03, -5.917709284593716e-05,  1.191333895484752e-06,
 -2.075726321161351e-08,  3.329562669749088e-10, -5.046670197875514e-12,  7.325942243370635e-14, -1.026968588054986e-15,  1.397930412494907e-17, -1.855370933233742e-19,
  2.408273389676848e-21, -3.064227339112750e-23,  6.122994756335547e-03, -2.397650309272458e-04,  6.860258986586323e-06, -1.676684076773832e-07,  3.686416944474511e-09,
 -7.490911877161869e-11,  1.430318062585284e-12, -2.594724915665378e-14,  4.507031206704576e-16, -7.539215866159853e-18,  1.219842046015663e-19, -1.915236625906549e-21,
  8.344157816885665e-03, -4.763243654945857e-04,  1.902965701706882e-05, -6.232838640439564e-07,  1.785214335878268e-08, -4.627172417823839e-10,  1.108084722494130e-11,
 -2.485654073749937e-13,  5.274061027109282e-15, -1.066141221181230e-16,  2.064655122530241e-18, -3.845890407122451e-20,  7.441399363222338e-03, -6.141414456153364e-04,
  3.307138257631433e-05, -1.405136892464605e-06,  5.089508705085195e-08, -1.636297540690823e-09,  4.785279968788560e-11, -1.293841095885100e-12,  3.271837768391794e-14,
 -7.804671242585742e-16,  1.767756163086796e-17, -3.820038254337575e-19,  4.898932810301048e-03, -5.665401760742879e-04,  4.003209145111810e-05, -2.157443620774948e-06,
  9.681384753188007e-08, -3.787200433763385e-09,  1.327983671888383e-10, -4.252425580643426e-12,  1.260040821994813e-13, -3.488979161614410e-15,  9.096147307785052e-17,
 -2.245052889952012e-18,  2.548563974386186e-03, -3.982857255113564e-04,  3.610410868531462e-05, -2.422646767854725e-06,  1.324702743979791e-07, -6.208845538479201e-09,
  2.572720855247154e-10, -9.621681386071129e-12,  3.296004313750642e-13, -1.045621901278738e-14,  3.098080081437677e-16, -8.625299069157416e-18,  1.106321923705629e-03,
 -2.252729218789539e-04,  2.562514471838617e-05, -2.103305342990348e-06,  1.379813260891332e-07, -7.639301316000738e-09,  3.691034439046682e-10, -1.591820504044435e-11,
  6.227256374925038e-13, -2.236643881804590e-14,  7.444760125231604e-16, -2.311720379106253e-17,  4.230000784312966e-04, -1.081876574322302e-04,  1.507983428449114e-05,
 -1.485390714646185e-06,  1.149833308811795e-07, -7.407241708979083e-09,  4.114872872266861e-10, -2.019323792182812e-11,  8.907160232467741e-13, -3.577828360394593e-14,
  1.322050306080470e-15, -4.526073394174373e-17,  1.508785499964098e-04, -4.665793816314444e-05,  7.754652574915838e-06, -8.963028000923788e-07,  8.027362808410384e-08,
 -5.910510780498363e-09,  3.713142092688800e-10, -2.041458307792417e-11,  1.000460866568796e-12, -4.431492447043475e-14,  1.793488478322470e-15, -6.682443316670453e-17,
  5.302187458356223e-05, -1.903406871537145e-05,  3.652152683148238e-06, -4.817946814211266e-07,  4.870841858347153e-08, -4.008216483560651e-09,  2.789305898502440e-10,
 -1.685246399838557e-11,  9.011150192507200e-13, -4.326887281563105e-14,  1.887190685899667e-15, -7.536166263319782e-17,  1.874399027033368e-05, -7.477357359937886e-06,
  1.593914496102017e-06, -2.319183392252503e-07,  2.566030945389587e-08, -2.294146579216480e-09,  1.722977637570349e-10, -1.116686449454381e-11,  6.370142461662826e-13,
 -3.246995469330899e-14,  1.496544183299820e-15, -6.288436591467342e-17,  5.623206463193755e-06, -2.380536536274986e-06,  5.393166935935380e-07, -8.309276486245937e-08,
  9.692838320363512e-09, -9.097770391389824e-10,  7.145152536562591e-11, -4.825225617365701e-12,  2.858672558843440e-13, -1.508784918726148e-14,  7.180954463228983e-16,
 -3.107922798791668e-17,  1.855670957813181e-03, -5.055930159746915e-05,  9.711644995719321e-07, -1.615084018162314e-08,  2.475132417291391e-10, -3.588523151265516e-12,
  4.988162936281735e-14, -6.702544332121464e-16,  8.752473419442634e-18, -1.115294695284568e-19,  1.390727031829048e-21, -1.701208396864606e-23,  5.262235342456465e-03,
 -1.920311989150088e-04,  5.158125011769752e-06, -1.190266684057712e-07,  2.480131757870023e-09, -4.789080318547446e-11,  8.707758107588004e-13, -1.506867724442244e-14,
  2.500513192345019e-16, -4.001184107983835e-18,  6.200083891656997e-20, -9.332978632376417e-22,  6.701998653300949e-03, -3.497689020885231e-04,  1.299973986588062e-05,
 -3.992985451793172e-07,  1.077880748534107e-08, -2.642727954527576e-10,  6.003789304150557e-12, -1.280717126350325e-13,  2.589476991773010e-15, -4.997126010779576e-17,
  9.253211196714833e-19, -1.650544828913425e-20,  5.423895082450706e-03, -4.053087872003447e-04,  2.018867081470060e-05, -8.007021938132550e-07,  2.723611448819135e-08,
 -8.260397015610657e-10,  2.287008755392251e-11, -5.871544081868995e-13,  1.413442564158650e-14, -3.216796508304575e-16,  6.965255094820141e-18, -1.441527472877889e-19,
  3.140113333018947e-03, -3.283110441118821e-04,  2.140459515314644e-05, -1.074763765886514e-06,  4.523732686677473e-08, -1.668251213345062e-09,  5.537093433363858e-11,
 -1.684000631876533e-12,  4.753012013239840e-14, -1.256806476073629e-15,  3.136173858070713e-17, -7.424212772042203e-19,  1.389670951920504e-03, -1.973467497874501e-04,
  1.653144603729009e-05, -1.034950928779361e-06,  5.316135485952592e-08, -2.353052020517647e-09,  9.247425536687754e-11, -3.291957268593850e-12,  1.076755962408342e-13,
 -3.270525532301784e-15,  9.300520670712810e-17, -2.490778996307289e-18,  4.962419229716927e-04, -9.279986612472532e-05,  9.814947327654484e-06, -7.554522325368112e-07,
  4.677350675129254e-08, -2.456567951281078e-09,  1.130715633572829e-10, -4.662163409462700e-12,  1.749157036506403e-13, -6.041672816831313e-15,  1.938655680186870e-16,
 -5.816378656739608e-18,  1.514030620980735e-04, -3.610799642455600e-05,  4.729862913877833e-06, -4.408271055660142e-07,  3.246552495319905e-08, -1.998795993983652e-09,
  1.065243041190969e-10, -5.031546814532657e-12,  2.142298332620471e-13, -8.327272608495842e-15,  2.984377071933067e-16, -9.930081796315087e-18,  4.222094415477198e-05,
 -1.240086999087107e-05,  1.965269602279211e-06, -2.176211378209344e-07,  1.875026051188981e-08, -1.332880544975621e-09,  8.109048902054450e-11, -4.329014781455933e-12,
  2.064842654828563e-13, -8.920271156201415e-15,  3.527561371827417e-16, -1.286479768113158e-17,  1.160401139247210e-05, -4.033396957704508e-06,  7.502729461479627e-07,
 -9.621598496009146e-08,  9.480772546844293e-09, -7.621890405343941e-10,  5.192497036299905e-11, -3.076826875261808e-12,  1.616143670956786e-13, -7.634118898702743e-15,
  3.279747296169549e-16, -1.291607982888399e-17,  3.318426652778334e-06, -1.303433195332163e-06,  2.735806856008352e-07, -3.924072470142412e-08,  4.285288422224109e-09,
 -3.785756805601065e-10,  2.812370576587538e-11, -1.804620551024982e-12,  1.020053724837439e-13, -5.155781794627498e-15,  2.357913970813476e-16, -9.837210146353635e-18,
  8.677028422372711e-07, -3.656081323524513e-07,  8.242409247272371e-08, -1.264010910829597e-08,  1.468082951470772e-09, -1.372394578897395e-10,  1.073799269011731e-11,
 -7.226190985566448e-13,  4.267158978010346e-14, -2.245315086351063e-15,  1.065594879549622e-16, -4.599600014305294e-18,  1.667833269529597e-03, -4.350296380649098e-05,
  7.989418027783842e-07, -1.270560180527142e-08,  1.863433456502386e-10, -2.588279968090472e-12,  3.450085762549477e-14, -4.449879386893544e-16,  5.581658836029915e-18,
 -6.837898136874120e-20,  8.200357935739479e-22, -9.657474004425496e-24,  4.568459414392863e-03, -1.558709514596907e-04,  3.939611651859458e-06, -8.600033455389003e-08,
  1.701290780741051e-09, -3.126885155451379e-11,  5.422197581415896e-13, -8.963161598957523e-15,  1.422765583020187e-16, -2.180444965851844e-18,  3.239491237440959e-20,
 -4.680234991065168e-22,  5.484239080412076e-03, -2.623617442165185e-04,  9.090895057334641e-06, -2.623621454569450e-07,  6.685961232471757e-09, -1.552884547224874e-10,
  3.351167720895009e-12, -6.806025609549664e-14,  1.312698885914555e-15, -2.420608033791221e-17,  4.289503917371025e-19, -7.332621803785519e-21,  4.073842764543026e-03,
 -2.759111688461105e-04,  1.273300392570525e-05, -4.720586310943654e-07,  1.509733973188795e-08, -4.323771953468735e-10,  1.134288333603933e-11, -2.767154763605260e-13,
  6.345095181384705e-15, -1.378428724756544e-16,  2.854436298929822e-18, -5.659586836521959e-20,  2.102195498523754e-03, -1.984936948910936e-04,  1.194567582303017e-05,
 -5.590840209255579e-07,  2.207994443085390e-08, -7.678102735825853e-10,  2.412596768536259e-11, -6.969237310079220e-13,  1.873599870056513e-14, -4.730573942643925e-16,
  1.129635857336510e-17, -2.564249615504960e-19,  8.026554096769450e-04, -1.032374462183220e-04,  7.981753003527267e-06, -4.657832258612786e-07,  2.245742716727486e-08,
 -9.380015021197611e-10,  3.493523481732972e-11, -1.182843858980246e-12,  3.691150251915961e-14, -1.072529121778802e-15,  2.924781074998908e-17, -7.527995063451250e-19,
  2.386894715814120e-04, -4.077734530416573e-05,  3.997461272707820e-06, -2.878182142802572e-07,  1.678282143521666e-08, -8.345512923343721e-10,  3.652801887157887e-11,
 -1.437489660594140e-12,  5.163801936542795e-14, -1.712512379298655e-15,  5.289237758712356e-17, -1.530928206663554e-18,  5.850942552024843e-05, -1.292531654426195e-05,
  1.583672505248801e-06, -1.391211078773337e-07,  9.715537722030343e-09, -5.699685110797044e-10,  2.906283452110158e-11, -1.317979146840929e-12,  5.404035043456662e-14,
 -2.028289495714630e-15,  7.035611752336162e-17, -2.270762136703018e-18,  1.271979710229070e-05, -3.524264180768333e-06,  5.296895989523920e-07, -5.593873394041379e-08,
  4.618414091431766e-09, -3.158554831302730e-10,  1.855073754133721e-11, -9.588625208883492e-13,  4.439684941316963e-14, -1.866091654855154e-15,  7.194548106811997e-17,
 -2.562826712515185e-18,  2.692575492624566e-06, -9.012270014871305e-07,  1.617531945905124e-07, -2.008244578628483e-08,  1.921817370939369e-09, -1.504622529895227e-10,
  1.000650743110710e-11, -5.800507122359947e-13,  2.986111098029376e-14, -1.384723210203158e-15,  5.848708541415535e-17, -2.267523679806935e-18,  6.076950780326963e-07,
 -2.343071917643344e-07,  4.828686049204771e-08, -6.810385492215077e-09,  7.324362786689347e-10, -6.381249937897290e-11,  4.680923652688034e-12, -2.969152061535825e-13,
  1.660674755881770e-14, -8.312878920786895e-16,  3.768077803345777e-17, -1.559234853745403e-18,  1.354290804770403e-07, -5.674677124827360e-08,  1.271993319694124e-08,
 -1.940119486806147e-09,  2.242045419911438e-10, -2.086183757579870e-11,  1.625275946710192e-12, -1.089382927708796e-13,  6.409150847806292e-15, -3.360786116049704e-16,
  1.589857652497612e-17, -6.842002546614812e-19,  1.505705570535821e-03, -3.767427442713479e-05,  6.627902488707629e-07, -1.009714417578390e-08,  1.419441401311140e-10,
 -1.891659244259413e-12,  2.421245775612783e-14, -3.001760615747989e-16,  3.620829743204079e-18, -4.270733913027430e-20,  4.929433178840040e-22, -5.598089907286195e-24,
  4.002069313724614e-03, -1.280626472008803e-04,  3.052371714456000e-06, -6.315256546076111e-08,  1.188098747417680e-09, -2.081722040719214e-11,  3.447649612733835e-13,
 -5.451487681043701e-15,  8.287997730501962e-17, -1.217961561616704e-18,  1.736853588540490e-20, -2.410919560882677e-22,  4.562595328523479e-03, -2.006199351826306e-04,
  6.494481365888536e-06, -1.764347922998486e-07,  4.251612438271496e-09, -9.368268191348735e-11,  1.922967364383992e-12, -3.722673882035467e-14,  6.856573800265296e-16,
 -1.209322699720991e-17,  2.052679886996894e-19, -3.365423002060908e-21,  3.143087476287869e-03, -1.931721766544329e-04,  8.273869956059002e-06, -2.871638131298748e-07,
  8.646141354138255e-09, -2.340836267589512e-10,  5.824250319583176e-12, -1.351240865201901e-13,  2.953408566756162e-15, -6.128192250281352e-17,  1.214262137150838e-18,
 -2.307481120513019e-20,  1.464023631672078e-03, -1.247498589111312e-04,  6.935916069329514e-06, -3.027848485430263e-07,  1.122652835412000e-08, -3.682929358550850e-10,
  1.095936945615192e-11, -3.007679198446526e-13,  7.702861580559978e-15, -1.857175722081969e-16,  4.243877142011748e-18, -9.236681833683692e-20,  4.890727031770059e-04,
 -5.680991657483687e-05,  4.050906998784276e-06, -2.202371347478688e-07,  9.962527295598323e-09, -3.924819596605217e-10,  1.384632447080548e-11, -4.456501759718734e-13,
  1.326007131085310e-14, -3.683561639530086e-16,  9.626242879853123e-18, -2.379543482070848e-19,  1.227581451356982e-04, -1.906350985438748e-05,  1.727633923879627e-06,
 -1.161226083686847e-07,  6.365850706286967e-09, -2.992317496528130e-10,  1.243572992796318e-11, -4.664022831436662e-13,  1.601886910056594e-14, -5.093621947512249e-16,
  1.512190814547353e-17, -4.216871671794472e-19,  2.441052336963647e-05, -4.961778201680409e-06,  5.661102793273451e-07, -4.670675091799764e-08,  3.083427024283137e-09,
 -1.718926542607147e-10,  8.364760527020301e-12, -3.633462421517764e-13,  1.431534251500161e-14, -5.177189216240140e-16,  1.734693512931223e-17, -5.420485758898515e-19,
  4.140947699711168e-06, -1.074391064193075e-06,  1.522871500757991e-07, -1.526681825101884e-08,  1.202983686831408e-09, -7.887200570557482e-11,  4.457576609439562e-12,
 -2.224345524286629e-13,  9.970814246109168e-15, -4.067458809037155e-16,  1.525336797633989e-17, -5.295840589830792e-19,  6.667195273952536e-07, -2.135295389979385e-07,
  3.678150768553678e-08, -4.401008270219936e-09,  4.074076215794007e-10, -3.095476205175094e-11,  2.003436419192225e-12, -1.132934177453035e-13,  5.701814133889280e-15,
 -2.589723397042500e-16,  1.073144584730802e-17, -4.088102514927015e-19,  1.157621544007294e-07, -4.364930803981084e-08,  8.801965651867350e-09, -1.217058780977846e-09,
  1.285657493158136e-10, -1.102102153096602e-11,  7.966480031403530e-13, -4.986154805308077e-14,  2.755038637302647e-15, -1.363820323217108e-16,  6.119143917805894e-18,
 -2.508512137170493e-19,  2.142254631225269e-08, -8.917007777709319e-09,  1.985250770321945e-09, -3.008838174756813e-10,  3.456758231357179e-11, -3.199155936757069e-12,
  2.480013747315368e-13, -1.654698467222310e-14,  9.693932295858547e-16, -5.063326484585724e-17,  2.386544756805450e-18, -1.023583732837015e-19,  1.364896691682238e-03,
 -3.282069003479105e-05,  5.540976562282073e-07, -8.099769433285312e-09,  1.093032431891637e-10, -1.399622081061508e-12,  1.722310733925047e-14, -2.055372043793651e-16,
  2.386105979437689e-18, -2.714671845093071e-20,  3.017093383600204e-22, -3.303568673415908e-24,  3.534274978863968e-03, -1.063807925239221e-04,  2.396185461477891e-06,
 -4.707114912565118e-08,  8.435268345109081e-10, -1.411105484226216e-11,  2.235099853653615e-13, -3.385075249027309e-15,  4.934957175450669e-17, -6.962355635252644e-19,
  9.539852636454718e-21, -1.273542553399772e-22,  3.852081697565521e-03, -1.561042166600220e-04,  4.730839514959057e-06, -1.212051126332584e-07,  2.766332693135275e-09,
 -5.791234636809022e-11,  1.132162769603174e-12, -2.091676003269628e-14,  3.682981379380948e-16, -6.219293617607130e-18,  1.012074291157887e-19, -1.592785755815440e-21,
  2.483862456369512e-03, -1.387254814108343e-04,  5.524936887935895e-06, -1.798015196258799e-07,  5.103449794124292e-09, -1.307704495218291e-10,  3.089112606246132e-12,
 -6.821802575268760e-14,  1.422386625774663e-15, -2.820888249835903e-17,  5.351405116862292e-19, -9.751583334490044e-21,  1.056661894962384e-03, -8.122196862393781e-05,
  4.176694316225965e-06, -1.702274382695371e-07,  5.930221595681477e-09, -1.836495047676798e-10,  5.178073369546936e-12, -1.350626326831926e-13,  3.296224646503297e-15,
 -7.590557905642928e-17,  1.660064250372486e-18, -3.464428501541994e-20,  3.130743020625235e-04, -3.276153689776038e-05,  2.154100657249793e-06, -1.090924914278989e-07,
  4.629343798350329e-09, -1.719882607737845e-10,  5.745987498157319e-12, -1.757474120713440e-13,  4.984258175549457e-15, -1.323166898951479e-16,  3.312091341187124e-18,
 -7.858903114652101e-20,  6.727587331506769e-05, -9.452746086421336e-06,  7.902939471958356e-07, -4.951004766478567e-08,  2.548190078727307e-09, -1.130826131874204e-10,
  4.456779040029678e-12, -1.591119749151204e-13,  5.218755107369662e-15, -1.589209301501004e-16,  4.529715049313111e-18, -1.215529998931653e-19,  1.098310147749640e-05,
 -2.040573223921970e-06,  2.159111447754263e-07, -1.667614355596198e-08,  1.037819105129648e-09, -5.484040267761054e-11,  2.541012073488894e-12, -1.054955866554421e-13,
  3.985658894205455e-15, -1.386203651361249e-16,  4.478180605808845e-18, -1.352329741663799e-19,  1.460892223279484e-06, -3.521853839178494e-07,  4.681161927022807e-08,
 -4.434226464540068e-09,  3.321452609435145e-10, -2.080295655186350e-11,  1.127767970101142e-12, -5.417083215179452e-14,  2.344542668453692e-15, -9.259275344213583e-17,
  3.369599270942740e-18, -1.137763360534175e-19,  1.773211974460009e-07, -5.394740608582634e-08,  8.865966680841512e-09, -1.017289654051342e-09,  9.070588292861849e-11,
 -6.663088489089557e-12,  4.182697423993992e-13, -2.300485150781259e-14,  1.128780173641085e-15, -5.009025635902212e-17,  2.031792006223076e-18, -7.589459634041364e-20,
  2.308932251828958e-08, -8.474688575111103e-09,  1.665307655986002e-09, -2.249398535633445e-10,  2.326751350528637e-11, -1.957174156134191e-12,  1.390768933682795e-13,
 -8.571016628095759e-15,  4.669643418364114e-16, -2.282134557468987e-17,  1.011997872158360e-18, -4.104352391785454e-20,  3.442900732967696e-09, -1.421667614576761e-09,
  3.139626444816519e-10, -4.722748812669906e-11,  5.388563402424448e-12, -4.955690198499754e-13,  3.819608661333765e-14, -2.535046008969328e-15,  1.477925510617593e-16,
 -7.684885287651377e-18,  3.607162779704230e-19, -1.541164762402729e-20,  1.241903251834749e-03, -2.874895786888772e-05,  4.665375377687195e-07, -6.554210426157898e-09,
  8.501923070046951e-11, -1.047526099271751e-12,  1.240522011590315e-14, -1.427457162796384e-16,  1.595177744690371e-18, -1.753990088391437e-20,  1.883580002103180e-22,
 -1.961372484468544e-24,  3.143811209187892e-03, -8.926098782783301e-05,  1.903860135122632e-06, -3.557031969436275e-08,  6.081035352110802e-10, -9.726526573558776e-12,
  1.475363137868397e-13, -2.142975700984814e-15,  2.999106906638056e-17, -4.066882420749538e-19,  5.360595985086563e-21, -6.885144383560220e-23,  3.295103872988657e-03,
 -1.234022382695755e-04,  3.508014525148870e-06, -8.491099201972103e-08,  1.838462288901680e-09, -3.661870099751467e-11,  6.826990547866502e-13, -1.205118961023276e-14,
  2.030772394540483e-16, -3.286555102098865e-18,  5.132216952617882e-20, -7.759775868789400e-22,  2.005421704966671e-03, -1.019438071860476e-04,  3.782414435415307e-06,
 -1.156090083041199e-07,  3.097787030179089e-09, -7.521868875084599e-11,  1.688790469237587e-12, -3.553260249952067e-14,  7.073627949184639e-16, -1.341816864458950e-17,
  2.438724419747985e-19, -4.263888098856049e-21,  7.876214119671543e-04, -5.460720216360042e-05,  2.600870322048966e-06, -9.907532115200434e-08,  3.245991160681990e-09,
 -9.496870149846682e-11,  2.538822174174772e-12, -6.297309517383504e-14,  1.465170043740267e-15, -3.223662738743975e-17,  6.749225273029351e-19, -1.350802928898332e-20,
  2.096882985544629e-04, -1.972589305814711e-05,  1.196268475291054e-06, -5.644576087066958e-08,  2.247349356317448e-09, -7.874332331752712e-11,  2.491321016530809e-12,
 -7.240729349227158e-14,  1.956973848023328e-15, -4.963547092825383e-17,  1.189739851793216e-18, -2.708829278050481e-20,  3.913851297208478e-05, -4.954240788757086e-06,
  3.815426499300636e-07, -2.225301962340437e-08,  1.074233980833083e-09, -4.496463033738641e-11,  1.679031511529106e-12, -5.700740681893305e-14,  1.783941355397962e-15,
 -5.197555385451864e-17,  1.420941982941341e-18, -3.665656471836418e-20,  5.318710536207585e-06, -8.973886093465094e-07,  8.773856728363375e-08, -6.325909674878667e-09,
  3.702280163399925e-10, -1.850353416883015e-11,  8.146838321477615e-13, -3.226585970886269e-14,  1.166799902216863e-15, -3.895738332542124e-17,  1.211342366720791e-18,
 -3.529326103442363e-20,  5.595079200645423e-07, -1.243122685423078e-07,  1.540794337085794e-08, -1.372866861987540e-09,  9.737800874727748e-11, -5.806384048705972e-12,
  3.010048716704303e-13, -1.387795390338386e-14,  5.784097607672097e-16, -2.206020909513154e-17,  7.772557378888136e-19, -2.546801757469128e-20,  5.097363627027565e-08,
 -1.461117588706692e-08,  2.276288277735961e-09, -2.491259286629856e-10,  2.129758021518702e-11, -1.506483804753071e-12,  9.139512531413791e-14, -4.873281742453397e-15,
  2.324479158237420e-16, -1.005119226406716e-17,  3.981129156282533e-19, -1.454903296894302e-20,  4.858137089210963e-09, -1.725897392916126e-09,  3.288590995329029e-10,
 -4.321056614264309e-11,  4.360780920425538e-12, -3.587996016581554e-13,  2.499489186313263e-14, -1.513001288423132e-15,  8.110183854755176e-17, -3.905418893335796e-18,
  1.708633900697765e-19, -6.844922975892076e-21,  5.639275351146075e-10, -2.305987556706656e-10,  5.043111978596959e-11, -7.518194073183464e-12,  8.508342227928819e-13,
 -7.767042290708870e-14,  5.946210905087708e-15, -3.922234041713952e-16,  2.273801455495619e-17, -1.176222911722025e-18,  5.494745254333898e-20, -2.337346659185095e-21,
  1.133904573748616e-03, -2.530962792882809e-05,  3.954064126066839e-07, -5.346592659732991e-09,  6.674972587310826e-11, -7.925305375214461e-13,  9.037526716316030e-15,
 -1.005008723980112e-16,  1.081084406693510e-18, -1.146018924377149e-20,  1.216343975219079e-22, -1.133476593140710e-24,  2.814741155325340e-03, -7.558570624516436e-05,
  1.529546526945762e-06, -2.722312986157730e-08,  4.446294689817799e-10, -6.809429977022323e-12,  9.903200180883517e-14, -1.381396928975498e-15,  1.857821993926957e-17,
 -2.423477377332882e-19,  3.079697980487639e-21, -3.799449425710262e-23,  2.851809152453119e-03, -9.896418494426217e-05,  2.644005909076885e-06, -6.056713694087920e-08,
  1.245981869387504e-09, -2.364544707650981e-11,  4.209379680236640e-13, -7.107830063766316e-15,  1.147537255716191e-16, -1.781624600833523e-18,  2.672146698291690e-20,
 -3.885212309141726e-22,  1.650433810930460e-03, -7.649266153506789e-05,  2.649158246343728e-06, -7.617459595989682e-08,  1.929678985720195e-09, -4.445596049693854e-11,
  9.497187588724350e-13, -1.905720009652367e-14,  3.625440532889523e-16, -6.583274966336564e-18,  1.147082709460949e-19, -1.925626248093834e-21,  6.043568233748037e-04,
 -3.779842084641922e-05,  1.670190994960067e-06, -5.954012436342652e-08,  1.836538379232018e-09, -5.080912121249911e-11,  1.288860397839276e-12, -3.042053743295761e-14,
  6.751353256244214e-16, -1.419890586347922e-17,  2.846877525082063e-19, -5.465977671854848e-21,  1.463632788391781e-04, -1.235541603740989e-05,  6.916002405801328e-07,
 -3.041874904209485e-08,  1.136779238358355e-09, -3.757648666164712e-11,  1.126089767913060e-12, -3.110301269283024e-14,  8.011395384676523e-16, -1.941270395422339e-17,
  4.455166104245410e-19, -9.731532502056341e-21,  2.407251571118115e-05, -2.734264055670637e-06,  1.938033762096187e-07, -1.051564310195006e-08,  4.758297495698173e-10,
 -1.877448712983041e-11,  6.638129836476375e-13, -2.142009684628414e-14,  6.390765429898022e-16, -1.780151691624447e-17,  4.664314740484325e-19, -1.155834242980737e-20,
  2.764434834239992e-06, -4.209108394841051e-07,  3.791129693831264e-08, -2.545565763528228e-09,  1.398214677680139e-10, -6.597320179600220e-12,  2.755372608229051e-13,
 -1.039304349730552e-14,  3.591596681311847e-16, -1.149394900387877e-17,  3.434671234099788e-19, -9.640561464533094e-21,  2.327677679244644e-07, -4.726541541011859e-08,
  5.433702169908151e-09, -4.534718665558882e-10,  3.034791783084211e-11, -1.717202556024947e-12,  8.487666875085603e-14, -3.746010034341113e-15,  1.499674858845443e-16,
 -5.510514957370677e-18,  1.875521979823526e-19, -5.950920204870273e-21,  1.592864245952219e-08, -4.262582934699122e-09,  6.252026085815939e-10, -6.490030360773186e-11,
  5.294163193769429e-12, -3.590898537615897e-13,  2.097568825255686e-14, -1.080655742840905e-15,  4.995466662216667e-17, -2.098938915537910e-18,  8.097171264392559e-20,
 -2.888200782624150e-21,  1.087428188987951e-09, -3.713257406075781e-10,  6.820670929352557e-11, -8.674996341121978e-12,  8.505483654500758e-13, -6.820321483533467e-14,
  4.642867122840297e-15, -2.752687594915337e-16,  1.448096851647100e-17, -6.855512642492454e-19,  2.953185628172893e-20, -1.166486281838382e-21,  9.451011649853529e-11,
 -3.818316330323276e-11,  8.251822215675985e-12, -1.216910888004019e-12,  1.363793610082741e-13, -1.234060608148107e-14,  9.372726632505677e-16, -6.137976269003551e-17,
  3.535014773915100e-18, -1.817698303022536e-19,  8.444818726257390e-21, -3.574160250281507e-22,  1.038610358234388e-03, -2.238598971112595e-05,  3.371679237863943e-07,
 -4.394508004443612e-09,  5.285888625776506e-11, -6.058388432272806e-13,  6.651988216747356e-15, -7.165511297138523e-17,  7.456737101929026e-19, -7.420597787478806e-21,
  8.409894899284633e-23, -6.179705259379810e-25,  2.534960191236232e-03, -6.454467709824441e-05,  1.241444252018161e-06, -2.108146718960018e-08,  3.293913769673791e-10,
 -4.836918196494602e-12,  6.751666983727225e-14, -9.056274807743141e-16,  1.172100218180475e-17, -1.469515900457780e-19,  1.810592612541621e-21, -2.135252715897685e-23,
  2.494088592247711e-03, -8.041313612573138e-05,  2.022818132910196e-06, -4.392668917561744e-08,  8.598949340078614e-10, -1.556885586590923e-11,  2.649838739921852e-13,
 -4.284951729571331e-15,  6.634930108581125e-17, -9.892677220190334e-19,  1.426087148294230e-20, -1.996273396018587e-22,  1.381721475191884e-03, -5.849124433147302e-05,
  1.894538467569452e-06, -5.133461469285571e-08,  1.231219873482129e-09, -2.694596131199080e-11,  5.483771832687315e-13, -1.050484437014039e-14,  1.911492777061424e-16,
 -3.325670755337852e-18,  5.558648263738959e-20, -8.967064297086016e-22,  4.759767475183730e-04, -2.686286935254739e-05,  1.103229944290903e-06, -3.685533782245136e-08,
  1.071554084157270e-09, -2.806047146415025e-11,  6.760129392168990e-13, -1.519408044569790e-14,  3.218590073968527e-16, -6.474115255074201e-18,  1.243612359421543e-19,
 -2.291538509664054e-21,  1.060670608832755e-04, -8.022369958784184e-06,  4.149627053263469e-07, -1.702528794880885e-08,  5.975900695204622e-10, -1.864476838885438e-11,
  5.294521264479462e-13, -1.390130673247766e-14,  3.413081708330461e-16, -7.902124703868428e-18,  1.736394921143430e-19, -3.638621694004364e-21,  1.558824305383854e-05,
 -1.582942115607797e-06,  1.032366802904554e-07, -5.209506430342626e-09,  2.209048872335412e-10, -8.213613254445131e-12,  2.748836471542164e-13, -8.426537681210618e-15,
  2.395851243045342e-16, -6.377115880735405e-18,  1.600520478237536e-19, -3.807448972431528e-21,  1.536817127399864e-06, -2.098806287527549e-07,  1.737383572367846e-08,
 -1.084374807197820e-09,  5.581114044737074e-11, -2.482471157497400e-12,  9.821221635963251e-14, -3.523235804357722e-15,  1.161964337448423e-16, -3.559452893849631e-18,
  1.020851035597620e-19, -2.756761152428138e-21,  1.051228775450591e-07, -1.934315074813405e-08,  2.052390653832129e-09, -1.598082735241242e-10,  1.005752230884097e-11,
 -5.384593864550188e-13,  2.530740175584639e-14, -1.066511936286109e-15,  4.091517371297809e-17, -1.445193748816715e-18,  4.741361662777358e-20, -1.453811515746397e-21,
  5.436769770226420e-09, -1.344699796931373e-09,  1.843680546750974e-10, -1.804894786160880e-11,  1.398054116451658e-12, -9.054134450136566e-14,  5.072931258787623e-15,
 -2.516548839472447e-16,  1.123858918823600e-17, -4.575214206450277e-19,  1.714471023962612e-20, -5.954108860845911e-22,  2.613480751490433e-10, -8.505600486122432e-11,
  1.495772258767725e-11, -1.831003114110162e-12,  1.735678101811256e-13, -1.350757268732191e-14,  8.952724212714407e-16, -5.182162983410202e-17,  2.667844463653296e-18,
 -1.238513219243459e-19,  5.241158804101033e-21, -2.037006136962379e-22,  1.628816348156709e-11, -6.481889375127559e-12,  1.380441577589410e-12, -2.009070589068498e-13,
  2.225189877819581e-14, -1.992412035502267e-15,  1.499002965674828e-16, -9.733329013603789e-18,  5.562610914010482e-19, -2.840314921799215e-20,  1.311172651149924e-21,
 -5.517086753931684e-23,  9.541462543564520e-04, -1.988607280738052e-05,  2.891347716037480e-07, -3.637662435708597e-09,  4.218904107265400e-11, -4.677957221846910e-13,
  4.943896068130783e-15, -5.146603617889208e-17,  5.333748555480372e-19, -4.512251917452440e-21,  6.291187104301719e-23, -4.010515886559490e-25,  2.295159864269203e-03,
 -5.554225907716156e-05,  1.017159193398222e-06, -1.650498741547866e-08,  2.470030337014029e-10, -3.482856146476483e-12,  4.670477546136275e-14, -6.028671219736599e-16,
  7.536687349778783e-18, -9.024772175605238e-20,  1.090047705306379e-21, -1.231766731641784e-23,  2.201764309411037e-03, -6.612678678604668e-05,  1.568989706500407e-06,
 -3.235071041368890e-08,  6.035090486137652e-10, -1.043842518494742e-11,  1.700714097153672e-13, -2.636630682194671e-15,  3.919215936667645e-17, -5.619551833717977e-19,
  7.788101671590168e-21, -1.050808370298273e-22,  1.174591773094578e-03, -4.550086879535121e-05,  1.381006079194358e-06, -3.532021731594497e-08,  8.032392409662079e-10,
 -1.672033755505744e-11,  3.245422444831714e-13, -5.941308541802293e-15,  1.034846649483748e-16, -1.727253313684283e-18,  2.770164940056596e-20, -4.297809380098439e-22,
  3.837376170025492e-04, -1.955218977688428e-05,  7.478204219846804e-07, -2.344479169327113e-08,  6.433395618988263e-10, -1.596287851579935e-11,  3.655847071159809e-13,
 -7.831127149234540e-15,  1.584388631552482e-16, -3.050399436369561e-18,  5.615960627119015e-20, -9.936208751051938e-22,  7.952011725398455e-05, -5.381769426825462e-06,
  2.576441049057706e-07, -9.869690968132077e-09,  3.256504881117907e-10, -9.596269734332961e-12,  2.583614231767208e-13, -6.451276471540270e-15,  1.510280990008926e-16,
 -3.341913405939903e-18,  7.032095130628340e-20, -1.413787090498914e-21,  1.058321998372570e-05, -9.575179672396038e-07,  5.748276489687146e-08, -2.697731631419693e-09,
  1.072086816341517e-10, -3.756284648138906e-12,  1.189784186469898e-13, -3.464305302032551e-15,  9.384151926386582e-17, -2.386078973073022e-18,  5.734050138760404e-20,
 -1.308911127628633e-21,  9.101964125137850e-07, -1.108409600521387e-07,  8.419348209710688e-09, -4.877850540204375e-10,  2.349743885584634e-11, -9.841833468208378e-13,
  3.684334250726396e-14, -1.255688814396710e-15,  3.947917102962444e-17, -1.156355374336689e-18,  3.179446897682507e-20, -8.251257157577785e-22,  5.144548327883256e-08,
 -8.504631362883881e-09,  8.292702414015052e-10, -6.003999288015473e-11,  3.543178857217252e-12, -1.790185801006920e-13,  7.981400454280075e-15, -3.204456428950130e-16,
  1.175520980309493e-17, -3.983130294819625e-19,  1.257152408521425e-20, -3.717964765227256e-22,  2.034062748810269e-09, -4.599621980783480e-10,  5.853105927908635e-11,
 -5.373032090443846e-12,  3.932975961238558e-13, -2.421734943485719e-14,  1.296560934314785e-15, -6.171903890549437e-17,  2.654424618792527e-18, -1.043943191031617e-19,
  3.789675082879593e-21, -1.278154119409588e-22,  6.810594722088428e-11, -2.091078828094790e-11,  3.492789845215513e-12, -4.088478046018345e-13,  3.726665681979552e-14,
 -2.801507004591223e-15,  1.800477109689689e-16, -1.013820886590379e-17,  5.091281389908834e-19, -2.311110326280055e-20,  9.583091783979921e-22, -3.656290996273853e-23,
  2.905402285057509e-12, -1.134215672634438e-12,  2.371845864874902e-13, -3.396364899584386e-14,  3.708140387740377e-15, -3.278284465318332e-16,  2.438669043096103e-17,
 -1.567512166971120e-18,  8.877083671709173e-20, -4.495546748383513e-21,  2.059833604299177e-22, -8.608650075809422e-24,  8.789669702124524e-04, -1.773679847483983e-05,
  2.492438490909561e-07, -3.031495269592463e-09,  3.391232796414981e-11, -3.646397137201338e-13,  3.720639160780082e-15, -3.654655753392450e-17,  4.118470783865314e-19,
 -2.369131020889553e-21,  4.295812565249848e-23, -5.782225430488800e-25,  2.088099331447035e-03, -4.813496498687473e-05,  8.406956517761536e-07, -1.305457750750663e-08,
  1.873168776727324e-10, -2.539977681768888e-12,  3.276687704797082e-14, -4.062184584785168e-16,  4.957245103536773e-18, -5.586009446308140e-20,  6.633363207250888e-22,
 -7.622811343436099e-24,  1.960114846927135e-03, -5.497808936802696e-05,  1.232484142004884e-06, -2.416571151688722e-08,  4.302380696123424e-10, -7.117647909608748e-12,
  1.111440170780885e-13, -1.654042270291798e-15,  2.361090884142571e-17, -3.262650745755138e-19,  4.348001822396570e-21, -5.646051944329920e-23,  1.012278145896271e-03,
 -3.595263072304185e-05,  1.024470076431360e-06, -2.477093672929891e-08,  5.349630129405126e-10, -1.060403688044958e-11,  1.965333464848140e-13, -3.443009042745350e-15,
  5.740897137720390e-17, -9.211433696211219e-19,  1.418011064517837e-20, -2.113607182672566e-22,  3.159307285139003e-04, -1.454148674203882e-05,  5.190708013773698e-07,
 -1.529410421423338e-08,  3.966419728827717e-10, -9.335038245522611e-12,  2.034429409031852e-13, -4.157625964097379e-15,  8.037189372321333e-17, -1.482738297895235e-18,
  2.617501195321561e-20, -4.447010911994787e-22,  6.147349534047045e-05, -3.718451744132686e-06,  1.650811193397407e-07, -5.910628329110639e-09,  1.835131060694160e-10,
 -5.111500523608868e-12,  1.305641863867255e-13, -3.102419021372260e-15,  6.927567731133009e-17, -1.465775940592572e-18,  2.954251794282950e-20, -5.699126601289303e-22,
  7.502581248230954e-06, -6.028298247702530e-07,  3.334807666789711e-08, -1.456006220986888e-09,  5.424745660574032e-11, -1.791424845021483e-12,  5.371044217678117e-14,
 -1.485514400846824e-15,  3.833436181602487e-17, -9.310163596500354e-19,  2.141822114540098e-20, -4.690143092819785e-22,  5.718526998438034e-07, -6.174277462831354e-08,
  4.300342486601699e-09, -2.310559979428926e-10,  1.040992608787140e-11, -4.102745801664470e-13,  1.452220285367774e-14, -4.698544436485661e-16,  1.407101172588041e-17,
 -3.937415305877718e-19,  1.036969557716957e-20, -2.583839999546729e-22,  2.720389069345678e-08, -4.005674024722720e-09,  3.576904153241038e-10, -2.401122509908270e-11,
  1.325514785889983e-12, -6.306401345797649e-14,  2.661693646306284e-15, -1.016108980539654e-16,  3.557564800751943e-18, -1.154258366555745e-19,  3.498459346591029e-21,
 -9.962047623070506e-23,  8.358198275156528e-10, -1.708120786728294e-10,  2.003495466060990e-11, -1.715218785764773e-12,  1.181013338542561e-13, -6.886271732729939e-15,
  3.510095246636435e-16, -1.597984489809562e-17,  6.598191526318431e-19, -2.499692876903987e-20,  8.766916249831784e-22, -2.864333847254149e-23,  1.943605022289754e-11,
 -5.561882835748121e-12,  8.745468688447418e-13, -9.718901238949444e-14,  8.467265909039091e-15, -6.116973261109060e-16,  3.794854318483587e-17, -2.070429574797169e-18,
  1.010662552085013e-19, -4.471739709065169e-21,  1.811674943116388e-22, -6.768099712859185e-24,  5.408656428703146e-13, -2.059805162571723e-13,  4.209543341097887e-14,
 -5.907627729306391e-15,  6.337360442920696e-16, -5.516769234150933e-17,  4.048183463275128e-18, -2.570680413119274e-19,  1.440119577526478e-20, -7.222407532398406e-22,
  3.280322018871113e-23, -1.360100461753505e-24,  8.117896135803216e-04, -1.587965965465288e-05,  2.158956549707936e-07, -2.542710696571651e-09,  2.743700046250692e-11,
 -2.862031080291227e-13,  2.871057672301452e-15, -2.445844202217776e-17,  3.500716551587880e-19, -1.305842798970267e-21,  5.981633293878412e-24, -1.152572455446814e-24,
  1.908085621349502e-03, -4.198867043461020e-05,  7.004753252130902e-07, -1.042474270872503e-08,  1.435454442453263e-10, -1.873826998817070e-12,  2.334424500750300e-14,
 -2.752483836547335e-16,  3.350286793959422e-18, -3.526968849905743e-20,  3.815053809576233e-22, -5.498225964347431e-24,  1.758237687011343e-03, -4.617109523003605e-05,
  9.795306746721778e-07, -1.829013281217185e-08,  3.112075073659649e-10, -4.930335421928218e-12,  7.385667479915298e-14, -1.057165768650634e-15,  1.447919261440446e-17,
 -1.932758963870242e-19,  2.487788674183139e-21, -3.071058621771101e-23,  8.831626439135000e-04, -2.881496705724696e-05,  7.723254235213399e-07, -1.768129484522570e-08,
  3.631972986495626e-10, -6.863630646809051e-12,  1.215496936579084e-13, -2.042915004029314e-15,  3.255978095892992e-17, -5.033853119702397e-19,  7.468956728969056e-21,
 -1.059649035658064e-22,  2.650431200281722e-04, -1.102779367279693e-05,  3.682205883267013e-07, -1.021106863584682e-08,  2.506542692230691e-10, -5.601687836779907e-12,
  1.162573769668279e-13, -2.270591132138993e-15,  4.192525291301797e-17, -7.421387802945282e-19,  1.258328890330847e-20, -2.048191533401076e-22,  4.885323820058594e-05,
 -2.638391002516633e-06,  1.088776817384921e-07, -3.647584252275730e-09,  1.066961477396239e-10, -2.811543951825202e-12,  6.817951891760667e-14, -1.543188600437670e-15,
  3.287283588228254e-17, -6.655178348243287e-19,  1.285581003633886e-20, -2.378977531002475e-22,  5.531913926074706e-06, -3.935074352174743e-07,  2.009489082973796e-08,
 -8.166302804947670e-10,  2.854399668729408e-11, -8.888133473103963e-13,  2.523137593669334e-14, -6.630884174970930e-16,  1.630127773748177e-17, -3.781874870409855e-19,
  8.328834167722448e-21, -1.749237187054332e-22,  3.794337807924755e-07, -3.611880470992438e-08,  2.307249147579172e-09, -1.149052129156523e-10,  4.840405008956554e-12,
 -1.794358157025869e-13,  6.002633695418056e-15, -1.842776462075917e-16,  5.253576433319714e-18, -1.403581365782618e-19,  3.538324733354180e-21, -8.458838301065660e-23,
  1.548550322734561e-08, -2.013465314822624e-09,  1.642489875882088e-10, -1.019941103613164e-11,  5.257150487255696e-13, -2.351138157962782e-14,  9.378248209985915e-16,
 -3.398643860596324e-17,  1.133857376205920e-18, -3.517056211868895e-20,  1.022080861074995e-21, -2.797944268448149e-23,  3.773213763693223e-10, -6.884455458879756e-11,
  7.396225596237644e-12, -5.875671581600419e-13,  3.789617853360271e-14, -2.084605256792461e-15,  1.008203501785466e-16, -4.375846560427965e-18,  1.729569228554492e-19,
 -6.294388518335177e-21,  2.127227919139788e-22, -6.716016661364513e-24,  6.131639067871282e-12, -1.612295678802302e-12,  2.363360103098476e-13, -2.474305421278413e-14,
  2.047167512004271e-15, -1.413420034419618e-16,  8.423550802225566e-18, -4.433986420390635e-19,  2.095845006744092e-20, -9.007661582568793e-22,  3.554542182309042e-23,
 -1.296573562779462e-24,  1.062104076516270e-13, -3.915945758195347e-14,  7.772306434115965e-15, -1.063605065701472e-15,  1.116409498628809e-16, -9.536334549438056e-18,
  6.882680243236262e-19, -4.307202303511266e-20,  2.381822277033488e-21, -1.180760597055576e-22,  5.307414705933354e-24, -2.180114357290558e-25,  7.515420510236749e-04,
 -1.426749343476770e-05,  1.878397293428165e-07, -2.145977958390970e-09,  2.235287565561849e-11, -2.242943676407177e-13,  2.335681517250807e-15, -1.407335212813404e-17,
  2.933327264944266e-19, -2.276806974552419e-21, -5.885228651781762e-23, -1.728347053301246e-24,  1.750597864933290e-03, -3.684887374009630e-05,  5.880139896732992e-07,
 -8.399803514886241e-09,  1.111052382098298e-10, -1.395013192908720e-12,  1.696569518052358e-14, -1.858627499261885e-16,  2.299904528671610e-18, -2.453391910339990e-20,
  1.620383936309854e-22, -4.542414841933964e-24,  1.587946101598973e-03, -3.913504256868311e-05,  7.869575524127864e-07, -1.401255559290460e-08,  2.281743602682740e-10,
 -3.466428503323733e-12,  4.981979593090970e-14, -6.882995609198128e-16,  9.031096293491620e-18, -1.160574280917842e-19,  1.474145449691560e-21, -1.676534474953766e-23,
  7.790431059806504e-04, -2.339576774704597e-05,  5.909517842662834e-07, -1.282734435935338e-08,  2.510075456097337e-10, -4.530008716816760e-12,  7.657446822524439e-14,
 -1.241274755493488e-15,  1.886138092139994e-17, -2.798291531304947e-19,  4.086535023540446e-21, -5.371670469079141e-23,  2.261335808475683e-04, -8.511609175022260e-06,
  2.664914077985486e-07, -6.964444504976699e-09,  1.620627008207875e-10, -3.444431864800040e-12,  6.804940740517229e-14, -1.274528013462535e-15,  2.245500740634892e-17,
 -3.809947622492380e-19,  6.253511249086425e-21, -9.670623725725762e-23,  3.980048565813048e-05, -1.917193310506931e-06,  7.374632358521568e-08, -2.314191702386265e-09,
  6.386024979603622e-11, -1.593916194347970e-12,  3.669998205257196e-14, -7.927242487194499e-16,  1.610753029445649e-17, -3.120432958625429e-19,  5.790899158941983e-21,
 -1.026066861017088e-22,  4.226753848975902e-06, -2.653473620742376e-07,  1.254050526546532e-08, -4.746280274608055e-10,  1.557794331642657e-11, -4.577183645948663e-13,
  1.230500681002827e-14, -3.075124723607357e-16,  7.202254621271684e-18, -1.596276099866337e-19,  3.367100635027176e-21, -6.779658471322390e-23,  2.646957576509044e-07,
 -2.208906319014587e-08,  1.295908754005300e-09, -5.980503254073032e-11,  2.355798033373847e-12, -8.213950267498527e-14,  2.596240980158115e-15, -7.561670912921909e-17,
  2.051415524585886e-18, -5.230629708261480e-20,  1.261670497749273e-21, -2.892130347784685e-23,  9.447582332651248e-09, -1.075194157808226e-09,  8.003419047508783e-11,
 -4.589274791522705e-12,  2.205727548094347e-13, -9.260828717107871e-15,  3.486523004372034e-16, -1.197926911966909e-17,  3.803268606642063e-19, -1.126369814198489e-20,
  3.134365897143102e-22, -8.237697796718728e-24,  1.868712517898288e-10, -3.005360314329371e-11,  2.941868915068299e-12, -2.159023961712350e-13,  1.299561978519356e-14,
 -6.721791304531166e-16,  3.075179710178821e-17, -1.268827697799023e-18,  4.787684980622220e-20, -1.669458955704297e-21,  5.423346251919379e-23, -1.650677773399006e-24,
  2.155881116061289e-12, -5.124282023241728e-13,  6.931374634235676e-14, -6.781963020990652e-15,  5.293540100092879e-16, -3.473008342530166e-17,  1.978391685217120e-18,
 -1.000229500467308e-19,  4.559668572322885e-21, -1.896636064795834e-22,  7.265774520595295e-24, -2.579931604161017e-25,  2.230373155369392e-14, -7.877440319003571e-15,
  1.506010463161297e-15, -1.996550724237991e-16,  2.039757449741869e-17, -1.702262216746635e-18,  1.203983400546665e-19, -7.402330431130549e-21,  4.029972609676331e-22,
 -1.970329546166608e-23,  8.747689683218752e-25, -3.553767438369896e-26,  6.973225768505886e-04, -1.286202429099412e-05,  1.640953789089985e-07, -1.821289372137505e-09,
  1.840072278926272e-11, -1.720016608485995e-13,  2.056611335197413e-15, -6.601980174916218e-18,  1.506882519916226e-19, -6.125208379677276e-21, -1.295743671849477e-22,
 -1.143838989851971e-24,  1.612012248574509e-03, -3.251971666542674e-05,  4.970289082091940e-07, -6.824828425538944e-09,  8.689485465091045e-11, -1.042750652529672e-12,
  1.266586357213283e-14, -1.255182677212944e-16,  1.488198251909903e-18, -2.169766728968039e-20, -8.522438448543168e-24, -2.887739934603131e-24,  1.443013464832708e-03,
 -3.345479859572882e-05,  6.386176298467235e-07, -1.085744016887547e-08,  1.693952442470383e-10, -2.472851996973703e-12,  3.403880679784701e-14, -4.560574005020191e-16,
  5.760290563760710e-18, -6.932677299066975e-20,  9.147851998542339e-22, -9.543205365616379e-24,  6.940284452822126e-04, -1.922188289075764e-05,  4.584244475407433e-07,
 -9.446870776209548e-09,  1.762867847702246e-10, -3.049371150605926e-12,  4.895520001998689e-14, -7.714026081313140e-16,  1.124430692457128e-17, -1.547032370999245e-19,
  2.354041126002469e-21, -2.826017803900578e-23,  1.958776975560273e-04, -6.674604038508963e-06,  1.964602494454448e-07, -4.844633486765173e-09,  1.069868348662055e-10,
 -2.169422707532584e-12,  4.066202914347328e-14, -7.343606615651530e-16,  1.238079045379035e-17, -1.984932225027284e-19,  3.229822061371765e-21, -4.707033568093177e-23,
  3.315745370582390e-05, -1.423079395519977e-06,  5.119128397843155e-08, -1.506215168925490e-09,  3.925418251648340e-11, -9.302026959342725e-13,  2.030514750244728e-14,
 -4.198516240952802e-16,  8.147436009838349e-18, -1.503818957650537e-19,  2.701730975132873e-21, -4.571194825520757e-23,  3.335121032387090e-06, -1.841725910499222e-07,
  8.083330698927961e-09, -2.850890130276968e-10,  8.794374925794319e-12, -2.441859755456048e-13,  6.213633888095067e-15, -1.478798384754336e-16,  3.301261419046031e-18,
 -6.983058440171867e-20,  1.413611410920131e-21, -2.726819079824209e-23,  1.932927959976824e-07, -1.405761441817486e-08,  7.594712017755763e-10, -3.247479436455421e-11,
  1.196655560244835e-12, -3.926374983775466e-14,  1.172202596468621e-15, -3.240014994511083e-17,  8.363474146865898e-19, -2.034267946031698e-20,  4.695287396922533e-22,
 -1.031495906930703e-23,  6.147842285880730e-09, -6.068128172506540e-10,  4.123740765031636e-11, -2.180570358131154e-12,  9.764793841550384e-14, -3.845928052232398e-15,
  1.365220733510480e-16, -4.443437807770545e-18,  1.341184964970841e-19, -3.788394088168957e-21,  1.008426116158205e-22, -2.541642334410185e-24,  1.012291024631642e-10,
 -1.415774825439455e-11,  1.258069474381365e-12, -8.497326926015723e-14,  4.758841061589324e-15, -2.308035858569155e-16,  9.961875740098301e-18, -3.897719398121887e-19,
  1.400669367939794e-20, -4.668859618256353e-22,  1.454647823297107e-23, -4.258939720620753e-25,  8.499447024861540e-13, -1.792502310946181e-13,  2.215182684454673e-14,
 -2.009597378003599e-15,  1.470073472860270e-16, -9.113138427608007e-18,  4.937004819062480e-19, -2.386531037867290e-20,  1.044910116579364e-21, -4.190752685380638e-23,
  1.553159788527303e-24, -5.351512709457620e-26,  5.095436008924308e-15, -1.698735570373735e-15,  3.094839512492645e-16, -3.941921754800559e-17,  3.893861597051812e-18,
 -3.157633506109546e-19,  2.178780510165581e-20, -1.311054370955235e-21,  7.004373882808728e-23, -3.368105610404028e-24,  1.473442284099961e-25, -5.907801788659383e-27,
  6.483683305462932e-04, -1.163192245430776e-05,  1.439013872983834e-07, -1.551772274649915e-09,  1.544111851456108e-11, -1.245575596860673e-13,  1.898618968198139e-15,
 -6.363352566499855e-18, -1.682877724551929e-19, -1.149198132711019e-20, -1.106668191489099e-22,  2.743414389436873e-24,  1.489398563802543e-03, -2.884892501110083e-05,
  4.228351061105657e-07, -5.585941994906980e-09,  6.881969694800115e-11, -7.762918762090510e-13,  9.699032703528499e-15, -9.064453949511493e-17,  6.803763110083424e-19,
 -2.340912557395508e-20, -3.928133319553915e-23,  2.339066406178711e-24,  1.318647417932663e-03, -2.882442966544214e-05,  5.230909682729716e-07, -8.502380107934640e-09,
  1.271719000737024e-10, -1.790399329331313e-12,  2.352055014438494e-14, -3.053511554052262e-16,  3.832004037463915e-18, -4.009434527224244e-20,  5.647231523695838e-22,
 -7.073550154858996e-24,  6.238198071704847e-04, -1.596424109720395e-05,  3.601612947929398e-07, -7.057016236678694e-09,  1.254895509456623e-10, -2.097530091131425e-12,
  3.167282317243619e-14, -4.847097725015050e-16,  7.106013171393889e-18, -8.168036258759235e-20,  1.364453889504849e-21, -1.895252540897175e-23,  1.719915838726758e-04,
 -5.309348771621952e-06,  1.473179896512131e-07, -3.433190681826344e-09,  7.189804275440498e-11, -1.401312295570786e-12,  2.472908071158245e-14, -4.311250398094074e-16,
  7.135476047132864e-18, -1.028889552054975e-19,  1.706864139191183e-21, -2.539885958118953e-23,  2.818312862076131e-05, -1.076430090310887e-06,  3.634716704098792e-08,
 -1.004027158306888e-09,  2.470460527112769e-11, -5.588316932117819e-13,  1.151416491367220e-14, -2.282778320203823e-16,  4.276260552627191e-18, -7.385662570874579e-20,
  1.299552826530722e-21, -2.141724142211447e-23,  2.709043604862570e-06, -1.311228787920484e-07,  5.368218557306669e-09, -1.765655714154978e-10,  5.119627367840205e-12,
 -1.347928135065643e-13,  3.240092348876520e-15, -7.352805756796998e-17,  1.570480110535836e-18, -3.153529062319841e-20,  6.150874135195204e-22, -1.140926844472172e-23,
  1.471374987133092e-07, -9.266231644553712e-09,  4.629614594479966e-10, -1.834354107883355e-11,  6.323936633024868e-13, -1.955921752568605e-14,  5.510639854046801e-16,
 -1.446274887040654e-17,  3.555456790130551e-19, -8.237937687463713e-21,  1.820979264835534e-22, -3.834733938087687e-24,  4.245693117791666e-09, -3.598893422284566e-10,
  2.238550162212237e-11, -1.090481350046596e-12,  4.547493231358878e-14, -1.680204667905623e-15,  5.618540591030907e-17, -1.731448411347361e-18,  4.965790729848673e-20,
 -1.336482357993641e-21,  3.400934821195022e-23, -8.213101990518974e-25,  5.972168431888008e-11, -7.159237874923193e-12,  5.766761599212021e-13, -3.573512812340491e-14,
  1.857624168579353e-15, -8.430235491711419e-17,  3.425212979440458e-18, -1.268243924684386e-19,  4.331578933356103e-21, -1.377400636245173e-22,  4.107797599929359e-24,
 -1.154645144550454e-25,  3.769936574810165e-13, -6.908276225695349e-14,  7.731033070946088e-15, -6.454139463291425e-16,  4.397701105895346e-17, -2.561976473833101e-18,
  1.313538228971119e-19, -6.044191963718611e-21,  2.531387353295941e-22, -9.752107024049990e-24,  3.484438454415399e-25, -1.161232539600904e-26,  1.293142690199241e-15,
 -3.986784904712400e-16,  6.827751169810190e-17, -8.269402981458711e-18,  7.833806600959832e-19, -6.131982400929763e-20,  4.105040917255738e-21, -2.406429209367667e-22,
  1.256692769437994e-23, -5.923290032547701e-25,  2.545908447157420e-26, -1.004942966354665e-27,  6.040308278308411e-04, -1.055117004625167e-05,  1.266880761030863e-07,
 -1.322244450515001e-09,  1.338635073762567e-11, -8.214204832631960e-14,  1.578735408563989e-15, -1.886231758771536e-17, -6.134300262718626e-19, -1.135126650790706e-20,
  1.763265589488135e-22,  1.064669778788605e-23,  1.380368663396650e-03, -2.571675235313010e-05,  3.619368359910653e-07, -4.597214699298813e-09,  5.542544079213699e-11,
 -5.722931119080035e-13,  7.338871108382953e-15, -8.230098901523934e-17, -1.415455816321386e-19, -2.019432537642380e-20,  2.741650082175118e-22,  1.234961880127701e-23,
  1.211118454479354e-03, -2.501576102310714e-05,  4.321812195460911e-07, -6.726096119550038e-09,  9.638278111490130e-11, -1.315840507997356e-12,  1.649801305479010e-14,
 -2.020732738136205e-16,  2.719542661721150e-18, -2.383933691833539e-20,  2.411511659792450e-22, -7.936955265951185e-24,  5.652333869859259e-04, -1.339049541615557e-05,
  2.862619485004353e-07, -5.347670438066068e-09,  9.016361526389647e-11, -1.476929828375085e-12,  2.090814852864084e-14, -2.954445935143150e-16,  4.948950624894454e-18,
 -4.368547762564376e-20,  5.231502427365580e-22, -2.041792504388932e-23,  1.528753958916221e-04, -4.277980860028830e-06,  1.121913190536870e-07, -2.478464958944953e-09,
  4.894936083327268e-11, -9.298724573126665e-13,  1.537965157277017e-14, -2.508783379146819e-16,  4.418168220595107e-18, -5.415054770278811e-20,  7.806220324807502e-22,
 -1.828632950734280e-23,  2.439113448987119e-05, -8.278880400209776e-07,  2.634495970744332e-08, -6.850753557054065e-10,  1.584429855597794e-11, -3.458694356815487e-13,
  6.700449867021580e-15, -1.255576906342768e-16,  2.360377230021999e-18, -3.709198794636421e-20,  6.108041996314659e-22, -1.138582962349774e-23,  2.258751200819912e-06,
 -9.544027646535009e-08,  3.663945873252580e-09, -1.126030623705663e-10,  3.060077510506050e-12, -7.695791573324199e-14,  1.743112558993993e-15, -3.752404170968232e-17,
  7.787977411196889e-19, -1.468031805144392e-20,  2.732390891056200e-22, -5.068041668038750e-24,  1.162946354469091e-07, -6.296680728536141e-09,  2.926400724867309e-10,
 -1.075375835017038e-11,  3.463045872885240e-13, -1.013839270329528e-14,  2.691966358980764e-16, -6.699150823580298e-18,  1.576247762910767e-19, -3.466239915215550e-21,
  7.328672566235151e-23, -1.490690238245125e-24,  3.096035854307376e-09, -2.229276051692918e-10,  1.275536970028395e-11, -5.721915841277204e-13,  2.219706334135305e-14,
 -7.705240628221057e-16,  2.424777580338613e-17, -7.070505605179504e-19,  1.928166052719354e-20, -4.937513824328191e-22,  1.200484368826974e-23, -2.778882530666806e-25,
  3.817047022323847e-11, -3.859986343588159e-12,  2.822857047962561e-13, -1.600983422457311e-14,  7.709522316083068e-16, -3.270074973470287e-17,  1.248374877664960e-18,
 -4.367069764550749e-20,  1.415470132235654e-21, -4.286108481897326e-23,  1.221525647132865e-24, -3.291022633908579e-26,  1.881796725653300e-13, -2.926478528039600e-14,
  2.946740065017414e-15, -2.248596507028269e-16,  1.419258650305211e-17, -7.732815938012427e-19,  3.735239979072249e-20, -1.629329343454449e-21,  6.502187479761281e-23,
 -2.397422886910002e-24,  8.230172377311269e-26, -2.644396998886086e-27,  3.733947565523371e-16, -1.034959379912016e-16,  1.638838934944247e-17, -1.864056452732191e-18,
  1.677072908493660e-19, -1.257151916302917e-20,  8.111756585454952e-22, -4.606989773428731e-23,  2.340659608680818e-24, -1.077057407472078e-25,  4.532528080837419e-27,
 -1.756049610430329e-28,  5.637576575823649e-04, -9.597604632911833e-06,  1.120580912589208e-07, -1.119370534594920e-09,  1.206681751320409e-11, -5.311225989617611e-14,
  7.299444740555272e-16, -4.263666311898838e-17, -7.655406991999178e-19,  6.716565618941246e-21,  7.408141250134264e-22,  1.206942254029423e-23,  1.282963465038235e-03,
 -2.302765991575052e-05,  3.117422080283956e-07, -3.793205001696208e-09,  4.554912229685009e-11, -4.248919765399447e-13,  4.883753289426216e-15, -9.513162417909397e-17,
 -5.183451067036706e-19,  3.816846485073924e-21,  9.480258542727495e-22,  1.474506375744188e-23,  1.117493665875477e-03, -2.185681693631023e-05,  3.599171944402784e-07,
 -5.374749147200746e-09,  7.361483666431051e-11, -9.786945899833351e-13,  1.193854115704954e-14, -1.276140742027589e-16,  1.949161006772026e-18, -2.128279001267898e-20,
 -1.051411831311138e-22, -6.623529401023071e-24,  5.158770441949698e-04, -1.133464402289779e-05,  2.298522041636843e-07, -4.116605358239055e-09,  6.505960830928792e-11,
 -1.057861484285869e-12,  1.463477253955356e-14, -1.600065368653005e-16,  3.530123641373817e-18, -4.125657000932121e-20, -3.902921138136586e-22, -1.831763816185629e-23,
  1.373872542855188e-04, -3.487396273859841e-06,  8.659424543844857e-08, -1.826121901555518e-09,  3.354962108471679e-11, -6.307036220650677e-13,  1.007545113258443e-14,
 -1.361804616711040e-16,  2.845338007219178e-18, -3.805323214341598e-20,  5.497289854927236e-23, -1.375039236213917e-23,  2.145449200112185e-05, -6.461766465905515e-07,
  1.944220913406696e-08, -4.792243806106417e-10,  1.028966903315657e-11, -2.197986031115025e-13,  4.069959359404482e-15, -6.755981277125720e-17,  1.358343210749353e-18,
 -2.115615083002968e-20,  2.194179182219947e-22, -6.681259876333253e-24,  1.928092904175006e-06, -7.080511121307274e-08,  2.562180837134651e-09, -7.399422472685154e-11,
  1.866886821719784e-12, -4.533774104313175e-14,  9.747005755192302e-16, -1.932573547189984e-17,  4.021205491528648e-19, -7.276265207461171e-21,  1.159754152656632e-22,
 -2.417672698656627e-24,  9.508806267885879e-08, -4.390954990804843e-09,  1.911335223997195e-10, -6.538817404154109e-12,  1.954712496881502e-13, -5.456474751530930e-15,
  1.368706597079836e-16, -3.193662045305296e-18,  7.284509346720073e-20, -1.525668063706117e-21,  3.005901093916295e-23, -6.097827772180863e-25,  2.372127666704576e-09,
 -1.433069779412342e-10,  7.598092097559620e-12, -3.143619936195255e-13,  1.130350107014694e-14, -3.700438514981710e-16,  1.096035414908162e-17, -3.013397745715327e-19,
  7.843473663566871e-21, -1.909903980975303e-22,  4.414620814854877e-24, -9.855905038018793e-26,  2.627204913046239e-11, -2.201347347353584e-12,  1.469213776099919e-13,
 -7.617926616914376e-15,  3.389391418660994e-16, -1.344230756906743e-17,  4.815138645157126e-19, -1.588476792728489e-20,  4.884054783904999e-22, -1.406010572318587e-23,
  3.822339412838274e-25, -9.865249234869167e-27,  1.054010297197949e-13, -1.354548214893330e-14,  1.224273440855414e-15, -8.491285226752533e-17,  4.940557917752328e-18,
 -2.507929219450211e-19,  1.136776433371809e-20, -4.683172502826191e-22,  1.774719800637817e-23, -6.241327754179715e-25,  2.051975834466931e-26, -6.337325617284674e-28,
  1.257504159997177e-16, -3.017117294759493e-17,  4.337027198547476e-18, -4.567469469334759e-19,  3.859625826015166e-20, -2.745728937586976e-21,  1.694741472601844e-22,
 -9.265448077562475e-24,  4.554798604644512e-25, -2.036490282524889e-26,  8.356550936519260e-28, -3.166469188454869e-29,  5.270796286826742e-04, -8.751664261542052e-06,
  9.975087019192452e-08, -9.342982303583234e-10,  1.107051460258306e-11, -5.223889868659185e-14, -7.250293796633447e-16, -5.679086339605008e-17,  9.145259290689298e-20,
  4.138213545015126e-20,  7.891180053805659e-22, -1.565508166727436e-23,  1.195569102993562e-03, -2.070401581011010e-05,  2.703341174185521e-07, -3.126968313098538e-09,
  3.799951521806395e-11, -3.411060389996290e-13,  2.066478572501714e-15, -1.012661391382938e-16,  4.034341678955791e-19,  4.807718641618176e-20,  1.019413538380323e-21,
 -1.877740628997428e-23,  1.035443019728041e-03, -1.921683612592884e-05,  3.018886841744115e-07, -4.339032565725548e-09,  5.665004378161740e-11, -7.287483322892634e-13,
  9.114988489328681e-15, -7.873627001997374e-17,  1.060296718770221e-18, -2.856955546396788e-20, -1.671795066066593e-22,  5.883640399929316e-24,  4.739262522932408e-04,
 -9.677217891884676e-06,  1.860586407092738e-07, -3.227138229891760e-09,  4.711147551157619e-11, -7.491373446102549e-13,  1.148383509125452e-14, -7.504704730893383e-17,
  1.625940331483298e-18, -6.625493291553759e-20, -6.236807271040252e-22,  1.389829510717787e-23,  1.246961114830001e-04, -2.874049716069954e-06,  6.752470836135253e-08,
 -1.378229756922516e-09,  2.309257343750896e-11, -4.256368743658047e-13,  7.328358731315437e-15, -6.759225287538128e-17,  1.403523616669533e-18, -4.390844053752813e-20,
 -2.124323728383187e-22,  4.782862154559595e-24,  1.914799039798318e-05, -5.111454310174806e-07,  1.454988592158736e-08, -3.450135471308354e-10,  6.739839169283153e-12,
 -1.405637599983214e-13,  2.681491192158019e-15, -3.507333633568464e-17,  6.972884637023720e-19, -1.673642356412804e-20,  4.546307099745253e-23, -6.377054710990541e-25,
  1.680879222474495e-06, -5.341306686457771e-08,  1.827219574648836e-09, -5.026770774207352e-11,  1.156818730875016e-12, -2.719892518780685e-14,  5.796775680260871e-16,
 -9.931711774473432e-18,  2.025699656244138e-19, -4.273405989531920e-21,  4.567414865673738e-23, -8.235850938400600e-25,  8.015085229646041e-08, -3.129849873109673e-09,
  1.283368848009650e-10, -4.132076413199361e-12,  1.131199446064467e-13, -3.024838858927025e-15,  7.321719387869305e-17, -1.553638239359108e-18,  3.431514584342734e-20,
 -7.307391956309581e-22,  1.234293274332604e-23, -2.401867376932289e-25,  1.900278469977157e-09, -9.501909537824547e-11,  4.706185544346811e-12, -1.808500527188828e-13,
  5.973134102476814e-15, -1.851998505522121e-16,  5.204363485596022e-18, -1.332774667025946e-19,  3.320448417698828e-21, -7.809837577124698e-23,  1.676761091782454e-24,
 -3.612255550598654e-26,  1.934600934676946e-11, -1.316438053144904e-12,  8.085844378867019e-14, -3.842323303417906e-15,  1.570983300232966e-16, -5.837170692047958e-18,
  1.964194226266748e-19, -6.084337498643990e-21,  1.776039906480614e-22, -4.866762515273388e-24,  1.255343149809117e-25, -3.106278900807557e-27,  6.584768090585173e-14,
 -6.786401546872279e-15,  5.522190170101143e-16, -3.469039233420778e-17,  1.851363912193211e-18, -8.735505786723571e-20,  3.704095764528496e-21, -1.435978601747729e-22,
  5.153770859884289e-24, -1.723711845388951e-25,  5.409641191057841e-27, -1.601862064461734e-28,  5.045316825018743e-17, -9.980361421244459e-18,  1.280098962558108e-18,
 -1.229544347854411e-19,  9.642986465582831e-21, -6.447278790769347e-22,  3.774980015833314e-23, -1.972551025054710e-24,  9.324632820428746e-26, -4.029167689994791e-27,
  1.604566515167659e-28, -5.922056064022564e-30,  4.936021143813750e-04, -7.995580573809619e-06,  8.956309982673712e-08, -7.669889511899718e-10,  9.731122098612080e-12,
 -8.684405286301590e-14, -2.018436758101968e-15, -2.605864124329274e-17,  1.866420379469417e-18,  4.656055954609459e-20, -7.988962764359929e-22, -5.061103742215045e-23,
  1.116854660713386e-03, -1.868160705678989e-05,  2.362395284471820e-07, -2.571773348134507e-09,  3.145884718440341e-11, -3.222544375211747e-13, -2.860449992131415e-16,
 -5.537436308199963e-17,  2.523308400248550e-18,  5.656976883916224e-20, -9.362674191839518e-22, -6.325247997717703e-23,  9.630965139217895e-04, -1.699562536361486e-05,
  2.548143161455950e-07, -3.538038729939478e-09,  4.409977172254266e-11, -5.335881526630391e-13,  7.226022709985601e-15, -6.173948650888297e-17,  1.993755769805869e-20,
 -2.515609979397950e-20,  4.362281199316360e-22,  1.864402694208664e-23,  4.379657646293353e-04, -8.331881697387955e-06,  1.514079988139588e-07, -2.578879918228424e-09,
  3.473519162378037e-11, -4.951918415598442e-13,  9.729299165168241e-15, -6.392020286944171e-17, -9.283002324380024e-19, -6.465586814394190e-20,  1.011472765248977e-21,
  5.404003658197095e-23,  1.141836517396513e-04, -2.394313669964842e-06,  5.295129285056113e-08, -1.067865611659790e-09,  1.620521992642481e-11, -2.688919654444672e-13,
  5.820051956229487e-15, -4.870400606948751e-17, -2.044984723431938e-19, -4.007896617126618e-20,  5.829255665706098e-22,  2.822385086487427e-23,  1.731231901394002e-05,
 -4.096661948288334e-07,  1.097448402596877e-08, -2.564651930075848e-10,  4.503292854466329e-12, -8.601416568684346e-14,  1.924116983349813e-15, -2.196464745282167e-17,
  1.418799860082704e-19, -1.318448352793448e-20,  1.837217149144724e-22,  6.173550234925819e-24,  1.493037504840989e-06, -4.093035874846573e-08,  1.319328583971133e-09,
 -3.543761542622808e-11,  7.326617990527604e-13, -1.602204188681290e-14,  3.714448606825138e-16, -5.603278404335703e-18,  7.679499378849785e-20, -2.747677278071457e-21,
  4.007033470963038e-23,  4.457135244736362e-25,  6.940888290729765e-08, -2.274768650082484e-09,  8.788870048130507e-11, -2.723495911089906e-12,  6.722076049629857e-14,
 -1.686900113947066e-15,  4.171380120271482e-17, -7.977364955236296e-19,  1.496239146678982e-20, -3.828035802789522e-22,  6.442802079523349e-24, -4.980522537387777e-26,
  1.583727779795576e-09, -6.466865856562357e-11,  3.006145845556306e-12, -1.092074449370798e-13,  3.268407887094581e-15, -9.527114933258043e-17,  2.614531321675885e-18,
 -6.162007936080862e-20,  1.414945090847946e-21, -3.418173203330922e-23,  6.904925282255332e-25, -1.228461397344175e-26,  1.513239776839889e-11, -8.187266427159703e-13,
  4.667476984817303e-14, -2.054713949669191e-15,  7.643615435063888e-17, -2.658099499500601e-18,  8.490493271047230e-20, -2.451059268696862e-21,  6.742508790014555e-23,
 -1.785896769361665e-24,  4.347334316924593e-26, -1.008246698752267e-27,  4.546959486211377e-14, -3.637257805948855e-15,  2.685937911221354e-16, -1.530808320760759e-17,
  7.440596676200229e-19, -3.259285085465584e-20,  1.292630628713353e-21, -4.694029416875926e-23,  1.591349200094955e-24, -5.059978571755917e-26,  1.509684464548017e-27,
 -4.270439309090969e-29,  2.439245299571194e-17, -3.752116273089667e-18,  4.245743453259312e-19, -3.667388312117769e-20,  2.636737587555112e-21, -1.641131180679583e-22,
  9.037739272819927e-24, -4.478925409947702e-25,  2.022608554259470e-26, -8.397003685287464e-28,  3.228203938707124e-29, -1.155154213482711e-30,  4.629980508529298e-04,
 -7.313394161328487e-06,  8.122722896218318e-08, -6.279279159759879e-10,  7.491023067018253e-12, -1.360702394506175e-13, -1.728300997162773e-15,  5.017486523105205e-17,
  2.472507817863458e-18, -2.373532620802529e-20, -2.360026787902242e-21, -2.358216717207358e-24,  1.045724039201289e-03, -1.690707327107112e-05,  2.081834016552727e-07,
 -2.120708009523884e-09,  2.487328950966979e-11, -3.371100933787288e-13, -4.821702818436817e-16,  4.550397161439029e-17,  3.260280992670026e-18, -2.955433876765213e-20,
 -2.942372979566196e-21, -5.163201942540638e-24,  8.989380891099826e-04, -1.511569433626458e-05,  2.162681607414422e-07, -2.908989446306058e-09,  3.501961211617188e-11,
 -3.815145100242224e-13,  5.402853278553647e-15, -7.074838242176341e-17, -3.971869463812579e-19,  5.532587440671289e-21,  9.443111330538488e-22, -2.084326514881475e-24,
  4.068772166525903e-04, -7.235629587017797e-06,  1.235084271975580e-07, -2.090353352189563e-09,  2.699632356880310e-11, -2.882811458820882e-13,  7.255603203349428e-15,
 -1.186063153194090e-16, -1.995241426871119e-18,  1.711498907357002e-20,  2.697792317664300e-21,  2.571356273019789e-24,  1.053782030822701e-04, -2.017914874154599e-06,
  4.153838974247646e-08, -8.445074422833620e-10,  1.210503289434913e-11, -1.474271750633784e-13,  4.193803999156134e-15, -7.146353387232781e-17, -9.430882871810908e-19,
  5.481103719597049e-21,  1.506978866186125e-21,  2.612279099160787e-24,  1.583133080874617e-05, -3.330712149876032e-07,  8.280015769338326e-09, -1.958706104693935e-10,
  3.196000271627362e-12, -4.707685034019383e-14,  1.314560760401236e-15, -2.306395526308203e-17, -1.356712004850963e-19, -7.210291044546727e-22,  4.000512707719798e-22,
  7.849993364379322e-25,  1.347984963333970e-06, -3.189890648426195e-08,  9.552711220399434e-10, -2.584358983277501e-11,  4.897505691655516e-13, -8.791620463588902e-15,
  2.365500704447214e-16, -4.374399538400589e-18,  1.223720525475715e-20, -6.998150724659187e-22,  5.937642106120820e-23,  3.952669598652929e-26,  6.153187734902975e-08,
 -1.686347757730382e-09,  6.070405822568974e-11, -1.870240263714846e-12,  4.191661396129664e-14, -9.107343938805812e-16,  2.434649981120834e-17, -4.924011248674609e-19,
  5.517098507987944e-21, -1.468989964851245e-22,  5.553026865623807e-24, -2.235453417014230e-26,  1.365940601493048e-09, -4.509768797189469e-11,  1.956178869363149e-12,
 -6.925439675039414e-14,  1.872957238520430e-15, -4.907888971887677e-17,  1.371009748055346e-18, -3.154738484068431e-20,  5.821058780269051e-22, -1.417187980636127e-23,
  3.664137285904547e-25, -4.460864207435534e-27,  1.247293724058003e-11, -5.265854720719008e-13,  2.790571743811442e-14, -1.165920907279867e-15,  3.913801005363902e-17,
 -1.249365424376494e-18,  3.879002571455667e-20, -1.056687059496705e-21,  2.618976401117618e-23, -6.781876171707853e-25,  1.671817998581632e-26, -3.362222253434838e-28,
  3.428656796931786e-14, -2.061363419492680e-15,  1.392635521165435e-16, -7.293821896902824e-18,  3.198391866483394e-19, -1.292963394511904e-20,  4.831550644239673e-22,
 -1.639541278247363e-23,  5.195129912497128e-25, -1.577118562660391e-26,  4.496559387143278e-28, -1.196067428165853e-29,  1.414939057340160e-17, -1.588404720215806e-18,
  1.583572915559917e-19, -1.219347068380182e-20,  7.931411301759158e-22, -4.555367760164454e-23,  2.342645294671723e-24, -1.092243225554045e-25,  4.678360483974742e-27,
 -1.855755301061130e-28,  6.849127068889344e-30, -2.363026305465188e-31,  4.349989763787312e-04, -6.691897809821211e-06,  7.431578318655646e-08, -5.314743032465557e-10,
  4.509184999912982e-12, -1.531634431646288e-13,  5.334302968070474e-16,  9.896327347857427e-17,  1.603408183137300e-19, -9.136024350566303e-20, -3.900117689675661e-22,
  8.034666840959629e-23,  9.812743809321119e-04, -1.533714805546384e-05,  1.848998629735448e-07, -1.776676823345676e-09,  1.817245194071531e-11, -3.233690357028911e-13,
  1.938953064373403e-15,  1.118608328598301e-16,  3.579704965801547e-19, -1.154522614782285e-19, -5.463922996911163e-22,  1.004716912580377e-22,  8.417272555903868e-04,
 -1.351619277140156e-05,  1.844912998093978e-07, -2.403367218532499e-09,  2.851980680007968e-11, -2.766257535708915e-13,  3.321582398720835e-15, -7.381898043840213e-17,
  3.608536277649713e-19,  3.086395823861117e-20,  1.031904780304436e-22, -3.076769738571837e-23,  3.797618251820875e-04, -6.340938933911768e-06,  1.008528488081285e-07,
 -1.696320379404613e-09,  2.267080018660863e-11, -1.599296323281661e-13,  3.273610142821721e-15, -1.534862398021964e-16,  2.970732780145364e-19,  9.547624595308528e-20,
  5.190971505408674e-22, -8.928407355899884e-23,  9.791136850964040e-05, -1.723043710291934e-06,  3.248480287080955e-08, -6.696818959285939e-10,  9.985548572766692e-12,
 -7.361342523584630e-14,  1.879055725677938e-15, -8.768005860948678e-17,  2.070236917534785e-19,  5.065018821090301e-20,  3.586291373020540e-22, -4.884743066904582e-23,
  1.461778561654857e-05, -2.754251096411288e-07,  6.210246752842920e-09, -1.507803511795522e-10,  2.515405354424104e-12, -2.368409934499551e-14,  6.252324533753320e-16,
 -2.492287221999443e-17,  9.541431203546058e-20,  1.166898455290772e-20,  1.195429833996206e-22, -1.229492304192940e-23,  1.233882283904608e-06, -2.537558094414133e-08,
  6.872486149980332e-10, -1.914676713386175e-11,  3.609572764702377e-13, -4.547333782815926e-15,  1.188994290110479e-16, -3.954875293178406e-18,  2.549955280544071e-20,
  1.189567579143292e-21,  2.247501024799911e-23, -1.608752972039175e-24,  5.563011683938323e-08, -1.280285546224381e-09,  4.177487336850535e-11, -1.317920930553835e-12,
  2.851603881409905e-14, -4.753437750467808e-16,  1.252309978001238e-17, -3.610389064164092e-19,  3.753431941423713e-21,  2.883024304943718e-23,  2.517424998577740e-24,
 -1.148762667833480e-25,  1.212219214026059e-09, -3.232736379700003e-11,  1.277588323440203e-12, -4.561948528475687e-14,  1.158089030738898e-15, -2.504912366771414e-17,
  6.897952167968954e-19, -1.862363388110386e-20,  2.901575667241536e-22, -3.326880396502522e-24,  1.706009863626159e-25, -4.963412022263253e-27,  1.073736238717911e-11,
 -3.502727062487772e-13,  1.698724968643598e-14, -6.976335369570845e-16,  2.147221436337105e-17, -5.973187381572343e-19,  1.804207102570127e-20, -5.043611070718111e-22,
  1.094302896536081e-23, -2.333967493466900e-25,  6.772379081077958e-27, -1.582272161882976e-28,  2.781625912243662e-14, -1.226579694003529e-15,  7.559188646242030e-17,
 -3.743063379722785e-18,  1.478833019862874e-19, -5.386124098247042e-21,  1.913260268462943e-22, -6.201327597938246e-24,  1.797805183702574e-25, -5.075331838968302e-27,
  1.438241242522975e-28, -3.683325336612415e-30,  9.635972389856824e-18, -7.446466865851221e-19,  6.575720125891807e-20, -4.536270793811531e-21,  2.633676525347276e-22,
 -1.380082957808048e-23,  6.606541128835283e-25, -2.882267468377736e-26,  1.159699191250910e-27, -4.367755822687905e-29,  1.543840627815740e-30, -5.105941143669865e-32,
  4.093814814998109e-04, -6.121879516715677e-06,  6.827465351664627e-08, -4.822239440554349e-10,  1.788653389821242e-12, -1.095039009309750e-13,  2.900464773691010e-15,
  5.532628543027187e-17, -2.579309974435587e-18, -4.105625580306663e-20,  2.495402150190842e-21,  2.646274637822812e-23,  9.227555163212857e-04, -1.393875661551794e-05,
  1.651219217805491e-07, -1.534088979189106e-09,  1.241466424289115e-11, -2.417288285011575e-13,  4.627055419817915e-15,  6.125115637729662e-17, -3.143678475920974e-18,
 -5.385548505443409e-20,  3.131394548059638e-21,  3.538667025604941e-23,  7.904421180009546e-04, -1.214826229117545e-05,  1.582184166217310e-07, -1.987645455099042e-09,
  2.362804532353365e-11, -2.194154463044933e-13,  1.574064513686810e-15, -4.624578636973925e-17,  1.240309020645985e-18,  1.099295042949698e-20, -9.196168264887089e-22,
 -7.499741889692971e-24,  3.558912061162378e-04, -5.609595457462184e-06,  8.257781799411970e-08, -1.356308840671159e-09,  1.992869744865511e-11, -1.287330344160279e-13,
 -3.903600529516797e-16, -9.263493616813142e-17,  3.181480429127218e-18,  4.256799273952962e-20, -2.718699191326405e-21, -3.064557101145551e-23,  9.149175677351548e-05,
 -1.492693935934708e-06,  2.536438419670428e-08, -5.200405177901740e-10,  8.776431733851715e-12, -5.555026052910879e-14, -2.141176892940764e-16, -5.335402943504764e-17,
  1.773894741852598e-18,  2.385943795694580e-20, -1.469527803527737e-21, -1.874840248066058e-23,  1.360491355891914e-05, -2.323282401453925e-07,  4.628748675551096e-09,
 -1.137339956732564e-10,  2.138717556606288e-12, -1.631340801422663e-14,  3.357166555888689e-17, -1.530766860333402e-17,  4.698128067800420e-19,  5.861931274098607e-21,
 -3.570869615215579e-22, -5.331825096042087e-24,  1.142051329584599e-06, -2.070453941433917e-08,  4.895425935136376e-10, -1.397943132931150e-11,  2.902323699736319e-13,
 -2.888171074609411e-15,  2.642799120828209e-17, -2.423780913742648e-18,  6.696079279785336e-20,  6.691205587734466e-22, -4.242027110430847e-23, -8.043385095635026e-25,
  5.108732229572679e-08, -1.002222842578517e-09,  2.842776583986104e-11, -9.245650115634669e-13,  2.127179457444549e-14, -2.811272154630520e-16,  4.330445548538704e-18,
 -2.151848941501708e-19,  5.342156914106147e-21,  2.684338848241834e-23, -2.254046549497468e-24, -6.632167257265994e-26,  1.100284973958167e-09, -2.401443031226253e-11,
  8.272710030899565e-13, -3.035788771991502e-14,  7.855089529044289e-16, -1.377661609758519e-17,  2.872178280332379e-19, -1.036626856952166e-20,  2.408924868781040e-22,
 -7.517347150673189e-25, -2.779210566514674e-26, -3.031287652981439e-27,  9.562262285144755e-12, -2.427969912337133e-13,  1.034736876883749e-14, -4.302954373259005e-16,
  1.288939607948014e-17, -3.004116757571935e-19,  7.859635883042562e-21, -2.486452371924283e-22,  5.937787509120721e-24, -7.991038388630180e-26,  1.457800805838268e-27,
 -8.020606226639272e-29,  2.388266451606250e-14, -7.681054497085244e-16,  4.198805211893795e-17, -2.038389120252540e-18,  7.478034492907964e-20, -2.363724263101874e-21,
  7.713454442851076e-23, -2.520380429923735e-24,  7.011563637225106e-26, -1.668769474931805e-27,  4.351373178171083e-29, -1.286141663595071e-30,  7.443911640218802e-18,
 -3.811839895619415e-19,  2.968563951769309e-20, -1.883120855085312e-21,  9.730706674327173e-23, -4.551218004957356e-24,  2.016374272045735e-25, -8.291078413402263e-27,
  3.116092536869923e-28, -1.094204382249369e-29,  3.685753597978675e-31, -1.180821152939303e-32,  3.859502095514103e-04, -5.598482503357756e-06,  6.260066699518765e-08,
 -4.669955251946045e-10,  3.687531412202600e-13, -3.128687111815379e-14,  3.212758357176407e-15, -3.126787033393668e-17, -2.272832315381646e-18,  5.068342881404565e-20,
  1.440960629625725e-21, -5.980235351744744e-23,  8.695301845110855e-04, -1.268836693949091e-05,  1.477657340280500e-07, -1.367732854161237e-09,  8.766403643675656e-12,
 -1.223644683848402e-13,  4.820028144133476e-15, -4.561715280407101e-17, -2.823923913905332e-18,  6.269990390385447e-20,  1.861651792754107e-21, -7.521585644716633e-23,
  7.442381504418038e-04, -1.097181713725992e-05,  1.364957945729476e-07, -1.643008038591168e-09,  1.953641991178040e-11, -1.925824145022229e-13,  8.434828054484681e-16,
 -7.263777089216790e-18,  9.997824126275915e-19, -2.118493242183552e-20, -4.665171575445663e-22,  2.212295232978149e-23,  3.346783760838142e-04, -5.008857611501256e-06,
  6.812676701547799e-08, -1.059220387500474e-09,  1.711289351985395e-11, -1.570820058311342e-13, -1.482637390723158e-15,  1.223461202565848e-17,  2.757379790769076e-18,
 -5.820902006609490e-20, -1.591525121221841e-21,  6.593439342529797e-23,  8.589054214916059e-05, -1.312441898594642e-06,  1.992777160045327e-08, -3.891713741357613e-10,
  7.528009428595401e-12, -7.183107280716951e-14, -8.684671586200030e-16,  5.401232722832617e-18,  1.557509759778897e-18, -3.189940456612372e-20, -9.044999909942480e-22,
  3.606029452864893e-23,  1.274180499931047e-05, -2.002008571281215e-07,  3.458311358336983e-09, -8.219457002258481e-11,  1.795017192697505e-12, -1.886144756098778e-14,
 -1.736386256247348e-16,  1.943303935828990e-19,  4.135373534382350e-19, -8.114318919235545e-21, -2.337010848118356e-22,  8.957240841143366e-24,  1.066109242112102e-06,
 -1.738453053962234e-08,  3.478049764229582e-10, -9.781915439881275e-12,  2.346143416326316e-13, -2.816582698004313e-15, -1.035662939020289e-17, -2.522698999140726e-19,
  5.803901028330139e-20, -1.078694046143081e-21, -3.043706424308441e-23,  1.116001518268419e-24,  4.747064874365067e-08, -8.137932743650175e-10,  1.920307615382327e-11,
 -6.252462365765408e-13,  1.630156449497766e-14, -2.300023162097538e-16,  6.999385693383675e-19, -4.919023559395598e-20,  4.391228607799917e-21, -7.713958173523926e-23,
 -1.930473769604768e-24,  6.765789349961449e-26,  1.015432958227046e-09, -1.865871736948303e-11,  5.302730018585882e-13, -1.970292200166627e-14,  5.597500357345145e-16,
 -9.532842979324926e-18,  9.822152929854825e-20, -3.474681216621026e-21,  1.756050278288915e-22, -3.006343342303295e-24, -4.922657591040155e-26,  1.692970042315305e-27,
  8.728348558279642e-12, -1.775666377408115e-13,  6.250526569050434e-15, -2.638940578372261e-16,  8.304238007979333e-18, -1.762499800164713e-19,  3.173701178796570e-21,
 -9.864177260482254e-23,  3.513631580731088e-24, -6.455450044260104e-26, -5.045399909215307e-29,  5.368588125147584e-30,  2.135181017617873e-14, -5.127455926376576e-16,
  2.341612511787916e-17, -1.139560486958462e-18,  4.141283707668426e-20, -1.151624514988211e-21,  3.080909669217540e-23, -9.904234480786209e-25,  3.104111597331861e-26,
 -7.086354717316253e-28,  1.168672112638429e-29, -2.948834412864991e-31,  6.281030113206251e-18, -2.131538749022095e-19,  1.410223466903439e-20, -8.539573753307374e-22,
  4.045325742267807e-23, -1.653783132793021e-24,  6.546380095614011e-26, -2.556542353563068e-27,  9.248099518699864e-29, -3.004167737063423e-30,  9.177240382587294e-32,
 -2.813237478028548e-33,  3.645225093205601e-04, -5.120014983535771e-06,  5.702392610532050e-08, -4.623330097380633e-10,  4.088688462192661e-13,  2.904771572993079e-14,
  1.642127824799705e-15, -6.892284164615263e-17, -4.924041428162908e-20,  5.685797762426813e-20, -9.107875488362421e-22, -3.174626824136455e-23,  8.210401899260662e-04,
 -1.156965573869780e-05,  1.321325509304819e-07, -1.241350936790923e-09,  7.329877391652876e-12, -2.978813295433034e-14,  2.680853547351568e-15, -9.212831489293892e-17,
 -3.512252508089448e-20,  7.185795273003141e-20, -1.133388949318684e-21, -4.104405803399865e-23,  7.024170709025526e-04, -9.953686952943771e-06,  1.185315989959996e-07,
 -1.360152625513941e-09,  1.588611113143422e-11, -1.719502360409883e-13,  9.587255465633473e-16,  1.081884843487696e-17,  1.307973846823368e-19, -2.148322092374104e-20,
  3.599203620756883e-22,  1.041365169108788e-23,  3.156587153563477e-04, -4.510281461915379e-06,  5.694971278174995e-08, -8.122126777339700e-10,  1.368534785759619e-11,
 -1.808148297624009e-13, -2.736446963536497e-16,  6.045576424900696e-17,  2.228375299689975e-19, -6.483923217809450e-20,  1.019321187323181e-21,  3.548433485598445e-23,
  8.093278015292329e-05, -1.169768260258546e-06,  1.592967810881575e-08, -2.812113400918652e-10,  5.919157279822831e-12, -8.645857981576220e-14, -2.232657897441429e-16,
  3.309066711077956e-17,  1.493931097664857e-19, -3.639335535731371e-20,  5.548758891881710e-22,  2.032861238272017e-23,  1.199073752583999e-05, -1.760214964812716e-07,
  2.631177459059823e-09, -5.669373001199977e-11,  1.382967972346320e-12, -2.178254467640455e-14, -3.502951609552953e-17,  7.756503271039368e-18,  5.194475984183268e-20,
 -9.436559798448847e-21,  1.385960635157459e-22,  5.330729758468302e-24,  1.001476912567676e-06, -1.501217489848087e-08,  2.510436727324190e-10, -6.491392101067684e-12,
  1.761348584813176e-13, -2.981786779424613e-15,  1.661491941591359e-18,  8.512193677538006e-19,  9.887235551199097e-21, -1.267381601854096e-21,  1.775311479695660e-23,
  7.145461203293556e-25,  4.448101089437747e-08, -6.860914240917607e-10,  1.311555475107138e-11, -4.005283233501008e-13,  1.182767984964884e-14, -2.167941385034625e-16,
  8.032190004832036e-19,  3.842496658847769e-20,  1.018700498598272e-21, -8.892247963704153e-23,  1.180080628129798e-24,  4.835022657360271e-26,  9.479817725251631e-10,
 -1.522380198785652e-11,  3.416312681715721e-13, -1.216713143249655e-14,  3.876070947183023e-16, -7.817402873178114e-18,  6.161982883260243e-20,  2.076756560739301e-22,
  5.377020406494076e-23, -3.145365474364794e-24,  4.023548372116908e-26,  1.497138218917256e-27,  8.100899284756131e-12, -1.382154289204845e-13,  3.776009895692642e-15,
 -1.558256782544767e-16,  5.373784784226139e-18, -1.226555846131748e-19,  1.639899360393949e-21, -2.263410090030643e-23,  1.306155549715751e-24, -5.263081242124215e-26,
  7.143697765995444e-28,  1.575761324222327e-29,  1.960275423580442e-14, -3.703802305505506e-16,  1.306559311753462e-17, -6.287234684827709e-19,  2.401851636990794e-20,
 -6.535578203270911e-22,  1.368666032748891e-23, -3.321759830647389e-25,  1.201793879726919e-26, -3.782323941185842e-28,  6.722217863801635e-30, -2.778259881710336e-32,
  5.601945409026931e-18, -1.323820004959655e-19,  6.868896112611031e-21, -4.053386955465679e-22,  1.867109285308195e-23, -6.867306125694587e-25,  2.299070235327242e-26,
 -8.040742599288331e-28,  2.893128991770094e-29, -9.446650492456327e-31,  2.631519395710848e-32, -6.721603776571881e-34,  3.449199237382956e-04, -4.685849477318629e-06,
  5.153953580776717e-08, -4.496401385410979e-10,  1.233646757560878e-12,  4.671470989931946e-14, -6.277438866281394e-17, -4.645476343933059e-17,  1.163935050901654e-18,
  9.502909838835269e-21, -1.098067314257653e-21,  1.643611189802959e-23,  7.767841234939793e-04, -1.057021328349875e-05,  1.179293293311872e-07, -1.126195498484073e-09,
  7.176711712936344e-12,  5.485355404682108e-15,  3.982380062224731e-16, -6.279950956220281e-17,  1.502495848811896e-18,  1.207988411746022e-20, -1.395972921792661e-21,
  2.061412266673519e-23,  6.644012236164122e-04, -9.066653189354290e-06,  1.036256808070367e-07, -1.132133250121351e-09,  1.270156228857869e-11, -1.454328355410252e-13,
  1.227126314217830e-15,  5.930472534870560e-18, -3.290851466956445e-19, -3.908516845977343e-21,  3.952281569182625e-22, -6.219464767179571e-24,  2.984719501031554e-04,
 -4.090221880411913e-06,  4.839801401821205e-08, -6.219686884580300e-10,  1.013670618040548e-11, -1.680852151859228e-13,  1.236007172866005e-15,  3.998657568806586e-17,
 -1.177744218539263e-18, -1.177749713268424e-20,  1.233254477753369e-21, -1.826685628231869e-23,  7.648930910765770e-05, -1.054350722537732e-06,  1.306622924233110e-08,
 -2.003183313812110e-10,  4.209767750709683e-12, -8.118467225797683e-14,  6.106625230212841e-16,  2.228485786496177e-17, -6.444643272831242e-19, -6.919745958777895e-21,
  6.925274308335790e-22, -1.000926017039451e-23,  1.132492913798676e-05, -1.573502470933029e-07,  2.069295194988049e-09, -3.802348209539331e-11,  9.563072436087222e-13,
 -2.009664832038238e-14,  1.638089196555913e-16,  5.344188170152986e-18, -1.567173958336332e-19, -1.920361792976169e-21,  1.786820008367189e-22, -2.507826502158120e-24,
  9.450132941260307e-07, -1.327198075353023e-08,  1.881175799333913e-10, -4.139889265838883e-12,  1.188558871125064e-13, -2.656290568096212e-15,  2.429155581814428e-17,
  6.143197679890327e-19, -1.867042836497561e-20, -2.834934947483102e-22,  2.370270457749582e-23, -3.202090565629602e-25,  4.192017226127820e-08, -5.974959736525602e-10,
  9.306064860612527e-12, -2.445270751092563e-13,  7.779643831978901e-15, -1.834781747460999e-16,  1.936248114610877e-18,  3.164500561077075e-20, -1.036310261164657e-21,
 -2.256741527801500e-23,  1.619048257616679e-24, -2.084240542638693e-26,  8.917618194159660e-10, -1.298068567354070e-11,  2.279479253907978e-13, -7.131585885852987e-15,
  2.471280716917629e-16, -6.165446013372250e-18,  7.724900395133465e-20,  5.127527351397456e-22, -2.118641962936623e-23, -9.331443574030101e-25,  5.412668894178816e-26,
 -6.625258306600325e-28,  7.598445231225426e-12, -1.141986521656258e-13,  2.347530517097580e-15, -8.748236661606129e-17,  3.280695847205336e-18, -8.770875298623099e-20,
  1.351284238985061e-21, -4.763205593267302e-24,  1.917080075207113e-26, -1.830397876222992e-26,  8.076058018637676e-28, -9.832203240847356e-30,  1.829054330878843e-14,
 -2.903916601421802e-16,  7.446079098649592e-18, -3.336729311588638e-19,  1.365654043215042e-20, -4.040218598166323e-22,  8.077572006674011e-24, -1.162879876149554e-25,
  2.886089076693179e-27, -1.420295449996745e-28,  4.737424859776319e-30, -6.953609472535979e-32,  5.157514198055102e-18, -9.268917156327507e-20,  3.423989602806383e-21,
 -1.926117073808600e-22,  9.060475037427399e-24, -3.258608451408114e-25,  9.500914109234328e-27, -2.647902984225682e-28,  8.537479618414883e-30, -2.986765164320939e-31,
  9.152227580067264e-33, -2.185394557105051e-34,  3.269675501138372e-04, -4.294711773349519e-06,  4.629182810542377e-08, -4.228744363088540e-10,  2.069633406680493e-12,
  3.386136007345295e-14, -8.415621149439852e-16, -1.054780960747181e-17,  9.238021629739453e-19, -1.685102585258289e-20, -2.184572883584328e-22,  1.737454376731187e-23,
  7.363073167334384e-04, -9.678874819373071e-06,  1.051078562699046e-07, -1.010469497873569e-09,  7.268109155821144e-12, -5.573030727930640e-16, -6.864889521708926e-16,
 -1.643708114109897e-17,  1.195614537743733e-18, -2.152307477381376e-20, -2.800601374316700e-22,  2.216698261596627e-23,  6.297111789082733e-04, -8.288745785132830e-06,
  9.116873052938695e-08, -9.505429958671284e-10,  1.009451423339483e-11, -1.152149403474663e-13,  1.242839739551996e-15, -4.412830826760533e-18, -2.615747276310927e-19,
  5.503044132659353e-21,  7.813675061689563e-23, -6.113840728235179e-24,  2.828417319529918e-04, -3.730378528712245e-06,  4.180264902500419e-08, -4.847612426519231e-10,
  7.139757653696573e-12, -1.293404312475167e-13,  1.821549813944681e-15,  3.181738085475989e-18, -9.459659494168254e-19,  1.796611926164587e-20,  2.516797902614492e-22,
 -1.944018718881494e-23,  7.246720314161453e-05, -9.584084608746807e-07,  1.101602026049929e-08, -1.449863295845534e-10,  2.770771998078341e-12, -6.143522205845667e-14,
  9.407280827356142e-16,  1.996006229797473e-18, -5.237162725609656e-19,  9.893852217200308e-21,  1.448352709118226e-22, -1.094742160206592e-23,  1.072607604150637e-05,
 -1.423898465321904e-07,  1.692360616025787e-09, -2.568412446504400e-11,  6.027688771301402e-13, -1.495709729629103e-14,  2.411954604819969e-16,  3.423033610529279e-19,
 -1.298974754605446e-19,  2.454991440104357e-21,  3.865244366236985e-23, -2.827832322247825e-24,  8.946612267501534e-07, -1.193723389900346e-08,  1.482114396323357e-10,
 -2.626954499790056e-12,  7.258564588900868e-14, -1.938090472693442e-15,  3.270672292100646e-17,  2.857848458839094e-21, -1.605386035969424e-20,  3.037509600139024e-22,
  5.379731060717551e-24, -3.746658426879248e-25,  3.966314317638060e-08, -5.329299734162961e-10,  7.006316833776460e-12, -1.466562121979304e-13,  4.625456444730776e-15,
 -1.304798958506721e-16,  2.312362948145736e-18, -4.244614941173435e-21, -9.642229200710115e-22,  1.819909880483244e-23,  3.936456238296592e-25, -2.541910163723660e-26,
  8.430276307799177e-10, -1.144089891284860e-11,  1.623597183924022e-13, -4.060036377697158e-15,  1.430431644309237e-16, -4.233601511584330e-18,  7.963809815213467e-20,
 -3.562929098423231e-22, -2.484040562059293e-23,  4.593273152290258e-25,  1.449912774464412e-26, -8.323024497276201e-28,  7.173660597763882e-12, -9.884732255558137e-14,
  1.560375106470999e-15, -4.731245841761332e-17,  1.838533761546567e-18, -5.721967664364359e-20,  1.166040516889612e-21, -9.486616124930126e-24, -1.878600155759419e-25,
  2.967830597347700e-27,  2.451005074665249e-28, -1.173190815465782e-29,  1.722726944842281e-14, -2.436753370306178e-16,  4.517815691516440e-18, -1.702468242090563e-19,
  7.289129407898545e-21, -2.423689305745395e-22,  5.570149507792570e-24, -7.547318363913805e-26,  4.059885150132272e-28, -1.686905701664676e-29,  1.602482947013267e-30,
 -5.954468266211833e-32,  4.829817432093330e-18, -7.250361881668698e-20,  1.801733815913628e-21, -8.946377877329655e-23,  4.348189431757784e-24, -1.637544492677370e-25,
  4.704984752416909e-27, -1.087768661083559e-28,  2.502618913411719e-30, -7.787954458623953e-32,  2.833182120867654e-33, -8.623521662981443e-35,  3.104980870813954e-04,
 -3.944068122083463e-06,  4.143466735910947e-08, -3.854877060909074e-10,  2.535734492954832e-12,  1.287169965755752e-14, -8.188726998822823e-16,  8.856198605818915e-18,
  3.043751603118939e-19, -1.467086302392226e-20,  2.214034303072071e-22,  3.175358186148079e-24,  6.991995293751118e-04, -8.884544736688777e-06,  9.367643200189594e-08,
 -8.952523939756407e-10,  7.074085063736679e-12, -1.898461493175551e-14, -7.335575230548384e-16,  8.840441422214289e-18,  4.037096900122792e-19, -1.877533147081448e-20,
  2.822521500614265e-22,  4.074038183285602e-24,  5.979463125282691e-04, -7.602441163341049e-06,  8.066034545690101e-08, -8.059010586109174e-10,  8.074418687711328e-12,
 -8.762204905017722e-14,  1.033587341722241e-15, -9.443255513777569e-18, -5.783834230601654e-20,  4.806172944802802e-21, -7.561546845571855e-23, -1.103672917651724e-24,
  2.685547201948953e-04, -3.417465099055478e-06,  3.659321252814037e-08, -3.888674964638580e-10,  4.982329936568944e-12, -8.734380702676998e-14,  1.589660018150409e-15,
 -1.618081353225350e-17, -2.798356857917924e-19,  1.579824629506419e-20, -2.416984534584487e-22, -3.594917322211452e-24,  6.879975752929205e-05, -8.765714329650328e-07,
  9.505584383572475e-09, -1.092675306775282e-10,  1.764057640132540e-12, -3.973212858251309e-14,  8.188436523127891e-16, -8.726222312228897e-18, -1.546053768891695e-19,
  8.777879807985253e-21, -1.341523803737031e-22, -2.053515103257332e-24,  1.018184647840553e-05, -1.299405521304596e-07,  1.433155033395206e-09, -1.812252319422485e-11,
  3.602308337034575e-13, -9.436039871512352e-15,  2.067924223055619e-16, -2.303947198634741e-18, -3.734745934753247e-20,  2.210152578000015e-21, -3.378826051201637e-23,
 -5.408065816157471e-25,  8.491083593233509e-07, -1.086056533656863e-08,  1.225130823065674e-10, -1.733907967986232e-12,  4.142591507802830e-14, -1.199330541219351e-15,
  2.737425502645185e-17, -3.212153705688924e-19, -4.391219733976346e-21,  2.805534129389707e-22, -4.286709568625219e-24, -7.368795474392713e-26,  3.763391733728902e-08,
 -4.828399781306676e-10,  5.613893717152672e-12, -9.060507488540290e-14,  2.545988557914072e-15, -7.922959251225147e-17,  1.870786143814832e-18, -2.340625577302999e-20,
 -2.400739103728809e-22,  1.766902668789463e-23, -2.687677367408266e-25, -5.212455751312217e-27,  7.996004947442667e-10, -1.030377818951409e-11,  1.249009640602505e-13,
 -2.349659550701512e-15,  7.628629089007964e-17, -2.514108207089895e-18,  6.145839702972935e-20, -8.348372486140480e-22, -4.930608485199458e-24,  5.018198619016002e-25,
 -7.498083644382187e-27, -1.818681362632993e-28,  6.800244736273026e-12, -8.821282581933093e-14,  1.136012787197925e-15, -2.563133444313418e-17,  9.495566455220638e-19,
 -3.295727214166829e-20,  8.407256901028402e-22, -1.274887165150268e-23, -4.821040470916781e-27,  5.119347757054897e-27, -7.075241755211919e-29, -2.821654028390652e-30,
  1.631428291725689e-14, -2.140467004109769e-16,  3.036266766095598e-18, -8.583215197214437e-20,  3.613864383454124e-21, -1.328072367562776e-22,  3.609946186775902e-24,
 -6.414829772089271e-26,  4.434733279166458e-28,  8.258811701533809e-30, -2.350300806317245e-32, -1.622975633286861e-32,  4.563217609681534e-18, -6.141492358548987e-20,
  1.054893653373642e-21, -4.085768325643806e-23,  1.993699899779016e-24, -8.030036828733983e-26,  2.478822643073777e-27, -5.770816053976867e-29,  1.031758531812671e-30,
 -1.843302206833927e-32,  5.881989530124196e-34, -2.431368049849591e-35,  2.953564635659867e-04, -3.630391366609896e-06,  3.705754747097232e-08, -3.438257969165959e-10,
  2.620577446176165e-12, -3.128160400161752e-15, -5.009756917009527e-16,  1.196811296465550e-17, -5.419048501582270e-20, -5.455297169826954e-21,  1.971196855646113e-22,
 -2.707722038671613e-24,  6.650948053401739e-04, -8.176215816586313e-06,  8.359716439936328e-08, -7.859578969899676e-10,  6.543583419595459e-12, -3.270169408223970e-14,
 -3.902416046774082e-16,  1.326920938555807e-17, -5.584504193165924e-20, -7.015934887427532e-21,  2.516210839471698e-22, -3.456721855420520e-24,  5.687688003795622e-04,
 -6.993770292732834e-06,  7.171096160480916e-08, -6.894739209491015e-10,  6.548138468937275e-12, -6.606031075936398e-14,  7.648433934072508e-16, -9.148916277022448e-18,
  5.718361803451982e-20,  1.654289515967277e-21, -6.735093817529851e-23,  9.339764820571260e-25,  2.554425514163810e-04, -3.142149957341415e-06,  3.235372262901084e-08,
 -3.212185185156956e-10,  3.577017092275400e-12, -5.518601618734101e-14,  1.082538358558494e-15, -1.803187611341710e-17,  1.030433430822037e-19,  5.690975323281347e-21,
 -2.163546097782950e-22,  2.991381269022161e-24,  6.543786279122470e-05, -8.053456727507520e-07,  8.340715326008137e-09, -8.642175415208980e-11,  1.144353053939765e-12,
 -2.331841177906996e-14,  5.448547621745236e-16, -9.728644316901000e-18,  5.789146284216889e-20,  3.144841338442208e-21, -1.207246547878523e-22,  1.673103766990313e-24,
  9.683758923325424e-06, -1.192599168120603e-07,  1.244848699673964e-09, -1.362245791512656e-11,  2.154927038803936e-13, -5.318651247950728e-15,  1.355144679152730e-16,
 -2.507159039379384e-18,  1.600704148615525e-20,  7.820013807420929e-22, -3.066843227747599e-23,  4.263948462222995e-25,  8.075083070692850e-07, -9.954027444142923e-09,
  1.049983379315933e-10, -1.230526720591057e-12,  2.323353048986207e-14, -6.580962239010207e-16,  1.767620077480216e-17, -3.360831295129466e-19,  2.352727168015727e-21,
  9.732157985132590e-23, -3.949035725536263e-24,  5.510212704565803e-26,  3.578633119053473e-08, -4.416910887261548e-10,  4.726026794772071e-12, -6.033819190500635e-14,
  1.355015053862951e-15, -4.255632695635231e-17,  1.187283839340579e-18, -2.319785699790318e-20,  1.820001099173386e-22,  5.939292804999217e-24, -2.546081086986434e-25,
  3.563314815120067e-27,  7.602300859610081e-10, -9.399945119102378e-12,  1.026067558053159e-13, -1.459271485791658e-15,  3.883107427626041e-17, -1.323057288485555e-18,
  3.812538449942814e-20, -7.693868046210807e-22,  6.941328860748370e-24,  1.595373064560046e-25, -7.548224474480327e-27,  1.055529284039423e-28,  6.463928483629971e-12,
 -8.014031753481547e-14,  9.010655661285364e-16, -1.473501297371304e-17,  4.638189767278097e-19, -1.693412047041082e-20,  5.045369809190480e-22, -1.063722845774181e-23,
  1.142209531796568e-25,  1.428145541927063e-27, -8.510174851934012e-29,  1.167468031092979e-30,  1.550130969993470e-14, -1.930677252914535e-16,  2.279215532308873e-18,
 -4.513070637129385e-20,  1.687964704006980e-21, -6.587562050672208e-23,  2.050268536877818e-24, -4.628400038991670e-26,  6.244492954315332e-28,  5.991971287481729e-31,
 -2.241158935141096e-31,  2.598366580947463e-33,  4.331959114109695e-18, -5.449819101551984e-20,  7.121148560381700e-22, -1.906301668695082e-23,  8.688627077787700e-25,
 -3.695985162565350e-26,  1.248465226848621e-27, -3.231491711580221e-29,  6.140684444042962e-31, -7.957525968330153e-33,  8.579899160523113e-35, -3.272400112756622e-36,
  2.814026834499790e-04, -3.349730282326240e-06,  3.317933137936722e-08, -3.029417623129248e-10,  2.463319677473755e-12, -1.145935487253429e-14, -2.102394544077798e-16,
  8.368057459337874e-18, -1.389084486800650e-19, -6.686225994066977e-23,  7.587830256552904e-23, -2.307118362091764e-24,  6.336702076784374e-04, -7.543437034522493e-06,
  7.477095329599989e-08, -6.868813865251245e-10,  5.824180228458669e-12, -3.798263091521025e-14, -6.965520757033312e-17,  9.070061546145089e-18, -1.658824789588113e-19,
 -1.387290348628670e-22,  9.681164894212318e-23, -2.944792061438954e-24,  5.418910843320437e-04, -6.451490601725715e-06,  6.402529891447684e-08, -5.943588382187840e-10,
  5.390986100379023e-12, -5.053280162207396e-14,  5.400277287509412e-16, -6.801395358999655e-18,  7.868865900554490e-20, -1.778156358343740e-22, -2.546844945588219e-23,
  7.983634068725363e-25,  2.433684720774945e-04, -2.897841246287632e-06,  2.881019521889493e-08, -2.715674465612384e-10,  2.694742709514168e-12, -3.475491825408212e-14,
  6.442701381918693e-16, -1.285520229381283e-17,  1.856149912386511e-19, -2.007140516764180e-22, -8.215433546807813e-23,  2.553640023928913e-24,  6.234376147021866e-05,
 -7.424881990718664e-07,  7.400181808344296e-09, -7.122036892750461e-11,  7.881018794676644e-13, -1.322634991551560e-14,  3.096420131002491e-16, -6.844638118655985e-18,
  1.029282563499455e-19, -1.369168265820876e-22, -4.555126842358776e-23,  1.429920264195924e-24,  9.225674926933583e-06, -1.099034407957096e-07,  1.099066471743777e-09,
 -1.087141721030920e-11,  1.363386850197762e-13, -2.832323703728285e-15,  7.525368836723371e-17, -1.742440747170523e-18,  2.686470376839895e-20, -4.949568687588053e-23,
 -1.145922519768978e-23,  3.653431746212898e-25,  7.692864236654841e-07, -9.167652205500122e-09,  9.209445396935496e-11, -9.440505794365189e-13,  1.360579168552410e-14,
 -3.360125996938267e-16,  9.658315740788866e-18, -2.301925609431085e-19,  3.633811147995502e-21, -9.354037850947543e-24, -1.454822114579261e-24,  4.745400427386599e-26,
  3.409104400375525e-08, -4.064662119157809e-10,  4.108407177645289e-12, -4.412584492313904e-14,  7.402334237025662e-16, -2.106253793305974e-17,  6.392996703820550e-19,
 -1.559103044730972e-20,  2.529108553993515e-22, -9.029381844670418e-25, -9.184170139359394e-26,  3.101447925143766e-27,  7.241737335978102e-10, -8.640296452142795e-12,
  8.809228932682554e-14, -1.006771542658464e-15,  1.992047698000593e-17, -6.379977017667791e-19,  2.019683912229302e-20, -5.038257259335106e-22,  8.463931327250364e-24,
 -4.177208312281191e-26, -2.631990552308150e-27,  9.412385949902252e-29,  6.156813381118268e-12, -7.353485140458831e-14,  7.594687721641169e-16, -9.458888775313100e-18,
  2.243595921646238e-19, -7.959563335278869e-21,  2.615554692837099e-22, -6.704345097741867e-24,  1.182946567193802e-25, -8.139763950712923e-28, -2.781763300471878e-29,
  1.113920925283963e-30,  1.476261188588387e-14, -1.766259330083254e-16,  1.863767379638226e-18, -2.639011768733408e-20,  7.690958588569828e-22, -2.999752181904164e-23,
  1.026643799421586e-24, -2.739221910266986e-26,  5.219805563964151e-28, -5.164995540050391e-30, -5.979497397009053e-32,  3.439388971589880e-33,  4.124182615571051e-18,
 -4.952694455175226e-20,  5.468980772064472e-22, -9.717677609988691e-24,  3.664299138432582e-25, -1.587980226871179e-26,  5.793495861763477e-28, -1.675501351971822e-29,
  3.708649107175430e-31, -5.774114027816084e-33,  4.668959537275396e-35,  1.442217903844189e-37  };
  int offset = -12;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 12;
    if (std::isnan(t)) {
      fill_n(rr+offset, 12, 0.5);
      fill_n(ww+offset, 12, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 12; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t*t*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;
      const double t2 = t * 2.0;
      for (int j=1; j <=12; ++j) {
        const int boxof = it*144+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
