//
// BAGEL - Brilliantly Advanced General Electronic Structure Library
// Filename: glibint.h
// Copyright (C) 2012 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//


#ifdef LIBINT_INTERFACE

#ifndef __SRC_RYSINT_GLIBINT_H
#define __SRC_RYSINT_GLIBINT_H

#include <src/integral/rys/rysintegral.h>

namespace bagel {

class GLibint : public RysInt {
  protected:
    void root_weight(int) override {}
    void compute_ssss(double) override {}

  public:
    GLibint(const std::array<std::shared_ptr<const Shell>,4>&, std::shared_ptr<StackMem> stack = nullptr);

    void compute() override {}

    double* data(const int i) override { return data_ + i*size_block_; }

    virtual void allocate_data(const int asize_final, const int csize_final, const int asize_final_sph, const int csize_final_sph) { assert(false); }
};

}

#endif

#endif
