//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      Device/Histo/DiffUtil.h
//! @brief     Defines namespace DataUtil.
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_DEVICE_HISTO_DIFFUTIL_H
#define BORNAGAIN_DEVICE_HISTO_DIFFUTIL_H

#include <memory>
#include <vector>

class Datafield;
class SimulationResult;

namespace DiffUtil {

//! Returns relative difference between two data sets sum(dat[i] - ref[i])/ref[i]).
double meanRelVecDiff(const std::vector<double>& dat, const std::vector<double>& ref);

//! Returns Datafield representing relative difference of two histograms.
Datafield* relativeDifferenceField(const Datafield& dat, const Datafield& ref);

//! Returns sum of relative differences between each pair of elements:
//! (a, b) -> 2*abs(a - b)/(a + b)      ( and zero if  a-b=0 )
double meanRelativeDifference(const SimulationResult& dat, const SimulationResult& ref);

//! Returns true is relative difference is below threshold; prints informative output
bool checkRelativeDifference(const std::vector<double>& dat, const std::vector<double>& ref,
                             double threshold);
} // namespace DiffUtil

#endif // BORNAGAIN_DEVICE_HISTO_DIFFUTIL_H
