//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Device/SphericalDetectorForm.cpp
//! @brief     Implement class SphericalDetectorForm
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#include "GUI/View/Device/SphericalDetectorForm.h"
#include "GUI/Model/Detector/SphericalDetectorItem.h"
#include "GUI/View/Device/AxisPropertyForm.h"
#include "GUI/View/Device/ResolutionForm.h"
#include <QGridLayout>

SphericalDetectorForm::SphericalDetectorForm(QWidget* parent, SphericalDetectorItem* item)
    : QWidget(parent)
{
    ASSERT(item);
    auto* grid = new QGridLayout(this);
    grid->setColumnStretch(0, 1);
    grid->setColumnStretch(1, 1);
    grid->setColumnStretch(2, 1);

    auto* phiForm =
        new AxisPropertyForm(this, u8"\u03c6 axis", &item->phiAxis(), "Number of phi-axis bins");
    grid->addWidget(phiForm, 1, 0);

    auto* alphaForm = new AxisPropertyForm(this, u8"\u03b1 axis", &item->alphaAxis(),
                                           "Number of alpha-axis bins");
    grid->addWidget(alphaForm, 1, 1);

    auto* resolutionForm = new ResolutionForm(ResolutionForm::Degree, this, item);
    grid->addWidget(resolutionForm, 1, 2);

    grid->setRowStretch(2, 1);

    connect(phiForm, &AxisPropertyForm::dataChanged, this, &SphericalDetectorForm::dataChanged);

    connect(alphaForm, &AxisPropertyForm::dataChanged, this, &SphericalDetectorForm::dataChanged);

    connect(resolutionForm, &ResolutionForm::dataChanged, this,
            &SphericalDetectorForm::dataChanged);
}
