/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/*
 * This file is part of the libepubgen project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#ifndef INCLUDED_EPUBGENERATOR_H
#define INCLUDED_EPUBGENERATOR_H

#include "EPUBHTMLManager.h"
#include "EPUBHTMLGenerator.h"
#include "EPUBImageManager.h"
#include "EPUBListStyleManager.h"
#include "EPUBManifest.h"
#include "EPUBParagraphStyleManager.h"
#include "EPUBPath.h"
#include "EPUBSpanStyleManager.h"
#include "EPUBSplitGuard.h"
#include "EPUBTableStyleManager.h"

namespace libepubgen
{

class EPUBPackage;

class EPUBGenerator
{
  // disable copying
  EPUBGenerator(const EPUBGenerator &);
  EPUBGenerator &operator=(const EPUBGenerator &);

public:
  EPUBGenerator(EPUBPackage *package, EPUBSplitMethod method);
  virtual ~EPUBGenerator();

  void startDocument(const librevenge::RVNGPropertyList &props);
  void endDocument();

  void setDocumentMetaData(const librevenge::RVNGPropertyList &props);

  void startNewHtmlFile();

  const EPUBHTMLGeneratorPtr_t &getHtml() const;

  const EPUBSplitGuard &getSplitGuard() const;
  EPUBSplitGuard &getSplitGuard();

private:
  virtual void startHtmlFile() = 0;
  virtual void endHtmlFile() = 0;

private:
  void writeContainer();
  void writeNavigation();
  void writeStylesheet();
  void writeRoot();

private:
  EPUBPackage *m_package;
  EPUBManifest m_manifest;
  EPUBHTMLManager m_htmlManager;
  EPUBImageManager m_imageManager;
  EPUBListStyleManager m_listStyleManager;
  EPUBParagraphStyleManager m_paragraphStyleManager;
  EPUBSpanStyleManager m_spanStyleManager;
  EPUBTableStyleManager m_tableStyleManager;
  const EPUBPath m_stylesheetPath;

  librevenge::RVNGPropertyList m_documentProps;
  librevenge::RVNGPropertyList m_metadata;

  EPUBHTMLGeneratorPtr_t m_currentHtml;

  EPUBSplitGuard m_splitGuard;
};

}

#endif // INCLUDED_EPUBGENERATOR

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
