-----------------------------------------------------------------------
--              GtkAda - Ada95 binding for Gtk+/Gnome                --
--                                                                   --
--                  Copyright (C) 2008-2013, AdaCore                 --
--                                                                   --
-- This library is free software; you can redistribute it and/or     --
-- modify it under the terms of the GNU General Public               --
-- License as published by the Free Software Foundation; either      --
-- version 2 of the License, or (at your option) any later version.  --
--                                                                   --
-- This library is distributed in the hope that it will be useful,   --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of    --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU --
-- General Public License for more details.                          --
--                                                                   --
-- You should have received a copy of the GNU General Public         --
-- License along with this library; if not, write to the             --
-- Free Software Foundation, Inc., 59 Temple Place - Suite 330,      --
-- Boston, MA 02111-1307, USA.                                       --
--                                                                   --
-----------------------------------------------------------------------

with Gdk.Display;  use Gdk.Display;

package Gdk.Display_Manager is

   type Display_Manager is new Glib.C_Proxy;

   function Display_Manager_Get return Display_Manager;
   --  Return the global Display Manager.
   --  This function must be called after the initial call to Gtk.Main.Init.

   procedure Set_Default_Display
     (Manager : Display_Manager;
      Display : Gdk_Display);
   --  Set Display as the default display.

private
   pragma Import (C, Display_Manager_Get, "gdk_display_manager_get");

end Gdk.Display_Manager;
