/**********************************************************
 * This file has been automatically created by "typemaker2"
 * from the file "gwen_parser_element.xml".
 * Please do not edit this file, all changes will be lost.
 * Better edit the mentioned source file instead.
 **********************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include "gwen_parser_element_p.h"

#include <gwenhywfar/misc.h>
#include <gwenhywfar/debug.h>

/* code headers */

/* macro functions */
GWEN_LIST_FUNCTIONS(GWEN_PARSER_ELEMENT, GWEN_ParserElement)
GWEN_LIST2_FUNCTIONS(GWEN_PARSER_ELEMENT, GWEN_ParserElement)
GWEN_TREE_FUNCTIONS(GWEN_PARSER_ELEMENT, GWEN_ParserElement)


GWEN_PARSER_ELEMENT_TYPE GWEN_ParserElementType_fromString(const char *p_s) {
  if (p_s && *p_s) {
    if (strcasecmp(p_s, "element")==0)
      return GWEN_ParserElementType_Element;
    else if (strcasecmp(p_s, "attribute")==0)
      return GWEN_ParserElementType_Attribute;
    else if (strcasecmp(p_s, "data")==0)
      return GWEN_ParserElementType_Data;
    else if (strcasecmp(p_s, "choice")==0)
      return GWEN_ParserElementType_Choice;
  }
  return GWEN_ParserElementType_Unknown;
}

const char *GWEN_ParserElementType_toString(GWEN_PARSER_ELEMENT_TYPE p_i) {
  switch(p_i) {
    case GWEN_ParserElementType_Element: return "element";
    case GWEN_ParserElementType_Attribute: return "attribute";
    case GWEN_ParserElementType_Data: return "data";
    case GWEN_ParserElementType_Choice: return "choice";
    default: return "unknown";
  }
}

GWEN_PARSER_ELEMENT *GWEN_ParserElement_new(void) {
  GWEN_PARSER_ELEMENT *p_struct;

  GWEN_NEW_OBJECT(GWEN_PARSER_ELEMENT, p_struct)
  p_struct->_refCount=1;
  GWEN_LIST_INIT(GWEN_PARSER_ELEMENT, p_struct)
  GWEN_TREE_INIT(GWEN_PARSER_ELEMENT, p_struct)
  /* members */
  p_struct->flags=0;
  p_struct->elementType=GWEN_ParserElementType_Element;
  p_struct->name=NULL;
  p_struct->type=NULL;
  p_struct->dbName=NULL;
  p_struct->minOccurs=1;
  p_struct->maxOccurs=1;
  p_struct->minSize=0;
  p_struct->maxSize=-1;
  p_struct->data=NULL;
  p_struct->runtimeFlags=0;
  /* virtual functions */

  return p_struct;
}

void GWEN_ParserElement_free(GWEN_PARSER_ELEMENT *p_struct) {
  if (p_struct) {
  assert(p_struct->_refCount);
  if (p_struct->_refCount==1) {
    GWEN_LIST_FINI(GWEN_PARSER_ELEMENT, p_struct)
    GWEN_TREE_FINI(GWEN_PARSER_ELEMENT, p_struct)
  /* members */
    free(p_struct->name);
    free(p_struct->type);
    free(p_struct->dbName);
    free(p_struct->data);
    p_struct->_refCount=0;
    GWEN_FREE_OBJECT(p_struct);
  }
  else
    p_struct->_refCount--;
  }
}

void GWEN_ParserElement_Attach(GWEN_PARSER_ELEMENT *p_struct) {
  assert(p_struct);
  assert(p_struct->_refCount);
  p_struct->_refCount++;
}

GWEN_PARSER_ELEMENT *GWEN_ParserElement_dup(const GWEN_PARSER_ELEMENT *p_src) {
  GWEN_PARSER_ELEMENT *p_struct;

  assert(p_src);
  p_struct=GWEN_ParserElement_new();
  /* member "flags" */
  p_struct->flags=p_src->flags;

  /* member "elementType" */
  p_struct->elementType=p_src->elementType;

  /* member "name" */
  if (p_struct->name) {
    free(p_struct->name);
    p_struct->name=NULL;
  }
  if (p_src->name) {
    p_struct->name=strdup(p_src->name);
  }

  /* member "type" */
  if (p_struct->type) {
    free(p_struct->type);
    p_struct->type=NULL;
  }
  if (p_src->type) {
    p_struct->type=strdup(p_src->type);
  }

  /* member "dbName" */
  if (p_struct->dbName) {
    free(p_struct->dbName);
    p_struct->dbName=NULL;
  }
  if (p_src->dbName) {
    p_struct->dbName=strdup(p_src->dbName);
  }

  /* member "minOccurs" */
  p_struct->minOccurs=p_src->minOccurs;

  /* member "maxOccurs" */
  p_struct->maxOccurs=p_src->maxOccurs;

  /* member "minSize" */
  p_struct->minSize=p_src->minSize;

  /* member "maxSize" */
  p_struct->maxSize=p_src->maxSize;

  /* member "data" */
  if (p_struct->data) {
    free(p_struct->data);
    p_struct->data=NULL;
  }
  if (p_src->data) {
    p_struct->data=strdup(p_src->data);
  }

  /* member "runtimeFlags" */
  p_struct->runtimeFlags=p_src->runtimeFlags;

  return p_struct;
}

GWEN_PARSER_ELEMENT *GWEN_ParserElement_copy(GWEN_PARSER_ELEMENT *p_struct, const GWEN_PARSER_ELEMENT *p_src) {
    assert(p_struct);
  assert(p_src);
  /* member "flags" */
  p_struct->flags=p_src->flags;

  /* member "elementType" */
  p_struct->elementType=p_src->elementType;

  /* member "name" */
  if (p_struct->name) {
    free(p_struct->name);
  }
  if (p_struct->name) {
    free(p_struct->name);
    p_struct->name=NULL;
  }
  if (p_src->name) {
    p_struct->name=strdup(p_src->name);
  }

  /* member "type" */
  if (p_struct->type) {
    free(p_struct->type);
  }
  if (p_struct->type) {
    free(p_struct->type);
    p_struct->type=NULL;
  }
  if (p_src->type) {
    p_struct->type=strdup(p_src->type);
  }

  /* member "dbName" */
  if (p_struct->dbName) {
    free(p_struct->dbName);
  }
  if (p_struct->dbName) {
    free(p_struct->dbName);
    p_struct->dbName=NULL;
  }
  if (p_src->dbName) {
    p_struct->dbName=strdup(p_src->dbName);
  }

  /* member "minOccurs" */
  p_struct->minOccurs=p_src->minOccurs;

  /* member "maxOccurs" */
  p_struct->maxOccurs=p_src->maxOccurs;

  /* member "minSize" */
  p_struct->minSize=p_src->minSize;

  /* member "maxSize" */
  p_struct->maxSize=p_src->maxSize;

  /* member "data" */
  if (p_struct->data) {
    free(p_struct->data);
  }
  if (p_struct->data) {
    free(p_struct->data);
    p_struct->data=NULL;
  }
  if (p_src->data) {
    p_struct->data=strdup(p_src->data);
  }

  /* member "runtimeFlags" */
  p_struct->runtimeFlags=p_src->runtimeFlags;

  return p_struct;
}

uint32_t GWEN_ParserElement_GetFlags(const GWEN_PARSER_ELEMENT *p_struct) {
  assert(p_struct);
  return p_struct->flags;
}

GWEN_PARSER_ELEMENT_TYPE GWEN_ParserElement_GetElementType(const GWEN_PARSER_ELEMENT *p_struct) {
  assert(p_struct);
  return p_struct->elementType;
}

const char *GWEN_ParserElement_GetName(const GWEN_PARSER_ELEMENT *p_struct) {
  assert(p_struct);
  return p_struct->name;
}

const char *GWEN_ParserElement_GetType(const GWEN_PARSER_ELEMENT *p_struct) {
  assert(p_struct);
  return p_struct->type;
}

const char *GWEN_ParserElement_GetDbName(const GWEN_PARSER_ELEMENT *p_struct) {
  assert(p_struct);
  return p_struct->dbName;
}

int GWEN_ParserElement_GetMinOccurs(const GWEN_PARSER_ELEMENT *p_struct) {
  assert(p_struct);
  return p_struct->minOccurs;
}

int GWEN_ParserElement_GetMaxOccurs(const GWEN_PARSER_ELEMENT *p_struct) {
  assert(p_struct);
  return p_struct->maxOccurs;
}

int GWEN_ParserElement_GetMinSize(const GWEN_PARSER_ELEMENT *p_struct) {
  assert(p_struct);
  return p_struct->minSize;
}

int GWEN_ParserElement_GetMaxSize(const GWEN_PARSER_ELEMENT *p_struct) {
  assert(p_struct);
  return p_struct->maxSize;
}

const char *GWEN_ParserElement_GetData(const GWEN_PARSER_ELEMENT *p_struct) {
  assert(p_struct);
  return p_struct->data;
}

uint32_t GWEN_ParserElement_GetRuntimeFlags(const GWEN_PARSER_ELEMENT *p_struct) {
  assert(p_struct);
  return p_struct->runtimeFlags;
}

void GWEN_ParserElement_SetFlags(GWEN_PARSER_ELEMENT *p_struct, uint32_t p_src) {
  assert(p_struct);
  p_struct->flags=p_src;
}

void GWEN_ParserElement_AddFlags(GWEN_PARSER_ELEMENT *p_struct, uint32_t p_src) {
  assert(p_struct);
  p_struct->flags|=p_src;
}

void GWEN_ParserElement_SubFlags(GWEN_PARSER_ELEMENT *p_struct, uint32_t p_src) {
  assert(p_struct);
  p_struct->flags&=~p_src;
}

void GWEN_ParserElement_SetElementType(GWEN_PARSER_ELEMENT *p_struct, GWEN_PARSER_ELEMENT_TYPE  p_src) {
  assert(p_struct);
  p_struct->elementType=p_src;
}

void GWEN_ParserElement_SetName(GWEN_PARSER_ELEMENT *p_struct, const char *p_src) {
  assert(p_struct);
  if (p_struct->name) {
    free(p_struct->name);
  }
  if (p_src) {
    p_struct->name=strdup(p_src);
  }
  else {
    p_struct->name=NULL;
  }
}

void GWEN_ParserElement_SetType(GWEN_PARSER_ELEMENT *p_struct, const char *p_src) {
  assert(p_struct);
  if (p_struct->type) {
    free(p_struct->type);
  }
  if (p_src) {
    p_struct->type=strdup(p_src);
  }
  else {
    p_struct->type=NULL;
  }
}

void GWEN_ParserElement_SetDbName(GWEN_PARSER_ELEMENT *p_struct, const char *p_src) {
  assert(p_struct);
  if (p_struct->dbName) {
    free(p_struct->dbName);
  }
  if (p_src) {
    p_struct->dbName=strdup(p_src);
  }
  else {
    p_struct->dbName=NULL;
  }
}

void GWEN_ParserElement_SetMinOccurs(GWEN_PARSER_ELEMENT *p_struct, int p_src) {
  assert(p_struct);
  p_struct->minOccurs=p_src;
}

void GWEN_ParserElement_SetMaxOccurs(GWEN_PARSER_ELEMENT *p_struct, int p_src) {
  assert(p_struct);
  p_struct->maxOccurs=p_src;
}

void GWEN_ParserElement_SetMinSize(GWEN_PARSER_ELEMENT *p_struct, int p_src) {
  assert(p_struct);
  p_struct->minSize=p_src;
}

void GWEN_ParserElement_SetMaxSize(GWEN_PARSER_ELEMENT *p_struct, int p_src) {
  assert(p_struct);
  p_struct->maxSize=p_src;
}

void GWEN_ParserElement_SetData(GWEN_PARSER_ELEMENT *p_struct, const char *p_src) {
  assert(p_struct);
  if (p_struct->data) {
    free(p_struct->data);
  }
  if (p_src) {
    p_struct->data=strdup(p_src);
  }
  else {
    p_struct->data=NULL;
  }
}

void GWEN_ParserElement_SetRuntimeFlags(GWEN_PARSER_ELEMENT *p_struct, uint32_t p_src) {
  assert(p_struct);
  p_struct->runtimeFlags=p_src;
}

void GWEN_ParserElement_AddRuntimeFlags(GWEN_PARSER_ELEMENT *p_struct, uint32_t p_src) {
  assert(p_struct);
  p_struct->runtimeFlags|=p_src;
}

void GWEN_ParserElement_SubRuntimeFlags(GWEN_PARSER_ELEMENT *p_struct, uint32_t p_src) {
  assert(p_struct);
  p_struct->runtimeFlags&=~p_src;
}

/* list1 functions */
GWEN_PARSER_ELEMENT_LIST *GWEN_ParserElement_List_dup(const GWEN_PARSER_ELEMENT_LIST *p_src) {
  GWEN_PARSER_ELEMENT_LIST *p_dest;
  GWEN_PARSER_ELEMENT *p_elem;

  assert(p_src);
  p_dest=GWEN_ParserElement_List_new();
  p_elem=GWEN_ParserElement_List_First(p_src);
  while(p_elem) {
    GWEN_PARSER_ELEMENT *p_cpy;

    p_cpy=GWEN_ParserElement_dup(p_elem);
    GWEN_ParserElement_List_Add(p_cpy, p_dest);
    p_elem=GWEN_ParserElement_List_Next(p_elem);
  }

  return p_dest;
}

void GWEN_ParserElement_ReadDb(GWEN_PARSER_ELEMENT *p_struct, GWEN_DB_NODE *p_db) {
  assert(p_struct);
  /* member "flags" */
  p_struct->flags=GWEN_DB_GetIntValue(p_db, "flags", 0, 0);

  /* member "elementType" */
  { const char *s; s=GWEN_DB_GetCharValue(p_db, "elementType", 0, NULL); if (s) p_struct->elementType=GWEN_ParserElementType_fromString(s); else p_struct->elementType=GWEN_ParserElementType_Element; }

  /* member "name" */
  if (p_struct->name) {
    free(p_struct->name);
  }
  { const char *s; s=GWEN_DB_GetCharValue(p_db, "name", 0, NULL); if (s) p_struct->name=strdup(s); }
  if (p_struct->name==NULL) {  p_struct->name=NULL;
  }

  /* member "type" */
  if (p_struct->type) {
    free(p_struct->type);
  }
  { const char *s; s=GWEN_DB_GetCharValue(p_db, "type", 0, NULL); if (s) p_struct->type=strdup(s); }
  if (p_struct->type==NULL) {  p_struct->type=NULL;
  }

  /* member "dbName" */
  if (p_struct->dbName) {
    free(p_struct->dbName);
  }
  { const char *s; s=GWEN_DB_GetCharValue(p_db, "dbName", 0, NULL); if (s) p_struct->dbName=strdup(s); }
  if (p_struct->dbName==NULL) {  p_struct->dbName=NULL;
  }

  /* member "minOccurs" */
  p_struct->minOccurs=GWEN_DB_GetIntValue(p_db, "minOccurs", 0, 1);

  /* member "maxOccurs" */
  p_struct->maxOccurs=GWEN_DB_GetIntValue(p_db, "maxOccurs", 0, 1);

  /* member "minSize" */
  p_struct->minSize=GWEN_DB_GetIntValue(p_db, "minSize", 0, 0);

  /* member "maxSize" */
  p_struct->maxSize=GWEN_DB_GetIntValue(p_db, "maxSize", 0, -1);

  /* member "data" */
  if (p_struct->data) {
    free(p_struct->data);
  }
  { const char *s; s=GWEN_DB_GetCharValue(p_db, "data", 0, NULL); if (s) p_struct->data=strdup(s); }
  if (p_struct->data==NULL) {  p_struct->data=NULL;
  }

  /* member "runtimeFlags" */
  /* member "runtimeFlags" is volatile, just presetting */
  p_struct->runtimeFlags=0;

}

int GWEN_ParserElement_WriteDb(const GWEN_PARSER_ELEMENT *p_struct, GWEN_DB_NODE *p_db) {
  int p_rv;

  assert(p_struct);
  /* member "flags" */
  p_rv=GWEN_DB_SetIntValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "flags", p_struct->flags);
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "elementType" */
  p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "elementType", GWEN_ParserElementType_toString(p_struct->elementType));
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "name" */
  if (p_struct->name) p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "name", p_struct->name); else { GWEN_DB_DeleteVar(p_db, "name"); p_rv=0; }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "type" */
  if (p_struct->type) p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "type", p_struct->type); else { GWEN_DB_DeleteVar(p_db, "type"); p_rv=0; }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "dbName" */
  if (p_struct->dbName) p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "dbName", p_struct->dbName); else { GWEN_DB_DeleteVar(p_db, "dbName"); p_rv=0; }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "minOccurs" */
  p_rv=GWEN_DB_SetIntValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "minOccurs", p_struct->minOccurs);
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "maxOccurs" */
  p_rv=GWEN_DB_SetIntValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "maxOccurs", p_struct->maxOccurs);
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "minSize" */
  p_rv=GWEN_DB_SetIntValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "minSize", p_struct->minSize);
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "maxSize" */
  p_rv=GWEN_DB_SetIntValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "maxSize", p_struct->maxSize);
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "data" */
  if (p_struct->data) p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "data", p_struct->data); else { GWEN_DB_DeleteVar(p_db, "data"); p_rv=0; }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "runtimeFlags" is volatile, not writing to db */

  return 0;
}

GWEN_PARSER_ELEMENT *GWEN_ParserElement_fromDb(GWEN_DB_NODE *p_db) {
  GWEN_PARSER_ELEMENT *p_struct;
  p_struct=GWEN_ParserElement_new();
  GWEN_ParserElement_ReadDb(p_struct, p_db);
  return p_struct;
}

int GWEN_ParserElement_toDb(const GWEN_PARSER_ELEMENT *p_struct, GWEN_DB_NODE *p_db) {
  return GWEN_ParserElement_WriteDb(p_struct, p_db);
}


/* code headers */
#include "gwen_parser_element_fns.c"

