// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _IGESData_BasicEditor_HeaderFile
#define _IGESData_BasicEditor_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineAlloc_HeaderFile
#include <Standard_DefineAlloc.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_IGESData_Protocol_HeaderFile
#include <Handle_IGESData_Protocol.hxx>
#endif
#ifndef _Handle_IGESData_IGESModel_HeaderFile
#include <Handle_IGESData_IGESModel.hxx>
#endif
#ifndef _Interface_GeneralLib_HeaderFile
#include <Interface_GeneralLib.hxx>
#endif
#ifndef _IGESData_SpecificLib_HeaderFile
#include <IGESData_SpecificLib.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Handle_IGESData_IGESEntity_HeaderFile
#include <Handle_IGESData_IGESEntity.hxx>
#endif
class IGESData_Protocol;
class IGESData_IGESModel;
class IGESData_IGESEntity;


//! This class provides various functions of basic edition, <br>
//!           such as : <br>
//!           - setting header unit (WARNING : DOES NOT convert entities) <br>
//!           - computation of the status (Subordinate, UseFlag) of entities <br>
//!             of IGES Entities on a whole model <br>
//!           - auto correction of IGES Entities, defined both by DirChecker <br>
//!             and by specific service AutoCorrect <br>
//!             (this auto correction performs non-ambigious, rather logic, <br>
//!              editions) <br>
class IGESData_BasicEditor  {
public:

  DEFINE_STANDARD_ALLOC

  //! Creates a Basic Editor, with a new IGESModel, ready to run <br>
  Standard_EXPORT   IGESData_BasicEditor(const Handle(IGESData_Protocol)& protocol);
  //! Creates a Basic Editor for IGES Data, ready to run <br>
  Standard_EXPORT   IGESData_BasicEditor(const Handle(IGESData_IGESModel)& model,const Handle(IGESData_Protocol)& protocol);
  //! Returns the designated model <br>
  Standard_EXPORT     Handle_IGESData_IGESModel Model() const;
  //! Sets a new unit from its flag (param 14 of Global Section) <br>
//!           Returns True if done, False if <flag> is incorrect <br>
  Standard_EXPORT     Standard_Boolean SetUnitFlag(const Standard_Integer flag) ;
  //! Sets a new unit from its value in meters (rounded to the <br>
//!           closest one, max gap 1%) <br>
//!           Returns True if done, False if <val> is too far from a <br>
//!           suitable value <br>
  Standard_EXPORT     Standard_Boolean SetUnitValue(const Standard_Real val) ;
  //! Sets a new unit from its name (param 15 of Global Section) <br>
//!           Returns True if done, False if <name> is incorrect <br>
//!           Remark : if <flag> has been set to 3 (user defined), <name> <br>
//!           is then free <br>
  Standard_EXPORT     Standard_Boolean SetUnitName(const Standard_CString name) ;
  //! Applies unit value to convert header data : Resolution, <br>
//!           MaxCoord, MaxLineWeight <br>
//!           Applies unit only once after SetUnit... has been called, <br>
//!           if <enforce> is given as True. <br>
//!           It can be called just before writing the model to a file, <br>
//!           i.e. when definitive values are finally known <br>
  Standard_EXPORT     void ApplyUnit(const Standard_Boolean enforce = Standard_False) ;
  //! Performs the re-computation of status on the whole model <br>
//!           (Subordinate Status and Use Flag of each IGES Entity), which <br>
//!           can have required values according the way they are referenced <br>
//!           (see definitions of Logical use, Physical use, etc...) <br>
  Standard_EXPORT     void ComputeStatus() ;
  //! Performs auto-correction on an IGESEntity <br>
//!           Returns True if something has changed, False if nothing done. <br>
//! <br>
//!           Works with the specific IGES Services : DirChecker which <br>
//!           allows to correct data in "Directory Part" of Entities (such <br>
//!           as required values for status, or references to be null), and <br>
//!           the specific IGES service OwnCorrect, which is specialised for <br>
//!           each type of entity. <br>
  Standard_EXPORT     Standard_Boolean AutoCorrect(const Handle(IGESData_IGESEntity)& ent) ;
  //! Performs auto-correction on the whole Model <br>
//!           Returns the count of modified entities <br>
  Standard_EXPORT     Standard_Integer AutoCorrectModel() ;
  //! From the name of unit, computes flag number, 0 if incorrect <br>
//!           (in this case, user defined entity remains possible) <br>
  Standard_EXPORT   static  Standard_Integer UnitNameFlag(const Standard_CString name) ;
  //! From the flag of unit, determines value in MM, 0 if incorrect <br>
  Standard_EXPORT   static  Standard_Real UnitFlagValue(const Standard_Integer flag) ;
  //! From the flag of unit, determines its name, "" if incorrect <br>
  Standard_EXPORT   static  Standard_CString UnitFlagName(const Standard_Integer flag) ;
  //! From the flag of IGES version, returns name, "" if incorrect <br>
  Standard_EXPORT   static  Standard_CString IGESVersionName(const Standard_Integer flag) ;
  //! Returns the maximum allowed value for IGESVersion Flag <br>
  Standard_EXPORT   static  Standard_Integer IGESVersionMax() ;
  //! From the flag of drafting standard, returns name, "" if incorrect <br>
  Standard_EXPORT   static  Standard_CString DraftingName(const Standard_Integer flag) ;
  //! Returns the maximum allowed value for Drafting Flag <br>
  Standard_EXPORT   static  Standard_Integer DraftingMax() ;





protected:





private:



Standard_Boolean theunit;
Handle_IGESData_Protocol theproto;
Handle_IGESData_IGESModel themodel;
Interface_GeneralLib theglib;
IGESData_SpecificLib theslib;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
