// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _IntAna2d_IntPoint_HeaderFile
#define _IntAna2d_IntPoint_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <Standard_Real.hxx>
#include <gp_Pnt2d.hxx>
#include <Standard_Boolean.hxx>
#include <Standard_Storable.hxx>
#include <Standard_PrimitiveTypes.hxx>
class Standard_DomainError;
class gp_Pnt2d;


Standard_EXPORT const Handle(Standard_Type)& STANDARD_TYPE(IntAna2d_IntPoint);

//! Geometrical intersection between two 2d elements.
class IntAna2d_IntPoint 
{

public:

  DEFINE_STANDARD_ALLOC

  
  //! Create an intersection point between 2 parametric 2d lines.
  //! X,Y are the coordinate of the point. U1 is the parameter
  //! on the first element, U2 the parameter on the second one.
  Standard_EXPORT IntAna2d_IntPoint(const Standard_Real X, const Standard_Real Y, const Standard_Real U1, const Standard_Real U2);
  
  //! Create an intersection point between a parametric 2d line,
  //! and a line given by an implicit equation (ImplicitCurve).
  //! X,Y are the coordinate of the point. U1 is the parameter
  //! on the parametric element.
  //! Empty constructor. It's necessary to use one of
  //! the SetValue method after this one.
  Standard_EXPORT IntAna2d_IntPoint(const Standard_Real X, const Standard_Real Y, const Standard_Real U1);
  
  Standard_EXPORT IntAna2d_IntPoint();
  
  //! Set the values for a "non-implicit" point.
  Standard_EXPORT virtual   void SetValue (const Standard_Real X, const Standard_Real Y, const Standard_Real U1, const Standard_Real U2) ;
  
  //! Set the values for an "implicit" point.
  Standard_EXPORT virtual   void SetValue (const Standard_Real X, const Standard_Real Y, const Standard_Real U1) ;
  
  //! Returns the geometric point.
     const  gp_Pnt2d& Value()  const;
  
  //! Returns True if the second curve is implicit.
      Standard_Boolean SecondIsImplicit()  const;
  
  //! Returns the parameter on the first element.
      Standard_Real ParamOnFirst()  const;
  
  //! Returns the parameter on the second element.
  //! If the second element is an implicit curve, an exception
  //! is raised.
      Standard_Real ParamOnSecond()  const;
    Standard_Real _CSFDB_GetIntAna2d_IntPointmyu1() const { return myu1; }
    void _CSFDB_SetIntAna2d_IntPointmyu1(const Standard_Real p) { myu1 = p; }
    Standard_Real _CSFDB_GetIntAna2d_IntPointmyu2() const { return myu2; }
    void _CSFDB_SetIntAna2d_IntPointmyu2(const Standard_Real p) { myu2 = p; }
    const gp_Pnt2d& _CSFDB_GetIntAna2d_IntPointmyp() const { return myp; }
    Standard_Boolean _CSFDB_GetIntAna2d_IntPointmyimplicit() const { return myimplicit; }
    void _CSFDB_SetIntAna2d_IntPointmyimplicit(const Standard_Boolean p) { myimplicit = p; }



protected:




private: 


  Standard_Real myu1;
  Standard_Real myu2;
  gp_Pnt2d myp;
  Standard_Boolean myimplicit;


};


#include <IntAna2d_IntPoint.lxx>





#endif // _IntAna2d_IntPoint_HeaderFile
