/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.sort;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.circular.CircularDependencyStrategy;
import org.apache.ivy.plugins.version.VersionMatcher;
import org.apache.ivy.util.Message;

final class ModuleInSort {
    private final ModuleDescriptor module;
    private boolean isSorted = false;
    private List loopElements = new LinkedList();
    private boolean isLoopIntermediateElement = false;
    private ModuleInSort caller;

    public ModuleInSort(ModuleDescriptor moduleDescriptor) {
        this.module = moduleDescriptor;
    }

    public final boolean isProcessed() {
        if (this.isSorted || this.isLoopIntermediateElement) {
            Message.debug("Module descriptor is processed : " + this.module.getModuleRevisionId().toString());
            return true;
        }
        return false;
    }

    public final void setCaller(ModuleInSort moduleInSort) {
        this.caller = moduleInSort;
    }

    public final void endOfCall() {
        this.caller = null;
    }

    public final boolean checkLoop(ModuleInSort moduleRevisionIdArray, CircularDependencyStrategy circularDependencyStrategy) {
        if (this.caller != null) {
            LinkedList<ModuleRevisionId> linkedList = new LinkedList<ModuleRevisionId>();
            linkedList.add(this.module.getModuleRevisionId());
            Object object = moduleRevisionIdArray;
            while (object != this) {
                linkedList.add(object.module.getModuleRevisionId());
                object.isLoopIntermediateElement = true;
                this.loopElements.add(object);
                object = object.caller;
            }
            linkedList.add(this.module.getModuleRevisionId());
            object = linkedList.toArray(new ModuleRevisionId[linkedList.size()]);
            circularDependencyStrategy.handleCircularDependency((ModuleRevisionId[])object);
            return true;
        }
        return false;
    }

    public final void addToSortedListIfRequired(List list) {
        if (!this.isLoopIntermediateElement) {
            this.addToSortList(list);
        }
    }

    private void addToSortList(List list) {
        boolean bl;
        Iterator iterator = this.loopElements.iterator();
        while (iterator.hasNext()) {
            ((ModuleInSort)iterator.next()).addToSortList(list);
        }
        ModuleInSort moduleInSort = this;
        if (moduleInSort.isSorted) {
            Message.debug("Module descriptor already sorted : " + moduleInSort.module.getModuleRevisionId().toString());
            bl = true;
        } else {
            bl = false;
        }
        if (!bl) {
            list.add(this.module);
            this.isSorted = true;
        }
    }

    public final String toString() {
        return this.module.getModuleRevisionId().toString();
    }

    public final DependencyDescriptor[] getDependencies() {
        return this.module.getDependencies();
    }

    public final boolean match(DependencyDescriptor dependencyDescriptor, VersionMatcher versionMatcher) {
        ModuleDescriptor moduleDescriptor = this.module;
        return moduleDescriptor.getResolvedModuleRevisionId().getRevision() == null || moduleDescriptor.getResolvedModuleRevisionId().getRevision().equals(Ivy.getWorkingRevision()) || versionMatcher.accept(dependencyDescriptor.getDependencyRevisionId(), moduleDescriptor);
    }

    public final ModuleDescriptor getSortedModuleDescriptor() {
        return this.module;
    }
}

