<!-- SPDX-License-Identifier: BSD-3-Clause -->
<!-- Copyright (c) Contributors to the OpenEXR Project -->

# OpenEXR Project Roles and Responsibilities

OpenEXR is a project of the Academy Software Foundation and relies on
the ASWF governance policies, supported by the Linux Foundation.

There are three primary project roles: a "contributor" submits code to the
project; a "committer" approves code to be included into the project; and
the "Technical Steering Committee" (TSC) provides overall high-level
project guidance.

* [Contributors](#Contributors)
* [Committers](#Committers)
* [Technical Steering Committee](#Technical-Steering-Committee)

## Contributors

The OpenEXR project grows and thrives from assistance from
contributors.  A contributor is anyone in the community who submits
code, bug fixes, documentation, or other technical artifacts to the
project. However, such contributions must be approved by a project
committer before they become a part of the project.

Anyone can be a contributor. You need no formal approval from the
project, beyond the legal forms.

### How to Become a Contributor

* Review the coding standards to ensure your contribution is in line
  with the project's coding and styling guidelines.

* Sign the Individual CLA, or have your organization sign the Corporate CLA.

* Submit your code as a PR with the appropriate DCO sign-off.

## Committers

Project committers have merge access on the OpenEXR GitHub repositories
and are responsible for approving submissions by contributors.

### Committer Responsibilities

Typical activities of a committer include:

* Helping users and novice contributors.

* Ensuring a response to questions posted to the
  openexr-dev@lists.aswf.io mailing list.

* Contributing code and documentation changes that improve the
  project.

* Reviewing and commenting on issues and pull requests.

* Ensuring that changes and new code meet acceptable standards and are
  in the long-term interest of the project.

* Participating in working groups.

* Merging pull requests.

### How to Become a Committer

Any existing committer can nominate an individual making significant
and valuable contributions to the OpenEXR project to become a new
committer.  New committers are approved by vote of the TSC.

If you are interested in becoming a committer, contact the TSC at
info@openexr.com.

## Technical Steering Committee

The Technical Steering Committee (TSC) oversees the overall technical
direction of OpenEXR, as defined in the project
[charter](ASWF/charter/OpenEXR-Technical-Charter.md).  This
charter defines the TSC member terms and succession policies.

The responsibilities of the TSC include:

* Coordinating technical direction of the project.

* Project governance and contribution policy.

* GitHub repository administration.

* Maintaining the list of additional committers.

* Appointing representatives to work with other open source or open
  standards communities.

* Discussions, seeking consensus, and where necessary, voting on
  technical matters relating to the code base that affect multiple
  projects.

* Coordinating any marketing, events, or communications regarding the
  project.

The TSC elects a Chair person, who acts as the project manager,
organizing meetings and providing oversight to project
administration. The Chair is elected by the TSC.  The Chair also
serves as the OpenEXR representative on the Academy Software
Foundation (ASWF) Technical Advisory Council (TAC). The chair
represents the project at ASWF TAC meetings.

### Current TSC Members

* Cary Phillips (chair) - Industrial Light & Magic
* Rod Bogart - Epic Games
* Larry Gritz - Sony Pictures ImageWorks
* Peter Hillman - Weta Digital, Ltd.
* Kimball Thurston - Weta Digital, Ltd.
* Nick Porcino - Pixar Animation Studios
* Christina Tempelaar-Lietz - Industrial Light & Magic
* Joseph Goldstone - ARRI
* John Mertic - The Linux Foundation

### TSC Meetings

All meetings of the TSC are open to participation by any member of the
OpenEXR community. Meeting times are listed in the [ASWF technical
community calendar](https://lists.aswf.io/g/tac/calendar), currently
each Thursday at 1:30pm Pacific Time via Zoom video conference.  The
TSC Chair moderates the meeting, or appoints another TSC member to
moderate in his or her absence.

Items are added to the TSC agenda which are considered contentious or
are modifications of governance, contribution policy, TSC membership,
or release process, in addition to topics involving the high-level
technical direction of the project.

The intention of the agenda is not to approve or review all
patches. That should happen continuously on GitHub and be handled by
the larger group of committers.

Any community member or contributor can ask that something be reviewed
by the TSC at the meeting by logging a GitHub issue. Any committer,
TSC member, or the meeting chair can bring the issue to the TSC's
attention by applying the `TSC` label.

Prior to each TSC meeting, the meeting chair will share the agenda with members
of the TSC. TSC members can also add items to the agenda at the beginning of
each meeting. The meeting chair and the TSC cannot veto or remove items.

The TSC may invite additional persons to participate in a non-voting capacity.

The meeting chair is responsible for archiving the minutes, stored at 
https://github.com/AcademySoftwareFoundation/openexr/tree/master/ASWF/tsc-meetings.

Due to the challenges of scheduling a global meeting with participants
in several time zones, the TSC will seek to resolve as many agenda
items as possible outside of meetings on the public mailing list.

