/**
 * VampirTrace
 * http://www.tu-dresden.de/zih/vampirtrace
 *
 * Copyright (c) 2005-2013, ZIH, TU Dresden, Federal Republic of Germany
 *
 * Copyright (c) 1998-2005, Forschungszentrum Juelich, Juelich Supercomputing
 *                          Centre, Federal Republic of Germany
 *
 * See the file COPYING in the package base directory for details
 **/

package grpFilt;

import help.Config;
import help.Text;
import help.myMouseListener;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JFormattedTextField;
import javax.swing.JViewport;
import javax.swing.border.TitledBorder;
import javax.swing.text.DefaultFormatter;


import widgets.myFileDialog;
import xmlObjects.Group;
import xmlObjects.VtEnv;


/****
 * 	Is a Panel that contains all components and gui elements for the general settings of grouping and filtering.
 */
public class General extends javax.swing.JPanel{
	
	/**
	 * serialVersionUID
	 */
	private static final long serialVersionUID = 1L;
	private SymbolGroupTable simbolTable= null;
	private Group group = null;
	private GridBagConstraints c = new GridBagConstraints();
	private JViewport view = null;
	private VtEnv env = null;
	private boolean isclicked = false;
	private boolean wasShown = false;
	private JButton symbAdd = new JButton("Import From Executable");
	private final myFileDialog impFile = new myFileDialog();
	private JButton addSymb = new JButton("Add Single Symbol Name");
	private final myFileDialog fromBin = new myFileDialog();
	private JButton fromBinBtn = null;
	private final JFormattedTextField text = new JFormattedTextField("");
	private JPanel Symb = new JPanel(new GridBagLayout());
	private Text mytext = null;
	private JPanel impExistings = null;
	private JLabel grpLabel = null;
	private JLabel filtLabel = null;
	private JScrollPane comp = null;
	private  JPanel search = null;
	/****
	 * initialize all components
	 * @param sTable SymbolGroupTable used by this class, Filtering and Grouping class.
	 */
	public General(final SymbolGroupTable sTable,Group group,boolean advanced,final VtEnv env,Text mytext)
	{
		this.mytext = mytext;
		simbolTable = sTable;
		this.env = env;
		this.setLayout(new GridBagLayout());
		
	impExistings = new JPanel(new GridBagLayout());
//	impExistings.setBorder(BorderFactory.createTitledBorder(mytext.getText("General_imp_grpFilt_title")));
	impExistings.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 0, 0, 0,Color.GRAY), mytext.getText("General_imp_grpFilt_title"), TitledBorder.DEFAULT_JUSTIFICATION,TitledBorder.DEFAULT_POSITION));
	GridBagConstraints d = new GridBagConstraints();
//	impExistings.setVisible(false);

	d.fill = GridBagConstraints.HORIZONTAL;
	
	d.gridx=d.gridy=0;
	
	
	d.gridwidth = 0;
	d.anchor = GridBagConstraints.LINE_START;
	grpLabel = new JLabel(mytext.getText("General_grp_Label"));
	d.weightx = 1;
	impExistings.add(grpLabel,d);
	
	
	d.gridwidth = 1;
	d.gridx = 1;
	d.insets = new Insets(8,0,8,30);
	final myFileDialog grpFile = new myFileDialog();
	fromBinBtn = new JButton(mytext.getText("General_imp_bin_title"));
	grpFile.setIsFile(true);
	grpFile.setIsPath(false);
	grpFile.setIObehavior("in");
	grpFile.showDialog();
	
	impExistings.add(grpFile,d);

	d.gridx=2;
	JButton impGrpFile = new JButton(mytext.getText("Import_Label"));
	
	
	d.weightx = 0;
	impExistings.add(impGrpFile,d);
	d.weightx = 1;
	d.gridx = 0;
	d.gridy++;
	
	d.weightx = 0;
	filtLabel = new JLabel("Filter file");
	impExistings.add(filtLabel,d);
	d.weightx = 1;
	d.gridx = 1;
	final myFileDialog filtFile = new myFileDialog();
	filtFile.setIsFile(true);
	filtFile.setIsPath(false);
	filtFile.setIObehavior("in");
	filtFile.showDialog();
	impExistings.add(filtFile,d);
	
	d.gridx=2;
	JButton impfiltFile = new JButton("Import");
	d.weightx = 0;
	impExistings.add(impfiltFile,d);
	d.weightx = 1;
	
	if(advanced)
	{
		grpLabel.setPreferredSize(new Dimension(VtEnv.maxLabelWidth_adv-30,grpLabel.getPreferredSize().height)); 
		grpLabel.setMinimumSize(new Dimension(VtEnv.maxLabelWidth_adv-30,grpLabel.getPreferredSize().height));
		filtLabel.setPreferredSize(new Dimension(VtEnv.maxLabelWidth_adv-30,grpLabel.getPreferredSize().height)); 
		filtLabel.setMinimumSize(new Dimension(VtEnv.maxLabelWidth_adv-30,grpLabel.getPreferredSize().height));
	}
	else
	{
		grpLabel.setPreferredSize(new Dimension(VtEnv.maxLabelWidth-30,grpLabel.getPreferredSize().height)); 
		grpLabel.setMinimumSize(new Dimension(VtEnv.maxLabelWidth-30,grpLabel.getPreferredSize().height));
		filtLabel.setPreferredSize(new Dimension(VtEnv.maxLabelWidth-30,grpLabel.getPreferredSize().height));
		filtLabel.setMinimumSize(new Dimension(VtEnv.maxLabelWidth-30,grpLabel.getPreferredSize().height));
	}
	
	
	    c.fill = GridBagConstraints.HORIZONTAL;
	    c.weightx = 1;
		c.gridx=0;
		c.gridy=0;

		 
		c.gridwidth = 4;
		c.insets = new Insets(0,10,10,8);
		c.anchor = GridBagConstraints.LINE_START;

		c.gridwidth = 4;
		c.gridy++;
		
		this.add(impExistings,c);
		c.insets = new Insets(10,10,10,8);
		c.gridx=0;
		c.gridwidth = 4;
		c.gridy++;
		
		
		
		//Symb.setBorder(BorderFactory.createTitledBorder(mytext.getText("General_ApplSymFunc_title")));
		Symb.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 0, 0, 0,Color.GRAY), mytext.getText("General_ApplSymFunc_title"), TitledBorder.DEFAULT_JUSTIFICATION,TitledBorder.DEFAULT_POSITION));
		d.gridx=0;
		d.gridy=0;
		d.gridx = 0;
		
		d.gridy++;
		d.gridwidth = 3;
		d.insets = new Insets(0,0,8,0);
		
		Symb.add(addTable(),d);
		d.gridx = 4;
	//	d.insets = new Insets(0,0,0,60);
		
		d.gridy++;
		d.gridx = 2;

		d.weightx = 0;
		Symb.add(addSymb,d);
		d.weightx = 1;
		d.gridx = 0;
		d.gridwidth = 2;

		
		//text.setColumns(19);
		d.insets = new Insets(0,0,0,30);
		Symb.add(text,d);
		d.insets = new Insets(0,0,8,0);
		d.gridy++;
		d.gridx=2;
		d.gridwidth = 1;
		d.weightx = 0;
		Symb.add(symbAdd,d);
		d.weightx = 1;
		d.gridx = 0;
		d.gridwidth = 2;
		
		impFile.setIsFile(true);
		impFile.setIsPath(false);
		impFile.setIObehavior("in");
		impFile.showDialog();
		d.insets = new Insets(0,0,0,30);
		Symb.add(impFile,d);
		d.insets = new Insets(0,0,8,0);
		
		
		d.gridy++;
		d.gridx=2;
		d.gridwidth = 1;

		symbAdd.setPreferredSize(fromBinBtn.getPreferredSize());
		addSymb.setPreferredSize(fromBinBtn.getPreferredSize());
		if(VtEnv.nm.trim().equals(""))
		{
			fromBinBtn.setEnabled(false);
			impFile.setEnabled(false);
			symbAdd.setEnabled(false);
			fromBin.setEnabled(false);
		}
		d.weightx = 0;
		Symb.add(fromBinBtn,d);
		d.weightx = 1;
		d.gridx = 0;
		d.gridwidth = 2;
		fromBin.setIsFile(true);
		fromBin.setIsPath(false);
		fromBin.setIObehavior("in");
		fromBin.showDialog();
		d.insets = new Insets(0,0,0,30);
		Symb.add(fromBin,d);
		d.insets = new Insets(0,0,8,0);
		
		
		c.gridx = 0;
		c.gridwidth = 4;
		this.add(Symb,c);
	//	if(Symb.getPreferredSize().width < Config.subGroup_min_width)
	//		Symb.setPreferredSize(new Dimension(Config.subGroup_min_width, Symb.getPreferredSize().height));
		
		this.group = group;
		JPanel grouppanel = group.getPanel(advanced);
		((JPanel)grouppanel.getComponent(0)).remove(0);

		c.insets = new Insets(0,0,0,0);
		c.gridy++;
		this.add(grouppanel,c);
		
		//ActionListenors
		addSymb.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {		
				simbolTable.addRow(text.getText());
				text.setText("");
				isclicked = true;
			}
			
		});
	
		fromBinBtn.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent e)
			{				
				sTable.getSymbolsFromExecutable(fromBin.text.getText(),"own",false);
				sTable.find(null);
				isclicked = true;
				((JFormattedTextField)fromBin.getComponent(0)).setText("");
			}
		});
		
		symbAdd.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent e)
			{	
				if(sTable.executablesLoded)
				{
					String[] options = { VtEnv.mytext.getText("dialog_chanche_exec_takenew"),VtEnv.mytext.getText("dialog_chanche_exec_merge"),VtEnv.mytext.getText("dialog_chanche_exec_takeold")};
	    			int answer = JOptionPane.showOptionDialog(null, VtEnv.mytext.getText("dialog_chanche_exec"), VtEnv.mytext.getText("dialog_chanche_exec_title"),JOptionPane.DEFAULT_OPTION, JOptionPane.WARNING_MESSAGE,null, options, options[0]);
	    			VtEnv.executableAnswer = answer;
				}
				sTable.getSymbolsFromExecutable(impFile.text.getText(),"exec",false);
				sTable.find(null);
				sTable.executablesLoded=true;
				isclicked = true;
			}
		});
		
		impGrpFile.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e)
			{
				sTable.setGrpFile(grpFile.text.getText());
				isclicked = true;
			}
		});
		
		impfiltFile.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e)
			{
				sTable.setFilterFile(filtFile.text.getText());
				isclicked = true;
			}
		});
		
		myMouseListener l = new myMouseListener();
		l.setToolTip(env);
		l.setText(Config.setToolTipString(mytext.getText("General_imp_grpFile_title"), mytext.getText("General_imp_grpFile")));
		
		impGrpFile.addMouseListener(l);
		grpFile.addMouseListener(l);
		grpFile.getComponent(0).addMouseListener(l);
		grpFile.getComponent(1).addMouseListener(l);
		
		l = new myMouseListener();
		l.setToolTip(env);
		l.setText(Config.setToolTipString(mytext.getText("General_imp_filtFile_title"), mytext.getText("General_imp_filtFile")));
		impfiltFile.addMouseListener(l);
		filtFile.addMouseListener(l);
		filtFile.getComponent(0).addMouseListener(l);
		filtFile.getComponent(1).addMouseListener(l);
		
		l = new myMouseListener();
		l.setToolTip(env);
		l.setText(Config.setToolTipString(mytext.getText("General_addSymb_title"), mytext.getText("General_addSymb")));
		addSymb.addMouseListener(l);
		text.addMouseListener(l);
		
		l = new myMouseListener();
		l.setToolTip(env);
		if(VtEnv.nm.equals(""))
			l.setText(Config.setToolTipString(mytext.getText("General_imp_exec_title"), mytext.getText("General_imp_exec_nonm")));
		else
			l.setText(Config.setToolTipString(mytext.getText("General_imp_exec_title"), mytext.getText("General_imp_exec")));
		
		symbAdd.addMouseListener(l);
		impFile.addMouseListener(l);
		impFile.getComponent(0).addMouseListener(l);
		impFile.getComponent(1).addMouseListener(l);
		
		
		l = new myMouseListener();
		l.setToolTip(env);
		if(VtEnv.nm.equals(""))
			l.setText(Config.setToolTipString(mytext.getText("General_imp_bin_title"), mytext.getText("General_imp_bin_nonm")));
		else
			l.setText(Config.setToolTipString(mytext.getText("General_imp_bin_title"), mytext.getText("General_imp_bin")));
		fromBin.addMouseListener(l);
		for(int k=0;k<fromBin.getComponentCount();k++)
		{
			fromBin.getComponent(k).addMouseListener(l);
		}
		fromBinBtn.addMouseListener(l);
		
	}
	
	
	/***
	 * initialize a symbolGroupTable with search  button scrollPane  
	 * @return component with symbolGroupTable 
	 */
	private Component addTable()
	{
		final JFormattedTextField text = new JFormattedTextField("");
		((DefaultFormatter)text.getFormatter()).setOverwriteMode(false);
		text.setColumns(8);
		
		simbolTable.find(null);
		simbolTable.setView(SymbolGroupTable.GENERAL_VIEW);
		comp = new JScrollPane(simbolTable);
		comp.setPreferredSize(new Dimension(258, 250));
		comp.setVerticalScrollBarPolicy( JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
		comp.setHorizontalScrollBarPolicy( JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
		
		view = comp.getViewport();
		search = new JPanel(new BorderLayout());
		final JLabel SearchFor = new JLabel("Search for ");
		search.add(SearchFor);
		search.add(text,BorderLayout.LINE_END);

		JPanel output = new JPanel(new GridBagLayout());
		GridBagConstraints c = new GridBagConstraints();
		c.gridx=0;c.gridy=0;
		output.add(new JLabel(),c);
		
		
		c.gridx = 1;
		c.anchor = GridBagConstraints.LINE_END;
		output.add(search,c);
		c.gridy++;
		c.gridx = 0;
		c.gridwidth = 2;
		c.fill = GridBagConstraints.HORIZONTAL;
		c.weightx = 1;
		output.add(comp,c);
		c.weightx = 0;
		
		
		final SearchFunction myFunc = new SearchFunction(simbolTable,text);
		final Thread searchThread = new Thread(myFunc);
		searchThread.start();
		
		text.addKeyListener(new KeyListener(){


			public void keyPressed(KeyEvent e) {;}

			public void keyReleased(KeyEvent e) {
				if(myFunc.searchisRunning)
				{
					try {
						myFunc.currentDelay = 0;
					} catch (Exception err) {
						Config.errorHandler(err);
					}
				}else{
					try {
						myFunc.searchisRunning = true;
						myFunc.currentDelay = 0;
					} catch (Exception err) {
						Config.errorHandler(err);
					}
				}
				
					
			}

			public void keyTyped(KeyEvent e) {;}
			
		});
	



		myMouseListener n = new myMouseListener();
		n.setToolTip(env);
		n.setText(Config.setToolTipString(mytext.getText("General_search_title"), mytext.getText("General_search")));
		
		text.addMouseListener(n);
		
		
		return output;
	}

	/***
	 * changes view   
	 * @param visible true if advanced settings are shown otherwise false
	 * @return this panel in the special view.
	 */
	public JPanel getPanel(boolean visible)
	{
		this.remove(this.getComponentCount()-1);
		JPanel grouppanel = (JPanel)group.getPanel(visible).getComponent(0);
		grouppanel.remove(0);
		c.insets = new Insets(0,0,0,0);
		this.add(grouppanel,c);
		comp.setVisible(true);
		search.setVisible(true);
		if(!wasShown && !simbolTable.simbolIsSet)
			wasShown=true;
			
		if(visible)
		{
			grpLabel.setPreferredSize(new Dimension(VtEnv.maxLabelWidth_adv-30,grpLabel.getPreferredSize().height)); 
			grpLabel.setMinimumSize(new Dimension(VtEnv.maxLabelWidth_adv-30,grpLabel.getPreferredSize().height));
			filtLabel.setPreferredSize(new Dimension(VtEnv.maxLabelWidth_adv-30,grpLabel.getPreferredSize().height)); 
			filtLabel.setMinimumSize(new Dimension(VtEnv.maxLabelWidth_adv-30,grpLabel.getPreferredSize().height));
		}
		else
		{
			grpLabel.setPreferredSize(new Dimension(VtEnv.maxLabelWidth-30,grpLabel.getPreferredSize().height)); 
			grpLabel.setMinimumSize(new Dimension(VtEnv.maxLabelWidth-30,grpLabel.getPreferredSize().height));
			filtLabel.setPreferredSize(new Dimension(VtEnv.maxLabelWidth-30,grpLabel.getPreferredSize().height));
			filtLabel.setMinimumSize(new Dimension(VtEnv.maxLabelWidth-30,grpLabel.getPreferredSize().height));
		}

		
		if(visible || VtEnv.nm.equals(""))
		{
//				if(!text.isVisible())
//				Symb.setPreferredSize(new Dimension(Symb.getPreferredSize().width,Symb.getPreferredSize().height+87));
			
			addSymb.setVisible(true);
			text.setVisible(true);
			impExistings.setVisible(true);
			Symb.setVisible(true);
			fromBinBtn.setVisible(true);
			fromBin.setVisible(true);
			
			if(!(!isclicked && this.simbolTable.executablesLoded))
			{
				symbAdd.setVisible(true);
				impFile.setVisible(true);
			}
			

		}
		else
		{
				impExistings.setVisible(false);
				Symb.setVisible(false);
				symbAdd.setVisible(false);
				impFile.setVisible(false);
				addSymb.setVisible(false);
				fromBinBtn.setVisible(false);
				fromBin.setVisible(false);
				text.setVisible(false);
		}
		
		if(!simbolTable.simbolIsSet || wasShown)
		{
			wasShown=true;
			Symb.setVisible(true);
			symbAdd.setVisible(true);
			impFile.setVisible(true);
		}
		
		if(!VtEnv.nm.equals("") && !visible)
		{
			comp.setVisible(false);
			search.setVisible(false);	
		}
		if(VtEnv.nm.equals("") && !visible)
		{
			simbolTable.hideDefaultStandardGroups(true);
		}
		else
			simbolTable.hideDefaultStandardGroups(false);
		simbolTable.filter(null, 4);
		return this;
	}
	
	/*** 
	 * set simbolGroupTable
	 * @param table Table of type SymbolGroupTable
	 */
	public void setSTable(SymbolGroupTable table)
	{
		table.setView(SymbolGroupTable.GENERAL_VIEW);
		this.simbolTable = table;
		myMouseListener n = new myMouseListener();
		n = new myMouseListener();
		n.setToolTip(env);
		n.setText(Config.setToolTipString(mytext.getText("General_symbTable_title"), mytext.getText("General_symbTable")));
		
		MouseListener[] help = this.simbolTable.getMouseListeners();
		
		for(int i=1;i<help.length;i++)
		{
			if(help[i].getClass() == myMouseListener.class)
				this.simbolTable.removeMouseListener(help[i]);
		}
		this.simbolTable.addMouseListener(n);
		
		table.find(null);
		view.removeAll();
		
		view.add(table);
	}
}
