//                                               -*- C++ -*-
/**
 *  @file  WhiteNoise.hxx
 *  @brief A class which implements the WhiteNoise process
 *
 *  Copyright 2005-2015 Airbus-EDF-IMACS-Phimeca
 *
 *  This library is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  @author schueller
 *  @date   2012-07-16 10:12:54 +0200 (Mon, 16 Jul 2012)
 */
#ifndef OPENTURNS_WHITENOISE_HXX
#define OPENTURNS_WHITENOISE_HXX

#include "ProcessImplementation.hxx"
#include "Distribution.hxx"

BEGIN_NAMESPACE_OPENTURNS

/**
 * @class WhiteNoise
 *
 * An interface class for composite White Noise
 */
class OT_API WhiteNoise
  : public ProcessImplementation
{
  CLASSNAME;

public:

  /** Some typedefs to ease reading */

  /** Default constructor */
  WhiteNoise();

  /** Standard constructor */
  explicit WhiteNoise(const Distribution & distribution);

  /** Standard constructor */
  WhiteNoise(const Distribution & distribution,
             const Mesh & mesh);

  /** Virtual constructor */
  virtual WhiteNoise * clone() const;

  /** String converter */
  String __repr__() const;

  /** String converter  - pretty print */
  String __str__(const String & offset = "") const;

  /** Is the underlying stationary ? */
  Bool isStationary() const;

  /** Is the underlying a Normal process ? */
  Bool isNormal() const;

  /** Realization accessor */
  Field getRealization() const;

  /** Continuous realization accessor */
  NumericalMathFunction getContinuousRealization() const;

  /** Continuation of the last realization on a given number of steps */
  using ProcessImplementation::getFuture;
  TimeSeries getFuture(const UnsignedInteger stepNumber) const;

  /** Get the marginal process corresponding to the i-th marginal component */
  Implementation getMarginal(const UnsignedInteger i) const;

  /** Get the marginal process corresponding to indices components */
  Implementation getMarginal(const Indices & indices) const;

  /** Distribution accessor */
  Distribution getDistribution() const;

  /** Distribution accessor */
  void setDistribution(const Distribution & distribution);

  /** Method save() stores the object through the StorageManager */
  void save(Advocate & adv) const;

  /** Method load() reloads the object from the StorageManager */
  void load(Advocate & adv);

private:

  /** The distribution of the WhiteNoise */
  Distribution distribution_;

}; /* class WhiteNoise */
END_NAMESPACE_OPENTURNS

#endif /* OPENTURNS_WHITENOISE_HXX */
