#
# This script was written by BEKRAR Chaouki <bekrar@adconsulting.fr>
#
# Macromedia ColdFusion MX Path Disclosure Vulnerability
#
# http://www.k-otik.com/bugtraq/04.26.coldfusion.php
#

if (description)
{
 script_id(11558);
 script_tag(name:"cvss_base", value:"5.0");
 script_cve_id("CVE-2003-1469");
 script_bugtraq_id(7443);
 script_version ("$Revision: 8231 $");
 script_tag(name:"risk_factor", value:"Medium");

 script_name("Macromedia ColdFusion MX Path Disclosure Vulnerability");
 desc = "
A vulnerability has been reported for Macromedia ColdFusion MX that 
may reveal the physical path information to attackers.

When certain malformed URL requests (port 8500) are received by the server, an 
error message is returned containing the full path of the ColdFusion 
installation.

Solution : Change the 'Debugging Settings' on the Administrator console 
of the ColdFusion server. This can be achieved by disabling the 'Enable 
Robust Exception Information' option.

Risk factor : Low";

 script_description(desc);
 script_summary("Macromedia ColdFusion MX Path Disclosure Vulnerability");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2003 A.D.Consulting France");
 script_dependencie("http_version.nasl");
 script_require_ports("Services/www", 8500);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("misc_func.inc");

port = get_http_port(default:8500);
if (! port ) exit(0);
dir = make_list(cgi_dirs());
foreach d (dir)
  {
   url = string(d, "/CFIDE/probe.cfm");
   req = http_get(item:url, port:port);
   buf = http_keepalive_send_recv(port:port, data:req);
   if( buf == NULL ) break;
 
  if( "Error occured in" >< buf)
   {
    if(egrep(pattern:"[A-Z]:\\.*probe\.cfm", string:buf))
	{
    	security_warning(port:port);
    	exit(0);
	}
   }
  }

