###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_simple_machines_forum_mult_vuln_apr09.nasl 1556 2009-04-16 17:25:12Z apr $
#
# Simple Machines Forum Multiple Vulnerabilities.
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800558);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"7.5");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2008-6657", "CVE-2008-6658", "CVE-2008-6659");
  script_bugtraq_id(32119, 32139);
  script_name("Simple Machines Forum Multiple Vulnerabilities");
  desc = "

  Overview: This host has Simple Machines Forum installed which is prone
  to multiple vulnerabilities.

  Vulnerability Insight:
  Multiple flaws are due to
  - Lack of access control and validation check while performing certain
    HTTP requests which lets the attacker perform certain administrative
    commands.
  - Lack of validation check for the 'theme_dir' settings before being
    used which causes arbitrary code execution from local resources.
  - Crafted avatars are being allowed for code execution.

  Impact:
  Successful exploitation will let the attacker execute malicious arbitrary
  codes in the context of the SMF web application to gain administrative
  privileges, install malicious components into the forum context or can
  cause directory traversal attacks also.

  Impact Level: Application.

  Affected Software/OS:
  Simple Machines Forum version 1.0 to 1.0.14
  Simple Machines Forum version 1.1 to 1.1.6

  Fix: Update your Simple Machines Forum version to 1.1.7 or later
  http://www.simplemachines.org

  References:
  http://secunia.com/advisories/32516
  http://www.milw0rm.com/exploits/6993
  http://www.milw0rm.com/exploits/7011
  http://xforce.iss.net/xforce/xfdb/46343

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.9
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Simple Machines Forum");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Web application abuses");
  script_dependencies("gb_simple_machines_forum_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("version_func.inc");
include("http_func.inc");

httpPort = get_http_port(default:80);
if(!httpPort){
  httpPort = 80;
}

if(!get_port_state(httpPort)){
  exit(0);
}

ver = get_kb_item("www/" + httpPort + "/SMF");
ver = eregmatch(pattern:"^(.+) under (/.*)$", string:ver);
if(ver[1] == NULL){
  exit(0);
}

if((version_in_range(version:ver[1], test_version:"1.0", test_version2:"1.0.14"))||
   (version_in_range(version:ver[1], test_version:"1.1", test_version2:"1.1.6"))){
 security_hole(httpPort);
}
