###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_xemacs_detect_win.nasl 3824 2009-08-07 13:59:02Z aug $
#
# XEmacs Version Detection (Win)
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800925);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("XEmacs Version Detection (Win)");
  desc = "

  Overview: This script detects the installed version of XEmacs and sets
  the result in KB.

  Risk factor: None";

  script_description(desc);
  script_summary("Sets KB for the version of XEmacs");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";

if(!registry_key_exists(key:key)){
    exit(0);
}

foreach item (registry_enum_keys(key:key))
{
  xemacsName = registry_get_sz(key:key + item, item:"DisplayName");

  if("XEmacs" >< xemacsName)
  {
    xemacsVer = eregmatch(pattern:"XEmacs ([0-9.]+)", string:xemacsName);

    if(xemacsVer[1] != NULL){
      set_kb_item(name:"XEmacs/Win/Ver", value:xemacsVer[1]);
      security_note(data:"XEmacs version " + xemacsVer[1] + " was detected on the host");
    }
  }
}
