# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory MDVSA-2009:099 (openafs)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(63914);
 script_cve_id("CVE-2009-1250", "CVE-2009-1251");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Mandrake Security Advisory MDVSA-2009:099 (openafs)";
 script_name(name);

 desc = "The remote host is missing an update to openafs
announced via advisory MDVSA-2009:099.

Multiple vulnerabilities has been found and corrected in openafs:

The cache manager in the client in OpenAFS 1.0 through 1.4.8 and
1.5.0 through 1.5.58 on Linux allows remote attackers to cause a
denial of service (system crash) via an RX response with a large
error-code value that is interpreted as a pointer and dereferenced,
related to use of the ERR_PTR macro (CVE-2009-1250).

Heap-based buffer overflow in the cache manager in the client in
OpenAFS 1.0 through 1.4.8 and 1.5.0 through 1.5.58 on Unix platforms
allows remote attackers to cause a denial of service (system crash)
or possibly execute arbitrary code via an RX response containing
more data than specified in a request, related to use of XDR arrays
(CVE-2009-1251).

The updated packages have been patched to correct these issues.

Affected: 2008.1, 2009.0

Solution:
To upgrade automatically use MandrakeUpdate or urpmi.  The verification
of md5 checksums and GPG signatures is performed automatically for you.

https://secure1.securityspace.com/smysecure/catid.html?in=MDVSA-2009:099

Risk factor : High";

 script_description(desc);

 summary = "Mandrake Security Advisory MDVSA-2009:099 (openafs)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Mandrake Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"dkms-libafs", rpm:"dkms-libafs~1.4.6~2.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libopenafs1", rpm:"libopenafs1~1.4.6~2.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libopenafs-devel", rpm:"libopenafs-devel~1.4.6~2.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openafs", rpm:"openafs~1.4.6~2.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openafs-client", rpm:"openafs-client~1.4.6~2.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openafs-doc", rpm:"openafs-doc~1.4.6~2.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openafs-server", rpm:"openafs-server~1.4.6~2.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64openafs1", rpm:"lib64openafs1~1.4.6~2.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64openafs-devel", rpm:"lib64openafs-devel~1.4.6~2.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dkms-libafs", rpm:"dkms-libafs~1.4.7~5.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libopenafs1", rpm:"libopenafs1~1.4.7~5.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libopenafs-devel", rpm:"libopenafs-devel~1.4.7~5.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openafs", rpm:"openafs~1.4.7~5.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openafs-client", rpm:"openafs-client~1.4.7~5.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openafs-doc", rpm:"openafs-doc~1.4.7~5.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openafs-server", rpm:"openafs-server~1.4.7~5.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64openafs1", rpm:"lib64openafs1~1.4.7~5.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64openafs-devel", rpm:"lib64openafs-devel~1.4.7~5.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
