###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms10-008.nasl 7188 2010-02-10 11:55:09Z feb $
#
# Microsoft Data Analyzer ActiveX Control Vulnerability (978262)
#
# Authors:
# Veerendra GG <veerendragg@secpod.com>
#
# Copyright:
# Copyright (c) 2010 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900229);
  script_version("$Revision: 7541 $: 1.0");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2010-0252");
  script_name("Microsoft Data Analyzer ActiveX Control Vulnerability (978262)");
  desc = "
  Overview: This host has critical security update missing according to
  Microsoft Bulletin MS10-008.

  Vulnerability Insight:
  An unspecified error exists in the Microsoft Data Analyzer ActiveX control
  (max3activex.dll) when used with Internet Explorer. Attackers can execute
  arbitrary code by tricking a user into visiting a specially crafted web page.

  Impact:
  Successful exploitation will let the remote attackers execute arbitrary code
  and can compromise a vulnerable system.

  Impact Level: System.

  Affected Software/OS:
  Microsoft Windows 2K  Service Pack 4 and prior
  Microsoft Windows XP  Service Pack 3 and prior
  Microsoft Windows 2K3 Service Pack 2 and prior

  Fix:
  Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link,
  http://www.microsoft.com/technet/security/bulletin/ms10-008.mspx

  Workaround:
  Set the killbit for the following CLSIDs,
  {E0ECA9C3-D669-4EF4-8231-00724ED9288F}, {C05A1FBC-1413-11D1-B05F-00805F4945F6},
  {5D80A6D1-B500-47DA-82B8-EB9875F85B4D}, {0CCA191D-13A6-4E29-B746-314DEE697D83},
  {2d8ed06d-3c30-438b-96ae-4d110fdc1fb8}
  http://support.microsoft.com/kb/240797

  References:
  http://secunia.com/advisories/38503/
  http://www.vupen.com/english/advisories/2010/0341
  http://www.microsoft.com/technet/security/bulletin/ms10-008.mspx

  Risk factor: Critical";

  script_description(desc);
  script_summary("Check for the CLSID and Hotfix");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2010 SecPod");
  script_family("Windows : Microsoft Bulletins");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("secpod_activex.inc");

## Check For OS and Service Packs
if(hotfix_check_sp(win2k:5, xp:4, win2003:3) <= 0){
  exit(0);
}

## MS10-008 Hotfix check
if(hotfix_missing(name:"978262") == 0){
  exit(0);
}

## CLSID List
clsids = make_list(
  "{E0ECA9C3-D669-4EF4-8231-00724ED9288F}", "{C05A1FBC-1413-11D1-B05F-00805F4945F6}",
  "{5D80A6D1-B500-47DA-82B8-EB9875F85B4D}", "{0CCA191D-13A6-4E29-B746-314DEE697D83}",
  "{2d8ed06d-3c30-438b-96ae-4d110fdc1fb8}");

foreach clsid (clsids)
{
  ## Check if Kill-Bit is set for ActiveX control
  if(is_killbit_set(clsid:clsid) == 0)
  {
    security_hole(0);
    exit(0);
  }
}
