###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_pivot_detect.nasl 3042 2009-06-25 16:24:41Z jun $
#
# Pivot Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900578);
  script_version("Revision: 1.0 ");
  script_tag(name:"risk_factor", value:"None");
  script_name("Pivot Version Detection");
  desc = "

  Overview: This script detects the installed version of Pivot and
  sets the result in KB.

  Risk factor: None";

  script_description(desc);
  script_summary("Sets the KB for the version of Pivot");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

pivotPort = get_http_port(default:80);
if(!pivotPort){
  pivotPort = 80;
}
if(!get_port_state(pivotPort)){
  exit(0);
}

foreach dir (make_list("/pivot", "/", cgi_dirs()))
{
  sndReq = http_get(item:string(dir, "/pivot/index.php"), port:pivotPort);
  rcvRes = http_send_recv(port:pivotPort, data:sndReq);

  if("Pivot" >< rcvRes)
  {
    ver = eregmatch(pattern:"Pivot - ([0-9]\.[0-9.]+ ?(alpha|beta|RC)?" +
                            " ?[0-9]?[a-z]?)?", string:rcvRes);
    pivotVer = ereg_replace(pattern:" ", replace:".", string:ver[1]);
    if(pivotVer != NULL)
    {
      set_kb_item(name:"www/" + pivotPort + "/Pivot",
                value:pivotVer + " under " + dir);
      security_note(data:"Pivot version " + pivotVer + " running at " +
                         "location " + dir +  " was detected on the host");
    }
  }
}
