##############################################################################
#
#  Ultra Office ActiveX Control Multiple Vulnerabilities
#
#  Copyright: SecPod
#
#  Date Written: 2008/09/01
#
#  Revision: 1.1
#
#  Log: veerendragg
#  Issue #0153
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
 script_id(900208);
 script_cve_id("CVE-2008-3878");
 script_bugtraq_id(30861);
 script_copyright("Copyright (C) 2008 SecPod");
 script_version("Revision: 1.1 ");
 script_tag(name:"cvss_base", value:"6.8");
 script_tag(name:"risk_factor", value:"High");
 script_category(ACT_GATHER_INFO);
 script_family("Denial of Service");
 script_name("Ultra Office ActiveX Control Multiple Vulnerabilities");
 script_summary("Check for Vulnerable Version of Ultra Office");
 desc = "
 Overview : This host is running Ultra Office Control, which is prone to 
 multiple vulnerabilities.

 Vulnerability Insight :

        Error exists when handling parameters received by the HttpUpload()
        and Save() methods in OfficeCtrl.ocx file.

        Impact : Successful exploitation will allow execution of arbitrary
        code, stack-based buffer overflow, can overwrite arbitrary files
        on the vulnerable system by tricking a user into visiting a
        malicious website.

 Impact Level : Application

 Affected Software/OS :
        Ultra Office Control 2.x and prior versions on Windows (All). 

 Fix : No solution/patch is available as on 01st September, 2008. Information
 regarding this issue will be update once the solution details are available.
 For updates refer, http://www.ultrashareware.com/Ultra-Office-Control.htm 

 Quick Fix: Set a kill bit for the CLSID's
 {00989888-BB72-4E31-A7C6-5F819C24D2F7}

 Refer to following link to set kill-bit,
 http://support.microsoft.com/kb/240797

 References : http://secunia.com/advisories/31632/
 http://www.juniper.net/security/auto/vulnerabilities/vuln30861.html
 
 CVSS Score :
        CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P) 
        CVSS Temporal Score : 5.8
 Risk factor : High";

 script_description(desc);
 script_dependencies("secpod_reg_enum.nasl");
 script_require_keys("SMB/WindowsVersion");
 script_require_ports(139, 445);
 exit(0);
}


 include("smb_nt.inc");
 include("secpod_smb_func.inc");

 if(!get_kb_item("SMB/WindowsVersion")){
        exit(0);
 }

 name   =  kb_smb_name();
 login  =  kb_smb_login();
 pass   =  kb_smb_password();
 domain =  kb_smb_domain();
 port   =  kb_smb_transport();

 if(!port) port = 139;

 if(!get_port_state(port))exit(0);

 soc = open_sock_tcp(port);
 if(!soc){
        exit(0);
 }

 r = smb_session_request(soc:soc, remote:name);
 if(!r)
 {
        close(soc);
        exit(0);
 }

 prot = smb_neg_prot(soc:soc);
 if(!prot)
 {
        close(soc);
        exit(0);
 }

 r = smb_session_setup(soc:soc, login:login, password:pass,
                       domain:domain, prot:prot);
 if(!r)
 {
        close(soc);
        exit(0);
 }


 uid = session_extract_uid(reply:r);
 r = smb_tconx(soc:soc, name:name, uid:uid, share:"IPC$");

 tid = tconx_extract_tid(reply:r);
 if(!tid)
 {
        close(soc);
        exit(0);
 }

 r = smbntcreatex(soc:soc, uid:uid, tid:tid, name:"\winreg");
 if(!r)
 {
        close(soc);
        exit(0);
 }

 pipe = smbntcreatex_extract_pipe(reply:r);
 if(!pipe)
 {
        close(soc);
        exit(0);
 }

 r = pipe_accessible_registry(soc:soc, uid:uid, tid:tid, pipe:pipe);
 if(!r)
 {
        close(soc);
        exit(0);
 }

 handle = registry_open_hklm(soc:soc, uid:uid, tid:tid, pipe:pipe);
 if(!handle)
 {
        close(soc);
        exit(0);
 }

 key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
 key_h = registry_get_key(soc:soc, uid:uid, tid:tid, pipe:pipe,
                          key:key, reply:handle);
 if(!key_h)
 {
        close(soc);
        exit(0);
 }

 # To get application installed Path.
 enumKeys = registry_enum_key(soc:soc, uid:uid, tid:tid, pipe:pipe, reply:key_h);
 close(soc);

 foreach entry (enumKeys)
 {
        if("Ultra Office Control" >< entry)
        {
                appInsLoc = registry_get_sz(item:"InstallLocation", key:key + entry);
                if(!appInsLoc){
                        exit(0); 
                }
		break;
        }
 }

 # To Get File Version.
 share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:appInsLoc);
 file =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",
                      string:appInsLoc + "OfficeCtrl.ocx");

 soc = open_sock_tcp(port);
 if(!soc){
        exit(0);
 }

 r = smb_session_request(soc:soc, remote:name);
 if(!r)
 {
        close(soc);
        exit(0);
 }

 prot = smb_neg_prot(soc:soc);
 if(!prot)
 {
        close(soc);
        exit(0);
 }

 r = smb_session_setup(soc:soc, login:login, password:pass, domain:domain, prot:prot);
 if(!r)
 {
        close(soc);
        exit(0);
 }

 uid = session_extract_uid(reply:r);
 r = smb_tconx(soc:soc, name:name, uid:uid, share:share);

 tid = tconx_extract_tid(reply:r);
 if(!tid)
 {
        close(soc);
        exit(0);
 }

 fid = OpenAndX(socket:soc, uid:uid, tid:tid, file:file);
 if(!fid)
 {
        close(soc);
	exit(0);
 }

 fileVer = GetVersion(socket:soc, uid:uid, tid:tid, fid:fid);
 close(soc);

 if(!fileVer){
	exit(0);
 }

 # Grep for Version <= 2.0.2008.801  
 if(egrep(pattern:"^([01]\..*|2\.0\.[01]?[0-9]?[0-9]?[0-9]\..*|2\.0\.200[0-7]" +
		  "\..*|2\.0\.2008(\.[0-7]?[0-9]?[0-9]|\.80[01]))$", string:fileVer))
 {
        clsid = "{00989888-BB72-4E31-A7C6-5F819C24D2F7}";
        regKey = "SOFTWARE\Classes\CLSID\"+ clsid;
        if(registry_key_exists(key:regKey))
        {
                # Check for Kill-Bit set for ActiveX control
                activeKey = "SOFTWARE\Microsoft\Internet Explorer\"+
                            "ActiveX Compatibility\" + clsid;
                killBit = registry_get_dword(key:activeKey,
                          		     item:"Compatibility Flags");
                if(killBit && (int(killBit) == 1024)){
                        exit(0);
                }
                security_warning(0);        
        }
 }
