///////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2012-2013 DreamWorks Animation LLC
//
// All rights reserved. This software is distributed under the
// Mozilla Public License 2.0 ( http://www.mozilla.org/MPL/2.0/ )
//
// Redistributions of source code must retain the above copyright
// and license notice and the following restrictions and disclaimer.
//
// *     Neither the name of DreamWorks Animation nor the names of
// its contributors may be used to endorse or promote products derived
// from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// IN NO EVENT SHALL THE COPYRIGHT HOLDERS' AND CONTRIBUTORS' AGGREGATE
// LIABILITY FOR ALL CLAIMS REGARDLESS OF THEIR BASIS EXCEED US$250.00.
//
///////////////////////////////////////////////////////////////////////////

#ifndef OPENVDB_VIEWER_VIEWER_HAS_BEEN_INCLUDED
#define OPENVDB_VIEWER_VIEWER_HAS_BEEN_INCLUDED

#include <openvdb/openvdb.h>
#include <string>


namespace openvdb_viewer {

class Viewer;


/// @brief Initialize and return a viewer.
/// @param progName  the name of the calling program (for use in info displays)
/// @param verbose   if true, print diagnostic info to stdout
/// @note Currently, the viewer window is a singleton (but that might change
/// in the future), so although this function returns a new Viewer instance
/// on each call, all instances are associated with the same window.
/// Typically, then, this function should be called only once.
Viewer init(const std::string& progName, bool verbose = false);


/// Manager for a window that displays OpenVDB grids
class Viewer
{
public:
    /// Resize the window associated with this viewer and display the given grids.
    void view(const openvdb::GridCPtrVec&, int width = 900, int height = 800);

    /// When multiple grids are being viewed, advance to the next grid.
    void showNextGrid();
    /// When multiple grids are being viewed, return to the previous grid.
    void showPrevGrid();

private:
    friend Viewer init(const std::string&, bool);
    Viewer();
};

} // namespace openvdb_viewer

#endif // OPENVDB_VIEWER_VIEWER_HAS_BEEN_INCLUDED

// Copyright (c) 2012-2013 DreamWorks Animation LLC
// All rights reserved. This software is distributed under the
// Mozilla Public License 2.0 ( http://www.mozilla.org/MPL/2.0/ )
