-- This reservoir simulation deck is made available under the Open Database
-- License: http://opendatacommons.org/licenses/odbl/1.0/. Any rights in
-- individual contents of the database are licensed under the Database Contents
-- License: http://opendatacommons.org/licenses/dbcl/1.0/

-- Copyright (C) 2015 Statoil

--
--         Generated by : Prosper 9.3 - License#:4474 - Sep 17 2006 14:05:16
--         Generated on : 09 Jan 07  14:23
--           Input File : C:\GAP\B4DH.OUT
--          Output File : Z:\res\sim\ior\linn\gap\B4DH.Ecl
--
--
--                Fluid : Oil
--           PVT Method : Black Oil
--    Equation Of State : 
--            Separator : Single-Stage
--            Emulsions : No
--             Hydrates : Disable Warning
--      Water Viscosity : Use Default Correlation
--         Water Vapour : No Calculations
--      Viscosity Model : Newtonian Fluid
--
--            Flow Type : Tubing
--            Well Type : Producer
--
--      Artificial Lift : None
--            Lift Type : 
--
--           Predicting : Pressure and Temperature (offshore)
--    Temperature Model : Rough Approximation
--                Range : Full System
--
--           Completion : Cased Hole
--          Gravel Pack : No
--
--          Inflow Type : Single Branch
--           Gas Coning : No
--
--              Company : Statoil
--                Field : Norne
--             Location : Nordland II
--                 Well : B-4DH
--             Platform : Treasure Prospect
--              Analyst : lmarr+Arild Stokkenes
--                 Date : 01 Jun 06  10:13
--
--
--
--  Surface Equipment Correlation :  GRE (modified by PE)
--      Vertical Lift Correlation :  Petroleum Experts - (1.002) (1.000)
--
--                    Rate Method :  User Selected
--                      Rate Type :  Liquid Rates
--
--                     First Node :    1            Xmas Tree        394 (m)
--                      Last Node :   19               Tubing    3446.98 (m)
--
--         Sensitivity Variable 1 :  First Node Pressure
--         Sensitivity Variable 2 :  Gas Oil Ratio
--         Sensitivity Variable 3 :  Water Cut
--
--
-- PROSPER Lift Curves For ECLIPSE Simulator    (Liquid - Producer Well)  (Units System  - METRIC)


VFPPROD

-- Table   Datum Depth   Rate Type   WFR Type   GFR Type   TAB Type
-- -----   -----------   ---------   --------   --------   --------
--    40       2637.48       'LIQ'      'WCT'      'GOR'            /


-- Prosper files are corrected from RKB to MSL depth. lmarr

-- Table   Datum Depth   Rate Type   WFR Type   GFR Type   TAB Type
-- -----   -----------   ---------   --------   --------   --------
      40       2613.48       'LIQ'      'WCT'      'GOR'            /



-- 'LIQ' units - SM3/DAY
  200.0   500.0  1000.0  1500.0  2000.0 
 2500.0  3000.0  3500.0  4000.0  4500.0 
 5000.0  5500.0  6000.0  6500.0  7000.0 
 7500.0  8000.0 10000.0 14000.0 /

-- 'THP' units - BARSA
  21.01   41.01   61.01   81.01  101.01 
 121.01  141.01  161.01  181.01  201.01 /

-- 'WCT' units - FRACTION
      0     0.1     0.2     0.3     0.4 
    0.5     0.6     0.7     0.8       1 /

-- 'GOR' units - SM3/SM3
     90     100     150     300     500 
   1000    2000 /

-- 'ALQ' units - 
      0 /

 1  1  1  1  129.90  104.93  104.12  106.10  109.59 
             113.98  119.04  124.63  130.64  137.01 
             143.68  150.62  157.81  165.24  172.92 
             180.58  188.31  220.16  290.59 
/
 1  1  2  1  115.51   96.36   96.54   99.25  103.27 
             108.11  113.57  119.53  125.90  132.63 
             139.66  146.96  154.49  162.24  170.16 
             178.27  186.74  220.46  293.46 
/
 1  1  3  1   71.47   72.73   76.53   81.44   87.06 
              93.25   99.95  107.12  114.70  122.65 
             130.93  139.51  148.34  157.42  166.71 
             176.19  185.86  226.12  312.84 
/
 1  1  4  1   55.20   59.83   65.87   72.87   80.59 
              88.97   97.99  107.60  117.66  128.12 
             139.03  150.35  162.06  174.12  186.51 
             199.19  212.14  266.41  385.43 
/
 1  1  5  1   50.05   56.49   63.96   72.57   82.62 
              93.84  105.99  118.95  132.63  146.99 
             161.97  177.50  193.28  209.33  225.65 
             242.34  259.41  331.38  493.93 
/
 1  1  6  1   43.68   51.64   65.97   82.36  100.59 
             118.78  139.51  161.31  182.73  206.29 
             230.74  256.11  282.42  309.66  337.47 
             365.14  394.16  518.15  809.69 
/
 1  1  7  1   37.71   54.75   88.38  120.43  153.08 
             187.19  224.06  263.43  304.75  346.96 
             393.40  440.74  491.83  544.40  599.05 
             656.53  716.19  979.31 1612.31 
/
 1  2  1  1  143.14  114.08  112.27  113.73  116.79 
             120.83  125.58  130.87  136.61  142.72 
             149.14  155.83  162.83  170.00  177.25 
             184.62  192.11  223.18  292.39 
/
 1  2  2  1  129.06  104.69  103.90  106.12  109.76 
             114.28  119.47  125.18  131.31  137.80 
             144.59  151.66  158.96  166.48  174.18 
             182.23  190.25  222.99  294.60 
/
 1  2  3  1   77.20   77.45   80.58   85.20   90.60 
              96.62  103.18  110.20  117.61  125.40 
             133.50  141.88  150.52  159.39  168.46 
             177.72  187.16  226.50  311.28 
/
 1  2  4  1   56.16   60.72   66.82   73.71   81.22 
              89.35   98.04  107.21  116.85  126.97 
             137.52  148.48  159.81  171.47  183.44 
             195.69  208.19  260.55  375.38 
/
 1  2  5  1   50.95   57.27   64.51   72.74   82.31 
              92.96  104.48  116.77  129.75  143.37 
             157.59  172.19  187.03  202.23  217.81 
             233.70  249.91  318.14  471.46 
/
 1  2  6  1   44.32   52.11   65.00   79.71   96.10 
             114.00  132.89  152.30  173.44  195.34 
             218.07  241.60  265.96  289.44  316.32 
             342.48  367.59  479.00  745.67 
/
 1  2  7  1   39.87   52.86   83.44  112.53  142.92 
             173.73  206.82  243.18  278.62  318.49 
             360.08  402.61  448.35  495.70  544.07 
             595.24  648.32  880.99 1437.05 
/
 1  3  1  1  156.23  124.60  122.14  122.87  125.39 
             129.00  133.33  138.25  143.63  149.40 
             155.50  161.92  168.49  175.23  182.16 
             189.22  196.43  226.59  294.34 
/
 1  3  2  1  144.92  114.86  113.02  114.56  117.69 
             121.80  126.62  131.98  137.78  143.96 
             150.45  157.21  164.23  171.49  179.01 
             186.56  194.22  225.91  296.04 
/
 1  3  3  1   89.30   83.81   86.09   90.25   95.35 
             101.13  107.46  114.25  121.46  129.02 
             136.89  145.04  153.43  162.04  170.85 
             179.85  189.02  227.29  309.89 
/
 1  3  4  1   57.77   61.85   67.92   74.70   82.01 
              89.83   98.16  107.01  116.35  126.15 
             136.36  146.96  157.90  169.15  180.69 
             192.49  204.53  254.92  365.51 
/
 1  3  5  1   51.99   58.17   65.17   73.05   82.17 
              92.26  103.15  114.77  127.05  139.94 
             153.29  166.91  180.89  195.27  210.03 
             225.15  240.59  305.13  449.37 
/
 1  3  6  1   45.09   52.76   64.62   77.42   92.52 
             108.76  126.30  144.86  164.28  184.19 
             204.45  226.80  248.46  271.07  295.92 
             317.66  341.92  445.21  686.06 
/
 1  3  7  1   39.91   51.41   78.58  104.94  131.98 
             160.93  190.55  223.52  255.31  291.06 
             327.25  366.00  406.62  447.56  491.51 
             536.78  583.55  787.49 1273.31 
/
 1  4  1  1  170.82  137.50  133.56  133.79  135.67 
             138.70  142.52  146.96  151.89  157.21 
             162.84  168.73  174.87  181.23  187.78 
             194.49  201.37  230.45  296.31 
/
 1  4  2  1  159.77  126.61  124.19  124.89  127.38 
             130.94  135.28  140.19  145.56  151.33 
             157.42  163.81  170.53  177.37  184.37 
             191.52  198.81  229.31  297.68 
/
 1  4  3  1  107.90   92.47   93.56   97.07  101.73 
             107.16  113.17  119.67  126.57  133.83 
             141.40  149.23  157.31  165.60  174.09 
             182.77  191.62  228.62  308.76 
/
 1  4  4  1   60.50   63.85   69.52   76.10   83.18 
              90.76   98.84  107.41  116.45  125.91 
             135.75  145.96  156.48  167.30  178.39 
             189.72  201.28  249.60  355.63 
/
 1  4  5  1   53.26   59.24   66.01   73.60   82.27 
              91.80  102.07  113.02  124.58  136.62 
             148.98  161.75  174.94  188.51  202.45 
             216.72  231.32  292.36  427.70 
/
 1  4  6  1   46.05   53.68   64.63   76.26   89.40 
             103.99  119.85  136.72  154.44  172.95 
             192.10  211.89  232.37  253.35  274.63 
             296.28  318.40  412.36  629.01 
/
 1  4  7  1   40.47   50.56   74.15   97.73  122.50 
             147.60  174.99  203.78  232.75  264.52 
             297.08  330.33  365.85  402.60  441.29 
             481.06  521.97  699.19 1120.83 
/
 1  5  1  1  184.56  151.54  146.30  146.23  147.67 
             150.12  153.32  157.12  161.43  166.16 
             171.24  176.64  182.29  188.19  194.30 
             200.61  207.10  234.92  298.71 
/
 1  5  2  1  175.65  141.18  137.14  137.38  139.19 
             142.08  145.80  150.11  154.95  160.21 
             165.79  171.65  177.75  184.07  190.61 
             197.34  204.22  233.32  299.58 
/
 1  5  3  1  130.52  104.26  103.75  106.38  110.43 
             115.36  120.92  126.97  133.44  140.27 
             147.41  154.83  162.50  170.38  178.47 
             186.75  195.20  230.95  307.84 
/
 1  5  4  1   65.05   67.39   72.46   78.72   85.55 
              92.85  100.63  108.87  117.55  126.62 
             136.05  145.81  155.88  166.21  176.80 
             187.62  198.65  244.76  345.82 
/
 1  5  5  1   54.84   60.56   67.14   74.52   82.78 
              91.75  101.39  111.61  122.27  133.38 
             144.94  156.93  169.33  182.09  195.20 
             208.61  222.32  279.82  406.39 
/
 1  5  6  1   47.27   54.95   64.96   75.46   87.30 
             100.52  114.88  130.19  146.29  163.12 
             180.64  198.79  217.41  236.33  255.56 
             275.22  295.33  380.37  574.30 
/
 1  5  7  1   41.39   50.67   70.41   91.09  112.71 
             135.13  159.79  183.95  210.84  238.50 
             266.55  296.76  328.07  359.82  393.48 
             428.05  463.49  615.84  977.08 
/
 1  6  1  1  198.53  166.92  160.49  160.01  161.00 
             162.94  165.59  168.80  172.47  176.60 
             181.07  185.86  190.96  196.33  201.92 
             207.77  213.79  240.07  301.42 
/
 1  6  2  1  192.27  157.47  151.74  151.64  153.00 
             155.32  158.35  161.97  166.08  170.62 
             175.51  180.75  186.25  192.03  198.03 
             204.26  210.68  238.14  301.85 
/
 1  6  3  1  154.03  119.54  117.67  119.14  122.31 
             126.48  131.35  136.77  142.63  148.88 
             155.46  162.33  169.46  176.82  184.40 
             192.18  200.15  234.09  307.42 
/
 1  6  4  1   72.68   73.53   77.69   83.47   89.86 
              96.76  104.13  111.96  120.19  128.80 
             137.76  147.01  156.55  166.35  176.37 
             186.62  197.07  240.72  336.46 
/
 1  6  5  1   57.20   62.21   68.72   75.92   83.74 
              92.12  101.02  110.44  120.36  130.75 
             141.58  152.81  164.40  176.34  188.58 
             201.11  213.90  267.52  385.53 
/
 1  6  6  1   48.90   56.65   65.68   75.08   85.70 
              97.57  110.46  124.19  138.68  153.85 
             169.66  186.03  202.72  219.67  236.93 
             254.61  272.70  349.12  521.65 
/
 1  6  7  1   42.70   51.63   67.39   84.60  103.55 
             122.95  143.91  166.45  188.69  213.04 
             238.29  264.47  291.61  319.70  348.69 
             377.65  407.94  536.80  835.41 
/
 1  7  1  1  210.56  182.61  175.72  174.96  175.58 
             177.07  179.21  181.85  184.97  188.50 
             192.35  196.57  201.05  205.85  210.87 
             216.18  221.72  246.17  304.73 
/
 1  7  2  1  207.20  175.31  168.20  167.63  168.47 
             170.22  172.63  175.60  179.02  182.86 
             187.08  191.63  196.48  201.59  207.00 
             212.61  218.48  244.01  304.62 
/
 1  7  3  1  177.56  138.34  135.80  136.33  138.38 
             141.51  145.45  149.99  155.04  160.50 
             166.32  172.45  178.88  185.56  192.48 
             199.71  207.16  238.26  307.74 
/
 1  7  4  1   88.11   84.41   87.06   91.89   97.56 
             103.83  110.62  117.87  125.51  133.53 
             141.87  150.50  159.39  168.52  177.88 
             187.44  197.20  238.03  327.87 
/
 1  7  5  1   62.22   65.67   71.54   78.33   85.66 
              93.49  101.80  110.59  119.84  129.51 
             139.58  150.00  160.76  171.81  183.14 
             194.73  206.57  256.10  365.12 
/
 1  7  6  1   51.36   58.84   66.87   75.23   84.79 
              95.37  106.79  118.96  131.81  145.28 
             159.26  173.54  188.18  203.25  218.72 
             234.58  250.75  318.64  470.61 
/
 1  7  7  1   44.56   52.92   65.87   79.76   95.06 
             111.79  129.82  148.91  168.89  189.69 
             210.89  233.27  256.33  279.05  302.90 
             327.20  352.26  459.34  707.40 
/
 1  8  1  1  220.03  199.10  191.93  190.97  191.28 
             192.39  194.09  196.27  198.88  201.85 
             205.13  208.77  212.71  216.89  221.39 
             226.15  231.14  253.54  308.77 
/
 1  8  2  1  217.58  193.46  185.87  185.02  185.47 
             186.74  188.62  190.97  193.78  196.99 
             200.55  204.39  208.58  213.02  217.77 
             222.78  228.00  251.33  308.26 
/
 1  8  3  1  200.52  163.98  157.76  157.77  159.13 
             161.38  164.32  167.83  171.83  176.27 
             181.08  186.23  191.69  197.43  203.44 
             209.70  216.18  244.19  308.95 
/
 1  8  4  1  129.61  104.20  104.04  107.15  111.57 
             116.80  122.62  128.95  135.71  142.84 
             150.30  158.04  166.05  174.30  182.77 
             191.45  200.33  237.68  320.63 
/
 1  8  5  1   73.22   74.30   78.76   84.72   91.32 
              98.41  105.99  114.01  122.45  131.29 
             140.46  149.96  159.76  169.82  180.12 
             190.66  201.42  246.43  345.49 
/
 1  8  6  1   54.87   61.64   68.74   76.42   84.98 
              94.28  104.25  114.85  125.92  137.43 
             149.39  161.80  174.64  187.86  201.44 
             215.35  229.59  289.43  421.46 
/
 1  8  7  1   47.27   55.47   66.29   77.22   89.38 
             102.89  117.58  133.22  149.68  166.87 
             184.76  203.22  222.24  241.79  261.66 
             281.91  302.61  390.19  589.85 
/
 1  9  1  1  228.77  215.31  208.76  207.79  207.94 
             208.79  210.15  211.94  214.11  216.61 
             219.44  222.51  225.92  229.61  233.57 
             237.79  242.22  262.51  313.99 
/
 1  9  2  1  227.19  211.69  204.69  203.60  203.79 
             204.71  206.16  208.06  210.34  212.92 
             215.88  219.15  222.71  226.55  230.62 
             234.99  239.62  260.56  313.28 
/
 1  9  3  1  218.98  192.42  184.12  183.43  184.05 
             185.46  187.48  189.99  192.94  196.28 
             200.01  204.03  208.41  213.10  218.02 
             223.26  228.72  253.04  311.87 
/
 1  9  4  1  177.80  136.79  134.69  135.47  137.75 
             141.11  145.25  150.01  155.25  160.91 
             166.94  173.30  179.96  186.89  194.07 
             201.49  209.13  241.72  317.07 
/
 1  9  5  1  113.19   96.47   97.72  101.68  106.72 
             112.46  118.77  125.57  132.77  140.36 
             148.27  156.48  164.97  173.71  182.67 
             191.85  201.24  240.70  328.21 
/
 1  9  6  1   62.83   66.83   72.94   79.93   87.44 
              95.44  103.93  112.90  122.34  132.20 
             142.48  153.13  164.12  175.44  187.05 
             198.93  211.07  262.02  374.51 
/
 1  9  7  1   51.85   59.85   68.18   76.72   86.44 
              97.19  108.79  121.13  134.15  147.80 
             162.03  176.67  191.62  206.96  222.71 
             238.88  255.32  324.69  480.34 
/
 1 10  1  1  243.34  242.17  241.49  241.58  242.13 
             243.02  244.19  245.62  247.30  249.22 
             251.38  253.76  256.38  259.22  262.29 
             265.58  269.09  285.38  328.59 
/
 1 10  2  1  243.34  242.17  241.49  241.58  242.13 
             243.02  244.19  245.62  247.30  249.22 
             251.38  253.76  256.38  259.22  262.29 
             265.58  269.09  285.38  328.59 
/
 1 10  3  1  243.34  242.17  241.49  241.58  242.13 
             243.02  244.19  245.62  247.30  249.22 
             251.38  253.76  256.38  259.22  262.29 
             265.58  269.09  285.38  328.59 
/
 1 10  4  1  243.34  242.17  241.49  241.58  242.13 
             243.02  244.19  245.62  247.30  249.22 
             251.38  253.76  256.38  259.22  262.29 
             265.58  269.09  285.38  328.59 
/
 1 10  5  1  243.34  242.17  241.49  241.58  242.13 
             243.02  244.19  245.62  247.30  249.22 
             251.38  253.76  256.38  259.22  262.29 
             265.58  269.09  285.38  328.59 
/
 1 10  6  1  243.34  242.17  241.49  241.58  242.13 
             243.02  244.19  245.62  247.30  249.22 
             251.38  253.76  256.38  259.22  262.29 
             265.58  269.09  285.38  328.59 
/
 1 10  7  1  243.34  242.17  241.49  241.58  242.13 
             243.02  244.19  245.62  247.30  249.22 
             251.38  253.76  256.38  259.22  262.29 
             265.58  269.09  285.38  328.59 
/
 2  1  1  1  194.69  162.25  158.20  157.58  158.50 
             160.44  163.18  166.55  170.44  174.80 
             179.54  184.65  190.08  195.77  201.72 
             207.91  214.30  242.22  306.94 
/
 2  1  2  1  187.86  152.37  149.30  148.95  150.18 
             152.47  155.58  159.36  163.71  168.54 
             173.81  179.48  185.53  191.78  198.27 
             204.96  211.84  241.14  309.04 
/
 2  1  3  1  139.87  119.87  118.31  119.81  123.06 
             127.36  132.44  138.13  144.34  151.00 
             158.04  165.44  173.15  181.14  189.40 
             197.89  206.62  243.59  324.85 
/
 2  1  4  1   85.67   87.47   92.79   98.82  105.45 
             112.69  120.53  128.97  137.96  147.47 
             157.46  167.89  178.73  189.94  201.50 
             213.39  225.59  277.20  393.25 
/
 2  1  5  1   78.41   82.78   89.05   96.79  105.67 
             115.45  126.12  137.61  149.91  162.96 
             176.65  190.78  205.37  220.46  236.05 
             252.11  268.61  338.87  499.98 
/
 2  1  6  1   71.81   78.85   89.24  101.73  116.43 
             133.12  151.43  171.14  192.10  214.19 
             237.41  261.73  287.16  313.60  340.69 
             368.45  397.01  519.62  813.68 
/
 2  1  7  1   66.62   77.19  100.20  128.18  158.56 
             192.97  228.76  266.40  307.47  349.44 
             394.96  443.08  493.72  546.69  601.66 
             658.81  718.35  978.08 1606.61 
/
 2  2  1  1  200.93  170.94  166.26  165.53  166.31 
             168.08  170.58  173.68  177.29  181.35 
             185.80  190.61  195.73  201.14  206.81 
             212.71  218.87  245.88  309.23 
/
 2  2  2  1  196.27  161.08  157.43  156.98  158.05 
             160.14  163.01  166.52  170.58  175.11 
             180.09  185.38  190.99  196.89  203.04 
             209.43  216.03  244.42  310.73 
/
 2  2  3  1  153.75  127.56  125.58  126.47  129.17 
             133.04  137.74  143.10  148.98  155.32 
             162.07  169.17  176.58  184.29  192.26 
             200.48  208.93  244.89  324.00 
/
 2  2  4  1   89.36   90.12   94.68  100.35  106.71 
             113.69  121.28  129.44  138.13  147.32 
             156.96  167.02  177.46  188.26  199.39 
             210.83  222.57  272.20  383.63 
/
 2  2  5  1   79.27   83.62   89.80   97.31  105.79 
             115.09  125.20  136.10  147.75  160.07 
             172.86  186.14  199.93  214.22  228.97 
             244.16  259.78  326.16  477.70 
/
 2  2  6  1   72.64   79.53   89.16  100.66  114.17 
             129.52  146.38  164.53  183.85  204.26 
             225.69  248.12  271.55  295.87  320.75 
             346.25  372.47  484.99  751.10 
/
 2  2  7  1   67.11   76.91   96.87  121.71  149.72 
             179.01  212.01  247.01  282.54  321.44 
             362.39  405.48  450.71  498.04  547.10 
             597.74  650.06  878.37 1432.48 
/
 2  3  1  1  207.28  180.28  174.95  174.12  174.75 
             176.32  178.58  181.43  184.77  188.53 
             192.67  197.16  201.98  207.09  212.45 
             218.10  224.00  249.97  311.74 
/
 2  3  2  1  203.13  170.90  166.35  165.81  166.74 
             168.63  171.24  174.46  178.19  182.36 
             186.92  191.85  197.10  202.64  208.45 
             214.51  220.80  248.14  312.76 
/
 2  3  3  1  169.20  136.46  134.13  134.69  136.86 
             140.18  144.40  149.30  154.78  160.74 
             167.10  173.84  180.90  188.26  195.89 
             203.78  211.90  246.81  323.35 
/
 2  3  4  1   94.54   94.03   97.59  102.75  108.74 
             115.42  122.70  130.55  138.90  147.73 
             157.00  166.66  176.69  187.06  197.74 
             208.71  219.96  267.54  374.26 
/
 2  3  5  1   80.38   84.59   90.69   97.99  106.08 
             114.90  124.48  134.79  145.73  157.19 
             169.20  181.73  194.75  208.25  222.17 
             236.51  251.24  313.78  455.93 
/
 2  3  6  1   73.60   80.37   89.24   99.78  112.15 
             126.22  141.67  158.31  176.03  194.75 
             214.43  235.05  256.55  278.75  301.44 
             324.73  348.68  451.33  691.49 
/
 2  3  7  1   67.74   76.86   94.45  115.42  139.70 
             166.67  195.85  227.03  259.98  294.65 
             331.21  369.50  408.17  450.95  494.17 
             537.13  583.33  785.54 1269.52 
/
 2  4  1  1  214.72  190.04  184.26  183.35  183.83 
             185.22  187.27  189.85  192.90  196.37 
             200.21  204.40  208.87  213.67  218.74 
             224.11  229.72  254.58  314.37 
/
 2  4  2  1  211.07  181.59  176.15  175.46  176.20 
             177.85  180.18  183.09  186.48  190.29 
             194.51  199.05  203.96  209.14  214.58 
             220.30  226.25  252.42  315.07 
/
 2  4  3  1  185.27  146.74  144.10  144.37  146.18 
             149.05  152.75  157.11  162.07  167.53 
             173.43  179.71  186.34  193.28  200.51 
             207.99  215.73  249.23  322.99 
/
 2  4  4  1  101.81   99.79  102.00  106.46  111.97 
             118.24  125.14  132.60  140.57  149.00 
             157.84  167.07  176.64  186.53  196.73 
             207.20  217.95  263.35  365.20 
/
 2  4  5  1   82.53   85.84   91.80   98.90  106.59 
             114.94  123.95  133.56  143.77  154.55 
             165.87  177.68  189.95  202.66  215.76 
             229.25  243.09  301.80  434.70 
/
 2  4  6  1   74.77   81.33   89.50   99.14  110.43 
             123.27  137.36  152.52  168.67  185.74 
             203.69  222.50  242.08  262.15  282.72 
             303.86  325.61  418.65  634.65 
/
 2  4  7  1   68.55   77.11   92.74  110.87  131.78 
             155.25  180.76  208.12  237.15  267.73 
             299.79  333.37  368.50  405.19  443.20 
             482.35  522.69  697.95 1118.04 
/
 2  5  1  1  222.57  200.83  194.24  193.20  193.57 
             194.78  196.59  198.93  201.73  204.92 
             208.42  212.31  216.47  220.97  225.76 
             230.79  236.11  259.75  317.53 
/
 2  5  2  1  219.42  192.99  186.79  185.94  186.48 
             187.89  189.96  192.54  195.62  199.08 
             202.93  207.12  211.63  216.44  221.51 
             226.88  232.47  257.39  317.75 
/
 2  5  3  1  201.14  158.55  155.68  155.68  157.15 
             159.62  162.85  166.73  171.16  176.07 
             181.41  187.15  193.24  199.67  206.39 
             213.40  220.67  252.28  323.01 
/
 2  5  4  1  111.33  108.28  108.68  112.19  117.06 
             122.80  129.21  136.19  143.67  151.61 
             159.94  168.64  177.69  187.04  196.68 
             206.60  216.77  259.82  356.51 
/
 2  5  5  1   86.49   88.36   93.61  100.30  107.55 
             115.39  123.83  132.86  142.45  152.56 
             163.18  174.25  185.75  197.64  209.90 
             222.51  235.46  290.29  413.98 
/
 2  5  6  1   76.24   82.45   90.06   98.85  109.18 
             120.83  133.56  147.26  161.85  177.29 
             193.54  210.55  228.08  246.06  264.57 
             283.63  303.25  387.00  580.24 
/
 2  5  7  1   69.64   77.78   91.56  107.19  125.25 
             145.57  167.75  191.60  216.91  243.58 
             271.60  300.89  331.43  363.27  396.40 
             430.44  465.28  615.62  975.29 
/
 2  6  1  1  230.46  212.01  204.78  203.68  203.93 
             204.97  206.61  208.68  211.21  214.12 
             217.38  220.92  224.82  229.01  233.44 
             238.18  243.18  265.58  321.29 
/
 2  6  2  1  227.81  205.08  198.14  197.20  197.57 
             198.77  200.58  202.86  205.61  208.75 
             212.26  216.06  220.21  224.62  229.35 
             234.34  239.58  263.12  320.97 
/
 2  6  3  1  214.09  172.86  169.04  168.81  169.97 
             172.05  174.83  178.20  182.10  186.45 
             191.23  196.39  201.90  207.75  213.95 
             220.49  227.21  256.26  323.71 
/
 2  6  4  1  136.84  120.03  118.95  121.13  125.07 
             130.04  135.75  142.07  148.91  156.21 
             163.92  171.99  180.40  189.12  198.12 
             207.39  216.91  257.32  348.47 
/
 2  6  5  1   93.52   93.30   97.37  103.30  109.93 
             117.17  125.00  133.40  142.32  151.73 
             161.59  171.88  182.56  193.60  204.98 
             216.68  228.68  279.51  393.90 
/
 2  6  6  1   78.13   83.90   90.99   99.07  108.49 
             118.98  130.39  142.66  155.73  169.56 
             184.07  199.07  214.56  230.58  247.12 
             264.17  281.71  356.47  527.61 
/
 2  6  7  1   71.09   78.96   90.94  104.17  119.52 
             136.80  155.80  176.24  197.96  220.86 
             244.90  270.05  296.31  323.65  351.97 
             381.02  410.82  538.32  839.26 
/
 2  7  1  1  238.21  223.39  215.84  214.76  214.89 
             215.79  217.22  219.11  221.39  224.04 
             227.02  230.32  233.86  237.74  241.89 
             246.31  250.96  272.12  325.46 
/
 2  7  2  1  236.06  217.93  210.29  209.25  209.46 
             210.45  212.02  214.05  216.51  219.33 
             222.45  225.93  229.72  233.75  238.12 
             242.76  247.64  269.72  324.96 
/
 2  7  3  1  225.10  190.81  184.30  183.92  184.82 
             186.54  188.89  191.78  195.15  198.94 
             203.12  207.66  212.53  217.73  223.23 
             228.99  235.05  261.69  325.23 
/
 2  7  4  1  169.85  135.77  133.94  135.03  137.68 
             141.51  146.22  151.62  157.58  164.03 
             170.91  178.17  185.78  193.70  201.91 
             210.40  219.14  256.48  341.43 
/
 2  7  5  1  105.49  102.84  104.78  109.43  115.12 
             121.56  128.62  136.24  144.37  152.97 
             161.99  171.40  181.17  191.28  201.70 
             212.42  223.42  270.00  374.80 
/
 2  7  6  1   80.79   85.80   92.42  100.02  108.58 
             117.95  128.06  138.90  150.41  162.46 
             175.06  188.20  201.87  216.03  230.67 
             245.74  261.24  327.17  477.10 
/
 2  7  7  1   73.10   80.83   90.92  101.96  114.75 
             129.21  145.14  162.30  180.57  199.87 
             220.11  241.27  263.35  286.34  310.00 
             334.23  359.09  465.55  712.74 
/
 2  8  1  1  245.58  234.54  227.43  226.29  226.38 
             227.16  228.45  230.16  232.23  234.64 
             237.36  240.33  243.64  247.22  251.07 
             255.18  259.52  279.43  330.46 
/
 2  8  2  1  243.97  231.01  223.04  221.98  222.09 
             222.91  224.28  226.07  228.25  230.77 
             233.62  236.73  240.18  243.91  247.92 
             252.19  256.69  277.30  329.69 
/
 2  8  3  1  235.77  210.37  201.97  201.26  201.78 
             203.09  204.98  207.34  210.16  213.34 
             216.92  220.81  225.04  229.58  234.41 
             239.53  244.91  269.02  328.07 
/
 2  8  4  1  203.62  156.92  154.46  154.84  156.66 
             159.44  163.00  167.20  171.97  177.24 
             182.97  189.11  195.62  202.48  209.65 
             217.12  224.86  258.36  336.70 
/
 2  8  5  1  135.05  120.24  119.40  121.92  126.11 
             131.30  137.23  143.76  150.82  158.34 
             166.29  174.61  183.28  192.28  201.57 
             211.14  220.98  262.79  357.25 
/
 2  8  6  1   87.20   89.53   95.19  102.23  109.86 
             118.03  126.79  136.15  146.07  156.55 
             167.53  179.00  190.92  203.25  215.98 
             229.09  242.55  299.71  428.95 
/
 2  8  7  1   76.39   83.55   91.70  100.80  111.34 
             123.26  136.28  150.30  165.21  180.98 
             197.57  214.93  233.01  251.61  270.69 
             290.31  310.50  396.85  595.74 
/
 2  9  1  1  252.36  245.45  239.28  238.28  238.30 
             239.00  240.16  241.70  243.58  245.78 
             248.28  251.05  254.06  257.37  260.94 
             264.77  268.84  287.54  336.10 
/
 2  9  2  1  251.30  243.26  236.38  235.28  235.34 
             236.05  237.24  238.84  240.78  243.04 
             245.61  248.47  251.57  254.97  258.64 
             262.57  266.75  285.89  335.45 
/
 2  9  3  1  245.86  230.11  221.62  220.59  220.75 
             221.68  223.15  225.03  227.34  230.00 
             233.01  236.33  239.91  243.83  248.04 
             252.51  257.22  278.72  332.91 
/
 2  9  4  1  228.70  187.03  182.30  182.14  183.23 
             185.13  187.67  190.76  194.34  198.36 
             202.80  207.61  212.79  218.30  224.14 
             230.29  236.73  265.20  334.64 
/
 2  9  5  1  192.85  148.75  146.66  147.41  149.63 
             152.86  156.91  161.64  166.98  172.84 
             179.16  185.89  192.99  200.43  208.18 
             216.22  224.55  260.36  342.79 
/
 2  9  6  1  106.06  103.46  105.87  110.81  116.72 
             123.34  130.58  138.38  146.70  155.49 
             164.73  174.36  184.38  194.75  205.45 
             216.47  227.78  275.78  384.02 
/
 2  9  7  1   81.56   87.09   93.94  101.70  110.42 
             119.93  130.19  141.18  152.88  165.21 
             178.04  191.41  205.30  219.71  234.61 
             249.97  265.78  333.21  486.83 
/
 2 10  1  1  263.44  262.26  261.58  261.68  262.23 
             263.11  264.28  265.72  267.40  269.32 
             271.47  273.85  276.47  279.31  282.37 
             285.67  289.18  305.46  348.65 
/
 2 10  2  1  263.44  262.26  261.58  261.68  262.23 
             263.11  264.28  265.72  267.40  269.32 
             271.47  273.85  276.47  279.31  282.37 
             285.67  289.18  305.46  348.65 
/
 2 10  3  1  263.44  262.26  261.58  261.68  262.23 
             263.11  264.28  265.72  267.40  269.32 
             271.47  273.85  276.47  279.31  282.37 
             285.67  289.18  305.46  348.65 
/
 2 10  4  1  263.44  262.26  261.58  261.68  262.23 
             263.11  264.28  265.72  267.40  269.32 
             271.47  273.85  276.47  279.31  282.37 
             285.67  289.18  305.46  348.65 
/
 2 10  5  1  263.44  262.26  261.58  261.68  262.23 
             263.11  264.28  265.72  267.40  269.32 
             271.47  273.85  276.47  279.31  282.37 
             285.67  289.18  305.46  348.65 
/
 2 10  6  1  263.44  262.26  261.58  261.68  262.23 
             263.11  264.28  265.72  267.40  269.32 
             271.47  273.85  276.47  279.31  282.37 
             285.67  289.18  305.46  348.65 
/
 2 10  7  1  263.44  262.26  261.58  261.68  262.23 
             263.11  264.28  265.72  267.40  269.32 
             271.47  273.85  276.47  279.31  282.37 
             285.67  289.18  305.46  348.65 
/
 3  1  1  1  222.93  204.14  199.05  197.85  198.06 
             199.19  201.00  203.39  206.23  209.50 
             213.15  217.13  221.49  226.14  231.11 
             236.33  241.85  266.34  326.20 
/
 3  1  2  1  219.37  195.62  191.05  190.04  190.48 
             191.87  193.97  196.67  199.85  203.47 
             207.50  211.88  216.60  221.63  226.95 
             232.52  238.39  264.52  327.54 
/
 3  1  3  1  201.11  163.23  160.35  160.26  161.76 
             164.35  167.79  171.93  176.68  181.96 
             187.72  193.90  200.48  207.42  214.68 
             222.25  230.10  264.32  340.49 
/
 3  1  4  1  122.81  120.50  121.84  126.00  131.43 
             137.71  144.73  152.40  160.65  169.44 
             178.72  188.45  198.60  209.15  220.06 
             231.31  242.90  292.30  405.08 
/
 3  1  5  1  104.81  107.85  113.96  121.11  129.09 
             137.97  147.73  158.34  169.73  181.75 
             194.41  207.69  221.55  235.97  250.91 
             266.34  282.25  350.36  508.38 
/
 3  1  6  1   98.52  104.06  112.85  123.98  137.37 
             152.72  169.67  188.05  207.74  228.70 
             250.88  274.26  298.82  324.28  350.48 
             377.50  405.41  526.43  819.89 
/
 3  1  7  1   92.65  101.83  120.71  144.03  171.66 
             202.93  237.12  274.05  313.56  355.66 
             400.35  447.62  497.53  549.86  604.29 
             661.02  720.21  981.41 1611.50 
/
 3  2  1  1  228.17  211.27  205.79  204.59  204.79 
             205.86  207.59  209.81  212.52  215.64 
             219.10  222.96  227.13  231.58  236.35 
             241.37  246.69  270.42  328.96 
/
 3  2  2  1  224.90  203.36  198.17  197.12  197.49 
             198.78  200.74  203.25  206.27  209.68 
             213.52  217.67  222.16  226.96  232.04 
             237.40  243.08  268.33  329.81 
/
 3  2  3  1  208.22  170.75  167.70  167.47  168.78 
             171.14  174.32  178.16  182.59  187.54 
             192.95  198.79  205.01  211.59  218.51 
             225.73  233.25  266.19  340.15 
/
 3  2  4  1  128.59  125.68  125.78  129.25  134.18 
             140.06  146.70  154.00  161.87  170.26 
             179.14  188.46  198.18  208.28  218.73 
             229.51  240.61  287.97  396.04 
/
 3  2  5  1  107.20  109.05  114.89  121.80  129.42 
             137.87  147.11  157.10  167.77  179.12 
             191.09  203.65  216.76  230.39  244.51 
             259.09  274.10  338.34  486.74 
/
 3  2  6  1   99.39  104.73  112.97  123.22  135.57 
             149.69  165.26  182.16  200.29  219.59 
             239.99  261.48  284.03  307.34  331.34 
             356.09  381.66  492.21  757.32 
/
 3  2  7  1   93.25  101.89  118.84  139.57  164.19 
             192.13  222.78  255.86  291.23  328.84 
             368.70  410.87  455.30  501.93  550.38 
             600.71  653.06  883.99 1437.66 
/
 3  3  1  1  233.57  218.79  212.90  211.75  211.93 
             212.94  214.57  216.70  219.23  222.20 
             225.53  229.15  233.14  237.42  241.96 
             246.81  251.92  274.84  331.83 
/
 3  3  2  1  230.59  211.28  205.75  204.70  205.01 
             206.19  208.03  210.38  213.19  216.41 
             220.01  223.97  228.20  232.78  237.63 
             242.81  248.24  272.56  332.24 
/
 3  3  3  1  215.56  179.15  175.97  175.61  176.75 
             178.89  181.79  185.33  189.43  194.03 
             199.08  204.55  210.39  216.60  223.14 
             229.99  237.14  268.48  339.99 
/
 3  3  4  1  135.53  132.15  131.26  133.81  138.11 
             143.48  149.65  156.50  163.93  171.88 
             180.31  189.16  198.41  208.03  217.98 
             228.27  238.86  284.06  387.30 
/
 3  3  5  1  110.90  111.20  116.23  122.68  129.92 
             137.90  146.62  156.03  166.12  176.84 
             188.14  199.99  212.35  225.20  238.49 
             252.22  266.35  326.73  465.68 
/
 3  3  6  1  100.41  105.53  113.23  122.66  134.03 
             146.97  161.22  176.67  193.26  210.93 
             229.63  249.31  269.86  291.03  312.87 
             335.44  358.73  459.26  697.81 
/
 3  3  7  1   93.99  102.15  117.27  135.53  157.27 
             181.98  209.17  238.59  270.00  303.35 
             338.64  375.88  415.10  456.31  499.12 
             543.43  589.39  791.36 1274.85 
/
 3  4  1  1  240.12  226.71  220.48  219.36  219.52 
             220.46  221.99  224.01  226.44  229.19 
             232.35  235.83  239.57  243.66  248.03 
             252.67  257.55  279.66  335.15 
/
 3  4  2  1  237.42  220.24  213.90  212.84  213.08 
             214.14  215.84  218.04  220.68  223.71 
             227.06  230.79  234.80  239.16  243.81 
             248.71  253.92  277.26  335.17 
/
 3  4  3  1  224.05  188.50  185.26  184.81  185.78 
             187.69  190.32  193.55  197.31  201.55 
             206.23  211.31  216.77  222.57  228.71 
             235.24  242.07  271.46  340.30 
/
 3  4  4  1  150.82  140.07  138.66  140.24  143.72 
             148.41  154.00  160.30  167.20  174.62 
             182.52  190.85  199.57  208.65  218.06 
             227.79  237.82  280.74  378.97 
/
 3  4  5  1  116.44  114.92  118.64  124.37  131.06 
             138.53  146.71  155.57  165.05  175.13 
             185.75  196.87  208.47  220.52  232.99 
             245.85  259.09  315.62  445.24 
/
 3  4  6  1  101.60  106.48  113.66  122.35  132.81 
             144.62  157.59  171.65  186.73  202.80 
             219.81  237.69  256.20  275.31  295.09 
             315.53  336.64  427.52  641.17 
/
 3  4  7  1   94.91  102.66  116.01  131.95  150.95 
             172.56  196.42  222.26  249.92  279.25 
             310.20  342.81  377.09  413.04  450.51 
             489.19  529.18  703.84 1123.39 
/
 3  5  1  1  247.19  235.17  228.50  227.39  227.53 
             228.41  229.85  231.73  234.02  236.62 
             239.60  242.90  246.49  250.34  254.51 
             258.95  263.64  284.93  338.82 
/
 3  5  2  1  244.80  229.29  222.63  221.50  221.68 
             222.66  224.22  226.26  228.72  231.51 
             234.69  238.20  241.98  246.11  250.52 
             255.18  260.13  282.47  338.49 
/
 3  5  3  1  233.10  199.83  195.67  195.14  195.96 
             197.65  200.02  202.95  206.37  210.25 
             214.55  219.23  224.30  229.74  235.44 
             241.43  247.69  275.29  341.15 
/
 3  5  4  1  176.75  149.88  147.97  149.05  151.75 
             155.60  160.42  166.01  172.24  179.03 
             186.29  193.98  202.07  210.53  219.32 
             228.43  237.84  278.22  371.12 
/
 3  5  5  1  123.91  121.13  122.86  127.58  133.55 
             140.39  147.96  156.18  165.00  174.37 
             184.26  194.61  205.41  216.62  228.23 
             240.20  252.52  305.12  425.46 
/
 3  5  6  1  103.04  107.64  114.33  122.41  132.01 
             142.72  154.45  167.14  180.76  195.28 
             210.59  226.52  243.06  260.22  278.02 
             296.42  315.40  396.97  587.17 
/
 3  5  7  1   96.12  103.51  115.12  128.90  145.29 
             163.95  184.63  207.04  231.02  256.49 
             283.40  311.68  341.32  372.36  404.69 
             438.04  472.44  621.80  981.23 
/
 3  6  1  1  254.32  244.09  236.92  235.87  235.95 
             236.75  238.08  239.85  241.99  244.48 
             247.29  250.41  253.82  257.48  261.44 
             265.68  270.17  290.61  342.84 
/
 3  6  2  1  252.28  239.07  231.79  230.71  230.83 
             231.70  233.13  235.01  237.29  239.93 
             242.91  246.16  249.75  253.64  257.81 
             262.22  266.92  288.25  342.28 
/
 3  6  3  1  242.32  213.71  207.26  206.71  207.40 
             208.90  211.00  213.62  216.70  220.20 
             224.08  228.33  232.91  237.82  243.04 
             248.57  254.36  280.15  342.87 
/
 3  6  4  1  202.83  162.11  159.75  160.35  162.49 
             165.70  169.75  174.52  179.92  185.88 
             192.34  199.26  206.59  214.29  222.35 
             230.73  239.41  276.93  364.02 
/
 3  6  5  1  133.87  130.40  130.10  133.43  138.43 
             144.42  151.19  158.63  166.66  175.22 
             184.27  193.77  203.69  214.00  224.67 
             235.70  247.05  295.54  406.45 
/
 3  6  6  1  105.61  109.14  115.43  123.13  131.90 
             141.51  151.99  163.34  175.48  188.29 
             201.77  215.88  230.61  245.94  261.81 
             278.23  295.16  367.73  535.67 
/
 3  6  7  1   97.84  104.87  114.77  126.54  140.45 
             156.33  173.96  193.07  213.54  235.27 
             258.24  282.42  307.78  334.28  361.72 
             389.97  419.09  545.06  845.35 
/
 3  7  1  1  261.31  253.03  245.80  244.73  244.76 
             245.51  246.76  248.41  250.43  252.78 
             255.43  258.33  261.56  265.07  268.85 
             272.88  277.17  296.78  347.34 
/
 3  7  2  1  259.65  249.39  241.50  240.42  240.49 
             241.27  242.58  244.31  246.43  248.88 
             251.66  254.74  258.12  261.73  265.66 
             269.85  274.31  294.61  346.64 
/
 3  7  3  1  251.52  228.63  220.47  219.68  220.13 
             221.36  223.17  225.47  228.17  231.30 
             234.76  238.60  242.73  247.19  251.96 
             257.01  262.34  286.25  345.54 
/
 3  7  4  1  226.12  177.44  174.72  174.88  176.48 
             179.06  182.41  186.41  190.99  196.09 
             201.67  207.69  214.11  220.92  228.08 
             235.57  243.38  277.53  358.38 
/
 3  7  5  1  155.60  143.33  142.05  143.77  147.29 
             152.08  157.77  164.19  171.22  178.79 
             186.85  195.35  204.26  213.54  223.18 
             233.14  243.43  287.49  388.61 
/
 3  7  6  1  111.84  112.36  117.55  124.68  132.49 
             141.01  150.24  160.17  170.79  182.06 
             193.93  206.38  219.38  232.89  246.88 
             261.33  276.22  339.97  486.60 
/
 3  7  7  1  100.20  106.67  115.04  124.94  136.59 
             149.94  164.69  180.66  197.79  215.98 
             235.19  255.43  276.65  298.72  321.46 
             344.89  369.06  473.35  718.96 
/
 3  8  1  1  267.95  260.94  254.99  253.90  253.95 
             254.63  255.79  257.33  259.22  261.43 
             263.93  266.72  269.78  273.11  276.70 
             280.51  284.61  303.42  352.34 
/
 3  8  2  1  266.69  258.81  251.68  250.60  250.62 
             251.33  252.53  254.14  256.10  258.35 
             260.93  263.82  266.98  270.41  274.11 
             278.07  282.27  301.59  351.60 
/
 3  8  3  1  260.49  243.98  235.01  234.01  234.23 
             235.19  236.71  238.69  241.08  243.83 
             246.88  250.30  254.03  258.01  262.33 
             266.93  271.77  293.80  349.47 
/
 3  8  4  1  241.28  196.69  193.78  193.59  194.71 
             196.70  199.36  202.60  206.35  210.58 
             215.24  220.32  225.77  231.59  237.76 
             244.26  251.08  281.28  355.30 
/
 3  8  5  1  202.77  161.88  159.76  160.60  162.95 
             166.37  170.64  175.64  181.28  187.51 
             194.25  201.45  209.08  217.09  225.46 
             234.17  243.19  282.17  372.62 
/
 3  8  6  1  124.71  121.84  124.10  129.38  135.75 
             142.93  150.83  159.37  168.53  178.26 
             188.51  199.26  210.48  222.14  234.21 
             246.68  259.53  314.45  440.26 
/
 3  8  7  1  103.50  108.97  116.16  124.45  134.28 
             145.28  157.30  170.28  184.20  199.01 
             214.68  231.13  248.19  265.85  284.15 
             303.07  322.62  406.75  602.62 
/
 3  9  1  1  273.98  268.46  264.40  263.36  263.40 
             264.03  265.11  266.56  268.34  270.42 
             272.78  275.42  278.32  281.48  284.89 
             288.55  292.46  310.47  357.70 
/
 3  9  2  1  273.15  267.02  262.19  261.11  261.13 
             261.77  262.88  264.36  266.18  268.30 
             270.72  273.41  276.38  279.60  283.09 
             286.82  290.81  309.15  357.05 
/
 3  9  3  1  268.97  259.38  250.76  249.53  249.58 
             250.33  251.60  253.30  255.36  257.77 
             260.49  263.53  266.80  270.40  274.28 
             278.43  282.84  302.96  354.80 
/
 3  9  4  1  256.13  225.60  217.95  217.58  218.33 
             219.81  221.87  224.40  227.38  230.76 
             234.52  238.64  243.11  247.92  253.05 
             258.48  264.22  290.45  354.87 
/
 3  9  5  1  238.33  189.08  186.36  186.42  187.82 
             190.12  193.13  196.75  200.93  205.60 
             210.74  216.31  222.28  228.64  235.35 
             242.41  249.80  282.34  360.25 
/
 3  9  6  1  152.88  143.57  142.52  144.49  148.35 
             153.41  159.34  165.99  173.24  181.05 
             189.35  198.10  207.27  216.84  226.78 
             237.05  247.67  293.20  397.75 
/
 3  9  7  1  112.38  113.52  119.14  126.54  134.56 
             143.24  152.63  162.72  173.49  184.92 
             196.97  209.62  222.83  236.58  250.83 
             265.57  280.78  346.01  496.27 
/
 3 10  1  1  283.54  282.36  281.68  281.78  282.33 
             283.21  284.38  285.81  287.49  289.41 
             291.56  293.95  296.56  299.40  302.46 
             305.75  309.27  325.54  368.71 
/
 3 10  2  1  283.54  282.36  281.68  281.78  282.33 
             283.21  284.38  285.81  287.49  289.41 
             291.56  293.95  296.56  299.40  302.46 
             305.75  309.27  325.54  368.71 
/
 3 10  3  1  283.54  282.36  281.68  281.78  282.33 
             283.21  284.38  285.81  287.49  289.41 
             291.56  293.95  296.56  299.40  302.46 
             305.75  309.27  325.54  368.71 
/
 3 10  4  1  283.54  282.36  281.68  281.78  282.33 
             283.21  284.38  285.81  287.49  289.41 
             291.56  293.95  296.56  299.40  302.46 
             305.75  309.27  325.54  368.71 
/
 3 10  5  1  283.54  282.36  281.68  281.78  282.33 
             283.21  284.38  285.81  287.49  289.41 
             291.56  293.95  296.56  299.40  302.46 
             305.75  309.27  325.54  368.71 
/
 3 10  6  1  283.54  282.36  281.68  281.78  282.33 
             283.21  284.38  285.81  287.49  289.41 
             291.56  293.95  296.56  299.40  302.46 
             305.75  309.27  325.54  368.71 
/
 3 10  7  1  283.54  282.36  281.68  281.78  282.33 
             283.21  284.38  285.81  287.49  289.41 
             291.56  293.95  296.56  299.40  302.46 
             305.75  309.27  325.54  368.71 
/
 4  1  1  1  246.52  236.74  231.66  230.44  230.47 
             231.31  232.76  234.71  237.10  239.87 
             242.96  246.43  250.21  254.30  258.65 
             263.31  268.24  290.53  346.87 
/
 4  1  2  1  243.67  229.93  224.98  223.78  223.88 
             224.86  226.48  228.64  231.25  234.23 
             237.63  241.39  245.44  249.85  254.52 
             259.52  264.79  288.46  347.66 
/
 4  1  3  1  229.95  199.94  196.63  196.00  196.86 
             198.73  201.38  204.67  208.52  212.89 
             217.72  222.98  228.64  234.67  241.06 
             247.78  254.93  285.65  357.91 
/
 4  1  4  1  159.28  155.73  154.33  155.99  159.71 
             164.74  170.72  177.48  184.90  192.91 
             201.45  210.47  219.95  229.84  240.13 
             250.79  261.80  309.18  419.33 
/
 4  1  5  1  135.65  134.50  138.69  144.93  152.21 
             160.40  169.46  179.33  189.98  201.36 
             213.42  226.12  239.42  253.29  267.69 
             282.60  298.00  364.30  519.73 
/
 4  1  6  1  124.17  128.44  136.25  146.45  159.01 
             173.32  189.23  206.59  225.35  245.45 
             266.82  289.46  313.19  337.76  363.21 
             389.60  416.95  536.08  826.96 
/
 4  1  7  1  118.11  126.19  142.84  164.18  190.00 
             219.53  252.23  287.82  326.16  367.21 
             410.95  457.39  506.56  558.10  611.86 
             668.01  726.70  987.10 1617.84 
/
 4  2  1  1  251.36  242.82  237.34  236.23  236.29 
             237.14  238.56  240.45  242.76  245.40 
             248.42  251.78  255.44  259.37  263.62 
             268.14  272.93  294.67  349.78 
/
 4  2  2  1  248.69  236.45  231.11  229.95  230.08 
             231.03  232.59  234.62  237.13  240.04 
             243.30  246.87  250.81  255.05  259.56 
             264.38  269.46  292.46  350.20 
/
 4  2  3  1  236.03  206.91  203.55  202.88  203.66 
             205.40  207.87  210.96  214.59  218.70 
             223.27  228.25  233.62  239.36  245.48 
             251.97  258.69  288.00  358.02 
/
 4  2  4  1  168.45  161.55  159.81  161.10  164.16 
             168.58  174.03  180.29  187.22  194.76 
             202.82  211.36  220.35  229.75  239.53 
             249.69  260.18  305.42  410.63 
/
 4  2  5  1  140.00  137.68  140.53  146.15  152.93 
             160.64  169.18  178.51  188.57  199.32 
             210.70  222.68  235.23  248.29  261.87 
             275.92  290.43  352.84  498.58 
/
 4  2  6  1  125.05  129.17  136.49  145.96  157.56 
             170.71  185.30  201.26  218.49  236.93 
             256.56  277.32  298.99  321.43  344.71 
             368.86  393.87  502.53  765.11 
/
 4  2  7  1  118.80  126.42  141.29  160.24  183.18 
             209.50  238.69  270.47  304.67  341.24 
             380.17  421.50  465.16  511.02  558.75 
             608.46  660.28  889.84 1443.78 
/
 4  3  1  1  256.37  248.96  243.39  242.32  242.42 
             243.25  244.63  246.46  248.68  251.27 
             254.20  257.43  260.94  264.77  268.88 
             273.27  277.91  299.08  353.04 
/
 4  3  2  1  253.90  243.41  237.61  236.50  236.64 
             237.56  239.06  241.04  243.44  246.18 
             249.30  252.77  256.55  260.59  264.96 
             269.61  274.51  296.79  353.14 
/
 4  3  3  1  242.34  214.54  211.19  210.51  211.21 
             212.81  215.12  218.01  221.41  225.26 
             229.56  234.25  239.34  244.81  250.57 
             256.62  262.95  290.90  358.54 
/
 4  3  4  1  188.91  168.44  166.35  167.31  169.95 
             173.79  178.60  184.26  190.62  197.59 
             205.11  213.11  221.56  230.41  239.65 
             249.26  259.20  302.17  402.27 
/
 4  3  5  1  145.30  142.31  143.50  148.25  154.41 
             161.55  169.54  178.28  187.72  197.80 
             208.49  219.74  231.52  243.78  256.52 
             269.70  283.32  341.84  478.06 
/
 4  3  6  1  126.06  130.02  136.87  145.69  156.37 
             168.41  181.74  196.31  212.06  228.93 
             246.86  265.73  285.35  305.74  326.93 
             348.91  371.66  470.31  706.23 
/
 4  3  7  1  119.65  126.85  140.01  156.71  176.90 
             200.12  225.96  254.09  284.35  316.67 
             351.02  387.42  425.89  466.35  508.40 
             552.06  597.46  797.66 1280.75 
/
 4  4  1  1  262.56  255.75  249.81  248.83  248.93 
             249.75  251.08  252.85  254.99  257.49 
             260.26  263.38  266.80  270.51  274.49 
             278.71  283.22  303.81  356.56 
/
 4  4  2  1  260.29  250.85  244.58  243.50  243.63 
             244.50  245.93  247.82  250.11  252.76 
             255.71  259.02  262.64  266.56  270.73 
             275.20  279.95  301.50  356.39 
/
 4  4  3  1  249.84  223.82  219.62  218.94  219.57 
             221.05  223.19  225.87  229.04  232.64 
             236.65  241.03  245.76  250.82  256.21 
             261.90  267.88  294.45  359.56 
/
 4  4  4  1  211.38  176.64  174.22  174.85  177.09 
             180.46  184.74  189.78  195.50  201.82 
             208.69  216.07  223.89  232.13  240.76 
             249.76  259.09  299.61  394.50 
/
 4  4  5  1  151.87  148.38  148.13  151.73  157.08 
             163.54  170.86  178.95  187.71  197.09 
             207.04  217.52  228.50  239.94  251.82 
             264.12  276.82  331.43  458.23 
/
 4  4  6  1  127.45  131.03  137.43  145.72  155.50 
             166.46  178.58  191.82  206.12  221.44 
             237.64  254.58  272.27  290.71  309.89 
             329.77  350.35  439.37  650.36 
/
 4  4  7  1  120.72  127.52  139.04  153.62  171.23 
             191.48  214.08  238.73  265.27  293.56 
             323.59  355.37  388.89  424.15  460.83 
             498.82  538.22  711.03 1129.08 
/
 4  5  1  1  269.33  263.05  256.70  255.69  255.80 
             256.57  257.85  259.54  261.60  264.00 
             266.71  269.71  273.01  276.54  280.39 
             284.50  288.87  308.85  360.36 
/
 4  5  2  1  267.31  258.93  252.00  250.93  251.04 
             251.87  253.22  255.01  257.19  259.72 
             262.58  265.69  269.16  272.91  276.94 
             281.21  285.78  306.61  359.95 
/
 4  5  3  1  258.02  234.94  228.96  228.23  228.76 
             230.10  232.04  234.50  237.40  240.71 
             244.43  248.48  252.88  257.61  262.64 
             267.98  273.60  298.77  361.18 
/
 4  5  4  1  229.92  186.46  183.75  184.05  185.90 
             188.81  192.56  197.02  202.12  207.79 
             213.99  220.67  227.80  235.33  243.26 
             251.56  260.21  298.01  387.48 
/
 4  5  5  1  160.14  156.13  155.14  157.37  161.65 
             167.22  173.74  181.04  189.02  197.61 
             206.75  216.40  226.52  237.08  248.06 
             259.44  271.19  321.77  439.17 
/
 4  5  6  1  130.54  132.32  138.23  146.09  155.00 
             164.93  175.89  187.84  200.71  214.38 
             228.81  243.98  259.87  276.45  293.68 
             311.54  330.02  409.74  597.19 
/
 4  5  7  1  122.06  128.48  138.41  151.01  166.19 
             183.67  203.21  224.50  247.44  271.95 
             297.95  325.40  354.30  384.66  416.20 
             448.83  482.60  630.04  987.10 
/
 4  6  1  1  276.16  269.71  263.97  262.93  263.00 
             263.73  264.95  266.58  268.55  270.85 
             273.45  276.34  279.48  282.93  286.64 
             290.61  294.84  314.23  364.53 
/
 4  6  2  1  274.42  266.98  259.83  258.79  258.86 
             259.63  260.91  262.61  264.68  267.08 
             269.76  272.78  276.08  279.68  283.54 
             287.67  292.03  312.12  363.97 
/
 4  6  3  1  266.41  246.72  239.39  238.50  238.88 
             240.04  241.77  244.00  246.64  249.69 
             253.08  256.84  260.92  265.31  269.99 
             274.99  280.24  303.96  363.50 
/
 4  6  4  1  242.24  198.28  195.34  195.35  196.82 
             199.27  202.49  206.37  210.84  215.85 
             221.35  227.31  233.71  240.50  247.68 
             255.22  263.10  297.85  381.50 
/
 4  6  5  1  175.80  166.22  164.61  166.09  169.27 
             173.69  179.17  185.49  192.51  200.16 
             208.35  217.04  226.20  235.78  245.77 
             256.14  266.88  313.20  420.99 
/
 4  6  6  1  136.81  135.45  139.98  147.05  155.08 
             163.99  173.76  184.35  195.73  207.87 
             220.72  234.24  248.40  263.16  278.50 
             294.38  310.80  381.53  546.69 
/
 4  6  7  1  123.81  129.65  138.28  149.05  161.95 
             176.87  193.48  211.59  231.10  251.95 
             274.09  297.50  322.13  347.86  374.49 
             402.03  430.55  554.55  852.11 
/
 4  7  1  1  282.85  276.53  271.55  270.48  270.52 
             271.21  272.37  273.91  275.80  278.00 
             280.50  283.28  286.33  289.65  293.23 
             297.04  301.13  319.93  368.87 
/
 4  7  2  1  281.44  274.28  268.17  267.04  267.08 
             267.79  268.99  270.59  272.55  274.83 
             277.42  280.26  283.42  286.85  290.55 
             294.51  298.72  318.07  368.34 
/
 4  7  3  1  274.81  259.85  250.72  249.74  249.97 
             250.95  252.49  254.50  256.86  259.64 
             262.76  266.22  269.94  274.01  278.37 
             282.98  287.90  310.15  366.84 
/
 4  7  4  1  254.94  212.56  209.52  209.28  210.40 
             212.41  215.12  218.43  222.27  226.61 
             231.40  236.62  242.25  248.27  254.65 
             261.38  268.45  299.89  377.19 
/
 4  7  5  1  218.84  179.62  177.41  178.24  180.65 
             184.16  188.56  193.73  199.58  206.05 
             213.08  220.63  228.64  237.09  245.94 
             255.18  264.77  306.44  404.16 
/
 4  7  6  1  146.27  143.09  144.76  150.17  156.90 
             164.57  173.07  182.33  192.30  202.94 
             214.20  226.05  238.46  251.40  264.83 
             278.75  293.13  355.00  498.78 
/
 4  7  7  1  126.19  131.28  138.79  147.88  158.84 
             171.39  185.24  200.33  216.58  233.95 
             252.41  271.93  292.38  313.60  335.59 
             358.38  381.98  484.32  727.12 
/
 4  8  1  1  289.17  283.40  279.35  278.29  278.32 
             278.96  280.05  281.55  283.36  285.47 
             287.86  290.53  293.46  296.66  300.10 
             303.77  307.72  325.95  373.59 
/
 4  8  2  1  288.10  281.66  276.79  275.65  275.66 
             276.31  277.44  278.95  280.80  282.97 
             285.42  288.16  291.17  294.45  297.99 
             301.75  305.79  324.43  373.05 
/
 4  8  3  1  283.00  272.63  263.12  261.99  262.05 
             262.86  264.21  266.00  268.13  270.63 
             273.47  276.62  280.08  283.82  287.80 
             292.10  296.66  317.44  370.98 
/
 4  8  4  1  267.74  230.06  226.88  226.49  227.31 
             228.93  231.17  233.93  237.17  240.84 
             244.93  249.41  254.26  259.47  265.03 
             270.92  277.13  305.04  375.17 
/
 4  8  5  1  246.93  197.83  195.11  195.34  197.01 
             199.65  203.08  207.18  211.89  217.14 
             222.91  229.15  235.84  242.94  250.44 
             258.32  266.56  302.81  389.48 
/
 4  8  6  1  160.78  156.64  155.98  158.66  163.42 
             169.41  176.31  183.98  192.33  201.29 
             210.83  220.90  231.46  242.48  253.95 
             265.83  278.12  331.04  453.86 
/
 4  8  7  1  131.18  133.67  140.14  148.12  157.39 
             167.63  178.87  191.10  204.28  218.36 
             233.21  248.80  265.12  282.15  299.86 
             318.25  337.27  419.52  612.53 
/
 4  9  1  1  294.86  290.15  287.18  286.28  286.31 
             286.92  287.97  289.37  291.10  293.11 
             295.40  297.97  300.81  303.88  307.20 
             310.77  314.58  332.20  378.62 
/
 4  9  2  1  294.16  288.97  285.53  284.52  284.50 
             285.11  286.17  287.59  289.35  291.40 
             293.73  296.34  299.20  302.33  305.71 
             309.34  313.22  331.14  378.15 
/
 4  9  3  1  290.70  282.95  276.28  275.09  275.04 
             275.71  276.88  278.46  280.39  282.66 
             285.23  288.10  291.25  294.64  298.34 
             302.30  306.52  325.89  376.31 
/
 4  9  4  1  280.32  258.12  248.15  247.73  248.36 
             249.66  251.49  253.77  256.45  259.51 
             262.93  266.69  270.80  275.24  279.99 
             285.04  290.39  314.64  375.97 
/
 4  9  5  1  266.21  222.96  220.04  219.81  220.84 
             222.69  225.20  228.27  231.84  235.88 
             240.36  245.25  250.55  256.22  262.25 
             268.63  275.36  305.44  379.41 
/
 4  9  6  1  215.54  179.65  177.66  178.71  181.31 
             185.03  189.64  195.04  201.15  207.90 
             215.23  223.07  231.39  240.16  249.34 
             258.92  268.86  312.05  413.24 
/
 4  9  7  1  146.76  143.56  146.00  151.83  158.83 
             166.71  175.39  184.82  194.95  205.77 
             217.22  229.28  241.92  255.11  268.82 
             283.03  297.73  361.09  508.45 
/
 4 10  1  1  303.65  302.46  301.78  301.87  302.42 
             303.31  304.48  305.91  307.59  309.50 
             311.66  314.04  316.65  319.49  322.55 
             325.84  329.35  345.62  388.77 
/
 4 10  2  1  303.65  302.46  301.78  301.87  302.42 
             303.31  304.48  305.91  307.59  309.50 
             311.66  314.04  316.65  319.49  322.55 
             325.84  329.35  345.62  388.77 
/
 4 10  3  1  303.65  302.46  301.78  301.87  302.42 
             303.31  304.48  305.91  307.59  309.50 
             311.66  314.04  316.65  319.49  322.55 
             325.84  329.35  345.62  388.77 
/
 4 10  4  1  303.65  302.46  301.78  301.87  302.42 
             303.31  304.48  305.91  307.59  309.50 
             311.66  314.04  316.65  319.49  322.55 
             325.84  329.35  345.62  388.77 
/
 4 10  5  1  303.65  302.46  301.78  301.87  302.42 
             303.31  304.48  305.91  307.59  309.50 
             311.66  314.04  316.65  319.49  322.55 
             325.84  329.35  345.62  388.77 
/
 4 10  6  1  303.65  302.46  301.78  301.87  302.42 
             303.31  304.48  305.91  307.59  309.50 
             311.66  314.04  316.65  319.49  322.55 
             325.84  329.35  345.62  388.77 
/
 4 10  7  1  303.65  302.46  301.78  301.87  302.42 
             303.31  304.48  305.91  307.59  309.50 
             311.66  314.04  316.65  319.49  322.55 
             325.84  329.35  345.62  388.77 
/
 5  1  1  1  268.13  264.20  259.18  258.17  258.24 
             259.01  260.32  262.08  264.24  266.75 
             269.60  272.77  276.19  279.96  284.00 
             288.32  292.91  313.88  367.83 
/
 5  1  2  1  265.61  258.82  253.80  252.69  252.76 
             253.61  255.03  256.93  259.21  261.91 
             264.96  268.34  272.04  276.01  280.31 
             284.90  289.75  311.89  368.30 
/
 5  1  3  1  254.43  231.77  228.51  227.71  228.28 
             229.79  232.01  234.82  238.16  241.97 
             246.22  250.90  255.96  261.34  267.06 
             273.09  279.42  307.44  376.63 
/
 5  1  4  1  205.50  188.60  186.36  187.17  189.73 
             193.54  198.35  204.01  210.45  217.57 
             225.28  233.54  242.30  251.51  261.16 
             271.21  281.66  327.08  434.68 
/
 5  1  5  1  167.54  164.42  164.98  169.54  175.84 
             183.28  191.68  200.95  211.02  221.84 
             233.35  245.51  258.28  271.63  285.54 
             299.96  314.91  379.59  532.80 
/
 5  1  6  1  149.11  152.45  159.42  169.11  180.86 
             194.32  209.38  225.95  243.96  263.35 
             284.07  306.00  328.89  352.75  377.62 
             403.48  430.34  547.87  836.53 
/
 5  1  7  1  143.20  150.21  165.04  184.89  209.22 
             237.35  268.80  303.26  340.59  380.74 
             423.66  469.38  517.86  568.67  621.80 
             677.42  735.64  994.34 1623.01 
/
 5  2  1  1  272.81  268.99  264.26  263.33  263.43 
             264.23  265.53  267.26  269.37  271.83 
             274.62  277.67  281.05  284.73  288.68 
             292.91  297.40  317.94  370.89 
/
 5  2  2  1  270.42  264.44  259.21  258.18  258.29 
             259.12  260.51  262.36  264.61  267.23 
             270.19  273.47  277.02  280.92  285.10 
             289.56  294.28  315.88  371.15 
/
 5  2  3  1  259.97  238.18  234.94  234.16  234.71 
             236.14  238.25  240.92  244.09  247.69 
             251.71  256.12  260.90  266.01  271.45 
             277.21  283.26  310.19  377.16 
/
 5  2  4  1  228.43  194.56  192.08  192.65  194.90 
             198.35  202.74  207.95  213.88  220.45 
             227.62  235.32  243.53  252.19  261.29 
             270.80  280.69  323.85  426.45 
/
 5  2  5  1  172.31  168.81  168.41  171.99  177.59 
             184.42  192.22  200.88  210.31  220.45 
             231.25  242.66  254.66  267.20  280.26 
             293.82  307.85  368.59  512.03 
/
 5  2  6  1  150.05  153.21  159.75  168.83  179.66 
             192.02  205.84  221.03  237.54  255.31 
             274.29  294.25  315.13  336.93  359.65 
             383.29  407.82  514.88  775.32 
/
 5  2  7  1  143.98  150.55  163.75  181.35  202.94 
             227.94  255.93  286.61  319.82  355.50 
             393.65  434.26  477.26  522.38  569.46 
             618.60  669.92  897.84 1449.39 
/
 5  3  1  1  277.65  273.99  269.66  268.77  268.91 
             269.70  270.98  272.70  274.73  277.13 
             279.85  282.87  286.17  289.75  293.61 
             297.74  302.12  322.25  374.24 
/
 5  3  2  1  275.41  270.52  264.93  264.00  264.14 
             264.97  266.33  268.13  270.31  272.85 
             275.72  278.86  282.34  286.12  290.18 
             294.51  299.10  320.15  374.24 
/
 5  3  3  1  265.76  245.96  241.99  241.21  241.71 
             243.05  245.02  247.52  250.48  253.88 
             257.67  261.84  266.35  271.21  276.38 
             281.86  287.64  313.46  378.20 
/
 5  3  4  1  237.77  201.48  198.78  199.11  201.07 
             204.14  208.12  212.87  218.29  224.34 
             230.95  238.08  245.70  253.78  262.27 
             271.18  280.47  321.22  418.73 
/
 5  3  5  1  178.03  174.13  173.22  175.70  180.41 
             186.51  193.62  201.60  210.33  219.75 
             229.81  240.44  251.63  263.34  275.54 
             288.22  301.34  358.13  491.92 
/
 5  3  6  1  151.98  154.10  160.24  168.77  178.72 
             190.03  202.64  216.51  231.58  247.78 
             264.95  283.00  301.95  321.77  342.44 
             363.93  386.22  483.24  716.95 
/
 5  3  7  1  144.90  151.08  162.72  178.20  197.18 
             219.20  243.91  270.97  300.26  331.72 
             365.30  401.01  438.85  478.58  519.94 
             563.02  607.90  806.44 1286.90 
/
 5  4  1  1  283.69  279.62  275.43  274.59  274.73 
             275.52  276.78  278.43  280.44  282.77 
             285.42  288.35  291.57  295.03  298.80 
             302.83  307.12  326.79  377.81 
/
 5  4  2  1  281.61  276.61  271.15  270.21  270.35 
             271.16  272.47  274.21  276.32  278.77 
             281.55  284.62  287.99  291.65  295.55 
             299.76  304.24  324.72  377.59 
/
 5  4  3  1  272.74  254.97  249.76  248.93  249.34 
             250.56  252.40  254.72  257.50  260.70 
             264.25  268.19  272.45  277.04  281.94 
             287.15  292.64  317.32  379.72 
/
 5  4  4  1  247.26  209.57  206.67  206.78  208.43 
             211.15  214.71  218.99  223.91  229.41 
             235.46  242.00  249.02  256.47  264.34 
             272.62  281.27  319.40  411.54 
/
 5  4  5  1  184.97  180.66  179.28  181.13  184.84 
             190.02  196.31  203.49  211.44  220.07 
             229.32  239.13  249.47  260.31  271.61 
             283.37  295.55  348.33  472.57 
/
 5  4  6  1  155.85  155.46  161.02  168.98  178.09 
             188.38  199.85  212.43  226.04  240.57 
             256.01  272.31  289.43  307.34  326.02 
             345.43  365.56  452.95  661.65 
/
 5  4  7  1  146.02  151.77  161.98  175.49  192.00 
             211.19  232.76  256.42  282.00  309.46 
             338.75  369.84  402.74  437.32  473.29 
             510.66  549.53  720.63 1135.97 
/
 5  5  1  1  290.35  285.67  281.64  280.76  280.88 
             281.64  282.85  284.46  286.40  288.67 
             291.24  294.09  297.22  300.62  304.28 
             308.20  312.37  331.60  381.61 
/
 5  5  2  1  288.51  282.99  277.78  276.84  276.96 
             277.73  278.99  280.66  282.69  285.05 
             287.73  290.70  293.96  297.50  301.31 
             305.36  309.71  329.63  381.22 
/
 5  5  3  1  280.52  264.82  258.26  257.36  257.68 
             258.78  260.46  262.63  265.22  268.19 
             271.53  275.21  279.24  283.54  288.19 
             293.10  298.32  321.86  381.79 
/
 5  5  4  1  257.73  219.04  216.00  215.91  217.28 
             219.64  222.79  226.60  231.01  235.97 
             241.43  247.38  253.77  260.59  267.81 
             275.42  283.40  318.78  405.19 
/
 5  5  5  1  195.81  188.79  186.94  188.27  191.33 
             195.64  200.96  207.18  214.21  221.93 
             230.26  239.16  248.57  258.46  268.82 
             279.60  290.79  339.42  454.08 
/
 5  5  6  1  161.31  158.69  162.60  169.57  177.81 
             187.10  197.41  208.67  220.85  233.88 
             247.74  262.37  277.74  293.81  310.55 
             327.94  345.96  424.07  609.18 
/
 5  5  7  1  147.39  152.62  161.57  173.24  187.45 
             204.03  222.63  243.01  265.11  288.82 
             314.07  340.84  369.13  398.80  429.63 
             461.65  494.90  640.61  995.12 
/
 5  6  1  1  297.08  291.95  288.16  287.23  287.33 
             288.04  289.21  290.76  292.65  294.84 
             297.33  300.10  303.14  306.44  310.01 
             313.83  317.90  336.66  385.74 
/
 5  6  2  1  295.49  289.63  284.83  283.83  283.91 
             284.64  285.85  287.46  289.41  291.68 
             294.26  297.12  300.27  303.69  307.35 
             311.30  315.50  334.84  385.22 
/
 5  6  3  1  288.52  275.96  267.53  266.55  266.77 
             267.74  269.27  271.26  273.67  276.45 
             279.53  282.99  286.76  290.84  295.17 
             299.83  304.74  327.15  384.57 
/
 5  6  4  1  268.74  230.21  227.10  226.83  227.93 
             229.96  232.70  236.05  239.96  244.37 
             249.25  254.59  260.34  266.50  273.05 
             279.97  287.25  319.74  400.27 
/
 5  6  5  1  237.19  199.09  196.79  197.60  200.04 
             203.63  208.14  213.45  219.48  226.17 
             233.46  241.30  249.65  258.48  267.77 
             277.48  287.60  331.80  436.62 
/
 5  6  6  1  168.65  165.20  166.35  171.69  178.69 
             186.83  195.93  205.91  216.71  228.28 
             240.57  253.55  267.18  281.43  296.27 
             311.68  327.63  396.72  559.45 
/
 5  6  7  1  149.12  153.77  161.56  171.54  183.71 
             197.88  213.67  230.96  249.70  269.83 
             291.29  314.06  338.02  362.99  388.94 
             415.92  443.92  566.22  861.28 
/
 5  7  1  1  303.65  298.38  294.92  294.00  294.04 
             294.71  295.82  297.30  299.16  301.28 
             303.69  306.37  309.32  312.53  315.99 
             319.71  323.67  341.98  389.95 
/
 5  7  2  1  302.37  296.45  292.23  291.17  291.21 
             291.88  293.03  294.56  296.43  298.61 
             301.09  303.85  306.89  310.18  313.74 
             317.56  321.64  340.40  389.40 
/
 5  7  3  1  296.57  286.91  277.59  276.52  276.64 
             277.48  278.86  280.68  282.90  285.47 
             288.37  291.59  295.07  298.88  302.98 
             307.36  311.98  333.24  388.04 
/
 5  7  4  1  280.12  243.41  240.35  239.95  240.82 
             242.53  244.89  247.80  251.21  255.09 
             259.39  264.11  269.22  274.72  280.58 
             286.79  293.35  322.81  396.91 
/
 5  7  5  1  258.17  212.35  209.66  209.99  211.83 
             214.71  218.42  222.84  227.91  233.58 
             239.80  246.53  253.75  261.42  269.52 
             278.04  286.95  326.25  420.68 
/
 5  7  6  1  178.93  174.76  174.30  177.35  182.66 
             189.30  196.95  205.47  214.75  224.74 
             235.38  246.64  258.48  270.87  283.78 
             297.19  311.08  371.24  512.46 
/
 5  7  7  1  152.62  155.44  162.24  170.76  181.24 
             193.08  206.20  220.56  236.12  252.85 
             270.70  289.50  309.18  329.74  351.16 
             373.45  396.57  497.25  737.54 
/
 5  8  1  1  309.83  304.83  301.84  300.94  300.98 
             301.61  302.67  304.10  305.85  307.92 
             310.25  312.85  315.71  318.82  322.18 
             325.80  329.66  347.51  394.44 
/
 5  8  2  1  308.87  303.35  299.85  298.78  298.79 
             299.42  300.52  301.98  303.77  305.86 
             308.24  310.89  313.81  316.99  320.43 
             324.12  328.06  346.25  394.04 
/
 5  8  3  1  304.40  295.90  288.56  287.29  287.30 
             288.02  289.26  290.93  292.96  295.29 
             297.97  300.96  304.23  307.79  311.63 
             315.73  320.10  340.17  392.29 
/
 5  8  4  1  291.62  261.71  256.21  255.76  256.45 
             257.89  259.90  262.40  265.34  268.70 
             272.44  276.56  281.03  285.86  291.03 
             296.52  302.34  328.86  395.59 
/
 5  8  5  1  274.45  229.74  226.79  226.71  228.00 
             230.21  233.14  236.70  240.82  245.47 
             250.60  256.20  262.24  268.71  275.57 
             282.82  290.44  324.42  407.56 
/
 5  8  6  1  194.07  189.15  187.64  189.30  192.68 
             197.32  203.04  209.70  217.15  225.31 
             234.08  243.44  253.32  263.71  274.57 
             285.89  297.63  348.66  468.71 
/
 5  8  7  1  161.94  159.53  164.09  171.63  180.30 
             189.94  200.56  212.15  224.65  238.03 
             252.24  267.27  283.05  299.57  316.80 
             334.72  353.29  433.91  624.43 
/
 5  9  1  1  315.37  311.16  308.63  307.93  308.06 
             308.73  309.79  311.19  312.89  314.88 
             317.13  319.64  322.41  325.43  328.68 
             332.18  335.92  353.24  398.97 
/
 5  9  2  1  314.75  310.15  307.33  306.50  306.57 
             307.20  308.25  309.65  311.37  313.38 
             315.66  318.21  321.02  324.08  327.39 
             330.94  334.74  352.34  398.72 
/
 5  9  3  1  311.72  305.01  299.98  298.72  298.66 
             299.27  300.37  301.87  303.72  305.89 
             308.37  311.13  314.17  317.49  321.07 
             324.91  329.02  347.93  397.38 
/
 5  9  4  1  302.93  287.23  275.40  274.91  275.44 
             276.61  278.29  280.40  282.90  285.75 
             288.94  292.48  296.33  300.49  304.97 
             309.75  314.82  337.96  397.11 
/
 5  9  5  1  291.11  252.88  249.98  249.63  250.47 
             252.09  254.32  257.07  260.29  263.95 
             268.02  272.50  277.36  282.59  288.18 
             294.11  300.39  328.71  399.67 
/
 5  9  6  1  261.69  212.29  209.80  210.34  212.37 
             215.44  219.35  223.99  229.30  235.22 
             241.72  248.74  256.27  264.27  272.71 
             281.58  290.86  331.76  429.71 
/
 5  9  7  1  179.37  175.17  174.92  178.52  184.24 
             191.17  199.05  207.78  217.27  227.47 
             238.34  249.83  261.93  274.59  287.79 
             301.51  315.74  377.40  522.17 
/
 5 10  1  1  323.75  322.55  321.87  321.97  322.52 
             323.40  324.57  326.00  327.68  329.60 
             331.75  334.13  336.74  339.58  342.64 
             345.93  349.44  365.70  408.83 
/
 5 10  2  1  323.75  322.55  321.87  321.97  322.52 
             323.40  324.57  326.00  327.68  329.60 
             331.75  334.13  336.74  339.58  342.64 
             345.93  349.44  365.70  408.83 
/
 5 10  3  1  323.75  322.55  321.87  321.97  322.52 
             323.40  324.57  326.00  327.68  329.60 
             331.75  334.13  336.74  339.58  342.64 
             345.93  349.44  365.70  408.83 
/
 5 10  4  1  323.75  322.55  321.87  321.97  322.52 
             323.40  324.57  326.00  327.68  329.60 
             331.75  334.13  336.74  339.58  342.64 
             345.93  349.44  365.70  408.83 
/
 5 10  5  1  323.75  322.55  321.87  321.97  322.52 
             323.40  324.57  326.00  327.68  329.60 
             331.75  334.13  336.74  339.58  342.64 
             345.93  349.44  365.70  408.83 
/
 5 10  6  1  323.75  322.55  321.87  321.97  322.52 
             323.40  324.57  326.00  327.68  329.60 
             331.75  334.13  336.74  339.58  342.64 
             345.93  349.44  365.70  408.83 
/
 5 10  7  1  323.75  322.55  321.87  321.97  322.52 
             323.40  324.57  326.00  327.68  329.60 
             331.75  334.13  336.74  339.58  342.64 
             345.93  349.44  365.70  408.83 
/
 6  1  1  1  288.81  286.42  283.64  282.86  283.02 
             283.82  285.08  286.76  288.81  291.19 
             293.89  296.90  300.19  303.77  307.62 
             311.75  316.14  336.32  388.71 
/
 6  1  2  1  286.42  283.19  279.22  278.34  278.48 
             279.29  280.65  282.43  284.59  287.11 
             289.93  293.10  296.57  300.34  304.40 
             308.74  313.35  334.51  389.19 
/
 6  1  3  1  276.61  260.32  257.17  256.34  256.78 
             258.07  260.01  262.52  265.50  268.91 
             272.73  276.94  281.49  286.42  291.65 
             297.19  303.05  329.40  396.10 
/
 6  1  4  1  249.76  218.95  216.34  216.68  218.68 
             221.86  226.00  230.94  236.61  242.94 
             249.88  257.38  265.41  273.93  282.92 
             292.35  302.22  345.68  450.66 
/
 6  1  5  1  197.66  193.99  193.15  195.74  200.68 
             207.16  214.78  223.37  232.81  243.03 
             253.98  265.58  277.83  290.68  304.10 
             318.07  332.58  395.73  546.97 
/
 6  1  6  1  174.10  176.13  182.42  191.65  202.70 
             215.47  229.85  245.76  263.15  281.94 
             302.01  323.16  345.38  368.70  393.07 
             418.49  444.94  561.07  847.70 
/
 6  1  7  1  167.87  173.87  187.26  205.88  228.98 
             255.93  286.30  319.76  356.22  395.61 
             437.83  482.93  530.74  580.89  633.48 
             688.61  746.39 1003.46 1629.87 
/
 6  2  1  1  293.42  291.03  288.39  287.65  287.85 
             288.66  289.92  291.58  293.60  295.94 
             298.59  301.54  304.78  308.29  312.07 
             316.12  320.44  340.28  391.92 
/
 6  2  2  1  291.14  287.97  284.21  283.39  283.57 
             284.39  285.71  287.45  289.57  292.03 
             294.82  297.92  301.31  304.99  308.96 
             313.19  317.71  338.43  392.03 
/
 6  2  3  1  281.85  266.69  263.22  262.37  262.76 
             263.98  265.84  268.21  271.05  274.29 
             277.93  281.97  286.32  291.02  296.03 
             301.36  306.98  332.45  397.10 
/
 6  2  4  1  256.63  224.87  222.10  222.26  224.03 
             226.92  230.71  235.26  240.51  246.38 
             252.83  259.82  267.33  275.31  283.75 
             292.62  301.91  342.99  443.02 
/
 6  2  5  1  202.64  198.64  197.42  199.53  203.62 
             209.32  216.23  224.11  232.84  242.33 
             252.52  263.35  274.78  286.79  299.35 
             312.42  326.01  385.16  526.50 
/
 6  2  6  1  176.87  176.94  182.89  191.50  201.69 
             213.41  226.59  241.16  257.08  274.23 
             292.46  311.73  332.03  353.32  375.57 
             398.78  422.90  528.54  787.19 
/
 6  2  7  1  168.66  174.23  186.16  202.66  223.12 
             247.03  274.00  303.72  336.09  371.03 
             408.52  448.49  490.87  535.31  581.81 
             630.46  681.33  907.71 1456.93 
/
 6  3  1  1  298.19  295.85  293.39  292.69  292.92 
             293.74  294.99  296.63  298.61  300.91 
             303.52  306.41  309.58  313.02  316.73 
             320.71  324.94  344.44  395.19 
/
 6  3  2  1  296.05  292.98  289.52  288.73  288.93 
             289.77  291.07  292.78  294.85  297.26 
             299.98  303.00  306.31  309.88  313.75 
             317.90  322.32  342.58  395.17 
/
 6  3  3  1  287.34  274.13  269.77  268.90  269.26 
             270.41  272.16  274.39  277.09  280.19 
             283.65  287.48  291.64  296.10  300.92 
             306.00  311.40  335.95  398.49 
/
 6  3  4  1  263.97  231.66  228.75  228.75  230.29 
             232.89  236.34  240.50  245.32  250.72 
             256.68  263.16  270.13  277.56  285.44 
             293.74  302.43  341.06  435.80 
/
 6  3  5  1  208.53  204.20  202.60  204.27  207.81 
             212.71  218.78  225.85  233.79  242.48 
             251.86  261.87  272.45  283.59  295.26 
             307.42  320.06  375.18  506.74 
/
 6  3  6  1  180.55  178.56  183.59  191.58  200.95 
             211.66  223.69  236.96  251.37  266.86 
             283.37  300.87  319.31  338.65  358.86 
             379.92  401.80  497.41  729.23 
/
 6  3  7  1  169.61  174.73  185.32  199.82  217.79 
             238.82  262.56  288.73  317.21  347.94 
             380.87  415.98  453.23  492.26  533.02 
             575.58  620.00  817.05 1295.06 
/
 6  4  1  1  304.18  301.28  298.81  298.12  298.33 
             299.11  300.36  301.97  303.91  306.16 
             308.70  311.53  314.63  318.01  321.64 
             325.53  329.69  348.82  398.75 
/
 6  4  2  1  302.17  298.64  295.23  294.47  294.66 
             295.47  296.74  298.40  300.42  302.76 
             305.40  308.35  311.58  315.08  318.85 
             322.90  327.21  347.00  398.55 
/
 6  4  3  1  294.03  282.58  276.91  276.01  276.32 
             277.39  279.04  281.13  283.68  286.62 
             289.92  293.52  297.49  301.74  306.33 
             311.21  316.36  339.97  400.31 
/
 6  4  4  1  272.65  239.49  236.48  236.33  237.65 
             239.96  243.07  246.84  251.23  256.17 
             261.64  267.59  274.02  280.89  288.18 
             295.89  303.98  340.08  429.23 
/
 6  4  5  1  215.56  210.92  208.95  210.19  213.20 
             217.47  222.80  229.03  236.08  243.88 
             252.36  261.47  271.15  281.37  292.09 
             303.30  314.96  365.97  487.79 
/
 6  4  6  1  185.15  182.08  185.09  192.01  200.48 
             210.20  221.07  233.03  246.02  259.99 
             274.90  290.70  307.34  324.79  343.01 
             361.99  381.70  467.66  674.37 
/
 6  4  7  1  170.74  175.42  184.76  197.40  213.01 
             231.37  252.06  274.86  299.67  326.41 
             355.06  385.56  417.91  451.80  487.14 
             523.99  562.39  732.01 1144.75 
/
 6  5  1  1  310.82  307.15  304.60  303.85  304.03 
             304.79  305.98  307.54  309.43  311.62 
             314.14  316.91  319.94  323.24  326.79 
             330.58  334.65  353.41  402.50 
/
 6  5  2  1  309.04  304.78  301.43  300.59  300.74 
             301.51  302.74  304.34  306.30  308.57 
             311.14  314.00  317.14  320.55  324.22 
             328.16  332.37  351.70  402.17 
/
 6  5  3  1  301.65  292.24  284.71  283.74  283.99 
             284.96  286.50  288.49  290.89  293.62 
             296.74  300.19  303.95  307.98  312.34 
             317.00  321.93  344.56  402.63 
/
 6  5  4  1  282.38  248.54  245.49  245.21  246.32 
             248.36  251.13  254.52  258.48  262.96 
             267.93  273.36  279.24  285.53  292.24 
             299.33  306.81  340.29  423.86 
/
 6  5  5  1  257.63  219.14  216.83  217.65  220.13 
             223.79  228.41  233.87  240.08  246.98 
             254.52  262.65  271.34  280.56  290.26 
             300.44  311.07  357.77  469.80 
/
 6  5  6  1  191.05  187.47  188.29  193.66  200.94 
             209.51  219.18  229.86  241.48  253.99 
             267.32  281.44  296.32  311.92  328.20 
             345.15  362.75  439.38  622.41 
/
 6  5  7  1  172.13  176.35  184.53  195.45  208.92 
             224.76  242.55  262.18  283.54  306.55 
             331.17  357.37  385.08  414.07  444.29 
             475.78  508.58  652.79 1004.97 
/
 6  6  1  1  317.52  313.23  310.64  309.86  310.00 
             310.71  311.85  313.39  315.23  317.36 
             319.78  322.48  325.44  328.66  332.14 
             335.86  339.84  358.22  406.43 
/
 6  6  2  1  316.01  311.17  307.94  307.03  307.14 
             307.86  309.03  310.58  312.47  314.66 
             317.16  319.93  322.98  326.29  329.87 
             333.71  337.80  356.67  406.13 
/
 6  6  3  1  309.51  301.16  293.16  292.12  292.30 
             293.18  294.60  296.45  298.70  301.30 
             304.19  307.45  311.01  314.86  318.98 
             323.42  328.15  349.76  405.48 
/
 6  6  4  1  292.65  259.06  256.03  255.65  256.57 
             258.35  260.80  263.83  267.37  271.39 
             275.86  280.77  286.09  291.81  297.92 
             304.39  311.23  342.03  419.60 
/
 6  6  5  1  270.62  229.36  226.74  227.16  229.14 
             232.19  236.12  240.81  246.18  252.18 
             258.78  265.93  273.60  281.77  290.40 
             299.48  308.99  351.08  452.98 
/
 6  6  6  1  198.84  194.70  194.40  197.70  203.41 
             210.60  218.91  228.21  238.38  249.36 
             261.10  273.53  286.65  300.40  314.76 
             329.71  345.24  412.78  573.33 
/
 6  6  7  1  174.80  177.57  184.69  194.02  205.66 
             219.14  234.22  250.83  268.92  288.42 
             309.31  331.46  354.71  379.04  404.46 
             430.96  458.52  579.33  872.19 
/
 6  7  1  1  324.06  319.45  316.81  316.07  316.20 
             316.88  317.99  319.45  321.23  323.30 
             325.65  328.28  331.16  334.31  337.70 
             341.34  345.24  363.24  410.62 
/
 6  7  2  1  322.85  317.75  314.72  313.78  313.83 
             314.49  315.63  317.12  318.93  321.06 
             323.47  326.15  329.11  332.33  335.80 
             339.53  343.51  361.91  410.18 
/
 6  7  3  1  317.43  309.33  302.34  301.19  301.27 
             302.05  303.34  305.05  307.15  309.58 
             312.34  315.40  318.77  322.42  326.31 
             330.53  335.02  355.62  409.08 
/
 6  7  4  1  303.29  271.33  268.43  268.00  268.76 
             270.29  272.44  275.11  278.26  281.84 
             285.83  290.21  294.98  300.13  305.63 
             311.48  317.67  345.71  416.89 
/
 6  7  5  1  284.60  242.23  239.38  239.45  240.95 
             243.42  246.68  250.61  255.16  260.27 
             265.92  272.08  278.71  285.80  293.33 
             301.29  309.64  346.90  438.19 
/
 6  7  6  1  209.48  204.78  203.61  205.75  209.74 
             215.14  221.79  229.44  237.96  247.26 
             257.26  267.91  279.16  291.00  303.40 
             316.31  329.74  388.24  527.11 
/
 6  7  7  1  181.28  179.71  185.41  193.61  203.55 
             214.78  227.31  241.10  256.10  272.23 
             289.39  307.53  326.64  346.69  367.65 
             389.50  412.21  511.41  749.53 
/
 6  8  1  1  330.20  325.69  323.15  322.46  322.61 
             323.30  324.39  325.81  327.55  329.57 
             331.85  334.41  337.21  340.27  343.58 
             347.12  350.91  368.46  414.79 
/
 6  8  2  1  329.31  324.38  321.52  320.69  320.77 
             321.42  322.49  323.92  325.68  327.72 
             330.05  332.65  335.51  338.63  342.00 
             345.62  349.48  367.38  414.54 
/
 6  8  3  1  325.14  317.78  312.21  310.95  310.91 
             311.59  312.75  314.34  316.28  318.55 
             321.13  324.01  327.18  330.63  334.34 
             338.33  342.58  362.16  413.25 
/
 6  8  4  1  314.04  290.78  283.07  282.64  283.28 
             284.62  286.49  288.84  291.60  294.75 
             298.28  302.17  306.40  310.98  315.88 
             321.12  326.74  352.14  416.22 
/
 6  8  5  1  299.29  258.72  255.77  255.56  256.64 
             258.58  261.20  264.42  268.16  272.41 
             277.11  282.28  287.87  293.87  300.28 
             307.07  314.24  346.48  426.72 
/
 6  8  6  1  242.64  219.48  217.47  218.61  221.40 
             225.37  230.33  236.14  242.75  250.07 
             258.06  266.67  275.86  285.59  295.85 
             306.59  317.79  366.96  484.36 
/
 6  8  7  1  191.70  188.05  189.42  195.47  203.24 
             212.21  222.25  233.28  245.25  258.11 
             271.83  286.36  301.68  317.75  334.54 
             352.02  370.18  449.33  637.60 
/
 6  9  1  1  335.68  331.79  329.55  329.00  329.21 
             329.92  331.00  332.41  334.10  336.07 
             338.30  340.79  343.52  346.50  349.72 
             353.17  356.86  373.97  419.22 
/
 6  9  2  1  335.10  330.90  328.43  327.77  327.92 
             328.60  329.67  331.08  332.79  334.77 
             337.03  339.54  342.31  345.32  348.58 
             352.08  355.82  373.15  418.95 
/
 6  9  3  1  332.32  326.34  322.49  321.24  321.12 
             321.70  322.76  324.20  326.04  328.15 
             330.57  333.26  336.23  339.47  342.98 
             346.73  350.75  369.31  418.11 
/
 6  9  4  1  324.61  313.07  300.97  300.29  300.67 
             301.71  303.26  305.22  307.58  310.30 
             313.33  316.72  320.40  324.39  328.69 
             333.28  338.18  360.54  418.09 
/
 6  9  5  1  314.34  280.16  277.40  277.04  277.79 
             279.27  281.33  283.88  286.88  290.30 
             294.12  298.32  302.89  307.82  313.10 
             318.73  324.69  351.76  420.41 
/
 6  9  6  1  289.01  242.20  239.50  239.76  241.43 
             244.09  247.54  251.68  256.45  261.81 
             267.72  274.16  281.09  288.50  296.36 
             304.66  313.38  352.21  447.03 
/
 6  9  7  1  209.95  205.17  204.20  206.55  210.76 
             216.55  223.53  231.48  240.28  249.83 
             260.10  271.03  282.57  294.71  307.42 
             320.67  334.45  394.50  536.87 
/
 6 10  1  1  343.85  342.65  341.97  342.07  342.62 
             343.50  344.67  346.10  347.78  349.69 
             351.84  354.23  356.84  359.67  362.73 
             366.02  369.52  385.78  428.89 
/
 6 10  2  1  343.85  342.65  341.97  342.07  342.62 
             343.50  344.67  346.10  347.78  349.69 
             351.84  354.23  356.84  359.67  362.73 
             366.02  369.52  385.78  428.89 
/
 6 10  3  1  343.85  342.65  341.97  342.07  342.62 
             343.50  344.67  346.10  347.78  349.69 
             351.84  354.23  356.84  359.67  362.73 
             366.02  369.52  385.78  428.89 
/
 6 10  4  1  343.85  342.65  341.97  342.07  342.62 
             343.50  344.67  346.10  347.78  349.69 
             351.84  354.23  356.84  359.67  362.73 
             366.02  369.52  385.78  428.89 
/
 6 10  5  1  343.85  342.65  341.97  342.07  342.62 
             343.50  344.67  346.10  347.78  349.69 
             351.84  354.23  356.84  359.67  362.73 
             366.02  369.52  385.78  428.89 
/
 6 10  6  1  343.85  342.65  341.97  342.07  342.62 
             343.50  344.67  346.10  347.78  349.69 
             351.84  354.23  356.84  359.67  362.73 
             366.02  369.52  385.78  428.89 
/
 6 10  7  1  343.85  342.65  341.97  342.07  342.62 
             343.50  344.67  346.10  347.78  349.69 
             351.84  354.23  356.84  359.67  362.73 
             366.02  369.52  385.78  428.89 
/
 7  1  1  1  309.07  307.59  306.09  305.61  305.90 
             306.73  308.03  309.69  311.68  314.00 
             316.62  319.57  322.76  326.23  329.97 
             333.98  338.25  357.94  409.38 
/
 7  1  2  1  306.68  304.68  302.49  301.83  302.08 
             302.93  304.26  305.99  308.08  310.50 
             313.24  316.29  319.63  323.27  327.18 
             331.36  335.83  356.35  409.83 
/
 7  1  3  1  297.43  286.40  283.42  282.59  282.95 
             284.10  285.88  288.15  290.90  294.05 
             297.56  301.48  305.75  310.30  315.22 
             320.44  326.02  351.38  416.08 
/
 7  1  4  1  274.48  247.08  244.43  244.53  246.19 
             248.97  252.64  257.08  262.21  267.98 
             274.35  281.28  288.73  296.69  305.13 
             314.03  323.37  364.97  467.14 
/
 7  1  5  1  225.94  222.10  220.77  222.72  226.64 
             232.05  238.73  246.52  255.25  264.83 
             275.17  286.21  297.93  310.26  323.20 
             336.72  350.80  412.49  561.94 
/
 7  1  6  1  201.16  199.73  205.47  214.09  224.54 
             236.70  250.50  265.85  282.67  300.81 
             320.18  340.75  362.47  385.32  409.27 
             434.29  460.37  575.27  860.06 
/
 7  1  7  1  192.04  197.11  209.46  227.03  249.07 
             275.03  304.44  337.05  372.74  411.43 
             453.06  497.61  544.75  594.31  646.41 
             701.12  758.52 1014.10 1638.49 
/
 7  2  1  1  313.66  312.12  310.63  310.20  310.50 
             311.36  312.63  314.27  316.24  318.56 
             321.14  324.01  327.15  330.57  334.25 
             338.20  342.40  361.79  412.59 
/
 7  2  2  1  311.38  309.36  307.26  306.63  306.89 
             307.74  309.07  310.77  312.82  315.20 
             317.89  320.88  324.16  327.72  331.56 
             335.66  340.04  360.19  412.82 
/
 7  2  3  1  302.50  292.80  289.10  288.26  288.60 
             289.70  291.40  293.59  296.23  299.21 
             302.62  306.38  310.44  314.85  319.57 
             324.65  330.04  354.55  417.34 
/
 7  2  4  1  280.88  252.90  250.13  250.11  251.59 
             254.12  257.50  261.61  266.37  271.74 
             277.66  284.13  291.10  298.56  306.48 
             314.84  323.64  362.91  459.88 
/
 7  2  5  1  230.99  226.88  225.24  226.82  230.27 
             235.12  241.12  248.13  256.07  264.84 
             274.37  284.59  295.45  306.92  318.96 
             331.56  344.70  402.32  541.70 
/
 7  2  6  1  204.38  201.70  206.01  213.94  223.60 
             234.79  247.44  261.46  276.75  293.25 
             310.91  329.68  349.51  370.36  392.19 
             414.99  438.74  543.12  800.28 
/
 7  2  7  1  192.83  197.47  208.46  224.04  243.55 
             266.56  292.64  321.55  353.19  387.47 
             424.36  463.77  505.52  549.35  595.33 
             643.54  694.03  919.07 1466.05 
/
 7  3  1  1  318.42  316.85  315.39  315.01  315.33 
             316.19  317.44  319.06  321.04  323.29 
             325.83  328.65  331.74  335.10  338.72 
             342.61  346.74  365.83  415.83 
/
 7  3  2  1  316.26  314.25  312.28  311.68  311.96 
             312.81  314.09  315.80  317.81  320.14 
             322.78  325.70  328.91  332.40  336.16 
             340.18  344.47  364.25  415.86 
/
 7  3  3  1  307.83  300.01  295.20  294.38  294.70 
             295.75  297.36  299.46  301.97  304.82 
             308.08  311.68  315.61  319.82  324.40 
             329.29  334.45  358.11  418.81 
/
 7  3  4  1  287.71  259.52  256.67  256.53  257.83 
             260.12  263.21  266.99  271.38  276.34 
             281.83  287.83  294.31  301.26  308.65 
             316.48  324.72  361.62  453.37 
/
 7  3  5  1  236.91  232.53  230.59  231.81  234.80 
             239.10  244.46  250.78  257.93  265.87 
             274.53  283.87  293.84  304.39  315.51 
             327.16  339.32  392.81  522.23 
/
 7  3  6  1  208.29  205.17  207.41  214.27  223.00 
             233.16  244.63  257.34  271.22  286.19 
             302.22  319.25  337.24  356.15  375.94 
             396.60  418.10  512.40  742.60 
/
 7  3  7  1  193.78  198.01  207.77  221.45  238.56 
             258.80  281.71  307.12  334.90  364.98 
             397.33  431.92  468.54  506.95  547.17 
             589.28  633.32  829.04 1304.74 
/
 7  4  1  1  324.38  322.19  320.58  320.17  320.49 
             321.31  322.54  324.14  326.05  328.25 
             330.74  333.53  336.56  339.86  343.42 
             347.23  351.30  370.08  419.36 
/
 7  4  2  1  322.37  319.78  317.73  317.12  317.38 
             318.21  319.47  321.09  323.06  325.37 
             327.94  330.80  333.94  337.35  341.03 
             344.96  349.17  368.54  419.24 
/
 7  4  3  1  314.35  308.24  301.85  301.02  301.31 
             302.30  303.83  305.82  308.21  310.93 
             314.03  317.48  321.25  325.30  329.69 
             334.38  339.37  362.14  420.81 
/
 7  4  4  1  295.86  267.07  264.18  263.93  265.06 
             267.13  269.94  273.38  277.40  281.96 
             287.01  292.55  298.54  304.98  311.84 
             319.11  326.78  361.27  447.56 
/
 7  4  5  1  272.58  239.30  237.07  237.94  240.48 
             244.23  248.97  254.58  260.98  268.11 
             275.91  284.35  293.38  302.98  313.12 
             323.76  334.91  384.15  503.65 
/
 7  4  6  1  213.15  209.60  210.29  215.62  223.18 
             232.22  242.49  253.91  266.39  279.87 
             294.29  309.61  325.80  342.81  360.61 
             379.19  398.51  483.13  688.09 
/
 7  4  7  1  194.92  198.75  207.36  219.28  234.18 
             251.82  271.73  293.81  317.95  344.09 
             372.17  402.15  433.89  467.15  501.96 
             538.36  576.36  744.66 1155.06 
/
 7  5  1  1  331.04  327.97  326.11  325.65  325.94 
             326.74  327.94  329.48  331.34  333.49 
             335.93  338.63  341.61  344.84  348.33 
             352.08  356.07  374.52  423.06 
/
 7  5  2  1  329.26  325.81  323.57  322.94  323.14 
             323.91  325.14  326.72  328.63  330.85 
             333.36  336.14  339.21  342.54  346.13 
             349.99  354.09  373.07  422.81 
/
 7  5  3  1  321.95  315.45  309.17  308.25  308.47 
             309.38  310.82  312.69  314.95  317.58 
             320.54  323.83  327.44  331.30  335.50 
             340.00  344.78  366.66  423.36 
/
 7  5  4  1  305.16  275.72  272.84  272.52  273.49 
             275.33  277.86  280.99  284.64  288.80 
             293.42  298.49  303.99  309.91  316.24 
             322.95  330.05  362.08  442.74 
/
 7  5  5  1  283.66  247.47  244.99  245.52  247.62 
             250.84  254.97  259.89  265.54  271.85 
             278.80  286.33  294.43  303.06  312.19 
             321.82  331.90  376.71  486.12 
/
 7  5  6  1  219.29  215.32  215.21  218.75  224.84 
             232.55  241.52  251.58  262.63  274.59 
             287.41  301.03  315.43  330.57  346.42 
             362.95  380.15  455.39  636.54 
/
 7  5  7  1  197.15  199.72  207.27  217.56  230.49 
             245.66  262.78  281.74  302.46  324.88 
             348.96  374.63  401.70  430.08  459.80 
             490.86  523.25  666.14 1016.23 
/
 7  6  1  1  337.75  333.96  331.88  331.37  331.63 
             332.40  333.57  335.07  336.89  338.99 
             341.37  344.02  346.92  350.09  353.50 
             357.17  361.07  379.16  426.82 
/
 7  6  2  1  336.24  332.08  329.66  328.99  329.17 
             329.91  331.07  332.59  334.44  336.61 
             339.05  341.76  344.74  347.99  351.50 
             355.27  359.28  377.84  426.65 
/
 7  6  3  1  329.84  322.95  317.08  316.07  316.21 
             317.05  318.40  320.16  322.31  324.80 
             327.57  330.70  334.13  337.86  341.86 
             346.16  350.71  371.72  426.26 
/
 7  6  4  1  315.01  285.69  282.88  282.50  283.33 
             284.96  287.23  290.04  293.35  297.11 
             301.31  305.93  310.94  316.34  322.13 
             328.28  334.80  364.33  439.12 
/
 7  6  5  1  295.79  257.48  254.79  255.01  256.69 
             259.40  262.93  267.18  272.09  277.60 
             283.69  290.32  297.47  305.11  313.23 
             321.81  330.84  371.10  470.23 
/
 7  6  6  1  227.29  222.87  222.02  224.56  229.09 
             235.17  242.61  251.14  260.64  270.99 
             282.15  294.04  306.63  319.88  333.78 
             348.29  363.39  429.46  587.96 
/
 7  6  7  1  201.98  201.10  207.56  216.41  227.62 
             240.48  254.95  270.98  288.50  307.48 
             327.76  349.24  371.91  395.74  420.71 
             446.79  473.98  593.46  884.40 
/
 7  7  1  1  344.29  340.08  337.85  337.31  337.55 
             338.30  339.44  340.90  342.67  344.73 
             347.05  349.63  352.48  355.57  358.91 
             362.49  366.31  384.03  430.79 
/
 7  7  2  1  343.10  338.52  336.00  335.32  335.49 
             336.20  337.33  338.80  340.60  342.69 
             345.05  347.69  350.59  353.75  357.16 
             360.83  364.74  382.84  430.56 
/
 7  7  3  1  337.79  330.83  325.58  324.48  324.54 
             325.28  326.52  328.17  330.19  332.54 
             335.20  338.17  341.43  344.97  348.77 
             352.86  357.23  377.35  429.84 
/
 7  7  4  1  325.23  297.22  294.56  294.16  294.88 
             296.32  298.34  300.86  303.83  307.21 
             310.99  315.16  319.69  324.59  329.84 
             335.43  341.36  368.63  437.05 
/
 7  7  5  1  308.83  269.91  267.09  267.04  268.34 
             270.56  273.52  277.12  281.30  286.03 
             291.27  297.00  303.20  309.86  316.96 
             324.48  332.41  368.04  456.69 
/
 7  7  6  1  238.05  233.20  231.61  233.27  236.70 
             241.44  247.29  254.12  261.84  270.38 
             279.69  289.70  300.37  311.65  323.52 
             335.94  348.90  405.80  542.43 
/
 7  7  7  1  209.10  205.87  208.94  216.34  225.70 
             236.44  248.46  261.71  276.14  291.68 
             308.31  325.97  344.63  364.25  384.80 
             406.24  428.57  526.44  762.61 
/
 7  8  1  1  350.42  346.21  343.97  343.44  343.68 
             344.41  345.53  346.96  348.69  350.69 
             352.96  355.49  358.26  361.29  364.55 
             368.06  371.80  389.14  434.99 
/
 7  8  2  1  349.55  345.02  342.53  341.88  342.06 
             342.76  343.86  345.30  347.04  349.07 
             351.37  353.93  356.75  359.82  363.14 
             366.70  370.51  388.14  434.70 
/
 7  8  3  1  345.52  338.98  334.77  333.51  333.44 
             334.08  335.22  336.76  338.64  340.85 
             343.36  346.17  349.26  352.62  356.26 
             360.15  364.32  383.53  433.91 
/
 7  8  4  1  335.58  318.51  308.22  307.85  308.48 
             309.77  311.57  313.81  316.46  319.49 
             322.85  326.58  330.64  335.02  339.74 
             344.77  350.12  374.52  436.79 
/
 7  8  5  1  322.53  285.57  282.77  282.51  283.48 
             285.26  287.68  290.67  294.16  298.13 
             302.55  307.39  312.66  318.34  324.41 
             330.87  337.70  368.61  446.51 
/
 7  8  6  1  291.47  247.91  245.66  246.48  248.87 
             252.39  256.83  262.10  268.12  274.84 
             282.22  290.21  298.80  307.94  317.61 
             327.79  338.46  385.77  500.58 
/
 7  8  7  1  220.02  215.92  216.13  220.19  226.84 
             235.03  244.41  254.86  266.30  278.66 
             291.90  305.96  320.82  336.45  352.82 
             369.90  387.68  465.44  651.69 
/
 7  9  1  1  355.88  352.18  350.15  349.70  349.97 
             350.71  351.82  353.22  354.92  356.88 
             359.10  361.57  364.28  367.24  370.43 
             373.86  377.52  394.49  439.42 
/
 7  9  2  1  355.33  351.38  349.16  348.62  348.84 
             349.56  350.65  352.06  353.76  355.74 
             357.98  360.47  363.21  366.19  369.42 
             372.88  376.59  393.74  439.15 
/
 7  9  3  1  352.67  347.22  343.88  342.84  342.81 
             343.40  344.45  345.88  347.64  349.71 
             352.08  354.72  357.64  360.82  364.26 
             367.96  371.91  390.22  438.47 
/
 7  9  4  1  345.72  335.33  325.23  324.31  324.58 
             325.52  326.97  328.85  331.11  333.68 
             336.63  339.90  343.48  347.32  351.50 
             355.97  360.70  382.52  438.94 
/
 7  9  5  1  336.56  307.38  303.08  302.74  303.45 
             304.86  306.82  309.24  312.09  315.35 
             318.99  323.01  327.37  332.10  337.16 
             342.57  348.30  374.45  441.82 
/
 7  9  6  1  314.10  270.00  267.29  267.39  268.85 
             271.23  274.37  278.17  282.57  287.53 
             293.01  299.02  305.51  312.47  319.89 
             327.75  336.03  373.19  465.27 
/
 7  9  7  1  238.58  233.60  232.21  234.06  237.69 
             242.64  248.72  255.81  263.85  272.72 
             282.36  292.70  303.70  315.32  327.54 
             340.32  353.66  412.16  552.25 
/
 7 10  1  1  363.95  362.75  362.07  362.17  362.71 
             363.60  364.77  366.19  367.87  369.79 
             371.94  374.32  376.93  379.76  382.82 
             386.11  389.61  405.86  448.95 
/
 7 10  2  1  363.95  362.75  362.07  362.17  362.71 
             363.60  364.77  366.19  367.87  369.79 
             371.94  374.32  376.93  379.76  382.82 
             386.11  389.61  405.86  448.95 
/
 7 10  3  1  363.95  362.75  362.07  362.17  362.71 
             363.60  364.77  366.19  367.87  369.79 
             371.94  374.32  376.93  379.76  382.82 
             386.11  389.61  405.86  448.95 
/
 7 10  4  1  363.95  362.75  362.07  362.17  362.71 
             363.60  364.77  366.19  367.87  369.79 
             371.94  374.32  376.93  379.76  382.82 
             386.11  389.61  405.86  448.95 
/
 7 10  5  1  363.95  362.75  362.07  362.17  362.71 
             363.60  364.77  366.19  367.87  369.79 
             371.94  374.32  376.93  379.76  382.82 
             386.11  389.61  405.86  448.95 
/
 7 10  6  1  363.95  362.75  362.07  362.17  362.71 
             363.60  364.77  366.19  367.87  369.79 
             371.94  374.32  376.93  379.76  382.82 
             386.11  389.61  405.86  448.95 
/
 7 10  7  1  363.95  362.75  362.07  362.17  362.71 
             363.60  364.77  366.19  367.87  369.79 
             371.94  374.32  376.93  379.76  382.82 
             386.11  389.61  405.86  448.95 
/
 8  1  1  1  329.25  328.20  327.24  327.09  327.55 
             328.47  329.78  331.44  333.42  335.71 
             338.29  341.15  344.29  347.70  351.37 
             355.31  359.52  378.90  429.79 
/
 8  1  2  1  326.77  325.48  324.21  323.88  324.25 
             325.16  326.49  328.23  330.28  332.65 
             335.33  338.31  341.57  345.12  348.95 
             353.05  357.42  377.57  430.28 
/
 8  1  3  1  317.41  310.70  307.77  307.05  307.42 
             308.52  310.18  312.29  314.87  317.86 
             321.22  324.95  328.98  333.39  338.11 
             343.14  348.51  373.03  436.09 
/
 8  1  4  1  297.36  273.43  270.92  270.93  272.40 
             274.91  278.26  282.35  287.10  292.47 
             298.41  304.90  311.92  319.44  327.44 
             335.91  344.84  384.92  483.96 
/
 8  1  5  1  252.58  248.83  247.28  248.84  252.28 
             257.13  263.17  270.24  278.25  287.14 
             296.84  307.29  318.45  330.28  342.73 
             355.79  369.45  429.72  577.63 
/
 8  1  6  1  227.42  224.75  228.38  236.33  246.28 
             257.93  271.20  285.99  302.20  319.76 
             338.63  358.73  380.03  402.47  426.03 
             450.67  476.41  590.18  873.24 
/
 8  1  7  1  215.71  220.04  231.56  248.25  269.39 
             294.48  323.05  354.91  389.95  427.99 
             469.08  513.06  559.58  608.63  660.29 
             714.63  771.68 1025.87 1648.35 
/
 8  2  1  1  333.83  332.70  331.72  331.59  332.06 
             332.98  334.29  335.93  337.89  340.14 
             342.68  345.50  348.59  351.95  355.57 
             359.45  363.59  382.69  432.87 
/
 8  2  2  1  331.46  330.11  328.83  328.53  328.91 
             329.81  331.13  332.83  334.85  337.18 
             339.81  342.77  345.98  349.47  353.22 
             357.25  361.53  381.32  433.16 
/
 8  2  3  1  322.41  317.49  313.14  312.44  312.80 
             313.85  315.45  317.53  320.02  322.90 
             326.10  329.69  333.62  337.87  342.41 
             347.29  352.49  376.23  437.49 
/
 8  2  4  1  303.42  279.13  276.54  276.45  277.78 
             280.08  283.19  286.98  291.40  296.40 
             301.95  308.02  314.59  321.64  329.16 
             337.13  345.53  383.36  477.34 
/
 8  2  5  1  257.64  253.66  251.86  253.11  256.14 
             260.49  265.94  272.37  279.67  287.80 
             296.69  306.29  316.57  327.49  339.03 
             351.14  363.82  419.94  557.48 
/
 8  2  6  1  230.78  227.77  229.71  236.48  245.46 
             256.10  268.21  281.70  296.49  312.52 
             329.72  348.04  367.45  387.89  409.33 
             431.77  455.16  558.37  814.20 
/
 8  2  7  1  216.51  220.45  230.69  245.47  264.16 
             286.40  311.69  339.89  370.88  404.58 
             440.92  479.79  520.91  564.21  609.75 
             657.56  707.70  931.51 1476.44 
/
 8  3  1  1  338.58  337.39  336.41  336.30  336.77 
             337.70  338.99  340.61  342.55  344.77 
             347.27  350.05  353.09  356.40  359.96 
             363.78  367.85  386.65  436.11 
/
 8  3  2  1  336.34  334.95  333.68  333.41  333.81 
             334.71  336.01  337.66  339.64  341.95 
             344.54  347.41  350.55  353.97  357.68 
             361.63  365.85  385.29  436.30 
/
 8  3  3  1  327.69  323.59  318.92  318.24  318.58 
             319.60  321.14  323.13  325.52  328.29 
             331.41  334.87  338.61  342.71  347.12 
             351.83  356.82  379.79  439.20 
/
 8  3  4  1  309.92  285.57  282.93  282.76  283.94 
             286.05  288.90  292.40  296.50  301.14 
             306.29  311.94  318.06  324.64  331.67 
             339.13  347.01  382.56  471.41 
/
 8  3  5  1  288.07  259.34  257.30  258.24  260.87 
             264.73  269.61  275.40  282.01  289.37 
             297.46  306.22  315.61  325.62  336.20 
             347.34  359.02  410.89  538.27 
/
 8  3  6  1  234.85  231.49  232.29  237.53  245.37 
             254.89  265.80  278.00  291.39  305.90 
             321.47  338.05  355.61  374.10  393.50 
             413.79  434.94  528.03  756.81 
/
 8  3  7  1  217.46  220.99  230.04  243.04  259.46 
             279.00  301.21  325.94  353.10  382.62 
             414.46  448.52  484.50  522.36  562.14 
             603.86  647.53  842.08 1315.74 
/
 8  4  1  1  344.54  342.70  341.51  341.35  341.80 
             342.70  343.98  345.57  347.47  349.65 
             352.11  354.83  357.82  361.07  364.57 
             368.33  372.33  390.83  439.54 
/
 8  4  2  1  342.44  340.42  338.98  338.68  339.06 
             339.93  341.21  342.82  344.76  347.00 
             349.53  352.34  355.42  358.77  362.38 
             366.26  370.39  389.48  439.65 
/
 8  4  3  1  334.17  329.76  325.24  324.53  324.85 
             325.81  327.28  329.18  331.48  334.13 
             337.12  340.44  344.08  348.03  352.23 
             356.77  361.61  383.77  441.29 
/
 8  4  4  1  317.70  292.88  290.22  289.98  291.02 
             292.94  295.55  298.77  302.53  306.81 
             311.58  316.81  322.49  328.60  335.13 
             342.08  349.43  382.68  466.14 
/
 8  4  5  1  297.12  266.08  263.81  264.46  266.70 
             270.08  274.40  279.56  285.47  292.09 
             299.37  307.29  315.80  324.89  334.52 
             344.68  355.35  402.89  520.07 
/
 8  4  6  1  239.85  236.13  236.26  240.08  246.50 
             254.74  264.37  275.21  287.16  300.13 
             314.08  328.94  344.68  361.26  378.66 
             396.85  415.81  499.18  702.57 
/
 8  4  7  1  219.34  221.76  229.74  241.06  255.40 
             272.38  291.66  313.11  336.68  362.28 
             389.86  419.32  450.42  483.15  517.51 
             553.51  591.16  758.27 1166.49 
/
 8  5  1  1  351.19  348.44  346.95  346.71  347.11 
             347.98  349.22  350.77  352.63  354.77 
             357.18  359.85  362.78  365.97  369.41 
             373.09  377.03  395.21  443.16 
/
 8  5  2  1  349.36  346.39  344.66  344.29  344.63 
             345.47  346.70  348.27  350.16  352.35 
             354.82  357.56  360.57  363.84  367.37 
             371.16  375.21  393.89  443.09 
/
 8  5  3  1  341.86  336.68  332.22  331.41  331.65 
             332.55  333.94  335.75  337.93  340.47 
             343.33  346.51  350.00  353.78  357.83 
             362.20  366.85  388.22  443.89 
/
 8  5  4  1  326.76  301.20  298.57  298.28  299.19 
             300.92  303.30  306.24  309.69  313.62 
             318.00  322.81  328.04  333.69  339.73 
             346.16  352.97  383.90  461.89 
/
 8  5  5  1  307.69  274.14  271.68  272.06  273.92 
             276.83  280.61  285.15  290.39  296.27 
             302.75  309.83  317.46  325.62  334.30 
             343.47  353.13  396.31  503.30 
/
 8  5  6  1  246.13  242.05  241.53  244.47  249.51 
             256.22  264.40  273.78  284.21  295.61 
             307.91  321.04  334.96  349.65  365.07 
             381.20  398.02  471.94  651.34 
/
 8  5  7  1  223.13  222.78  229.77  239.54  252.04 
             266.62  283.14  301.53  321.71  343.63 
             367.21  392.28  418.77  446.66  475.96 
             506.63  538.66  680.34 1028.50 
/
 8  6  1  1  357.90  354.39  352.62  352.29  352.65 
             353.48  354.68  356.20  358.01  360.10 
             362.46  365.08  367.96  371.08  374.46 
             378.08  381.94  399.80  446.96 
/
 8  6  2  1  356.37  352.61  350.62  350.17  350.47 
             351.27  352.47  354.00  355.83  357.96 
             360.37  363.04  365.98  369.18  372.63 
             376.33  380.28  398.56  446.76 
/
 8  6  3  1  349.84  344.03  339.79  338.81  338.97 
             339.79  341.09  342.80  344.88  347.29 
             350.02  353.06  356.40  360.02  363.93 
             368.12  372.56  393.14  446.91 
/
 8  6  4  1  336.37  310.71  308.17  307.85  308.65 
             310.21  312.36  315.03  318.18  321.76 
             325.76  330.17  334.97  340.14  345.70 
             351.61  357.89  386.72  458.83 
/
 8  6  5  1  319.25  283.91  281.31  281.43  282.94 
             285.42  288.67  292.61  297.18  302.34 
             308.04  314.28  321.03  328.28  336.00 
             344.18  352.81  391.59  488.36 
/
 8  6  6  1  254.21  249.78  248.61  250.74  254.74 
             260.19  266.86  274.62  283.38  293.08 
             303.62  314.95  327.02  339.78  353.21 
             367.28  381.96  446.62  603.19 
/
 8  6  7  1  228.37  225.56  230.26  238.74  249.45 
             261.79  275.76  291.29  308.29  326.66 
             346.35  367.33  389.54  412.95  437.52 
             463.23  490.07  608.33  897.51 
/
 8  7  1  1  364.45  360.46  358.49  358.09  358.41 
             359.21  360.37  361.85  363.62  365.67 
             367.97  370.54  373.36  376.42  379.73 
             383.28  387.07  404.60  450.96 
/
 8  7  2  1  363.24  358.99  356.81  356.31  356.58 
             357.34  358.50  359.99  361.78  363.85 
             366.19  368.80  371.66  374.78  378.15 
             381.76  385.62  403.49  450.68 
/
 8  7  3  1  357.89  351.76  347.91  346.77  346.83 
             347.55  348.76  350.36  352.31  354.60 
             357.20  360.09  363.28  366.75  370.49 
             374.51  378.78  398.55  450.36 
/
 8  7  4  1  346.38  323.17  319.26  318.94  319.65 
             321.05  323.00  325.41  328.26  331.51 
             335.15  339.16  343.53  348.26  353.33 
             358.77  364.55  390.72  457.17 
/
 8  7  5  1  331.68  295.91  293.25  293.16  294.35 
             296.40  299.16  302.53  306.45  310.90 
             315.85  321.27  327.15  333.48  340.25 
             347.43  355.03  389.38  475.85 
/
 8  7  6  1  264.94  260.18  258.41  259.76  262.79 
             267.08  272.42  278.70  285.84  293.79 
             302.49  311.90  321.99  332.72  344.06 
             355.98  368.48  423.80  558.25 
/
 8  7  7  1  235.78  232.26  233.51  239.55  248.04 
             258.15  269.62  282.36  296.31  311.39 
             327.57  344.80  363.04  382.26  402.42 
             423.50  445.48  542.10  776.49 
/
 8  8  1  1  370.58  366.53  364.49  364.07  364.37 
             365.14  366.27  367.72  369.45  371.45 
             373.71  376.22  378.97  381.98  385.22 
             388.70  392.41  409.62  455.17 
/
 8  8  2  1  369.71  365.41  363.18  362.67  362.92 
             363.67  364.79  366.24  367.98  370.00 
             372.28  374.82  377.62  380.66  383.94 
             387.47  391.24  408.69  454.86 
/
 8  8  3  1  365.69  359.76  356.29  355.22  355.20 
             355.82  356.93  358.44  360.28  362.44 
             364.90  367.65  370.68  373.99  377.56 
             381.40  385.50  404.46  454.34 
/
 8  8  4  1  356.53  344.60  332.35  331.92  332.49 
             333.70  335.41  337.55  340.08  343.00 
             346.24  349.82  353.75  358.01  362.56 
             367.45  372.63  396.35  457.30 
/
 8  8  5  1  344.74  310.87  308.27  308.03  308.95 
             310.63  312.92  315.75  319.06  322.84 
             327.05  331.68  336.71  342.14  347.97 
             354.17  360.74  390.63  466.68 
/
 8  8  6  1  316.75  274.75  272.46  273.09  275.21 
             278.41  282.49  287.36  292.95  299.21 
             306.12  313.64  321.74  330.40  339.60 
             349.32  359.54  405.16  517.39 
/
 8  8  7  1  246.97  242.72  242.49  245.74  251.14 
             258.39  267.05  276.87  287.75  299.59 
             312.34  325.94  340.36  355.56  371.53 
             388.22  405.63  482.09  666.43 
/
 8  9  1  1  376.02  372.44  370.54  370.16  370.48 
             371.24  372.36  373.78  375.47  377.43 
             379.65  382.11  384.81  387.75  390.92 
             394.34  397.98  414.86  459.59 
/
 8  9  2  1  375.49  371.69  369.64  369.19  369.47 
             370.22  371.32  372.74  374.44  376.41 
             378.64  381.12  383.84  386.81  390.01 
             393.46  397.13  414.17  459.31 
/
 8  9  3  1  372.88  367.81  364.82  363.94  364.00 
             364.64  365.71  367.14  368.89  370.95 
             373.28  375.89  378.76  381.90  385.29 
             388.93  392.83  410.87  458.53 
/
 8  9  4  1  366.45  356.95  348.42  347.37  347.55 
             348.41  349.78  351.58  353.76  356.29 
             359.15  362.28  365.77  369.56  373.65 
             377.97  382.63  404.02  459.47 
/
 8  9  5  1  358.11  334.15  327.49  327.21  327.92 
             329.29  331.17  333.51  336.27  339.41 
             342.93  346.81  351.04  355.61  360.51 
             365.75  371.32  396.78  463.30 
/
 8  9  6  1  337.77  296.20  293.57  293.61  294.94 
             297.15  300.07  303.62  307.75  312.42 
             317.60  323.28  329.43  336.06  343.13 
             350.64  358.58  394.40  484.18 
/
 8  9  7  1  265.59  260.66  259.05  260.58  263.80 
             268.29  273.85  280.37  287.78  296.01 
             305.03  314.77  325.22  336.32  348.04 
             360.36  373.26  430.25  568.16 
/
 8 10  1  1  384.05  382.85  382.16  382.26  382.81 
             383.69  384.86  386.29  387.97  389.88 
             392.03  394.41  397.02  399.85  402.91 
             406.19  409.70  425.93  469.01 
/
 8 10  2  1  384.05  382.85  382.16  382.26  382.81 
             383.69  384.86  386.29  387.97  389.88 
             392.03  394.41  397.02  399.85  402.91 
             406.19  409.70  425.93  469.01 
/
 8 10  3  1  384.05  382.85  382.16  382.26  382.81 
             383.69  384.86  386.29  387.97  389.88 
             392.03  394.41  397.02  399.85  402.91 
             406.19  409.70  425.93  469.01 
/
 8 10  4  1  384.05  382.85  382.16  382.26  382.81 
             383.69  384.86  386.29  387.97  389.88 
             392.03  394.41  397.02  399.85  402.91 
             406.19  409.70  425.93  469.01 
/
 8 10  5  1  384.05  382.85  382.16  382.26  382.81 
             383.69  384.86  386.29  387.97  389.88 
             392.03  394.41  397.02  399.85  402.91 
             406.19  409.70  425.93  469.01 
/
 8 10  6  1  384.05  382.85  382.16  382.26  382.81 
             383.69  384.86  386.29  387.97  389.88 
             392.03  394.41  397.02  399.85  402.91 
             406.19  409.70  425.93  469.01 
/
 8 10  7  1  384.05  382.85  382.16  382.26  382.81 
             383.69  384.86  386.29  387.97  389.88 
             392.03  394.41  397.02  399.85  402.91 
             406.19  409.70  425.93  469.01 
/
 9  1  1  1  349.54  348.56  347.85  347.91  348.49 
             349.50  350.86  352.54  354.53  356.81 
             359.37  362.21  365.31  368.68  372.31 
             376.20  380.34  399.48  449.82 
/
 9  1  2  1  346.92  345.93  345.09  345.04  345.56 
             346.55  347.92  349.63  351.68  354.02 
             356.67  359.60  362.81  366.30  370.07 
             374.10  378.40  398.25  450.42 
/
 9  1  3  1  337.01  334.04  330.70  330.14  330.56 
             331.64  333.29  335.37  337.86  340.69 
             343.92  347.51  351.44  355.70  360.29 
             365.15  370.36  394.25  456.30 
/
 9  1  4  1  319.03  298.38  296.10  296.12  297.49 
             299.83  302.97  306.81  311.28  316.35 
             321.98  328.13  334.82  342.00  349.67 
             357.80  366.41  405.28  501.39 
/
 9  1  5  1  277.89  274.36  272.77  274.11  277.21 
             281.66  287.23  293.80  301.30  309.64 
             318.79  328.70  339.33  350.65  362.62 
             375.24  388.46  447.35  593.57 
/
 9  1  6  1  252.72  249.94  251.78  258.61  267.90 
             279.03  291.80  306.10  321.85  338.97 
             357.39  377.07  397.96  420.02  443.21 
             467.52  492.94  605.69  887.07 
/
 9  1  7  1  238.88  242.65  253.50  269.46  289.85 
             314.18  342.02  373.21  407.61  445.13 
             485.71  529.09  575.05  623.65  674.92 
             728.92  785.66 1038.52 1659.48 
/
 9  2  1  1  354.10  353.05  352.32  352.37  352.96 
             353.95  355.30  356.97  358.93  361.18 
             363.71  366.51  369.57  372.89  376.46 
             380.30  384.39  403.26  452.95 
/
 9  2  2  1  351.60  350.54  349.67  349.62  350.15 
             351.13  352.49  354.18  356.19  358.50 
             361.10  363.98  367.14  370.57  374.27 
             378.24  382.47  401.98  453.31 
/
 9  2  3  1  342.01  339.09  335.87  335.33  335.75 
             336.80  338.37  340.37  342.78  345.56 
             348.69  352.16  355.96  360.09  364.49 
             369.24  374.28  397.46  457.68 
/
 9  2  4  1  324.86  303.98  301.64  301.58  302.82 
             304.98  307.90  311.48  315.65  320.39 
             325.65  331.43  337.69  344.44  351.65 
             359.31  367.41  404.10  495.20 
/
 9  2  5  1  304.36  279.22  277.41  278.48  281.21 
             285.20  290.24  296.22  303.06  310.69 
             319.08  328.18  337.96  348.39  359.45 
             371.11  383.36  437.97  573.88 
/
 9  2  6  1  256.18  253.09  254.13  259.47  267.62 
             277.63  289.20  302.19  316.51  332.08 
             348.85  366.74  385.74  405.79  426.86 
             448.95  472.02  574.17  828.67 
/
 9  2  7  1  239.72  243.11  252.74  266.85  284.90 
             306.43  331.05  358.60  389.01  422.19 
             458.02  496.31  536.86  579.69  624.84 
             672.32  722.15  944.80 1487.94 
/
 9  3  1  1  358.83  357.73  356.98  357.03  357.62 
             358.61  359.94  361.59  363.52  365.74 
             368.23  370.99  374.00  377.27  380.80 
             384.58  388.61  407.21  456.23 
/
 9  3  2  1  356.48  355.35  354.47  354.43  354.97 
             355.94  357.28  358.95  360.93  363.20 
             365.75  368.58  371.68  375.05  378.68 
             382.58  386.73  405.90  456.38 
/
 9  3  3  1  347.30  344.46  341.44  340.90  341.30 
             342.32  343.85  345.79  348.12  350.80 
             353.82  357.14  360.81  364.80  369.09 
             373.68  378.56  401.00  459.47 
/
 9  3  4  1  331.13  310.27  307.90  307.77  308.89 
             310.88  313.58  316.89  320.77  325.18 
             330.09  335.48  341.33  347.64  354.39 
             361.57  369.17  403.69  489.73 
/
 9  3  5  1  311.54  284.89  282.88  283.68  286.06 
             289.61  294.13  299.52  305.71  312.64 
             320.27  328.56  337.50  347.05  357.19 
             367.90  379.17  429.52  554.88 
/
 9  3  6  1  260.34  256.95  257.38  261.52  268.29 
             277.05  287.35  298.99  311.88  325.91 
             341.03  357.18  374.32  392.41  411.44 
             431.36  452.18  544.15  771.66 
/
 9  3  7  1  241.30  243.71  252.20  264.59  280.45 
             299.35  320.93  345.07  371.68  400.70 
             432.07  465.54  500.95  538.34  577.72 
             619.09  662.45  855.92 1327.63 
/
 9  4  1  1  364.77  363.01  362.05  362.03  362.58 
             363.54  364.85  366.46  368.36  370.54 
             372.99  375.70  378.66  381.88  385.35 
             389.07  393.04  411.37  459.68 
/
 9  4  2  1  362.57  360.80  359.71  359.61  360.12 
             361.06  362.37  364.00  365.94  368.16 
             370.67  373.44  376.48  379.78  383.34 
             387.16  391.24  410.06  459.66 
/
 9  4  3  1  353.77  350.53  347.57  346.96  347.32 
             348.29  349.74  351.62  353.86  356.44 
             359.35  362.58  366.08  369.93  374.07 
             378.50  383.22  404.94  461.61 
/
 9  4  4  1  338.63  317.36  314.99  314.81  315.81 
             317.64  320.12  323.18  326.77  330.86 
             335.41  340.42  345.87  351.74  358.03 
             364.73  371.82  404.21  485.00 
/
 9  4  5  1  320.16  291.56  289.38  289.92  291.96 
             295.08  299.10  303.91  309.46  315.70 
             322.58  330.08  338.18  346.85  356.07 
             365.83  376.11  422.21  537.30 
/
 9  4  6  1  265.43  261.73  261.56  264.91  270.45 
             277.76  286.66  296.88  308.27  320.73 
             334.19  348.59  363.90  380.06  397.07 
             414.89  433.50  515.69  717.61 
/
 9  4  7  1  244.39  244.47  251.92  262.72  276.61 
             293.02  311.74  332.67  355.72  380.84 
             407.94  436.80  467.37  499.64  533.61 
             569.26  606.59  772.62 1178.80 
/
 9  5  1  1  371.41  368.74  367.45  367.33  367.82 
             368.74  370.00  371.58  373.44  375.57 
             377.97  380.63  383.54  386.71  390.12 
             393.78  397.68  415.72  463.32 
/
 9  5  2  1  369.49  366.75  365.33  365.14  365.58 
             366.48  367.75  369.34  371.23  373.40 
             375.85  378.56  381.54  384.77  388.26 
             392.00  396.00  414.45  463.15 
/
 9  5  3  1  361.58  357.39  354.31  353.59  353.86 
             354.76  356.13  357.90  360.03  362.50 
             365.30  368.40  371.81  375.51  379.50 
             383.77  388.33  409.31  464.24 
/
 9  5  4  1  347.56  325.41  323.07  322.85  323.75 
             325.41  327.69  330.51  333.81  337.58 
             341.79  346.42  351.46  356.89  362.73 
             368.95  375.55  405.76  481.18 
/
 9  5  5  1  330.38  299.49  297.17  297.47  299.18 
             301.89  305.42  309.68  314.60  320.16 
             326.31  333.02  340.28  348.08  356.39 
             365.20  374.50  416.34  521.26 
/
 9  5  6  1  271.77  267.77  267.02  269.60  274.16 
             280.28  287.73  296.40  306.17  316.99 
             328.74  341.36  354.82  369.07  384.06 
             399.80  416.24  488.90  666.67 
/
 9  5  7  1  248.43  246.18  252.03  261.41  273.48 
             287.55  303.58  321.49  341.21  362.63 
             385.64  410.18  436.21  463.70  492.61 
             522.93  554.64  695.23 1041.57 
/
 9  6  1  1  378.10  374.66  373.07  372.85  373.28 
             374.15  375.38  376.91  378.73  380.82 
             383.17  385.78  388.63  391.74  395.09 
             398.69  402.52  420.26  467.14 
/
 9  6  2  1  376.50  372.94  371.21  370.92  371.31 
             372.16  373.39  374.93  376.77  378.89 
             381.28  383.93  386.84  390.00  393.42 
             397.08  401.00  419.08  466.87 
/
 9  6  3  1  369.68  364.68  361.61  360.70  360.89 
             361.70  362.98  364.65  366.68  369.07 
             371.74  374.72  377.99  381.54  385.37 
             389.49  393.87  414.10  467.16 
/
 9  6  4  1  357.07  334.56  332.31  332.07  332.87 
             334.39  336.47  339.05  342.08  345.54 
             349.40  353.66  358.31  363.32  368.70 
             374.46  380.60  408.35  478.52 
/
 9  6  5  1  341.56  309.04  306.61  306.70  308.11 
             310.43  313.49  317.20  321.52  326.41 
             331.84  337.78  344.22  351.16  358.56 
             366.43  374.74  412.33  507.12 
/
 9  6  6  1  279.86  275.58  274.28  276.12  279.75 
             284.76  290.93  298.17  306.36  315.48 
             325.44  336.21  347.75  360.02  372.99 
             386.61  400.89  464.17  618.89 
/
 9  6  7  1  253.84  250.85  253.39  261.01  271.11 
             282.99  296.48  311.52  328.02  345.92 
             365.17  385.73  407.55  430.58  454.79 
             480.16  506.66  623.80  911.36 
/
 9  7  1  1  384.62  380.70  378.88  378.57  378.95 
             379.78  380.96  382.46  384.23  386.27 
             388.58  391.13  393.94  396.98  400.27 
             403.80  407.57  425.01  471.14 
/
 9  7  2  1  383.38  379.29  377.32  376.95  377.29 
             378.10  379.28  380.78  382.57  384.63 
             386.97  389.56  392.40  395.49  398.83 
             402.42  406.25  423.96  470.82 
/
 9  7  3  1  377.85  372.34  369.23  368.33  368.41 
             369.12  370.32  371.89  373.81  376.05 
             378.60  381.48  384.61  388.01  391.69 
             395.64  399.86  419.35  470.68 
/
 9  7  4  1  366.99  348.61  342.92  342.69  343.42 
             344.80  346.69  349.05  351.81  354.93 
             358.44  362.31  366.54  371.11  376.03 
             381.26  386.83  412.24  477.19 
/
 9  7  5  1  353.60  320.66  318.21  318.13  319.26 
             321.21  323.82  327.03  330.77  335.01 
             339.74  344.93  350.56  356.65  363.16 
             370.09  377.43  410.75  495.43 
/
 9  7  6  1  322.92  285.98  284.16  285.32  288.07 
             292.02  296.98  302.84  309.54  317.02 
             325.25  334.18  343.79  354.04  364.92 
             376.40  388.46  442.20  574.48 
/
 9  7  7  1  261.44  257.83  258.64  263.29  270.78 
             280.17  291.06  303.29  316.76  331.39 
             347.14  363.95  381.79  400.62  420.42 
             441.15  462.79  558.25  791.01 
/
 9  8  1  1  390.73  386.75  384.82  384.46  384.81 
             385.61  386.76  388.21  389.94  391.94 
             394.20  396.70  399.45  402.44  405.67 
             409.13  412.83  429.97  475.34 
/
 9  8  2  1  389.85  385.67  383.61  383.19  383.50 
             384.28  385.42  386.88  388.62  390.63 
             392.91  395.44  398.22  401.24  404.51 
             408.01  411.76  429.10  475.01 
/
 9  8  3  1  385.75  380.25  377.20  376.32  376.40 
             377.08  378.20  379.69  381.52  383.65 
             386.08  388.79  391.77  395.02  398.54 
             402.32  406.36  425.06  474.39 
/
 9  8  4  1  377.07  366.21  355.75  355.19  355.65 
             356.77  358.39  360.45  362.88  365.70 
             368.85  372.34  376.15  380.29  384.75 
             389.49  394.56  417.76  477.56 
/
 9  8  5  1  366.26  335.03  332.66  332.47  333.36 
             334.98  337.19  339.91  343.10  346.73 
             350.79  355.25  360.12  365.37  371.00 
             377.01  383.39  412.48  487.04 
/
 9  8  6  1  340.65  300.35  298.11  298.64  300.58 
             303.55  307.37  311.93  317.20  323.12 
             329.66  336.80  344.52  352.80  361.62 
             370.96  380.80  425.01  534.97 
/
 9  8  7  1  272.77  268.55  268.05  270.92  275.80 
             282.26  290.11  299.25  309.54  320.84 
             333.09  346.23  360.22  375.00  390.57 
             406.89  423.94  499.15  681.70 
/
 9  9  1  1  396.16  392.62  390.80  390.47  390.81 
             391.60  392.72  394.15  395.84  397.80 
             400.02  402.47  405.17  408.10  411.27 
             414.67  418.30  435.13  479.74 
/
 9  9  2  1  395.62  391.91  389.97  389.58  389.90 
             390.67  391.79  393.21  394.91  396.88 
             399.11  401.58  404.29  407.24  410.44 
             413.86  417.53  434.49  479.46 
/
 9  9  3  1  393.01  388.21  385.49  384.75  384.88 
             385.56  386.65  388.08  389.83  391.86 
             394.18  396.76  399.61  402.71  406.06 
             409.66  413.52  431.37  478.60 
/
 9  9  4  1  386.91  378.11  370.90  369.74  369.84 
             370.63  371.94  373.66  375.78  378.24 
             381.03  384.13  387.55  391.26  395.22 
             399.51  404.09  425.12  479.86 
/
 9  9  5  1  379.21  361.52  350.98  350.76  351.48 
             352.83  354.67  356.96  359.64  362.71 
             366.13  369.91  374.04  378.50  383.29 
             388.41  393.85  418.78  484.20 
/
 9  9  6  1  360.50  321.17  318.70  318.73  319.98 
             322.06  324.83  328.21  332.13  336.59 
             341.54  346.98  352.87  359.23  366.04 
             373.28  380.94  415.69  503.52 
/
 9  9  7  1  326.84  286.56  284.87  286.19  289.12 
             293.26  298.43  304.53  311.49  319.24 
             327.77  337.03  346.98  357.60  368.85 
             380.73  393.19  448.69  584.49 
/
 9 10  1  1  404.15  402.94  402.26  402.36  402.91 
             403.79  404.96  406.39  408.06  409.98 
             412.12  414.50  417.11  419.94  423.00 
             426.28  429.78  446.01  489.07 
/
 9 10  2  1  404.15  402.94  402.26  402.36  402.91 
             403.79  404.96  406.39  408.06  409.98 
             412.12  414.50  417.11  419.94  423.00 
             426.28  429.78  446.01  489.07 
/
 9 10  3  1  404.15  402.94  402.26  402.36  402.91 
             403.79  404.96  406.39  408.06  409.98 
             412.12  414.50  417.11  419.94  423.00 
             426.28  429.78  446.01  489.07 
/
 9 10  4  1  404.15  402.94  402.26  402.36  402.91 
             403.79  404.96  406.39  408.06  409.98 
             412.12  414.50  417.11  419.94  423.00 
             426.28  429.78  446.01  489.07 
/
 9 10  5  1  404.15  402.94  402.26  402.36  402.91 
             403.79  404.96  406.39  408.06  409.98 
             412.12  414.50  417.11  419.94  423.00 
             426.28  429.78  446.01  489.07 
/
 9 10  6  1  404.15  402.94  402.26  402.36  402.91 
             403.79  404.96  406.39  408.06  409.98 
             412.12  414.50  417.11  419.94  423.00 
             426.28  429.78  446.01  489.07 
/
 9 10  7  1  404.15  402.94  402.26  402.36  402.91 
             403.79  404.96  406.39  408.06  409.98 
             412.12  414.50  417.11  419.94  423.00 
             426.28  429.78  446.01  489.07 
/
10  1  1  1  369.81  368.86  368.21  368.34  368.99 
             370.04  371.44  373.15  375.16  377.44 
             380.01  382.84  385.93  389.29  392.90 
             396.77  400.90  419.93  470.04 
/
10  1  2  1  367.24  366.27  365.60  365.70  366.34 
             367.39  368.81  370.55  372.59  374.94 
             377.57  380.48  383.66  387.12  390.84 
             394.83  399.09  418.73  470.44 
/
10  1  3  1  356.50  354.58  352.59  352.21  352.71 
             353.83  355.43  357.46  359.89  362.69 
             365.84  369.34  373.17  377.32  381.80 
             386.59  391.69  415.12  476.31 
/
10  1  4  1  339.88  322.25  320.25  320.32  321.65 
             323.88  326.88  330.54  334.81  339.65 
             345.05  350.97  357.39  364.31  371.72 
             379.60  387.94  425.88  519.45 
/
10  1  5  1  320.74  298.92  297.40  298.60  301.47 
             305.61  310.83  317.02  324.11  332.03 
             340.73  350.20  360.39  371.28  382.83 
             395.04  407.89  465.42  609.80 
/
10  1  6  1  277.21  274.44  275.77  281.28  289.78 
             300.33  312.59  326.42  341.72  358.41 
             376.43  395.70  416.21  437.90  460.75 
             484.74  509.85  621.66  901.41 
/
10  1  7  1  261.63  264.97  275.26  290.60  310.38 
             334.04  361.25  391.86  425.68  462.72 
             502.79  545.58  591.05  639.24  690.17 
             743.86  800.32 1051.61 1671.20 
/
10  2  1  1  374.36  373.35  372.67  372.79  373.44 
             374.48  375.87  377.56  379.53  381.79 
             384.32  387.11  390.16  393.47  397.03 
             400.85  404.92  423.70  473.17 
/
10  2  2  1  371.90  370.86  370.16  370.27  370.89 
             371.94  373.33  375.05  377.06  379.37 
             381.96  384.82  387.95  391.35  395.02 
             398.94  403.13  422.46  473.37 
/
10  2  3  1  361.53  359.59  357.65  357.27  357.76 
             358.83  360.41  362.37  364.73  367.44 
             370.50  373.89  377.60  381.63  385.97 
             390.62  395.55  418.32  477.76 
/
10  2  4  1  345.55  327.76  325.70  325.71  326.92 
             329.00  331.79  335.21  339.21  343.75 
             348.81  354.37  360.41  366.91  373.88 
             381.31  389.17  425.00  513.58 
/
10  2  5  1  327.00  303.77  302.06  303.02  305.56 
             309.29  314.02  319.66  326.12  333.37 
             341.35  350.05  359.42  369.45  380.11 
             391.39  403.27  456.56  590.63 
/
10  2  6  1  280.73  277.69  278.45  282.97  290.15 
             299.46  310.46  322.94  336.78  351.90 
             368.23  385.72  404.32  423.99  444.72 
             466.47  489.24  590.38  843.55 
/
10  2  7  1  263.04  265.47  274.60  288.15  305.67 
             326.57  350.60  377.60  407.50  440.17 
             475.50  513.21  553.27  595.69  640.48 
             687.64  737.19  958.77 1500.22 
/
10  3  1  1  379.08  378.01  377.32  377.44  378.08 
             379.11  380.48  382.14  384.09  386.31 
             388.80  391.55  394.56  397.82  401.34 
             405.10  409.12  427.64  476.45 
/
10  3  2  1  376.76  375.66  374.95  375.05  375.67 
             376.70  378.07  379.76  381.74  384.01 
             386.55  389.37  392.45  395.79  399.39 
             403.25  407.37  426.37  476.47 
/
10  3  3  1  366.85  364.92  363.09  362.69  363.15 
             364.20  365.71  367.61  369.88  372.51 
             375.46  378.74  382.34  386.24  390.45 
             394.95  399.75  421.84  479.60 
/
10  3  4  1  351.64  333.92  331.84  331.79  332.89 
             334.82  337.41  340.60  344.33  348.57 
             353.29  358.49  364.15  370.24  376.78 
             383.75  391.14  424.81  508.40 
/
10  3  5  1  333.90  309.41  307.53  308.25  310.47 
             313.80  318.06  323.15  329.01  335.59 
             342.86  350.79  359.36  368.54  378.31 
             388.66  399.58  448.66  572.36 
/
10  3  6  1  284.95  281.65  281.85  285.61  291.66 
             299.60  309.22  320.29  332.64  346.19 
             360.85  376.57  393.31  411.01  429.67 
             449.26  469.75  560.67  787.01 
/
10  3  7  1  265.60  266.11  274.15  286.04  301.46 
             319.78  340.81  364.43  390.55  419.12 
             449.95  482.85  517.79  554.78  593.81 
             634.85  677.92  870.40 1340.35 
/
10  4  1  1  385.01  383.28  382.36  382.42  383.02 
             384.02  385.35  386.98  388.89  391.07 
             393.52  396.23  399.19  402.40  405.86 
             409.56  413.52  431.77  479.90 
/
10  4  2  1  382.83  381.09  380.16  380.19  380.77 
             381.76  383.10  384.75  386.69  388.92 
             391.41  394.17  397.19  400.47  404.01 
             407.80  411.84  430.51  479.77 
/
10  4  3  1  373.34  370.94  369.08  368.59  368.99 
             369.99  371.43  373.25  375.48  378.01 
             380.86  384.03  387.50  391.27  395.34 
             399.69  404.34  425.73  481.78 
/
10  4  4  1  358.93  340.85  338.77  338.67  339.67 
             341.45  343.85  346.81  350.27  354.21 
             358.61  363.46  368.73  374.43  380.53 
             387.04  393.95  425.41  504.02 
/
10  4  5  1  342.17  316.01  313.98  314.48  316.40 
             319.33  323.13  327.69  332.96  338.90 
             345.47  352.64  360.41  368.74  377.64 
             387.07  397.02  441.92  555.34 
/
10  4  6  1  290.08  286.51  286.19  289.20  294.32 
             301.10  309.33  318.89  329.68  341.60 
             354.56  368.51  383.38  399.15  415.76 
             433.22  451.50  532.55  733.13 
/
10  4  7  1  268.83  267.24  273.95  284.30  297.79 
             313.70  331.93  352.39  374.99  399.64 
             426.17  454.52  484.66  516.55  550.16 
             585.50  622.52  787.57 1191.91 
/
10  5  1  1  391.62  388.98  387.74  387.69  388.22 
             389.17  390.46  392.05  393.92  396.06 
             398.46  401.12  404.02  407.18  410.58 
             414.23  418.12  436.09  483.53 
/
10  5  2  1  389.73  387.02  385.75  385.66  386.18 
             387.12  388.42  390.02  391.91  394.08 
             396.52  399.23  402.19  405.40  408.87 
             412.58  416.55  434.88  483.29 
/
10  5  3  1  381.26  377.77  375.61  375.06  375.36 
             376.27  377.63  379.37  381.50  383.93 
             386.67  389.71  393.06  396.70  400.62 
             404.83  409.32  430.02  484.43 
/
10  5  4  1  367.80  348.66  346.62  346.49  347.40 
             349.03  351.25  353.98  357.19  360.84 
             364.92  369.41  374.31  379.60  385.28 
             391.34  397.78  426.91  500.57 
/
10  5  5  1  352.14  323.82  321.67  321.97  323.59 
             326.15  329.50  333.55  338.24  343.54 
             349.42  355.87  362.84  370.35  378.36 
             386.88  395.89  436.63  539.81 
/
10  5  6  1  296.44  292.62  291.78  294.10  298.31 
             304.01  311.00  319.16  328.39  338.65 
             349.86  361.97  374.95  388.75  403.34 
             418.68  434.77  506.20  682.42 
/
10  5  7  1  272.99  270.51  274.37  283.16  294.79 
             308.45  324.06  341.52  360.75  381.68 
             404.21  428.33  453.97  481.10  509.68 
             539.68  571.07  710.65 1055.16 
/
10  6  1  1  398.29  394.88  393.34  393.17  393.64 
             394.55  395.79  397.33  399.16  401.25 
             403.60  406.21  409.06  412.16  415.51 
             419.09  422.92  440.60  487.34 
/
10  6  2  1  396.71  393.18  391.59  391.39  391.84 
             392.73  393.98  395.54  397.38  399.50 
             401.88  404.52  407.42  410.57  413.96 
             417.61  421.50  439.48  487.02 
/
10  6  3  1  389.48  385.04  382.58  381.95  382.19 
             383.01  384.28  385.93  387.94  390.26 
             392.89  395.82  399.03  402.55  406.33 
             410.39  414.72  434.72  487.34 
/
10  6  4  1  377.28  357.53  355.56  355.41  356.24 
             357.74  359.78  362.30  365.25  368.62 
             372.37  376.49  380.98  385.84  391.07 
             396.63  402.54  429.50  498.18 
/
10  6  5  1  363.08  333.15  330.93  331.05  332.39 
             334.60  337.53  341.08  345.22  349.90 
             355.11  360.83  367.03  373.72  380.88 
             388.49  396.56  433.17  526.33 
/
10  6  6  1  304.52  300.46  299.13  300.79  304.14 
             308.81  314.61  321.43  329.19  337.84 
             347.34  357.65  368.72  380.53  393.05 
             406.27  420.14  482.03  634.98 
/
10  6  7  1  278.53  275.50  277.30  283.59  292.91 
             304.22  317.23  331.81  347.89  365.39 
             384.25  404.42  425.86  448.54  472.41 
             497.45  523.65  639.73  925.79 
/
10  7  1  1  404.79  400.90  399.12  398.86  399.27 
             400.12  401.32  402.83  404.60  406.65 
             408.95  411.51  414.31  417.35  420.63 
             424.16  427.92  445.31  491.33 
/
10  7  2  1  403.56  399.51  397.66  397.36  397.75 
             398.59  399.79  401.30  403.09  405.16 
             407.48  410.07  412.90  415.98  419.31 
             422.88  426.69  444.32  490.97 
/
10  7  3  1  397.76  392.68  390.00  389.30  389.50 
             390.26  391.46  393.03  394.94  397.15 
             399.67  402.47  405.55  408.91  412.54 
             416.43  420.60  439.85  490.65 
/
10  7  4  1  387.21  374.79  366.02  365.69  366.36 
             367.67  369.48  371.75  374.41  377.44 
             380.87  384.64  388.74  393.21  397.99 
             403.10  408.53  433.39  497.21 
/
10  7  5  1  374.87  344.46  342.23  342.19  343.29 
             345.17  347.70  350.78  354.38  358.47 
             363.03  368.05  373.51  379.39  385.70 
             392.43  399.57  432.08  515.31 
/
10  7  6  1  346.56  310.81  309.04  310.07  312.63 
             316.33  321.00  326.54  332.89  340.01 
             347.85  356.39  365.60  375.47  385.95 
             397.05  408.74  461.10  591.29 
/
10  7  7  1  286.23  282.66  283.21  287.37  293.90 
             302.50  312.78  324.47  337.45  351.63 
             366.96  383.37  400.82  419.28  438.72 
             459.12  480.45  574.80  806.02 
/
10  8  1  1  410.88  406.92  405.03  404.71  405.08 
             405.90  407.06  408.52  410.25  412.26 
             414.51  417.01  419.76  422.75  425.97 
             429.43  433.12  450.22  495.51 
/
10  8  2  1  410.01  405.87  403.89  403.53  403.88 
             404.68  405.84  407.31  409.05  411.06 
             413.34  415.86  418.63  421.64  424.90 
             428.39  432.12  449.40  495.16 
/
10  8  3  1  405.76  400.57  397.83  397.11  397.28 
             398.00  399.15  400.65  402.46  404.58 
             406.99  409.67  412.62  415.83  419.31 
             423.04  427.03  445.51  494.36 
/
10  8  4  1  397.31  387.33  378.43  377.74  378.11 
             379.15  380.70  382.68  385.05  387.79 
             390.88  394.25  398.00  402.06  406.39 
             411.06  416.04  438.80  497.67 
/
10  8  5  1  387.30  358.34  356.20  356.07  356.96 
             358.55  360.69  363.34  366.44  369.97 
             373.91  378.25  382.98  388.10  393.58 
             399.44  405.67  434.14  508.14 
/
10  8  6  1  363.59  324.96  322.83  323.31  325.15 
             327.95  331.56  335.90  340.92  346.57 
             352.83  359.67  367.09  375.06  383.56 
             392.59  402.12  445.14  553.13 
/
10  8  7  1  297.63  293.54  292.90  295.49  300.00 
             306.03  313.39  321.95  331.63  342.37 
             354.11  366.78  380.32  394.70  409.87 
             425.83  442.53  516.53  697.36 
/
10  9  1  1  416.29  412.77  410.98  410.67  411.03 
             411.83  412.96  414.39  416.09  418.05 
             420.26  422.72  425.41  428.34  431.50 
             434.90  438.53  455.33  499.87 
/
10  9  2  1  415.75  412.08  410.20  409.85  410.19 
             410.98  412.11  413.54  415.24  417.21 
             419.43  421.90  424.61  427.55  430.74 
             434.16  437.81  454.73  499.59 
/
10  9  3  1  413.09  408.49  405.97  405.33  405.52 
             406.23  407.34  408.78  410.52  412.55 
             414.86  417.42  420.24  423.32  426.65 
             430.22  434.04  451.75  498.65 
/
10  9  4  1  407.17  398.94  392.89  391.61  391.60 
             392.34  393.61  395.29  397.35  399.75 
             402.49  405.54  408.85  412.50  416.44 
             420.66  425.17  445.90  500.04 
/
10  9  5  1  399.99  387.25  373.78  373.63  374.37 
             375.70  377.52  379.77  382.40  385.41 
             388.77  392.47  396.52  400.90  405.60 
             410.63  415.97  440.74  504.79 
/
10  9  6  1  382.58  345.23  342.93  342.97  344.18 
             346.18  348.84  352.08  355.86  360.15 
             364.92  370.17  375.88  382.02  388.62 
             395.64  403.09  436.95  523.17 
/
10  9  7  1  351.18  311.52  309.84  311.02  313.75 
             317.63  322.50  328.27  334.86  342.25 
             350.38  359.24  368.79  379.00  389.86 
             401.34  413.43  467.50  601.17 
/
10 10  1  1  424.25  423.04  422.36  422.46  423.01 
             423.89  425.06  426.49  428.16  430.07 
             432.22  434.60  437.20  440.03  443.09 
             446.37  449.87  466.10  509.13 
/
10 10  2  1  424.25  423.04  422.36  422.46  423.01 
             423.89  425.06  426.49  428.16  430.07 
             432.22  434.60  437.20  440.03  443.09 
             446.37  449.87  466.10  509.13 
/
10 10  3  1  424.25  423.04  422.36  422.46  423.01 
             423.89  425.06  426.49  428.16  430.07 
             432.22  434.60  437.20  440.03  443.09 
             446.37  449.87  466.10  509.13 
/
10 10  4  1  424.25  423.04  422.36  422.46  423.01 
             423.89  425.06  426.49  428.16  430.07 
             432.22  434.60  437.20  440.03  443.09 
             446.37  449.87  466.10  509.13 
/
10 10  5  1  424.25  423.04  422.36  422.46  423.01 
             423.89  425.06  426.49  428.16  430.07 
             432.22  434.60  437.20  440.03  443.09 
             446.37  449.87  466.10  509.13 
/
10 10  6  1  424.25  423.04  422.36  422.46  423.01 
             423.89  425.06  426.49  428.16  430.07 
             432.22  434.60  437.20  440.03  443.09 
             446.37  449.87  466.10  509.13 
/
10 10  7  1  424.25  423.04  422.36  422.46  423.01 
             423.89  425.06  426.49  428.16  430.07 
             432.22  434.60  437.20  440.03  443.09 
             446.37  449.87  466.10  509.13 
/
