/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower86@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/
#include "protocolversion4.h"

const char* ProtocolVersion4::m_programId = "QChat";

ProtocolVersion4::ProtocolVersion4()
 : AbstractProtocol()
{
}

ProtocolVersion4::~ProtocolVersion4()
{
}

QString ProtocolVersion4::compName(const char * buf, uint sz)
{
  if(sz < protocolLen() || sz < protocolLen() + compNameLen(buf) + optionsLen(buf))
    return QString();
  return QString::fromUtf8(buf + protocolLen() + optionsLen(buf), compNameLen(buf));
}

QString ProtocolVersion4::userName(const char * buf, uint sz)
{
  if(sz < protocolLen() || sz < protocolLen() + optionsLen(buf) + compNameLen(buf) + userNameLen(buf))
    return QString();
  return QString::fromUtf8(buf + protocolLen() + optionsLen(buf) + compNameLen(buf), userNameLen(buf));
}

QString ProtocolVersion4::message(const char * buf, uint sz)
{
  if(sz < protocolLen() || sz < protocolLen() + optionsLen(buf) + compNameLen(buf) + userNameLen(buf) + messageLen(buf))
    return QString();
  return QString::fromUtf8(buf + protocolLen() + optionsLen(buf) + compNameLen(buf) + userNameLen(buf), messageLen(buf));
}

QByteArray ProtocolVersion4::parametrs(const char * buf, uint sz)
{
  if(sz < protocolLen() || sz < protocolLen() + optionsLen(buf) + compNameLen(buf) + userNameLen(buf) + messageLen(buf) + parametrsLen(buf))
    return QByteArray();
  return QByteArray(buf + protocolLen() + optionsLen(buf) + compNameLen(buf) + userNameLen(buf) + messageLen(buf), parametrsLen(buf));
}

