/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower86@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/
#ifndef SHORTCUTGRABBER_H
#define SHORTCUTGRABBER_H

#include <QDialog>
#include <QKeySequence>

#include "shortcutbutton.h"

/**
	@author Anistratov Oleg <ower86@gmail.com>
*/
class ShortcutGrabber : public QDialog
{
  Q_OBJECT
  private:
    ShortcutButton* m_shortcutBtn;
    QKeySequence    m_sequence;

  public:
    ShortcutGrabber(QWidget *parent = 0);
    ~ShortcutGrabber();

    const QKeySequence& sequence() const {return m_sequence;}
    bool execute();

  public slots:
    void acceptSequence(const QKeySequence&);

};

#endif
