#include "gallerywidget.h"
#include "ui_gallerywidget.h"
#include "logging.h"
#include "global.h"
#include <QSplashScreen>
#include "dispatcher.h"
#include <QFileInfo>
#include <QStatusBar>
#include "txwidget.h"

galleryWidget::galleryWidget(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::galleryWidget)
{
    ui->setupUi(this);
    ui->tabWidget->setCurrentIndex(0);
}

galleryWidget::~galleryWidget()
{
  writeSettings();
  addToLog ("deleting galleryWidget",DBGALLERY);
    delete ui;
  addToLog ("ui deleted: galleryWidget",DBGALLERY);
}




void galleryWidget::init()
{
  initView();
  readSettings();
}

/*!
  reads the settings (saved images for tx,rx,templates)
*/

void galleryWidget::readSettings()
{
  int i;
  QSettings qSettings;
  qSettings.beginGroup ("Gallery");
  rxIndex=qSettings.value( "rxIndex",0 ).toInt();
  qSettings.endGroup();
  QString spl ( "\n\nLoading RX images" );
  splash->showMessage ( spl );
  qApp->processEvents();
  for ( i=0;i<NUMTHUMBS;i++ )
  {
    qApp->processEvents();
    rxThumbsArray[i]->readThumbSettings ( &qSettings );
  }
  spl+="\nLoading TX images";
  splash->showMessage ( spl );
  qApp->processEvents();
  for ( i=0;i<NUMTHUMBS;i++ )
  {
    qApp->processEvents();
    txThumbsArray[i]->readThumbSettings ( &qSettings );
  }
  spl+="\nLoading Templates";
  splash->showMessage ( spl );
  qApp->processEvents();
  for ( i=0;i<NUMTHUMBS;i++ )
  {
    qApp->processEvents();
    templateThumbsArray[i]->readThumbSettings ( &qSettings );
  }
}

/*!
  writes the settings (saved images for tx,rx,templates)
*/
void galleryWidget::writeSettings()
{
  int i;
  QSettings qSettings;
  qSettings.beginGroup ( "Gallery" );
  qSettings.setValue ( "rxIndex",rxIndex );
  qSettings.endGroup();
  for ( i=0;i<NUMTHUMBS;i++ )
  {
    rxThumbsArray[i]->writeThumbSettings ( &qSettings );
    txThumbsArray[i]->writeThumbSettings ( &qSettings );
    templateThumbsArray[i]->writeThumbSettings ( &qSettings );
  }
}

/*!
  setup of the user interface
*/

void galleryWidget::initView()
{
  #define MINCOLSIZE 32
  #define MINROWSIZE 26
  int i;
  rxThumbsArray[0]= ui->rximage1;
  rxThumbsArray[1]= ui->rximage2;
  rxThumbsArray[2]= ui->rximage3;
  rxThumbsArray[3]= ui->rximage4;
  rxThumbsArray[4]= ui->rximage5;
  rxThumbsArray[5]= ui->rximage6;
  rxThumbsArray[6]= ui->rximage7;
  rxThumbsArray[7]= ui->rximage8;
  rxThumbsArray[8]= ui->rximage9;
  rxThumbsArray[9]= ui->rximage10;
  rxThumbsArray[10]=ui->rximage11;
  rxThumbsArray[11]=ui->rximage12;

  txThumbsArray[0]= ui->tximage1;
  txThumbsArray[1]= ui->tximage2;
  txThumbsArray[2]= ui->tximage3;
  txThumbsArray[3]= ui->tximage4;
  txThumbsArray[4]= ui->tximage5;
  txThumbsArray[5]= ui->tximage6;
  txThumbsArray[6]= ui->tximage7;
  txThumbsArray[7]= ui->tximage8;
  txThumbsArray[8]= ui->tximage9;
  txThumbsArray[9]= ui->tximage10;
  txThumbsArray[10]=ui->tximage11;
  txThumbsArray[11]=ui->tximage12;

  templateThumbsArray[0]= ui->tmpimage1;
  templateThumbsArray[1]= ui->tmpimage2;
  templateThumbsArray[2]= ui->tmpimage3;
  templateThumbsArray[3]= ui->tmpimage4;
  templateThumbsArray[4]= ui->tmpimage5;
  templateThumbsArray[5]= ui->tmpimage6;
  templateThumbsArray[6]= ui->tmpimage7;
  templateThumbsArray[7]= ui->tmpimage8;
  templateThumbsArray[8]= ui->tmpimage9;
  templateThumbsArray[9]= ui->tmpimage10;
  templateThumbsArray[10]=ui->tmpimage11;
  templateThumbsArray[11]=ui->tmpimage12;
  for ( i=0;i<NUMTHUMBS;i++ )
  {
    rxThumbsArray[i]->setType ( imageViewer::RXTHUMB );
    txThumbsArray[i]->setType ( imageViewer::TXTHUMB );
    templateThumbsArray[i]->setType ( imageViewer::TEMPLATETHUMB );
    connect( rxThumbsArray[i],SIGNAL(layoutChanged()),SLOT(slotLayoutChanged()));
    connect( txThumbsArray[i],SIGNAL(layoutChanged()),SLOT(slotLayoutChanged()));
    connect( templateThumbsArray[i],SIGNAL(layoutChanged()),SLOT(slotLayoutChanged()));
  }
  for (i=0;i<4;i++)
    {
      ui->gridLayout1->setColumnMinimumWidth(i,MINCOLSIZE);
      ui->gridLayout1->setColumnStretch(i,1);
      ui->gridLayout2->setColumnMinimumWidth(i,MINCOLSIZE);
      ui->gridLayout2->setColumnStretch(i,1);
      ui->gridLayout3->setColumnMinimumWidth(i,MINCOLSIZE);
      ui->gridLayout3->setColumnStretch(i,1);
    }
  for (i=0;i<3;i++)
    {
      ui->gridLayout1->setRowMinimumHeight(i,MINROWSIZE);
      ui->gridLayout1->setRowStretch(i,1);
      ui->gridLayout2->setRowMinimumHeight(i,MINROWSIZE);
      ui->gridLayout2->setRowStretch(i,1);
      ui->gridLayout3->setRowMinimumHeight(i,MINROWSIZE);
      ui->gridLayout3->setRowStretch(i,1);
    }

}

/*!
  closeEvent signals the dispatcher to initiate  program exit.
*/


/*!
  get the filename of a template

  \param[in] tm index of template
  \return QString containing filename, check with QString.isNull for validity
*/

QString galleryWidget::getTemplateFileName ( int tm )
{
  if ( tm<NUMTHUMBS )
  {
    return templateThumbsArray[tm]->getFilename();
  }
  return QString();
}

 const QStringList &galleryWidget::getFilenames()
 {
   QString str;
   sl.clear();

   int i;
   for(i=0;i<NUMTHUMBS;i++)
   {
     str=getTemplateFileName (i);
     if(!str.isEmpty())
      {
        QFileInfo fi(str);
        sl.append(fi.baseName());
      }
     else
     {
       sl.append("Empty");
     }
   }
   return sl;
 }

/*!
  loads an image in the rximages gallery in a new position

  \param[in] fn the filename

*/

void galleryWidget::putRxImage ( QString fn )
{

  shuffle(rxThumbsArray,rxIndex);
  rxThumbsArray[rxIndex]->open(fn,FALSE);
  statusBarPtr->showMessage ( "Saved: "+fn );
}

/*!
  loads an image in the rximages gallery in a new position

  \return QString containing filename, check with QString.isEmpty for validity

*/
QString galleryWidget::getLastRxImage()
{
  return rxThumbsArray[rxIndex]->getFilename();
}

 void galleryWidget::slotLayoutChanged()
 {
   int i,j;
    for ( i=0,j=0;i<NUMTHUMBS;i++ )
    {
      if(rxThumbsArray[i]->getFilename().isEmpty()) continue;
      rxThumbsArray[j]->setFilename(rxThumbsArray[i]->getFilename());
      rxThumbsArray[j]->reload();
      j++;
    }
    rxIndex=j;
    for(;j<NUMTHUMBS;j++)
      {
        rxThumbsArray[j]->init();
      }
    for ( i=0,j=0;i<NUMTHUMBS;i++ )
    {
      if(txThumbsArray[i]->getFilename().isEmpty()) continue;
       txThumbsArray[j]->setFilename(txThumbsArray[i]->getFilename());
       txThumbsArray[j]->reload();
      j++;
    }

    for(;j<NUMTHUMBS;j++)
      {
        txThumbsArray[j]->init();
      }
    for ( i=0,j=0;i<NUMTHUMBS;i++ )
    {
      if(templateThumbsArray[i]->getFilename().isEmpty()) continue;
       templateThumbsArray[j]->setFilename(templateThumbsArray[i]->getFilename());
       templateThumbsArray[j]->reload();
      j++;

    }
    for(;j<NUMTHUMBS;j++)
      {
        templateThumbsArray[j]->init();
      }
    txMW->setupTemplatesComboBox();
 }

 void galleryWidget::shuffle(imageViewer *ar[],int &index)
{
   int i;
   if((index+1)==NUMTHUMBS)
     {
       for(i=0;i<(NUMTHUMBS-1);i++)
         {
           ar[i]->setFilename(ar[i+1]->getFilename());
           ar[i]->reload();
         }
     }
   else
    {
      index++;
    }
}
